package ibase.webitm.ejb.mkt;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class MarketingBillSubmitEJB
 */
@Stateless
public class MarketingBillSubmitEJB extends ValidatorEJB implements MarketingBillSubmitRemote, MarketingBillSubmitLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();

    /**
     * Default constructor. 
     */
    public MarketingBillSubmitEJB() 
    {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;	
		String errString = "";
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : MarketingBillSubmitEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return (errString);
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)	throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		Node parentNode = null;
		Node childNode = null;
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String chkStr = "";
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");

			new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			
			switch (currentFormNo) {
			case 1:

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if (childNode.getFirstChild() != null) 
					{
						childNode.getFirstChild().getNodeValue();
					}

					if (childNodeName.equalsIgnoreCase("porder_no"))
					{
						if (childNode.getFirstChild() == null) 
						{
							errString = getErrorString("porder_no","VTPURCEMP",userId);
							break;
						}
						else if (childNode.getFirstChild() != null)
						{
							int paramName = 0;
							String porder_no = genericUtility.getColumnValue("porder_no", dom);
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM porder WHERE purc_order = ?";
							pstmt = conn.prepareStatement(countSerSql);
							pstmt.setString(1, porder_no);
							ResultSet rsCnt = pstmt.executeQuery();
							
							System.out.println("porder_no" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							rsCnt.close();
							pstmt = null;
							if (paramName == 0) 
							{
								errString = getErrorString("porder_no","INVPONO", userId);
								break;
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("bill_no")) 
					{
						if (childNode.getFirstChild() == null ) 
						{
							errString = getErrorString("bill_no","BILLNO",userId);
							break;
						}
					}
					else if (childNodeName.equalsIgnoreCase("bill_date")) 
					{
						if (childNode.getFirstChild() == null) 
						{
							errString = getErrorString("bill_date","BILLDT",userId);
							break;
						}
					}
					//Added by Prasad on 08/07/15 [for validation of Challan Date] START
					else if(childNodeName.equalsIgnoreCase("challan_date"))
					{
						chkStr = genericUtility.getColumnValue("challan_no",dom);
						
						if(childNode.getFirstChild() == null && chkStr != null )
						{
							errString =getErrorString("challan_date","CHALLANDT",userId);
							break;
						}
					}
					//Added by Prasad on 08/07/15 [for validation of Challan Date] END
					else if (childNodeName.equalsIgnoreCase("bill_amt")) 
					{
						if (childNode.getFirstChild() == null) 
						{
							errString = getErrorString("bill_amt","BILLAMT",userId);
							break;
						}
					}
				}
				break;
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception ::" + e);
			e.printStackTrace();
			errString = e.getMessage();
		} 
		finally 
		{
			try
			{
				if (conn != null) 
				{
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		System.out.println("ErrString ::" + errString);
		return errString;
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, 	String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :MarketingBillSubmitEJB:itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return (valueXmlString);
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		ResultSet resultSet = null;
		String sql = "";
		String columnValue = "";
		Connection connectionObject = null;
		Statement statement;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		
		try
		{
			connectionObject = getConnection(); 
		    statement = connectionObject.createStatement();
		    
		    Date date = new Date();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String newDate = simpleDateFormat.format(date) ; 
            
    		if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
    		
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("current form no: " + currentFormNo);
			
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail1>\r\n");
					
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						valueXmlString.append("<status>").append("<![CDATA[N]]>").append("</status>\r\n");
						valueXmlString.append("<doc_type>").append("<![CDATA[O]]>").append("</doc_type>\r\n");
						valueXmlString.append("<tran_date>").append("<![CDATA[" + newDate + "]]>").append("</tran_date>");
					}
					
					if (currentColumn.trim().equalsIgnoreCase("porder_no"))
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						
						sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.tax_reg "
								+ " FROM porder porder, supplier supp "
								+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
								+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
								+ " WHERE porder.supp_code = supp.supp_code "
								+ " AND purc_order ='" + columnValue + "'";
						resultSet = statement.executeQuery(sql);
						if (resultSet.next())
						{
							valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</tax_reg>\r\n");
						}
						else
						{
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
						}
						resultSet.close(); resultSet = null;
					}
					valueXmlString.append("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch (Exception e) 
		{
			System.out.println("Exception :MarketingBillSubmitEJB:itemChange(Document,String):"+e.getMessage()+ ":");
			valueXmlString.delete(0,valueXmlString.length());
			valueXmlString=valueXmlString.append(genericUtility.createErrorString(e));
			e.printStackTrace();
		}
		finally 
		{
			try
			{
				if (connectionObject != null) 
				{
					connectionObject.close();
				}
				connectionObject = null;
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		System.out.println("\n***** ValueXmlString :" +valueXmlString + ":*******");
		return valueXmlString.toString();
	}
}