package ibase.webitm.ejb.mkt;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@Stateless
public class MarketingBillApproval3PreSave extends ValidatorEJB
		implements MarketingBillApproval3PreSaveLocal, MarketingBillApproval3PreSaveRemote {
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

	public String preSave() throws RemoteException, ITMException {
		return "";
	}

	public String preSave(String domString, String editFlag, String xtraParams, Connection conn)
			throws RemoteException, ITMException {
		String retString = "";
		try {

			System.out.println("domString ReceiptGenWizPreSaveEJB [" + domString + "]");

			retString = callWfValData(domString, xtraParams, conn);

		} catch (Exception e) {
			System.out.println("Exception :WsfaDSRWizPreSaveEJB : :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("Return string :" + retString);
		return retString;
	}

	private String callWfValData(String domString, String xtraParams, Connection conn) throws ITMException {

		String errString = "";
		
		String remarks3 = "", status = "", errCode = "", loginCode = "";
		try {

			System.out.println("domString ::::: " + domString);
			Document dom1 = parseString(domString);
			System.out.println("dom1.....  " + dom1);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			remarks3 = genericUtility.getColumnValue("remarks3", dom1);
			status = genericUtility.getColumnValue("approval_status3", dom1);

			
			if(status != null && status.trim().length() > 0 && status.equalsIgnoreCase("R")) {
				if (remarks3 == null || remarks3.trim().length() == 0) {
				errCode = "VTREA";
				errString = itmDBAccess.getErrorString("full_ret", errCode, loginCode, "", conn);
				return errString;

				}
			}

			if (status == null || status.trim().length() == 0) {
				errCode = "VTSTS";
				errString = itmDBAccess.getErrorString("full_ret", errCode, loginCode, "", conn);
				return errString;

			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}

		return errString;
	}

}
