package ibase.webitm.ejb.mkt;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@Stateless
public class MarketingBillApproval1PreSave extends ValidatorEJB
		implements MarketingBillApproval1PreSaveLocal, MarketingBillApproval1PreSaveRemote {
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

	public String preSave() throws RemoteException, ITMException {
		return "";
	}

	public String preSave(String domString, String editFlag, String xtraParams, Connection conn)
			throws RemoteException, ITMException {
		String retString = "";
		try {

			System.out.println("domString ReceiptGenWizPreSaveEJB [" + domString + "]");

			retString = callWfValData(domString, xtraParams, conn);

		} catch (Exception e) {
			System.out.println("Exception :WsfaDSRWizPreSaveEJB : :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("Return string :" + retString);
		return retString;
	}

	private String callWfValData(String domString, String xtraParams, Connection conn) throws ITMException {

		String errString = "";
		String udf_str4 = "", remarks1 = "", status = "", errCode = "", loginCode = "";
		String sql="";
		String acctcode="",cctrcode="";
		PreparedStatement ps=null;
		ResultSet rs=null;
		ArrayList<String> udfStr2List=null;
		try {
          
			System.out.println("domString ::::: " + domString);
			Document dom1 = parseString(domString);
			System.out.println("dom1.....  " + dom1);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			udf_str4 = genericUtility.getColumnValue("udf_str4", dom1);
			remarks1 = genericUtility.getColumnValue("remarks1", dom1);
			status = genericUtility.getColumnValue("approval_status1", dom1);
			acctcode = checkNull(genericUtility.getColumnValue("acct_code", dom1));
			cctrcode = checkNull(genericUtility.getColumnValue("cctr_code", dom1));
			
			udfStr2List= new ArrayList<String>();
			
			sql="select udf_str2 from gencodes where fld_value=? and sh_descr=?";
			ps=conn.prepareStatement(sql);
			ps.setString(1, acctcode);
			ps.setString(2, cctrcode);
			rs=ps.executeQuery();
			
			while(rs.next()) {
				udfStr2List.add(checkNull(rs.getString("udf_str2")));
			}
			

			if (udf_str4 == null || udf_str4.trim().length() == 0) {
				errCode = "VTEMPA";
				errString = itmDBAccess.getErrorString("udf_str4", errCode, loginCode, "", conn);
				return errString;

			}
			
			else {
				if(!udfStr2List.contains(udf_str4)) {
					errCode = "VTEMPA1";
					errString = itmDBAccess.getErrorString("udf_str4", errCode, loginCode, "", conn);
					return errString;
				}
				
				
			}
			
			

			if (remarks1 == null || remarks1.trim().length() == 0) {
				errCode = "VTREA";
				errString = itmDBAccess.getErrorString("remarks1", errCode, loginCode, "", conn);
				return errString;

			}

			if (status == null || status.trim().length() == 0) {
				errCode = "VTSTS";
				errString = itmDBAccess.getErrorString("status", errCode, loginCode, "", conn);
				return errString;

			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		finally {
			if(udfStr2List!=null) {
				udfStr2List.clear();
			}
		}
		return errString;
	}
	
	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		return input.trim();
	}

}
