/**
 * 
 */
package ibase.webitm.bean.mkt;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.ejb.DocumentHandlerWrapperRemote;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;

/**
 * @author user
 *
 */
public class MarketingBillBean extends ValidatorEJB
{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private ServletContext servletContext = null;
	private HttpServletRequest request = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private String userId = "";
	private String sessionId = "";
	private String transDb="";
	private Map<String, ArrayList<String>> mapListUnAlloc = new HashMap<String, ArrayList<String>>();
	private Map<String, ArrayList<String>> inProcessMapList = new HashMap<String, ArrayList<String>>();
	private String inProcessDocIds = "";
	
	E12GenericUtility genericUtility = new E12GenericUtility();
	
	/**
	 * 
	 */
	public MarketingBillBean() 
	{
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * 
	 * @param objName
	 * @param sessionCtx
	 * @throws ITMException
	 */
	public MarketingBillBean(String objName, HttpSession sessionCtx) throws ITMException 
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	
	//Added By Prasad on 18/08/15 [for getting servletCtx, sesionCtx, objName, request from jsp] START
	/**
	 * 
	 * @param objName
	 * @param sessionCtx
	 * @param ctx
	 * @throws ITMException 
	 */
	public MarketingBillBean(String objName, HttpSession sessionCtx, ServletContext servletCtx, HttpServletRequest request) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.servletContext = servletCtx;
			this.request = request;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			this.userId = userInfo.getLoginCode();
			this.transDb=userInfo.getTransDB();
			this.sessionId = this.sessionCtx.getId();
			
			System.out.println("userId = ["+ userId +"] sessionId = ["+ sessionId +"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	//Added By Prasad on 18/08/15 [for getting servletCtx, sesionCtx, objName, request from jsp] END
	
	/**
	 * get refId for view attachment
	 * @param voucherNo
	 * @return
	 * @throws ITMException
	 */
	public String getDocument(String voucherNo) throws ITMException 
	{
		String refId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//ValidatorEJB ValidatorEJB= new ValidatorEJB();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			
			String sql = "SELECT TRAN_ID FROM SUPPLIER_BILL WHERE VOUCHER_NO = ?";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, voucherNo);
			
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				refId += rs.getString(1) + ",";
			}
			rs.close();
			if ( refId.trim().length() > 1 )
			{
				refId = refId.substring( 0, refId.trim().length()-1 );
			}
			System.out.println("TRAN_ID : ["+ refId +"]");
		} 
		catch (SQLException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				conn.close();
			}
			catch (SQLException e) 
			{
				throw new ITMException(e);
			}
		}
		
		return refId;
	}
	
	//Added by Chetan on 03/03/15 for [Payment Attachment] Start
	/**
	 * get records for Payment details
	 * @param tranId
	 * @return
	 * @throws ITMException 
	 */
	public Map<String, String> getPaymentDetails(String tranId) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map<String,String> mapRsList = new HashMap<String, String>();
		DecimalFormat decimalFormat = new DecimalFormat("#.00");

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();

			String sql = "SELECT MISC_PAYDET.VOUCH_NO, MISC_PAYDET.PAY_AMT " +
					" FROM MISC_PAYMENT, MISC_PAYDET " +
					" WHERE MISC_PAYMENT.TRAN_ID = MISC_PAYDET.TRAN_ID AND MISC_PAYMENT.TRAN_ID= ? " +
					" ORDER BY MISC_PAYDET.VOUCH_NO";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
 
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				String vouchNo = rs.getString(1);
				double payAmt = rs.getDouble(2);
				System.out.println("vouchNo = "+vouchNo);
				System.out.println("payAmt = "+payAmt);
				mapRsList.put(vouchNo, decimalFormat.format(payAmt));
			}
			pstmt.close(); pstmt = null;
			rs.close(); rs = null;
			conn.close();
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return mapRsList;
	}
	//Added by Chetan on 03/03/15 for [Payment Attachment] End
	
	//Added by Prasad on 20/04/15 [for SSC changes [Payment Authorization Screen]] START
	/**
	 * get voucher Details
	 * @param tranId
	 * @return
	 * @throws ITMException
	 */
	public String getVocherDetails( String tranId ) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		DecimalFormat decimalFormat = new DecimalFormat("#.00");
		StringBuffer valueXmlString = new StringBuffer();
		String vouch_det = "";
		int num = 0;

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();

			//Changed by Prasad on 08/05/15 [For getting Voucher Details] START
			/*String sql = "SELECT MISC_PAYDET.VOUCH_NO, TO_CHAR(MISC_PAYDET.VOUCH_DATE, 'DD-MON-YYYY') VOUCH_DATE, MISC_PAYDET.PAY_AMT, "
					+ " TO_CHAR(MISC_PAYABLES.DUE_DATE, 'DD-MON-YYYY') DUE_DATE "
					+ " FROM MISC_PAYDET, MISC_PAYABLES, MISC_PAYMENT "
					+ " WHERE MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " AND MISC_PAYMENT.TRAN_ID = MISC_PAYDET.TRAN_ID "
					+ " AND MISC_PAYMENT.TRAN_ID = ? "
					+ " ORDER BY MISC_PAYDET.VOUCH_NO";*/
			
			String sql = "SELECT MISC_PAYDET.VOUCH_NO, TO_CHAR(MISC_PAYDET.VOUCH_DATE, 'DD-MON-YYYY') VOUCH_DATE, MISC_PAYDET.PAY_AMT, "
					+ " TO_CHAR(MISC_PAYABLES.DUE_DATE, 'DD-MON-YYYY') DUE_DATE, "
					+ " NVL(DDF_GET_MULTI_BARCODE(MISC_PAYDET.VOUCH_NO), 'N/A') BARCODE_NO "
					+ " FROM MISC_PAYDET, MISC_PAYABLES, MISC_PAYMENT "
					+ " WHERE MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ " AND MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " AND MISC_PAYMENT.TRAN_ID = MISC_PAYDET.TRAN_ID "
					+ " AND MISC_PAYMENT.TRAN_ID = ? "
					+ " ORDER BY MISC_PAYDET.VOUCH_NO ";
			//Changed by Prasad on 08/05/15 [For getting Voucher Details] END
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
 
			rs = pstmt.executeQuery();
			
			valueXmlString.append("<Root>\r\n");
			while (rs.next())
			{
				valueXmlString.append("<VOUCHER_DET domID='" + num + "'>\r\n");
				valueXmlString.append("<voucher_no><![CDATA[").append( rs.getString(1) ).append("]]></voucher_no>\r\n");
				valueXmlString.append("<voucher_date><![CDATA[").append( rs.getString(2) ).append("]]></voucher_date>\r\n");
				valueXmlString.append("<pay_amt><![CDATA[").append( decimalFormat.format( rs.getDouble(3) ) ).append("]]></pay_amt>\r\n");
				valueXmlString.append("<due_date><![CDATA[").append( rs.getString(4) ).append("]]></due_date>\r\n");
				valueXmlString.append("<barcode_no><![CDATA[").append( rs.getString(5) ).append("]]></barcode_no>\r\n"); //Added by Prasad on 08/05/15 [For getting Bar code Details] END
				valueXmlString.append("</VOUCHER_DET>\r\n");
				num++;
			}
			valueXmlString.append("</Root>\r\n");
			
			pstmt.close(); pstmt = null;
			rs.close(); rs = null;
			conn.close();
		}
		catch (SQLException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				conn.close();
				if (pstmt != null)
				{
					pstmt.close();
				}
			}
			catch (SQLException e) 
			{
				throw new ITMException(e);
			}
		}
		
		try 
		{
			String xslFileName = getXSLFileName( "MKTPaymentAuth.xsl" );
			
			vouch_det = genericUtility.transformToString( xslFileName, valueXmlString.toString(), CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (ITMException e) 
		{
			throw new ITMException(e);
		}
		
		return vouch_det;
	}
	
	/**
	 * get XSL filename
	 * @param xslFileName
	 * @return
	 * @throws ITMException
	 */
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			//File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			//Changed by Prasad on 31/07/15 [Change xsl path] START
			//File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME );
			File xslPath = new File( defaultPath + File.separator  + "xsl" );
			//Changed by Prasad on 31/07/15 [Change xsl path] END
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	/**
	 * get Attachment details
	 * @param refId
	 * @return
	 * @throws ITMException 
	 */
	public String getAttachmentDetails( String objName, String refId ) throws ITMException 
	{
		String retStr = "", refSer = "", xmlData = "";
		String refCol = null;
		try 
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			
			DBAccessRemote dbAccess = (DBAccessRemote)ctx.lookup("ibase/DBAccessEJB/remote");
			refSer = dbAccess.getRefSer( null, objName );
			
			DocumentHandlerRemote docHandler = (DocumentHandlerRemote)ctx.lookup("ibase/DocumentHandlerEJB/remote");
			if ( refId != null && refId.indexOf(",") != -1 )
			{
				//Changed By Prasad on [14/05/15] [for view multiple attachment] START
				//xmlData = docHandler.getMultiDocumentInfoList(refSer, refId, refCol);
				try 
				{
					DocumentHandlerWrapperRemote docWrapperHandler = (DocumentHandlerWrapperRemote)ctx.lookup("ibase/DocumentHandlerWrapperEJB/remote");
					System.out.println( "In MarketingBillBean docWrapperHandler["+docWrapperHandler+"]" );
					// error because miss match argument
					xmlData = docWrapperHandler.getMultiDocumentInfoList(refSer, refId, refCol,transDb);
				}
				catch (Exception e) 
				{
					System.out.println("Exception In MarketingBillBean getMultiDocumentInfoList : "+ e.getMessage());
					e.printStackTrace();
				}
				//Changed By Prasad on [14/05/15] [for view multiple attachment] END
			}
			else
			{
				xmlData = docHandler.getDocumentInfoList(refSer, refId, refCol,transDb);
			}
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		
		try 
		{
			String xslFileName = getXSLFileName( "MKTMultiAttachView.xsl" );
			
			retStr = genericUtility.transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (ITMException e) 
		{
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		
		return retStr;
	}
	
	/**
	 * checking rights and delete attachment
	 * @param docId
	 * @param refId
	 * @param objName
	 * @param refCol
	 * @return
	 * @throws ITMException
	 * @throws RemoteException
	 */
	public String removeAttachment( String docId, String refId, String objName, String refCol ) throws ITMException, RemoteException
	{
		String retStr = "";
		try 
		{
			String userLevel = this.userInfo.getUserLevel();
			String profileId = this.userInfo.getProfileId();
			String loginCode = this.userInfo.getLoginCode();
			if(profileId != null)
			{
				profileId = profileId.trim();
			}
			String pkValues = refId;
			System.out.println("pkValues==== "+pkValues);
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			
			DBAccessRemote dbAccess = (DBAccessRemote)ctx.lookup("ibase/DBAccessEJB/remote");
			DocumentHandlerRemote docHandler = (DocumentHandlerRemote)ctx.lookup("ibase/DocumentHandlerEJB/remote");
			
			if( pkValues != null && !pkValues.isEmpty() )
			{
				String addedByUserId = docHandler.docAddedBy( docId,transDb );
				System.out.println("addedByUserId = ["+ addedByUserId +"]");
				
				boolean isAuthorized = dbAccess.deleteAttachmentAuth( docId, userLevel, profileId, loginCode, objName, pkValues, addedByUserId,transDb );
				System.out.println("isAuthorized = ["+ isAuthorized +"]");
				
				if( isAuthorized )
				{
					retStr = removeAttach( docId, refId, objName, refCol );
				}
				else
				{
					retStr = "User have not authorization to delete attachment";
				}
			}
			else
			{
				System.out.println("pkValues are null.");
				retStr = "pkValues are null."; 
			}
		} 
		catch (RemoteException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retStr = ["+ retStr +"]");		
		
		return retStr;
	}
	
	/**
	 * remove attachment from DOC_CONTENTS
	 * @param docId
	 * @param refId
	 * @param objName
	 * @param refCol
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String removeAttach(String docId, String refId, String objName, String refCol) throws RemoteException,ITMException
	{
		String retString = "", refSer = ""; //$NON-NLS-1$
		Connection conn = null;
		PreparedStatement mPstmt = null;
		String selQry = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			DBAccessRemote dbAccess = (DBAccessRemote)ctx.lookup("ibase/DBAccessEJB/remote");
			refSer = dbAccess.getRefSer( null, objName );
			
			System.out.println("refCol = [" + refCol + "]");
			if(refCol == null || "null".equalsIgnoreCase(refCol))
			{
				refCol = "";
			}
			
			selQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID ='"+docId+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			System.out.println("Execute --- " + selQry);
			
			mPstmt = conn.prepareStatement(selQry);
			int deletedRow = mPstmt.executeUpdate();
			mPstmt.close();
			mPstmt=null;

			String refIds = refId;
			if ( refId != null && refId.indexOf(",") != -1 )
			{
				String[] refIDs = refId.split(",");
				refIds = "";
				for (int i = 0; i < refIDs.length; i++)
				{
					refIds += "'" + refIDs[i].trim() + "',";
				}
				if ( refIds.trim().length() >= 2 )
				{
					refIds = refIds.substring(1, refIds.trim().length()-2);
				}
			}
			System.out.println("tranId ["+ refIds +"]");
			if(refCol.length() == 0)
			{
				selQry = "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID ='" + docId + "' AND REF_ID IN ('" + refIds + "') AND REF_SER = '" + refSer + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
			else
			{
				selQry = "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID ='" + docId + "' AND REF_ID IN ('" + refIds + "') AND REF_SER = '" + refSer + "' AND REF_COL='" + refCol + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}

			mPstmt = conn.prepareStatement(selQry);
			int deletedTranRow = mPstmt.executeUpdate();
			mPstmt.close();
			mPstmt=null;
			if(deletedRow == 1 && deletedTranRow == 1)
			{
				retString = "success";
				conn.commit();
			}
			else
			{
				retString = "Deleted Failure";
				conn.rollback();
			}
		}
		catch(SQLException ie)
		{
			System.out.println("SQLException :MarketingBillBean :removeAttach:==>"+ie); //$NON-NLS-1$
			retString = "Deleted Failure";
			ie.printStackTrace(); 
			throw new ITMException(ie);
     	}
		catch(Exception e)
		{
			System.out.println("Exception :MarketingBillBean :removeAttach :==>"+e); //$NON-NLS-1$
			retString = "Deleted Failure";
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{					
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		
		System.out.println("In MarketingBillBean : removeAttach :retString["+retString+"]");
		
	    return retString;
	}
	//Added by Prasad on 20/04/15 [for SSC changes [Payment Authorization Screen]] END
	
	//Added by Prasad on 08/05/15 [for getting report type] START
	/**
	 * for getting report type
	 * @param voucherNo
	 * @return
	 * @throws ITMException
	 */
	public String getReportType( String voucherNo ) throws ITMException 
	{
		String retStr = "0";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			
			String sql = "SELECT COUNT(1) FROM VOUCHER WHERE TRAN_ID = ?";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, voucherNo);
			
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				retStr = rs.getString(1);
			}
			rs.close();
			System.out.println("retStr : ["+ retStr +"]");
		} 
		catch (SQLException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				conn.close();
			}
			catch (SQLException e) 
			{
				throw new ITMException(e);
			}
		}
		
		return retStr;
	}
	//Added by Prasad on 08/05/15 [for getting report type] END
	
	//Added by Prasad on 11/05/15 [for getting Document Details] START
	/**
	 * For getting Document Details
	 * @return
	 */
	public String getDocumentDtl()
	{
		String docId = "", docName = "";//, objName = "";
		String inProcessDocMapKey = "", inProcessDocMapValue = "";
		byte[] byteArray = null;
		
		try 
		{
			System.out.println("objName = ["+ objName +"] userId = ["+ userId +"] sessionId = ["+ sessionId +"]");
			
			removeInProcessDocId(); //For remove docId from InprocessMap
			
			System.out.println("****************** In getDocumentDtl *************");
			
			DocumentHandlerRemote documentHandlerEJB = null;
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			documentHandlerEJB = (DocumentHandlerRemote) ctx.lookup("ibase/DocumentHandlerEJB/remote");
			
			if ( servletContext.getAttribute("unAllocDocMapMarkt") != null )
			{
				System.out.println("Getting unallocated document map");
				mapListUnAlloc = (Map<String, ArrayList<String>>) servletContext.getAttribute("unAllocDocMapMarkt");
			}
			for (Map.Entry<String, ArrayList<String>> entry1 : mapListUnAlloc.entrySet()) 
			{
				System.out.println("[unallocated document map] ObjName = [" + entry1.getKey() + "] DocumentIds = [" + entry1.getValue() + "]");
			}
			
			if ( servletContext.getAttribute("inProcessUnAllocDocMapMarkt") != null )
			{
				System.out.println("Getting inProcess UnAllocated document Map");
				inProcessMapList = (Map<String, ArrayList<String>>) servletContext.getAttribute("inProcessUnAllocDocMapMarkt");
			}
			else
			{
				System.out.println("Creating inProcess UnAllocated document Map as not found in servletContext");
				inProcessMapList = new HashMap<String, ArrayList<String>>();
			}
			for (Map.Entry<String, ArrayList<String>> entry2 : inProcessMapList.entrySet()) 
			{
				System.out.println("[inProcess UnAllocated document Map] ObjName = [" + entry2.getKey() + "] DocumentIds = [" + entry2.getValue() + "]");
			}
			
			if ( servletContext.getAttribute("inProcessDocIds") != null )
			{
				System.out.println("Getting inProcess document Ids");
				inProcessDocIds = (String)servletContext.getAttribute("inProcessDocIds");
			}
			System.out.println("[inProcess document Ids] inProcessDocIds = [" + inProcessDocIds + "]");
			
			//Getting Document from Unallocated map START
			if ( mapListUnAlloc != null && ! mapListUnAlloc.isEmpty() )
			{
				//objName = "supplier_bill";
				ArrayList<String> docIDAL = mapListUnAlloc.get("marketing_bill");//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
				if ( docIDAL != null && ! docIDAL.isEmpty() )
				{
					//Changed by Prasad on 12/01/16 [for document repetition check already processed or not] START
					//docId = docIDAL.get(0);
					//docId = request.getParameter( "DOC_ID" ) != null ? request.getParameter( "DOC_ID" ) : docId;
					if ( request != null && E12GenericUtility.checkNull( request.getParameter( "DOC_ID" ) ).length() > 0 ) //direct entry for Unallocated document - [supplier_bill_unalloc]
					{
						docId = request.getParameter( "DOC_ID" );
					}
					else
					{
						for ( int i = 0; i < docIDAL.size(); i++ )
						{
							docId = docIDAL.get(i);
							boolean isProcessedDocument = isProcessedDocument( docId, objName );
							System.out.println("isProcessedDocument - ["+ isProcessedDocument +"]");
							if ( ! isProcessedDocument )
							{
								break;
							}
							else if ( isProcessedDocument )
							{
								if ( docIDAL.remove( docId ) )
								{
									BaseLogger.info("["+ docId +"] : Removed from unAllocMap while loading.");
								}
							}
						}
					}
					//Changed by Prasad on 12/01/16 [for document repetition check already processed or not] END
					
					//docIDAL.remove(docId);
					if ( docIDAL.remove(docId) )
					{
						//Added By Prasad on 03/06/15 [For creating ssc.log]
						//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
						//SSCLogger.info("["+ docId +"] : Removed from unAllocMap");
						BaseLogger.info("["+ docId +"] : Removed from unAllocMap");
					}
					mapListUnAlloc.put("marketing_bill", docIDAL);//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
					
					servletContext.setAttribute("unAllocDocMapMarkt", mapListUnAlloc);
					
					//if (docId != "")
					if ( E12GenericUtility.checkNull( docId ).length() > 0 )
					{
						docName = documentHandlerEJB.getDocumentName(docId,transDb);
						System.out.println("docId = ["+ docId +"] docName = ["+ docName +"]");

						System.out.println("inProcessDocIds = ["+ inProcessDocIds +"]");
						inProcessDocIds = inProcessDocIds + "'" + docId + "',";
						System.out.println("After appending inProcessDocIds = ["+ inProcessDocIds +"]");
						
						servletContext.setAttribute("inProcessDocIds", inProcessDocIds);
						
						inProcessDocMapKey = userId + ":" + sessionId;
						inProcessDocMapValue = objName + ":" + docId + ":" + docName;
						
						if( ! inProcessMapList.isEmpty() && inProcessMapList.containsKey( inProcessDocMapKey ) )
						{
							ArrayList<String> oldArrayList = inProcessMapList.get( inProcessDocMapKey );
							if ( ! oldArrayList.contains( inProcessDocMapValue ) ) 
							{
								oldArrayList.add( inProcessDocMapValue.trim() );
								System.out.println("[" + inProcessDocMapValue + "] Document added in process list in IF");
								//Added By Prasad on 03/06/15 [For creating ssc.log]
								//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
								//SSCLogger.info("["+ docId +"] : Added in inProcessMap");
								BaseLogger.info("["+ docId +"] : Added in inProcessMap");
							}
							inProcessMapList.put( inProcessDocMapKey, oldArrayList );
						}
						else
						{
							ArrayList<String> inProcessValue = new ArrayList<String>();
							inProcessValue.add( inProcessDocMapValue.trim() );
							System.out.println("[" + inProcessDocMapValue + "] Document added in process list in ELSE");
							//Added By Prasad on 03/06/15 [For creating ssc.log]
							//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
							//SSCLogger.info("["+ docId +"] : Added in inProcessMap");
							BaseLogger.info("["+ docId +"] : Added in inProcessMap");
							inProcessMapList.put( inProcessDocMapKey, inProcessValue );
						}
						servletContext.setAttribute("inProcessUnAllocDocMapMarkt", inProcessMapList);
					}
			
					byteArray = documentHandlerEJB.getDocument(docId,userInfo);
					String strDirectoy = "";
					//Download Document in 'Downloads' folder
					if (byteArray != null) 
					{
						try 
						{
							strDirectoy = CommonConstants.APPLICATION_CONTEXT +"Downloads";
							System.out.println("strDirectoy = ["+ strDirectoy +"]");
							File outFile = new File(strDirectoy);
							if ( ! outFile.exists() ) 
							{
								outFile.mkdir();
							}
							if ( ! docName.equals("") )
							{
								outFile = new File(strDirectoy + File.separator + docName);
								
								FileOutputStream fout = new FileOutputStream(outFile);
								IOUtils.write(byteArray, fout);
								fout.close();
							}
							else
							{
								System.out.println("Document Name is empty.");
							}
						}
						catch (Exception e) 
						{
							e.printStackTrace();
						}
					}
				}
			}
			//Getting Document from Unallocated map END
		}
		catch (RemoteException e) 
		{
			e.printStackTrace();
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return inProcessDocMapValue;
	}
	
	/**
	 * For remove docId from InprocessMap
	 */
	private void removeInProcessDocId()
	{
		System.out.println("****************** In removeDocument *************");
		String docId = "";
		String inProcessDocMapKey = "";
		
		try
		{
			//Added By Prasad on 03/06/15 [For creating ssc.log]
			//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
			//SSCLogger.info("["+ userId +"] --------------- In SupplierBillBean --------------- for objName : ["+ objName +"]");
			BaseLogger.info("["+ userId +"] --------------- In MarketingBillBean --------------- for objName : ["+ objName +"]");
			
			if ( servletContext.getAttribute("unAllocDocMapMarkt") != null )
			{
				System.out.println("Getting unallocated document map");
				mapListUnAlloc = (Map<String, ArrayList<String>>) servletContext.getAttribute("unAllocDocMapMarkt");
			}
			for (Map.Entry<String, ArrayList<String>> entry1 : mapListUnAlloc.entrySet()) 
			{
				System.out.println("[unallocated document map] ObjName = [" + entry1.getKey() + "] DocumentIds = [" + entry1.getValue() + "]");
			}
			
			if ( servletContext.getAttribute("inProcessUnAllocDocMapMarkt") != null )
			{
				System.out.println("Getting inProcess UnAllocated document Map");
				inProcessMapList = (Map<String, ArrayList<String>>) servletContext.getAttribute("inProcessUnAllocDocMapMarkt");
			}
			else
			{
				System.out.println("Creating inProcess UnAllocated document Map as not found in servletContext");
				inProcessMapList = new HashMap<String, ArrayList<String>>();
			}
			for (Map.Entry<String, ArrayList<String>> entry2 : inProcessMapList.entrySet()) 
			{
				System.out.println("[inProcess UnAllocated document Map] ObjName = [" + entry2.getKey() + "] DocumentIds = [" + entry2.getValue() + "]");
			}
			
			if ( servletContext.getAttribute("inProcessDocIds") != null )
			{
				System.out.println("Getting inProcess document Ids");
				inProcessDocIds = (String)servletContext.getAttribute("inProcessDocIds");
			}
			System.out.println("[inProcess document Ids] inProcessDocIds = [" + inProcessDocIds + "]");
			
			inProcessDocMapKey = userId + ":" + sessionId;
			if ( inProcessMapList != null && !inProcessMapList.isEmpty() )
			{
				ArrayList<String> value = inProcessMapList.get(inProcessDocMapKey);
				if ( value != null && !value.isEmpty())
				{
					for (int i = 0; i < value.size(); i++) 
					{
						System.out.println("********************** "+ value.get(i));
						if ( value.get(i) != null )
						{
							String[] inProcessDocMapValue = value.get(i).split(":");
							if ( inProcessDocMapValue[0] != null && inProcessDocMapValue[0].trim().equals( objName ) )
							{
								docId = (String)value.get(i);
								//value.remove( docId );
								if ( value.remove( docId.trim() ) )
								{
									System.out.println("From DocMapKey = [" + inProcessDocMapKey + "] DocId = ["+ docId +"] Removed.");
									//Added By Prasad on 03/06/15 [For creating ssc.log]
									//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
									//SSCLogger.info("["+ docId +"] : Removed from inProcessMap");
									BaseLogger.info("["+ docId +"] : Removed from inProcessMap");
								}
								else
								{
									//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
									//SSCLogger.info("["+ docId +"] : Not Removed from inProcessMap");
									BaseLogger.info("["+ docId +"] : Not Removed from inProcessMap");
								}
							}
						}
			        }
				}
				
				//if (docId != "")
				if ( E12GenericUtility.checkNull( docId ).length() > 0 )
				{
					String[] inProcessDocMapValue = docId.split("\\:");
					
					if ( ( !mapListUnAlloc.isEmpty() ) && ( mapListUnAlloc.containsKey("marketing_bill" ) ) )//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
					{
						ArrayList<String> oldArrayList = mapListUnAlloc.get("marketing_bill");//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
						if (!oldArrayList.contains(inProcessDocMapValue[1]))
						{
							oldArrayList.add(inProcessDocMapValue[1].trim());
							System.out.println("[" + inProcessDocMapValue[1] + "] Document added in process list if condition [Remove]");
							//Added By Prasad on 03/06/15 [For creating ssc.log]
							//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
							//SSCLogger.info("["+ inProcessDocMapValue[1] +"] : Added in unAllocMap");
							BaseLogger.info("["+ inProcessDocMapValue[1] +"] : Added in unAllocMap");
						}
						mapListUnAlloc.put("marketing_bill", oldArrayList);//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
					}
					else
					{
						ArrayList<String> inProcessValue = new ArrayList<String>();
						inProcessValue.add(inProcessDocMapValue[1].trim());
						System.out.println("[" + inProcessDocMapValue[1] + "] Document added in process list else condition [Remove]");
						//Added By Prasad on 03/06/15 [For creating ssc.log]
						//Changed by Prasad on 12/08/15 [change SSCLogger to BaseLogger]
						//SSCLogger.info("["+ inProcessDocMapValue[1] +"] : Added in unAllocMap");
						BaseLogger.info("["+ inProcessDocMapValue[1] +"] : Added in unAllocMap");
						mapListUnAlloc.put("marketing_bill", inProcessValue);//Modified by vinay c 15/01/2020 [Rename supplier_bill ]
					}
					servletContext.setAttribute("unAllocDocMapMarkt", mapListUnAlloc);
					
					String removeString = "'" + inProcessDocMapValue[1] + "',";
					System.out.println("removeString [Remove] = ["+ removeString +"]");
					
					inProcessDocIds = inProcessDocIds.replace(removeString, "");
					System.out.println("After remooving inProcessDocIds [Remove] = ["+ inProcessDocIds +"]");
					
					servletContext.setAttribute("inProcessDocIds", inProcessDocIds);
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * for checking document is present in unallocated map or not
	 * @param docId
	 * @return
	 */
	public String isDocIdInUnallocateMap( String docId )
	{
		System.out.println("In isDocIdInUnallocateMap ["+ docId +"]");
		String isDocIdInMap = "";
		String inProcessDocIds = "";
		Map<String, ArrayList<String>> mapListUnAlloc = new HashMap<String, ArrayList<String>>();
		
		if ( servletContext.getAttribute("inProcessDocIds") != null )
		{
			inProcessDocIds = (String)servletContext.getAttribute("inProcessDocIds");
		}
		if ( inProcessDocIds.indexOf( docId ) != -1 )
		{
			isDocIdInMap = "Document is in Process.";
		}
		else
		{
			if ( servletContext.getAttribute("unAllocDocMapMarkt") != null )
			{
				System.out.println("Getting unallocated document map");
				mapListUnAlloc = (Map<String, ArrayList<String>>) servletContext.getAttribute("unAllocDocMapMarkt");
			}
			ArrayList<String> docIDAL = mapListUnAlloc.get("marketing_bill");//Modified by vinay c 16/01/2019 rename supplier_bill to marketing_bill
			if ( docIDAL != null )
			{
				if ( docIDAL.isEmpty() )
				{
					isDocIdInMap = "Document is already Processed.";
				}
				else if ( !docIDAL.isEmpty() && !docIDAL.contains(docId) )
				{
					isDocIdInMap = "Document is already Processed.";
				}
			}
			if ( docIDAL == null )
			{
				isDocIdInMap = "Document is already Processed.";
			}
		}
		System.out.println("isDocIdInMap = ["+ isDocIdInMap +"]");
		
		return isDocIdInMap;
	}
	//Added by Prasad on 11/05/15 [for getting Document Details] END
	
	//Added by Prasad on 05-06-15 [for delete transaction if document upload fails] START
	/**
	 * for delete transaction if document upload fails
	 * @param objName
	 * @param tranId
	 * @return
	 * @throws Exception
	 */
	public String deleteTransaction( String objName, String tranId ) throws Exception
	{
		String retStr = "Success";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			
			String winName = "w_"+objName;
			String tableName = "", tranIdCol = "";
			
			String sql = "SELECT TRAN_ID_COL, TABLE_NAME FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, winName);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				tranIdCol = rs.getString(1);
				tableName = rs.getString(2);
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			System.out.println("tranIdCol : ["+ tranIdCol +"] tableName : ["+ tableName +"]");
			
			conn.setAutoCommit(false);
			
			sql = "DELETE FROM "+ tableName +" WHERE "+ tranIdCol +" = "+ tranId;
			pstmt = conn.prepareStatement(sql);
			int delCnt = pstmt.executeUpdate();
			pstmt.close(); pstmt = null;
			if ( delCnt > 0)
			{
				conn.commit();
			}
			System.out.println(delCnt + " rows of "+ tableName +" deleted.");
		}
		catch (SQLException e) 
		{
			retStr = "Error";
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			retStr = "Error";
			throw new Exception(e);
		}
		finally 
		{
			try 
			{
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				throw new Exception(e);
			}
		}
		
		return retStr; 
	}
	//Added by Prasad on 05-06-15 [for delete transaction if document upload fails] END
	
	//Added by Prasad on 29/07/15 [for view document from Payment Authorization screen] START
	/**
	 * for view document from Payment Authorization screen
	 * @param docId
	 * @param docName
	 * @return
	 */
	public String viewDocument( String docIds ) throws Exception
	{
		String documentPath = "";
		String docName = "";
		String documentNames = "";
		System.out.println("docIds = ["+ docIds +"]");
		try 
		{
			DocumentHandlerRemote documentHandlerEJB = null;
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			documentHandlerEJB = (DocumentHandlerRemote) ctx.lookup("ibase/DocumentHandlerEJB/remote");
			
			String[] documentIds = docIds.split(",");
 			for ( int i = 0; i < documentIds.length; i++ )
			{
				String docId = documentIds[i];
				byte[] byteArray = documentHandlerEJB.getDocument(docId,userInfo);
				
				docName = documentHandlerEJB.getDocumentName(docId,transDb);
				System.out.println("docId = ["+ docId +"] docName = ["+ docName +"]");
				documentNames += "," + docName;
				if (byteArray != null) 
				{
					try 
					{
						documentPath = CommonConstants.APPLICATION_CONTEXT +"PayAuthAttachments";
						File outFile = new File(documentPath);
						if ( ! outFile.exists() ) 
						{
							outFile.mkdir();
						}
						if ( ! docName.equals("") )
						{
							outFile = new File(documentPath + File.separator + docName);
							FileOutputStream fout = new FileOutputStream(outFile);
							IOUtils.write(byteArray, fout);
							fout.close();
						}
						else
						{
							System.out.println("Document Name is empty.");
						}
					}
					catch (Exception e) 
					{
						e.printStackTrace();
					}
				}
			}
 			documentNames = documentNames.substring(1, documentNames.length());
 			System.out.println("documentNames = ["+ documentNames +"]");
		}
		catch (RemoteException e) 
		{
			System.out.println("RemoteException: viewDocument : "+e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (ITMException e) 
		{
			System.out.println("ITMException: viewDocument : "+e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (NamingException e) 
		{
			System.out.println("NamingException: viewDocument : "+e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			System.out.println("Exception: viewDocument : "+e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("documentPath = ["+ (documentPath + File.separator + docName).toString() +"]");
		
		return documentNames;
	}
	//Added by Prasad on 29/07/15 [for view document from Payment Authorization screen] END
	
	//Added by Prasad on 12/01/16 [for document repetition check already processed or not] START
	/**
	 * Check for document is already process or not
	 * @param docId
	 * @param objName
	 * @return
	 */
	private boolean isProcessedDocument( String docId, String objName )
	{
		boolean isProcessedDocument = false;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			
			String sql = "SELECT COUNT(1) AS COUNT FROM SUPPLIER_BILL WHERE TRIM(BARCODE_SCAN) "
					+ " IN (SELECT TRIM(REF_ID) FROM UNALLOCATED_ATTACH "
					+ " WHERE DOC_ID = ? AND OBJ_NAME = ?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, docId);
			pstmt.setString(2, objName);
			rs = pstmt.executeQuery();
			int retCnt = 0;
			if ( rs.next() )
			{
				retCnt = rs.getInt(1);
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			if ( retCnt != 0 )
			{
				isProcessedDocument = true;
			}
		}
		catch (SQLException e) 
		{
			isProcessedDocument = false;
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			isProcessedDocument = false;
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("isProcessedDocument : ["+ isProcessedDocument +"]");
		
		return isProcessedDocument; 
	}
	//Added by Prasad on 12/01/16 [for document repetition check already processed or not] END
}
