package ibase.webitm.ejb.mkt;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import org.w3c.dom.Document;

/**
 * Session Bean implementation class MarketingBillSubmitPosEJB
 */
@Stateless
public class MarketingBillSubmitPosEJB extends ValidatorEJB implements MarketingBillSubmitPosRemote, MarketingBillSubmitPosLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
    /**
     * Default constructor. 
     */
    public MarketingBillSubmitPosEJB() 
    {

    }

	@Override
	public String postSave(String xmlStringAll, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		Document dom = null;
		String retString = "";
		
		System.out.println("PostSave Action Called:::"+ xmlStringAll);
		System.out.println("PostSave editFlag:::"+ editFlag);
		System.out.println("PostSave tranId:::"+ tranId);
		
		try 
		{
			if ( editFlag.equalsIgnoreCase( "A" ) )
			{
				dom = genericUtility.parseString(xmlStringAll);
				
				String userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
				String termId = getValueFromXTRA_PARAMS(xtraParams, "termId");
				
				tranId = checkNull(genericUtility.getColumnValue("tran_id",dom, "1"));
				upadateSuppBillStatus( conn, tranId, userId, termId );
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			retString = e.getMessage();
			throw new ITMException(e);
		}
		System.out.println("retString = ["+ retString +"]");
		
		return retString;
	}
	
	//Added by Prasad on 30/06/15 [for updating Supplier Bill Entry] START
	/**
	 * Update Supplier Bill entry
	 * @param conn
	 * @param tranId
	 * @param userId
	 * @param termId
	 * @throws ITMException
	 */
	private void upadateSuppBillStatus( Connection conn, String tranId, String userId, String termId ) throws ITMException
	{
		PreparedStatement pstmt = null;
		
		try 
		{
			if ( ! checkNull(tranId).equals("") )
			{
				String sql = "UPDATE SUPPLIER_BILL "
						+ " SET STATUS = 'H', REAS_CODES = (SELECT VAR_VALUE FROM FINPARM WHERE VAR_NAME = 'SSC_PORTAL_REASON'), "
						+ " CHG_DATE = SYSDATE, CHG_USER = ?, CHG_TERM = ? "
						+ " WHERE TRAN_ID = ?";
				
				pstmt = conn.prepareStatement(sql);
				
				pstmt.setString(1, userId);
				pstmt.setString(2, termId);
				pstmt.setString(3, tranId);
				int updateCnt = pstmt.executeUpdate();
				System.out.println("updateCnt "+ updateCnt);
				
				if( updateCnt != 0 )
				{
					conn.commit();
				}
			}
		} 
		catch (SQLException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				throw new ITMException(e);
			}
		}
	}
	//Added by Prasad on 30/06/15 [for updating Supplier Bill Entry] END
	
	/**
	 * checking null value
	 * @param input
	 * @return
	 */
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
