 
package ibase.webitm.ejb.mkt	;

import ibase.ejb.E12EMAILComp;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UnAllocatedDocEJBLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class MarketingBillPosEJB
 */
@Stateless
public class MarketingBillPosEJB extends ValidatorEJB implements MarketingBillPosRemote, MarketingBillPosLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
    /**
     * Default constructor. 
     */
    public MarketingBillPosEJB() 
    {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		Document dom = null;
		String retString="";
		//By VALLABH KADAM.
		String suppCode="",porderNo="",billNo="",reasonCodes="",voucherNo="",status="", sundryType = "", sundryCode = "", docType = "";// Added by parikshit on 15/02/16 [added docType variable - F15KSUN007 ]
		
		int cnt=0,cnt1=0;
		Timestamp billDate=null,billRcvDate=null;
		
		PreparedStatement pstmt1=null,pstmt2=null,pstmt3=null,pstmt=null;
		ResultSet rs1=null,rs2=null,rs3=null,rs=null;
		String sql1="",sql2="",sql3="",sql="";
		String transDB="";
		String chgUser="";
		String loginEmpCode="";
		String loginSiteCode="";
		ibase.utility.UserInfoBean userInfo=null;
		
		
		// By VALLABH KADAM.
		
		System.out.println("PostSave Action Called:::"+ xmlStringAll);
		System.out.println("PostSave editFlag:::"+ editFlag);

		try 
		{
			dom = genericUtility.parseString(xmlStringAll);
			userInfo = new ibase.utility.UserInfoBean();
			System.out.println("xtraParams>>>>" + xtraParams);
			String userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String termId = getValueFromXTRA_PARAMS(xtraParams, "termId");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			userInfo.setEmpCode(loginEmpCode);
			userInfo.setRemoteHost(termId);
			userInfo.setSiteCode(loginSiteCode);
			userInfo.setLoginCode(userId);
			userInfo.setEntityCode(loginEmpCode);
			
			if ( editFlag.equalsIgnoreCase( "A" ) )
			{
				String objName = checkNull(getObjNameFromDom(dom, "objName","1"));
				
				tranId = checkNull(genericUtility.getColumnValue("tran_id",dom, "1"));
				String billDocId = checkNull(genericUtility.getColumnValue("bill_doc_id",dom, "1"));
				System.out.println("billDocId>>> " +billDocId);
				System.out.println("objName = ["+ objName +"] tranId = ["+ tranId +"] billDocId = ["+ billDocId +"] userId = ["+ userId +"]");
				
				if ( billDocId != null && billDocId.trim().length() > 0)
				{
					String[] inProcessDocMapValue = billDocId.split("\\:");
					String inProcessObjName = inProcessDocMapValue[0];
					String inProcessDocId = inProcessDocMapValue[1];
					String docName = inProcessDocMapValue[2];
					
					String strDirectoy = CommonConstants.APPLICATION_CONTEXT +"Downloads";
					if (docName != "")
					{
						File file = new File(strDirectoy + File.separator + docName);
						if(file.delete())
						{
							System.out.println(file.getName() + " is deleted!");
						}
						else
						{
							System.out.println("Delete operation is failed.");
						}
					}
					
					//Changed by Prasad on 07/07/14 [sends connection to update count of attachments] START
					//UnAllocatedDocEJBRemote unAllocatedDocEJBRemote = null;
					//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
					//unAllocatedDocEJBRemote = (UnAllocatedDocEJBRemote) ctx.lookup("ibase/UnAllocatedDocEJB/remote");
					//retString = unAllocatedDocEJBLocal.updateDocTransactionLink(objName, tranId, inProcessObjName, inProcessDocId, userId);
					
					UnAllocatedDocEJBLocal unAllocatedDocEJBLocal = null;
					InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
					unAllocatedDocEJBLocal = (UnAllocatedDocEJBLocal) ctx.lookup("ibase/UnAllocatedDocEJB/local");
					
					//added by adnan for transdb
					sql = "select TRANS_DB from users where code= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if (rs.next()) 
					{
						transDB = rs.getString("TRANS_DB");
						
					}
					System.out.println("transDB = " + transDB);
					if(rs != null)
					{
						rs.close();
						rs= null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//end by adnan
					
					retString = unAllocatedDocEJBLocal.updateDocTransactionLink(objName, tranId, inProcessObjName, inProcessDocId, userId, conn,userInfo);
					//Changed by Prasad on 07/07/14 [sends connection to update count of attachments] END
				}
			}
			//Added By Prasad on 27/06/15 [for updating Voucher Details] START
			//Changed by Prasad on 09/07/15 [pass connection object to method] START
			//String updateStatus = updateVoucherDetails( dom, userId, termId )
			String updateStatus = updateVoucherDetails( dom, userId, termId, conn );
			//Changed by Prasad on 09/07/15 [removi new connection object] END
			System.out.println("voucher updateStatus "+ updateStatus);
			//Added By Prasad on 27/06/15 [for updating Voucher Details] END
			
			
			/**
			 * VALLABH KADAM 
			 * change on [30/JUN/15]
			 * Add from SupplierBillSubmitPos.java  
			 * 
			 * 	START
			 * */
			
			
			billNo=checkNull(genericUtility.getColumnValue("bill_no",dom, "1"));			
			voucherNo=checkNull(genericUtility.getColumnValue("voucher_no",dom, "1"));
			System.out.println("Umakanta::voucherNo["+voucherNo+"]");
			String billDateStr= checkNull( genericUtility.getColumnValue( "bill_date",dom, "1" ) );
			System.out.println("Umakanta::billDateStr["+billDateStr+"]");
			if ( billDateStr.length() > 0 )
			{
				billDate = Timestamp.valueOf(genericUtility.getValidDateString(billDateStr, genericUtility.getApplDateFormat(),
						genericUtility.getDBDateFormat())+ " 00:00:00.0");	
			}
//			String billRcvDateStr=genericUtility.getColumnValue("bill_rcvd_dt",dom, "1");			
//			billRcvDate = Timestamp.valueOf(genericUtility.getValidDateString(billRcvDateStr, genericUtility.getApplDateFormat(),
//					genericUtility.getDBDateFormat())+ " 00:00:00.0");			
			suppCode=checkNull(genericUtility.getColumnValue("supp_code",dom, "1"));
			porderNo=checkNull(genericUtility.getColumnValue("porder_no",dom, "1"));
			reasonCodes=checkNull(genericUtility.getColumnValue("reas_codes",dom, "1"));
			status=checkNull(genericUtility.getColumnValue("status",dom, "1"));
			sundryType = checkNull(genericUtility.getColumnValue("sundry_type",dom, "1"));
			sundryCode = checkNull(genericUtility.getColumnValue("sundry_code",dom, "1"));
			docType = checkNull(genericUtility.getColumnValue("doc_type",dom, "1")); // Added by parikshit on 15/02/16 [get doc_type value from dom - F15KSUN007 ]
			
	        
	        System.out.println("@V@ Supplier Code :- ["+suppCode+"]");
	        System.out.println("@V@ Purchase order :- ["+porderNo+"]");
	        System.out.println("@V@ Bill No :- ["+billNo+"]");
	        System.out.println("@V@ Reason Codes :- ["+reasonCodes+"]");
	        System.out.println("@V@ Voucher No :- "+voucherNo+"]");
	        System.out.println("@V@ Status :- ["+status+"]");
	        System.out.println("@V@ Bill Date :- ["+billDateStr+"]");
	        System.out.println("@V@ SundryType :- ["+sundryType+"]");
	        System.out.println("@V@ SundryCode:- ["+sundryCode+"]");
	        System.out.println("@V@ docType:- ["+docType+"]");
//	        System.out.println("@V@ Bill Recived Date :- ["+billRcvDate+"]");
	        
	        
	        /**
        	 * Check reasonCodes is not empty
        	 * and status is 'H'
        	 * */
        	if((reasonCodes != null || reasonCodes.trim().length()>0) && ("H".equalsIgnoreCase(status)))
        	{
        		/**
        		 * Split the multiple reason codes
        		 * to get individual reason code.
        		 * */
        		String[] reasonCodeArr=reasonCodes.split(",");
        		for(String resCode:reasonCodeArr)
        		{
        			/**
        			 * For each resCode
        			 * check 'UDF_STR2'='Y'
        			 * from table 'GENCODES'
        			 * */
        			sql2="SELECT COUNT(*) AS CNT FROM GENCODES WHERE FLD_VALUE=? AND MOD_NAME=? AND UDF_STR2='Y' AND FLD_NAME='REAS_CODE'";
        			pstmt2 = conn.prepareStatement(sql2);
        			pstmt2.setString(1, resCode.trim());
        			/* START >> Commented by vinay c 15/01/2020
        			pstmt2.setString(2, "W_SUPPLIER_BILL".trim());
        			End */
        			/* START >> Added by vinay c 15/01/2020 */
        			pstmt2.setString(2, "W_MARKETING_BILL".trim());
        			/* End */
        	        rs2 = pstmt2.executeQuery();
        	        if(rs2.next())
        	        {
        	        	cnt=rs2.getInt("CNT");
        	        }
        	        pstmt2.close();
        	        rs2.close();
        	        pstmt2=null;
        	        rs2=null;
        	        
        	        System.out.println("@V@ Reason Code 'Y' count :- ["+cnt+"]");
        	        
        	        if(cnt>0)
        	        {
        	        	/**
        	        	 * Check in table 'PAY_3WAY_STAT'
        	        	 * the record is exist for same
        	        	 * resCode, suppCode, porderNo, billNo
        	        	 * */
        	        	sql3="SELECT COUNT(*) AS CNT FROM PAY_3WAY_STAT WHERE PURC_ORDER=? AND REAS_CODE=?";
	        			pstmt3 = conn.prepareStatement(sql3);		        			
	        			pstmt3.setString(1, porderNo);		        			
	        			pstmt3.setString(2, resCode);		        			
	        	        rs3 = pstmt3.executeQuery();
	        	        if(rs3.next())
	        	        {
	        	        	cnt1=rs3.getInt("CNT");
	        	        }
	        	        pstmt3.close();
	        	        rs3.close();
	        	        pstmt3=null;
	        	        rs3=null;
	        	        
	        	        System.out.println("@V@ Record exist for Purchase Order :- ["+porderNo+"] Reason Code :- ["+resCode+"] Count :- ["+cnt1+"]");
	        	        
	        	        if(cnt1<=0)
	        	        {
	        	        	/**
	        	        	 * Insert record in
	        	        	 * table 'PAY_3WAY_STAT'
	        	        	 * */
	        	        	retString=insertPayThreeWayStat(suppCode,porderNo,billNo,resCode,voucherNo,billDate,xtraParams,conn);
	        	        	System.out.println("Return After Insert :- ["+retString+"]");
	        	        	if (retString.indexOf("Success") > -1)
	    					{
	    						String[] arrayForTranId = retString.split("<TranID>");
	    						int endIndex = arrayForTranId[1].indexOf("</TranID>");
	    						String tranIdForDesp = arrayForTranId[1].substring(0,endIndex);
	    						System.out.println("@V@ Tran id Generated is :- :- "+tranIdForDesp);
	    						retString="";
	    					}
	        	        	else
	        	        	{
	        	        		throw new Exception(retString);
	        	        	}
	        	        }
        	        }
        		}
        	}
        	/**
			 * VALLABH KADAM 
			 * change on [30/JUN/15]
			 * Add from SupplierBillSubmitPos.java
			 * 
			 *   END
			 * */
			//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] Start
        	// if ( checkNull( sundryCode ).length() > 0 && checkNull( sundryType ).length() > 0 )//commented by parikshit on 15/02/16 [added if condition with checked doc_type not 'D' - F15KSUN007 ]
        /*	if ( checkNull( sundryCode ).length() > 0 && checkNull( sundryType ).length() > 0 && !(checkNull(docType).equalsIgnoreCase("D")))
        	{
				E12EMAILComp e12EmailComp = new E12EMAILComp();	
        		String xtraParamsvalue = "loginCode="+userId+"~~loginEmpCode"+userId;
        		e12EmailComp.sendEMAIL( xmlStringAll , "SSC_MAIL_FORMAT", xtraParamsvalue );
        	}*/
			//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] End
        	
        	//added by Adnan on[10/08/20] Update approve
        	String statusU="";
        	sql="select status from supplier_bill where tran_id=? ";
        	pstmt=conn.prepareStatement(sql);
        	pstmt.setString(1, tranId);
        	rs=pstmt.executeQuery();
        	if(rs.next()) {
        		statusU=rs.getString("status");
        	}
        	pstmt.close();
        	pstmt=null;
        	rs.close();
        	rs=null;
        	if("S".equalsIgnoreCase(statusU)) {
        	sql="update supplier_bill set approval_status3=? where tran_id=?";
        	pstmt=conn.prepareStatement(sql);
        	pstmt.setString(1, "O");
        	pstmt.setString(2, tranId);
        	int cntt=pstmt.executeUpdate();
        	System.out.println("cntt.. "+cntt);
        	
        	}
        	
        	
        	
        	
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
			retString = e.getMessage();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			retString = e.getMessage();
			throw new ITMException(e);
		}
		System.out.println("retString = ["+ retString +"]");
		
		return retString;
	}
	
	/**
	 * The method is use to insert record in table 'PAY_3WAY_STAT'
	 * @param suppCode as supplier code [String]
	 * @param porderNo as purchase order no [String]
	 * @param billNo as bill no [String]
	 * @param resCode reason code [String]
	 * @param voucherNo as voucher no [String]
	 * @param billDate bill date [Date]
	 * @param modName as module name [String]
	 * @param xtraParams as extra parameters [String]
	 * @param conn connection object [Object]
	 * @return String as insert [success/fail]
	 * */
	private String insertPayThreeWayStat(String suppCode, String porderNo, String billNo, String resCode, String voucherNo, 
			Timestamp billDate, String xtraParams, Connection conn)throws ITMException
    {		
	    // TODO Auto-generated method stub
		String retString="";
		String sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String rcpTranId="",siteCode="",loginSiteCode="",genDescr="",genShDescr="",roleCode="";
		Calendar currentDate = Calendar.getInstance();
		boolean isdetFlag =  false;
		String chgUser = null,chgTerm = null;		
		
		Timestamp sysDate = null;
		
		try
		{		
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			System.out.println("@V@ Now the date is :=>  " + sysDateStr);
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(),
					genericUtility.getDBDateFormat())+ " 00:00:00.0");
			
			System.out.println("@V@ TRAN DATE :-"+sysDate);
			
			//Select more voucher details
			if(voucherNo!=null || voucherNo.trim().length()>0)
			{
			sql ="SELECT TRAN_ID__RCP,SITE_CODE FROM VOUCHER WHERE TRAN_ID=?";  
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,voucherNo);		
			rs = pstmt.executeQuery();
			if (rs.next())
				{
				rcpTranId=rs.getString("tran_id__rcp");
				siteCode=rs.getString("site_code");
				}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			}
			else
			{
				voucherNo="";
				rcpTranId="";
				siteCode="";
			}
			
			//Select Gencodes details			  
			sql="SELECT DESCR,SH_DESCR, UDF_STR1,FLD_VALUE FROM GENCODES WHERE FLD_VALUE=? AND MOD_NAME=? AND FLD_NAME='REAS_CODE'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,resCode.trim());
			/* START >> Commented by vinay c 15/01/2020
			pstmt.setString(2,"W_SUPPLIER_BILL".trim());
			*/		
			/* START >> Commented by vinay c 15/01/2020 */
			pstmt.setString(2,"W_MARKETING_BILL".trim());
			/* End */	
			rs = pstmt.executeQuery();
			if (rs.next())
				{
				genDescr=checkNull(rs.getString("DESCR"));
				genShDescr=checkNull(rs.getString("SH_DESCR"));
				roleCode=checkNull(rs.getString("UDF_STR1"));
				resCode=checkNull(rs.getString("FLD_VALUE"));
				}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			
			isdetFlag =  false;
			StringBuffer xmlBuff = null;
			String xmlString = "";
			xmlBuff = new StringBuffer();
					
			xmlBuff.append("<?xml version='1.0' encoding='UTF-8'?>\n");
			xmlBuff.append("<DocumentRoot>");
			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>").append("Group0 description").append("</description>");
			xmlBuff.append("<Header0>");
			
			xmlBuff.append("<objName><![CDATA[").append("supp_bill_mismatch").append("]]></objName>");  
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			
			xmlBuff.append("<description>").append("Header0 members").append("</description>");
			xmlBuff.append("<Detail1 objContext=\"1\" objName=\"supp_bill_mismatch\" domID=\"\" dbID=\"\">");
			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
			      
			xmlBuff.append("<tran_id/>");
			xmlBuff.append("<tran_date><![CDATA["+ sdf.format(sysDate) +"]]></tran_date>");	
			xmlBuff.append("<site_code><![CDATA["+ siteCode +"]]></site_code>");
			xmlBuff.append("<supp_code><![CDATA["+ suppCode +"]]></supp_code>");
			xmlBuff.append("<purc_order><![CDATA["+ porderNo +"]]></purc_order>");
			xmlBuff.append("<tran_id__rcp><![CDATA["+ rcpTranId +"]]></tran_id__rcp>");
			xmlBuff.append("<tran_id__vch><![CDATA["+ voucherNo +"]]></tran_id__vch>");
			xmlBuff.append("<bill_no><![CDATA["+ billNo +"]]></bill_no>");
			xmlBuff.append("<bill_date><![CDATA["+ sdf.format(billDate) +"]]></bill_date>");
//			xmlBuff.append("<bill_date><![CDATA["+ sdf.format(billDateStr) +"]]></bill_date>");
			xmlBuff.append("<reas_code><![CDATA["+ resCode +"]]></reas_code>");
			xmlBuff.append("<remarks><![CDATA["+ genDescr +"]]></remarks>");
			xmlBuff.append("<role_code><![CDATA["+roleCode+"]]></role_code>");
			xmlBuff.append("<status><![CDATA["+ "2" +"]]></status>");
			xmlBuff.append("<status_date><![CDATA["+ sdf.format(sysDate) +"]]></status_date>");
			xmlBuff.append("<status_remarks><![CDATA["+ genDescr+"]]></status_remarks>");
			xmlBuff.append("<add_date><![CDATA["+ sdf.format(sysDate) +"]]></add_date>");
			xmlBuff.append("<add_user><![CDATA["+chgUser+"]]></add_user>");
			xmlBuff.append("<add_term><![CDATA["+chgTerm+"]]></add_term>");
			xmlBuff.append("<chg_date><![CDATA["+ sdf.format(sysDate) +"]]></chg_date>");
			xmlBuff.append("<chg_user><![CDATA["+chgUser+"]]></chg_user>");
			xmlBuff.append("<chg_term><![CDATA["+chgTerm+"]]></chg_term>");
			xmlBuff.append("</Detail1>");
			
			if(xmlBuff!=null)
			{
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("@V@: xmlString:"+xmlBuff.toString());
			}
			System.out.println("@V@ just before savdata()");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
            if(xmlString != null && xmlString.trim().length()>0)
            {
            	retString = saveData(loginSiteCode,xmlString,conn);
            }
            
            
		}
		catch(SQLException sqlE){
			sqlE.printStackTrace();
			throw new ITMException(sqlE);
		}
		catch(Exception e){
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		
	    return retString;
    }
	
	/**
	 * The method save data according respective object name
	 * @param siteCode as site code [String]
	 * @param xmlString as XML [String]
	 * @param conn as connection object [Object]
	 * @return String
	 * @throws ITMException
	 * */
	private String saveData(String siteCode,String xmlString, Connection conn) throws ITMException
	{
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString,true,conn);
		}
		catch(ITMException itme)
		{
			throw itme;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	/**
	 * Get Value from Dom
	 * @param dom
	 * @param attribute
	 * @param objContext
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		
		return objName;
	}
	
	/**
	 * checking null value
	 * @param input
	 * @return
	 */
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	//Added By Prasad on 27/06/15 [for updating Voucher Details] START
	/**
	 * for Updating Voucher Details
	 * @param dom
	 * @param userId
	 * @param termId
	 * @param conn
	 * @return
	 * @throws ITMException
	 */
	private String updateVoucherDetails( Document dom, String userId, String termId, Connection conn ) throws ITMException
	{
		String updateStatus = "Error";
		String sql1=null,sql2=null;
		String purcRecptNo="";
		//Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs1=null;
		
		try 
		{
			//Commented by Prasad on 09/07/15 [removing new connection object] START
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);*/
			//Commented by Prasad on 09/07/15 [removing new connection object] END
			
			String voucherNo = checkNull(genericUtility.getColumnValue("voucher_no",dom, "1"));
			String billVouchNo = checkNull(genericUtility.getColumnValue("bill_voucher_no",dom, "1"));
			String billNo = checkNull(genericUtility.getColumnValue("bill_no",dom, "1"));
			String billDt = checkNull(genericUtility.getColumnValue("bill_date",dom, "1"));
			String billRcvdDt = checkNull(genericUtility.getColumnValue("bill_rcvd_dt",dom, "1"));
			
			if ( voucherNo.equals( "" ) && ! billVouchNo.equals( "" ) )
			{
				voucherNo = billVouchNo;
				billNo = "";
				billDt = "";
				billRcvdDt = "";
			}
			
			if ( ! checkNull(voucherNo).equals("") )
			{
				String sql = "UPDATE VOUCHER SET BILL_NO = ?, BILL_DATE = ?, BILL_RECD_DATE = ?, CHG_DATE = SYSDATE, CHG_USER = ?, CHG_TERM = ? "
						+ " WHERE TRAN_ID = ? AND CONFIRMED = 'N' ";
				
				pstmt = conn.prepareStatement(sql);
				
				pstmt.setString(1, billNo);
				if ( ! billDt.equals("") )
				{
					billDt = checkNull(genericUtility.getValidDateTimeString(
							billDt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
					
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(billDt));
				}
				else
				{
					pstmt.setString(2, "");
				}
				if ( ! billRcvdDt.equals("") )
				{
					billRcvdDt = checkNull(genericUtility.getValidDateTimeString(
							billRcvdDt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(billRcvdDt));
				}
				else
				{
					pstmt.setString(3, "");
				}
				
				pstmt.setString(4, userId);
				pstmt.setString(5, termId);
				pstmt.setString(6, voucherNo);
				
				int updateCnt = pstmt.executeUpdate();
				System.out.println("updateCnt "+ updateCnt);
				
				if( updateCnt != 0 )
				{
					updateStatus = "success";
					//Commented by Prasad on 09/07/15 [removing new connection object]
					//conn.commit();
				}
			}
			/**
			 * Added by VALLABH KADAM
			 * [18/SEP/15]
			 * */
			String challanNo=checkNull(genericUtility.getColumnValue("challan_no",dom, "1"));//Get ChallanNo from dom
			String purcOrdNo=checkNull(genericUtility.getColumnValue("porder_no",dom, "1"));//Get PurchaseOrdNo from dom
			String suppBillTranId = checkNull(genericUtility.getColumnValue("tran_id",dom, "1"));// Get Supplier bill TranId
			
			System.out.println("@V@ Challan no :- ["+challanNo+"]");
			System.out.println("@V@ Purchase Ord No :- ["+purcOrdNo+"]");
			System.out.println("@V@ Supplier Bill Tran Id :- ["+suppBillTranId+"]");
			
			/**
			 * Find Purchase Receipt no
			 * from table PORCP
			 * */
			sql1="select TRAN_ID from PORCP where DC_NO=? and PURC_ORDER=?";
			pstmt1 = conn.prepareStatement(sql1);
			pstmt1.setString(1,challanNo);		
			pstmt1.setString(2,purcOrdNo);		
			rs1 = pstmt1.executeQuery();
			if (rs1.next())
				{
					purcRecptNo=checkNull(rs1.getString("TRAN_ID"));
				}
			rs1.close();
			rs1=null;
			pstmt1.close();
			pstmt1=null;
			
			System.out.println("@V@ Purchase receipt no :- ["+purcRecptNo+"]");
			/**
			 * If Purchase Receipt
			 * is NOT NULL
			 * Update the Purchase Receipt 
			 * in SUPPLIER_BILL table  
			 * */
			if(purcRecptNo!=null && purcRecptNo.trim().length()>0)
			{
				sql2 = "UPDATE SUPPLIER_BILL SET PRCP_NO=? WHERE TRAN_ID=?";				
				pstmt2 = conn.prepareStatement(sql2);				
				pstmt2.setString(1, purcRecptNo);							
				pstmt2.setString(2, suppBillTranId);							
				int updateCnt = pstmt2.executeUpdate();
				
				pstmt2.close();
				pstmt2=null;
				
				System.out.println("@V@ UpdateCnt after receipt update:- ["+ updateCnt+"]");
			}
			/**
			 * VALLABH KADAM
			 * [18/SEP/15] END
			 * */
		} 
		catch (SQLException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				//Commented by Prasad on 09/07/15 [removing new connection object] START
				/*if ( conn != null )
				{
					conn.close();
					conn = null;
				}*/
				//Commented by Prasad on 09/07/15 [removing new connection object] END
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				throw new ITMException(e);
			}
		}
		
		return updateStatus;
	}
	//Added By Prasad on 27/06/15 [for updating Voucher Details] END
}
