package ibase.webitm.ejb.mkt;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@Stateless
public class MarketingBillEditPreSave extends ValidatorEJB
		implements MarketingBillEditPreSaveLocal,MarketingBillEditPreSaveRemote  {
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

	public String preSave() throws RemoteException, ITMException {
		return "";
	}

	public String preSave(String domString, String editFlag, String xtraParams, Connection conn)
			throws RemoteException, ITMException {
		String retString = "";
		try {

			System.out.println("domString ReceiptGenWizPreSaveEJB [" + domString + "]");

			retString = callWfValData(domString, xtraParams, conn);

		} catch (Exception e) {
			System.out.println("Exception :WsfaDSRWizPreSaveEJB : :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("Return string :" + retString);
		return retString;
	}

	private String callWfValData(String domString, String xtraParams, Connection conn) throws ITMException {

		String errString = "";
		String udf_str5 = "", remarks1 = "", status = "", errCode = "", loginCode = "";
		PreparedStatement ps=null;
		ResultSet rs=null;
		ArrayList<String> udfStr1List=null;
		String sql="";
		String acctcode="",cctrcode="";
		try {

			System.out.println("domString ::::: " + domString);
			Document dom1 = parseString(domString);
			System.out.println("dom1.....  " + dom1);
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			udf_str5 = genericUtility.getColumnValue("udf_str5", dom1);
			status = genericUtility.getColumnValue("status", dom1);
			acctcode = checkNull(genericUtility.getColumnValue("acct_code", dom1));
			cctrcode = checkNull(genericUtility.getColumnValue("cctr_code", dom1));

			udfStr1List= new ArrayList<String>();
			sql="select udf_str3 from gencodes where fld_value=? and sh_descr=?";
			ps=conn.prepareStatement(sql);
			ps.setString(1, acctcode);
			ps.setString(2, cctrcode);
			rs=ps.executeQuery();
			while(rs.next()) {
				udfStr1List.add(checkNull(rs.getString("udf_str3")));
			}
			
			
		/*	if (udf_str5 == null || udf_str5.trim().length() == 0) {
				errCode = "VTEMPA";
				errString = itmDBAccess.getErrorString("udf_str5", errCode, loginCode, "", conn);
				return errString;

			}
			else {
				if(!udfStr1List.contains(udf_str5)) {
					errCode = "VTEMPA1";
					errString = itmDBAccess.getErrorString("udf_str5", errCode, loginCode, "", conn);
					return errString;
				}
			}
			if (status == null || status.trim().length() == 0) {
				errCode = "VTSTS";
				errString = itmDBAccess.getErrorString("status", errCode, loginCode, "", conn);
				return errString;

			}*/

			rs.close();
			rs=null;
			ps.close();
			ps=null;
			
		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally {
			if(udfStr1List!=null) {
				udfStr1List.clear();
			}
		}

		return errString;
	}
	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		return input.trim();
	}

}
