package ibase.webitm.ejb.mkt;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;

/**
 * Session Bean implementation class MarketingBillEJB
 */
@Stateless
public class MarketingBillEJB extends ValidatorEJB implements MarketingBillEJBLocal,MarketingBillEJBRemote 
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

    /**
     * Default constructor. 
     */
    public MarketingBillEJB() {
        // TODO Auto-generated constructor stub
    	if(genericUtility == null) 
    	{
    		genericUtility = new E12GenericUtility();
    	}
    }

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;	
		String errString = "";
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : MarketingBillEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return (errString);
	}

	@SuppressWarnings("resource")
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) 	throws RemoteException, ITMException 
	{
		System.out.println("in wfValData method.....");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		Node parentNode = null;
		Node childNode = null;
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String chkStr = "";
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		int cnts=0;
		String query="";
		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList<String>();
		 
		ResultSet rs = null;
		try 
		{   
			FinCommon finCommon= new FinCommon();
			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");

			new SimpleDateFormat(genericUtility.getApplDateFormat());
			 System.out.println("editFlag==>"+editFlag);
			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			
			switch (currentFormNo) {
			case 1:

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if (childNode.getFirstChild() != null) 
					{
						childNode.getFirstChild().getNodeValue();
					}
					
					 if (childNodeName.equalsIgnoreCase("bill_rcvd_dt")) 
					{
						 boolean isToDateValid = false,isToDateIsFutureDate =true;
						 String billRcvdDt = genericUtility.getColumnValue("bill_rcvd_dt",dom);
						if (childNode.getFirstChild() == null) 
						{
							//errString = getErrorString("bill_rcvd_dt","BILLRCPTDT",userId);
							//break;
							errList.add( "BILLRCPTDT" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else 
						{	
							if(!isToDateValid) 
							{	
								isToDateValid = isValidDate(billRcvdDt);
								
								if(isToDateValid) 
								{
								isToDateIsFutureDate = isFutureDate(billRcvdDt);
								}
							}
							if (isToDateValid && isToDateIsFutureDate)  
							{
								//errString = getErrorString("bill_date","BILLDT",userId);
								//break;
								errList.add( "BILLRFURDT" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					
				//added validation by adnan for acct code cctr code and proj code on 12/08/20
				/*	else if (childNodeName.equalsIgnoreCase("acct_code")) 
					{  
						String acctcode=genericUtility.getColumnValue("acct_code", dom);
						System.out.println("acctcode... "+acctcode);
						query = "select count(*)  from accounts where acct_code =?";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1,acctcode);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							cnts = rs.getInt(1);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						
						if(cnts == 0)
						{
					    	errCode = "VMACCT1";
					    	errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						
							
				
						
					}*/
					
					/*else if (childNodeName.equalsIgnoreCase("cctr_code")) 
					{  
						String cctrcode=genericUtility.getColumnValue("cctr_code", dom);
						String acctcode=genericUtility.getColumnValue("acct_code", dom);
						System.out.println("cctr_code... "+cctrcode);
						System.out.println("acct_code... "+acctcode);
						
						if(cctrcode==null || cctrcode.trim().length()==0) {
							errCode = "VMCCTR1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else {
						errCode =finCommon.isCctrCode(acctcode, cctrcode, "", conn);
						if(errCode!=null &&  errCode.trim().length() > 0)
						{
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						
						}
					
						
				
						
					}*/
					
					
					else if (childNodeName.equalsIgnoreCase("proj_code") && editFlag.trim().equalsIgnoreCase("E")) 
					{  
						String projcode=genericUtility.getColumnValue("proj_code", dom);
						System.out.println("proj_code... "+projcode);
						String statusCheck=genericUtility.getColumnValue("status", dom);
						
						if(statusCheck!=null && statusCheck.trim().equalsIgnoreCase("R")) {
							if(projcode==null || projcode.trim().length() == 0) {
								errCode = "VMPROJREJ";
						    	errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							
						}
						if(projcode!=null && projcode.trim().length() > 0) {
						query = "select count(*)  from project where proj_code =?";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1,projcode);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							cnts = rs.getInt(1);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						
						if(cnts == 0)
						{
					    	errCode = "VMPROJ1";
					    	errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						 
						}
							
				
						
					}
					 
					else if (childNodeName.equalsIgnoreCase("bill_date")) 
					{
						boolean isToDateValid = false,isToDateIsFutureDate =true;
						String billDt = genericUtility.getColumnValue("bill_date",dom);
						if (childNode.getFirstChild() == null) 
						{
							//errString = getErrorString("bill_rcvd_dt","BILLRCPTDT",userId);
							//break;
							errList.add( "BILLDT" );
							errFields.add( childNodeName.toLowerCase() );
						}						
						else 
						{	
							if(!isToDateValid) 
							{	
								isToDateValid = isValidDate(billDt);
								
								if(isToDateValid) 
								{
								isToDateIsFutureDate = isFutureDate(billDt);
								}
							}
							if (isToDateValid && isToDateIsFutureDate)  
							{
								//errString = getErrorString("bill_date","BILLDT",userId);
								//break;
								errList.add( "BILLFURDT" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
						

					
					
					
					
					
					
					//pravin 26.04.22
					
					 
				/*	else if (childNodeName.equalsIgnoreCase("udf_str1")) 
					{  
						String udfStr1=genericUtility.getColumnValue("udf_str1", dom);
						System.out.println("udfStr1... "+udfStr1);
						
						if(udfStr1==null || udfStr1.trim().length()==0) {
							errCode = "VMUDF1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
				
						
					}*/
					
					//Added by Prasad on 25/06/15 [for validation of Reason Code] END
				}
				//Added by umakanta 30/DEC/2015 Start
				int errListSize = errList.size();
				int cnt =0;
				String errFldName = null;
				if ( errList != null && errListSize > 0 )
				{
					for (cnt = 0; cnt < errListSize; cnt++ )
					{
						errCode = (String)errList.get(cnt);
						errFldName = (String)errFields.get(cnt);
						System.out.println("errCode .........."+errCode);
						//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
						//System.out.println("errMsg .........."+errMsg);
						errString = getErrorString( errFldName, errCode, userId );
						errorType =  errorType( conn , errCode );
						if ( errString.length() > 0)
						{
							String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
							bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
							bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."+errStringXml);
							errString = "";
						}
						if ( errorType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;

					errStringXml.append("</Errors></Root>\r\n");
				}
				else
				{
					errStringXml = new StringBuffer( "" );
				}
				errString = errStringXml.toString();
				//Added by umakanta 30/DEC/2015 End
				//break;
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception ::" + e);
			e.printStackTrace();
			errString = e.getMessage();
		} 
		finally 
		{
			try
			{
				if (conn != null) 
				{
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		System.out.println("ErrString ::" + errString);
		return errString;
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, 	String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :MarketingBillEJB:itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("returning from MarketingBillEJB itemChanged");
		
		return (valueXmlString);
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		PreparedStatement pStmt = null;
		ResultSet resultSet = null;
		String sql = "";
		String columnValue = "";
		String returnValue = "";
		Connection connectionObject = null;
		Statement statement;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		
		try
		{
			connectionObject = getConnection(); 
		    statement = connectionObject.createStatement();
		    
		    Date date = new Date();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String newDate = simpleDateFormat.format(date) ; 
            
    		if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
    		
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("itemchanged dom....");
			System.out.println("current form no: " + currentFormNo);
			String loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			System.out.println("loginSiteCode==>"+loginSiteCode);
			currentColumn = checkNull( currentColumn );
			switch (currentFormNo)
			{
			case 1:
				System.out.println("case");
				valueXmlString.append("<Detail1>\r\n");

				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					String refser="M-BILL";
					valueXmlString.append("<status>").append("<![CDATA[O]]>").append("</status>\r\n");
					//Added By Prasad on 24/06/15 [for set description of status]
					valueXmlString.append("<bill_status>").append("<![CDATA[Accepted]]>").append("</bill_status>\r\n");
					valueXmlString.append("<reas_codes protect='1'>").append("<![CDATA[]]>").append("</reas_codes>\r\n");
					valueXmlString.append("<doc_type>").append("<![CDATA[O]]>").append("</doc_type>\r\n");
					valueXmlString.append("<tran_date>").append("<![CDATA[" + newDate + "]]>").append("</tran_date>");
					//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] 
					valueXmlString.append("<bill_type>").append("<![CDATA[1]]>").append("</bill_type>\r\n");
					//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail].
					valueXmlString.append("<doc_type_descr>").append("<![CDATA[Original]]>").append("</doc_type_descr>\r\n");
					//Added By Amit Shrivastava on 03/02/20 for add ref ser on itm default [Start]
					valueXmlString.append("<ref_ser protect='1'>").append("<![CDATA["+ refser +"]]>").append("</ref_ser>\r\n");
					//valueXmlString.append("<ref_ser>").append("<![CDATA[M-BILL]]>").append("</ref_ser>\r\n");
					//Added By Amit Shrivastava on 03/02/20 for add ref ser on itm default [End]
					valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
				}

				//Added By Prasad on 24/06/15 [for setting default values when EDIT transaction] START
				if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					System.out.println("Inside currentColumn = "+currentColumn);
					System.out.println("Inside dom = "+dom.toString());
					System.out.println("Inside dom = "+genericUtility.serializeDom(dom));
					System.out.println("Inside dom1 = "+dom1.toString());
					System.out.println("Inside dom1 = "+genericUtility.serializeDom(dom1));
					System.out.println("Inside dom2 = "+dom2.toString());
					System.out.println("Inside dom2 = "+genericUtility.serializeDom(dom2));
					String sundryType = checkNull( genericUtility.getColumnValue("sundry_type", dom) );
					System.out.println("Inside sundryType = "+sundryType);
					String sundryCode = checkNull( genericUtility.getColumnValue("sundry_code", dom) );
					System.out.println("Inside sundryCode = "+sundryCode);
					
					

					if ( "S".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select supp.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.email_addr," 
								+" nvl(fdf_reg_no('S', supp.supp_code, 'L' ),'NA') as tax_reg,supp.pan_no  "
								+" from supplier supp LEFT OUTER JOIN state state ON state.state_code = supp.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = supp.count_code WHERE supp.supp_code = ? ";
					}
					else if ( "E".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select emp.emp_code, emp.emp_fname||''||emp.emp_mname||''||emp.emp_lname, emp.cur_city, state.descr, country.descr, emp.cur_pin, "
								+" emp.email_id_off, nvl(fdf_reg_no('E', emp.emp_code, 'P' ),'NA') as tax_reg,emp.it_no  " 
								+" from employee emp LEFT OUTER JOIN state state ON state.state_code = emp.cur_state " 
								+" LEFT OUTER JOIN country country ON country.count_code = state.count_code WHERE emp.emp_code = ? ";			
					}
					else if ( "R".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select strgcust.sc_code, strgcust.first_name||''||strgcust.middle_name||''||strgcust.last_name, strgcust.city, "
								+" state.descr,country.descr, strgcust.pin, strgcust.email_addr, nvl(fdf_reg_no('R', strgcust.sc_code, 'P' ),'NA')  as tax_reg,strgcust.pan_no "
								+" from strg_customer strgcust  LEFT OUTER JOIN state state ON state.state_code = strgcust.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = strgcust.count_code WHERE strgcust.sc_code = ? ";
					}
					
					if ( checkNull( sql ).length() > 0 )
					{
						pStmt = connectionObject.prepareStatement( sql );
						pStmt.setString( 1, sundryCode );
						resultSet = pStmt.executeQuery();
						if (resultSet.next())
						{
							valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(9) +"]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</email_addr>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA["+sundryType+"]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA["+ sundryCode +"]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
						}
						else
						{
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
						}
						resultSet.close();
						resultSet = null;
						pStmt.close();
						pStmt = null;
					}
					
					
					
					
					if ( editFlag.equalsIgnoreCase("E") )
					{
						String voucherNo = checkNull( genericUtility.getColumnValue("voucher_no", dom) );
						String voucherStatus = getVoucherStatus(connectionObject, voucherNo);
						String billType = genericUtility.getColumnValue( "bill_type",dom );
						if ( voucherStatus.equalsIgnoreCase( "Y" ) )
						{
							String prcpNo = checkNull( genericUtility.getColumnValue("prcp_no", dom) );

							valueXmlString.append("<prcp_no protect='1'>").append("<![CDATA["+ prcpNo +"]]>").append("</prcp_no>\r\n");
							valueXmlString.append("<voucher_no protect='1'>").append("<![CDATA["+ voucherNo +"]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
						}
						String status = checkNull( genericUtility.getColumnValue("status", dom) );
						//Changed by Prasad on 02/07/15 [for reason code editable or not] START
						String reasCode = checkNull( genericUtility.getColumnValue("reas_codes", dom) );
						if ( status != null && status.equalsIgnoreCase("H") )
						{
							//valueXmlString.append("<status protect='1'>").append("<![CDATA["+ status +"]]>").append("</status>\r\n");
							valueXmlString.append("<reas_codes protect='0'>").append("<![CDATA["+ reasCode +"]]>").append("</reas_codes>\r\n");
						}
						
						
						
						else
						{
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
							valueXmlString.append("<reas_codes protect='1'>").append("<![CDATA["+ reasCode +"]]>").append("</reas_codes>\r\n");
						}
						
						//added by adnan on 13/08/20 for status S
						
						/*
						 * if(status!=null && status.equalsIgnoreCase("S") ) {
						 * 
						 * valueXmlString.append("<doc_type protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</doc_type>\r\n");
						 * valueXmlString.append("<document_ref_no protect='1'>").append("<![CDATA["+
						 * reasCode +"]]>").append("</document_ref_no>\r\n");
						 * valueXmlString.append("<acct_code protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</acct_code>\r\n");
						 * valueXmlString.append("<cctr_code protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</cctr_code>\r\n");
						 * valueXmlString.append("<proj_code protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</proj_code>\r\n");
						 * 
						 * valueXmlString.append("<remarks protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</remarks>\r\n");
						 * valueXmlString.append("<udf_str1 protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</udf_str1>\r\n");
						 * valueXmlString.append("<udf_str2 protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</udf_str2>\r\n");
						 * valueXmlString.append("<udf_str3 protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</udf_str3>\r\n");
						 * valueXmlString.append("<status protect='1'>").append("<![CDATA["+ reasCode
						 * +"]]>").append("</status>\r\n");
						 * valueXmlString.append("<reas_codes protect='1'>").append("<![CDATA["+
						 * reasCode +"]]>").append("</reas_codes>\r\n");
						 * 
						 * 
						 * 
						 * 
						 * }
						 */
						
						//end by adnan on 13/08/20 for status S
						
						
						
						
						
						
						
						
						
						
						
						
						
						
						
						
						//Changed by Prasad on 02/07/15 [for reason code editable or not] END
						valueXmlString.append("<bill_voucher_no>").append("<![CDATA[" + checkNull(voucherNo) + "]]>").append("</bill_voucher_no>");						
						if ( "2".equalsIgnoreCase( checkNull( billType ) ) )
						{
							valueXmlString.append("<prcp_no protect='1'>").append("<![CDATA[]]>").append("</prcp_no>\r\n");
							valueXmlString.append("<porder_no protect='1'>").append("<![CDATA[]]>").append("</porder_no>\r\n");
							valueXmlString.append("<document_ref_no protect='1'>").append("<![CDATA[]]>").append("</document_ref_no>\r\n");// Added by parikshit on 19/02/16 [to protect document_ref_no number - F15KSUN017] 
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
						}
						//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]Start.
						String docType = checkNull(genericUtility.getColumnValue("doc_type", dom));
						String docTypeDescr = checkNull( getDocTypeDescr( docType, connectionObject ) );
						valueXmlString.append("<doc_type_descr>").append("<![CDATA[").append( docTypeDescr ).append("]]>").append("</doc_type_descr>\r\n");
						//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]End.
						
						//Added By Amit Shrivastava on 03/02/20 [Start]
						if ( currentColumn.equalsIgnoreCase("ref_ser"))
						{
							System.out.println(" inside the imt defult Edit ref_ser>>");
							String refSer = checkNull( genericUtility.getColumnValue("ref_ser", dom) );

							valueXmlString.append("<ref_ser protect='1'>").append("<![CDATA["+ refSer +"]]>").append("</ref_ser>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
						}
						
						//Added By Amit Shrivastava on 03/02/20 [End]
					}
				}
				//Added By Prasad on 24/06/15 [for setting default values when EDIT transaction] END
				//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] Start
				if ( "bill_type".equalsIgnoreCase( currentColumn ) )
				{
					columnValue = genericUtility.getColumnValue( currentColumn, dom );
					if ( columnValue != null && !"".equalsIgnoreCase( columnValue ) )
					{
						if ( "1".equalsIgnoreCase( columnValue ) )
						{
							valueXmlString.append("<porder_no protect='0'>").append("<![CDATA[]]>").append("</porder_no>\r\n");
							valueXmlString.append("<prcp_no protect='0'>").append("<![CDATA[]]>").append("</prcp_no>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<bill_no>").append("<![CDATA[]]>").append("</bill_no>\r\n");
							valueXmlString.append("<bill_date>").append("<![CDATA[]]>").append("</bill_date>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA[]]>").append("</challan_no>\r\n");
							valueXmlString.append("<challan_date>").append("<![CDATA[]]>").append("</challan_date>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<bill_rcvd_dt>").append("<![CDATA[]]>").append("</bill_rcvd_dt>\r\n");
							valueXmlString.append("<document_ref_no protect='0'>").append("<![CDATA[]]>").append("</document_ref_no>\r\n");// Added by parikshit on 19/02/16 [to protect document_ref_no number - F15KSUN017]
							valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [for display company name - F16ASUN015]
						
						}
						else if ( "2".equalsIgnoreCase( columnValue ) )
						{
							valueXmlString.append("<porder_no protect='1'>").append("<![CDATA[]]>").append("</porder_no>\r\n");
							valueXmlString.append("<prcp_no protect='1'>").append("<![CDATA[]]>").append("</prcp_no>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<bill_no>").append("<![CDATA[]]>").append("</bill_no>\r\n");
							valueXmlString.append("<bill_date>").append("<![CDATA[]]>").append("</bill_date>\r\n");
							valueXmlString.append("<challan_no>").append("<![CDATA[]]>").append("</challan_no>\r\n");
							valueXmlString.append("<challan_date>").append("<![CDATA[]]>").append("</challan_date>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<bill_rcvd_dt>").append("<![CDATA[]]>").append("</bill_rcvd_dt>\r\n");
							valueXmlString.append("<document_ref_no protect='1'>").append("<![CDATA[]]>").append("</document_ref_no>\r\n");// Added by parikshit on 19/02/16 [to protect document_ref_no number - F15KSUN017]
							valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [for display company name - F16ASUN015]
						}
						else
						{
							System.out.println( "MarketingBillEJB::itemChanged::Bill type Value not equql to 1 and 2." );
						}
					}
					else
					{
						System.out.println( "MarketingBillEJB::itemChanged::Bill type Value is Empty." );
					}
				}
				//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] End

				//Added by parikshit on 18/FEB/2016 [ check purc_order number -F15KSUN017] start
				if ("document_ref_no".equalsIgnoreCase(currentColumn.trim()))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					if( checkNull(columnValue).length() == 0)
					{
						valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
						valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
						valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
						valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
						valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
						valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
						valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
						valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
						valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
						valueXmlString.append("<porder_no>").append("<![CDATA[]]>").append("</porder_no>\r\n");
						valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");
					}
					else
					{
						String documentRefNo = "" ;
						boolean flag = false;
						pStmt = null;
						sql = " SELECT PURC_ORDER FROM POAMD_HDR WHERE AMD_NO = ? ";
						pStmt = connectionObject.prepareStatement( sql );
						pStmt.setString( 1, columnValue );
						resultSet = pStmt.executeQuery();
						if (resultSet.next())
						{
							documentRefNo = checkNull( resultSet.getString( 1 ) );
							flag = true;
						}
						System.out.println("documentRefNo"+documentRefNo);
						resultSet.close();
						resultSet = null;
						pStmt.close();
						pStmt = null;
						
						if(flag)
						{
							valueXmlString.append( setPODetails(connectionObject , documentRefNo, dom,loginSiteCode ) );
						}
						else if(!flag)
						{
							pStmt = null;
							resultSet = null;
							sql = "SELECT COUNT(*) FROM PORDER WHERE PURC_ORDER = ? ";
							pStmt = connectionObject.prepareStatement( sql );
							pStmt.setString( 1, columnValue );
							resultSet = pStmt.executeQuery();
							if (resultSet.next())
							{
								if(resultSet.getInt(1) == 1)
								{
									valueXmlString.append( setPODetails(connectionObject, columnValue, dom ,loginSiteCode) );	
								}
							}
							resultSet.close();
							resultSet = null;
							pStmt.close();
							pStmt = null;
						}
					}
				}
				resultSet = null;
				//Added by parikshit on 18/FEB/2016 [ check purc_order number - F15KSUN017] end
				
				if (currentColumn.trim().equalsIgnoreCase("porder_no"))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);

					sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.tax_reg, supp.email_addr "
							+ " FROM porder porder, supplier supp "
							+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
							+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
							+ " WHERE porder.supp_code = supp.supp_code "
							+ " AND purc_order ='" + columnValue + "'";
					resultSet = statement.executeQuery(sql);
					if (resultSet.next())
					{
						valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
						valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
						valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
						valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
						valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
						valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</tax_reg>\r\n");
						//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] Start
						valueXmlString.append("<sundry_type>").append("<![CDATA[S]]>").append("</sundry_type>\r\n");
						valueXmlString.append("<sundry_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</sundry_code>\r\n");
						valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</email_addr>\r\n");
						//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] End
						valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
					}
					else
					{
						valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
						valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
						valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
						valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
						valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
						valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
						//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] Start
						valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
						valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
						valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
						//Added By Umakanta on 16/NOV/2015 [ F15HSUN001 ] [ for Mail to sundry for Non Po supplier bill transaction ] End
					}
					resultSet.close();
					resultSet = null;

					String bill_no = genericUtility.getColumnValue("bill_no",dom);
					String voucherNo = "";
					if ( bill_no != null && !bill_no.equals("") )
					{
						sql = "SELECT tran_id from voucher where purc_order = '" + columnValue + "' AND bill_no = '" + bill_no + "'";

						resultSet = statement.executeQuery(sql);
						//Changed by Prasad on 13/07/15 [for set Voucher No related to Purcahse Order No and Bill No] START
						/*if (resultSet.next())*/
						int chkCnt = 0;
						while (resultSet.next())
						{
							voucherNo = checkNull(resultSet.getString(1));
							chkCnt ++;
						}
						resultSet.close();
						resultSet = null;
						if ( chkCnt != 1 )
						{
							voucherNo = "";
						}
						//Changed by Prasad on 13/07/15 [for set Voucher No related to Purcahse Order No and Bill No] END
						valueXmlString.append("<voucher_no>").append("<![CDATA["+ voucherNo +"]]>").append("</voucher_no>\r\n");
					}

					if ( voucherNo.equals("") )
					{
						voucherNo = genericUtility.getColumnValue("voucher_no", dom);
					}
					System.out.println("voucherNo =========== ["+ voucherNo +"]");
					if ( voucherNo != null && !voucherNo.equals("") )
					{
						String gimNo = getGIMNo(connectionObject, columnValue, voucherNo);
						valueXmlString.append("<prcp_no>").append("<![CDATA["+ gimNo +"]]>").append("</prcp_no>\r\n");
						//Commented by Prasad on 13/07/15 [Stop retrieving GIM Details from Voucher No] START
						/*if ( ! gimNo.equals("") )
							{
								String billDocId = genericUtility.getColumnValue("bill_doc_id",dom);
								String billRcvdDt = checkNullAndTrim(genericUtility.getColumnValue("bill_rcvd_dt",dom));
								valueXmlString.append( getGIMNoDetails(connectionObject, gimNo, billDocId, billRcvdDt) );
							}*/
						//Commented by Prasad on 13/07/15 [Stop retrieving GIM Details from Voucher No] END
					}
				}

				resultSet = null;

				//Added by Prasad on 24/06/15 [for getting GRN details] START
				if (currentColumn.trim().equalsIgnoreCase("prcp_no"))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String billDocId = genericUtility.getColumnValue("bill_doc_id",dom);
					String billRcvdDt = checkNull(genericUtility.getColumnValue("bill_rcvd_dt",dom));
					String billNo = checkNull(genericUtility.getColumnValue("bill_no",dom)); //added by parikshit on 09/05/16 [taken billNo from dom]
					valueXmlString.append( getGIMNoDetails(connectionObject, columnValue, billDocId, billRcvdDt, billNo,loginSiteCode) );// changed by parikshit on 09/05/16 [passed billNo as a parameter for method]
				}

				if (currentColumn.trim().equalsIgnoreCase("status"))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					//String reasCode = genericUtility.getColumnValue("reas_codes",dom);
					//Modified by dipali on 17/sep/20 [Start]
					String reasCode = checkNull(genericUtility.getColumnValue("reas_codes",dom));
					//Modified by dipali on 17/sep/20 [End]
					if ( columnValue != null && !columnValue.equals("") )
					{
						if ( columnValue.equalsIgnoreCase("O") )
						{
							valueXmlString.append("<bill_status>").append("<![CDATA[Accepted]]>").append("</bill_status>\r\n");
							valueXmlString.append("<reas_codes protect='1'>").append("<![CDATA["+ reasCode +"]]>").append("</reas_codes>\r\n");
						}
						else if ( columnValue.equalsIgnoreCase("S") )
						{
							valueXmlString.append("<bill_status>").append("<![CDATA[Cancelled]]>").append("</bill_status>\r\n");
							valueXmlString.append("<reas_codes protect='1'>").append("<![CDATA["+ reasCode +"]]>").append("</reas_codes>\r\n");
						}
						else if ( columnValue.equalsIgnoreCase("H") )
						{
							valueXmlString.append("<bill_status>").append("<![CDATA[Hold]]>").append("</bill_status>\r\n");
							valueXmlString.append("<reas_codes protect='0'>").append("<![CDATA["+ reasCode +"]]>").append("</reas_codes>\r\n");
						}
					}
				}
				//Added by Prasad on 24/06/15 [for getting GRN details] END

				if ( "bill_no".equalsIgnoreCase( checkNull( currentColumn ) ) )
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String billType = genericUtility.getColumnValue( "bill_type",dom );
					//Added by Prasad on 22/06/15 [for getting bill_doc_id value]
					String billDocId = genericUtility.getColumnValue("bill_doc_id",dom);
					if ( "2".equalsIgnoreCase( checkNull( billType ) ) )
					{
						String varValue = "";
						String sundryType = "";
						String sundryCode = "";
						String refNo = "";
						String compnyName = "";
						int chkCnt = 0; 

						sql = "select var_value from finparm where prd_code = '999999' and var_name = 'MISC_TRAN_SER'";
						resultSet = statement.executeQuery(sql);
						if (resultSet.next())
						{
							varValue = checkNull(resultSet.getString(1));
						}
						resultSet.close();
						resultSet = null;
						pStmt = null;
						// changed by Parikshit on 17/05/16 [changed sql query to take company name] 
						//sql = "select distinct sundry_type, sundry_code,ref_no from misc_payables where bill_no = ? and INSTR(','|| ? || ',',','|| TRIM(TRAN_Ser) || ',' )>0 and misc_payables.tot_amt<>misc_payables.adj_amt";
						sql = " select distinct sundry_type, sundry_code,ref_no, misc_payables.site_code, site.descr " +
							  " from misc_payables left outer join site on site.site_code = misc_payables.site_code " +
							  " where bill_no = ? and INSTR(','|| ? || ',',','|| TRIM(TRAN_Ser) || ',' )>0 and misc_payables.tot_amt<>misc_payables.adj_amt";
						pStmt = connectionObject.prepareStatement( sql );
						pStmt.setString( 1, columnValue );
						pStmt.setString( 2, varValue);
						resultSet = pStmt.executeQuery();
						if (resultSet.next())
						{
							sundryType = checkNull( resultSet.getString( 1 ) );
							sundryCode = checkNull( resultSet.getString( 2 ) );
							refNo = checkNull( resultSet.getString( 3 ) );
							compnyName = checkNull( resultSet.getString( 5 ) ); // added by Parikshit on 17/05/16 [get company name from query]
							chkCnt++;
						}
						resultSet.close();
						resultSet = null;
						pStmt.close();
						pStmt = null;

					   if ( chkCnt == 0 )
						{
						   // changed by Parikshit on 17/05/16 [changed sql query to take company name using site table]
						   /*sql = "select sundry_type, sundry_code, tran_id from misc_voucher where bill_no = ? and confirmed = 'N' "
									+" union all select 'E', emp_code, tran_id from payr_voucher where ref_no = ? and confirmed = 'N' "
									+" union all select sundry_type, sundry_code, tran_id from drcr_inv where invoice_id = ? and confirmed = 'N'";*/
						  
						   sql = "select sundry_type, sundry_code, tran_id, misc_voucher.site_code, site.descr from misc_voucher "
									+ " left outer join site on site.site_code = misc_voucher.site_code where misc_voucher.bill_no = ? and confirmed = 'N'"
									+ " union all "
									+ " select 'E', emp_code, tran_id, payr_voucher.site_code, site.descr from payr_voucher "
									+ " left outer join site on site.site_code = payr_voucher.site_code where payr_voucher.ref_no = ? and confirmed = 'N' "
									+ " union all "
									+ " select sundry_type, sundry_code, tran_id, drcr_inv.site_code, site.descr from drcr_inv "
									+ " left outer join site on site.site_code = drcr_inv.site_code where drcr_inv.invoice_id = ? and confirmed = 'N'";
						   
							pStmt = connectionObject.prepareStatement( sql );
							pStmt.setString( 1, columnValue );
							pStmt.setString( 2, columnValue );
							pStmt.setString( 3, columnValue );
							resultSet = pStmt.executeQuery();
							if (resultSet.next())
							{
								sundryType = checkNull( resultSet.getString( 1 ) );
								sundryCode = checkNull( resultSet.getString( 2 ) );
								refNo = checkNull( resultSet.getString( 3 ) );
								compnyName = checkNull( resultSet.getString( 5 ) ); //added by Parikshit on 17/05/16 [get value of company name tag]
							}
							resultSet.close();
							resultSet = null;
							pStmt.close();
							pStmt = null;
						}
					   sql = "";
						if ( "S".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select supp.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.email_addr," 
									+" nvl(fdf_reg_no('S', supp.supp_code, 'L' ),'NA') as tax_reg "
									+" from supplier supp LEFT OUTER JOIN state state ON state.state_code = supp.state_code " 
									+" LEFT OUTER JOIN country country ON country.count_code = supp.count_code WHERE supp.supp_code = ? ";
						}
						else if ( "E".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select emp.emp_code, emp.emp_fname||''||emp.emp_mname||''||emp.emp_lname, emp.cur_city, state.descr, country.descr, emp.cur_pin, "
									+" emp.email_id_off, nvl(fdf_reg_no('E', emp.emp_code, 'P' ),'NA') as tax_reg  " 
									+" from employee emp LEFT OUTER JOIN state state ON state.state_code = emp.cur_state " 
									+" LEFT OUTER JOIN country country ON country.count_code = state.count_code WHERE emp.emp_code = ? ";			
						}
						else if ( "C".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select cust.cust_code, cust.cust_name, cust.city,  state.descr, country.descr, cust.pin, cust.email_addr, "
									+" nvl(fdf_reg_no('C', cust.cust_code, 'L' ),'NA') as tax_reg "
									+" from customer cust LEFT OUTER JOIN state state ON state.state_code = cust.state_code " 
									+" LEFT OUTER JOIN country country ON country.count_code = cust.count_code WHERE cust.cust_code =  ? ";
						}
						else if ( "P".equalsIgnoreCase( sundryType  ) )
						{
							sql = "select salp.sales_pers, salp.sp_name, salp.city, state.descr, country.descr, salp.pin, salp.email_addr, "
									+" nvl(fdf_reg_no('P', salp.sales_pers, 'P' ),'NA') as tax_reg "
									+" from sales_pers salp LEFT OUTER JOIN state state ON state.state_code = salp.state_code "
									+" LEFT OUTER JOIN country country ON country.count_code = salp.count_code WHERE salp.sales_pers = ? ";
						}
						else if ( "L".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select lparty.party_code, lparty.party_name, lparty.city, state.descr,country.descr, lparty.pin, lparty.email_addr,"
									+" nvl(fdf_reg_no('L', lparty.party_code, 'P' ),'NA') as tax_reg"
									+" from loanparty lparty LEFT OUTER JOIN state state ON state.state_code = lparty.state_code "
									+" LEFT OUTER JOIN country country ON country.count_code = lparty.count_code WHERE lparty.party_code = ? ";
						}
						else if ( "T".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select transp.tran_code, transp.tran_name, transp.city,  state.descr,country.descr, transp.pin, transp.email_addr, "
									+" nvl(fdf_reg_no('T', transp.tran_code, 'P' ),'NA') as tax_reg "
									+" from transporter transp LEFT OUTER JOIN state state ON state.state_code = transp.state_code " 
									+" LEFT OUTER JOIN country country ON country.count_code = transp.count_code WHERE transp.tran_code = ? ";
						}
						else if ( "X".equalsIgnoreCase( sundryType  ) )
						{
							sql = "select tax_authority.tauth_code, tax_authority.tauth_name, tax_authority.city, state.descr,country.descr, tax_authority.pin, " 
									+" tax_authority.email_addr,nvl(fdf_reg_no('X', tax_authority.tauth_code, 'P' ),'NA') as tax_reg " 
									+" from tax_authority tax_authority LEFT OUTER JOIN state state ON state.state_code = tax_authority.state_code  "
									+" LEFT OUTER JOIN country country ON country.count_code = tax_authority.count_code WHERE tax_authority.TAUTH_CODE = ? ";
						}
						else if ( "R".equalsIgnoreCase( sundryType  ) )
						{
							sql = " select strgcust.sc_code, strgcust.first_name||''||strgcust.middle_name||''||strgcust.last_name, strgcust.city, "
									+" state.descr,country.descr, strgcust.pin, strgcust.email_addr, nvl(fdf_reg_no('R', strgcust.sc_code, 'P' ),'NA')  as tax_reg "
									+" from strg_customer strgcust  LEFT OUTER JOIN state state ON state.state_code = strgcust.state_code " 
									+" LEFT OUTER JOIN country country ON country.count_code = strgcust.count_code WHERE strgcust.sc_code = ? ";
						}

						if ( checkNull( sql ).length() > 0 )
						{
							pStmt = connectionObject.prepareStatement( sql );
							pStmt.setString( 1, sundryCode );
							resultSet = pStmt.executeQuery();
							if (resultSet.next())
							{
								valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
								valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
								valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
								valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
								valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
								valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
								valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</email_addr>\r\n");
								valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</tax_reg>\r\n");
								valueXmlString.append("<sundry_type>").append("<![CDATA["+sundryType+"]]>").append("</sundry_type>\r\n");
								valueXmlString.append("<sundry_code>").append("<![CDATA["+ sundryCode +"]]>").append("</sundry_code>\r\n");
								valueXmlString.append("<voucher_no>").append("<![CDATA["+ refNo +"]]>").append("</voucher_no>\r\n");
								valueXmlString.append("<company_name>").append("<![CDATA["+ compnyName +"]]>").append("</company_name>\r\n"); //added by Parikshit on 17/05/16 [added company name tag]
							}
							else
							{
								valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
								valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
								valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
								valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
								valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
								valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
								valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
								valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
								valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
								valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
								valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
								valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n"); //added by Parikshit on 17/05/16 [added company name tag]
							}
							resultSet.close();
							resultSet = null;
							pStmt.close();
							pStmt = null;
						}
						//added by Parikshit on 17/05/16 [to set blank values on non matched item changed] start
						else
						{
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");
						}
						//added by Parikshit on 17/05/16 [to set blank values on non matched item changed] end
					}
					else
					{				
						String porderno = genericUtility.getColumnValue("porder_no",dom);
						int chkCnt = 0;

						if ( porderno != null && !porderno.equals("") )
						{
							sql = "SELECT tran_id from voucher where purc_order = '" + porderno + "' AND bill_no = '" + columnValue + "'";

							resultSet = statement.executeQuery(sql);
							while (resultSet.next())
							{
								returnValue = resultSet.getString(1);
								chkCnt++;
							}
							resultSet.close();
							resultSet = null;
							System.out.println("chkCnt =========== ["+ chkCnt +"]");

							if (chkCnt == 1)
							{
								valueXmlString.append("<voucher_no>").append("<![CDATA["+ returnValue +"]]>").append("</voucher_no>\r\n");

								System.out.println("set voucher no from Bill No =========== ["+ chkCnt +"]");
								//Added by Prasad on 13/08/15 [for set GIM No.] START
								if ( checkNull(returnValue).length() > 1 )
								{
									String gimNo = getGIMNo(connectionObject, porderno, returnValue);
									valueXmlString.append("<prcp_no>").append("<![CDATA["+ gimNo +"]]>").append("</prcp_no>\r\n");
								}
								//Added by Prasad on 13/08/15 [for set GIM No.] END
							}
							else
							{
								valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
								valueXmlString.append("<prcp_no>").append("<![CDATA[]]>").append("</prcp_no>\r\n");// added by parikshit on 19/02/16 [to set prcp_no no blank F15KSUN017]
							}
						}
					}
					//Added by Prasad on 22/06/15 [for getting added_on date from UNALLOCATED_ATTACH of respective doc_id] START
					if ( billDocId != null && ! billDocId.equals( "" ) )
					{
						String billRcvdDt = checkNull(genericUtility.getColumnValue("bill_rcvd_dt",dom));
						valueXmlString.append("<bill_rcvd_dt>").append("<![CDATA["+ getBillReceiptDt( connectionObject, billDocId, billRcvdDt ) +"]]>").append("</bill_rcvd_dt>\r\n");
					}
					//Added by Prasad on 22/06/15 [for getting added_on date from UNALLOCATED_ATTACH of respective doc_id] END
				}
                 //Added By Umakanta on 03/DEC/2015 [ To set beneficiary details  on itemchange of  Sundry Code ] Start
				
				if ( "sundry_code".equalsIgnoreCase( checkNull( currentColumn ) ) )
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String sundryType = "";
					String sundryCode = "";
					String refNo = "";
				    sql = "";
					sundryType = genericUtility.getColumnValue( "sundry_type", dom );
					sundryCode = genericUtility.getColumnValue( "sundry_code", dom );

					if ( "S".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select supp.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.email_addr," 
								+" nvl(fdf_reg_no('S', supp.supp_code, 'L' ),'NA') as tax_reg "
								+" from supplier supp LEFT OUTER JOIN state state ON state.state_code = supp.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = supp.count_code WHERE supp.supp_code = ? ";
					}
					else if ( "E".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select emp.emp_code, emp.emp_fname||''||emp.emp_mname||''||emp.emp_lname, emp.cur_city, state.descr, country.descr, emp.cur_pin, "
								+" emp.email_id_off, nvl(fdf_reg_no('E', emp.emp_code, 'P' ),'NA') as tax_reg  " 
								+" from employee emp LEFT OUTER JOIN state state ON state.state_code = emp.cur_state " 
								+" LEFT OUTER JOIN country country ON country.count_code = state.count_code WHERE emp.emp_code = ? ";			
					}
					else if ( "C".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select cust.cust_code, cust.cust_name, cust.city,  state.descr, country.descr, cust.pin, cust.email_addr, "
								+" nvl(fdf_reg_no('C', cust.cust_code, 'L' ),'NA') as tax_reg "
								+" from customer cust LEFT OUTER JOIN state state ON state.state_code = cust.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = cust.count_code WHERE cust.cust_code =  ? ";
					}
					else if ( "P".equalsIgnoreCase( sundryType  ) )
					{
						sql = "select salp.sales_pers, salp.sp_name, salp.city, state.descr, country.descr, salp.pin, salp.email_addr, "
								+" nvl(fdf_reg_no('P', salp.sales_pers, 'P' ),'NA') as tax_reg "
								+" from sales_pers salp LEFT OUTER JOIN state state ON state.state_code = salp.state_code "
								+" LEFT OUTER JOIN country country ON country.count_code = salp.count_code WHERE salp.sales_pers = ? ";
					}
					else if ( "L".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select lparty.party_code, lparty.party_name, lparty.city, state.descr,country.descr, lparty.pin, lparty.email_addr,"
								+" nvl(fdf_reg_no('L', lparty.party_code, 'P' ),'NA') as tax_reg"
								+" from loanparty lparty LEFT OUTER JOIN state state ON state.state_code = lparty.state_code "
								+" LEFT OUTER JOIN country country ON country.count_code = lparty.count_code WHERE lparty.party_code = ? ";
					}
					else if ( "T".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select transp.tran_code, transp.tran_name, transp.city,  state.descr,country.descr, transp.pin, transp.email_addr, "
								+" nvl(fdf_reg_no('T', transp.tran_code, 'P' ),'NA') as tax_reg "
								+" from transporter transp LEFT OUTER JOIN state state ON state.state_code = transp.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = transp.count_code WHERE transp.tran_code = ? ";
					}
					else if ( "X".equalsIgnoreCase( sundryType  ) )
					{
						sql = "select tax_authority.tauth_code, tax_authority.tauth_name, tax_authority.city, state.descr,country.descr, tax_authority.pin, " 
								+" tax_authority.email_addr,nvl(fdf_reg_no('X', tax_authority.tauth_code, 'P' ),'NA') as tax_reg " 
								+" from tax_authority tax_authority LEFT OUTER JOIN state state ON state.state_code = tax_authority.state_code  "
								+" LEFT OUTER JOIN country country ON country.count_code = tax_authority.count_code WHERE tax_authority.TAUTH_CODE = ? ";
					}
					else if ( "R".equalsIgnoreCase( sundryType  ) )
					{
						sql = " select strgcust.sc_code, strgcust.first_name||''||strgcust.middle_name||''||strgcust.last_name, strgcust.city, "
								+" state.descr,country.descr, strgcust.pin, strgcust.email_addr, nvl(fdf_reg_no('R', strgcust.sc_code, 'P' ),'NA')  as tax_reg "
								+" from strg_customer strgcust  LEFT OUTER JOIN state state ON state.state_code = strgcust.state_code " 
								+" LEFT OUTER JOIN country country ON country.count_code = strgcust.count_code WHERE strgcust.sc_code = ? ";
					}
					if ( checkNull( sql ).length() > 0 )
					{
						pStmt = connectionObject.prepareStatement( sql );
						pStmt.setString( 1, sundryCode );
						resultSet = pStmt.executeQuery();
						if (resultSet.next())
						{
							valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</email_addr>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA["+sundryType+"]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA["+ sundryCode +"]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA["+ refNo +"]]>").append("</voucher_no>\r\n");
						}
						else
						{
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
						}
						resultSet.close();
						resultSet = null;
						pStmt.close();
						pStmt = null;
					}
				}
                //Added By Umakanta on 03/DEC/2015 [ To set beneficiary details  on itemchange of  Sundry Code ] End

				resultSet = null;

				if (currentColumn.trim().equalsIgnoreCase("challan_no"))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String porderno = genericUtility.getColumnValue("porder_no",dom);
					int chkCnt = 0;

					if ( porderno != null && !porderno.equals("") )
					{
						sql = "select tran_id from voucher where bill_no "
								+ " in (select invoice_no from porcp where purc_order = '" + porderno + "' and dc_no = '" + columnValue + "')" +
								" and purc_order = '" + porderno + "'";//Added by Prasad on 16/09/15 [Check Porder No in Voucher and PORCP]

						resultSet = statement.executeQuery(sql);
						while (resultSet.next())
						{
							returnValue = resultSet.getString(1);
							chkCnt++;
						}
						resultSet.close();
						resultSet = null;

						System.out.println("chkCnt from porcp =========== ["+ chkCnt +"]");

						if (chkCnt == 0)
						{
							sql = "select tran_id from voucher where purc_order = '" + porderno + "' and bill_no = '" + columnValue + "'";

							resultSet = statement.executeQuery(sql);
							while (resultSet.next())
							{
								returnValue = resultSet.getString(1);
								chkCnt++;
							}
							resultSet.close();
							resultSet = null;
						}

						System.out.println("chkCnt from voucher =========== ["+ chkCnt +"]");

						if (chkCnt == 1)
						{
							valueXmlString.append("<voucher_no>").append("<![CDATA["+ returnValue +"]]>").append("</voucher_no>\r\n");

							System.out.println("set voucher no from Challan No =========== ["+ chkCnt +"]");
							//Added by Prasad on 13/08/15 [for set GIM No.] START
							if ( checkNull(returnValue).length() > 1 )
							{
								String gimNo = getGIMNo(connectionObject, porderno, returnValue);
								valueXmlString.append("<prcp_no>").append("<![CDATA["+ gimNo +"]]>").append("</prcp_no>\r\n");
							}
							//Added by Prasad on 13/08/15 [for set GIM No.] END
						}
						else
						{
							valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
							valueXmlString.append("<prcp_no>").append("<![CDATA[]]>").append("</prcp_no>\r\n");// added by parikshit on 19/02/16 [to set prcp_no no blank F15KSUN017]
						}
					}

					//Added by Prasad on 22/06/15 [for getting added_on date from UNALLOCATED_ATTACH of respective doc_id] START
					String billDocId = genericUtility.getColumnValue("bill_doc_id",dom);
					if ( billDocId != null && ! billDocId.equals( "" ) )
					{
						String billRcvdDt = checkNull(genericUtility.getColumnValue("bill_rcvd_dt",dom));
						valueXmlString.append("<bill_rcvd_dt>").append("<![CDATA["+ getBillReceiptDt( connectionObject, billDocId, billRcvdDt ) +"]]>").append("</bill_rcvd_dt>\r\n");
					}
					//Added by Prasad on 22/06/15 [for getting added_on date from UNALLOCATED_ATTACH of respective doc_id] END
				}

				resultSet = null;

				//if (currentColumn.trim().equalsIgnoreCase("voucher_no"))
				if ( "voucher_no".equalsIgnoreCase( currentColumn ) )
				{
					// Added by parikshit on 05/05/16 [checked condition po & non po transaction for voucher no - F16ASUN015] start
					String billType = genericUtility.getColumnValue( "bill_type",dom );
					System.out.println("billType - ["+ billType +"]");
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					if ( "2".equalsIgnoreCase( checkNull( billType ) ) )
					{
						valueXmlString.append( getNONPOCompanyDtl( columnValue , connectionObject,loginSiteCode) );//Added by parikshit on 16/MAY/2016 [ to get non-po company details -F16ASUN015]
					}
					else 
					{
						// Added by parikshit on 05/05/16 [checked condition po & non po transaction for voucher no - F16ASUN015] end
						String porderNo = "";
						String suppCode = "";
						//updated By Umakanta on 30/DEC/2015 [ F15HSUN001 ] [ To get email address of supplier ] Start
						//commented by parikshit on 05/05/16
						/*sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, "
							+ " supp.pin, supp.tax_reg, voucher.purc_order, supp.email_addr ,porder.site_descr"
							+ " FROM porder porder, voucher voucher, supplier supp "
							+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
							+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
							+ " WHERE porder.supp_code = supp.supp_code "
							+ " AND voucher.purc_order = porder.purc_order "
							+ " AND voucher.tran_id ='" + columnValue + "'";*/
						sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, "
								+ " supp.pin, supp.tax_reg, voucher.purc_order, supp.email_addr ,site.descr"
								+ " FROM porder porder LEFT OUTER JOIN site site ON porder.site_code__bill = site.site_code, voucher voucher, supplier supp "
								+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
								+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
								+ " WHERE porder.supp_code = supp.supp_code "
								+ " AND voucher.purc_order = porder.purc_order "
								+ " AND voucher.tran_id ='" + columnValue + "'";
						resultSet = statement.executeQuery(sql);
						if (resultSet.next())
						{
							suppCode = checkNull( resultSet.getString( 1 ) );
							porderNo = checkNull(resultSet.getString(8));

							valueXmlString.append("<supp_code>").append("<![CDATA["+ suppCode +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<porder_no>").append("<![CDATA["+ porderNo +"]]>").append("</porder_no>\r\n");
							//Added By Umakanta on 30/DEC/2015 [ F15HSUN001 ] [ To set sundry Type and Sundry Code On change of Voucher No field ] Start
							valueXmlString.append("<sundry_type>").append("<![CDATA[S]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA["+ suppCode +"]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString( 9 ) +"]]>").append("</email_addr>\r\n");
							//Added By Umakanta on 30/DEC/2015 [ F15HSUN001 ] [ To set sundry Type and Sundry Code On change of Voucher No field ] End
							valueXmlString.append("<document_ref_no>").append("<![CDATA["+ porderNo +"]]>").append("</document_ref_no>\r\n"); // added by parikshit on 19/02/16 [to set 'document_ref_no' F15KSUN017]
							valueXmlString.append("<company_name>").append("<![CDATA["+ resultSet.getString( 10 ) +"]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [for display company name - F16ASUN015] 
						}
						else
						{
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
							valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
							valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
							valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
							valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
							valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
							valueXmlString.append("<porder_no>").append("<![CDATA[]]>").append("</porder_no>\r\n");
							//Added By Umakanta on 30/DEC/2015 [ F15HSUN001 ] [ To set empty value in sundry Type and Sundry Code] Start
							valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
							valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
							valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
							//Added By Umakanta on 30/DEC/2015 [ F15HSUN001 ] [ To set empty value in sundry Type and Sundry Code] End
							valueXmlString.append("<document_ref_no>").append("<![CDATA[]]>").append("</document_ref_no>\r\n"); // added by parikshit on 19/02/16 [to set 'document_ref_no' F15KSUN017]
							valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [to display company name - F16ASUN015]
						}
						resultSet.close();
						resultSet = null;

						//Added By Prasad on 30/06/15 [for getting GIM details] START
						if ( checkNull(porderNo).length() == 0 )
						{
							porderNo = genericUtility.getColumnValue("porder_no", dom);
						}
						System.out.println("porder_no from dom =========== ["+ porderNo +"]");
						if ( checkNull(porderNo).length() > 0 )
						{
							String gimNo = getGIMNo(connectionObject, porderNo, columnValue);
							valueXmlString.append("<prcp_no>").append("<![CDATA["+ gimNo +"]]>").append("</prcp_no>\r\n");
							//Commented by Prasad on 13/07/15 [Stop retrieving GIM Details from Voucher No] START
							/*if ( ! gimNo.equals("") )
							{
								String billDocId = genericUtility.getColumnValue("bill_doc_id",dom);
								String billRcvdDt = checkNullAndTrim(genericUtility.getColumnValue("bill_rcvd_dt",dom));
								valueXmlString.append( getGIMNoDetails(connectionObject, gimNo, billDocId, billRcvdDt) );
							}*/
							//Commented by Prasad on 13/07/15 [Stop retrieving GIM Details from Voucher No] END
						}
						//Added By Prasad on 30/06/15 [for getting GIM details] END
					}
				}
				//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]Start.
				if( ("doc_type").equalsIgnoreCase(currentColumn.trim()))
				{
					String docType = checkNull(genericUtility.getColumnValue("doc_type", dom));
					String docTypeDescr = checkNull( getDocTypeDescr( docType, connectionObject ) );
					valueXmlString.append("<doc_type_descr>").append("<![CDATA[").append( docTypeDescr ).append("]]>").append("</doc_type_descr>\r\n");
				}
				
				if( ("udf_str2").equalsIgnoreCase(currentColumn.trim()))
				{
					String udfStr = checkNull(genericUtility.getColumnValue("udf_str2", dom));
					sql = "select descr as fin_descr from finent where fin_entity= ? ";

					pStmt = connectionObject.prepareStatement(sql);
					pStmt.setString(1, udfStr);
					resultSet = pStmt.executeQuery();
					String compName = "";
					
					System.out.println("sql = " + sql);
					if (resultSet.next()) 
					{
						compName = resultSet.getString("fin_descr");
					}
					resultSet.close();
					resultSet = null;
					pStmt.close();
					pStmt = null;
					
					valueXmlString.append("<company_name>").append("<![CDATA[").append( compName ).append("]]>").append("</company_name>\r\n");
				}
				
				//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]End.
				valueXmlString.append("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch (Exception e) 
		{
			System.out.println("Exception :MarketingBillEJB:itemChange(Document,String):"+e.getMessage()+ ":");
			valueXmlString.delete(0,valueXmlString.length());
			valueXmlString=valueXmlString.append(genericUtility.createErrorString(e));
			e.printStackTrace();
		}
		finally 
		{
			try
			{
				if (connectionObject != null) 
				{
					connectionObject.close();
				}
				connectionObject = null;
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		System.out.println("\n***** ValueXmlString :" +valueXmlString + ":*******");
		return valueXmlString.toString();
	}
	
	/**
	 * Check string is null
	 * @param input
	 * @return
	 */
	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		return input.trim();
	}
	
	//Added by Prasad on 30/06/15 [for onchange events] START
	/**
	 * get added_on from unallocated_attach table for setting Bill_Receipt_Date
	 * @param billDocId
	 * @param connectionObject
	 * @return
	 * @throws Exception
	 */
	private String getBillReceiptDt( Connection connectionObject, String billDocId, String billRcvdDt ) throws Exception
	{
		String billReceiptDt = "", addedOnDt = billRcvdDt;
		try 
		{
			Statement statement = connectionObject.createStatement();
			ResultSet resultSet = null;
			
			if ( billDocId != null && ! checkNull(billDocId).equals( "" ) )
			{
				String[] docId = billDocId.split(":");
				if ( docId[1] != null && ! checkNull(docId[1]).equals("") )
				{
					System.out.println("billDocId = ["+ docId[1] +"]");
					String sql = "SELECT ADDED_ON FROM UNALLOCATED_ATTACH WHERE DOC_ID = '" + docId[1] + "'";
					
					resultSet = statement.executeQuery(sql);
					while (resultSet.next())
					{
						billReceiptDt = resultSet.getString(1);
					}
					resultSet.close();
					resultSet = null;
					
					if ( billReceiptDt != null && ! billReceiptDt.equals("") )
					{
						addedOnDt = genericUtility.getValidDateString(billReceiptDt, 
								genericUtility.getDBDateFormat(), 
								genericUtility.getApplDateFormat());
					}
				}
			}
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("ADDED_ON =========== ["+ billReceiptDt +"]");
		
		return checkNull(addedOnDt);
	}
	
	/**
	 * get prcp_id from vouchrcp table for setting GIM No.
	 * @param connectionObject
	 * @param porderNo
	 * @param voucherNo
	 * @return
	 * @throws Exception 
	 */
	private String getGIMNo( Connection connectionObject, String porderNo, String voucherNo ) throws Exception
	{
		String gimNo = "";
		try 
		{
			Statement statement = connectionObject.createStatement();
			ResultSet resultSet = null;
			
			if ( porderNo != null && voucherNo != null && ! porderNo.equals( "" ) && ! voucherNo.equals( "" ) )
			{
				String sql = "SELECT VOUCHRCP.PRCP_ID FROM VOUCHRCP, PORCP "
						+ " WHERE VOUCHRCP.PURC_ORDER = PORCP.PURC_ORDER "
						+ " AND VOUCHRCP.PURC_ORDER = '"+ porderNo +"' "
						+ " AND VOUCHRCP.TRAN_ID = '"+ voucherNo +"' "
						+ " AND PORCP.TRAN_SER = 'P-RCP' "
						+ " GROUP BY VOUCHRCP.PRCP_ID ";
				
				resultSet = statement.executeQuery(sql);
				while (resultSet.next())
				{
					gimNo = resultSet.getString(1);
				}
				resultSet.close();
				resultSet = null;
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("gimNo =========== ["+ gimNo +"]");
		
		return checkNull(gimNo);
	}
	
	/**
	 * get prcp_id details from vouchrcp
	 * @param connectionObject
	 * @param prcpNo
	 * @param dom
	 * @return
	 * @throws Exception
	 */
	// changed by parikshit on 09/05/16 [passed billNo as a parameter for method]
	// private String getGIMNoDetails( Connection connectionObject, String prcpNo, String billDocId, String billRcvdDt ) throws Exception
	private String getGIMNoDetails( Connection connectionObject, String prcpNo, String billDocId, String billRcvdDt, String domBillNo ,String loginSiteCode) throws Exception
	{
		StringBuffer valueXmlString = new StringBuffer();
		try 
		{
			Statement statement = connectionObject.createStatement();
			ResultSet resultSet = null;
			//Changed by Prasad on 02/07/15 [get multiple voucherNo] START
			/*String sql = "SELECT INVOICE_NO, INVOICE_DATE, DC_NO, DC_DATE, "
					+ " (SELECT TRAN_ID FROM VOUCHER WHERE TRAN_ID__RCP = PORCP.TRAN_ID) VOUCHER_NO "
					+ " FROM PORCP WHERE CONFIRMED = 'Y' AND TRAN_ID = '" + prcpNo + "'";*/
			//Changed by Prasad on 13/07/15 [for getting GIM No. details] START
			/*String sql = "SELECT INVOICE_NO, INVOICE_DATE, DC_NO, DC_DATE "
					+ " FROM PORCP WHERE CONFIRMED = 'Y' AND TRAN_ID = '" + prcpNo + "'";*/
			String sql = "SELECT PORCP.INVOICE_NO, PORCP.INVOICE_DATE, PORCP.DC_NO, PORCP.DC_DATE, VOUCHER.TRAN_ID VOUCHER_NO "
					+ " FROM PORCP LEFT OUTER JOIN VOUCHER ON VOUCHER.TRAN_ID__RCP = PORCP.TRAN_ID "
					+ " WHERE PORCP.CONFIRMED = 'Y' AND PORCP.TRAN_ID = '" + prcpNo + "'";
			//Changed by Prasad on 13/07/15 [for getting GIM No. details] END
			resultSet = statement.executeQuery(sql);
			String billNo = "", challanNo = "";
			if (resultSet.next())
			{
				String invoiceDt = "", dcDt = "";
				if ( ! checkNull(resultSet.getString(2)).equals("") )
				{
					invoiceDt = checkNull( genericUtility.getValidDateString(resultSet.getString(2), 
							genericUtility.getDBDateFormat(), 
							genericUtility.getApplDateFormat()) ) ;
				}
				
				if ( ! checkNull(resultSet.getString(4)).equals("") )
				{
					dcDt = genericUtility.getValidDateString(resultSet.getString(4), 
							genericUtility.getDBDateFormat(), 
							genericUtility.getApplDateFormat());
				}
				billNo = checkNull(resultSet.getString(1));
				challanNo = checkNull(resultSet.getString(3));
				// valueXmlString.append("<bill_no>").append("<![CDATA["+ billNo +"]]>").append("</bill_no>\r\n");
				// Added by Parikshit on 09/05/16 [set bill no as per condition] start
				if(checkNull(domBillNo).length() < 1)
				{
					valueXmlString.append("<bill_no>").append("<![CDATA["+ billNo +" ]]>").append("</bill_no>\r\n");
				}
				else
				{
					valueXmlString.append("<bill_no>").append("<![CDATA["+ domBillNo +"]]>").append("</bill_no>\r\n");	
				}
				// Added by Parikshit on 09/05/16 [set bill no as per condition] end
				valueXmlString.append("<bill_date>").append("<![CDATA["+ invoiceDt +"]]>").append("</bill_date>\r\n");
				//valueXmlString.append("<challan_no>").append("<![CDATA["+ challanNo +"]]>").append("</challan_no>\r\n");
				valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
				valueXmlString.append("<challan_date>").append("<![CDATA["+ dcDt +"]]>").append("</challan_date>\r\n");
				valueXmlString.append("<voucher_no>").append("<![CDATA["+ checkNull(resultSet.getString(5)) +"]]>").append("</voucher_no>\r\n");
			}
			else
			{
				valueXmlString.append("<bill_no>").append("<![CDATA["+domBillNo+"]]>").append("</bill_no>\r\n"); //added bt parikshit on 09/05/16 [set bill no from dom]
				valueXmlString.append("<bill_date>").append("<![CDATA[]]>").append("</bill_date>\r\n");
				valueXmlString.append("<challan_no>").append("<![CDATA[]]>").append("</challan_no>\r\n");
				valueXmlString.append("<challan_date>").append("<![CDATA[]]>").append("</challan_date>\r\n");
				valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
			}
			resultSet.close();
			resultSet = null;
			
			//Changed by Prasad on 13/07/15 [Change logic fo getting Voucher No] START
			//Added by Prasad on 02/07/15 [get multiple voucherNo] START
			/*sql = "SELECT TRAN_ID FROM VOUCHER WHERE TRAN_ID__RCP = '" + prcpNo + "'";
			resultSet = statement.executeQuery(sql);
			if (resultSet.next())
			{
				valueXmlString.append("<voucher_no>").append("<![CDATA["+ checkNullAndTrim(resultSet.getString(1)) +"]]>").append("</voucher_no>\r\n");
			}
			else
			{
				valueXmlString.append("<voucher_no>").append("<![CDATA[]]>").append("</voucher_no>\r\n");
			}
			resultSet.close();
			resultSet = null;*/
			//Changed by Prasad on 02/07/15 [get multiple voucherNo] END
			//Changed by Prasad on 13/07/15 [Change logic fo getting Voucher No] END
			
			//if ( billNo != null && ! checkNullAndTrim(billNo).equals("") && billDocId != null && ! billDocId.equalsIgnoreCase("") )
			if ( billDocId != null && billDocId.trim().length() > 0 )
			{
				valueXmlString.append("<bill_rcvd_dt>").append("<![CDATA["+ getBillReceiptDt( connectionObject, billDocId, billRcvdDt ) +"]]>").append("</bill_rcvd_dt>\r\n");
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("getPRCPNoDetails =========== ["+ valueXmlString.toString() +"]");
		
		return checkNull(valueXmlString.toString());
	}
	
	/**
	 * get Voucher Confirmed Status (Y / N)
	 * @param connectionObject
	 * @param voucherNo
	 * @return
	 * @throws Exception
	 */
	private String getVoucherStatus( Connection connectionObject, String voucherNo ) throws Exception 
	{
		String status = "";
		try 
		{
			Statement statement = connectionObject.createStatement();
			ResultSet resultSet = null;
			
			if ( voucherNo != null && ! voucherNo.equals("") )
			{
				String sql = "SELECT CONFIRMED FROM VOUCHER WHERE TRAN_ID = '" + voucherNo + "'";
				resultSet = statement.executeQuery(sql);
				if (resultSet.next())
				{
					status = checkNull(resultSet.getString(1));
				}
				resultSet.close();
				resultSet = null;
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("getVoucherStatus =========== ["+ status +"]");
		
		return checkNull(status);
	}
	//Added by Prasad on 30/06/15 [for onchange events] END
	
	//Added By Umakanta on 30/DEC/2015
	private String errorType( Connection conn , String errorCode ) throws  ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}
	//Added by parikshit on 18/FEB/2016 [ check purc_order number -F15KSUN017] start
	/**
	 * setPODetails
	 * @param connectionObject
	 * @param documentRefNo
	 * @param dom
	 * @return 
	 * @throws Exception
	 */
	private String setPODetails( Connection connectionObject, String documentRefNo, Document dom ,String loginSiteCode) throws Exception 
	{
		StringBuffer valueXmlString = new StringBuffer();
		try 
		{
			Statement statement = connectionObject.createStatement();
			ResultSet resultSet = null;
			String sql = "";
			//changed by parikshit on 05/05/2016 [added company name description in query] -start
			/*sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.tax_reg, supp.email_addr, porder.site_descr "
					+ " FROM porder porder, supplier supp "
					+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
					+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
					+ " WHERE porder.supp_code = supp.supp_code "
					+ " AND purc_order ='" + documentRefNo + "'";*/
			sql = "SELECT porder.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.tax_reg, supp.email_addr, site.descr "
					+ " FROM porder porder LEFT OUTER JOIN site site ON site.site_code = porder.site_code__bill , supplier supp "
					+ " LEFT OUTER JOIN state state ON state.state_code = supp.state_code "
					+ " LEFT OUTER JOIN country country ON country.count_code = supp.count_code "
					+ " WHERE porder.supp_code = supp.supp_code "
					+ " AND purc_order ='" + documentRefNo + "'";
			//changed by parikshit on 05/05/2016 [added company name description in query] -end
			resultSet = statement.executeQuery(sql);
			if (resultSet.next())
			{
				valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
				valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
				valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
				valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
				valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
				valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
				valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</tax_reg>\r\n");
				valueXmlString.append("<sundry_type>").append("<![CDATA[S]]>").append("</sundry_type>\r\n");
				valueXmlString.append("<sundry_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</sundry_code>\r\n");
				valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</email_addr>\r\n");
				valueXmlString.append("<porder_no>").append("<![CDATA["+ documentRefNo +"]]>").append("</porder_no>\r\n");
				valueXmlString.append("<company_name>").append("<![CDATA["+ resultSet.getString(9) +"]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [for display company name - F16ASUN015]
				valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
			}
			else 
			{
				valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
				valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
				valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
				valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
				valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
				valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
				valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
				valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
				valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
				valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
				valueXmlString.append("<porder_no>").append("<![CDATA[]]>").append("</porder_no>\r\n");
				valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");// Added by parikshit on 05/05/16 [for display company name - F16ASUN015]
			}
			resultSet.close();
			resultSet = null;
			
			String bill_no = genericUtility.getColumnValue("bill_no",dom);
			String voucherNo = "";
			if ( bill_no != null && !bill_no.equals("") )
			{
				sql = "SELECT tran_id from voucher where purc_order = '" + documentRefNo + "' AND bill_no = '" + bill_no + "'";

				resultSet = statement.executeQuery(sql);
				int chkCnt = 0;
				while (resultSet.next())
				{
					voucherNo = checkNull(resultSet.getString(1));
					chkCnt ++;
				}
				resultSet.close();
				resultSet = null;
				if ( chkCnt != 1 )
				{
					voucherNo = "";
				}
				valueXmlString.append("<voucher_no>").append("<![CDATA["+ voucherNo +"]]>").append("</voucher_no>\r\n");
			}

			if ( voucherNo.equals("") )
			{
				voucherNo = genericUtility.getColumnValue("voucher_no", dom);
			}
			System.out.println("voucherNo =========== ["+ voucherNo +"]");
			if ( voucherNo != null && !voucherNo.equals("") )
			{
				String gimNo = getGIMNo(connectionObject, documentRefNo, voucherNo);
				valueXmlString.append("<prcp_no>").append("<![CDATA["+ gimNo +"]]>").append("</prcp_no>\r\n");
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		return checkNull(valueXmlString.toString());
	}
	//Added by parikshit on 18/FEB/2016 [ check purc_order number -F15KSUN017] end
	
	//Added by parikshit on 16/MAY/2016 [ to get non-po company details -F16ASUN015] start
	private String getNONPOCompanyDtl(String columnValue, Connection connectionObject,String loginSiteCode) throws SQLException 
	{
		StringBuffer valueXmlString = new StringBuffer();
		String sql = "";
		ResultSet resultSet = null;
		String varValue = "";
		String sundryType = "";
		String sundryCode = "";
		String billNo = "";
		String compnyName = "";
		int chkCnt = 0;
		Statement statement = null;
		PreparedStatement pStmt = null;

		sql = "select var_value from finparm where prd_code = '999999' and var_name = 'MISC_TRAN_SER'";
		statement = connectionObject.createStatement();
		resultSet = statement.executeQuery(sql);
		if (resultSet.next()) 
		{
			varValue = checkNull(resultSet.getString(1));
		}
		resultSet.close();
		resultSet = null;
		
		sql = "select distinct sundry_type, sundry_code, bill_no, misc_payables.site_code, site.descr " +
				" from misc_payables " +
				" left outer join site on site.site_code = misc_payables.site_code " +
				" where ref_no = ? " +
				" and INSTR(','|| ? || ',',','|| TRIM(TRAN_Ser) || ',' ) > 0 " +
				" and misc_payables.tot_amt<>misc_payables.adj_amt";
		pStmt = connectionObject.prepareStatement(sql);
		pStmt.setString(1, columnValue);
		pStmt.setString(2, varValue);
		resultSet = pStmt.executeQuery();
		if (resultSet.next()) 
		{
			sundryType = checkNull(resultSet.getString(1));
			sundryCode = checkNull(resultSet.getString(2));
			billNo = checkNull(resultSet.getString(3));
			compnyName = checkNull(resultSet.getString(5));
			chkCnt++;
		}
		resultSet.close();
		resultSet = null;
		pStmt.close();
		pStmt = null;

		if (chkCnt == 0) 
		{
			sql = "select sundry_type, sundry_code, bill_no, misc_voucher.site_code, site.descr from misc_voucher "
					+ " left outer join site on site.site_code = misc_voucher.site_code where misc_voucher.tran_id = ? and confirmed = 'N'"
					+ " union all "
					+ " select 'E', emp_code, ref_no, payr_voucher.site_code, site.descr from payr_voucher "
					+ " left outer join site on site.site_code = payr_voucher.site_code where payr_voucher.tran_id = ? and confirmed = 'N' "
					+ " union all "
					+ " select sundry_type, sundry_code, invoice_id, drcr_inv.site_code, site.descr from drcr_inv "
					+ " left outer join site on site.site_code = drcr_inv.site_code where drcr_inv.tran_id = ? and confirmed = 'N'";

			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, columnValue);
			pStmt.setString(2, columnValue);
			pStmt.setString(3, columnValue);
			resultSet = pStmt.executeQuery();
			if (resultSet.next()) 
			{
				sundryType = checkNull(resultSet.getString(1));
				sundryCode = checkNull(resultSet.getString(2));
				billNo = checkNull(resultSet.getString(3));
				compnyName = checkNull(resultSet.getString(5));
			}
			resultSet.close();
			resultSet = null;
			pStmt.close();
			pStmt = null;
		}
		sql = "";
		if ( "S".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select supp.supp_code, supp.supp_name, supp.city, state.descr, country.descr, supp.pin, supp.email_addr," 
					+" nvl(fdf_reg_no('S', supp.supp_code, 'L' ),'NA') as tax_reg "
					+" from supplier supp LEFT OUTER JOIN state state ON state.state_code = supp.state_code " 
					+" LEFT OUTER JOIN country country ON country.count_code = supp.count_code WHERE supp.supp_code = ? ";
		}
		else if ( "E".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select emp.emp_code, emp.emp_fname||''||emp.emp_mname||''||emp.emp_lname, emp.cur_city, state.descr, country.descr, emp.cur_pin, "
					+" emp.email_id_off, nvl(fdf_reg_no('E', emp.emp_code, 'P' ),'NA') as tax_reg  " 
					+" from employee emp LEFT OUTER JOIN state state ON state.state_code = emp.cur_state " 
					+" LEFT OUTER JOIN country country ON country.count_code = state.count_code WHERE emp.emp_code = ? ";			
		}
		else if ( "C".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select cust.cust_code, cust.cust_name, cust.city,  state.descr, country.descr, cust.pin, cust.email_addr, "
					+" nvl(fdf_reg_no('C', cust.cust_code, 'L' ),'NA') as tax_reg "
					+" from customer cust LEFT OUTER JOIN state state ON state.state_code = cust.state_code " 
					+" LEFT OUTER JOIN country country ON country.count_code = cust.count_code WHERE cust.cust_code =  ? ";
		}
		else if ( "P".equalsIgnoreCase( sundryType  ) )
		{
			sql = "select salp.sales_pers, salp.sp_name, salp.city, state.descr, country.descr, salp.pin, salp.email_addr, "
					+" nvl(fdf_reg_no('P', salp.sales_pers, 'P' ),'NA') as tax_reg "
					+" from sales_pers salp LEFT OUTER JOIN state state ON state.state_code = salp.state_code "
					+" LEFT OUTER JOIN country country ON country.count_code = salp.count_code WHERE salp.sales_pers = ? ";
		}
		else if ( "L".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select lparty.party_code, lparty.party_name, lparty.city, state.descr,country.descr, lparty.pin, lparty.email_addr,"
					+" nvl(fdf_reg_no('L', lparty.party_code, 'P' ),'NA') as tax_reg"
					+" from loanparty lparty LEFT OUTER JOIN state state ON state.state_code = lparty.state_code "
					+" LEFT OUTER JOIN country country ON country.count_code = lparty.count_code WHERE lparty.party_code = ? ";
		}
		else if ( "T".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select transp.tran_code, transp.tran_name, transp.city,  state.descr,country.descr, transp.pin, transp.email_addr, "
					+" nvl(fdf_reg_no('T', transp.tran_code, 'P' ),'NA') as tax_reg "
					+" from transporter transp LEFT OUTER JOIN state state ON state.state_code = transp.state_code " 
					+" LEFT OUTER JOIN country country ON country.count_code = transp.count_code WHERE transp.tran_code = ? ";
		}
		else if ( "X".equalsIgnoreCase( sundryType  ) )
		{
			sql = "select tax_authority.tauth_code, tax_authority.tauth_name, tax_authority.city, state.descr,country.descr, tax_authority.pin, " 
					+" tax_authority.email_addr,nvl(fdf_reg_no('X', tax_authority.tauth_code, 'P' ),'NA') as tax_reg " 
					+" from tax_authority tax_authority LEFT OUTER JOIN state state ON state.state_code = tax_authority.state_code  "
					+" LEFT OUTER JOIN country country ON country.count_code = tax_authority.count_code WHERE tax_authority.TAUTH_CODE = ? ";
		}
		else if ( "R".equalsIgnoreCase( sundryType  ) )
		{
			sql = " select strgcust.sc_code, strgcust.first_name||''||strgcust.middle_name||''||strgcust.last_name, strgcust.city, "
					+" state.descr,country.descr, strgcust.pin, strgcust.email_addr, nvl(fdf_reg_no('R', strgcust.sc_code, 'P' ),'NA')  as tax_reg "
					+" from strg_customer strgcust  LEFT OUTER JOIN state state ON state.state_code = strgcust.state_code " 
					+" LEFT OUTER JOIN country country ON country.count_code = strgcust.count_code WHERE strgcust.sc_code = ? ";
		}

		if ( checkNull( sql ).length() > 0 )
		{
			pStmt = connectionObject.prepareStatement( sql );
			pStmt.setString( 1, sundryCode );
			resultSet = pStmt.executeQuery();
			if (resultSet.next())
			{
				valueXmlString.append("<supp_code>").append("<![CDATA["+ resultSet.getString(1) +"]]>").append("</supp_code>\r\n");
				valueXmlString.append("<supp_name>").append("<![CDATA["+ resultSet.getString(2) +"]]>").append("</supp_name>\r\n");
				valueXmlString.append("<city>").append("<![CDATA["+ resultSet.getString(3) +"]]>").append("</city>\r\n");
				valueXmlString.append("<state_descr>").append("<![CDATA["+ resultSet.getString(4) +"]]>").append("</state_descr>\r\n");
				valueXmlString.append("<country_descr>").append("<![CDATA["+ resultSet.getString(5) +"]]>").append("</country_descr>\r\n");
				valueXmlString.append("<pin>").append("<![CDATA["+ resultSet.getString(6) +"]]>").append("</pin>\r\n");
				valueXmlString.append("<email_addr>").append("<![CDATA["+ resultSet.getString(7) +"]]>").append("</email_addr>\r\n");
				valueXmlString.append("<tax_reg>").append("<![CDATA["+ resultSet.getString(8) +"]]>").append("</tax_reg>\r\n");
				valueXmlString.append("<sundry_type>").append("<![CDATA["+sundryType+"]]>").append("</sundry_type>\r\n");
				valueXmlString.append("<sundry_code>").append("<![CDATA["+ sundryCode +"]]>").append("</sundry_code>\r\n");
				//Commented by Prasad on 10/06/16 [removing bill_no set condition]
				/*valueXmlString.append("<bill_no>").append("<![CDATA["+ billNo +"]]>").append("</bill_no>\r\n");*/
				valueXmlString.append("<company_name>").append("<![CDATA["+ compnyName +"]]>").append("</company_name>\r\n");
				valueXmlString.append("<challan_no>").append("<![CDATA["+ loginSiteCode +"]]>").append("</challan_no>\r\n");
			}
			else
			{
				valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
				valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
				valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
				valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
				valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
				valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
				valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
				valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
				valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
				valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
				//Commented by Prasad on 10/06/16 [removing bill_no set condition]
				/*valueXmlString.append("<bill_no>").append("<![CDATA[]>").append("</bill_no>\r\n");*/
				valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");
			}
			resultSet.close();
			resultSet = null;
			pStmt.close();
			pStmt = null;
		}
		else  
		{
			valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
			valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");
			valueXmlString.append("<city>").append("<![CDATA[]]>").append("</city>\r\n");
			valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>\r\n");
			valueXmlString.append("<country_descr>").append("<![CDATA[]]>").append("</country_descr>\r\n");
			valueXmlString.append("<pin>").append("<![CDATA[]]>").append("</pin>\r\n");
			valueXmlString.append("<email_addr>").append("<![CDATA[]]>").append("</email_addr>\r\n");
			valueXmlString.append("<tax_reg>").append("<![CDATA[]]>").append("</tax_reg>\r\n");
			valueXmlString.append("<sundry_type>").append("<![CDATA[]]>").append("</sundry_type>\r\n");
			valueXmlString.append("<sundry_code>").append("<![CDATA[]]>").append("</sundry_code>\r\n");
			//Commented by Prasad on 10/06/16 [removing bill_no set condition]
			/*valueXmlString.append("<bill_no>").append("<![CDATA[]]>").append("</bill_no>\r\n");*/
			valueXmlString.append("<company_name>").append("<![CDATA[]]>").append("</company_name>\r\n");
		}
	
		return valueXmlString.toString();
	}
	//Added by parikshit on 16/MAY/2016 [ to get non-po company details -F16ASUN015] end
	
	//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]Start.
	/**
	 * 
	 * @param docType
	 * @param connectionObject
	 * @return
	 * @throws Exception
	 */
	private String getDocTypeDescr( String docType, Connection connectionObject ) throws Exception
	{
		System.out.println("docType==["+ docType +"]");
		String docTypeDescr = "";
		if ( docType != null  )
		{
			PreparedStatement pstmt = null ; 
			ResultSet rs = null;
			try
			{	
				/* START >> Commented by vinay c 15/01/2020 
				String  sql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_SUPPLIER_BILL' AND ACTIVE='Y' AND FLD_VALUE = ? ";
				End  */
				/* START >> Added by vinay c 15/01/2020 */
				String  sql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_MARKETING_BILL' AND ACTIVE='Y' AND FLD_VALUE = ? ";
				/* End  */
				pstmt = connectionObject.prepareStatement( sql );			
				pstmt.setString(1, docType);			
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					docTypeDescr = rs.getString("DESCR");
				}			
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}
			finally
			{
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("docTypedescr== ["+ docTypeDescr +"]");
		
		return docTypeDescr;
	}
	
	private boolean isValidDate(String dateStr) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());//genericUtility.getApplDateFormat()
			Date date1 = sdf1.parse(dateStr);
			Calendar userDate = Calendar.getInstance();
			userDate.setTime(date1);
			//sdf.setLenient(false);
			Date date = sdf.parse(sdf.format(userDate.getTime()));
			System.out.println(" sdf getDBDateFormat "+genericUtility.getDBDateFormat());
			System.out.println(" sdf getApplDateFormat "+genericUtility.getApplDateFormat());
			System.out.println(" sdf date "+sdf.format(date));
		}
		catch (Exception e) {
			//myLogger.log(Level.SEVERE, " isValidDate Mtd An Exception Was Thrown ", e);
			System.out.println(" Exception "+e.getMessage());
			return false;
		}
		return true;
	}

	private boolean isFutureDate(String dateStr) {
		boolean isFutureDate = false;
		try 
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Calendar currentDate = Calendar.getInstance();
			Date currentAppDate = sdf.parse(sdf.format(currentDate.getTime()));
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());//genericUtility.getApplDateFormat()
			Date date1 = sdf1.parse(dateStr);
			Calendar userDate = Calendar.getInstance();
			userDate.setTime(date1);
			Date userAppDate = sdf.parse(sdf.format(userDate.getTime()));
			System.out.println(" currentAppDate:- "+sdf.format(currentAppDate));
			System.out.println(" userAppDate:- "+sdf.format(userAppDate));
			System.out.println(" userAppDate.after(currentAppDate):- "+userAppDate.after(currentAppDate));
			if(userAppDate.after(currentAppDate))
			{
				isFutureDate = true;
			}
		}
		catch(Exception e) {
			//myLogger.log(Level.SEVERE, " isFutureDate Mtd An Exception Was Thrown ", e);
			System.out.println(" Exception "+e.getMessage());
			e.printStackTrace();
		}
		return isFutureDate;
	}
	//added by vishal pathare on 24.1.17 for[adding Document Type ('Original' or 'Additional Supporting') in SSC mail]End.
}