package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EpaymentPrc extends ProcessEJB implements EpaymentPrcLocal, EpaymentPrcRemote {
	int MAXBLANKROWS = 33;
	String userId = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	String bankCD = null;

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("EpaymentPrcEJB :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				System.out.println("XML String :" + xmlString);
				headerDom = this.genericUtility.parseString(xmlString);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				System.out.println("XML String :" + xmlString2);
				detailDom = this.genericUtility.parseString(xmlString2);
			}

			rtrStr = this.getData(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var9) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var9.getMessage() + ":");
			rtrStr = var9.getMessage();
		}

		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String errString = null;
		String errCode = "";
		String returnString = "";
		String getDataSql = "";
		String sql = "";
		String sql1 = "";
		String resultString = "";
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		String siteCode = null;
		String tranId = "";
		String refNo = "";
		Timestamp toDate = null;
		Timestamp fromDate = null;
		boolean recFound = false;
		double netAmt = 0.0D;
		double exchRate = 0.0D;
		int flag = 0;
		Timestamp confDate = null;
		Timestamp refDate = null;
		Timestamp tranDate = null;
		String currCode = "";
		String sundryCode = "";
		String sundryType = "";
		String finEntity = "";
		String confirmed = "";
		Connection conn = null;

		String var63;
		try {
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
			this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId............." + this.userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String vouchNoFr = "";
			String vouchNoTo = "";
			String dateFr = "";
			String dateTo = "";
			String payMode = "";
			String bankCode = "";
			String frmSch = "";
			siteCode = this.genericUtility.getColumnValue("site_code", headerDom);
			vouchNoFr = this.genericUtility.getColumnValue("voucher_no_fr", headerDom);
			vouchNoTo = this.genericUtility.getColumnValue("voucher_no_to", headerDom);
			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
			if (vouchNoFr == null || vouchNoFr.trim().length() == 0) {
				vouchNoFr = "00";
			}

			if (vouchNoTo == null || vouchNoTo.trim().length() == 0) {
				vouchNoTo = "ZZ";
			}

			String mainTblName = null;
			String mainTblCode = null;
			String bankTblName = null;
			String bankTblCode = null;
			if ("T".equalsIgnoreCase(sundryType)) {
				mainTblName = "TRANSPORTER";
				mainTblCode = "TRAN_CODE";
				bankTblName = "TRANSPORTER_BANK";
				bankTblCode = "TRAN_CODE";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				mainTblName = "SALES_PERS";
				mainTblCode = "SALES_PERS";
				bankTblName = "SALES_PERS_BANK";
				bankTblCode = "SALES_PERS";
			} else if ("R".equalsIgnoreCase(sundryType)) {
				mainTblName = "STRG_CUSTOMER";
				mainTblCode = "SC_CODE";
				bankTblName = "STRG_CUST_BANK";
				bankTblCode = "SC_CODE";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				mainTblName = "LOANPARTY";
				mainTblCode = "PARTY_CODE";
				bankTblName = "LOANPARTY_BANK";
				bankTblCode = "PARTY_CODE";
			} else if ("S".equalsIgnoreCase(sundryType)) {
				mainTblName = "SUPPLIER";
				mainTblCode = "SUPP_CODE";
				bankTblName = "SUPPLIER_BANK";
				bankTblCode = "SUPP_CODE";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				mainTblName = "CUSTOMER";
				mainTblCode = "CUST_CODE";
				bankTblName = "CUSTOMER_BANK";
				bankTblCode = "CUST_CODE";
			}

			dateFr = this.genericUtility.getColumnValue("date_fr", headerDom);
			dateTo = this.genericUtility.getColumnValue("date_to", headerDom);
			frmSch = this.checkNull(this.genericUtility.getColumnValue("frm_sch", headerDom));
			System.out.println("frmSch@@@@@@@@@@==" + frmSch);
			if (dateFr == null || dateFr.trim().length() == 0) {
				returnString = this.itmDBAccessEJB.getErrorString("", "VTFRDTBLK", this.userId, "", conn);
				var63 = returnString;
				return var63;
			}

			if (dateTo != null && dateTo.trim().length() != 0) {
				System.out.println("dateFr :: " + dateFr);
				String dateFr1 = this.genericUtility.getValidDateString(dateFr, this.genericUtility.getApplDateFormat(),
						this.genericUtility.getDBDateFormat());
				fromDate = Timestamp.valueOf(dateFr1 + " 00:00:00.0");
				String dateTo1 = this.genericUtility.getValidDateString(dateTo, this.genericUtility.getApplDateFormat(),
						this.genericUtility.getDBDateFormat());
				toDate = Timestamp.valueOf(dateTo1 + " 00:00:00.0");
				System.out.println("fromDate..............." + fromDate);
				System.out.println("toDate..............." + toDate);
				payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
				bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
				this.bankCD = bankCode;
				System.out.println("payMode..............." + payMode);
				if (payMode != null && payMode.trim().length() != 0) {
					if (siteCode != null && siteCode.trim().length() != 0) {
						String bankFilePath = null;
						int cnt = 0;
						bankFilePath = "select count( * ) cnt from site where site_code = ? ";
						vPStmt = conn.prepareStatement(bankFilePath);
						vPStmt.setString(1, siteCode);
						vRs = vPStmt.executeQuery();
						if (vRs.next()) {
							cnt = vRs.getInt("cnt");
						}

						vRs.close();
						vRs = null;
						vPStmt.close();
						vPStmt = null;
						if (cnt == 0) {
							returnString = this.itmDBAccessEJB.getErrorString("", "VTSTINV", this.userId, "", conn);
							var63 = returnString;
							return var63;
						}

						if (bankCode != null && bankCode.trim().length() != 0) {
							bankFilePath = null;
							cnt = 0;
							bankFilePath = "select count( * ) cnt from bank where bank_code = ? ";
							vPStmt = conn.prepareStatement(bankFilePath);
							vPStmt.setString(1, bankCode);
							vRs = vPStmt.executeQuery();
							if (vRs.next()) {
								cnt = vRs.getInt("cnt");
							}

							vRs.close();
							vRs = null;
							vPStmt.close();
							vPStmt = null;
							if (cnt == 0) {
								returnString = this.itmDBAccessEJB.getErrorString("", "VTBNKINV", this.userId, "",
										conn);
								var63 = returnString;
								return var63;
							}

							bankFilePath = null;
							String bankFileFormat = null;
							String batchPath = null;
							String bankSql = null;
							bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
									+ bankCode + "'";
							System.out.println("bankSql :: " + bankSql);
							Statement bankStmt = null;
							ResultSet bankRs = null;

							try {
								bankStmt = conn.createStatement();
								bankRs = bankStmt.executeQuery(bankSql);
								if (bankRs.next()) {
									bankFilePath = bankRs.getString("filePath");
									bankFileFormat = bankRs.getString("bankformat");
									batchPath = bankRs.getString("batchpath");
								}
							} catch (Exception var95) {
								var95.printStackTrace();
							} finally {
								try {
									if (bankRs != null) {
										bankRs.close();
									}

									bankRs = null;
									if (bankStmt != null) {
										bankStmt.close();
									}

									bankStmt = null;
								} catch (Exception var94) {
									;
								}

							}

							if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
								if (bankFilePath != null && bankFilePath.trim().length() != 0) {
									String iciciSql = null;
									iciciSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE ,  MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE ,  MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,   MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE ,  MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY ,  MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,   MISC_PAYMENT.CONFIRMED   FROM  MISC_PAYMENT   WHERE ( MISC_PAYMENT.SITE_CODE = '"
											+ siteCode + "' ) " + "\tAND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
											+ "\tAND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
											+ "\tAND MISC_PAYMENT.EFF_DATE is null " + "\tAND MISC_PAYMENT.PAY_MODE = '"
											+ payMode + "' "
											+ "\tAND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') "
											+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
											+ "\t AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM MISC_PAYMENT_CANC "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
											+ "\tAND exists( select 1 from  MISC_PAYDET "
											+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID ) ";
									if (!"E".equalsIgnoreCase(sundryType)) {
										iciciSql = iciciSql + "\tAND exists ( select 1 from  " + bankTblName
												+ "\t\t\t\t\tWHERE " + bankTblName + ".CONFIRMED = 'Y' "
												+ " \t\t\t\t\t\tand " + bankTblName + ".ACTIVE_YN = 'Y' "
												+ "\t\t\t\t\t\tand " + bankTblName + ". " + bankTblCode + " in "
												+ "\t\t\t\t\t\t\t\t(select misc_paydet.sundry_code "
												+ "\t\t\t\t\t\t\t\t\tfrom misc_paydet "
												+ "\t\t\t\t\t\t\t\t where misc_paydet.tran_id = misc_payment.tran_id "
												+ "\t\t\t\t\t\t\t\t\t\tand misc_paydet.sundry_type = '" + sundryType
												+ "') " + "\t\t) ";
									}

									String citiSql = null;
									citiSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE ,  MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE ,  MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,   MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE ,  MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY ,  MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,   MISC_PAYMENT.CONFIRMED   FROM  MISC_PAYMENT   WHERE ( MISC_PAYMENT.SITE_CODE = '"
											+ siteCode + "' ) " + "\tAND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
											+ "\tAND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
											+ "\tAND MISC_PAYMENT.EFF_DATE is null " + "\tAND MISC_PAYMENT.PAY_MODE = '"
											+ payMode + "' " + " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
											+ "\tAND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end  in ('S','C') "
											+ "\t AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM MISC_PAYMENT_CANC "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
											+ "\tAND exists( select 1 from  MISC_PAYDET "
											+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID "
											+ "\t\t\t\t\t\tAND MISC_PAYDET.SUNDRY_TYPE= '" + sundryType + "' "
											+ "\t\t) " + "\tAND exists ( select 1 from  " + bankTblName
											+ "\t\t\t\t\tWHERE " + bankTblName + ".CONFIRMED = 'Y' "
											+ " \t\t\t\t\t\tand " + bankTblName + ".ACTIVE_YN = 'Y' "
											+ "\t\t\t\t\t\tand " + bankTblName + ". " + bankTblCode + " in "
											+ "\t\t\t\t\t\t\t\t(select misc_paydet.sundry_code "
											+ "\t\t\t\t\t\t\t\t\tfrom misc_paydet "
											+ "\t\t\t\t\t\t\t\t where misc_paydet.tran_id = misc_payment.tran_id "
											+ "\t\t\t\t\t\t\t\t\t\tand misc_paydet.sundry_type = '" + sundryType + "') "
											+ "\t\t) ";
									String stancSql = null;
									stancSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE ,  MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE ,  MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,   MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE ,  MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY ,  MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,   MISC_PAYMENT.CONFIRMED   FROM  MISC_PAYMENT   WHERE ( MISC_PAYMENT.SITE_CODE = '"
											+ siteCode + "' ) " + "\tAND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
											+ "\tAND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
											+ "\tAND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
											+ "\tAND MISC_PAYMENT.EFF_DATE is null " + "\tAND MISC_PAYMENT.PAY_MODE = '"
											+ payMode + "' "
											+ "\tAND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') "
											+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
											+ "\t AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM M" + "ISC_PAYMENT_CANC "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
											+ "\tAND exists( select 1 from  MISC_PAYDET "
											+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID ) ";
									if (bankFileFormat.equalsIgnoreCase("ICICI")) {
										sql = iciciSql;
										pstmt = conn.prepareStatement(iciciSql);
									} else if (bankFileFormat.equalsIgnoreCase("CITI")) {
										sql = citiSql;
										pstmt = conn.prepareStatement(citiSql);
									} else if (bankFileFormat.equalsIgnoreCase("STANC")) {
										sql = stancSql;
										pstmt = conn.prepareStatement(stancSql);
									}

									System.out.println("sql.............[" + sql + "]");
									pstmt.setTimestamp(1, fromDate);
									pstmt.setTimestamp(2, toDate);
									rs = pstmt.executeQuery();

									while (rs.next()) {
										recFound = true;
										tranId = rs.getString("TRAN_ID");
										flag = 0;
										sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, tranId);
										rs1 = pstmt1.executeQuery();
										if (rs1.next()) {
											flag = rs1.getInt(1);
										}

										rs1.close();
										rs1 = null;
										pstmt1.close();
										pstmt1 = null;
										if (flag == 0) {
											currCode = rs.getString("CURR_CODE");
											tranDate = rs.getTimestamp("TRAN_DATE");
											refDate = rs.getTimestamp("REF_DATE");
											exchRate = rs.getDouble("EXCH_RATE");
											netAmt = rs.getDouble("NET_AMT");
											sundryCode = rs.getString("SUNDRY_CODE");
											siteCode = rs.getString("SITE_CODE");
											finEntity = rs.getString("FIN_ENTITY");
											bankCode = rs.getString("BANK_CODE");
											payMode = rs.getString("PAY_MODE");
											confirmed = rs.getString("CONFIRMED");
											refNo = rs.getString("REF_NO");
											confDate = rs.getTimestamp("CONF_DATE");
											refNo = refNo == null ? "" : refNo.trim();
											retTabSepStrBuff.append(tranId).append("\t");
											retTabSepStrBuff.append(siteCode).append("\t");
											retTabSepStrBuff.append(sundryCode).append("\t");
											retTabSepStrBuff.append(bankCode).append("\t");
											retTabSepStrBuff.append(currCode).append("\t");
											retTabSepStrBuff.append(payMode).append("\t");
											retTabSepStrBuff.append(refNo).append("\t");
											retTabSepStrBuff.append(netAmt).append("\t");
											retTabSepStrBuff.append(finEntity).append("\t");
											retTabSepStrBuff.append(tranDate).append("\t");
											retTabSepStrBuff.append(exchRate).append("\t");
											retTabSepStrBuff.append(sundryType).append("\t");
											retTabSepStrBuff.append(confirmed).append("\t");
											retTabSepStrBuff.append(confDate).append("\t");
											retTabSepStrBuff.append(refDate).append("\t");
											retTabSepStrBuff.append("\n");
										}
									}

									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									System.out.println("frmSch[" + frmSch + "]recFound[" + recFound + "]");
									if ((frmSch == null || frmSch.trim().length() == 0 || !"Y".equalsIgnoreCase(frmSch))
											&& !recFound) {
										System.out.println("Match@@@@@");
										returnString = this.itmDBAccessEJB.getErrorString("", "VTNODATA", this.userId,
												"", conn);
										conn.close();
										conn = null;
										var63 = returnString;
										return var63;
									}

									System.out.println("retTabSepStrBuff[" + retTabSepStrBuff + "]");
									if (retTabSepStrBuff != null) {
										resultString = retTabSepStrBuff.toString();
										System.out.println("ResultString....." + resultString);
									}

									return resultString;
								}

								errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
								var63 = errString;
								return var63;
							}

							errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
							var63 = errString;
							return var63;
						}

						returnString = this.itmDBAccessEJB.getErrorString("", "VTBANKBLK", this.userId, "", conn);
						var63 = returnString;
						return var63;
					}

					returnString = this.itmDBAccessEJB.getErrorString("", "VTSTBLK", this.userId, "", conn);
					var63 = returnString;
					return var63;
				}

				returnString = this.itmDBAccessEJB.getErrorString("", "VTPMBLK", this.userId, "", conn);
				var63 = returnString;
				return var63;
			}

			returnString = this.itmDBAccessEJB.getErrorString("", "VTTODTBLK", this.userId, "", conn);
			var63 = returnString;
		} catch (SQLException var98) {
			System.out.println(
					"SQLException :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var98.getMessage() + ":");
			throw new ITMException(var98);
		} catch (Exception var99) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var99.getMessage() + ":");
			throw new ITMException(var99);
		} finally {
			try {
				retTabSepStrBuff = null;
				if (rs != null) {
					rs.close();
				}

				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception var97) {
				errString = var97.getMessage();
				var97.printStackTrace();
				throw new ITMException(var97);
			}

		}

		return var63;
	}

	public String process() throws RemoteException, ITMException {
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String retStr = "";

		try {
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			System.out.println("windowName[process]::::::::::;;;" + windowName);
			System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);
		} catch (Exception var11) {
			System.out.println(var11.getMessage());
			var11.printStackTrace();
		}

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}

			retStr = this.process(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var10) {
			System.out.println(
					"Exception :WorkorderPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var10.getMessage() + ":");
			var10.printStackTrace();
			retStr = var10.getMessage();
		}

		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String retStr = "";
		String tranId = "";
		String gentext = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		String retString = "";
		String errCode = "";
		String textDoc = "";
		String textDoc1 = "";
		String sundryType = "";
		String bankCode = "";
		String fileName = "";
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String filePath = null;
		String hdrLines = null;
		String bankFilePath = null;
		String bankFileFormat = null;
		String batchPath = null;

		label653 : {
			String var38;
			try {
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				String bankSql = null;
				this.genericUtility.getColumnValue("sundry_type", headerDom);
				bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
				bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
						+ bankCode + "'";
				Statement bankStmt = null;
				ResultSet bankRs = null;

				try {
					bankStmt = conn.createStatement();
					bankRs = bankStmt.executeQuery(bankSql);
					if (bankRs.next()) {
						bankFilePath = bankRs.getString("filePath");
						bankFileFormat = bankRs.getString("bankformat");
						batchPath = bankRs.getString("batchpath");
					}
				} catch (Exception var68) {
					var68.printStackTrace();
				} finally {
					try {
						if (bankRs != null) {
							bankRs.close();
						}

						bankRs = null;
						if (bankStmt != null) {
							bankStmt.close();
						}

						bankStmt = null;
					} catch (Exception var67) {
						;
					}

				}

				int flag1;
				int flag;
				label688 : {
					if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
						if (bankFilePath != null && bankFilePath.trim().length() != 0) {
							System.out.println("Manoharan 29/09/14 in process bankCD [" + this.bankCD + "] bank_code ["
									+ bankCode + "] bankFilePath [" + bankFilePath + "] bankFileFormat ["
									+ bankFileFormat + "] batchPath [" + batchPath + "]");
							Node currDetail = null;
							NodeList detailList = null;
							detailList = detailDom.getElementsByTagName("Detail2");
							int noOfDetails = 0;
							flag = 0;
							flag1 = 0;
							noOfDetails = detailList.getLength();
							flag = 0;
							int ctr = 0;

							while (true) {
								if (ctr >= noOfDetails) {
									break label688;
								}

								String tId = null;
								currDetail = detailList.item(ctr);
								tId = this.genericUtility.getColumnValueFromNode("tran_id", currDetail);
								sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tId);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									flag = rs.getInt(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								sql = "select count(1) from MISC_payment where MISC_PAYMENT.TRAN_ID =? and MISC_PAYMENT.EFF_DATE is not null ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tId);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									flag1 = rs.getInt(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if (flag > 0 || flag1 > 0) {
									break label688;
								}

								++ctr;
							}
						}

						errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
						var38 = errString;
						return var38;
					}

					errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
					var38 = errString;
					return var38;
				}

				if (flag <= 0) {
					if (flag1 > 0) {
						errString = this.itmDBAccessEJB.getErrorString("", "VTEFFDATE", this.userId);
						var38 = errString;
						return var38;
					}

					String destinationPath = null;
					ArrayList tranIdList = null;
					EpayICICI epayStanc;
					if (bankFileFormat.equalsIgnoreCase("ICICI")) {
						epayStanc = null;
						epayStanc = new EpayICICI();
						epayStanc.process(headerDom, detailDom, windowName, xtraParams, bankFilePath, batchPath, conn);
						tranIdList = epayStanc.tranIdList;
					} else if (bankFileFormat.equalsIgnoreCase("CITI")) {
//						epayStanc = null;
						EpayCITI epayCiti = new EpayCITI();
						epayCiti.process(headerDom, detailDom, windowName, xtraParams, bankFilePath, batchPath, conn);
						tranIdList = epayCiti.tranIdList;
					} else if (bankFileFormat.equalsIgnoreCase("STANC")) {
						System.out.println("@narendra inside stanc bank file format");
						epayStanc = null;
						EpaySTANC epayStanc1 = new EpaySTANC();
						epayStanc1.process(headerDom, detailDom, windowName, xtraParams, bankFilePath, batchPath, conn);
						tranIdList = epayStanc1.tranIdList;
					}

					int upd = 0;
					upd = Util.updateMiscPayment(tranIdList, conn);
					if (tranIdList != null && tranIdList.size() > 0) {
						System.out.println("Tran id generation");
						Util.InsertLog(tranIdList, this.userId, conn);
					}

					if (upd > 0) {
						System.out.println("commiting connection.............");
						conn.commit();
						errString = this.itmDBAccessEJB.getErrorString("", "VTEPSUCC", this.userId);
						System.out.println("process completed .." + errString);
						retString = errString;
						break label653;
					}

					System.out.println("connection rollback.............");
					System.out.println("Returning Result " + errString);
					conn.rollback();
					errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
					var38 = errString;
					return var38;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTTXNRPT", this.userId);
				var38 = errString;
			} catch (Exception var70) {
				System.out.println("Exception EpaymentPrcEJB" + var70.getMessage());
				System.out.println("connection rollback.............");
				System.out.println("Returning Result " + errString);

				try {
					conn.rollback();
				} catch (Exception var66) {
					;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
				var70.printStackTrace();
				var38 = errString;
				return var38;
			} finally {
				try {
					if (rs != null) {
						rs.close();
					}

					rs = null;
					if (pstmt != null) {
						pstmt.close();
					}

					if (conn != null) {
						conn.close();
						conn = null;
					}
				} catch (Exception var65) {
					System.out.println("Error In closing connection::==> " + var65);
					var65.printStackTrace();
				}

			}

			return var38;
		}

		System.out.println("returning EpaymentPrcEJB   " + retString);
		return retString;
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}

		return input.trim();
	}
}