package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class CitiBatIC extends ValidatorEJB implements CitiBatICRemote,
CitiBatICLocal {

	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String xmlString3, String objContext,
			String currentColumn, String editFlag, String xtraParams)
			throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		Document dom3 = null;

		String valueXmlString = "";
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
			}
			if (xmlString3 != null && xmlString3.trim().length() > 0) {
				dom3 = parseString(xmlString3);
			}
			System.out.println("xmlString1=" + xmlString);
			System.out.println("xmlString2=" + xmlString1);
			System.out.println("xmlString3=" + xmlString2);
			System.out.println("xmlString4=" + xmlString3);
			valueXmlString = itemChanged(dom, dom1, dom2, dom3, objContext,
					currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out
					.println("Exception : [DistributionRoute][itemChanged( String, String )] :==>\n"
							+ e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,
			Document dom3, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException,
			ITMException {

		String sql = "";
		int currentFormNo = 0;
		String childNodeName = null;
		int ctr = 0;
		int childNodeListLength = 0;

		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		GenericUtility genericUtility = GenericUtility.getInstance();

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String site_code = "";
		String work_ctr = "";
		String workDescr = "";

		try {
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			if ((objContext != null) && (objContext.trim().length() > 0)) {
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer(
					"<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append(
					"</editFlag>\r\n</Header>\r\n");

			SimpleDateFormat sdf = new SimpleDateFormat(
					genericUtility.getDispDateFormat());
			SimpleDateFormat sdf1 = new SimpleDateFormat(
					genericUtility.getDBDateFormat());
			System.out.println("Display Date format "
					+ genericUtility.getDispDateFormat());
			System.out.println("xtraParams: " + xtraParams);
			System.out
					.println("******************** Current Form No *************** = "
							+ currentFormNo);

			String loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,
					"loginSiteCode");
			System.out.println("loginsitecode.....=" + loginSiteCode);

			switch (currentFormNo) {
			case 1:
				System.out.println("currentFormNo-------*************** = "
						+ currentFormNo);
				parentNodeList = dom3.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr++;
				} while ((ctr < childNodeListLength)
						&& (!childNodeName.equals(currentColumn)));
				System.out.println("CurrentColumn : " + currentColumn);
				
				if (currentColumn.equalsIgnoreCase("itm_default")) {

					String bankCode = "";

					sql = " select bank_code from site where site_code=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSiteCode.trim());
					rs = pstmt.executeQuery();
					if (rs.next()) {
						bankCode = rs.getString("bank_code");
					}
					callPstRs(pstmt, rs);

					valueXmlString.append("<bank_code>")
							.append("<![CDATA[" + bankCode + "]]>")
							.append("</bank_code>");

					valueXmlString.append("<site_code>")
							.append("<![CDATA[" + loginSiteCode + "]]>")
							.append("</site_code>");
					
//					valueXmlString.append("<pay_mode>")
//					.append("<![CDATA[W]]>")
//					.append("</pay_mode>");
					// Changes done by Tanay [02/11/2018]
					valueXmlString.append("<pay_mode>")
					.append("<![CDATA[" + "" + "]]>")
					.append("</pay_mode>");
					
					valueXmlString.append("<name_option>")
					.append("<![CDATA[C]]>")
					.append("</name_option>");
				}
				
				if (currentColumn.equalsIgnoreCase("site_code")) {

					String siteCode = "";
					siteCode = genericUtility.getColumnValue("site_code", dom3);
					String bankCode = "";
					sql = " select bank_code from site where site_code=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						bankCode = rs.getString("bank_code");
					}
					callPstRs(pstmt, rs);

					valueXmlString.append("<bank_code>")
							.append("<![CDATA[" + bankCode + "]]>")
							.append("</bank_code>");
					
				}

				System.out
						.print("*************** Generated XML ******************"
								+ valueXmlString.toString());
				valueXmlString.append("</Detail1>\r\n");

				break;

			}
		} catch (Exception e) {
			System.out
					.println("Exception : :default_ItemChanged(Document,String):"
							+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility
					.createErrorString(e));
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if ((conn != null) && (!conn.isClosed())) {
					conn.close();
				}
			} catch (Exception ex) {
				System.out
						.println("Exception :NearExpiryIC:default_ItemChanged :==>\n"
								+ ex.getMessage());
				throw new ITMException(ex);
			}
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if ((conn != null) && (!conn.isClosed())) {
					conn.close();
				}
			} catch (Exception e) {
				System.out
						.println("Exception :NearExpiryIC:default_ItemChanged :==>\n"
								+ e.getMessage());
				throw new ITMException(e);
			}
		}

		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()
				+ ":********");
		return valueXmlString.toString();

	}

	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,
			String allFrmXmlStr, String objContext, String editFlag,
			String xtraParams) throws RemoteException {
		System.out.println("In wfValData");
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		try {
			System.out.println("currFrmXmlStr..." + currFrmXmlStr);
			System.out.println("hdrFrmXmlStr..." + hdrFrmXmlStr);
			System.out.println("allFrmXmlStr..." + allFrmXmlStr);
			if ((currFrmXmlStr != null) && (currFrmXmlStr.trim().length() != 0)) {
				currDom = parseString(currFrmXmlStr);
			}
			if ((hdrFrmXmlStr != null) && (hdrFrmXmlStr.trim().length() != 0)) {
				hdrDom = parseString(hdrFrmXmlStr);
			}
			if ((allFrmXmlStr != null) && (allFrmXmlStr.trim().length() != 0)) {
				allDom = parseString(allFrmXmlStr);
			}
			errString = validate(currDom, hdrDom, allDom, objContext, editFlag,
					xtraParams);
		} catch (Exception e) {
			System.out
					.println("Exception : [PurcRCPIc][wfValData(String currFrmXmlStr)] : ==>\n"
							+ e.getMessage());
		}
		return errString;
	}

	public String validate(Document currDom, Document hdrDom, Document allDom,
			String objContext, String editFlag, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("In validate Data");
		GenericUtility genericUtility = GenericUtility.getInstance();

		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		int count = 0;
		String errString = "";
		String errorType = "";
		String errCode = "";
		StringBuffer errStringXml = new StringBuffer(
				"<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String childNodeName = "";
		String sql = "";
		int noOfChilds = 0;
		ResultSet rs = null;
		String loginSiteCode = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		int currentFormNo = 0;
		int cnt = 0;

		ConnDriver connDriver = null;
		Node childNode = null;
		try {
			System.out.println("************xtraParams*************"
					+ xtraParams);
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,
					"loginCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,
					"loginSiteCode");
			System.out.println("**************loginCode************" + userId);
			if ((objContext != null) && (objContext.trim().length() > 0)) {
				currentFormNo = Integer.parseInt(objContext);
			}
			NodeList parentList = currDom.getElementsByTagName("Detail"
					+ currentFormNo);
			NodeList childList = null;
			System.out.println("hdrDom..." + hdrDom);
			switch (currentFormNo) {
			case 1:
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++) {
					childNode = childList.item(ctr);
					if (childNode.getNodeType() != 1) {
						continue;
					}
					childNodeName = childNode.getNodeName();
					System.out.println("Editflag =" + editFlag);
					System.out.println("parentList = " + parentList);
					System.out.println("childList = " + childList);

					if ("pay_mode".equalsIgnoreCase(childNodeName)) {
						String pay_mode = checkNull(genericUtility
								.getColumnValue("pay_mode", currDom));
						System.out.println("pay_mode: " + pay_mode);

						if ((pay_mode == "") || (pay_mode == null)) {
							System.out.println("VPBLKPYMD");
							errList.add("VPBLKPYMD");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
					}

					if ("sundry_type".equalsIgnoreCase(childNodeName)) {
						if (childNode.getFirstChild() == null) {
							errList.add("VPBLKSNTP");
							errFields.add(childNodeName.toLowerCase());
							break;
						}

						String sundry_type = checkNull(genericUtility
								.getColumnValue("sundry_type", currDom));
						System.out.println("sundry_type ... " + sundry_type);

						sql = "select count(*) from sundry_type where sundry_type= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundry_type.trim());
						rs = pstmt.executeQuery();
						if (rs.next()) {
							count = rs.getInt(1);
						}
						System.out.println("Value of Count: " + count);
						if (count <= 0) {
							errList.add("VPINVSNTP");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						callPstRs(pstmt, rs);
					}

					if (("name_option".equalsIgnoreCase(childNodeName))
							&& (childNode.getFirstChild() == null)) {
						errList.add("VPBLKNMOP");
						errFields.add(childNodeName.toLowerCase());
						break;
					}

					if ("bank_code".equalsIgnoreCase(childNodeName)) {
						if (childNode.getFirstChild() == null) {
							errList.add("VPBLKBNKCO");
							errFields.add(childNodeName.toLowerCase());
							break;
						}

						String bank_code = checkNull(genericUtility
								.getColumnValue("bank_code", currDom));
						System.out.println("bank_code ... " + bank_code);

						sql = "select count(*) from bank where bank_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bank_code.trim());
						rs = pstmt.executeQuery();
						if (rs.next()) {
							count = rs.getInt(1);
						}
						System.out.println("Value of Count: " + count);
						if (count <= 0) {
							errList.add("VPINVBNKCO");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						callPstRs(pstmt, rs);
					}

					if ("site_code".equalsIgnoreCase(childNodeName)) {
						if (childNode.getFirstChild() == null) {
							errList.add("VPBLKSTCOD");
							errFields.add(childNodeName.toLowerCase());
							break;
						}

						String site_code = checkNull(genericUtility
								.getColumnValue("site_code", currDom));
						System.out.println("site_code ... " + site_code);

						sql = "select count(*) from site where site_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, site_code.trim());
						rs = pstmt.executeQuery();
						if (rs.next()) {
							count = rs.getInt(1);
						}
						System.out.println("Value of Count: " + count);
						if (count <= 0) {
							errList.add("VPINVSTCD ");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						callPstRs(pstmt, rs);
					}

					if ("date_from".equalsIgnoreCase(childNodeName)) {
						if (childNode.getFirstChild() == null) {
							errList.add("VPBLKDATFR");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						String date_from = checkNull(genericUtility
								.getColumnValue("date_from", currDom));
						System.out.println("date_from ... " + date_from);

						String date_to = checkNull(genericUtility
								.getColumnValue("date_to", currDom));
						System.out.println("date_to ... " + date_to);
						// String date_from;
						// String date_to;
						Date dateFrom;
						Date dateTo;
						int errListSize;
						String errFldName;
						if (!date_to.isEmpty()) {
							dateFrom = new Date(date_from);
							dateTo = new Date(date_to);
							if ((!dateTo.after(dateFrom))
									&& (!dateTo.equals(dateFrom))) {
								errList.add("VPINVFRMTO");
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}

					if ("date_to".equalsIgnoreCase(childNodeName)) {
						if (childNode.getFirstChild() == null) {
							errList.add("VPBLKDATTO");
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						String date_from = checkNull(genericUtility
								.getColumnValue("date_from", currDom));
						System.out.println("date_from ... " + date_from);

						String date_to = checkNull(genericUtility
								.getColumnValue("date_to", currDom));
						System.out.println("date_to ... " + date_to);

						if (!date_from.isEmpty()) {
							Date dateFrom = new Date(date_from);
							Date dateTo = new Date(date_to);

							if ((dateTo.after(dateFrom))
									|| (dateTo.equals(dateFrom)))
								continue;
							errList.add("VPINVFRMTO");
							errFields.add(childNodeName.toLowerCase());
							break;
						}

					}

				}

			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if ((errList != null) && (errListSize > 0)) {
				for (cnt = 0; cnt < errListSize; cnt++) {
					errCode = (String) errList.get(cnt);
					errFldName = (String) errFields.get(cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) {
						String bifurErrString = errString.substring(
								errString.indexOf("<Errors>") + 8,
								errString.indexOf("<trace>"));
						bifurErrString = bifurErrString
								+ errString.substring(
										errString.indexOf("</trace>") + 8,
										errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."
								+ errStringXml);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			} else {
				errStringXml = new StringBuffer("");
			}
			errString = errStringXml.toString();
		} catch (Exception e) {
			System.out.println("Exception in StockTransferGrlIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if ((conn != null) && (!conn.isClosed()))
					conn.close();
			} catch (Exception e) {
				System.out.println("Exception :InvBankDtlsIC:wfValData :==>\n"
						+ e.getMessage());
				throw new ITMException(e);
			}
		}

		return errString;
	}

	private String errorType(Connection conn, String errorCode) {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
				msgType = rs.getString("MSG_TYPE");
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return msgType;
	}

	public void callPstRs(PreparedStatement pstmt, ResultSet rs) {
		try {
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private String checkNull(String inputVal) {
		if (inputVal == null) {
			inputVal = "";
		}
		return inputVal;
	}
}