package ibase.webitm.ejb.fin;

import ibase.utility.CommonConstants;
import ibase.webitm.utility.TransIDGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Util
{
  public static int updateMiscPayment(ArrayList tranIdList, Connection conn)
  {
    String sql = null;
    int upd = 0;
    String tranIdListStr = null;
    PreparedStatement pstmt = null;

    tranIdListStr = getListStr(tranIdList);

    sql = "update misc_payment set eff_date =? where tran_id in " + tranIdListStr;
    System.out.println("upd sql............." + sql);
    try {
      pstmt = conn.prepareStatement(sql);
      pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));

      upd = pstmt.executeUpdate();
    }
    catch (Exception ex) {
      ex.printStackTrace();
      upd = 0;
      try
      {
        pstmt.close();
        pstmt = null;
      }
      catch (Exception localException1)
      {
      }
    }
    finally
    {
      try
      {
        pstmt.close();
        pstmt = null; } catch (Exception localException2) {
      }
    }
    return upd;
  }

  public static String write(String filePath, String dataStr) {
    System.out.println("filePath :: " + filePath);
    System.out.println("dataStr :: " + dataStr);
    return nfFileOpen(filePath, dataStr);
  }

  public static String getUniqueFileName() {
    String currDtStr = null;
    Date currDt = null;
    currDt = new Date();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
    currDtStr = simpleDateFormat.format(currDt);
    return currDtStr;
  }

  private static String nfFileOpen(String asFilepath, String asString)
  {
    String lsErrcode = null;

    File ediFile = null;
    FileWriter ediFileWtr = null;
    try
    {
      ediFile = new File(asFilepath);
      ediFileWtr = new FileWriter(ediFile, true);
      System.out.println("asString::" + asString);
      int liLen = asString.length();

      if (ediFile == null)
      {
        lsErrcode = "VBFILEOPEN";
      }
      String lsWrite = asString;
      char[] writeCharArr = new char[lsWrite.length()];
      lsWrite.getChars(0, lsWrite.length(), writeCharArr, 0);
      ediFileWtr.write(writeCharArr);
    }
    catch (Exception ex) {
      lsErrcode = "VFLEIOERR";
      ex.printStackTrace();
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    finally
    {
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    return lsErrcode;
  }

  public static String getListStr(ArrayList tranIdList) {
    String listStr = null;
    int listLen = 0;
    listLen = tranIdList.size();
    listStr = "( ";
    for (int listIdx = 0; listIdx < listLen; listIdx++)
    {
      listStr = listStr + "'" + (String)tranIdList.get(listIdx) + "'" + ", ";
    }
    return listStr.substring(0, listStr.length() - 2) + " )";
  }

  public static String genDocText(String doc) {
    String formatedStr = null;
    formatedStr = "";
    int lengthDoc = doc.length();
    while (lengthDoc > 0)
    {
      if (lengthDoc > 70)
      {
        formatedStr = formatedStr + doc.substring(0, 70) + "@@@@@@@@@@@@@@@@@@@@@@" + "\n";
        doc = doc.substring(70);
      }
      else
      {
        formatedStr = formatedStr + doc + "@@@@@@@@@@@@@@@@@@@@@@";
        doc = "";
      }
      lengthDoc = doc.length();
    }
    return formatedStr;
  }

  public static String getBlankLines(int noBlankRows) {
    String blkStr = null;
    blkStr = "";
    String blankStr = "INV@                                                                     .";
    for (int i = 1; i < noBlankRows; i++)
    {
      blkStr = blkStr + blankStr + (i == noBlankRows - 1 ? "" : "\n");
    }
    return blkStr;
  }

  public static void EncriptFileICICI(ArrayList sourceFileList, String sourceLoc, String destinationLoc, String sundryType, String fileDescription) throws Exception {
    int noOfSourceFile = 0;
    noOfSourceFile = sourceFileList.size();
    System.out.println("manoharan 29/09/14 ICICI encription start sourceLoc [" + sourceLoc + "] destinationLoc [ " + destinationLoc + "]fileDescription[" + fileDescription + "]");
    for (int fileIndex = 0; fileIndex < noOfSourceFile; fileIndex++)
    {
      String fileName = null;
      fileName = (String)sourceFileList.get(fileIndex);
      fileName = fileDescription.trim() + fileName.trim();
      System.out.println("@@@@@@@@@ fileName[" + fileName + "]");

      String[] arg = { sourceLoc + fileName + ".txt", destinationLoc + fileName + ".enc" };
      if ("E".equalsIgnoreCase(sundryType))
      {
        Enc.main(arg);
      }
      else
      {
        enc128.main(arg);
      }
    }
  }

  public static void EncriptFileCITI(ArrayList sourceFileList, String sourceLoc, String destinationLoc) throws Exception {
    int noOfSourceFile = 0;

    System.out.println("manoharan 29/09/14 CITY encription start cmd /c start C:/SMIMETool/run/JSMin.bat");
    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/JSMin.bat");
  }

  public static void EncriptFileCITIAUS(ArrayList sourceFileList, String sourceLoc, String destinationLoc)
    throws Exception
  {
    int noOfSourceFile = 0;

    System.out.println("manoharan 29/09/14 CITY encription start cmd /c start C:/SMIMETool/run/JSMin.bat");
    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/JSMinAus.bat");
  }

  public static void EncriptFileSTANC(ArrayList sourceFileList, String sourceLoc, String destinationLoc)
    throws Exception
  {
    int noOfSourceFile = 0;

    System.out.println("STANC encription start cmd /c start C:/SMIMETool/run/STANCJSMin.bat");
    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/STANCJSMin.bat");
  }

  public static void EncriptFileCITIEMP(ArrayList sourceFileList, String sourceLoc, String destinationLoc)
    throws Exception
  {
    int noOfSourceFile = 0;

    System.out.println("manoharan 29/09/14 CITI EMP encription start cmd /c start C:/SMIMETool/run/JSMin.bat");
    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/JSMin.bat");
  }
  
  public static void EncriptFileCITIBATCH(ArrayList sourceFileList, String sourceLoc, String destinationLoc) throws Exception {
	    int noOfSourceFile = 0;

	    System.out.println("manoharan 29/09/14 CITY encription start cmd /c start C:/SMIMETool/run/JSMin.bat");
	    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/JSMin.bat");
	  }


  public static void InsertLog(ArrayList sourceFileList, String userId, Connection conn)
  {
    String tranId = null;
    PreparedStatement pStmt = null;
    ResultSet rs = null;

    String insSql = null;
    insSql = "insert into RPT_PRINT_LOG( TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL )   values( ?, ?, ?, ?, SYSDATE, ?, ? ) ";
    try
    {
      pStmt = conn.prepareStatement(insSql);
      int listLen = 0;
      listLen = sourceFileList.size();

      for (int listIdx = 0; listIdx < listLen; listIdx++)
      {
        tranId = generateTranId("w_rpt_print_log", userId, conn);
        pStmt.setString(1, tranId);
        pStmt.setString(2, "w_e_payment");
        pStmt.setString(3, (String)sourceFileList.get(listIdx));
        pStmt.setString(4, userId);
        pStmt.setInt(5, 1);
        pStmt.setString(6, "");

        pStmt.addBatch();
      }
      pStmt.executeBatch();
      pStmt.close(); 
      pStmt = null;
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    finally {
      try {
        if (pStmt != null)
          pStmt.close(); 
      } catch (Exception localException2) {
      }
      pStmt = null;
    }
  }

  private static String generateTranId(String windowName, String userId, Connection conn) throws Exception {
    Statement stmt = null;
    ResultSet rs = null;
    String sql = "";
    String tranId = "";
    String newKeystring = "";
    CommonConstants commonConstants = new CommonConstants();
    try
    {
      sql = "SELECT KEY_STRING, TRAN_ID_COL, nvl(REF_SER,'PEXRE')  FROM TRANSETUP WHERE TRAN_WINDOW = '" + windowName + "'";
      stmt = conn.createStatement();
      rs = stmt.executeQuery(sql);
      System.out.println("keyString :" + rs.toString());
      String keyString = "";
      String keyCol = "";
      String tranSer = "";
      if (rs.next())
      {
        keyString = rs.getString(1);
        keyCol = rs.getString(2);
        tranSer = rs.getString(3);
      }
      String xmlValues = "";
      System.out.println("keyCol" + keyCol);
      System.out.println("keyString" + keyString);
      System.out.println("tranSer" + tranSer);
      xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
      xmlValues = xmlValues + "<Header></Header>";
      xmlValues = xmlValues + "<Detail1>";
      xmlValues = xmlValues + "<tran_id></tran_id>";
      xmlValues = xmlValues + "</Detail1></Root>";
      System.out.println("xmlValues for tranid  :[" + xmlValues + "]");
      TransIDGenerator tg = new TransIDGenerator(xmlValues, userId, CommonConstants.DB_NAME);
      tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
    }
    catch (SQLException ex)
    {
      System.out.println("Exception ::" + sql + ex.getMessage() + ":");
      ex.printStackTrace();
      throw new Exception(ex);
    }
    catch (Exception e)
    {
      System.out.println("Exception ::" + e.getMessage() + ":");
      e.printStackTrace();
      throw new Exception(e);
    }
    System.out.println("tranId" + tranId);
    return tranId;
  }

  public static String normalizeStr(String str) {
    String[] restrictedChars = { ">", "<", "\"", ";", "{", "}", "[", "]", "\\", "|", "=", "*", "&", "^", "%", "$", "#", 
      "!", "~", "`", "'", "?", "-MAC" };

    int len = restrictedChars.length;

    for (int idx = 0; idx < len; idx++)
    {
      if ("&".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), "and");
      } else if ("#".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), "No");
      } else if ("-MAC".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " - MAC");
      }
      else
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      }
    }
    return str;
  }

  public static String normalizeStrICICI(String str) {
    String[] restrictedChars = { ">", "<", "\"", ";", "{", "}", "[", "]", "\\", "=", "*", "&", "^", "%", "$", "#", 
      "!", "~", "`", "'", "?", "-MAC", ":", ";", "''" };

    int len = restrictedChars.length;

    for (int idx = 0; idx < len; idx++)
    {
      if ("&".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      } else if ("#".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      } else if ("-MAC".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " - MAC");
      }
      else
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      }
    }
    return str;
  }

  public static String normalizeStrCitiCheck(String str)
  {
    String[] restrictedChars = { ">", "<", "\"", ";", "{", "}", "[", "]", "\\", "|", "=", "*", "&", "^", "%", "$", "#", 
      "!", "`", "'", "?", "-MAC" };

    int len = restrictedChars.length;

    for (int idx = 0; idx < len; idx++)
    {
      if ("&".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      } else if ("#".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      } else if ("-MAC".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      }
      else
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      }
    }
    return str;
  }

  private static String replaceChar(String str, String ch, String toStr)
  {
    StringBuffer bufferStr = null;
    bufferStr = new StringBuffer(str);

    int idxOf = 0;
    idxOf = bufferStr.indexOf(ch);
    while (idxOf > -1)
    {
      bufferStr = bufferStr.replace(idxOf, idxOf + 1, toStr);
      idxOf = bufferStr.indexOf(ch);
    }
    return bufferStr.toString();
  }

  public static String writeEpayCitiEmp(String filePath, String dataStr)
  {
    System.out.println("filePath :: " + filePath);
    System.out.println("dataStr :: " + dataStr);
    return nfFileOpenCiti(filePath, dataStr);
  }

  private static String nfFileOpenCiti(String asFilepath, String asString) {
    String lsErrcode = null;

    File ediFile = null;
    FileWriter ediFileWtr = null;
    try
    {
      ediFile = new File(asFilepath);
      ediFileWtr = new FileWriter(ediFile, true);
      System.out.println("asString::" + asString);
      int liLen = asString.length();
      String lsWrite = asString;
      char[] writeCharArr = new char[lsWrite.length()];
      lsWrite.getChars(0, lsWrite.length(), writeCharArr, 0);
      ediFileWtr.write(writeCharArr);
      lsErrcode = "success";
    }
    catch (Exception ex) {
      lsErrcode = "VFLEIOERR";
      ex.printStackTrace();
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    finally
    {
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    return lsErrcode;
  }

  public static String writeKotakEmp(String filePath, String dataStr)
  {
    System.out.println("filePath :: " + filePath);
    System.out.println("dataStr :: " + dataStr);
    return nfFileOpenKotak(filePath, dataStr);
  }

  private static String nfFileOpenKotak(String asFilepath, String asString) {
    String lsErrcode = null;

    File ediFile = null;
    FileWriter ediFileWtr = null;
    try
    {
      ediFile = new File(asFilepath);
      ediFileWtr = new FileWriter(ediFile, true);
      System.out.println("asString::" + asString);
      int liLen = asString.length();
      String lsWrite = asString;
      char[] writeCharArr = new char[lsWrite.length()];
      lsWrite.getChars(0, lsWrite.length(), writeCharArr, 0);
      ediFileWtr.write(writeCharArr);
      lsErrcode = "success";
    }
    catch (Exception ex) {
      lsErrcode = "VFLEIOERR";
      ex.printStackTrace();
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    finally
    {
      try
      {
        ediFileWtr.close();
        ediFileWtr = null;
        ediFile = null;
      } catch (Exception e) {
        lsErrcode = "VEFCLERR";
        e.printStackTrace();
      }
    }
    return lsErrcode;
  }

  public static void EncriptFileKOTAK(ArrayList sourceFileList, String sourceLoc, String destinationLoc) throws Exception {
    int noOfSourceFile = 0;

    System.out.println("manoharan 29/09/14 CITY encription start cmd /c start C:/SMIMETool/run/JSMin.bat");
    Runtime.getRuntime().exec("cmd /c start C:/SMIMETool/run/KOTAKJSMin.bat");
  }

  public static void encriptFileKotakSundry(ArrayList sourceFileList, String sourceLoc, String destinationLoc, String sundryType, String fileDescription) throws Exception
  {
    int noOfSourceFile = 0;
    noOfSourceFile = sourceFileList.size();
    System.out.println("manoharan 29/09/14 ICICI encription start sourceLoc [" + sourceLoc + "] destinationLoc [ " + destinationLoc + "]fileDescription[" + fileDescription + "]");
    for (int fileIndex = 0; fileIndex < noOfSourceFile; fileIndex++)
    {
      String fileName = null;
      fileName = (String)sourceFileList.get(fileIndex);
      fileName = fileDescription.trim() + fileName.trim();
      System.out.println("@@@@@@@@@ fileName[" + fileName + "]");

      String[] arg = { sourceLoc + fileName + ".txt", destinationLoc + fileName + ".enc" };
      if ("E".equalsIgnoreCase(sundryType))
      {
        Enc.main(arg);
      }
      else
      {
        enc128.main(arg);
      }
    }
  }

  public static String writeEpayKotakSundry(String filePath, String dataStr) {
    System.out.println("filePath :: " + filePath);
    System.out.println("dataStr :: " + dataStr);
    return nfFileOpen(filePath, dataStr);
  }

  public static String normalizeStrKotak(String str)
  {
    String[] restrictedChars = { ">", "<", "\"", ";", "{", "}", "[", "]", "\\", "|", "=", "*", "&", "^", "%", "$", "#", 
      "!", "`", "'", "?", "-MAC" };

    int len = restrictedChars.length;

    for (int idx = 0; idx < len; idx++)
    {
      if ("&".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), "and");
      } else if ("#".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), "No");
      } else if ("-MAC".equals(restrictedChars[idx]))
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " - MAC");
      }
      else
      {
        str = replaceChar(str, restrictedChars[idx].toString(), " ");
      }
    }
    return str;
  }
}