package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EpayKotakEmp extends ProcessEJB implements EpayKotakEmpLocal, EpayKotakEmpRemote {
	String userId = "";
	String sundryType = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	public ArrayList<String> tranIdList = null;

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("EpayKotakEmp :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				System.out.println("XML String :" + xmlString);
				headerDom = this.genericUtility.parseString(xmlString);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				System.out.println("XML String :" + xmlString2);
				detailDom = this.genericUtility.parseString(xmlString2);
			}

			rtrStr = this.getData(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var9) {
			System.out.println(
					"Exception :EpayKotakEmp :getData(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var9.getMessage() + ":");
			rtrStr = var9.getMessage();
		}

		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String errString = null;
		String errCode = "";
		String returnString = "";
		String bankCD = "";
		String getDataSql = "";
		String sql = "";
		String sql1 = "";
		String resultString = "";
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		new StringBuffer();
		String siteCode = null;
		String tranId = "";
		String refNo = "";
		Timestamp toDate = null;
		Timestamp fromDate = null;
		boolean recFound = false;
		double netAmt = 0.0D;
		double exchRate = 0.0D;
		int flag = 0;
		Timestamp confDate = null;
		Timestamp refDate = null;
		Timestamp tranDate = null;
		String currCode = "";
		String sundryCode = "";
		String sundryType = "";
		String finEntity = "";
		String confirmed = "";
		Connection conn = null;
		StringBuffer xmlStringBuffer = new StringBuffer("<?xml version = \"1.0\"?>");
		xmlStringBuffer.append("<DocumentRoot>");
		xmlStringBuffer.append("<description>").append("Datawindow Root").append("</description>");
		xmlStringBuffer.append("<group0>");
		xmlStringBuffer.append("<description>").append("Group0 description").append("</description>");
		xmlStringBuffer.append("<Header0>");

		String var61;
		try {
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
			this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId............." + this.userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String vouchNoFr = "";
			String vouchNoTo = "";
			String dateFr = "";
			String dateTo = "";
			String payMode = "";
			String bankCode = "";
			String frmSch = "";
			siteCode = this.genericUtility.getColumnValue("site_code", headerDom);
			vouchNoFr = this.genericUtility.getColumnValue("voucher_no_fr", headerDom);
			vouchNoTo = this.genericUtility.getColumnValue("voucher_no_to", headerDom);
			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
			if (vouchNoFr == null || vouchNoFr.trim().length() == 0) {
				vouchNoFr = "00";
			}

			if (vouchNoTo == null || vouchNoTo.trim().length() == 0) {
				vouchNoTo = "ZZ";
			}

			dateFr = this.genericUtility.getColumnValue("date_fr", headerDom);
			dateTo = this.genericUtility.getColumnValue("date_to", headerDom);
			if (dateFr != null && dateFr.trim().length() != 0) {
				if (dateTo != null && dateTo.trim().length() != 0) {
					System.out.println("dateFr :: " + dateFr);
					String dateFr1 = this.genericUtility.getValidDateString(dateFr,
							this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
					fromDate = Timestamp.valueOf(dateFr1 + " 00:00:00.0");
					String dateTo1 = this.genericUtility.getValidDateString(dateTo,
							this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
					toDate = Timestamp.valueOf(dateTo1 + " 00:00:00.0");
					System.out.println("fromDate..............." + fromDate);
					System.out.println("toDate..............." + toDate);
					payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
					bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
					System.out.println("payMode..............." + payMode);
					if (payMode != null && payMode.trim().length() != 0) {
						if (siteCode != null && siteCode.trim().length() != 0) {
							String bankFilePath = null;
							int cnt = 0;
							bankFilePath = "select count( * ) cnt from site where site_code = ? ";
							vPStmt = conn.prepareStatement(bankFilePath);
							vPStmt.setString(1, siteCode);
							vRs = vPStmt.executeQuery();
							if (vRs.next()) {
								cnt = vRs.getInt("cnt");
							}

							vRs.close();
							vRs = null;
							vPStmt.close();
							vPStmt = null;
							if (cnt == 0) {
								returnString = this.itmDBAccessEJB.getErrorString("", "VTSTINV", this.userId, "", conn);
								var61 = returnString;
								return var61;
							}

							if (bankCode != null && bankCode.trim().length() != 0) {
								bankFilePath = null;
								cnt = 0;
								bankFilePath = "select count( * ) cnt from bank where bank_code = ? ";
								vPStmt = conn.prepareStatement(bankFilePath);
								vPStmt.setString(1, bankCode);
								vRs = vPStmt.executeQuery();
								if (vRs.next()) {
									cnt = vRs.getInt("cnt");
								}

								vRs.close();
								vRs = null;
								vPStmt.close();
								vPStmt = null;
								if (cnt == 0) {
									returnString = this.itmDBAccessEJB.getErrorString("", "VTBNKINV", this.userId, "",
											conn);
									var61 = returnString;
									return var61;
								}

								bankFilePath = null;
								String bankFileFormat = null;
								String batchPath = null;
								String bankSql = null;
								bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
										+ bankCode + "'";
								System.out.println("bankSql :: " + bankSql);
								Statement bankStmt = null;
								ResultSet bankRs = null;

								try {
									bankStmt = conn.createStatement();
									bankRs = bankStmt.executeQuery(bankSql);
									if (bankRs.next()) {
										bankFilePath = bankRs.getString("filePath");
										bankFileFormat = bankRs.getString("bankformat");
										batchPath = bankRs.getString("batchpath");
									}
								} catch (Exception var92) {
									var92.printStackTrace();
								} finally {
									try {
										if (bankRs != null) {
											bankRs.close();
										}

										bankRs = null;
										if (bankStmt != null) {
											bankStmt.close();
										}

										bankStmt = null;
									} catch (Exception var91) {
										;
									}

								}

								if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
									if (bankFilePath != null && bankFilePath.trim().length() != 0) {
										String kotakSql = null;
										kotakSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE ,  MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE ,  MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,   MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE ,  MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY ,  MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,   MISC_PAYMENT.CONFIRMED   FROM  MISC_PAYMENT   WHERE ( MISC_PAYMENT.SITE_CODE = '"
												+ siteCode + "' ) " + "\tAND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
												+ "\tAND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
												+ "\tAND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
												+ "\tAND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
												+ "\tAND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
												+ "\tAND MISC_PAYMENT.EFF_DATE is null "
												+ "\tAND MISC_PAYMENT.PAY_MODE = '" + payMode + "' "
												+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
												+ "\tAND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end  in ('S','C') "
												+ "\t AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
												+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM MISC_PAYMENT_CANC "
												+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
												+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
												+ "\tAND exists( select 1 from  MISC_PAYDET "
												+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID "
												+ "\t\t\t\t\t\tAND MISC_PAYDET.SUNDRY_TYPE= '" + sundryType + "' "
												+ "\t\t) ";
										if (bankFileFormat.equalsIgnoreCase("KOTAK")) {
											sql = kotakSql;
											pstmt = conn.prepareStatement(kotakSql);
										}

										System.out.println("sql.............[" + sql + "]");
										pstmt.setTimestamp(1, fromDate);
										pstmt.setTimestamp(2, toDate);
										rs = pstmt.executeQuery();
										System.out.println("@vkc::rs >>" + rs);

										while (rs.next()) {
											System.out.println("@vkc::inside while >>" + rs);
											recFound = true;
											tranId = rs.getString("TRAN_ID");
											flag = 0;
											sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
											pstmt1 = conn.prepareStatement(sql);
											pstmt1.setString(1, tranId);
											rs1 = pstmt1.executeQuery();
											if (rs1.next()) {
												flag = rs1.getInt(1);
											}

											rs1.close();
											rs1 = null;
											pstmt1.close();
											pstmt1 = null;
											if (flag == 0) {
												currCode = rs.getString("CURR_CODE");
												tranDate = rs.getTimestamp("TRAN_DATE");
												refDate = rs.getTimestamp("REF_DATE");
												exchRate = rs.getDouble("EXCH_RATE");
												netAmt = rs.getDouble("NET_AMT");
												sundryCode = rs.getString("SUNDRY_CODE");
												siteCode = rs.getString("SITE_CODE");
												finEntity = rs.getString("FIN_ENTITY");
												bankCode = rs.getString("BANK_CODE");
												payMode = rs.getString("PAY_MODE");
												confirmed = rs.getString("CONFIRMED");
												refNo = rs.getString("REF_NO");
												confDate = rs.getTimestamp("CONF_DATE");
												refNo = refNo == null ? "" : refNo.trim();
												sundryType = rs.getString("SUNDRY_TYPE");
												System.out.println("@vkc::tranId >>" + tranId);
												System.out.println("@vkc::siteCode >>" + siteCode);
												System.out.println("@vkc::sundryCode >>" + sundryCode);
												System.out.println("@vkc::bankCode >>" + bankCode);
												System.out.println("@vkc::currCode >>" + currCode);
												System.out.println("@vkc::payMode >>" + payMode);
												System.out.println("@vkc::refNo >>" + refNo);
												System.out.println("@vkc::netAmt >>" + netAmt);
												System.out.println("@vkc::finEntity >>" + finEntity);
												System.out.println("@vkc::tranDate >>" + tranDate);
												System.out.println("@vkc::exchRate >>" + exchRate);
												System.out.println("@vkc::sundryType >>" + sundryType);
												System.out.println("@vkc::confirmed >>" + confirmed);
												System.out.println("@vkc::confDate >>" + confDate);
												System.out.println("@vkc::refDate >>" + refDate);
												xmlStringBuffer.append("<Detail2>");
												xmlStringBuffer.append("<tran_id>").append("<![CDATA[").append(tranId)
														.append("]]>").append("</tran_id>");
												xmlStringBuffer.append("<site_code>").append("<![CDATA[")
														.append(siteCode).append("]]>").append("</site_code>");
												xmlStringBuffer.append("<sundryCode>").append("<![CDATA[")
														.append(sundryCode).append("]]>").append("</sundryCode>");
												xmlStringBuffer.append("<bank_code>").append("<![CDATA[")
														.append(bankCode).append("]]>").append("</bank_code>");
												xmlStringBuffer.append("<curr_code>").append("<![CDATA[")
														.append(currCode).append("]]>").append("</curr_code>");
												xmlStringBuffer.append("<pay_mode>").append("<![CDATA[").append(payMode)
														.append("]]>").append("</pay_mode>");
												xmlStringBuffer.append("<ref_no>").append("<![CDATA[").append(refNo)
														.append("]]>").append("</ref_no>");
												xmlStringBuffer.append("<net_amt>").append("<![CDATA[").append(netAmt)
														.append("]]>").append("</net_amt>");
												xmlStringBuffer.append("<fin_entity>").append("<![CDATA[")
														.append(finEntity).append("]]>").append("</fin_entity>");
												xmlStringBuffer.append("<tran_date>").append("<![CDATA[")
														.append(tranDate).append("]]>").append("</tran_date>");
												xmlStringBuffer.append("<exch_rate>").append("<![CDATA[")
														.append(exchRate).append("]]>").append("</exch_rate>");
												xmlStringBuffer.append("<sundry_type>").append("<![CDATA[")
														.append(sundryType).append("]]>").append("</sundry_type>");
												xmlStringBuffer.append("<confirmed>").append("<![CDATA[")
														.append(confirmed).append("]]>").append("</confirmed>");
												xmlStringBuffer.append("<conf_date>").append("<![CDATA[")
														.append(confDate).append("]]>").append("</conf_date>");
												xmlStringBuffer.append("<ref_date>").append("<![CDATA[").append(refDate)
														.append("]]>").append("</ref_date>");
												xmlStringBuffer.append("</Detail2>");
											}
										}

										xmlStringBuffer.append("</Header0>");
										xmlStringBuffer.append("</group0>");
										xmlStringBuffer.append("</DocumentRoot>");
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
										System.out.println("frmSch[" + frmSch + "]recFound[" + recFound + "]");
										System.out.println("xmlStringBuffer[" + xmlStringBuffer + "]");
										if (xmlStringBuffer != null) {
											resultString = xmlStringBuffer.toString();
											System.out.println("ResultString....." + resultString);
										}

										return resultString;
									}

									errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
									var61 = errString;
									return var61;
								}

								errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
								var61 = errString;
								return var61;
							}

							returnString = this.itmDBAccessEJB.getErrorString("", "VTBANKBLK", this.userId, "", conn);
							var61 = returnString;
							return var61;
						}

						returnString = this.itmDBAccessEJB.getErrorString("", "VTSTBLK", this.userId, "", conn);
						var61 = returnString;
						return var61;
					}

					returnString = this.itmDBAccessEJB.getErrorString("", "VTPMBLK", this.userId, "", conn);
					var61 = returnString;
					return var61;
				}

				returnString = this.itmDBAccessEJB.getErrorString("", "VTTODTBLK", this.userId, "", conn);
				var61 = returnString;
				return var61;
			}

			returnString = this.itmDBAccessEJB.getErrorString("", "VTFRDTBLK", this.userId, "", conn);
			var61 = returnString;
		} catch (SQLException var95) {
			System.out.println(
					"SQLException :EpayKotakEmp :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var95.getMessage() + ":");
			throw new ITMException(var95);
		} catch (Exception var96) {
			System.out.println(
					"Exception :EpayKotakEmp :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var96.getMessage() + ":");
			throw new ITMException(var96);
		} finally {
			try {
				StringBuffer retTabSepStrBuff = null;
				if (rs != null) {
					rs.close();
				}

				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception var94) {
				errString = var94.getMessage();
				var94.printStackTrace();
				throw new ITMException(var94);
			}

		}

		return var61;
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String retStr = "";

		try {
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			System.out.println("dummy[process]::::::::::;;;" + windowName);
			System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);
			System.out.println("parsing xml condition");
			if (xmlString != null && xmlString.trim().length() != 0) {
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
				System.out.println("xmlString >> " + xmlString);
			}

			System.out.println("parsing xml2 condition");
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
				System.out.println("xmlString2 >> " + xmlString2);
			}

			retStr = this.process(headerDom, detailDom, windowName, xtraParams);
			return retStr;
		} catch (Exception var10) {
			System.out.println(
					"Exception : :process(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var10.getMessage() + ":");
			System.out.println("headerDom" + headerDom);
			System.out.println("xmlString >> " + xmlString);
			System.out.println("parsing xml2 condition");
			System.out.println("detailDom" + detailDom);
			System.out.println("xmlString2 >> " + xmlString2);
			var10.printStackTrace();
			throw new ITMException(var10);
		}
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String tranId = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		String retString = "";
		String textDoc = "";
		String nameOpt = "";
		String fileDescription = "";
		String bankCode = "";
		String payMode = "";
		String tempFileName = "";
		String filePath = "";
		String destinationPath = "";
		String fileDescr = "";
		Connection conn = null;

		label460 : {
			String var33;
			try {
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				System.out.println("@vkc::headerDom >>" + headerDom);
				System.out.println("@vkc::detailDom >>" + detailDom);
				System.out.println("@vkc::windowName >>" + windowName);
				System.out.println("@vkc::xtraParams >>" + xtraParams);
				this.tranIdList = new ArrayList();
				String jbossPath = null;
				jbossPath = CommonConstants.JBOSSHOME;
				this.sundryType = this.checkNull(this.genericUtility.getColumnValue("sundry_type", headerDom));
				System.out.println(">>>sundryType :: " + this.sundryType);
				nameOpt = this.genericUtility.getColumnValue("nameoption", headerDom);
				payMode = this.checkNull(this.genericUtility.getColumnValue("pay_mode", headerDom));
				bankCode = this.checkNull(this.genericUtility.getColumnValue("bank_code", headerDom));
				System.out.println(
						">>>sundryType[" + this.sundryType + "]payMode[" + payMode + "]bankCode[" + bankCode + "]");
				System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
				this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
				sql = " select descr from gencodes where fld_name = ? and mod_name = ?  and active = ? and sh_descr = ? and udf_str1= ? and udf_str2 = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "SITE_CODE");
				pstmt.setString(2, "W_EPAY_KOTAK_EMP");
				pstmt.setString(3, "Y");
				pstmt.setString(4, bankCode.trim());
				pstmt.setString(5, payMode.trim());
				pstmt.setString(6, this.sundryType.trim());
				rs = pstmt.executeQuery();
				if (rs.next()) {
					fileDescr = this.checkNull(rs.getString("descr")).trim();
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println(">>>fileDescr[" + fileDescr + "]");
				if (fileDescr.trim().length() != 0 && fileDescr != null) {
					sql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						filePath = this.checkNull(rs.getString("filePath")).trim();
						System.out.println("@vkc>>>filePath[" + filePath + "]");
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println(">>>filePath[" + filePath + "]");
					if (filePath != null && filePath.trim().length() != 0) {
						Node currDetail = null;
						NodeList detailList = null;
						detailList = detailDom.getElementsByTagName("Detail2");
						int noOfDetails = 0;
						noOfDetails = detailList.getLength();
						if (noOfDetails == 0) {
							System.out.println("@vkc::no data selected for process...");
							errString = this.itmDBAccessEJB.getErrorString("", "VTNODATSEL", this.userId);
							var33 = errString;
							return var33;
						}

						int flag = 0;

						for (int ctr = 0; ctr < noOfDetails; ++ctr) {
							this.tranIdList = new ArrayList();
							String tId = null;
							String tranDateStr = null;
							currDetail = detailList.item(ctr);
							tId = this.genericUtility.getColumnValueFromNode("tran_id", currDetail);
							tranDateStr = this.genericUtility.getColumnValueFromNode("tran_date", currDetail);
							System.out.println("tranDateStr :: " + tranDateStr);
							System.out.println("tranId :: " + tId);
							Timestamp tranDateTStmap = null;
							if (fileDescr != null && fileDescr.trim().length() > 5) {
								fileDescription = fileDescr.substring(5, fileDescr.length()).trim();
							} else {
								fileDescription = "";
							}

							System.out.println("@@@@@@@@ fileDescription[" + fileDescription + "]");
							System.out.println(">>>fileDescription[" + fileDescr + "]");
							tempFileName = fileDescription.trim() + tId.trim();
							System.out.println("tempFileName :: " + tempFileName);
							System.out.println("Tran ID::[" + tId + "]fileDescription[" + fileDescription + "]");
							sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tId);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								flag = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (flag > 0) {
								break;
							}

							if ("E".equalsIgnoreCase(this.sundryType)) {
								sql = "SELECT nvl(employee.bank_acct,'            ') ||'~'|| \t\t\tbank.ac_no||'~'|| \t\t\t'INR'||'~'|| \t\t\tsubstr(nvl(employee.bank_acct,'    '),1,4)||'~'|| \t\t\t'I'||'~'|| \t\t\tsum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0.00))||'~'|| \t\t\trpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30)||'~'|| \t\t\tsubstr(trim(ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"
										+ nameOpt + "')),1,150)||'~'|| "
										+ " to_char((CASE WHEN MISC_PAYMENT.REF_DATE < TRUNC(SYSDATE) THEN TRUNC(SYSDATE) ELSE MISC_PAYMENT.REF_DATE END),'dd/mm/yyyy') ";
								if ("N".equalsIgnoreCase("N")) {
									sql = sql + " ||'~'|| trim(employee.ifsc)";
								}

								sql = sql
										+ " DATAS FROM misc_paydet,          misc_payment,          employee, \t\t\tbank, \t\t\tbank_stan_serv    WHERE ( misc_payment.tran_id = misc_paydet.tran_id ) and          ( misc_paydet.sundry_code = employee.emp_code ) and \t\t\t( misc_paydet.sundry_type = 'E' ) and \t\t\t( misc_paydet.stan_code = bank_stan_serv.stan_code ) and          ( misc_payment.bank_code = bank_stan_serv.bank_code ) and \t\t\t( misc_payment.bank_code = bank.bank_code ) and \t\t\t( misc_payment.eff_date is null ) and          ( ( misc_paydet.sundry_type = 'E' ) AND          ( misc_payment.pay_mode = 'T' ) AND \tcase when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') AND          ( misc_payment.tran_id between '"
										+ tId + "'  and '" + tId + "' ) AND "
										+ "\t\t\t( misc_payment.tran_id not in (select payment_no from misc_payment_canc where tran_date >= ? ))) "
										+ "\tgroup by  nvl(employee.bank_acct,'            '), " + "\t\t\tbank.ac_no, "
										+ "\t\t\tsubstr(nvl(misc_payment.curr_code,'   '),1,3), "
										+ "\t\t\tsubstr(nvl(employee.bank_acct,'    '),1,4), "
										+ "\t\t\tsubstr(nvl(misc_payment.tran_type,' '),1,1), "
										+ "\t\t\trpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30), "
										+ "\t\t\tddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"
										+ nameOpt + "'), " + "\t\t\tmisc_payment.tran_date,MISC_PAYMENT.REF_DATE ";
								if ("N".equalsIgnoreCase("N")) {
									sql = sql + ", trim(employee.ifsc)";
								}

								sql = sql + " HAVING sum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0)) <> 0 ";
								sql = sql
										+ " UNION    SELECT nvl(employee.bank_acct,'            ') ||'~'|| \t\t\t bank.ac_no||'~'|| \t\t\t 'INR'||'~'|| \t\t\tsubstr(nvl(employee.bank_acct,'    '),1,4)||'~'|| \t\t\t'I'||'~'|| \t\t\tsum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0.00))||'~'|| \t\t\trpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30)||'~'|| \t\t\tsubstr(trim(ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"
										+ nameOpt + "')),1,150)||'~'|| "
										+ " to_char((CASE WHEN MISC_PAYMENT.REF_DATE < TRUNC(SYSDATE) THEN TRUNC(SYSDATE) ELSE MISC_PAYMENT.REF_DATE END),'dd/mm/yyyy') ";
								if ("N".equalsIgnoreCase("N")) {
									sql = sql + " ||'~'|| trim(employee.ifsc)";
								}

								sql = sql
										+ " DATAS FROM misc_paydet,         misc_payment,          employee, \t\t\tbank, \t\t\tbank_stan_serv, \t\t\tsales_pers     WHERE ( misc_payment.tran_id = misc_paydet.tran_id ) and          ( misc_paydet.sundry_code = sales_pers.sales_pers ) and \t\t\t( sales_pers.emp_code  = employee.emp_code ) and \t\t\t( misc_paydet.sundry_type = 'E' ) and \t\t\t( misc_paydet.stan_code = bank_stan_serv.stan_code ) and          ( misc_payment.bank_code = bank_stan_serv.bank_code ) and \t\t\t( misc_payment.bank_code = bank.bank_code ) and \t\t\t( misc_payment.eff_date is null ) and          ( ( misc_paydet.sundry_type = 'E' ) AND          ( misc_payment.pay_mode = 'T' ) AND  \tcase when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') AND          ( misc_payment.tran_id between '"
										+ tId + "' and '" + tId + "' ) AND "
										+ "\t\t\t( misc_payment.tran_id not in (select payment_no from misc_payment_canc where tran_date >= ? ))) "
										+ "\tgroup by  nvl(employee.bank_acct,'            '), " + "\t\t\tbank.ac_no, "
										+ "\t\t\tsubstr(nvl(misc_payment.curr_code,'   '),1,3), "
										+ "\t\t\tsubstr(nvl(employee.bank_acct,'    '),1,4), "
										+ "\t\t\tsubstr(nvl(misc_payment.tran_type,' '),1,1), "
										+ "\t\t\trpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30), "
										+ "\t\t   ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"
										+ nameOpt + "'), " + "\t\t\tmisc_payment.tran_date,MISC_PAYMENT.REF_DATE ";
								if ("N".equalsIgnoreCase("N")) {
									sql = sql + ", trim(employee.ifsc)";
								}

								sql = sql + " HAVING sum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0)) <> 0 ";
							}

							System.out.println("sql............." + sql);
							pstmt = conn.prepareStatement(sql);
							tranDateTStmap = Timestamp.valueOf(tranDateStr);
							if ("E".equalsIgnoreCase(this.sundryType)) {
								pstmt.setTimestamp(1, tranDateTStmap);
								pstmt.setTimestamp(2, tranDateTStmap);
							}

							rs = pstmt.executeQuery();
							StringBuffer dataBuff = new StringBuffer("");

							while (rs.next()) {
								textDoc = rs.getString("DATAS");
								dataBuff.append("\n" + textDoc);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							textDoc = dataBuff.toString();
							System.out.println("@vkc::textDoc >>" + textDoc);
							if (textDoc != null && textDoc.trim().length() > 0) {
								textDoc = Util.normalizeStrKotak(textDoc);
								errString = Util.writeKotakEmp(filePath + tempFileName + ".txt", textDoc.substring(1));
							}

							System.out.println("@vkc::errString >>" + errString);
							if (errString != null && errString.equals("success")) {
								this.tranIdList.add(tId);
								System.out.println("@vkc::tranIdList >>" + this.tranIdList);
								Util.InsertLog(this.tranIdList, this.userId, conn);
								Util.updateMiscPayment(this.tranIdList, conn);
							}

							this.tranIdList.clear();
							System.out.println("@vkc::tranIdList clear >>" + this.tranIdList);
						}

						if (flag > 0) {
							errString = this.itmDBAccessEJB.getErrorString("", "VTTXNRPT", this.userId);
							var33 = errString;
							return var33;
						}

						System.out.println("@vkc::errString #>>" + errString);
						errString = this.itmDBAccessEJB.getErrorString("", "PROCSUCC", this.userId);
						System.out.println("process completed .." + errString);
						break label460;
					}

					errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELO1", this.userId);
					var33 = errString;
					return var33;
				}

				System.out.println("inside fileDesc check");
				errString = this.itmDBAccessEJB.getErrorString("", "VTFILEDESC", this.userId);
				var33 = errString;
				return var33;
			} catch (Exception var47) {
				System.out.println("Exception EpayKotakEmp" + var47.getMessage());
				System.out.println("connection rollback.............");
				System.out.println("Returning Result " + errString);

				try {
					conn.rollback();
				} catch (Exception var46) {
					;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
				var47.printStackTrace();
				var33 = errString;
			} finally {
				try {
					if (rs != null) {
						rs.close();
					}

					rs = null;
					if (pstmt != null) {
						pstmt.close();
					}

					if (conn != null) {
						conn.close();
					}
				} catch (Exception var45) {
					System.out.println("Error In closing connection::==> " + var45);
					var45.printStackTrace();
				}

			}

			return var33;
		}

		System.out.println("returning EpayKotakEmp " + retString);
		return errString;
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}

		return input;
	}
}