
/***********************************
 * VALLABH KADAM
 * 2-FEB-15
 * EChqWritingPrc.java
 * Req id:- F14ASUN04
 * ****************************************/
package ibase.webitm.ejb.fin;

import ibase.webitm.utility.*;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import java.rmi.RemoteException;
import java.text.*;
import java.util.*;
import java.sql.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import ibase.webitm.utility.ITMException;
import java.io.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.ejb.Stateless;

@Stateless // added for ejb3

public class CitiBatPrc extends ProcessEJB implements CitiBatPrcLocal, CitiBatPrcRemote // SessionBean

{
	int MAXBLANKROWS = 33;
	String userId = "";
	// GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	String bankCD = null;

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("EpaymentPrcEJB :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				System.out.println("XML String :" + xmlString);
				headerDom = genericUtility.parseString(xmlString);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				System.out.println("XML String :" + xmlString2);
				detailDom = genericUtility.parseString(xmlString2);
			}

			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception e) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr;
	}// END OF GETDATA(1)

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String errString = null;
		String errCode = "", returnString = "";
		String getDataSql = "";
		String sql = "", sql1 = "";
		String resultString = "";
		ResultSet rs = null, rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		String siteCode = null, tranId = "", refNo = "";
		java.sql.Timestamp toDate = null;
		java.sql.Timestamp fromDate = null;
		boolean recFound = false;
		double netAmt = 0, exchRate = 0;
		int flag = 0;
		Timestamp confDate = null, refDate = null, tranDate = null;
		String currCode = "", sundryCode = "", sundryType = "", finEntity = "", confirmed = "", nameOption = "";
		Connection conn = null;

		try {
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId............." + userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String tran_id_from = "", tran_id_to = "", dateFr = "", dateTo = "", payMode = "", bankCode = "";
			siteCode = genericUtility.getColumnValue("site_code", headerDom);
			tran_id_from = genericUtility.getColumnValue("tran_id_from", headerDom);
			tran_id_to = genericUtility.getColumnValue("tran_id_to", headerDom);
			sundryType = genericUtility.getColumnValue("sundry_type", headerDom);
			nameOption = genericUtility.getColumnValue("nameoption", headerDom);
			payMode = genericUtility.getColumnValue("pay_mode", headerDom);
			System.out.println("siteCode :-[" + siteCode + "]");
			System.out.println("vouchNoFr :-[" + tran_id_from + "]");
			System.out.println("vouchNoTo :-[" + tran_id_to + "]");
			System.out.println("Get Data Sundry Type @@@@@@@@@@@:-[" + sundryType + "]");
			System.out.println("Get Data Name Option @@@@@@@@@@@:-[" + nameOption + "]");
			System.out.println("Get Data Pay mode @@@@@@@@@@@:-[" + payMode + "]");

//			sundryType="S";

			if (tran_id_from == null || tran_id_from.trim().length() == 0) {
				tran_id_from = "00";
			}
			if (tran_id_to == null || tran_id_to.trim().length() == 0) {
				tran_id_to = "ZZ";
			}

			String mainTblName = null, mainTblCode = null, bankTblName = null, bankTblCode = null;
			/*
			 * START >> Added by vinay c 13/02/2020 To validate sundry type is null or not
			 * and exist in master or not
			 */
			System.out.println("@vkc::checking SundyType:" + sundryType);
			if (sundryType == null || sundryType.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VBLSUND4", userId, "", conn);
				return returnString;
			} else if (sundryType != null && sundryType.trim().length() > 0) {
				sql = "SELECT COUNT(*) FROM SUNDRY_TYPE WHERE SUNDRY_TYPE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryType);
				rs = pstmt.executeQuery();
				if (rs.next()) {

					if (rs.getInt(1) == 0) {
						errCode = "VTSUND4";
						returnString = itmDBAccessEJB.getErrorString("", "VINVSUND4", userId, "", conn);
						return returnString;
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			} else {
				/*
				 * END >> Added by vinay c 13/02/2020 To validate sundry type is null or not and
				 * exist in master or not
				 */
				System.out.println("After Sundry Type :-[" + sundryType + "]");
				if ("T".equalsIgnoreCase(sundryType)) { // Transporter

					mainTblName = "TRANSPORTER";
					mainTblCode = "TRAN_CODE";
					bankTblName = "TRANSPORTER_BANK";
					bankTblCode = "TRAN_CODE";

				} else if ("P".equalsIgnoreCase(sundryType)) { // Sales Person

					mainTblName = "SALES_PERS";
					mainTblCode = "SALES_PERS";
					bankTblName = "SALES_PERS_BANK";
					bankTblCode = "SALES_PERS";

				} else if ("R".equalsIgnoreCase(sundryType)) { // Strategic Customer

					mainTblName = "STRG_CUSTOMER";
					mainTblCode = "SC_CODE";
					bankTblName = "STRG_CUST_BANK";
					bankTblCode = "SC_CODE";

				} else if ("L".equalsIgnoreCase(sundryType)) { // Loan Party

					mainTblName = "LOANPARTY";
					mainTblCode = "PARTY_CODE";
					bankTblName = "LOANPARTY_BANK";
					bankTblCode = "PARTY_CODE";

				} else if ("S".equalsIgnoreCase(sundryType)) {
					mainTblName = "SUPPLIER";
					mainTblCode = "SUPP_CODE";
					bankTblName = "SUPPLIER_BANK";
					bankTblCode = "SUPP_CODE";
				} else if ("C".equalsIgnoreCase(sundryType)) // Added by vinay c 13/02/2020 Added sundry type Customer
																// as value C.
				{
					// Customer
					mainTblName = "CUSTOMER";
					mainTblCode = "CUST_CODE";
					bankTblName = "CUSTOMER_BANK";
					bankTblCode = "CUST_CODE";

				} // END
				/* START >> Added by vinay c 13/02/2020 */
			}
			/* END >> Added by vinay c 13/02/2020 */
			dateFr = genericUtility.getColumnValue("date_fr", headerDom);
			dateTo = genericUtility.getColumnValue("date_to", headerDom);
			if (dateFr == null || dateFr.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VTFRDTBLK", userId, "", conn);
				return returnString;
			}
			if (dateTo == null || dateTo.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VTTODTBLK", userId, "", conn);
				return returnString;
			}
			System.out.println("dateFr :: " + dateFr);
			String dateFr1 = genericUtility.getValidDateString(dateFr, genericUtility.getApplDateFormat(),
					genericUtility.getDBDateFormat());
			String dateFr2 = genericUtility.getValidDateString(dateFr, "dd/MM/yy", "dd-MMM-yyyy");
			fromDate = java.sql.Timestamp.valueOf(dateFr1 + " 00:00:00.0");// 01/04/21
			String dateTo1 = genericUtility.getValidDateString(dateTo, genericUtility.getApplDateFormat(),
					genericUtility.getDBDateFormat());
			String dateTo2 = genericUtility.getValidDateString(dateTo, "dd/MM/yy", "dd-MMM-yyyy");
			toDate = java.sql.Timestamp.valueOf(dateTo1 + " 00:00:00.0");
			System.out.println("dateFr2 :: " + dateFr2);
			System.out.println("dateTo2 :: " + dateTo2);
			System.out.println("fromDate..............." + fromDate);
			System.out.println("toDate..............." + toDate);
			payMode = genericUtility.getColumnValue("pay_mode", headerDom);
			bankCode = genericUtility.getColumnValue("bank_code", headerDom);
			bankCD = bankCode;
			System.out.println("payMode..............." + payMode);

			if (payMode == null || payMode.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VTPMBLK", userId, "", conn);
				return returnString;
			}
			if (siteCode == null || siteCode.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VTSTBLK", userId, "", conn);
				return returnString;
			} else {
				String vSql = null;
				int cnt = 0;
				vSql = "select count( * ) cnt from site where site_code = ? ";
				vPStmt = conn.prepareStatement(vSql);
				vPStmt.setString(1, siteCode);
				vRs = vPStmt.executeQuery();
				if (vRs.next()) {
					cnt = vRs.getInt("cnt");
				}
				vRs.close();
				vRs = null;
				vPStmt.close();
				vPStmt = null;
				if (cnt == 0) {
					returnString = itmDBAccessEJB.getErrorString("", "VTSTINV", userId, "", conn);
					return returnString;
				}
			}

			if (bankCode == null || bankCode.trim().length() == 0) {
				returnString = itmDBAccessEJB.getErrorString("", "VTBANKBLK", userId, "", conn);
				return returnString;
			} else {
				String vSql = null;
				int cnt = 0;
				vSql = "select count( * ) cnt from bank where bank_code = ? ";
				vPStmt = conn.prepareStatement(vSql);
				vPStmt.setString(1, bankCode);
				vRs = vPStmt.executeQuery();
				if (vRs.next()) {
					cnt = vRs.getInt("cnt");
				}
				vRs.close();
				vRs = null;
				vPStmt.close();
				vPStmt = null;
				if (cnt == 0) {
					returnString = itmDBAccessEJB.getErrorString("", "VTBNKINV", userId, "", conn);
					return returnString;
				}
			}
			// get information from bank master and call the appropriate class start
			String bankFilePath = null;
			String bankFileFormat = null;
			String batchPath = null;

			String bankSql = null;
			System.out.println("BANK code:-[" + bankCode + "]");

			bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
					+ bankCode + "'";
			System.out.println("bankSql :: " + bankSql);
			Statement bankStmt = null;
			ResultSet bankRs = null;
			try {
				bankStmt = conn.createStatement();

				bankRs = bankStmt.executeQuery(bankSql);

				if (bankRs.next()) {
					bankFilePath = bankRs.getString("filePath");
					bankFileFormat = bankRs.getString("bankformat");
					batchPath = bankRs.getString("batchpath");
				}
			} catch (Exception bEx) {
				bEx.printStackTrace();
			} finally {
				try {
					if (bankRs != null) {
						bankRs.close();
					}
					bankRs = null;
					if (bankStmt != null) {
						bankStmt.close();
					}
					bankStmt = null;
				} catch (Exception tex) {
				}
			}
			if (bankFileFormat == null || bankFileFormat.trim().length() == 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", userId);// Not found
				return errString;

			}
			System.out.println("Bank File format :- [" + bankFileFormat + "]");
			if (bankFilePath == null || bankFilePath.trim().length() == 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTNOFLELOC", userId);// Not found
				return errString;
			}
			System.out.println("Bank File path :- [" + bankFilePath + "]");
			System.out.println("Batch path :- [" + batchPath + "]");
			/*
			 * START >> Commented by vinay c 13/02/2020 suggested by dylan sir String
			 * citiSql = null; citiSql =
			 * "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE , "
			 * +" MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE , "
			 * +" MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,  "
			 * +" MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE , "
			 * +" MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY , "
			 * +" MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,  "
			 * +" MISC_PAYMENT.CONFIRMED  " +" FROM  MISC_PAYMENT  "
			 * +" WHERE ( MISC_PAYMENT.SITE_CODE = '" + siteCode +"' ) "
			 * +"	AND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
			 * +"	AND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
			 * +"	AND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
			 * +"	AND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
			 * +"	AND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
			 * +"	AND MISC_PAYMENT.EFF_DATE is null " +"	AND MISC_PAYMENT.PAY_MODE = '" +
			 * payMode + "' " +" AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' " //
			 * +"	AND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   = 'S' "
			 * +"	AND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   IN('S','C') "
			 * //Add new wf_status (C) 18/MAR/15
			 * +"	 AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
			 * +"													FROM MISC_PAYMENT_CANC "
			 * +"													 WHERE " // +
			 * "TRAN_DATE >='01-SEP-1999' " //
			 * +"														SITE_CODE = '" +
			 * siteCode + "')"
			 * +"														SITE_CODE = '" +
			 * siteCode + "' AND CONFIRMED='Y')" // Add condition confirmed='Y' 18/MAR/15
			 * +"	AND exists( select 1 from  MISC_PAYDET,MISC_PAYMENT "
			 * +"					WHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID "
			 * +"						AND MISC_PAYDET.SUNDRY_TYPE= '" + sundryType + "' "
			 * +"		) "; END >> Commented by vinay c 13/02/2020 suggested by dylan sir
			 */
//				+"	AND exists ( select 1 from  " + bankTblName
//				+"					WHERE " + bankTblName + ".CONFIRMED = 'Y' "
//				+" 						and " + bankTblName + ".ACTIVE_YN = 'Y' "
//				+"						and " + bankTblName + ". " + bankTblCode + " in "
//				+"								(select misc_paydet.sundry_code "
//				+"									from misc_paydet,misc_payment "
//				+"								 where misc_paydet.tran_id = misc_payment.tran_id "
//				+"										and misc_paydet.sundry_type = '" + sundryType + "') "
//				+"		) ";
			/* START >> Added by vinay c 13/02/2020 suggested by dylan sir */
			String citiSql = null;
			citiSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE , "
					+ " MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE , "
					+ " MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,  "
					+ " MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE , "
					+ " MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY , "
					+ " MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,  "
					+ " MISC_PAYMENT.CONFIRMED  " + " FROM  MISC_PAYMENT  " + " WHERE ( MISC_PAYMENT.SITE_CODE = '"
					+ siteCode + "' ) " + "	AND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
					+ "	AND ( MISC_PAYMENT.TRAN_TYPE IN ('EC') )" // Change by Dylan
					+ " 	AND ( MISC_PAYMENT.TRAN_DATE <= ? ) " + "	AND ( MISC_PAYMENT.TRAN_ID >= '" + tran_id_from
					+ "' ) " + "	AND ( MISC_PAYMENT.TRAN_ID <= '" + tran_id_to + "' ) "
					+ "	AND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' " + "	AND MISC_PAYMENT.EFF_DATE is null "
					+ "	AND MISC_PAYMENT.PAY_MODE = '" + payMode + "' "
					// +" AND MISC_PAYMENT.CONFIRMED = 'Y' "
					// +" AND case when MISC_PAYMENT.STATUS is null then 'O' else
					// MISC_PAYMENT.STATUS end = 'S' " // 12/12/14 manoharan as per mail
					+ "	AND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') " // 09/01/15
																																// manoharan
																																// as
																																// per
																																// mail
					+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' " // 23/02/13 manoharan
					+ "	 AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
					+ "													FROM MISC_PAYMENT_CANC "
					+ "													 WHERE TRAN_DATE >='01-SEP-1999' "
					+ "														AND SITE_CODE = '" + siteCode + "')"
					+ "	AND exists( select 1 from  MISC_PAYDET "
					+ "					WHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID ) ";
			/* END >> Added by vinay c 13/02/2020 suggested by dylan sir */

			if (bankFileFormat.equalsIgnoreCase("CITI")) {
				sql = citiSql;
				pstmt = conn.prepareStatement(citiSql);
			}
			System.out.println("sqlcitiSql.............[" + citiSql + "]");
			System.out.println("sql.............[" + sql + "]");
			/*
			 * START >> Commented by vinay c 13/02/2020 Purpose to check by parameter_val
			 * sql ="select count(1) from RPT_PRINT_LOG where TRAN_ID__CTRL = ? "; pstmt1 =
			 * conn.prepareStatement( sql ); END
			 */
			pstmt.setString(1, dateFr2);
			pstmt.setString(2, dateTo2);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				recFound = true;
				tranId = rs.getString("TRAN_ID");
				flag = 0;
				/* START >> Added by vinay c 13/02/2020 Purpose to check by parameter_val */
				sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
				pstmt1 = conn.prepareStatement(sql);
				/* END */
				pstmt1.setString(1, tranId);
				rs1 = pstmt1.executeQuery();
				if (rs1.next()) {
					flag = rs1.getInt(1);
				}
				rs1.close();
				rs1 = null;
				// pstmt1.clearParameters(); // Commented by vinay c 13/02/2020
				/* START >> Added by vinay c 13/02/2020 closing pstmt1 */
				pstmt1.close();
				pstmt1 = null;
				/* END >> */
				if (flag == 0) {
					currCode = rs.getString("CURR_CODE");
					tranDate = rs.getTimestamp("TRAN_DATE");
					refDate = rs.getTimestamp("REF_DATE");
					exchRate = rs.getDouble("EXCH_RATE");
					netAmt = rs.getDouble("NET_AMT");
					sundryCode = rs.getString("SUNDRY_CODE");
					siteCode = rs.getString("SITE_CODE");
					finEntity = rs.getString("FIN_ENTITY");
					bankCode = rs.getString("BANK_CODE");
					payMode = rs.getString("PAY_MODE");
					confirmed = rs.getString("CONFIRMED");
					refNo = rs.getString("REF_NO");
					confDate = rs.getTimestamp("CONF_DATE");
					refNo = refNo == null ? "" : refNo.trim();

//						retTabSepStrBuff.append(tranId).append("\t");		
//						retTabSepStrBuff.append(siteCode).append("\t");
//						retTabSepStrBuff.append(sundryCode).append("\t");	
//						retTabSepStrBuff.append(bankCode).append("\t");	
//						retTabSepStrBuff.append(currCode).append("\t");
//						retTabSepStrBuff.append(payMode).append("\t");
//						retTabSepStrBuff.append(refNo).append("\t");
//						retTabSepStrBuff.append(netAmt).append("\t");
//						retTabSepStrBuff.append(finEntity).append("\t");
//						retTabSepStrBuff.append(tranDate).append("\t");
//						retTabSepStrBuff.append(exchRate).append("\t");
//						retTabSepStrBuff.append(sundryType).append("\t");
//						retTabSepStrBuff.append(confirmed).append("\t");
//						retTabSepStrBuff.append(confDate).append("\t");
//						retTabSepStrBuff.append(refDate).append("\t");
//						retTabSepStrBuff.append("\n");
					retTabSepStrBuff.append(tranId).append("\t");
					retTabSepStrBuff.append(sundryCode).append("\t");
					retTabSepStrBuff.append(payMode).append("\t");
					retTabSepStrBuff.append(bankCode).append("\t");
					retTabSepStrBuff.append(refNo).append("\t");
					retTabSepStrBuff.append(refDate).append("\t");
					retTabSepStrBuff.append(netAmt).append("\t");
					retTabSepStrBuff.append(currCode).append("\t");
					retTabSepStrBuff.append(siteCode).append("\t");
					retTabSepStrBuff.append(finEntity).append("\t");
					retTabSepStrBuff.append(tranDate).append("\t");
					retTabSepStrBuff.append(sundryType).append("\t");
					retTabSepStrBuff.append(confirmed).append("\t");
					retTabSepStrBuff.append(confDate).append("\t");
					retTabSepStrBuff.append(exchRate).append("\t");
					retTabSepStrBuff.append("\n");
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			// pstmt1.close(); // Commented by vinay c 13/02/2020
			// pstmt1 = null; // Commented by vinay c 13/02/2020

			if (!recFound) {
				returnString = itmDBAccessEJB.getErrorString("", "VTNODATA", userId, "", conn);
				conn.close();
				conn = null;
				return returnString;
			}
			/* START >> Added by vinay c 13/02/2020 To check retTabSepStrBuff is not null */
			if (retTabSepStrBuff != null) {
				/* END >> Added by vinay c 13/02/2020 To check retTabSepStrBuff is not null */
				resultString = retTabSepStrBuff.toString();
				System.out.println("ResultString....." + resultString);
				/* START >> Added by vinay c 13/02/2020 closing */
			}
			/* END >> */
		} catch (SQLException e) {
			System.out.println(
					"SQLException :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ e.getMessage() + ":");
			throw new ITMException(e);
		} catch (Exception e) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ e.getMessage() + ":");
			throw new ITMException(e);
		} finally {
			try {
				retTabSepStrBuff = null;
				if (rs != null) {
					rs.close();
				}
				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return resultString;
	}// END OF GETDATA(2)

	public String process() throws RemoteException, ITMException {
		System.out.println("I am in blank process .......EChqWritingPrc........");
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document detailDom = null;
		Document headerDom = null;
		// GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		String retStr = "";
		try {
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			System.out.println("windowName[process]::::::::::;;;" + windowName);
			System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);
		} catch (Exception e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception e) {
			System.out.println(
					"Exception :WorkorderPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
		}
		return retStr;
	}// END OF PROCESS (1)

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String retStr = "", tranId = "", gentext = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", errString = "";
		String retString = "", errCode = "", textDoc = "", textDoc1 = "", sundryType = "", bankCode = "";
		String fileName = "";
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String filePath = null;
		String hdrLines = null;

		String bankFilePath = null;
		String bankFileFormat = null;
		String batchPath = null;
		String siteCode = "", payMode = "", dateFr = "", dateTo = "", finParmDesc = "", nameOpt = ""; // Added by vinay
																										// c 13/02/2020
		int count = 0; // Added by vinay c 13/02/2020
		try {
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			// get information from bank master and call the appropriate class start
			String bankSql = null;
			sundryType = genericUtility.getColumnValue("sundry_type", headerDom);
			bankCode = genericUtility.getColumnValue("bank_code", headerDom);
			bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
					+ bankCode + "'";

			Statement bankStmt = null;
			ResultSet bankRs = null;
			try {
				bankStmt = conn.createStatement();

				bankRs = bankStmt.executeQuery(bankSql);

				if (bankRs.next()) {
					bankFilePath = bankRs.getString("filePath");
					bankFileFormat = bankRs.getString("bankformat");
					batchPath = bankRs.getString("batchpath");
				}
			} catch (Exception bEx) {
				bEx.printStackTrace();
			} finally {
				try {
					if (bankRs != null)
						bankRs.close();
					bankRs = null;
					if (bankStmt != null)
						bankStmt.close();
					bankStmt = null;
				} catch (Exception tex) {
				}
			}
			if (bankFileFormat == null || bankFileFormat.trim().length() == 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", userId);// Not found
				return errString;

			}
			if (bankFilePath == null || bankFilePath.trim().length() == 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTNOFLELOC", userId);// Not found
				return errString;
			}
			System.out.println(
					"VALLABH 03/FEB/15 in process bankCD [" + bankCD + "] bank_code [" + bankCode + "] bankFilePath ["
							+ bankFilePath + "] bankFileFormat [" + bankFileFormat + "] batchPath [" + batchPath + "]");

			Node currDetail = null;
			NodeList detailList = null;
			detailList = detailDom.getElementsByTagName("Detail2");
			int noOfDetails = 0;
			int flag = 0, flag1 = 0;
			noOfDetails = detailList.getLength();
			/*
			 * START >> Commented by vinay c 13/02/2020 Purpose to check parameter value.
			 * sql ="select count(1) from RPT_PRINT_LOG where TRAN_ID__CTRL = ? "; pstmt =
			 * conn.prepareStatement( sql ); END >>
			 */
			flag = 0;
			flag1 = 0;
			for (int ctr = 0; ctr < noOfDetails; ctr++) {
				String tId = null;
				currDetail = detailList.item(ctr);
				tId = genericUtility.getColumnValueFromNode("tran_id", currDetail);
				/* START >> Commented by vinay c 13/02/2020 Purpose to check parameter value. */
				sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
				pstmt = conn.prepareStatement(sql);
				/* END >> */
				pstmt.setString(1, tId);
				rs = pstmt.executeQuery();

				if (rs.next()) {
					flag = rs.getInt(1);
				}
				rs.close();
				rs = null;
				// pstmt.clearParameters(); // Commented by vinay c 13/02/2020
				/* START >> Added by vinay c 13/02/2020 closing pstmt */
				pstmt.close();
				pstmt = null;
				/* END >> Added by vinay c 13/02/2020 closing pstmt */
				/* START >> Added by vinay c 13/02/2020 To check effective date is not null */
				sql = "select count(1) from MISC_payment where MISC_PAYMENT.TRAN_ID =? and MISC_PAYMENT.EFF_DATE is not null ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					flag1 = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("vkc::flag >>" + flag + " || " + "vkc::flag1 >>" + flag1);
				/* END >> Added by vinay c 13/02/2020 To check effective date is not null */
				if (flag > 0 || flag1 > 0) // Added by vinay c 13/02/2020 condition flag1
				{
					break;
				}
			}
			// pstmt.close();
			// pstmt = null;

			if (flag > 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTTXNRPT", userId);
				return errString;
			}
			/* START >> Added by vinay c 13/02/2020 To check effective date is not null */
			if (flag1 > 0) {
				errString = itmDBAccessEJB.getErrorString("", "VTEFFDATE", userId);
				return errString;
			}
			/* END >> Added by vinay c 13/02/2020 To check effective date is not null */
			// -----------------------------
			/* START >> Added by vinay c 13/02/2020 */
			siteCode = genericUtility.getColumnValue("site_code", headerDom);
			payMode = genericUtility.getColumnValue("pay_mode", headerDom);
			dateFr = genericUtility.getColumnValue("date_fr", headerDom);
			dateTo = genericUtility.getColumnValue("date_to", headerDom);
			nameOpt = genericUtility.getColumnValue("nameoption", headerDom);// Added by vinay c
			fileName = siteCode.trim() + "/" + payMode.trim() + "/" + bankCode.trim() + "/" + nameOpt;

			filePath = bankFilePath;

			String destinationPath = null;
			destinationPath = batchPath;
			ArrayList tranIdList = null;
			String batchIdUpdate = ""; // Added by vinay c 04/03/2020 To update batch_id in misc_payment table for all
										// tran_id processed.
			System.out.println("Destinetion Path at PRC @@@@@@ :- [" + destinationPath + "]");
			if (bankFileFormat.equalsIgnoreCase("CITI")) {
				CitiBatWritingCITI eChqWrtCiti = null;
				eChqWrtCiti = new CitiBatWritingCITI();
				retString = eChqWrtCiti.process(headerDom, detailDom, windowName, xtraParams, bankFilePath,
						destinationPath, conn);
				tranIdList = eChqWrtCiti.tranIdList;
				// batchIdUpdate=eChqWrtCiti.batchIdUpdate; // Added by vinay c 04/03/2020 To
				// update batch_id in misc_payment table for all tran_id processed.
			}
			System.out.println("@vkc:batchIdUpdate >> " + retString); // Added by vinay c 04/03/2020 To update batch_id
																		// in misc_payment table for all tran_id
																		// processed.
			int upd = 0, upd1 = 0;
			// upd = Util.updateMiscPayment( tranIdList, conn ); // Commented by vinay c
			// 13/02/2020

			/*
			 * START >> Added by vinay 13/02/2020 To update effective date and reference
			 * number in misc_payment table
			 */
//			upd = updateMiscPayment( tranIdList,batchIdUpdate, conn ); // Added by vinay c 04/03/2020 Pass batchIdUpdate to update batch_id in misc_payment table for all tran_id processed.
			/*
			 * END >> Added by vinay 13/02/2020 To update effective date and reference
			 * number in misc_payment table
			 */
			// upd = updateMiscPayment(tranIdList, batchIdUpdate, conn);
			/*
			 * START >> Added by vinay 13/02/2020 To update ref_no as tran_id in
			 * banktran_log table
			 */
			upd1 = updateBankTranLog(tranIdList, conn);
			/*
			 * END >> Added by vinay 13/02/2020 To update ref_no as tran_id in banktran_log
			 * table
			 */

			if (tranIdList != null && tranIdList.size() > 0) {
				System.out.println("Tran id generation");
				Util.InsertLog(tranIdList, userId, conn);
				insertPrintCtrl(tranIdList, fileName, userId, conn);// Added by vinay c to add transaction 18/02/20
			}

			if (retString.equalsIgnoreCase("success")) {
				System.out.println("@vkc::commiting connection.............");
				conn.commit();
				// errString = itmDBAccessEJB.getErrorString("","VTEPSUCC",userId);
				errString = itmDBAccessEJB.getErrorString("", "PROCSUCC", userId); // added by sagar on 09/02/15
				System.out.println("process completed .." + errString);
				retString = errString;
			} else {
				System.out.println("@vkc::connection rollback.............");
				System.out.println("Returning Result " + errString);
				conn.rollback();
				errString = itmDBAccessEJB.getErrorString("", "VTEPFAIL", userId);
				return errString;
			}

			// get information from bank master and call the appropriate class end
		} catch (Exception e) {
			System.out.println("Exception EpaymentPrcEJB" + e.getMessage());
			System.out.println("connection rollback.............");
			System.out.println("Returning Result " + errString);
			try {
				conn.rollback();
			} catch (Exception ex) {
			}
			errString = itmDBAccessEJB.getErrorString("", "VTEPFAIL", userId);

			e.printStackTrace();
			return errString;
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				System.out.println("Error In closing connection::==> " + e);
				e.printStackTrace();
			}
		}
		System.out.println("returning EpaymentPrcEJB   " + retString);
		return (retString);
	}

	/*
	 * START >> Added by vinay 13/02/2020 To update effective date,reference number
	 * and batch_id in misc_payment table
	 */
	/*
	 * public static int updateMiscPayment(ArrayList tranIdList,String
	 * batch_id,Connection conn) { String sqll = null; int upd = 0; String
	 * tranIdListStr = null; PreparedStatement pstmt2 = null;
	 * 
	 * System.out.println("@narendra batch_id : "+batch_id);
	 * 
	 * //tranIdListStr = getListStr(tranIdList); Commented by vinay 20/05/2019 //sql
	 * = "update misc_payment set eff_date =? , batch_id= ? where tran_id in " // +
	 * tranIdListStr; //System.out.println("upd sql............." + sql); Commented
	 * by vinay 20/05/2019 try {
	 * 
	 * START >> Added by vinay 20/05/2019 String tIdList=null; //boolean
	 * updatedValue=false;
	 * System.out.println("Processing Transaction id list >>"+tranIdList);
	 * //System.out.println("updatedValue>>"+updatedValue); for(int
	 * i=0;i<tranIdList.size();i++) { tIdList=String.valueOf(tranIdList.get(i));
	 * System.out.println("TranIdList>>"+tranIdList.get(i)); sqll =
	 * "update misc_payment set eff_date =? , batch_id= ?,ref_no=? where tran_id=?";
	 * System.out.println("upd sql............." + sqll);
	 * System.out.println("BEFORE batch_id: "+batch_id); END >> Added by vinay
	 * 20/05/2019 pstmt2 = conn.prepareStatement(sqll); pstmt2.setTimestamp(1, new
	 * Timestamp(System.currentTimeMillis())); pstmt2.setString(2,batch_id);
	 * System.out.println("AFTER batch_id: "+batch_id); START >> Added by vinay
	 * 20/05/2019 pstmt2.setString(3,tIdList); pstmt2.setString(4,tIdList); END >>
	 * Added by vinay 20/05/2019 upd = pstmt2.executeUpdate(); if(upd > 0) {
	 * conn.commit(); } START >> Added by vinay 20/05/2019 }
	 * pstmt2.close();pstmt2=null;
	 * 
	 * for(int i=0;i<tranIdList.size();i++) {
	 * tIdList=String.valueOf(tranIdList.get(i));
	 * System.out.println("TranIdList>>"+tranIdList.get(i)); sqll
	 * ="update banktran_log set ref_no=? where tran_no=?"; pstmt2=
	 * conn.prepareStatement(sqll); pstmt2.setString(1,tIdList);
	 * pstmt2.setString(2,tIdList); upd=pstmt2.executeUpdate(); }
	 * 
	 * pstmt2.close();pstmt2=null;
	 * 
	 * END >> Added by vinay 20/05/2019
	 * 
	 * } catch (Exception ex) { ex.printStackTrace(); upd = 0; try { pstmt2.close();
	 * pstmt2 = null; } catch (Exception localException1) { } } finally { try {
	 * pstmt2.close(); pstmt2 = null; } catch (Exception localException2) { } }
	 * return upd; }//VJ
	 */
	public static int updateBankTranLog(ArrayList tranIdList, Connection conn) {
		String sql = null;
		int upd1 = 0;
		PreparedStatement pstmt = null;
		System.out.println("@vkc::Processing Transaction id list >>" + tranIdList);
		System.out.println("@vkc::upd1 >>" + upd1);

		try {
			for (int i = 0; i < tranIdList.size(); i++) {
				String tIdList = (String) tranIdList.get(i);
				System.out.println("TranIdList>>" + tranIdList.get(i));
				sql = "update banktran_log set ref_no = ? where tran_no = ? ";
				System.out.println("upd1 sql............." + sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tIdList);
				pstmt.setString(2, tIdList);
				upd1 = pstmt.executeUpdate();
				System.out.println("@vkc::upd1::for loop >>" + upd1);
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			upd1 = 0;
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return upd1;
	}
	/*
	 * END >> Added by vinay 13/02/2020 To update ref_no as tran_id in banktran_log
	 * table
	 */

	/* START >> Added by vinay 13/02/2020 insert in rpt_print_ctrl table */

	public static void insertPrintCtrl(ArrayList sourceFileList, String fileName, String userId, Connection conn) {
		String tranId = null;
		PreparedStatement pStmt = null;
		String insSql = null;
		insSql = "insert into RPT_PRINT_CTRL( TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID, PRINTED_ON)  values( ?, ?, ?, ?, SYSDATE) ";
		try {
			pStmt = conn.prepareStatement(insSql);
			int listLen = 0;
			listLen = sourceFileList.size();

			for (int listIdx = 0; listIdx < listLen; listIdx++) {
				tranId = (String) sourceFileList.get(listIdx);
				pStmt.setString(1, tranId);
				pStmt.setString(2, "w_echq_writing");
				pStmt.setString(3, fileName);
				pStmt.setString(4, userId);
				pStmt.addBatch();
			}
			pStmt.executeBatch();
			pStmt.close();
			pStmt = null;
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				if (pStmt != null)
					pStmt.close();
			} catch (Exception localException2) {
				localException2.printStackTrace();
			}
			pStmt = null;
		}
	}

	/* END >> Added by vinay 13/02/2020 insert in rpt_print_ctrl table */
}