package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EpaymentCityPrc extends ProcessEJB implements EpaymentCityPrcLocal, EpaymentCityPrcRemote {
	int MAXBLANKROWS = 33;
	String userId = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	String bankCD = null;

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("EpaymentPrcEJB :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				System.out.println("XML String :" + xmlString);
				headerDom = this.genericUtility.parseString(xmlString);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				System.out.println("XML String :" + xmlString2);
				detailDom = this.genericUtility.parseString(xmlString2);
			}

			rtrStr = this.getData(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var9) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var9.getMessage() + ":");
			rtrStr = var9.getMessage();
		}

		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String errString = null;
		String errCode = "";
		String returnString = "";
		String getDataSql = "";
		String sql = "";
		String sql1 = "";
		String resultString = "";
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		String siteCode = null;
		String tranId = "";
		String refNo = "";
		String finDescr = "";
		String bankNameBen = "";
		Timestamp toDate = null;
		Timestamp fromDate = null;
		boolean recFound = false;
		double netAmt = 0.0D;
		double exchRate = 0.0D;
		double checkAmount = 0.0D;
		int flag = 0;
		Timestamp confDate = null;
		Timestamp refDate = null;
		Timestamp tranDate = null;
		Timestamp valueDate = null;
		String currCode = "";
		String sundryCode = "";
		String sundryType = "";
		String finEntity = "";
		String confirmed = "";
		String beneficiaryName = "";
		String beneficiaryBank = "";
		String beneficiaryACNo = "";
		String localPaymentsDetails = "";
		String nameOfRemitter = "";
		String SundryType = "";
		String bankAccNo = "";
		String sundryName = "";
		String bankAcctBen = "";
		String ifscCode = "";
		Connection conn = null;

		String var78;
		try {
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
			this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId............." + this.userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String vouchNoFr = "";
			String vouchNoTo = "";
			String dateFr = "";
			String dateTo = "";
			String payMode = "";
			String bankCode = "";
			String frmSch = "";
			siteCode = this.genericUtility.getColumnValue("site_code", headerDom);
			vouchNoFr = this.genericUtility.getColumnValue("voucher_no_fr", headerDom);
			vouchNoTo = this.genericUtility.getColumnValue("voucher_no_to", headerDom);
			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
			if (vouchNoFr == null || vouchNoFr.trim().length() == 0) {
				vouchNoFr = "00";
			}

			if (vouchNoTo == null || vouchNoTo.trim().length() == 0) {
				vouchNoTo = "ZZ";
			}

			String mainTblName = null;
			String mainTblCode = null;
			String bankTblName = null;
			String bankTblCode = null;
			if ("T".equalsIgnoreCase(sundryType)) {
				mainTblName = "TRANSPORTER";
				mainTblCode = "TRAN_CODE";
				bankTblName = "TRANSPORTER_BANK";
				bankTblCode = "TRAN_CODE";
			} else {
				if (!"S".equalsIgnoreCase(sundryType)) {
					errString = this.itmDBAccessEJB.getErrorString("", "VTNODATA", this.userId, "", conn);
					System.out.println("process completed .." + errString);
					var78 = errString;
					return var78;
				}

				mainTblName = "SUPPLIER";
				mainTblCode = "SUPP_CODE";
				bankTblName = "SUPPLIER_BANK";
				bankTblCode = "SUPP_CODE";
			}

			dateFr = this.genericUtility.getColumnValue("date_fr", headerDom);
			dateTo = this.genericUtility.getColumnValue("date_to", headerDom);
			frmSch = this.checkNull(this.genericUtility.getColumnValue("frm_sch", headerDom));
			System.out.println("frmSch@@@@@@@@@@==" + frmSch);
			if (dateFr != null && dateFr.trim().length() != 0) {
				if (dateTo != null && dateTo.trim().length() != 0) {
					System.out.println("dateFr :: " + dateFr);
					String dateFr1 = this.genericUtility.getValidDateString(dateFr,
							this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
					fromDate = Timestamp.valueOf(dateFr1 + " 00:00:00.0");
					String dateTo1 = this.genericUtility.getValidDateString(dateTo,
							this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
					toDate = Timestamp.valueOf(dateTo1 + " 00:00:00.0");
					System.out.println("fromDate..............." + fromDate);
					System.out.println("toDate..............." + toDate);
					payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
					bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
					this.bankCD = bankCode;
					System.out.println("payMode..............." + payMode);
					if (siteCode != null && siteCode.trim().length() != 0) {
						String bankFilePath = null;
						int cnt = 0;
						bankFilePath = "select count( * ) cnt from site where site_code = ? ";
						vPStmt = conn.prepareStatement(bankFilePath);
						vPStmt.setString(1, siteCode);
						vRs = vPStmt.executeQuery();
						if (vRs.next()) {
							cnt = vRs.getInt("cnt");
						}

						vRs.close();
						vRs = null;
						vPStmt.close();
						vPStmt = null;
						if (cnt == 0) {
							returnString = this.itmDBAccessEJB.getErrorString("", "VTSTINV", this.userId, "", conn);
							var78 = returnString;
							return var78;
						}

						if (bankCode != null && bankCode.trim().length() != 0) {
							bankFilePath = null;
							cnt = 0;
							bankFilePath = "select count( * ) cnt from bank where bank_code = ? ";
							vPStmt = conn.prepareStatement(bankFilePath);
							vPStmt.setString(1, bankCode);
							vRs = vPStmt.executeQuery();
							if (vRs.next()) {
								cnt = vRs.getInt("cnt");
							}

							vRs.close();
							vRs = null;
							vPStmt.close();
							vPStmt = null;
							if (cnt == 0) {
								returnString = this.itmDBAccessEJB.getErrorString("", "VTBNKINV", this.userId, "",
										conn);
								var78 = returnString;
								return var78;
							}

							bankFilePath = null;
							String bankFileFormat = null;
							String batchPath = null;
							String bankSql = null;
							bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
									+ bankCode + "'";
							System.out.println("bankSql :: " + bankSql);
							Statement bankStmt = null;
							ResultSet bankRs = null;

							try {
								bankStmt = conn.createStatement();
								bankRs = bankStmt.executeQuery(bankSql);
								if (bankRs.next()) {
									bankFilePath = bankRs.getString("filePath");
									bankFileFormat = bankRs.getString("bankformat");
									System.out.println("bankFileFormat.............[" + bankFileFormat + "]");
									batchPath = bankRs.getString("batchpath");
								}
							} catch (Exception var110) {
								var110.printStackTrace();
							} finally {
								try {
									if (bankRs != null) {
										bankRs.close();
									}

									bankRs = null;
									if (bankStmt != null) {
										bankStmt.close();
									}

									bankStmt = null;
								} catch (Exception var109) {
									;
								}

							}

							if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
								if (bankFilePath != null && bankFilePath.trim().length() != 0) {
									String citySql = null;
									citySql = "SELECT MISC_PAYMENT.FIN_ENTITY ,FINENT.DESCR,  MISC_PAYMENT.SITE_CODE,  MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE,  MISC_PAYMENT.NET_AMT,  MISC_PAYMENT.BANK_CODE,   SUPPLIER_BANK.BANK_NAME__BEN, SUPPLIER_BANK.BANK_ACCT_NO__BEN,  BANK.AC_NO,BANK.IFSC_CODE, MISC_PAYMENT.CONF_DATE,MISC_PAYMENT.CONFIRMED,  MISC_PAYMENT.REF_NO,  MISC_PAYMENT.REF_DATE, MISC_PAYMENT.CURR_CODE,   MISC_PAYMENT.EXCH_RATE, MISC_PAYMENT.SUNDRY_TYPE, MISC_PAYMENT.SUNDRY_CODE,  DDF_SUNDRY_NAME(MISC_PAYMENT.SUNDRY_TYPE,MISC_PAYMENT.SUNDRY_CODE,'C') AS SUNDRY_NAME FROM MISC_PAYMENT , SUPPLIER_BANK , BANK , FINENT  WHERE ( MISC_PAYMENT.SITE_CODE = '"
											+ siteCode + "' ) " + " AND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
											+ " AND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
											+ " AND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
											+ " AND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
											+ " AND MISC_PAYMENT.PAY_MODE = 'N'" + " AND MISC_PAYMENT.EFF_DATE IS NULL"
											+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
											+ " AND MISC_PAYMENT.SUNDRY_CODE = SUPPLIER_BANK.SUPP_CODE "
											+ " AND SUPPLIER_BANK.ACTIVE_YN='Y' " + " AND SUPPLIER_BANK.CONFIRMED='Y' "
											+ " AND MISC_PAYMENT.BANK_CODE = BANK.BANK_CODE "
											+ " AND MISC_PAYMENT.FIN_ENTITY = FINENT.FIN_ENTITY "
											+ " AND MISC_PAYMENT.CONFIRMED='Y' "
											+ " AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT MISC_PAYMENT_CANC.PAYMENT_NO FROM MISC_PAYMENT_CANC WHERE MISC_PAYMENT_CANC.CONFIRMED='Y') "
											+ " AND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end  in ('S','C') "
											+ " AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM MISC_PAYMENT_CANC "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
											+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
											+ " AND exists( select 1 from  MISC_PAYDET "
											+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID "
											+ "\t\t\t\t\t\tAND MISC_PAYDET.SUNDRY_TYPE= '" + sundryType + "' "
											+ "\t\t) " + " AND exists ( select 1 from  " + bankTblName
											+ "\t\t\t\t\tWHERE " + bankTblName + ".CONFIRMED = 'Y' "
											+ " \t\t\t\t\t\tand " + bankTblName + ".ACTIVE_YN = 'Y' "
											+ "\t\t\t\t\t\tand " + bankTblName + ". " + bankTblCode + " in "
											+ "\t\t\t\t\t\t\t\t(select misc_paydet.sundry_code "
											+ "\t\t\t\t\t\t\t\t\tfrom misc_paydet "
											+ "\t\t\t\t\t\t\t\t where misc_paydet.tran_id = misc_payment.tran_id "
											+ "\t\t\t\t\t\t\t\t\t\tand misc_paydet.sundry_type = '" + sundryType + "') "
											+ "\t\t) order by tran_id ";
									System.out.println("459 Inside siteCode [" + siteCode + "] vouchNoFr [" + vouchNoFr
											+ "] vouchNoTo [" + vouchNoTo + "] sundryType [" + sundryType
											+ "] bankCode [" + bankCode + "] bankTblCode [" + bankTblCode
											+ "] bankTblName [" + bankTblName + "]");
									if (bankFileFormat.equalsIgnoreCase("CITIAUS")) {
										sql = citySql;
										pstmt = conn.prepareStatement(citySql);
									}

									System.out.println(
											"sql.............[" + sql + "]  bankFileFormat [" + bankFileFormat + "]");
									pstmt.setTimestamp(1, fromDate);
									pstmt.setTimestamp(2, toDate);
									rs = pstmt.executeQuery();

									while (rs.next()) {
										recFound = true;
										tranId = rs.getString("TRAN_ID");
										flag = 0;
										sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, tranId);
										rs1 = pstmt1.executeQuery();
										if (rs1.next()) {
											flag = rs1.getInt(1);
										}

										rs1.close();
										rs1 = null;
										pstmt1.close();
										pstmt1 = null;
										if (flag == 0) {
											siteCode = rs.getString("SITE_CODE");
											sundryCode = rs.getString("SUNDRY_CODE");
											bankCode = rs.getString("BANK_CODE");
											currCode = rs.getString("CURR_CODE");
											refNo = rs.getString("REF_NO");
											netAmt = rs.getDouble("NET_AMT");
											finEntity = rs.getString("FIN_ENTITY");
											tranDate = rs.getTimestamp("TRAN_DATE");
											exchRate = rs.getDouble("EXCH_RATE");
											confirmed = rs.getString("CONFIRMED");
											confDate = rs.getTimestamp("CONF_DATE");
											refDate = rs.getTimestamp("REF_DATE");
											finDescr = rs.getString("DESCR");
											bankNameBen = rs.getString("BANK_NAME__BEN");
											bankAcctBen = rs.getString("BANK_ACCT_NO__BEN");
											bankAccNo = rs.getString("AC_NO");
											ifscCode = rs.getString("IFSC_CODE");
											sundryName = rs.getString("SUNDRY_NAME");
											refNo = refNo == null ? "" : refNo.trim();
											retTabSepStrBuff.append(tranId).append("\t");
											retTabSepStrBuff.append(siteCode).append("\t");
											retTabSepStrBuff.append(sundryCode).append("\t");
											retTabSepStrBuff.append(bankCode).append("\t");
											retTabSepStrBuff.append(currCode).append("\t");
											retTabSepStrBuff.append(refNo).append("\t");
											retTabSepStrBuff.append(netAmt).append("\t");
											retTabSepStrBuff.append(finEntity).append("\t");
											retTabSepStrBuff.append(tranDate).append("\t");
											retTabSepStrBuff.append(exchRate).append("\t");
											retTabSepStrBuff.append(sundryType).append("\t");
											retTabSepStrBuff.append(confirmed).append("\t");
											retTabSepStrBuff.append(confDate).append("\t");
											retTabSepStrBuff.append(refDate).append("\t");
											retTabSepStrBuff.append(finDescr).append("\t");
											retTabSepStrBuff.append(bankNameBen).append("\t");
											retTabSepStrBuff.append(sundryName).append("\t");
											retTabSepStrBuff.append(bankAcctBen).append("\t");
											retTabSepStrBuff.append(bankAccNo).append("\t");
											retTabSepStrBuff.append(ifscCode).append("\t");
											retTabSepStrBuff.append("\n");
										}
									}

									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									System.out.println("frmSch[" + frmSch + "]recFound[" + recFound + "]");
									if (!recFound) {
										System.out.println("Match@@@@@");
										returnString = this.itmDBAccessEJB.getErrorString("", "VTNODATA", this.userId,
												"", conn);
										conn.close();
										conn = null;
										var78 = returnString;
										return var78;
									}

									System.out.println("retTabSepStrBuff[" + retTabSepStrBuff + "]");
									if (retTabSepStrBuff != null) {
										resultString = retTabSepStrBuff.toString();
										System.out.println("ResultString....." + resultString);
									}

									return resultString;
								}

								errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
								var78 = errString;
								return var78;
							}

							errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
							var78 = errString;
							return var78;
						}

						returnString = this.itmDBAccessEJB.getErrorString("", "VTBANKBLK", this.userId, "", conn);
						var78 = returnString;
						return var78;
					}

					returnString = this.itmDBAccessEJB.getErrorString("", "VTSTBLK", this.userId, "", conn);
					var78 = returnString;
					return var78;
				}

				returnString = this.itmDBAccessEJB.getErrorString("", "VTTODTBLK", this.userId, "", conn);
				var78 = returnString;
				return var78;
			}

			returnString = this.itmDBAccessEJB.getErrorString("", "VTFRDTBLK", this.userId, "", conn);
			var78 = returnString;
		} catch (SQLException var113) {
			System.out.println(
					"SQLException :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var113.getMessage() + ":");
			throw new ITMException(var113);
		} catch (Exception var114) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var114.getMessage() + ":");
			throw new ITMException(var114);
		} finally {
			try {
				retTabSepStrBuff = null;
				if (rs != null) {
					rs.close();
				}

				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception var112) {
				errString = var112.getMessage();
				var112.printStackTrace();
				throw new ITMException(var112);
			}

		}

		return var78;
	}

	public String process() throws RemoteException, ITMException {
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String retStr = "";

		try {
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			System.out.println("windowName[process]::::::::::;;;" + windowName);
			System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);
		} catch (Exception var11) {
			System.out.println(var11.getMessage());
			var11.printStackTrace();
		}

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}

			retStr = this.process(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var10) {
			System.out.println(
					"Exception :WorkorderPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var10.getMessage() + ":");
			var10.printStackTrace();
			retStr = var10.getMessage();
		}

		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String retStr = "";
		String tranId = "";
		String gentext = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		String retString = "";
		String errCode = "";
		String textDoc = "";
		String textDoc1 = "";
		String sundryType = "";
		String bankCode = "";
		String fileName = "";
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String filePath = null;
		String hdrLines = null;
		String bankFilePath = null;
		String bankFileFormat = null;
		String batchPath = null;

		label601 : {
			String var37;
			try {
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				String bankSql = null;
				this.genericUtility.getColumnValue("sundry_type", headerDom);
				bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
				bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
						+ bankCode + "'";
				Statement bankStmt = null;
				ResultSet bankRs = null;

				try {
					bankStmt = conn.createStatement();
					bankRs = bankStmt.executeQuery(bankSql);
					if (bankRs.next()) {
						bankFilePath = bankRs.getString("filePath");
						bankFileFormat = bankRs.getString("bankformat");
						batchPath = bankRs.getString("batchpath");
					}
				} catch (Exception var66) {
					var66.printStackTrace();
				} finally {
					try {
						if (bankRs != null) {
							bankRs.close();
						}

						bankRs = null;
						if (bankStmt != null) {
							bankStmt.close();
						}

						bankStmt = null;
					} catch (Exception var65) {
						;
					}

				}

				if (bankFileFormat == null || bankFileFormat.trim().length() == 0) {
					errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
					var37 = errString;
					return var37;
				}

				int flag;
				int flag1;
				String epayCity;
				label602 : {
					if (bankFilePath != null && bankFilePath.trim().length() != 0) {
						System.out.println("Manoharan 29/09/14 in process bankCD [" + this.bankCD + "] bank_code ["
								+ bankCode + "] bankFilePath [" + bankFilePath + "] bankFileFormat [" + bankFileFormat
								+ "] batchPath [" + batchPath + "]");
						Node currDetail = null;
						NodeList detailList = null;
						detailList = detailDom.getElementsByTagName("Detail2");
						int noOfDetails = 0;
						flag = 0;
						flag1 = 0;
						noOfDetails = detailList.getLength();
						flag = 0;
						int ctr = 0;

						while (true) {
							if (ctr >= noOfDetails) {
								break label602;
							}

							epayCity = null;
							currDetail = detailList.item(ctr);
							epayCity = this.genericUtility.getColumnValueFromNode("tran_id", currDetail);
							sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, epayCity);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								flag = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							sql = "select count(1) from MISC_payment where MISC_PAYMENT.TRAN_ID =? and MISC_PAYMENT.EFF_DATE is not null ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, epayCity);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								flag1 = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (flag > 0 || flag1 > 0) {
								break label602;
							}

							++ctr;
						}
					}

					errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
					var37 = errString;
					return var37;
				}

				if (flag <= 0) {
					if (flag1 > 0) {
						errString = this.itmDBAccessEJB.getErrorString("", "VTEFFDATE", this.userId);
						var37 = errString;
						return var37;
					}

					String destinationPath = null;
					epayCity = null;
					EpayCityAus epayCityAS = new EpayCityAus();
					retString = epayCityAS.process(headerDom, detailDom, windowName, xtraParams, bankFilePath, batchPath,
							conn);
					break label601;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTTXNRPT", this.userId);
				var37 = errString;
			} catch (Exception var68) {
				System.out.println("Exception EpaymentPrcEJB" + var68.getMessage());
				System.out.println("connection rollback.............");
				System.out.println("Returning Result " + errString);

				try {
					conn.rollback();
				} catch (Exception var64) {
					;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
				var68.printStackTrace();
				var37 = errString;
				return var37;
			} finally {
				try {
					if (rs != null) {
						rs.close();
					}

					rs = null;
					if (pstmt != null) {
						pstmt.close();
					}

					if (conn != null) {
						conn.close();
						conn = null;
					}
				} catch (Exception var63) {
					System.out.println("Error In closing connection::==> " + var63);
					var63.printStackTrace();
				}

			}

			return var37;
		}

		System.out.println("returning EpaymentPrcEJB   " + retString);
		return retString;
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}

		return input.trim();
	}
}