package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EChqWritingPrc extends ProcessEJB implements EChqWritingPrcLocal, EChqWritingPrcRemote {
	int MAXBLANKROWS = 33;
	String userId = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	String bankCD = null;

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		System.out.println("EpaymentPrcEJB :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				System.out.println("XML String :" + xmlString);
				headerDom = this.genericUtility.parseString(xmlString);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				System.out.println("XML String :" + xmlString2);
				detailDom = this.genericUtility.parseString(xmlString2);
			}

			rtrStr = this.getData(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var9) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var9.getMessage() + ":");
			rtrStr = var9.getMessage();
		}

		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String errString = null;
		String errCode = "";
		String returnString = "";
		String getDataSql = "";
		String sql = "";
		String sql1 = "";
		String resultString = "";
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();
		String siteCode = null;
		String tranId = "";
		String refNo = "";
		Timestamp toDate = null;
		Timestamp fromDate = null;
		boolean recFound = false;
		double netAmt = 0.0D;
		double exchRate = 0.0D;
		int flag = 0;
		Timestamp confDate = null;
		Timestamp refDate = null;
		Timestamp tranDate = null;
		String currCode = "";
		String sundryCode = "";
		String sundryType = "";
		String finEntity = "";
		String confirmed = "";
		String nameOption = "";
		Connection conn = null;

		try {
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: " + xtraParams);
			this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId............." + this.userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String vouchNoFr = "";
			String vouchNoTo = "";
			String dateFr = "";
			String dateTo = "";
			String payMode = "";
			String bankCode = "";
			siteCode = this.genericUtility.getColumnValue("site_code", headerDom);
			vouchNoFr = this.genericUtility.getColumnValue("voucher_no_fr", headerDom);
			vouchNoTo = this.genericUtility.getColumnValue("voucher_no_to", headerDom);
			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
			nameOption = this.genericUtility.getColumnValue("nameoption", headerDom);
			payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
			System.out.println("siteCode :-[" + siteCode + "]");
			System.out.println("vouchNoFr :-[" + vouchNoFr + "]");
			System.out.println("vouchNoTo :-[" + vouchNoTo + "]");
			System.out.println("Get Data Sundry Type @@@@@@@@@@@:-[" + sundryType + "]");
			System.out.println("Get Data Name Option @@@@@@@@@@@:-[" + nameOption + "]");
			System.out.println("Get Data Pay mode @@@@@@@@@@@:-[" + payMode + "]");
			if (vouchNoFr == null || vouchNoFr.trim().length() == 0) {
				vouchNoFr = "00";
			}

			if (vouchNoTo == null || vouchNoTo.trim().length() == 0) {
				vouchNoTo = "ZZ";
			}

			String mainTblName = null;
			String mainTblCode = null;
			String bankTblName = null;
			String bankTblCode = null;
			System.out.println("@vkc::checking SundyType:" + sundryType);
			String var63;
			if (sundryType != null && sundryType.trim().length() != 0) {
				if (sundryType != null && sundryType.trim().length() > 0) {
					sql = "SELECT COUNT(*) FROM SUNDRY_TYPE WHERE SUNDRY_TYPE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sundryType);
					rs = pstmt.executeQuery();
					if (rs.next() && rs.getInt(1) == 0) {
						errCode = "VTSUND4";
						returnString = this.itmDBAccessEJB.getErrorString("", "VINVSUND4", this.userId, "", conn);
						var63 = returnString;
						return var63;
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				} else {
					System.out.println("After Sundry Type :-[" + sundryType + "]");
					if ("T".equalsIgnoreCase(sundryType)) {
						mainTblName = "TRANSPORTER";
						mainTblCode = "TRAN_CODE";
						bankTblName = "TRANSPORTER_BANK";
						bankTblCode = "TRAN_CODE";
					} else if ("P".equalsIgnoreCase(sundryType)) {
						mainTblName = "SALES_PERS";
						mainTblCode = "SALES_PERS";
						bankTblName = "SALES_PERS_BANK";
						bankTblCode = "SALES_PERS";
					} else if ("R".equalsIgnoreCase(sundryType)) {
						mainTblName = "STRG_CUSTOMER";
						mainTblCode = "SC_CODE";
						bankTblName = "STRG_CUST_BANK";
						bankTblCode = "SC_CODE";
					} else if ("L".equalsIgnoreCase(sundryType)) {
						mainTblName = "LOANPARTY";
						mainTblCode = "PARTY_CODE";
						bankTblName = "LOANPARTY_BANK";
						bankTblCode = "PARTY_CODE";
					} else if ("S".equalsIgnoreCase(sundryType)) {
						mainTblName = "SUPPLIER";
						mainTblCode = "SUPP_CODE";
						bankTblName = "SUPPLIER_BANK";
						bankTblCode = "SUPP_CODE";
					} else if ("C".equalsIgnoreCase(sundryType)) {
						mainTblName = "CUSTOMER";
						mainTblCode = "CUST_CODE";
						bankTblName = "CUSTOMER_BANK";
						bankTblCode = "CUST_CODE";
					}
				}

				dateFr = this.genericUtility.getColumnValue("date_fr", headerDom);
				dateTo = this.genericUtility.getColumnValue("date_to", headerDom);
				if (dateFr != null && dateFr.trim().length() != 0) {
					if (dateTo != null && dateTo.trim().length() != 0) {
						System.out.println("dateFr :: " + dateFr);
						String dateFr1 = this.genericUtility.getValidDateString(dateFr,
								this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
						fromDate = Timestamp.valueOf(dateFr1 + " 00:00:00.0");
						String dateTo1 = this.genericUtility.getValidDateString(dateTo,
								this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
						toDate = Timestamp.valueOf(dateTo1 + " 00:00:00.0");
						System.out.println("fromDate..............." + fromDate);
						System.out.println("toDate..............." + toDate);
						payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
						bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
						this.bankCD = bankCode;
						System.out.println("payMode..............." + payMode);
						if (payMode == null || payMode.trim().length() == 0) {
							returnString = this.itmDBAccessEJB.getErrorString("", "VTPMBLK", this.userId, "", conn);
							var63 = returnString;
							return var63;
						} else if (siteCode == null || siteCode.trim().length() == 0) {
							returnString = this.itmDBAccessEJB.getErrorString("", "VTSTBLK", this.userId, "", conn);
							var63 = returnString;
							return var63;
						} else {
							String bankFilePath = null;
							int cnt = 0;
							bankFilePath = "select count( * ) cnt from site where site_code = ? ";
							vPStmt = conn.prepareStatement(bankFilePath);
							vPStmt.setString(1, siteCode);
							vRs = vPStmt.executeQuery();
							if (vRs.next()) {
								cnt = vRs.getInt("cnt");
							}

							vRs.close();
							vRs = null;
							vPStmt.close();
							vPStmt = null;
							if (cnt == 0) {
								returnString = this.itmDBAccessEJB.getErrorString("", "VTSTINV", this.userId, "", conn);
								var63 = returnString;
								return var63;
							} else if (bankCode != null && bankCode.trim().length() != 0) {
								bankFilePath = null;
								cnt = 0;
								bankFilePath = "select count( * ) cnt from bank where bank_code = ? ";
								vPStmt = conn.prepareStatement(bankFilePath);
								vPStmt.setString(1, bankCode);
								vRs = vPStmt.executeQuery();
								if (vRs.next()) {
									cnt = vRs.getInt("cnt");
								}

								vRs.close();
								vRs = null;
								vPStmt.close();
								vPStmt = null;
								if (cnt != 0) {
									bankFilePath = null;
									String bankFileFormat = null;
									String batchPath = null;
									String bankSql = null;
									System.out.println("BANK code:-[" + bankCode + "]");
									bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
											+ bankCode + "'";
									System.out.println("bankSql :: " + bankSql);
									Statement bankStmt = null;
									ResultSet bankRs = null;

									try {
										bankStmt = conn.createStatement();
										bankRs = bankStmt.executeQuery(bankSql);
										if (bankRs.next()) {
											bankFilePath = bankRs.getString("filePath");
											bankFileFormat = bankRs.getString("bankformat");
											batchPath = bankRs.getString("batchpath");
										}
									} catch (Exception var97) {
										var97.printStackTrace();
									} finally {
										try {
											if (bankRs != null) {
												bankRs.close();
											}

											bankRs = null;
											if (bankStmt != null) {
												bankStmt.close();
											}

											bankStmt = null;
										} catch (Exception var96) {
											;
										}

									}

									if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
										System.out.println("Bank File format :- [" + bankFileFormat + "]");
										if (bankFilePath != null && bankFilePath.trim().length() != 0) {
											System.out.println("Bank File path :- [" + bankFilePath + "]");
											System.out.println("Batch path :- [" + batchPath + "]");
											String citiSql = null;
											citiSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE ,  MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE ,  MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,   MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE ,  MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY ,  MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,   MISC_PAYMENT.CONFIRMED   FROM  MISC_PAYMENT   WHERE ( MISC_PAYMENT.SITE_CODE = '"
													+ siteCode + "' ) " + "\tAND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
													+ "\tAND ( MISC_PAYMENT.TRAN_TYPE IN ('EC') )"
													+ " \tAND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
													+ "\tAND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) "
													+ "\tAND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
													+ "\tAND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' "
													+ "\tAND MISC_PAYMENT.EFF_DATE is null "
													+ "\tAND MISC_PAYMENT.PAY_MODE = '" + payMode + "' "
													+ "\tAND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') "
													+ " AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' "
													+ "\t AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
													+ "\t\t\t\t\t\t\t\t\t\t\t\t\tFROM MISC_PAYMENT_CANC "
													+ "\t\t\t\t\t\t\t\t\t\t\t\t\t WHERE TRAN_DATE >='01-SEP-1999' "
													+ "\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND SITE_CODE = '" + siteCode + "')"
													+ "\tAND exists( select 1 from  MISC_PAYDET "
													+ "\t\t\t\t\tWHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID ) ";
											if (bankFileFormat.equalsIgnoreCase("CITI")) {
												sql = citiSql;
												pstmt = conn.prepareStatement(citiSql);
											}

											System.out.println("sqlcitiSql.............[" + citiSql + "]");
											System.out.println("sql.............[" + sql + "]");
											pstmt.setTimestamp(1, fromDate);
											pstmt.setTimestamp(2, toDate);
											rs = pstmt.executeQuery();

											while (rs.next()) {
												recFound = true;
												tranId = rs.getString("TRAN_ID");
												flag = 0;
												sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
												pstmt1 = conn.prepareStatement(sql);
												pstmt1.setString(1, tranId);
												rs1 = pstmt1.executeQuery();
												if (rs1.next()) {
													flag = rs1.getInt(1);
												}

												rs1.close();
												rs1 = null;
												pstmt1.close();
												pstmt1 = null;
												if (flag == 0) {
													currCode = rs.getString("CURR_CODE");
													tranDate = rs.getTimestamp("TRAN_DATE");
													refDate = rs.getTimestamp("REF_DATE");
													exchRate = rs.getDouble("EXCH_RATE");
													netAmt = rs.getDouble("NET_AMT");
													sundryCode = rs.getString("SUNDRY_CODE");
													siteCode = rs.getString("SITE_CODE");
													finEntity = rs.getString("FIN_ENTITY");
													bankCode = rs.getString("BANK_CODE");
													payMode = rs.getString("PAY_MODE");
													confirmed = rs.getString("CONFIRMED");
													refNo = rs.getString("REF_NO");
													confDate = rs.getTimestamp("CONF_DATE");
													refNo = refNo == null ? "" : refNo.trim();
													retTabSepStrBuff.append(tranId).append("\t");
													retTabSepStrBuff.append(sundryCode).append("\t");
													retTabSepStrBuff.append(payMode).append("\t");
													retTabSepStrBuff.append(bankCode).append("\t");
													retTabSepStrBuff.append(refNo).append("\t");
													retTabSepStrBuff.append(refDate).append("\t");
													retTabSepStrBuff.append(netAmt).append("\t");
													retTabSepStrBuff.append(currCode).append("\t");
													retTabSepStrBuff.append(siteCode).append("\t");
													retTabSepStrBuff.append(finEntity).append("\t");
													retTabSepStrBuff.append(tranDate).append("\t");
													retTabSepStrBuff.append(sundryType).append("\t");
													retTabSepStrBuff.append(confirmed).append("\t");
													retTabSepStrBuff.append(confDate).append("\t");
													retTabSepStrBuff.append(exchRate).append("\t");
													retTabSepStrBuff.append("\n");
												}
											}

											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;
											if (!recFound) {
												returnString = this.itmDBAccessEJB.getErrorString("", "VTNODATA",
														this.userId, "", conn);
												conn.close();
												conn = null;
												var63 = returnString;
												return var63;
											} else {
												if (retTabSepStrBuff != null) {
													resultString = retTabSepStrBuff.toString();
													System.out.println("ResultString....." + resultString);
												}

												return resultString;
											}
										} else {
											errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC",
													this.userId);
											var63 = errString;
											return var63;
										}
									} else {
										errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
										var63 = errString;
										return var63;
									}
								} else {
									returnString = this.itmDBAccessEJB.getErrorString("", "VTBNKINV", this.userId, "",
											conn);
									var63 = returnString;
									return var63;
								}
							} else {
								returnString = this.itmDBAccessEJB.getErrorString("", "VTBANKBLK", this.userId, "",
										conn);
								var63 = returnString;
								return var63;
							}
						}
					} else {
						returnString = this.itmDBAccessEJB.getErrorString("", "VTTODTBLK", this.userId, "", conn);
						var63 = returnString;
						return var63;
					}
				} else {
					returnString = this.itmDBAccessEJB.getErrorString("", "VTFRDTBLK", this.userId, "", conn);
					var63 = returnString;
					return var63;
				}
			} else {
				returnString = this.itmDBAccessEJB.getErrorString("", "VBLSUND4", this.userId, "", conn);
				var63 = returnString;
				return var63;
			}
		} catch (SQLException var100) {
			System.out.println(
					"SQLException :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var100.getMessage() + ":");
			throw new ITMException(var100);
		} catch (Exception var101) {
			System.out.println(
					"Exception :EpaymentPrcEJB :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):"
							+ var101.getMessage() + ":");
			throw new ITMException(var101);
		} finally {
			try {
				retTabSepStrBuff = null;
				if (rs != null) {
					rs.close();
				}

				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception var99) {
				errString = var99.getMessage();
				var99.printStackTrace();
				throw new ITMException(var99);
			}

		}
	}

	public String process() throws RemoteException, ITMException {
		System.out.println("I am in blank process .......EChqWritingPrc........");
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String retStr = "";

		try {
			System.out.println("xmlString[process]::::::::::;;;" + xmlString);
			System.out.println("xmlString2[process]::::::::::;;;" + xmlString2);
			System.out.println("windowName[process]::::::::::;;;" + windowName);
			System.out.println("xtraParams[process]:::::::::;;;" + xtraParams);
		} catch (Exception var11) {
			System.out.println(var11.getMessage());
			var11.printStackTrace();
		}

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}

			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}

			retStr = this.process(headerDom, detailDom, windowName, xtraParams);
		} catch (Exception var10) {
			System.out.println(
					"Exception :WorkorderPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):"
							+ var10.getMessage() + ":");
			var10.printStackTrace();
			retStr = var10.getMessage();
		}

		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String retStr = "";
		String tranId = "";
		String gentext = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		String retString = "";
		String errCode = "";
		String textDoc = "";
		String textDoc1 = "";
		String sundryType = "";
		String bankCode = "";
		String fileName = "";
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String filePath = null;
		String hdrLines = null;
		String bankFilePath = null;
		String bankFileFormat = null;
		String batchPath = null;
		String siteCode = "";
		String payMode = "";
		String dateFr = "";
		String dateTo = "";
		String finParmDesc = "";
		String nameOpt = "";
		boolean var32 = false;

		try {
			String var47;
			try {
				label667 : {
					conn = connDriver.getConnectDB("DriverITM");
					conn.setAutoCommit(false);
					String bankSql = null;
					this.genericUtility.getColumnValue("sundry_type", headerDom);
					bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);
					bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"
							+ bankCode + "'";
					Statement bankStmt = null;
					ResultSet bankRs = null;

					try {
						bankStmt = conn.createStatement();
						bankRs = bankStmt.executeQuery(bankSql);
						if (bankRs.next()) {
							bankFilePath = bankRs.getString("filePath");
							bankFileFormat = bankRs.getString("bankformat");
							batchPath = bankRs.getString("batchpath");
						}
					} catch (Exception var77) {
						var77.printStackTrace();
					} finally {
						try {
							if (bankRs != null) {
								bankRs.close();
							}

							bankRs = null;
							if (bankStmt != null) {
								bankStmt.close();
							}

							bankStmt = null;
						} catch (Exception var76) {
							;
						}

					}

					if (bankFileFormat != null && bankFileFormat.trim().length() != 0) {
						if (bankFilePath != null && bankFilePath.trim().length() != 0) {
							System.out.println("VALLABH 03/FEB/15 in process bankCD [" + this.bankCD + "] bank_code ["
									+ bankCode + "] bankFilePath [" + bankFilePath + "] bankFileFormat ["
									+ bankFileFormat + "] batchPath [" + batchPath + "]");
							Node currDetail = null;
							NodeList detailList = null;
							detailList = detailDom.getElementsByTagName("Detail2");
							int noOfDetails = 0;
							int flag = 0;
							int flag1 = 0;
							noOfDetails = detailList.getLength();

							for (int ctr = 0; ctr < noOfDetails; ++ctr) {
								String tId = null;
								currDetail = detailList.item(ctr);
								tId = this.genericUtility.getColumnValueFromNode("tran_id", currDetail);
								sql = "select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tId);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									flag = rs.getInt(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								sql = "select count(1) from MISC_payment where MISC_PAYMENT.TRAN_ID =? and MISC_PAYMENT.EFF_DATE is not null ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tId);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									flag1 = rs.getInt(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("vkc::flag >>" + flag + " || " + "vkc::flag1 >>" + flag1);
								if (flag > 0 || flag1 > 0) {
									break;
								}
							}

							if (flag > 0) {
								errString = this.itmDBAccessEJB.getErrorString("", "VTTXNRPT", this.userId);
								var47 = errString;
								return var47;
							}

							if (flag1 > 0) {
								errString = this.itmDBAccessEJB.getErrorString("", "VTEFFDATE", this.userId);
								var47 = errString;
								return var47;
							}

							siteCode = this.genericUtility.getColumnValue("site_code", headerDom);
							payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
							this.genericUtility.getColumnValue("date_fr", headerDom);
							this.genericUtility.getColumnValue("date_to", headerDom);
							nameOpt = this.genericUtility.getColumnValue("nameoption", headerDom);
							fileName = siteCode.trim() + "/" + payMode.trim() + "/" + bankCode.trim() + "/" + nameOpt;
							String destinationPath = null;
							ArrayList tranIdList = null;
							String batchIdUpdate = "";
							System.out.println("Destinetion Path at PRC @@@@@@ :- [" + batchPath + "]");
							if (bankFileFormat.equalsIgnoreCase("CITI")) {
								EChqWritingCITI eChqWrtCiti = null;
								eChqWrtCiti = new EChqWritingCITI();
								eChqWrtCiti.process(headerDom, detailDom, windowName, xtraParams, bankFilePath,
										batchPath, conn);
								tranIdList = eChqWrtCiti.tranIdList;
							}

							System.out.println("@vkc:batchIdUpdate >> " + batchIdUpdate);
							int upd = 0;
							int upd1 = 0;
							upd = updateMiscPayment(tranIdList, batchIdUpdate, conn);
							updateBankTranLog(tranIdList, conn);
							if (tranIdList != null && tranIdList.size() > 0) {
								System.out.println("Tran id generation");
								Util.InsertLog(tranIdList, this.userId, conn);
								insertPrintCtrl(tranIdList, fileName, this.userId, conn);
							}

							if (upd > 0) {
								System.out.println("@vkc::commiting connection.............");
								conn.commit();
								errString = this.itmDBAccessEJB.getErrorString("", "PROCSUCC", this.userId);
								System.out.println("process completed .." + errString);
								retString = errString;
								break label667;
							}

							System.out.println("@vkc::connection rollback.............");
							System.out.println("Returning Result " + errString);
							conn.rollback();
							errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
							var47 = errString;
							return var47;
						}

						errString = this.itmDBAccessEJB.getErrorString("", "VTNOFLELOC", this.userId);
						var47 = errString;
						return var47;
					}

					errString = this.itmDBAccessEJB.getErrorString("", "VTNOBNKFMT", this.userId);
					var47 = errString;
					return var47;
				}
			} catch (Exception var79) {
				System.out.println("Exception EpaymentPrcEJB" + var79.getMessage());
				System.out.println("connection rollback.............");
				System.out.println("Returning Result " + errString);

				try {
					conn.rollback();
				} catch (Exception var75) {
					;
				}

				errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
				var79.printStackTrace();
				var47 = errString;
				return var47;
			}
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}

				rs = null;
				if (pstmt != null) {
					pstmt.close();
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception var74) {
				System.out.println("Error In closing connection::==> " + var74);
				var74.printStackTrace();
			}

		}

		System.out.println("returning EpaymentPrcEJB   " + retString);
		return retString;
	}

	public static int updateMiscPayment(ArrayList tranIdList, String batchIdUpdate, Connection conn) {
		String sql = null;
		int upd = 0;
		PreparedStatement pstmt = null;
		System.out.println("@vkc::Processing Transaction id list >>" + tranIdList);
		System.out.println("@vkc::upd>>" + upd);

		try {
			for (int i = 0; i < tranIdList.size(); ++i) {
				String tIdList = (String) tranIdList.get(i);
				System.out.println("TranIdList>>" + tranIdList.get(i));
				sql = "update misc_payment set eff_date = ?, ref_no = ?, batch_id = ? where tran_id = ? ";
				System.out.println("upd sql............." + sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
				pstmt.setString(2, tIdList);
				pstmt.setString(3, batchIdUpdate);
				pstmt.setString(4, tIdList);
				upd = pstmt.executeUpdate();
				System.out.println("@vkc::upd::for loop >>" + upd);
			}
		} catch (Exception var16) {
			var16.printStackTrace();
			upd = 0;
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception var15) {
				var15.printStackTrace();
			}

		}

		return upd;
	}

	public static int updateBankTranLog(ArrayList tranIdList, Connection conn) {
		String sql = null;
		int upd1 = 0;
		PreparedStatement pstmt = null;
		System.out.println("@vkc::Processing Transaction id list >>" + tranIdList);
		System.out.println("@vkc::upd1 >>" + upd1);

		try {
			for (int i = 0; i < tranIdList.size(); ++i) {
				String tIdList = (String) tranIdList.get(i);
				System.out.println("TranIdList>>" + tranIdList.get(i));
				sql = "update banktran_log set ref_no = ? where tran_no = ? ";
				System.out.println("upd1 sql............." + sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tIdList);
				pstmt.setString(2, tIdList);
				upd1 = pstmt.executeUpdate();
				System.out.println("@vkc::upd1::for loop >>" + upd1);
			}
		} catch (Exception var15) {
			var15.printStackTrace();
			upd1 = 0;
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception var14) {
				var14.printStackTrace();
			}

		}

		return upd1;
	}

	public static void insertPrintCtrl(ArrayList sourceFileList, String fileName, String userId, Connection conn) {
		String tranId = null;
		PreparedStatement pStmt = null;
		String insSql = null;
		insSql = "insert into RPT_PRINT_CTRL( TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID, PRINTED_ON)  values( ?, ?, ?, ?, SYSDATE) ";

		try {
			pStmt = conn.prepareStatement(insSql);
			int listLen = 0;
			listLen = sourceFileList.size();

			for (int listIdx = 0; listIdx < listLen; ++listIdx) {
				tranId = (String) sourceFileList.get(listIdx);
				pStmt.setString(1, tranId);
				pStmt.setString(2, "w_echq_writing");
				pStmt.setString(3, fileName);
				pStmt.setString(4, userId);
				pStmt.addBatch();
			}

			pStmt.executeBatch();
		} catch (Exception var17) {
			var17.printStackTrace();
		} finally {
			try {
				if (pStmt != null) {
					pStmt.close();
				}
			} catch (Exception var16) {
				var16.printStackTrace();
			}

			pStmt = null;
		}

	}
}