package ibase.webitm.ejb.fin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuildPaymentXMLFileSch implements Schedule {
	private String pmtHost = "";
	private String pmtUser = "";
	private String pmtPwd = "";
	private String remoteFilePath = "";
	private String xmlFileNameUpd = "";
	private String pmtRmFilePath = "";
	private String locFilePath = "";
	private String pmtBackupFilePath = "";
	private String pmtPort = "";
	static String accToBeCredited = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	SimpleDateFormat sdf1 = null;
	String customDateVal = "";

	public String schedule(HashMap arg0) throws Exception {
		return null;
	}

	public String schedulePriority(String arg0) throws Exception {
		return null;
	}

	public String schedule(String scheduleParamXML) throws Exception {
		System.out.println("scheduleParamXML:::" + scheduleParamXML);
		UserInfoBean userInfo = new UserInfoBean();
		String disparmLoginSiteCode = "";
		Connection conn = null;
		Connection connRtm = null;
		ConnDriver connDriver = new ConnDriver();
		conn = connDriver.getConnectDB("DriverITM");
		String sql = "";
		String retString = "";
		String finParamTranType = "";
		String filePath = "";
		String updResult = "";
		String paymentSql = "";
		String sql1 = "";
		String fileNameStr = "";
		String userId = "";
		String tranId = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String siteCodeList = "";
		String siteCode = "";
		String paymentId = "";
		ArrayList<String> paymentIdList = new ArrayList();
		ArrayList<String> paymentSuccList = new ArrayList();
		new ArrayList();
		ArrayList<String> tempTranIdList = null;
		FinCommon finCommon = new FinCommon();
		String noOfDays = "0";
		int intnoOfDays = 0;
		int cnt = 0;
		int prntLgCount = 0;
		int insertCount = 0;
		Date fromDate = null;
		Timestamp fromDateDB = null;
		String sundryType = "";
		String payMode = "";
		String keyStr = "";
		String batchId = "";
		DocumentBuilderFactory icFactory = null;
		DocumentBuilder icBuilder = null;
		Document document = null;
		Element mainRootElement = null;
		String bankCode = "";
		String mapKey = "";
		String siteDescr = "";
		String CreDtTm = "";

		try {
			Document dom = null;
			Node currDetail = null;
			int noOfParam = 0;
			userId = userInfo.getLoginCode();
			System.out.println("User Id :- [" + userId + "]");
			UtilMethods utilmethod = new UtilMethods();
			System.out.println("scheduleParamXML-----" + scheduleParamXML);
			dom = this.genericUtility.parseString(scheduleParamXML);
			NodeList paramList = dom.getElementsByTagName("SCHEDULE");
			noOfParam = paramList.getLength();
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			int childNodeListLength = 0;
			String childNodeName = null;
			paymentIdList.clear();
			this.sdf1 = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
			Date currentDate = new Date();
			System.out.println("sdf1.format(currentDate)[" + this.sdf1.format(currentDate) + "]");
			this.customDateVal = this.sdf1.format(currentDate).replace("-", "");
			System.out.println("customDateVal[" + this.customDateVal + "]");
			Timestamp newsysDate = Timestamp.valueOf(this.sdf1.format(currentDate) + " 00:00:00.0");
			System.out.println(">>>> newsysDate is:" + newsysDate);
			noOfDays = this.checkNull(finCommon.getFinparams("999999", "EPAY_NO_DAYS", conn));
			System.out.println("No of days :- [" + noOfDays + "]");
			new HashMap();
			if (noOfDays != null && noOfDays.trim().length() > 0 && !"NULLFOUND".equals(noOfDays)) {
				intnoOfDays = Integer.parseInt(noOfDays);
				fromDate = utilmethod.RelativeDate(currentDate, -intnoOfDays);
				System.out.println(">>>fromDate:" + fromDate);
			} else {
				fromDate = currentDate;
			}

			fromDateDB = Timestamp.valueOf(this.sdf1.format(fromDate) + " 00:00:00.0");
			System.out.println(">>>>>fromDateDB:" + fromDateDB);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			dom = db.parse("/IBASEHOME/ibase.xml");
			this.locFilePath = dom.getElementsByTagName("PMT_EXPORT_PATH").item(0).getFirstChild().getNodeValue();
			System.out.println("LocFilePath :" + this.locFilePath);
			fileNameStr = this.checkNull(finCommon.getFinparams("999999", "CHEQFILE_NAME_PREF", conn));
			if (fileNameStr == null || fileNameStr.trim().length() == 0
					|| fileNameStr.trim().equalsIgnoreCase("NULLFOUND")) {
				fileNameStr = "payment_";
			}

			paymentSql = " select misc_payment.tran_id,misc_payment.sundry_type,misc_payment.pay_mode,misc_payment.net_amt__bc,misc_payment.bank_code from misc_payment misc_payment,bank bank   where misc_payment.confirmed='Y'  and misc_payment.tran_date>=?  and misc_payment.tran_date <=?  and misc_payment.eff_date IS NULL  and misc_payment.bank_code=bank.bank_code  and case when bank.UDF_STR5 is null then 'N' else bank.UDF_STR5 end ='Y'  AND case when misc_payment.WF_STATUS is null then 'O' else misc_payment.WF_STATUS end  in ('S','C')  and misc_payment.net_amt__bc > 0  and misc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed='Y')  and misc_payment.sundry_type in('S','C','T','L') and misc_payment.pay_mode in('W','X','V','U','F','Z') for update nowait ";
			HashMap<String, ArrayList<HeaderBean>> recMap = new HashMap();
			double netAmt = 0.0D;
			ArrayList<HeaderBean> tempList = null;
			pstmt = conn.prepareStatement(paymentSql);
			pstmt.setTimestamp(1, fromDateDB);
			pstmt.setTimestamp(2, newsysDate);
			rs = pstmt.executeQuery();
			HeaderBean dataBean = null;

			while (rs.next()) {
				sundryType = rs.getString("sundry_type");
				payMode = rs.getString("pay_mode");
				tranId = rs.getString("tran_id");
				netAmt = rs.getDouble("net_amt__bc");
				bankCode = rs.getString("bank_code");
				dataBean = new HeaderBean();
				dataBean.setTranId(tranId);
				dataBean.setSundryType(sundryType);
				dataBean.setNetAmt(netAmt);
				mapKey = payMode + "@" + bankCode;
				if (recMap.containsKey(mapKey)) {
					tempList = (ArrayList) recMap.get(mapKey);
				} else {
					tempList = new ArrayList();
				}

				tempList.add(dataBean);
				recMap.put(mapKey, tempList);
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("recMap[" + recMap + "]");
			System.out.println("@V@ Rec map size :- [" + recMap.size() + "]");
			Set keyset = recMap.keySet();
			Iterator<String> itr = keyset.iterator();
			new HeaderBean();
			double totAmt = 0.0D;
			double totTrn = 0.0D;

			while (itr.hasNext()) {
				totAmt = 0.0D;
				totTrn = 0.0D;
				mapKey = (String) itr.next();
				payMode = mapKey.split("@")[0];
				bankCode = mapKey.split("@")[1];
				tempList = (ArrayList) recMap.get(mapKey);
				totAmt = this.getValue(tempList, "amount");
				totTrn = this.getValue(tempList, "count");
				pstmt = conn.prepareStatement(
						"select descr from site where site_code in(select site_code from bank where bank_code=?)");
				pstmt.setString(1, bankCode);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					siteDescr = rs.getString(1);
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				pstmt = conn.prepareStatement(
						"select TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm from dual");
				rs = pstmt.executeQuery();
				if (rs.next()) {
					CreDtTm = rs.getString(1);
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				batchId = generateTranId("w_batchid_chqwrt", userId, conn);
				filePath = this.locFilePath + "/" + fileNameStr + batchId.trim() + ".xml";
				icFactory = DocumentBuilderFactory.newInstance();
				icBuilder = icFactory.newDocumentBuilder();
				document = icBuilder.newDocument();
				mainRootElement = document.createElementNS("urn:iso:std:iso:20022:tech:xsd:pain.001.001.03",
						"Document");
				mainRootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
				document.appendChild(mainRootElement);
				Element cstmrCdtTrfInitn = document.createElement("CstmrCdtTrfInitn");
				Element grpHdr = document.createElement("GrpHdr");
				grpHdr.appendChild(getElementValue(document, "MsgId", batchId.trim()));
				grpHdr.appendChild(getElementValue(document, "CreDtTm", CreDtTm));
				grpHdr.appendChild(getElementValue(document, "NbOfTxs", String.valueOf((int) totTrn)));
				grpHdr.appendChild(getElementValue(document, "CtrlSum", utilmethod.getReqDecString(totAmt, 2).trim()));
				Element initgPty = document.createElement("InitgPty");
				initgPty.appendChild(getElementValue(document, "Nm", siteDescr.trim()));
				grpHdr.appendChild(initgPty);
				cstmrCdtTrfInitn.appendChild(grpHdr);
				System.out.println("@V@ filePath :" + filePath);
				System.out.println("@V@ Temp list size :- [" + tempList.size() + "]");
				if (tempList.size() > 0) {
					for (int i = 0; i < tempList.size(); ++i) {
						HeaderBean dataBean1 = (HeaderBean) tempList.get(i);
						sundryType = dataBean1.getsundryType();
						tranId = dataBean1.getTranId();
						sql1 = "select tran_id from misc_payment where tran_id=? for update nowait";
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setString(1, tranId);
						rs1 = pstmt1.executeQuery();
						if (rs1.next()) {
							paymentId = rs1.getString("tran_id");
							sql = "select count(*) as cnt from misc_payment where tran_id=? and eff_date is null";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, paymentId);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("cnt");
							}

							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
							prntLgCount = this.getPrintLogCount(paymentId, conn);
							System.out.println("RPT_PRINT_LOG count :-[" + prntLgCount + "] for payment id :- ["
									+ paymentId + "]");
							if (cnt > 0 && prntLgCount == 0) {
								System.out.println("Eff date null count is 1 for id :- [" + paymentId + "]");
								document = this.genChequeWritingXML(cstmrCdtTrfInitn, mainRootElement, document,
										filePath, paymentId, sundryType, payMode, conn);
								System.out.println("@V@ document :- [" + document + "]");

								try {
									SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
									Date date = new Date();
									Timestamp currentDt = Timestamp
											.valueOf(sdf.format(date).toString() + " 00:00:00.0");
									System.out.println(">>>>execute update query!!!!!!!!!");
									sql = " update misc_payment set eff_date = ?,batch_id=? where tran_id=? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setTimestamp(1, currentDt);
									pstmt.setString(2, batchId);
									pstmt.setString(3, paymentId);
									pstmt.executeUpdate();
									pstmt.close();
									sql1 = "insert into RPT_PRINT_LOG( TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL )  values( ?, ?, ?, ?, SYSDATE, ?, ? )";
									pstmt2 = conn.prepareStatement(sql1);
									tranId = generateTranId("w_rpt_print_log", userId, conn);
									pstmt2.setString(1, tranId);
									pstmt2.setString(2, "w_e_payment");
									pstmt2.setString(3, filePath);
									pstmt2.setString(4, userId);
									pstmt2.setInt(5, 1);
									pstmt2.setString(6, paymentId);
									insertCount = pstmt2.executeUpdate();
									pstmt2.close();
									pstmt2 = null;
									System.out.println("RPT_PRINT_LOG Insert count :-[" + insertCount + "]");
									paymentSuccList.add(paymentId);
									System.out.println("paymentId : " + paymentId + " updated succefully!!!");
									finParamTranType = this
											.checkNull(finCommon.getFinparams("999999", "CHQ_AUTO_UPLOAD", conn));
									System.out.println("finParamTranType :" + finParamTranType);
									if (finParamTranType.equalsIgnoreCase("Y")) {
										this.setSFTPConfig();
										this.pmtRmFilePath = this.pmtRmFilePath + "/payment_" + paymentId.trim()
												+ ".xml";
										this.pmtBackupFilePath = this.pmtBackupFilePath + "/payment_" + paymentId.trim()
												+ ".xml";
										System.out.println("pmtRmFilePath by appending xml @@@@" + this.pmtRmFilePath);
										updResult = this.putFile(this.pmtUser, this.pmtHost, this.pmtPwd, this.pmtPort,
												this.pmtRmFilePath, filePath);
										if (updResult.equalsIgnoreCase("success")) {
											File fromFile = new File(filePath);
											File toFile = new File(this.pmtBackupFilePath);
											this.moveUploadFile(fromFile, toFile);
											System.out.println("payment" + paymentId.trim()
													+ ".xml uploaded sucessfully and move to backup folder!!!");
										} else {
											System.out
													.println("payment" + paymentId.trim() + ".xml uploaded failed!!!");
										}
									}
								} catch (Exception var110) {
									var110.printStackTrace();
									System.out.println("Exception :" + var110.getMessage());
								} finally {
									try {
										if (pstmt != null) {
											pstmt.close();
										}
									} catch (Exception var109) {
										var109.printStackTrace();
									}

								}
							}
						}

						pstmt1.close();
						pstmt1 = null;
						rs1.close();
						rs1 = null;
					}
				}

				TransformerFactory transformerFactory = TransformerFactory.newInstance();
				Transformer transformer = transformerFactory.newTransformer();
				DOMSource domSource = new DOMSource(document);
				StreamResult streamResult = new StreamResult(new File(filePath));
				transformer.transform(domSource, streamResult);
			}
		} catch (Exception var112) {
			var112.printStackTrace();
			conn.rollback();
		} finally {
			try {
				if (conn != null) {
					conn.commit();
					conn.close();
				}

				if (pstmt != null) {
					pstmt.close();
				}
			} catch (Exception var108) {
				var108.printStackTrace();
			}

		}

		return "";
	}

	private double getValue(ArrayList<HeaderBean> datalist, String criteria) {
		double totAmt = 0.0D;
		double count = 0.0D;
		double returnValue = 0.0D;
		HeaderBean databean = null;
		if (datalist.size() > 0) {
			for (int i = 0; i < datalist.size(); ++i) {
				databean = (HeaderBean) datalist.get(i);
				totAmt += databean.getNetAmt();
				++count;
			}
		}

		if ("amount".equalsIgnoreCase(criteria)) {
			returnValue = totAmt;
		} else {
			returnValue = count;
		}

		return returnValue;
	}

	private static String generateTranId(String windowName, String userId, Connection conn) throws Exception {
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "";
		new CommonConstants();

		try {
			sql = "SELECT KEY_STRING, TRAN_ID_COL, nvl(REF_SER,'PEXRE')  FROM TRANSETUP WHERE TRAN_WINDOW = '"
					+ windowName + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			System.out.println("keyString :" + rs.toString());
			String keyString = "";
			String keyCol = "";
			String tranSer = "";
			if (rs.next()) {
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer = rs.getString(3);
			}

			String xmlValues = "";
			System.out.println("keyCol" + keyCol);
			System.out.println("keyString" + keyString);
			System.out.println("tranSer" + tranSer);
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues for tranid  :[" + xmlValues + "]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, userId, CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
		} catch (SQLException var14) {
			System.out.println("Exception ::" + sql + var14.getMessage() + ":");
			var14.printStackTrace();
			throw new Exception(var14);
		} catch (Exception var15) {
			System.out.println("Exception ::" + var15.getMessage() + ":");
			var15.printStackTrace();
			throw new Exception(var15);
		}

		System.out.println("tranId :- [" + tranId + "]");
		return tranId;
	}

	private int getPrintLogCount(String paymentId, Connection conn) {
		int prntLgCount = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {
			sql = "select count(*) as cnt from RPT_PRINT_LOG where TRAN_ID__CTRL = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, paymentId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				prntLgCount = rs.getInt("cnt");
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
		} catch (SQLException var8) {
			var8.printStackTrace();
		}

		return prntLgCount;
	}

	public Document genChequeWritingXML(Element cstmrCdtTrfInitn, Element mainRootElement, Document document,
			String filePath, String paymentId, String sundryType, String payMode, Connection conn)
			throws RemoteException, ITMException {
		String errString = "";
		Object var10 = null;

		try {
			System.out.println("------genChequeWritingXML---------L ");
			System.out.println("filepath :" + filePath);
			if ("W".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'W'");
				mainRootElement
						.appendChild(this.getChequeInfo(cstmrCdtTrfInitn, document, paymentId, sundryType, conn));
			} else if ("X".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'X'");
				mainRootElement
						.appendChild(this.getChequeInfoCTX(cstmrCdtTrfInitn, document, paymentId, sundryType, conn));
			} else if ("V".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'V'");
				mainRootElement
						.appendChild(this.getChequeInfoPPD(cstmrCdtTrfInitn, document, paymentId, sundryType, conn));
			} else if ("U".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'U'");
				mainRootElement
						.appendChild(this.getChequeInfoCCD(cstmrCdtTrfInitn, document, paymentId, sundryType, conn));
			} else if ("F".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'F'");
				mainRootElement
						.appendChild(this.getChequeInfoFEDW(cstmrCdtTrfInitn, document, paymentId, sundryType, conn));
			} else if ("Z".equalsIgnoreCase(payMode)) {
				System.out.println("Payment mode 'Z'");
				mainRootElement.appendChild(
						this.getChequeInfoCCD_PLUS(cstmrCdtTrfInitn, document, paymentId, sundryType, payMode, conn));
			}

			System.out.println("Done creating XML File@@@!!");
			return document;
		} catch (Exception var12) {
			var12.printStackTrace();
			System.out.println("Exception :" + var12.getMessage());
			throw new ITMException(var12);
		}
	}

	private Node getChequeInfo(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'W'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		String sql1 = null;
		String AltAddr1 = "";
		String AltAddr2 = "";
		String AltPin = "";
		String AltCity = "";
		String AltState = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = "SELECT MISC_PAYMENT.TRAN_ID AS MsgId, TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm, 1 as NbOfTxs, misc_payment.net_amt__bc as CtrlSum, site.descr as Nm, misc_payment.tran_id as PmtInfId, (case when misc_payment.pay_mode ='W' then 'CHK' else misc_payment.pay_mode end ) as PmtMtd, 1 as NbOfTxs, misc_payment.net_amt__bc as CtrlSum, to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt, site.descr as Nm, (select country.iso3166 from country where country.count_code = state.count_code) as Ctry , bank.ac_no as Id, bank.curr_code as Ccy, bank.swift_code as BIC, bank.udf_str8 as MmbId, (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry, misc_payment.tran_id as InstrId, misc_payment.tran_id AS EndToEndId, misc_payment.curr_code as Ccy, misc_payment.net_amt__bc  as InstdAmt, misc_payment.ref_no as ChqNb, nvl((select gencodes.udf_str1 from gencodes where gencodes.fld_name='PAY_TYPE' AND gencodes.mod_name='W_MISC_PAY' and gencodes.active='Y' AND trim(gencodes.fld_value) = trim(misc_payment.tran_type)),'00000') as Prtry, nvl((select gencodes.udf_str2 from gencodes where gencodes.fld_name='PAY_TYPE' AND gencodes.mod_name='W_MISC_PAY' and gencodes.active='Y' AND trim(gencodes.fld_value) = trim(misc_payment.tran_type)),'A1') as FrmsCd, supplier.chq_name as Nm1, supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm, supplier.addr1 as Addr1, supplier.addr2 || supplier.addr3 as Addr2, supplier.pin as PstCd, supplier.city as TwnNm, supplier.state_code as CtrySubDvsn, (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry, misc_paydet.sundry_code as Id1, 'CINV' AS Cd, misc_payables.bill_no AS Nb, to_char(misc_payables.bill_date,'yyyy-mm-dd') as RltdDt, misc_paydet.curr_code as Ccy1, misc_paydet.pay_amt  as DuePyblAmt, misc_paydet.curr_code as Ccy1, misc_paydet.discount_amt  as DscntApldAmt, misc_paydet.curr_code as Ccy1, misc_paydet.pay_amt  as RmtdAmt, nvl(misc_payables.purc_order,misc_payables.ref_no) as Ref  ,misc_payment.bank_code as bank_code FROM MISC_PAYMENT , site , state , bank , "
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES "
					+ "WHERE misc_payment.site_code = site.site_code " + "and   site.state_code = state.state_code "
					+ "and   misc_payment.bank_code = bank.bank_code "
					+ "and   misc_payment.tran_id = misc_paydet.tran_id "
					+ "AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ "AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO " + "and   misc_payment.sundry_type=? "
					+ "and   misc_payment.sundry_code = supplier." + tranIdColmn + " and   MISC_PAYMENT.TRAN_ID=? "
					+ " and\tmisc_payment.sundry_type=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND MISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			pstmt.setString(3, sundryType);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")).trim());
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setChqNbStr(this.checkNull(rs.getString("ChqNb")).trim());
				hdrValObj.setPrtryStr(this.checkNull(rs.getString("Prtry")).trim());
				hdrValObj.setFrmsCdStr(this.checkNull(rs.getString("FrmsCd")).trim());
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setNbStr(this.checkNull(rs.getString("Nb")).trim());
				hdrValObj.setRltdDtStr(this.checkNull(rs.getString("RltdDt")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				hdrValObj.setDuePyblAmt(rs.getDouble("DuePyblAmt"));
				hdrValObj.setDscntApldAmt(rs.getDouble("DscntApldAmt"));
				hdrValObj.setRmtdAmt(rs.getDouble("RmtdAmt"));
				hdrValObj.setRefStr(this.checkNull(rs.getString("Ref")).trim());
				hdrValObj.setBankCodeStr(rs.getString("bank_code"));
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr = doc.createElement("Othr");
				othr.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Id.appendChild(othr);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId",
						hdrValObj.getInstrIdStr().trim() + hdrValObj.getBankCodeStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcyStr().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element chqInstr = doc.createElement("ChqInstr");
				chqInstr.appendChild(getElementValue(doc, "ChqNb", hdrValObj.getChqNbStr().trim()));
				Element dlvryMtd = doc.createElement("DlvryMtd");
				dlvryMtd.appendChild(getElementValue(doc, "Prtry", hdrValObj.getPrtryStr().trim()));
				chqInstr.appendChild(dlvryMtd);
				chqInstr.appendChild(getElementValue(doc, "FrmsCd", hdrValObj.getFrmsCdStr().trim()));
				cdtTrfTxInf.appendChild(chqInstr);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm1Str().trim()));
				Element pstlAdr2 = doc.createElement("PstlAdr");
				if ("S".equalsIgnoreCase(sundryType)) {
					System.out.println("@@ Sundry type IS 'S'");
					sql1 = "select alt_addr1 as AltAddr1, alt_addr2 || alt_addr3 as AltAddr2,alt_pin, alt_city, state_code__alt from supplier where supp_code=?";
					pstmt1 = conn.prepareStatement(sql1);
					pstmt1.setString(1, hdrValObj.getId1Str());
					rs1 = pstmt1.executeQuery();
					if (rs1.next()) {
						AltAddr1 = this.checkNull(rs1.getString("AltAddr1"));
						AltAddr2 = this.checkNull(rs1.getString("AltAddr2"));
						AltPin = this.checkNull(rs1.getString("alt_pin"));
						AltCity = this.checkNull(rs1.getString("alt_city"));
						AltState = this.checkNull(rs1.getString("state_code__alt"));
					}

					pstmt1.close();
					pstmt1 = null;
					rs1.close();
					rs1 = null;
					if (AltAddr1 != null && AltAddr1.trim().length() > 0
							|| AltAddr2 != null && AltAddr2.trim().length() > 0) {
						System.out.println("@@ Alt address NOT NULL");
						pstlAdr2.appendChild(getElementValue(doc, "PstCd", AltPin.trim()));
						pstlAdr2.appendChild(getElementValue(doc, "TwnNm", AltCity.trim()));
						pstlAdr2.appendChild(getElementValue(doc, "CtrySubDvsn", AltState.trim()));
						pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
						if (AltAddr1 != null && AltAddr1.trim().length() > 0) {
							pstlAdr2.appendChild(getElementValue(doc, "AdrLine", AltAddr1.trim()));
						}

						if (AltAddr2 != null && AltAddr2.trim().length() > 0) {
							pstlAdr2.appendChild(getElementValue(doc, "AdrLine", AltAddr2.trim()));
						}
					} else {
						System.out.println("@@ Alt address IS NULL");
						pstlAdr2.appendChild(getElementValue(doc, "PstCd", hdrValObj.getPstCdStr().trim()));
						pstlAdr2.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNmStr().trim()));
						pstlAdr2.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsnStr().trim()));
						pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
						if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
							pstlAdr2.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
						}

						if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
							pstlAdr2.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
						}
					}
				} else {
					System.out.println("@@ Sundry type NOT 'S'");
					pstlAdr2.appendChild(getElementValue(doc, "PstCd", hdrValObj.getPstCdStr().trim()));
					pstlAdr2.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNmStr().trim()));
					pstlAdr2.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsnStr().trim()));
					pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
					if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
						pstlAdr2.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
					}

					if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
						pstlAdr2.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
					}
				}

				cdtr.appendChild(pstlAdr2);
				Element id1 = doc.createElement("Id");
				Element orgId = doc.createElement("OrgId");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				orgId.appendChild(othr1);
				id1.appendChild(orgId);
				cdtr.appendChild(id1);
				cdtTrfTxInf.appendChild(cdtr);
				Element rmtInf = doc.createElement("RmtInf");
				rmtInf.appendChild(getElementValue(doc, "Ustrd", "Automatic Payment"));
				System.out.println("datalist.size()" + datalist.size());

				for (int j = 0; j < datalist.size(); ++j) {
					DataBean dbeanVal = (DataBean) datalist.get(j);
					Element strd = doc.createElement("Strd");
					Element rfrdDocInf = doc.createElement("RfrdDocInf");
					Element tp = doc.createElement("Tp");
					Element cdOrPrtry = doc.createElement("CdOrPrtry");
					if (dbeanVal.getDuePyblAmt() >= 0.0D) {
						cdOrPrtry.appendChild(getElementValue(doc, "Cd", dbeanVal.getCdStr().trim()));
					} else {
						cdOrPrtry.appendChild(getElementValue(doc, "Cd", "CREN"));
					}

					tp.appendChild(cdOrPrtry);
					rfrdDocInf.appendChild(tp);
					rfrdDocInf.appendChild(getElementValue(doc, "Nb", dbeanVal.getNbStr().trim()));
					rfrdDocInf.appendChild(getElementValue(doc, "RltdDt", dbeanVal.getRltdDtStr().trim()));
					strd.appendChild(rfrdDocInf);
					Element rfrdDocAmt = doc.createElement("RfrdDocAmt");
					Element duePybl_amt = doc.createElement("DuePyblAmt");
					duePybl_amt.setAttribute("Ccy", dbeanVal.getCcyStr().trim());
					duePybl_amt
							.setTextContent(utilMethods.getReqDecString(Math.abs(dbeanVal.getDuePyblAmt()), 2).trim());
					rfrdDocAmt.appendChild(duePybl_amt);
					Element dscntApld_amt = doc.createElement("DscntApldAmt");
					dscntApld_amt.setAttribute("Ccy", dbeanVal.getCcyStr().trim());
					dscntApld_amt.setTextContent(
							utilMethods.getReqDecString(Math.abs(dbeanVal.getDscntApldAmt()), 2).trim());
					rfrdDocAmt.appendChild(dscntApld_amt);
					Element rmtd_amt = doc.createElement("RmtdAmt");
					rmtd_amt.setAttribute("Ccy", dbeanVal.getCcy1Str().trim());
					rmtd_amt.setTextContent(utilMethods.getReqDecString(Math.abs(dbeanVal.getRmtdAmt()), 2).trim());
					rfrdDocAmt.appendChild(rmtd_amt);
					strd.appendChild(rfrdDocAmt);
					Element cdtrRefInf = doc.createElement("CdtrRefInf");
					cdtrRefInf.appendChild(getElementValue(doc, "Ref", dbeanVal.getRefStr().trim()));
					strd.appendChild(cdtrRefInf);
					rmtInf.appendChild(strd);
				}

				cdtTrfTxInf.appendChild(rmtInf);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var56) {
			var56.printStackTrace();
			throw new ITMException(var56);
		}
	}

	private Node getChequeInfoCTX(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'T'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;
		String bankTable = "";

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
				bankTable = "supplier_bank";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
				bankTable = "customer_bank";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
				bankTable = "transporter_bank";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
				bankTable = "loanparty_bank";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = "SELECT   MISC_PAYMENT.TRAN_ID||trim(misc_payment.bank_code) AS MsgId,     TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm,     1 as NbOfTxs,   misc_payment.net_amt__bc as CtrlSum,   site.descr as Nm,   misc_payment.tran_id as PmtInfId,   (case when misc_payment.pay_mode ='X' then 'TRF' else misc_payment.pay_mode end ) as PmtMtd,   1 as NbOfTxs,   misc_payment.net_amt__bc as CtrlSum,   'NURG' as Cd,   (case when misc_payment.pay_mode ='X' then 'CTX' else misc_payment.pay_mode end ) as Cd1,   to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt,   (select country.iso3166 from country where country.count_code = state.count_code)  as Ctry,   bank.udf_str7 as Id,    bank.udf_str6 as Prtry,   bank.ac_no as Id1,   bank.curr_code as Ccy,   bank.swift_code as BIC,    bank.udf_str8 as MmbId,  (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry1,   misc_payment.tran_id as InstrId,   misc_payment.tran_id AS EndToEndId,    misc_payment.curr_code as Ccy1,   misc_payment.net_amt__bc  as InstdAmt,   supplier_bank.bank_acct_no__ben as MmbId2,   supplier_bank.udf_str1 as MmbId1,   supplier_bank.bank_name__ben as Nm1,   supplier_bank.city__ben as TwnNm,   supplier_bank.state_code__ben as CtrySubDvsn,   (select country.iso3166 from country where country.count_code = supplier_bank.count_code__ben) as Ctry2,   supplier.chq_name as Nm2,   supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm,   supplier.addr1 as Addr1,   supplier.addr2 || supplier.addr3 as Addr2,   supplier.pin as PstCd,   supplier.city as TwnNm1,    supplier.state_code as CtrySubDvsn1,    (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry3,   supplier_bank.bank_acct_no__ben as Id2,  nvl(supplier_bank.udf_str3,'CASH') as Cd2,   misc_payables.ref_no as Ustrd,   'CINV' AS Cd3,   misc_payables.bill_no AS Nb,   to_char(misc_payables.bill_date,'yyyy-mm-dd') as RltdDt,   misc_paydet.pay_amt  as DuePyblAmt,    misc_paydet.discount_amt  as DscntApldAmt,    misc_paydet.tax_amt as TaxAmt,   misc_paydet.pay_amt  as RmtdAmt,    nvl(misc_payables.purc_order,misc_payables.ref_no) as Ref,misc_payment.bank_code as bank_code    FROM MISC_PAYMENT , site , state , bank , "
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES  , " + bankTable + " supplier_bank "
					+ "  WHERE misc_payment.site_code = site.site_code " + "  and   site.state_code = state.state_code "
					+ "  and   misc_payment.bank_code = bank.bank_code "
					+ "   and   misc_payment.tran_id = misc_paydet.tran_id "
					+ "  AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ "  AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " and   misc_payables.sundry_code = supplier_bank." + tranIdColmn
					+ " and supplier_bank.active_yn='Y' " + " and supplier_bank.confirmed='Y' "
					+ "and   misc_payment.sundry_type=? " + "and   misc_payment.sundry_code = supplier." + tranIdColmn
					+ " and   MISC_PAYMENT.TRAN_ID=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND MISC_PAYMENT.SUNDRY_CODE  = supplier_bank." + tranIdColmn
					+ " AND\tMISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setNm2Str(this.checkNull(rs.getString("Nm2")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")).trim());
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setCtry1Str(this.checkNull(rs.getString("Ctry1")).trim());
				hdrValObj.setCtry2Str(this.checkNull(rs.getString("Ctry2")).trim());
				hdrValObj.setCtry3Str(this.checkNull(rs.getString("Ctry3")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setId2Str(this.checkNull(rs.getString("Id2")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setMmbId1Str(this.checkNull(rs.getString("MmbId1")).trim());
				hdrValObj.setMmbId2Str(this.checkNull(rs.getString("MmbId2")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setPrtryStr(this.checkNull(rs.getString("Prtry")).trim());
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setTwnNm1Str(this.checkNull(rs.getString("TwnNm1")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCtrySubDvsn1Str(this.checkNull(rs.getString("CtrySubDvsn1")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setCd1Str(this.checkNull(rs.getString("Cd1")).trim());
				hdrValObj.setCd2Str(this.checkNull(rs.getString("Cd2")).trim());
				hdrValObj.setCd3Str(this.checkNull(rs.getString("Cd3")).trim());
				hdrValObj.setNbStr(this.checkNull(rs.getString("Nb")).trim());
				hdrValObj.setRltdDtStr(this.checkNull(rs.getString("RltdDt")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				hdrValObj.setDuePyblAmt(rs.getDouble("DuePyblAmt"));
				hdrValObj.setDscntApldAmt(rs.getDouble("DscntApldAmt"));
				hdrValObj.setRmtdAmt(rs.getDouble("RmtdAmt"));
				hdrValObj.setTaxAmt(rs.getDouble("TaxAmt"));
				hdrValObj.setRefStr(this.checkNull(rs.getString("Ref")).trim());
				hdrValObj.setBankCodeStr(this.checkNull(rs.getString("bank_code")).trim());
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				Element pmtTpInf = doc.createElement("PmtTpInf");
				Element svcLvl = doc.createElement("SvcLvl");
				svcLvl.appendChild(getElementValue(doc, "Cd", hdrValObj.getCdStr().trim()));
				pmtTpInf.appendChild(svcLvl);
				Element lclInstrm = doc.createElement("LclInstrm");
				lclInstrm.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd1Str().trim()));
				pmtTpInf.appendChild(lclInstrm);
				pmtInf.appendChild(pmtTpInf);
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				Element id = doc.createElement("Id");
				Element orgId = doc.createElement("OrgId");
				Element othr = doc.createElement("Othr");
				othr.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Element schmeNm = doc.createElement("SchmeNm");
				schmeNm.appendChild(getElementValue(doc, "Prtry", hdrValObj.getPrtryStr().trim()));
				othr.appendChild(schmeNm);
				orgId.appendChild(othr);
				id.appendChild(orgId);
				Dbtr.appendChild(id);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				Id.appendChild(othr1);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry1Str().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId",
						hdrValObj.getInstrIdStr().trim() + hdrValObj.getBankCodeStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcy1Str().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element cdtrAgt = doc.createElement("CdtrAgt");
				Element finInstnId1 = doc.createElement("FinInstnId");
				Element clrSysMmbId1 = doc.createElement("ClrSysMmbId");
				clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId1Str().trim()));
				finInstnId1.appendChild(clrSysMmbId1);
				Element pstlAdr2 = doc.createElement("PstlAdr");
				pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry2Str().trim()));
				finInstnId1.appendChild(pstlAdr2);
				cdtrAgt.appendChild(finInstnId1);
				cdtTrfTxInf.appendChild(cdtrAgt);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm2Str().trim()));
				Element pstlAdr3 = doc.createElement("PstlAdr");
				pstlAdr3.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNm1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsn1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry3Str().trim()));
				if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
				}

				if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
				}

				cdtr.appendChild(pstlAdr3);
				cdtTrfTxInf.appendChild(cdtr);
				Element cdtrAcct = doc.createElement("CdtrAcct");
				Element Id1 = doc.createElement("Id");
				Element othr2 = doc.createElement("Othr");
				othr2.appendChild(getElementValue(doc, "Id", hdrValObj.getMmbId2Str().trim()));
				Id1.appendChild(othr2);
				cdtrAcct.appendChild(Id1);
				Element tP = doc.createElement("Tp");
				tP.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd2Str().trim()));
				cdtrAcct.appendChild(tP);
				cdtTrfTxInf.appendChild(cdtrAcct);
				Element rmtInf = doc.createElement("RmtInf");
				rmtInf.appendChild(getElementValue(doc, "Ustrd", "Automatic Payment"));
				System.out.println("49");
				System.out.println("datalist.size()" + datalist.size());

				for (int j = 0; j < datalist.size(); ++j) {
					DataBean dbeanVal = (DataBean) datalist.get(j);
					Element strd = doc.createElement("Strd");
					Element rfrdDocInf = doc.createElement("RfrdDocInf");
					Element tp = doc.createElement("Tp");
					Element cdOrPrtry = doc.createElement("CdOrPrtry");
					System.out.println("Checked negative value--hdrValObj.getPmtInfIdStr().trim()["
							+ hdrValObj.getPmtInfIdStr().trim() + "]dbeanVal.getDuePyblAmt()["
							+ dbeanVal.getDuePyblAmt() + "]");
					if (dbeanVal.getDuePyblAmt() >= 0.0D) {
						cdOrPrtry.appendChild(getElementValue(doc, "Cd", dbeanVal.getCd3Str().trim()));
					} else {
						cdOrPrtry.appendChild(getElementValue(doc, "Cd", "CREN"));
					}

					tp.appendChild(cdOrPrtry);
					rfrdDocInf.appendChild(tp);
					rfrdDocInf.appendChild(getElementValue(doc, "Nb", dbeanVal.getNbStr().trim()));
					rfrdDocInf.appendChild(getElementValue(doc, "RltdDt", dbeanVal.getRltdDtStr().trim()));
					strd.appendChild(rfrdDocInf);
					Element rfrdDocAmt = doc.createElement("RfrdDocAmt");
					Element duePybl_amt = doc.createElement("DuePyblAmt");
					duePybl_amt.setAttribute("Ccy", dbeanVal.getCcy1Str().trim());
					duePybl_amt
							.setTextContent(utilMethods.getReqDecString(Math.abs(dbeanVal.getDuePyblAmt()), 2).trim());
					rfrdDocAmt.appendChild(duePybl_amt);
					Element dscntApld_amt = doc.createElement("DscntApldAmt");
					dscntApld_amt.setAttribute("Ccy", dbeanVal.getCcyStr().trim());
					dscntApld_amt.setTextContent(
							utilMethods.getReqDecString(Math.abs(dbeanVal.getDscntApldAmt()), 2).trim());
					rfrdDocAmt.appendChild(dscntApld_amt);
					Element tax_Amt = doc.createElement("TaxAmt");
					tax_Amt.setAttribute("Ccy", dbeanVal.getCcyStr().trim());
					tax_Amt.setTextContent(utilMethods.getReqDecString(Math.abs(dbeanVal.getTaxAmt()), 2).trim());
					rfrdDocAmt.appendChild(tax_Amt);
					Element rmtd_amt = doc.createElement("RmtdAmt");
					rmtd_amt.setAttribute("Ccy", dbeanVal.getCcy1Str().trim());
					rmtd_amt.setTextContent(utilMethods.getReqDecString(Math.abs(dbeanVal.getRmtdAmt()), 2).trim());
					rfrdDocAmt.appendChild(rmtd_amt);
					strd.appendChild(rfrdDocAmt);
					strd.appendChild(getElementValue(doc, "AddtlRmtInf", "--"));
					rmtInf.appendChild(strd);
				}

				cdtTrfTxInf.appendChild(rmtInf);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var59) {
			var59.printStackTrace();
			throw new ITMException(var59);
		}
	}

	private Node getChequeInfoPPD(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'V', 'PPD'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;
		String bankTable = "";

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
				bankTable = "supplier_bank";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
				bankTable = "customer_bank";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
				bankTable = "transporter_bank";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
				bankTable = "loanparty_bank";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = "SELECT  MISC_PAYMENT.TRAN_ID||trim(misc_payment.bank_code) AS MsgId,  TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm,  1 as NbOfTxs,  misc_payment.net_amt__bc as CtrlSum,  site.descr as Nm,  misc_payment.tran_id as PmtInfId,  (case when misc_payment.pay_mode ='V' then 'TRF' else misc_payment.pay_mode end ) as PmtMtd,  'NURG' as Cd,  (case when misc_payment.pay_mode ='V' then 'PPD' else misc_payment.pay_mode end ) as Cd1,  to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt,  (select country.iso3166 from country where country.count_code = state.count_code)  as Ctry,  bank.udf_str7 as Id,  bank.udf_str6 as Prtry,  bank.ac_no as Id1,  bank.curr_code as Ccy,  bank.swift_code as BIC,  bank.udf_str8 as MmbId,  (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry1,  misc_payment.tran_id as InstrId,  misc_payment.tran_id AS EndToEndId,  misc_payment.curr_code as Ccy1,  misc_payment.net_amt__bc  as InstdAmt,  supplier_bank.udf_str1 as MmbId1,  supplier_bank.bank_name__ben as Nm1,  supplier_bank.city__ben as TwnNm,  supplier_bank.state_code__ben as CtrySubDvsn,  (select country.iso3166 from country where country.count_code = supplier_bank.count_code__ben) as Ctry2,  supplier.chq_name as Nm2,  supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm,  supplier.addr1 as Addr1,  supplier.addr2 || supplier.addr3 as Addr2,  supplier.pin as PstCd,  supplier.city as TwnNm1,  supplier.state_code as CtrySubDvsn1,  (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry3,  supplier_bank.bank_acct_no__ben as Id2,  nvl(supplier_bank.udf_str3,'CASH') as Cd2 ,misc_payment.bank_code as bank_code  FROM MISC_PAYMENT , site , state , bank ,"
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES  ," + bankTable + " SUPPLIER_BANK "
					+ " WHERE misc_payment.site_code = site.site_code " + " and   site.state_code = state.state_code "
					+ " and   misc_payment.bank_code = bank.bank_code "
					+ " and   misc_payment.tran_id = misc_paydet.tran_id "
					+ " AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ " AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " and   misc_payables.sundry_code = supplier_bank." + tranIdColmn
					+ " and   misc_payment.sundry_type=? " + " and   misc_payment.sundry_code = supplier." + tranIdColmn
					+ " and   MISC_PAYMENT.TRAN_ID=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tsupplier_bank.confirmed= 'Y' " + " and\tsupplier_bank.active_yn = 'Y' "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND\t MISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " AND MISC_PAYMENT.SUNDRY_CODE  = supplier_bank."
					+ tranIdColmn + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setNm2Str(this.checkNull(rs.getString("Nm2")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")).trim());
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setCtry1Str(this.checkNull(rs.getString("Ctry1")).trim());
				hdrValObj.setCtry2Str(this.checkNull(rs.getString("Ctry2")).trim());
				hdrValObj.setCtry3Str(this.checkNull(rs.getString("Ctry3")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setId2Str(this.checkNull(rs.getString("Id2")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setMmbId1Str(this.checkNull(rs.getString("MmbId1")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setPrtryStr(this.checkNull(rs.getString("Prtry")).trim());
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setTwnNm1Str(this.checkNull(rs.getString("TwnNm1")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCtrySubDvsn1Str(this.checkNull(rs.getString("CtrySubDvsn1")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setCd1Str(this.checkNull(rs.getString("Cd1")).trim());
				hdrValObj.setCd2Str(this.checkNull(rs.getString("Cd2")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				hdrValObj.setBankCodeStr(this.checkNull(rs.getString("bank_code")).trim());
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				Element pmtTpInf = doc.createElement("PmtTpInf");
				Element svcLvl = doc.createElement("SvcLvl");
				svcLvl.appendChild(getElementValue(doc, "Cd", hdrValObj.getCdStr().trim()));
				pmtTpInf.appendChild(svcLvl);
				Element lclInstrm = doc.createElement("LclInstrm");
				lclInstrm.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd1Str().trim()));
				pmtTpInf.appendChild(lclInstrm);
				pmtInf.appendChild(pmtTpInf);
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				Element id = doc.createElement("Id");
				Element orgId = doc.createElement("OrgId");
				Element othr = doc.createElement("Othr");
				othr.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Element schmeNm = doc.createElement("SchmeNm");
				schmeNm.appendChild(getElementValue(doc, "Prtry", hdrValObj.getPrtryStr().trim()));
				othr.appendChild(schmeNm);
				orgId.appendChild(othr);
				id.appendChild(orgId);
				Dbtr.appendChild(id);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				Id.appendChild(othr1);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry1Str().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId",
						hdrValObj.getInstrIdStr().trim() + hdrValObj.getBankCodeStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcy1Str().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element cdtrAgt = doc.createElement("CdtrAgt");
				Element finInstnId1 = doc.createElement("FinInstnId");
				Element clrSysMmbId1 = doc.createElement("ClrSysMmbId");
				clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId1Str().trim()));
				finInstnId1.appendChild(clrSysMmbId1);
				Element pstlAdr2 = doc.createElement("PstlAdr");
				pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry2Str().trim()));
				finInstnId1.appendChild(pstlAdr2);
				cdtrAgt.appendChild(finInstnId1);
				cdtTrfTxInf.appendChild(cdtrAgt);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm2Str().trim()));
				Element pstlAdr3 = doc.createElement("PstlAdr");
				pstlAdr3.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNm1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsn1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry3Str().trim()));
				if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
				}

				if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
				}

				cdtr.appendChild(pstlAdr3);
				cdtTrfTxInf.appendChild(cdtr);
				Element cdtrAcct = doc.createElement("CdtrAcct");
				Element Id1 = doc.createElement("Id");
				Element othr2 = doc.createElement("Othr");
				othr2.appendChild(getElementValue(doc, "Id", hdrValObj.getId2Str().trim()));
				Id1.appendChild(othr2);
				cdtrAcct.appendChild(Id1);
				Element tP = doc.createElement("Tp");
				tP.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd2Str().trim()));
				cdtrAcct.appendChild(tP);
				cdtTrfTxInf.appendChild(cdtrAcct);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var47) {
			var47.printStackTrace();
			throw new ITMException(var47);
		}
	}

	private Node getChequeInfoCCD(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'U'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;
		String bankTable = "";

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
				bankTable = "supplier_bank";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
				bankTable = "customer_bank";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
				bankTable = "transporter_bank";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
				bankTable = "loanparty_bank";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = " SELECT  MISC_PAYMENT.TRAN_ID||trim(misc_payment.bank_code) AS MsgId,  TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm,  1 as NbOfTxs,  misc_payment.net_amt__bc as CtrlSum,  site.descr as Nm,  misc_payment.tran_id as PmtInfId,  (case when misc_payment.pay_mode ='U' then 'TRF' else misc_payment.pay_mode end ) as PmtMtd,  'NURG' as Cd,  (case when misc_payment.pay_mode ='U' then 'CCD' else misc_payment.pay_mode end ) as Cd1,  to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt,  (select country.iso3166 from country where country.count_code = state.count_code)  as Ctry,  bank.udf_str7 as Id,  bank.udf_str6 as Prtry,  bank.ac_no as Id1,  bank.curr_code as Ccy,  bank.swift_code as BIC,  bank.udf_str8 as MmbId,  (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry1,  misc_payment.tran_id as InstrId,  misc_payment.tran_id AS EndToEndId,  misc_payment.curr_code as Ccy1,  misc_payment.net_amt__bc  as InstdAmt,  supplier_bank.bank_acct_no__ben as MmbId1,  supplier_bank.bank_name__ben as Nm1,  supplier_bank.city__ben as TwnNm,  supplier_bank.state_code__ben as CtrySubDvsn,  supplier_bank.udf_str1 as MmbId2,  (select country.iso3166 from country where country.count_code = supplier_bank.count_code__ben) as Ctry2,  supplier.chq_name as Nm2,  supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm,  supplier.addr1 as Addr1,  supplier.addr2 || supplier.addr3 as Addr2,  supplier.pin as PstCd,  supplier.city as TwnNm1,  supplier.state_code as CtrySubDvsn1,  (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry3,  supplier_bank.bank_acct_no__ben as Id2,  nvl(supplier_bank.udf_str3,'CASH') as Cd2  FROM MISC_PAYMENT , site , state , bank ,"
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES  ," + bankTable + " SUPPLIER_BANK "
					+ " WHERE misc_payment.site_code = site.site_code " + " and   site.state_code = state.state_code "
					+ " and   misc_payment.bank_code = bank.bank_code "
					+ " and   misc_payment.tran_id = misc_paydet.tran_id "
					+ " AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ " AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " and   misc_payables.sundry_code = supplier_bank. " + tranIdColmn
					+ " and   misc_payment.sundry_type=? " + " and   misc_payment.sundry_code = supplier." + tranIdColmn
					+ " and   MISC_PAYMENT.TRAN_ID=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tsupplier_bank.confirmed= 'Y' " + " and\tsupplier_bank.active_yn = 'Y' "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND\tMISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " AND MISC_PAYMENT.SUNDRY_CODE  = supplier_bank."
					+ tranIdColmn + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setNm2Str(this.checkNull(rs.getString("Nm2")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")).trim());
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setCtry1Str(this.checkNull(rs.getString("Ctry1")).trim());
				hdrValObj.setCtry2Str(this.checkNull(rs.getString("Ctry2")).trim());
				hdrValObj.setCtry3Str(this.checkNull(rs.getString("Ctry3")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setId2Str(this.checkNull(rs.getString("Id2")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setMmbId1Str(this.checkNull(rs.getString("MmbId1")).trim());
				hdrValObj.setMmbId2Str(this.checkNull(rs.getString("MmbId2")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setPrtryStr(this.checkNull(rs.getString("Prtry")).trim());
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setTwnNm1Str(this.checkNull(rs.getString("TwnNm1")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCtrySubDvsn1Str(this.checkNull(rs.getString("CtrySubDvsn1")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setCd1Str(this.checkNull(rs.getString("Cd1")).trim());
				hdrValObj.setCd2Str(this.checkNull(rs.getString("Cd2")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				Element pmtTpInf = doc.createElement("PmtTpInf");
				Element svcLvl = doc.createElement("SvcLvl");
				svcLvl.appendChild(getElementValue(doc, "Cd", hdrValObj.getCdStr().trim()));
				pmtTpInf.appendChild(svcLvl);
				Element lclInstrm = doc.createElement("LclInstrm");
				lclInstrm.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd1Str().trim()));
				pmtTpInf.appendChild(lclInstrm);
				pmtInf.appendChild(pmtTpInf);
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				Element id = doc.createElement("Id");
				Element orgId = doc.createElement("OrgId");
				Element othr = doc.createElement("Othr");
				othr.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Element schmeNm = doc.createElement("SchmeNm");
				schmeNm.appendChild(getElementValue(doc, "Prtry", hdrValObj.getPrtryStr().trim()));
				othr.appendChild(schmeNm);
				orgId.appendChild(othr);
				id.appendChild(orgId);
				Dbtr.appendChild(id);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				Id.appendChild(othr1);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry1Str().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId", hdrValObj.getMsgIdStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcy1Str().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element cdtrAgt = doc.createElement("CdtrAgt");
				Element finInstnId1 = doc.createElement("FinInstnId");
				Element clrSysMmbId1 = doc.createElement("ClrSysMmbId");
				clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId2Str().trim()));
				finInstnId1.appendChild(clrSysMmbId1);
				Element pstlAdr2 = doc.createElement("PstlAdr");
				pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry2Str().trim()));
				finInstnId1.appendChild(pstlAdr2);
				cdtrAgt.appendChild(finInstnId1);
				cdtTrfTxInf.appendChild(cdtrAgt);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm2Str().trim()));
				Element pstlAdr3 = doc.createElement("PstlAdr");
				pstlAdr3.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNm1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsn1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry3Str().trim()));
				if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
				}

				if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
				}

				cdtr.appendChild(pstlAdr3);
				cdtTrfTxInf.appendChild(cdtr);
				Element cdtrAcct = doc.createElement("CdtrAcct");
				Element Id1 = doc.createElement("Id");
				Element othr2 = doc.createElement("Othr");
				othr2.appendChild(getElementValue(doc, "Id", hdrValObj.getMmbId1Str().trim()));
				Id1.appendChild(othr2);
				cdtrAcct.appendChild(Id1);
				Element tP = doc.createElement("Tp");
				tP.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd2Str().trim()));
				cdtrAcct.appendChild(tP);
				cdtTrfTxInf.appendChild(cdtrAcct);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var47) {
			var47.printStackTrace();
			throw new ITMException(var47);
		}
	}

	private Node getChequeInfoCCD_PLUS(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			String payMode, Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'N'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;
		String bankTable = "";

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
				bankTable = "supplier_bank";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
				bankTable = "customer_bank";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
				bankTable = "transporter_bank";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
				bankTable = "loanparty_bank";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = " SELECT  MISC_PAYMENT.TRAN_ID||trim(misc_payment.bank_code) AS MsgId,  misc_payment.remarks as Ustrd,  TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm,  1 as NbOfTxs,  misc_payment.net_amt__bc as CtrlSum,  site.descr as Nm,  misc_payment.tran_id as PmtInfId,  (case when misc_payment.pay_mode ='Z' then 'TRF' else misc_payment.pay_mode end ) as PmtMtd,  'NURG' as Cd,  (case when misc_payment.pay_mode ='Z' then 'CCD' else misc_payment.pay_mode end ) as Cd1,  to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt,  (select country.iso3166 from country where country.count_code = state.count_code)  as Ctry,  bank.udf_str7 as Id,  bank.udf_str6 as Prtry,  bank.ac_no as Id1,  bank.curr_code as Ccy,  bank.swift_code as BIC,  bank.udf_str8 as MmbId,  (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry1,  misc_payment.tran_id as InstrId,  misc_payment.tran_id AS EndToEndId,  misc_payment.curr_code as Ccy1,  misc_payment.net_amt__bc  as InstdAmt,  supplier_bank.bank_acct_no__ben as MmbId1,  supplier_bank.bank_name__ben as Nm1,  supplier_bank.city__ben as TwnNm,  supplier_bank.state_code__ben as CtrySubDvsn,  supplier_bank.udf_str1 as MmbId2,  (select country.iso3166 from country where country.count_code = supplier_bank.count_code__ben) as Ctry2,  supplier.chq_name as Nm2,  supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm,  supplier.addr1 as Addr1,  supplier.addr2 || supplier.addr3 as Addr2,  supplier.pin as PstCd,  supplier.city as TwnNm1,  supplier.state_code as CtrySubDvsn1,  (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry3,  supplier_bank.bank_acct_no__ben as Id2,  nvl(supplier_bank.udf_str3,'CASH') as Cd2  FROM MISC_PAYMENT , site , state , bank ,"
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES  ," + bankTable + " SUPPLIER_BANK "
					+ " WHERE misc_payment.site_code = site.site_code " + " and   site.state_code = state.state_code "
					+ " and   misc_payment.bank_code = bank.bank_code "
					+ " and   misc_payment.tran_id = misc_paydet.tran_id "
					+ " AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ " AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " and   misc_payables.sundry_code = supplier_bank." + tranIdColmn
					+ " and   misc_payment.sundry_type=? " + " and   misc_payment.sundry_code = supplier." + tranIdColmn
					+ " and   MISC_PAYMENT.TRAN_ID=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tsupplier_bank.confirmed= 'Y' " + " and\tsupplier_bank.active_yn = 'Y' "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND\tMISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " AND MISC_PAYMENT.SUNDRY_CODE  = supplier_bank."
					+ tranIdColmn + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setUstrdStr(this.checkNull(rs.getString("Ustrd")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setNm2Str(this.checkNull(rs.getString("Nm2")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")).trim());
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setCtry1Str(this.checkNull(rs.getString("Ctry1")).trim());
				hdrValObj.setCtry2Str(this.checkNull(rs.getString("Ctry2")).trim());
				hdrValObj.setCtry3Str(this.checkNull(rs.getString("Ctry3")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setId2Str(this.checkNull(rs.getString("Id2")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setMmbId1Str(this.checkNull(rs.getString("MmbId1")).trim());
				hdrValObj.setMmbId2Str(this.checkNull(rs.getString("MmbId2")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setPrtryStr(this.checkNull(rs.getString("Prtry")).trim());
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setTwnNm1Str(this.checkNull(rs.getString("TwnNm1")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCtrySubDvsn1Str(this.checkNull(rs.getString("CtrySubDvsn1")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setCd1Str(this.checkNull(rs.getString("Cd1")).trim());
				hdrValObj.setCd2Str(this.checkNull(rs.getString("Cd2")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				Element pmtTpInf = doc.createElement("PmtTpInf");
				Element svcLvl = doc.createElement("SvcLvl");
				svcLvl.appendChild(getElementValue(doc, "Cd", hdrValObj.getCdStr().trim()));
				pmtTpInf.appendChild(svcLvl);
				Element lclInstrm = doc.createElement("LclInstrm");
				if ("N".equalsIgnoreCase(payMode)) {
					lclInstrm.appendChild(getElementValue(doc, "Cd", "CCD"));
				} else {
					lclInstrm.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd1Str().trim()));
				}

				pmtTpInf.appendChild(lclInstrm);
				pmtInf.appendChild(pmtTpInf);
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				Element id = doc.createElement("Id");
				Element orgId = doc.createElement("OrgId");
				Element othr = doc.createElement("Othr");
				othr.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Element schmeNm = doc.createElement("SchmeNm");
				schmeNm.appendChild(getElementValue(doc, "Prtry", hdrValObj.getPrtryStr().trim()));
				othr.appendChild(schmeNm);
				orgId.appendChild(othr);
				id.appendChild(orgId);
				Dbtr.appendChild(id);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				Id.appendChild(othr1);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry1Str().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId", hdrValObj.getMsgIdStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcy1Str().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element cdtrAgt = doc.createElement("CdtrAgt");
				Element finInstnId1 = doc.createElement("FinInstnId");
				Element clrSysMmbId1 = doc.createElement("ClrSysMmbId");
				clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId2Str().trim()));
				finInstnId1.appendChild(clrSysMmbId1);
				Element pstlAdr2 = doc.createElement("PstlAdr");
				pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry2Str().trim()));
				finInstnId1.appendChild(pstlAdr2);
				cdtrAgt.appendChild(finInstnId1);
				cdtTrfTxInf.appendChild(cdtrAgt);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm2Str().trim()));
				Element pstlAdr3 = doc.createElement("PstlAdr");
				pstlAdr3.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNm1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsn1Str().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry3Str().trim()));
				if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
				}

				if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
				}

				cdtr.appendChild(pstlAdr3);
				cdtTrfTxInf.appendChild(cdtr);
				Element cdtrAcct = doc.createElement("CdtrAcct");
				Element Id1 = doc.createElement("Id");
				Element othr2 = doc.createElement("Othr");
				othr2.appendChild(getElementValue(doc, "Id", hdrValObj.getMmbId1Str().trim()));
				Id1.appendChild(othr2);
				cdtrAcct.appendChild(Id1);
				Element tP = doc.createElement("Tp");
				tP.appendChild(getElementValue(doc, "Cd", hdrValObj.getCd2Str().trim()));
				cdtrAcct.appendChild(tP);
				cdtTrfTxInf.appendChild(cdtrAcct);
				Element RmtInf = doc.createElement("RmtInf");
				RmtInf.appendChild(getElementValue(doc, "Ustrd", hdrValObj.getUstrdStr().trim()));
				cdtTrfTxInf.appendChild(RmtInf);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var49) {
			var49.printStackTrace();
			throw new ITMException(var49);
		}
	}

	private Node getChequeInfoFEDW(Element cstmrCdtTrfInitn, Document doc, String miscPayId, String sundryType,
			Connection conn) throws ITMException {
		System.out.println("Method for payment mode 'F'");
		String sqlStr = "";
		String syndryTable = "";
		String tranIdColmn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		System.out.println("miscPayId is :" + miscPayId);
		ArrayList<DataBean> datalist = new ArrayList();
		Element returnNode = null;
		String bankTable = "";

		try {
			System.out.println("Sundry type :- [" + sundryType + "] miscPayId :- [" + miscPayId + "]");
			if ("S".equalsIgnoreCase(sundryType)) {
				syndryTable = "supplier";
				tranIdColmn = "supp_code";
				bankTable = "supplier_bank";
			} else if ("C".equalsIgnoreCase(sundryType)) {
				syndryTable = "customer";
				tranIdColmn = "cust_code";
				bankTable = "customer_bank";
			} else if ("T".equalsIgnoreCase(sundryType)) {
				syndryTable = "transporter";
				tranIdColmn = "tran_code";
				bankTable = "transporter_bank";
			} else if ("L".equalsIgnoreCase(sundryType)) {
				syndryTable = "loanparty";
				tranIdColmn = "party_code";
				bankTable = "loanparty_bank";
			} else if ("P".equalsIgnoreCase(sundryType)) {
				syndryTable = "sales_pers";
				tranIdColmn = "sales_pers";
			}

			UtilMethods utilMethods = new UtilMethods();
			sqlStr = "SELECT  MISC_PAYMENT.TRAN_ID AS MsgId,  TO_CHAR(SYSDATE,'YYYY-MM-DD') || 'T' ||TO_CHAR(SYSDATE,'HH:MM:SS') AS CreDtTm,  1 as NbOfTxs,  misc_payment.net_amt__bc as CtrlSum,  site.descr as Nm,  misc_payment.tran_id as PmtInfId,  misc_payment.bank_code as BnkCode,  (case when misc_payment.pay_mode ='F' then 'TRF' else misc_payment.pay_mode end ) as PmtMtd,  'URGP' as Cd,  to_char(misc_payment.ref_date,'YYYY-MM-DD') as ReqdExctnDt,  (select country.iso3166 from country where country.count_code = state.count_code)  as Ctry,  bank.ac_no as Id,  bank.curr_code as Ccy,  bank.swift_code as BIC,  bank.udf_str8 as MmbId,  (select country.iso3166 from country where country.count_code = bank.count_code) as Ctry1,  misc_payment.tran_id as InstrId,  misc_payment.tran_id AS EndToEndId,  misc_payment.curr_code as Ccy1,  misc_payment.net_amt__bc  as InstdAmt,  supplier_bank.bank_acct_no__ben as MmbId1,  supplier_bank.bank_name__ben as Nm1,  (select country.iso3166 from country where country.count_code = supplier_bank.count_code__ben) as Ctry2,  supplier.chq_name as Nm2,  supplier.addr1 || supplier.addr2 || supplier.addr3 as StrtNm,  supplier.addr1 as Addr1,  supplier.addr2 || supplier.addr3 as Addr2,  supplier.pin as PstCd,  supplier.city as TwnNm,  supplier.state_code as CtrySubDvsn,  (select country.iso3166 from country where country.count_code = supplier.count_code) as Ctry3,  supplier_bank.bank_acct_no__ben as Id1,  supplier_bank.udf_str1 as MmbId2,  supplier_bank.udf_str2 as MmbId3,  supplier_bank.bank_name__ben as Nm3,  misc_payment.remarks as Ustrd  FROM MISC_PAYMENT , site , state , bank ,"
					+ syndryTable + " supplier , misc_paydet , MISC_PAYABLES  ," + bankTable + " SUPPLIER_BANK "
					+ " WHERE misc_payment.site_code = site.site_code " + " and   site.state_code = state.state_code "
					+ " and   misc_payment.bank_code = bank.bank_code "
					+ " and   misc_payment.tran_id = misc_paydet.tran_id "
					+ " AND   MISC_PAYDET.TRAN_SER = MISC_PAYABLES.TRAN_SER "
					+ " AND   MISC_PAYDET.VOUCH_NO = MISC_PAYABLES.REF_NO "
					+ " and   misc_payables.sundry_code = supplier_bank." + tranIdColmn
					+ " and   misc_payment.sundry_type=? " + " and   misc_payment.sundry_code = supplier." + tranIdColmn
					+ " and   MISC_PAYMENT.TRAN_ID=? " + " and\tmisc_payment.net_amt__bc > 0 "
					+ " and\tsupplier_bank.confirmed= 'Y' " + " and\tsupplier_bank.active_yn = 'Y' "
					+ " and\tmisc_payment.curr_code = bank.curr_code "
					+ " AND\tMISC_PAYMENT.SUNDRY_CODE = MISC_PAYDET.SUNDRY_CODE "
					+ " AND MISC_PAYMENT.WF_STATUS IN ('S','C') " + " AND MISC_PAYMENT.SUNDRY_CODE  = supplier_bank."
					+ tranIdColmn + " and\tmisc_payment.eff_date is null "
					+ " and\tmisc_payment.tran_id not in (select payment_no from misc_payment_canc where confirmed = 'Y')";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, sundryType);
			pstmt.setString(2, miscPayId);
			rs = pstmt.executeQuery();

			DataBean hdrValObj;
			while (rs.next()) {
				hdrValObj = new DataBean();
				hdrValObj.setMsgIdStr(this.checkNull(rs.getString("MsgId")).trim());
				hdrValObj.setCreDtTmStr(this.checkNull(rs.getString("CreDtTm")).trim());
				hdrValObj.setNbOfTxsStr(this.checkNull(rs.getString("NbOfTxs")).trim());
				hdrValObj.setBankCodeStr(this.checkNull(rs.getString("BnkCode")).trim());
				hdrValObj.setNmStr(this.checkNull(rs.getString("Nm")).trim());
				hdrValObj.setNm1Str(this.checkNull(rs.getString("Nm1")).trim());
				hdrValObj.setNm2Str(this.checkNull(rs.getString("Nm2")).trim());
				hdrValObj.setNm3Str(this.checkNull(rs.getString("Nm3")).trim());
				hdrValObj.setPmtInfIdStr(this.checkNull(rs.getString("PmtInfId")));
				hdrValObj.setPmtMtdStr(this.checkNull(rs.getString("PmtMtd")).trim());
				hdrValObj.setCtrlSumdbl(rs.getDouble("CtrlSum"));
				hdrValObj.setReqdExctnDtStr(this.checkNull(rs.getString("ReqdExctnDt")).trim());
				hdrValObj.setCtryStr(this.checkNull(rs.getString("Ctry")).trim());
				hdrValObj.setCtry1Str(this.checkNull(rs.getString("Ctry1")).trim());
				hdrValObj.setCtry2Str(this.checkNull(rs.getString("Ctry2")).trim());
				hdrValObj.setCtry3Str(this.checkNull(rs.getString("Ctry3")).trim());
				hdrValObj.setIdStr(this.checkNull(rs.getString("Id")).trim());
				hdrValObj.setId1Str(this.checkNull(rs.getString("Id1")).trim());
				hdrValObj.setCcyStr(this.checkNull(rs.getString("Ccy")).trim());
				hdrValObj.setBICStr(this.checkNull(rs.getString("BIC")).trim());
				hdrValObj.setMmbIdStr(this.checkNull(rs.getString("MmbId")).trim());
				hdrValObj.setMmbId1Str(this.checkNull(rs.getString("MmbId1")).trim());
				hdrValObj.setMmbId2Str(this.checkNull(rs.getString("MmbId2")).trim());
				hdrValObj.setMmbId3Str(this.checkNull(rs.getString("MmbId3")).trim());
				hdrValObj.setInstrIdStr(this.checkNull(rs.getString("InstrId")).trim());
				hdrValObj.setEndToEndIdStr(this.checkNull(rs.getString("EndToEndId")).trim());
				hdrValObj.setInstdAmtdbl(rs.getDouble("InstdAmt"));
				hdrValObj.setStrtNmStr(this.checkNull(rs.getString("StrtNm")).trim());
				hdrValObj.setAddr1Str(this.checkNull(rs.getString("Addr1")).trim());
				hdrValObj.setAddr2Str(this.checkNull(rs.getString("Addr2")).trim());
				hdrValObj.setPstCdStr(this.checkNull(rs.getString("PstCd")).trim());
				hdrValObj.setTwnNmStr(this.checkNull(rs.getString("TwnNm")).trim());
				hdrValObj.setCtrySubDvsnStr(this.checkNull(rs.getString("CtrySubDvsn")).trim());
				hdrValObj.setCdStr(this.checkNull(rs.getString("Cd")).trim());
				hdrValObj.setCcy1Str(this.checkNull(rs.getString("Ccy1")).trim());
				hdrValObj.setUstrdStr(this.checkNull(rs.getString("Ustrd")).trim());
				datalist.add(hdrValObj);
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if (datalist.size() > 0) {
				hdrValObj = (DataBean) datalist.get(0);
				Element pmtInf;
				if (hdrValObj.getMsgIdStr() == "" || hdrValObj.getMsgIdStr().length() <= 0) {
					System.out.println("Data not found for payment id :" + miscPayId);
					pmtInf = null;
					throw new Exception();
				}

				pmtInf = doc.createElement("PmtInf");
				pmtInf.appendChild(getElementValue(doc, "PmtInfId", hdrValObj.getPmtInfIdStr()));
				pmtInf.appendChild(getElementValue(doc, "PmtMtd", hdrValObj.getPmtMtdStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "NbOfTxs", hdrValObj.getNbOfTxsStr().trim()));
				pmtInf.appendChild(getElementValue(doc, "CtrlSum",
						utilMethods.getReqDecString(hdrValObj.getCtrlSumdbl(), 2).trim()));
				Element pmtTpInf = doc.createElement("PmtTpInf");
				Element svcLvl = doc.createElement("SvcLvl");
				svcLvl.appendChild(getElementValue(doc, "Cd", hdrValObj.getCdStr().trim()));
				pmtTpInf.appendChild(svcLvl);
				pmtInf.appendChild(pmtTpInf);
				pmtInf.appendChild(getElementValue(doc, "ReqdExctnDt", hdrValObj.getReqdExctnDtStr().trim()));
				Element Dbtr = doc.createElement("Dbtr");
				Dbtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNmStr().trim()));
				Element pstlAdr = doc.createElement("PstlAdr");
				pstlAdr.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtryStr().trim()));
				Dbtr.appendChild(pstlAdr);
				pmtInf.appendChild(Dbtr);
				Element dbtrAcct = doc.createElement("DbtrAcct");
				Element Id = doc.createElement("Id");
				Element othr1 = doc.createElement("Othr");
				othr1.appendChild(getElementValue(doc, "Id", hdrValObj.getIdStr().trim()));
				Id.appendChild(othr1);
				dbtrAcct.appendChild(Id);
				dbtrAcct.appendChild(getElementValue(doc, "Ccy", hdrValObj.getCcyStr().trim()));
				pmtInf.appendChild(dbtrAcct);
				Element dbtrAgt = doc.createElement("DbtrAgt");
				Element finInstnId = doc.createElement("FinInstnId");
				finInstnId.appendChild(getElementValue(doc, "BIC", hdrValObj.getBICStr().trim()));
				Element clrSysMmbId = doc.createElement("ClrSysMmbId");
				clrSysMmbId.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbIdStr().trim()));
				finInstnId.appendChild(clrSysMmbId);
				Element pstlAdr1 = doc.createElement("PstlAdr");
				pstlAdr1.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry1Str().trim()));
				finInstnId.appendChild(pstlAdr1);
				dbtrAgt.appendChild(finInstnId);
				pmtInf.appendChild(dbtrAgt);
				Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
				Element pmtId = doc.createElement("PmtId");
				pmtId.appendChild(getElementValue(doc, "InstrId",
						hdrValObj.getInstrIdStr().trim() + hdrValObj.getBankCodeStr().trim()));
				pmtId.appendChild(
						getElementValue(doc, "EndToEndId", hdrValObj.getEndToEndIdStr().trim() + this.customDateVal));
				cdtTrfTxInf.appendChild(pmtId);
				Element amt = doc.createElement("Amt");
				Element instd_amt = doc.createElement("InstdAmt");
				instd_amt.setAttribute("Ccy", hdrValObj.getCcy1Str().trim());
				instd_amt.setTextContent(utilMethods.getReqDecString(hdrValObj.getInstdAmtdbl(), 2).trim());
				amt.appendChild(instd_amt);
				cdtTrfTxInf.appendChild(amt);
				Element cdtrAgt = doc.createElement("CdtrAgt");
				Element finInstnId1 = doc.createElement("FinInstnId");
				Element clrSysMmbId1 = doc.createElement("ClrSysMmbId");
				if (hdrValObj.getMmbId3Str() != null && hdrValObj.getMmbId3Str().trim().length() > 0) {
					clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId3Str().trim()));
				} else {
					clrSysMmbId1.appendChild(getElementValue(doc, "MmbId", hdrValObj.getMmbId2Str().trim()));
				}

				finInstnId1.appendChild(clrSysMmbId1);
				Element pstlAdr2 = doc.createElement("PstlAdr");
				pstlAdr2.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry2Str().trim()));
				finInstnId1.appendChild(pstlAdr2);
				cdtrAgt.appendChild(finInstnId1);
				cdtTrfTxInf.appendChild(cdtrAgt);
				Element cdtr = doc.createElement("Cdtr");
				cdtr.appendChild(getElementValue(doc, "Nm", hdrValObj.getNm2Str().trim()));
				Element pstlAdr3 = doc.createElement("PstlAdr");
				pstlAdr3.appendChild(getElementValue(doc, "PstCd", hdrValObj.getPstCdStr().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "TwnNm", hdrValObj.getTwnNmStr().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "CtrySubDvsn", hdrValObj.getCtrySubDvsnStr().trim()));
				pstlAdr3.appendChild(getElementValue(doc, "Ctry", hdrValObj.getCtry3Str().trim()));
				if (hdrValObj.getAddr1Str() != null && hdrValObj.getAddr1Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr1Str().trim()));
				}

				if (hdrValObj.getAddr2Str() != null && hdrValObj.getAddr2Str().trim().length() > 0) {
					pstlAdr3.appendChild(getElementValue(doc, "AdrLine", hdrValObj.getAddr2Str().trim()));
				}

				cdtr.appendChild(pstlAdr3);
				cdtTrfTxInf.appendChild(cdtr);
				Element cdtrAcct = doc.createElement("CdtrAcct");
				Element Id1 = doc.createElement("Id");
				Element othr2 = doc.createElement("Othr");
				othr2.appendChild(getElementValue(doc, "Id", hdrValObj.getId1Str().trim()));
				Id1.appendChild(othr2);
				cdtrAcct.appendChild(Id1);
				cdtTrfTxInf.appendChild(cdtrAcct);
				Element rmtInf = doc.createElement("RmtInf");
				rmtInf.appendChild(getElementValue(doc, "Ustrd", hdrValObj.getUstrdStr().trim()));
				cdtTrfTxInf.appendChild(rmtInf);
				pmtInf.appendChild(cdtTrfTxInf);
				cstmrCdtTrfInitn.appendChild(pmtInf);
				returnNode = cstmrCdtTrfInitn;
			}

			return returnNode;
		} catch (Exception var42) {
			var42.printStackTrace();
			throw new ITMException(var42);
		}
	}

	private static Node getElementValue(Document doc, String name, String value) {
		Element node = doc.createElement(name);
		node.appendChild(doc.createTextNode(value));
		return node;
	}

	private String putFile(String username, String host, String password, String port, String remotefile,
			String localfile) {
		JSch jsch = new JSch();
		Session session = null;

		try {
			System.out.println("inside putFile ...........");
			System.out.println("username :" + username);
			System.out.println("host :" + host);
			System.out.println("password :" + password);
			System.out.println("port :" + port);
			System.out.println("remotefile :" + remotefile);
			System.out.println("localfile :" + localfile);
			session = jsch.getSession(username, host, Integer.parseInt(port));
			session.setConfig("StrictHostKeyChecking", "no");
			session.setPassword(password);
			session.connect();
			Channel channel = session.openChannel("sftp");
			channel.connect();
			System.out.println("channel success...........");
			ChannelSftp sftpChannel = (ChannelSftp) channel;
			System.out.println("process starts for upload localfile to remote path.......");
			sftpChannel.put(localfile, remotefile);
			System.out.println("The first file is uploaded successfully.");
			sftpChannel.exit();
			session.disconnect();
			return "success";
		} catch (JSchException var11) {
			var11.printStackTrace();
			return "false";
		} catch (SftpException var12) {
			var12.printStackTrace();
			return "false";
		}
	}

	private void setSFTPConfig() {
		new CommonConstants();
		String fileName = null;
		String xmlString = "";
		Document dom = null;
		String sCurrentLine = "";
		System.out.println("  in setSFTPConfig -------------------------");
		new StringBuilder();

		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			dom = db.parse("/IBASEHOME/ibase.xml");
			this.pmtRmFilePath = dom.getElementsByTagName("PMT_SFTP_PATH").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtRmFilePath  :::: " + this.pmtRmFilePath);
			this.locFilePath = dom.getElementsByTagName("PMT_EXPORT_PATH").item(0).getFirstChild().getNodeValue();
			System.out.println("LocFilePath  :::: " + this.locFilePath);
			this.pmtBackupFilePath = dom.getElementsByTagName("PMT_BACK_PATH").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtBackupFilePath  :::: " + this.pmtBackupFilePath);
			this.pmtHost = dom.getElementsByTagName("PMT_SFTP_HOST").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtHost  :::: " + this.pmtHost);
			this.pmtUser = dom.getElementsByTagName("PMT_SFTP_USER").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtUser  :::: " + this.pmtUser);
			this.pmtPwd = dom.getElementsByTagName("PMT_SFTP_PWD").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtPwd  :::: " + this.pmtPwd);
			this.pmtPort = dom.getElementsByTagName("PMT_SFTP_PORT").item(0).getFirstChild().getNodeValue();
			System.out.println("pmtPort  :::: " + this.pmtPort);
		} catch (Exception var9) {
			var9.printStackTrace();
		}

	}

	public void moveUploadFile(File src, File dst) throws IOException {
		InputStream in = new FileInputStream(src);
		OutputStream out = new FileOutputStream(dst);
		byte[] buf = new byte[1024];

		int len;
		while ((len = in.read(buf)) > 0) {
			out.write(buf, 0, len);
		}

		in.close();
		out.close();
		System.out.println("File is copied successful!");
		src.delete();
		System.out.println("original file delete successful !");
	}

	private String checkNull(String input) {
		if (input == null) {
			input = " ";
		}

		return input;
	}
}