package ibase.webitm.ejb.fin;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EpayCityAus {
	int MAXBLANKROWS = 33;
	String userId = "";
	String sundryType = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams, String filePath,
			String destinationPath, Connection conn) throws ITMException {
		String retStr = "";
		String tranId = "";
		String gentext = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		String retString = "";
		String errCode = "";
		String textDoc = "";
		String textDoc1 = "";
		String fileName = "";
		String nameOpt = "";
		String refDateAppfmt = "";
		NumberFormat formatter = new DecimalFormat("#0.00");
		String hdrLines = null;
		ArrayList<String> tranIdList = null;
		ArrayList<String> detailBatchIdList = null;
		boolean isError = true;

		label353 : {
			String var81;
			try {
				String jbossPath = null;
				jbossPath = CommonConstants.JBOSSHOME;
				this.sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
				System.out.println("sundryType :: " + this.sundryType);
				Node currDetail = null;
				NodeList detailList = null;
				detailList = detailDom.getElementsByTagName("Detail2");
				int noOfDetails = 0;
				noOfDetails = detailList.getLength();
				this.genericUtility.getColumnValue("nameoption", headerDom);
				Timestamp refDate = null;
				Timestamp sysDate = null;
				Timestamp Key = null;
				String currSystDate = "";
				String appRef_date = "";
				String currentSql = "";
				String finEntity = "";
				String descr = "";
				String bankNameBen = "";
				String bankAcctNoBen = "";
				String sundryCode = "";
				String bankAccNo = "";
				String finalStr = "";
				String tranDate = "";
				String siteCode = "";
				String detailTranId = "";
				String ifscCode = "";
				String payMode = "";
				String bankCode = "";
				String fileDescr = "";
				String fileDescription = "";
				String tempFileName = "";
				String detailDesr = "";
				double netAmt = 0.0D;
				HashMap<Timestamp, ArrayList<EpayElement>> processData = new HashMap();
				new HashMap();
				String header = null;
				String footer = null;
				String headerFurDate = "";
				String footerFurDate = "";
				String finalStrFurDate = "";
				String detailStrFurDate = "";
				ArrayList<EpayElement> epayList = null;
				ArrayList<EpayElement> epayListValue = null;
				String date = "";
				ArrayList totalNetList = null;
				int upd = 0;
				double totNetAmt = 0.0D;
				String detailStr = "";
				EpayElement epayElement = null;
				int cnt = 0;
				this.userId = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
				bankCode = this.checkNull(this.genericUtility.getColumnValue("bank_code", headerDom));
				System.out.println(">>>sundryType[" + this.sundryType + "] bankCode[" + bankCode + "]");
				sql = " select descr,udf_str3 from gencodes where fld_name = 'SITE_CODE' and mod_name = 'W_E_PAYMENT_CITY'  and active = 'Y' and sh_descr = ? and udf_str1= 'N' and udf_str2 = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bankCode.trim());
				pstmt.setString(2, this.sundryType.trim());
				rs = pstmt.executeQuery();
				if (rs.next()) {
					fileDescr = this.checkNull(rs.getString("descr")).trim();
					detailDesr = this.checkNull(rs.getString("udf_str3"));
				}

				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				System.out.println(">>>fileDescr[" + fileDescr + "] detailDesr [" + detailDesr + "]");
				currentSql = "select sysdate from dual";
				pstmt = conn.prepareStatement(currentSql);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					sysDate = rs.getTimestamp(1);
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("132 sysDate [" + sysDate + "]");

				for (int ctr = 0; ctr < noOfDetails; ++ctr) {
					String tId = null;
					currDetail = detailList.item(ctr);
					tId = this.genericUtility.getColumnValueFromNode("tran_id", currDetail);
					finEntity = this.checkNull(this.genericUtility.getColumnValueFromNode("fin_entity", currDetail));
					descr = this.checkNull(this.genericUtility.getColumnValueFromNode("descr", currDetail));
					refDate = Timestamp.valueOf(this.genericUtility.getColumnValueFromNode("ref_date", currDetail));
					bankNameBen = this
							.checkNull(this.genericUtility.getColumnValueFromNode("bank_name__ben", currDetail));
					bankAcctNoBen = this
							.checkNull(this.genericUtility.getColumnValueFromNode("bank_acct_no__ben", currDetail));
					netAmt = Double.parseDouble(this.genericUtility.getColumnValueFromNode("net_amt", currDetail));
					this.sundryType = this
							.checkNull(this.genericUtility.getColumnValueFromNode("sundry_type", currDetail));
					sundryCode = this.checkNull(this.genericUtility.getColumnValueFromNode("sundry_code", currDetail));
					bankAccNo = this.checkNull(this.genericUtility.getColumnValueFromNode("ac_no", currDetail));
					ifscCode = this.checkNull(this.genericUtility.getColumnValueFromNode("bank_ifsc_code", currDetail));
					this.checkNull(this.genericUtility.getColumnValueFromNode("tran_date", currDetail));
					this.checkNull(this.genericUtility.getColumnValueFromNode("site_code", currDetail));
					epayElement = new EpayElement();
					epayElement.setFinEntity(finEntity);
					epayElement.setDescr(descr);
					epayElement.setRefDate(refDate);
					epayElement.setBankNameBen(bankNameBen);
					epayElement.setBankAcctNoBen(bankAcctNoBen);
					epayElement.setNetAmt(netAmt);
					epayElement.setSundryType(this.sundryType);
					epayElement.setSundryCode(sundryCode);
					epayElement.setBankAccNo(bankAccNo);
					epayElement.setIfscCode(ifscCode);
					epayElement.setTranid(tId);
					System.out.println(">>>fileDescription[" + fileDescr + "]");
					if (fileDescr != null && fileDescr.trim().length() > 5) {
						fileDescription = fileDescr.substring(5, fileDescr.length()).trim();
					} else {
						fileDescription = "";
					}

					System.out.println("@@@@@@@@ fileDescription[" + fileDescription + "]");
					System.out.println("193 sysDate [" + sysDate + "] ref_date [" + refDate + "]");
					String mainTblName = null;
					String mainTblCode = null;
					String bankTblName = null;
					String bankTblCode = null;
					if ("T".equalsIgnoreCase(this.sundryType)) {
						mainTblName = "TRANSPORTER";
						mainTblCode = "TRAN_CODE";
						bankTblName = "TRANSPORTER_BANK";
						bankTblCode = "TRAN_CODE";
					} else if ("S".equalsIgnoreCase(this.sundryType)) {
						mainTblName = "SUPPLIER";
						mainTblCode = "SUPP_CODE";
						bankTblName = "SUPPLIER_BANK";
						bankTblCode = "SUPP_CODE";
					}

					if (refDate != null && (refDate.before(sysDate) || refDate.equals(sysDate))) {
						new ArrayList();
						if (processData.containsKey(sysDate)) {
							epayList = (ArrayList) processData.get(sysDate);
							epayList.add(epayElement);
							processData.put(sysDate, epayList);
						} else {
							epayList = new ArrayList();
							epayList.add(epayElement);
							processData.put(sysDate, epayList);
						}
					} else if (refDate != null && refDate.after(sysDate)) {
						new ArrayList();
						if (processData.containsKey(refDate)) {
							epayList = (ArrayList) processData.get(refDate);
							epayList.add(epayElement);
							processData.put(refDate, epayList);
						} else {
							epayList = new ArrayList();
							epayList.add(epayElement);
							processData.put(refDate, epayList);
						}
					} else {
						System.out.println(
								"20/02/15 tran_id [" + tId + "] skipped as there was no header data retrieved");
					}
				}

				new ArrayList();
				if (processData != null) {
					Iterator var95 = processData.entrySet().iterator();

					while (true) {
						if (!var95.hasNext()) {
							Util.EncriptFileCITIAUS(detailBatchIdList, filePath, destinationPath);
							break;
						}

						Entry<Timestamp, ArrayList<EpayElement>> epayEntry = (Entry) var95.next();
						tranIdList = new ArrayList();
						detailBatchIdList = new ArrayList();
						detailTranId = generateTranId("w_e_payment_city", this.userId, conn);
						detailBatchIdList.add(detailTranId);
						tempFileName = fileDescription.trim() + detailTranId.trim();
						Key = (Timestamp) epayEntry.getKey();
						epayListValue = (ArrayList) epayEntry.getValue();
						System.out.println("printing epayListValue.size():::" + epayListValue.size());
						detailStr = "";

						for (int j = 0; j < epayListValue.size(); ++j) {
							if (j == 0) {
								epayElement = (EpayElement) epayListValue.get(j);
								descr = epayElement.getDescr();
								refDate = epayElement.getRefDate();
								if (Key != null) {
									refDateAppfmt = this.genericUtility.getValidDateString(Key.toString(),
											this.genericUtility.getDBDateFormat(),
											this.genericUtility.getApplDateFormat());
									System.out.println("Getting oldTaxRegDateConverted::>>" + refDateAppfmt);
								}

								pstmt = conn.prepareStatement(
										"select RPAD(0,18,' ')||' 1'||'Cti'||RPAD(' ',7,' ')||RPAD(SUBSTR('" + descr
												+ "',1,25),26,' ')||'442865'||RPAD(101,12,' ')|| TO_CHAR(  to_date('"
												+ refDateAppfmt
												+ "','dd/mm/yy'),'DDMMYY') ||RPAD(' ',40,' ') from dual");
								rs = pstmt.executeQuery();
								if (rs.next()) {
									header = rs.getString(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}

							epayElement = (EpayElement) epayListValue.get(j);
							bankNameBen = epayElement.getBankNameBen();
							bankAcctNoBen = epayElement.getBankAcctNoBen();
							netAmt = epayElement.getNetAmt();
							totNetAmt += netAmt;
							this.sundryType = epayElement.getSundryType();
							sundryCode = epayElement.getSundryCode();
							descr = epayElement.getDescr();
							bankAccNo = epayElement.getBankAccNo();
							ifscCode = epayElement.getIfscCode();
							tranId = epayElement.getTranid();
							tranIdList.add(tranId);
							pstmt = conn.prepareStatement(" select  1||'" + bankNameBen + "'||LPAD('" + bankAcctNoBen
									+ "',9,' ')||' '||50||LPAD(TO_NUMBER(REPLACE('" + formatter.format(netAmt)
									+ "','.')),10,0)||RPAD(DDF_SUNDRY_NAME ('" + this.sundryType + "', '" + sundryCode
									+ "' ,'D'),32,' ')||LPAD('" + tranId + "',18,0)|| '" + ifscCode + "'||LPAD('"
									+ bankAccNo + "',9,0)||RPAD(SUBSTR('" + detailDesr + "',1,16),24,0) from dual");
							rs = pstmt.executeQuery();
							if (rs.next()) {
								detailStr = detailStr + rs.getString(1) + "\r\n";
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}

						System.out.println("317 formatter.format(totNetAmt)[" + formatter.format(totNetAmt) + "]");
						pstmt = conn.prepareStatement(
								"select 7||'999-999'||RPAD(' ',12,' ')||LPAD(0,10,0)||LPAD(SUM(TO_NUMBER(REPLACE( '"
										+ formatter.format(totNetAmt) + "','.'))),10,0)||LPAD(SUM(TO_NUMBER(REPLACE('"
										+ formatter.format(totNetAmt) + "','.'))),10,0)||RPAD(' ',24,' ')||LPAD("
										+ epayListValue.size() + ",6,0)||RPAD(' ',40,' ') from dual");
						rs = pstmt.executeQuery();
						if (rs.next()) {
							footer = rs.getString(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						finalStr = header + "\r\n" + detailStr + footer;
						System.out.println("296 Inside [" + finalStr + "]");
						if (finalStr != null) {
							errString = write(filePath + tempFileName + ".csv", finalStr);
							updateMiscPayment(Key, tranIdList, detailTranId, conn);
							if (tranIdList != null && tranIdList.size() > 0) {
								System.out.println("Tran id generation");
								InsertLog(tranIdList, this.userId, conn);
								isError = false;
							}
						}
					}
				}

				if (!isError) {
					errString = this.itmDBAccessEJB.getErrorString("", "VTEPSUCC", this.userId);
					System.out.println("process completed .." + errString);
					retString = errString;
				} else {
					errString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
					retString = errString;
				}
				break label353;
			} catch (Exception var91) {
				System.out.println("Exception EpaymentPrcEJB" + var91.getMessage());
				System.out.println("connection rollback.............");
				System.out.println("Returning Result " + errString);

				try {
					conn.rollback();
					retString = this.itmDBAccessEJB.getErrorString("", "VTEPFAIL", this.userId);
				} catch (Exception var90) {
					;
				}

				var91.printStackTrace();
				var81 = retString;
			} finally {
				try {
					if (isError) {
						conn.rollback();
					} else {
						conn.commit();
					}

					if (rs != null) {
						rs.close();
					}

					rs = null;
					if (pstmt != null) {
						pstmt.close();
					}
				} catch (Exception var89) {
					System.out.println("Error In closing connection::==> " + var89);
					var89.printStackTrace();
				}

			}

			return var81;
		}

		System.out.println("returning EpayCITI : " + retString);
		return retString;
	}

	private String checkNull(String value) {
		if (value == null) {
			value = "";
		}

		return value;
	}

	private static String generateTranId(String windowName, String userId, Connection conn) throws Exception {
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "";
		new CommonConstants();

		try {
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER  FROM TRANSETUP WHERE TRAN_WINDOW = '" + windowName + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			System.out.println("keyString :" + rs.toString());
			String keyString = "";
			String keyCol = "";
			String tranSer = "";
			if (rs.next()) {
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer = rs.getString(3);
			}

			String xmlValues = "";
			System.out.println("keyCol" + keyCol);
			System.out.println("keyString" + keyString);
			System.out.println("tranSer" + tranSer);
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues for tranid  :[" + xmlValues + "]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, userId, CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
		} catch (SQLException var14) {
			System.out.println("Exception ::" + sql + var14.getMessage() + ":");
			var14.printStackTrace();
			throw new Exception(var14);
		} catch (Exception var15) {
			System.out.println("Exception ::" + var15.getMessage() + ":");
			var15.printStackTrace();
			throw new Exception(var15);
		}

		System.out.println("tranId" + tranId);
		return tranId;
	}

	public static int updateMiscPayment(Timestamp effDate, ArrayList tranIdList, String batchId, Connection conn) {
		String sql = null;
		int upd = 0;
		String tranIdListStr = null;
		PreparedStatement pstmt = null;
		tranIdListStr = getListStr(tranIdList);
		sql = "update misc_payment set eff_date =?,batch_id=? where tran_id in " + tranIdListStr;
		System.out.println("upd sql............." + sql);

		try {
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, effDate);
			pstmt.setString(2, batchId);
			upd = pstmt.executeUpdate();
		} catch (Exception var17) {
			var17.printStackTrace();
			upd = 0;
		} finally {
			try {
				pstmt.close();
				pstmt = null;
			} catch (Exception var16) {
				;
			}

		}

		return upd;
	}

	public static String getListStr(ArrayList tranIdList) {
		String listStr = null;
//		int listLen = 0;
		int listLen = tranIdList.size();
		listStr = "( ";

		for (int listIdx = 0; listIdx < listLen; ++listIdx) {
			listStr = listStr + "'" + (String) tranIdList.get(listIdx) + "'" + ", ";
		}

		return listStr.substring(0, listStr.length() - 2) + " )";
	}

	public static String write(String filePath, String dataStr) {
		System.out.println("filePath :: " + filePath);
		System.out.println("dataStr :: " + dataStr);
		return nfFileOpen(filePath, dataStr);
	}

	private static String nfFileOpen(String asFilepath, String asString) {
		String lsErrcode = null;
		File ediFile = null;
		FileWriter ediFileWtr = null;

		try {
			ediFile = new File(asFilepath);
			ediFileWtr = new FileWriter(ediFile, true);
			System.out.println("asString::" + asString);
			int liLen = asString.length();
			if (ediFile == null) {
				lsErrcode = "VBFILEOPEN";
			}

			char[] writeCharArr = new char[asString.length()];
			asString.getChars(0, asString.length(), writeCharArr, 0);
			ediFileWtr.write(writeCharArr);
		} catch (Exception var20) {
			lsErrcode = "VFLEIOERR";
			var20.printStackTrace();
		} finally {
			try {
				ediFileWtr.close();
				ediFileWtr = null;
				ediFile = null;
			} catch (Exception var19) {
				lsErrcode = "VEFCLERR";
				var19.printStackTrace();
			}

		}

		return lsErrcode;
	}

	public static String normalizeStr(String str) {
		String[] restrictedChars = new String[]{">", "<", "\"", ";", "{", "}", "[", "]", "\\", "|", "=", "_", "*", "&",
				"^", "%", "$", "#", "!", "~", "`", "'", "?", "-MAC"};
		int len = restrictedChars.length;

		for (int idx = 0; idx < len; ++idx) {
			if ("&".equals(restrictedChars[idx])) {
				str = replaceChar(str, restrictedChars[idx].toString(), "and");
			} else if ("#".equals(restrictedChars[idx])) {
				str = replaceChar(str, restrictedChars[idx].toString(), "No");
			} else if ("-MAC".equals(restrictedChars[idx])) {
				str = replaceChar(str, restrictedChars[idx].toString(), " - MAC");
			} else {
				str = replaceChar(str, restrictedChars[idx].toString(), " ");
			}
		}

		return str;
	}

	private static String replaceChar(String str, String ch, String toStr) {
		StringBuffer bufferStr = null;
		bufferStr = new StringBuffer(str);
//		int idxOf = 0;

		for (int idxOf = bufferStr.indexOf(ch); idxOf > -1; idxOf = bufferStr.indexOf(ch)) {
			bufferStr = bufferStr.replace(idxOf, idxOf + 1, toStr);
		}

		return bufferStr.toString();
	}

	public static void InsertLog(ArrayList sourceFileList, String userId, Connection conn) {
		String tranId = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String insSql = null;
		insSql = "insert into RPT_PRINT_LOG( TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL )   values( ?, ?, ?, ?, SYSDATE, ?, ? ) ";

		try {
			pStmt = conn.prepareStatement(insSql);
			int listLen = 0;
			listLen = sourceFileList.size();

			for (int listIdx = 0; listIdx < listLen; ++listIdx) {
				tranId = generateTranId("w_rpt_print_log", userId, conn);
				pStmt.setString(1, tranId);
				pStmt.setString(2, "w_e_payment_city");
				pStmt.setString(3, (String) sourceFileList.get(listIdx));
				pStmt.setString(4, userId);
				pStmt.setInt(5, 1);
				pStmt.setString(6, "");
				pStmt.addBatch();
			}

			pStmt.executeBatch();
		} catch (Exception var17) {
			var17.printStackTrace();
		} finally {
			try {
				if (pStmt != null) {
					pStmt.close();
				}
			} catch (Exception var16) {
				;
			}

			pStmt = null;
		}

	}
}