package ibase.webitm.ejb.fin;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


@Stateless
public class EpayCitiEmp extends ProcessEJB implements EpayCitiEmpLocal,EpayCitiEmpRemote
{
	String userId ="", sundryType = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	public ArrayList<String> tranIdList = null;
	
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{	
		System.out.println("EpayCitiEmp :getData() function called");
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;		
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}

			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{			
			System.out.println("Exception :EpayCitiEmp :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();			
		}
		return rtrStr; 
	}//END OF GETDATA(1)

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String errString=null;		
		String errCode = "",returnString ="",bankCD = "";
		String getDataSql= "";
		String sql= "",sql1 ="" ;
		String resultString = "";
		ResultSet rs = null,rs1 = null;
		ResultSet vRs = null;
		PreparedStatement vPStmt = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		StringBuffer retTabSepStrBuff = new StringBuffer();		
		String siteCode=null,tranId ="",refNo="";
		java.sql.Timestamp toDate =null;
		java.sql.Timestamp fromDate	=null;
		boolean recFound =false;
		double netAmt=0,exchRate =0;
		int flag = 0;
		Timestamp confDate =null,refDate =null,tranDate =null; 
		String currCode = "",sundryCode = "",sundryType ="",finEntity ="",confirmed ="";
		Connection conn = null;
		StringBuffer xmlStringBuffer = new StringBuffer();
		try
		{
			xmlStringBuffer = new StringBuffer("<?xml version = \"1.0\"?>");
			xmlStringBuffer.append("<DocumentRoot>");
			xmlStringBuffer.append("<description>").append("Datawindow Root").append("</description>");
			xmlStringBuffer.append("<group0>");
			xmlStringBuffer.append("<description>").append("Group0 description").append("</description>");
			xmlStringBuffer.append("<Header0>");
			 
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: "+xtraParams);
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			System.out.println("userId............."+userId);
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String 	vouchNoFr="",vouchNoTo="",dateFr="",dateTo="",payMode ="",bankCode="",frmSch="";
			siteCode  = genericUtility.getColumnValue("site_code",headerDom);
			vouchNoFr = genericUtility.getColumnValue("voucher_no_fr",headerDom);	
			vouchNoTo = genericUtility.getColumnValue("voucher_no_to",headerDom);
			sundryType = genericUtility.getColumnValue("sundry_type",headerDom);
			if( vouchNoFr == null || vouchNoFr.trim().length() == 0 )
			{
				vouchNoFr = "00";
			}
			if( vouchNoTo == null || vouchNoTo.trim().length() == 0 )
			{
				vouchNoTo = "ZZ";
			}
			dateFr = genericUtility.getColumnValue("date_fr",headerDom);
			dateTo = genericUtility.getColumnValue("date_to",headerDom);

			//frmSch = checkNull(genericUtility.getColumnValue("frm_sch",headerDom));
			//System.out.println("frmSch@@@@@@@@@@=="+frmSch);
			if ( dateFr==null || dateFr.trim().length() == 0 )
			{
				returnString = itmDBAccessEJB.getErrorString("","VTFRDTBLK",userId,"",conn);
				return returnString;
			}
			if ( dateTo==null || dateTo.trim().length() == 0 )
			{
				returnString = itmDBAccessEJB.getErrorString("","VTTODTBLK",userId,"",conn);
				return returnString;
			}
			System.out.println( "dateFr :: " + dateFr );
			String dateFr1 = genericUtility.getValidDateString(dateFr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) ;
			fromDate =java.sql.Timestamp.valueOf( dateFr1+ " 00:00:00.0");

			String dateTo1 = genericUtility.getValidDateString(dateTo,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());			 
			toDate =java.sql.Timestamp.valueOf( dateTo1+ " 00:00:00.0");
			System.out.println("fromDate..............."+fromDate);
			System.out.println("toDate..............."+toDate);
			payMode =  genericUtility.getColumnValue("pay_mode",headerDom);
			bankCode =  genericUtility.getColumnValue("bank_code",headerDom);	
			bankCD = bankCode;
			System.out.println( "payMode..............." + payMode );

			if ( payMode==null || payMode.trim().length() == 0 )
			{
				returnString = itmDBAccessEJB.getErrorString("","VTPMBLK",userId,"",conn);
				return returnString;
			}
			if ( siteCode==null || siteCode.trim().length() == 0 )
			{
				returnString = itmDBAccessEJB.getErrorString("","VTSTBLK",userId,"",conn);
				return returnString;
			}
			else
			{
				String vSql = null;
				int cnt = 0;
				vSql = "select count( * ) cnt from site where site_code = ? ";
				vPStmt = conn.prepareStatement( vSql );
				vPStmt.setString(1,siteCode);
				vRs = vPStmt.executeQuery();
				if( vRs.next() )
				{
					cnt = vRs.getInt( "cnt" );
				}
				vRs.close();
				vRs = null;
				vPStmt.close();
				vPStmt = null;
				if( cnt == 0 )
				{
					returnString = itmDBAccessEJB.getErrorString("","VTSTINV",userId,"",conn);
					return returnString;
				}
			}

			if ( bankCode==null || bankCode.trim().length() == 0 )
			{
				returnString = itmDBAccessEJB.getErrorString("","VTBANKBLK",userId,"",conn);
				return returnString;
			}
			else
			{
				String vSql = null;
				int cnt = 0;
				vSql = "select count( * ) cnt from bank where bank_code = ? ";
				vPStmt = conn.prepareStatement( vSql );
				vPStmt.setString(1,bankCode);
				vRs = vPStmt.executeQuery();
				if( vRs.next() )
				{
					cnt = vRs.getInt( "cnt" );
				}
				vRs.close();
				vRs = null;
				vPStmt.close();
				vPStmt = null;
				if( cnt == 0 )
				{
					returnString = itmDBAccessEJB.getErrorString("","VTBNKINV",userId,"",conn);
					return returnString;
				}
			}
			//get information from bank master and call the appropriate class start
			String bankFilePath = null;
			String bankFileFormat  = null;
			String batchPath = null;

			String bankSql = null;

			bankSql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = '"+ bankCode + "'";
			System.out.println( "bankSql :: " + bankSql );
			Statement bankStmt = null;
			ResultSet bankRs = null;
			try
			{
				bankStmt = conn.createStatement();

				bankRs = bankStmt.executeQuery( bankSql );

				if( bankRs.next() )
				{
					bankFilePath = bankRs.getString( "filePath" );
					bankFileFormat = bankRs.getString( "bankformat" );
					batchPath = bankRs.getString( "batchpath" );
				}
			}
			catch( Exception bEx )
			{
				bEx.printStackTrace();
			}
			finally
			{
				try
				{
					if( bankRs != null )
						bankRs.close();
					bankRs = null;
					if( bankStmt != null )
						bankStmt.close();
					bankStmt = null;
				}
				catch( Exception tex ) 
				{
					
				}
			}
			if( bankFileFormat == null || bankFileFormat.trim().length() == 0 )
			{
				errString = itmDBAccessEJB.getErrorString("","VTNOBNKFMT",userId);
				return errString;

			}
			if( bankFilePath == null || bankFilePath.trim().length() == 0 )
			{
				errString = itmDBAccessEJB.getErrorString("","VTNOFLELOC",userId);
				return errString;
			}

			//end getting bank file details
			String citiSql = null;
			citiSql = "SELECT MISC_PAYMENT.TRAN_ID, MISC_PAYMENT.TRAN_DATE , "
					+" MISC_PAYMENT.NET_AMT ,  MISC_PAYMENT.REF_NO ,  MISC_PAYMENT.REF_DATE , "
					+" MISC_PAYMENT.CURR_CODE ,  MISC_PAYMENT.EXCH_RATE ,  "
					+" MISC_PAYMENT.SUNDRY_TYPE ,  MISC_PAYMENT.SUNDRY_CODE , "  
					+" MISC_PAYMENT.SITE_CODE ,  MISC_PAYMENT.FIN_ENTITY , "
					+" MISC_PAYMENT.BANK_CODE ,  MISC_PAYMENT.PAY_MODE ,  MISC_PAYMENT.CONF_DATE ,  "
					+" MISC_PAYMENT.CONFIRMED  "
					+" FROM  MISC_PAYMENT  "
					+" WHERE ( MISC_PAYMENT.SITE_CODE = '" + siteCode +"' ) "
					+"	AND ( MISC_PAYMENT.TRAN_DATE >= ? ) "
					+"	AND ( MISC_PAYMENT.TRAN_DATE <= ? ) "
					+"	AND ( MISC_PAYMENT.TRAN_ID >= '" + vouchNoFr + "' ) " 
					+"	AND ( MISC_PAYMENT.TRAN_ID <= '" + vouchNoTo + "' ) "
					+"	AND MISC_PAYMENT.BANK_CODE = '" + bankCode + "' " 
					+"	AND MISC_PAYMENT.EFF_DATE is null "
					+"	AND MISC_PAYMENT.PAY_MODE = '" + payMode + "' "
					+" AND MISC_PAYMENT.SUNDRY_TYPE = '" + sundryType + "' " 
					+"	AND case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end  in ('S','C') " 
					+"	 AND MISC_PAYMENT.TRAN_ID NOT IN (SELECT PAYMENT_NO "
					+"													FROM MISC_PAYMENT_CANC "
					+"													 WHERE TRAN_DATE >='01-SEP-1999' "
					+"														AND SITE_CODE = '" + siteCode + "')" 
					+"	AND exists( select 1 from  MISC_PAYDET "
					+"					WHERE MISC_PAYDET.TRAN_ID = MISC_PAYMENT.TRAN_ID "
					+"						AND MISC_PAYDET.SUNDRY_TYPE= '" + sundryType + "' "
					+"		) ";
				
			if( bankFileFormat.equalsIgnoreCase( "CITI" ) )
			{
				sql = citiSql;
				pstmt = conn.prepareStatement( citiSql);
			}
			System.out.println("sql.............["+sql + "]");
			pstmt.setTimestamp(1,fromDate);
			pstmt.setTimestamp(2,toDate);
			rs = pstmt.executeQuery();
			System.out.println("@vkc::rs >>" + rs);
			while (rs.next())
			{
				System.out.println("@vkc::inside while >>" + rs);
				recFound	= true;
				tranId		= rs.getString("TRAN_ID");
				flag = 0;
				sql ="select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
				pstmt1	= conn.prepareStatement( sql );
				pstmt1.setString(1, tranId);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					flag = rs1.getInt(1);
				}
				rs1.close();
				rs1 = null; 
				pstmt1.close();
				pstmt1=null;
				
				if( flag == 0)
				{
					currCode	= rs.getString("CURR_CODE");
					tranDate	= rs.getTimestamp("TRAN_DATE");
					refDate	    = rs.getTimestamp("REF_DATE");
					exchRate	= rs.getDouble("EXCH_RATE");
					netAmt		= rs.getDouble("NET_AMT");
					sundryCode	= rs.getString("SUNDRY_CODE");
					siteCode	= rs.getString("SITE_CODE");
					finEntity	= rs.getString("FIN_ENTITY");
					bankCode	= rs.getString("BANK_CODE");
					payMode		= rs.getString("PAY_MODE");
					confirmed	= rs.getString("CONFIRMED");
					refNo		= rs.getString("REF_NO");
					confDate	= rs.getTimestamp("CONF_DATE");
					refNo = refNo == null ?"" : refNo.trim();
					sundryType = rs.getString("SUNDRY_TYPE");
					System.out.println("@vkc::tranId >>"+ tranId);
					System.out.println("@vkc::siteCode >>"+ siteCode);
					System.out.println("@vkc::sundryCode >>"+ sundryCode);
					System.out.println("@vkc::bankCode >>"+ bankCode);
					System.out.println("@vkc::currCode >>"+ currCode);
					System.out.println("@vkc::payMode >>" + payMode);
					System.out.println("@vkc::refNo >>" + refNo);
					System.out.println("@vkc::netAmt >>"+ netAmt);
					System.out.println("@vkc::finEntity >>"+ finEntity);
					System.out.println("@vkc::tranDate >>"+ tranDate);
					System.out.println("@vkc::exchRate >>"+ exchRate);
					System.out.println("@vkc::sundryType >>"+ sundryType);
					System.out.println("@vkc::confirmed >>" + confirmed);
					System.out.println("@vkc::confDate >>"+ confDate);
					System.out.println("@vkc::refDate >>"+ refDate);
					/**Creating XML to display data in grid view on get data*/
					xmlStringBuffer.append("<Detail2>");
					xmlStringBuffer.append("<tran_id>").append("<![CDATA[").append(tranId).append("]]>").append("</tran_id>");
					xmlStringBuffer.append("<site_code>").append("<![CDATA[").append(siteCode).append("]]>").append("</site_code>");
					xmlStringBuffer.append("<sundryCode>").append("<![CDATA[").append(sundryCode).append("]]>").append("</sundryCode>");
					xmlStringBuffer.append("<bank_code>").append("<![CDATA[").append(bankCode).append("]]>").append("</bank_code>");
					xmlStringBuffer.append("<curr_code>").append("<![CDATA[").append(currCode).append("]]>").append("</curr_code>");
					xmlStringBuffer.append("<pay_mode>").append("<![CDATA[").append(payMode).append("]]>").append("</pay_mode>");
					xmlStringBuffer.append("<ref_no>").append("<![CDATA[").append(refNo).append("]]>").append("</ref_no>");
					xmlStringBuffer.append("<net_amt>").append("<![CDATA[").append(netAmt).append("]]>").append("</net_amt>");
					xmlStringBuffer.append("<fin_entity>").append("<![CDATA[").append(finEntity).append("]]>").append("</fin_entity>");
					xmlStringBuffer.append("<tran_date>").append("<![CDATA[").append(tranDate).append("]]>").append("</tran_date>");
					xmlStringBuffer.append("<exch_rate>").append("<![CDATA[").append(exchRate).append("]]>").append("</exch_rate>");
					xmlStringBuffer.append("<sundry_type>").append("<![CDATA[").append(sundryType).append("]]>").append("</sundry_type>");
					xmlStringBuffer.append("<confirmed>").append("<![CDATA[").append(confirmed).append("]]>").append("</confirmed>");
					xmlStringBuffer.append("<conf_date>").append("<![CDATA[").append(confDate).append("]]>").append("</conf_date>");
					xmlStringBuffer.append("<ref_date>").append("<![CDATA[").append(refDate).append("]]>").append("</ref_date>");
					xmlStringBuffer.append("</Detail2>");
			
				}
			}
			xmlStringBuffer.append("</Header0>");
			xmlStringBuffer.append("</group0>");
			xmlStringBuffer.append("</DocumentRoot>");
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("frmSch["+frmSch+"]recFound["+recFound+"]");
			System.out.println("xmlStringBuffer["+xmlStringBuffer+"]");
			if(xmlStringBuffer!=null)
			{
			resultString = xmlStringBuffer.toString();
			System.out.println("ResultString....." + resultString);
			}
		}
		catch (SQLException e)
		{
			System.out.println("SQLException :EpayCitiEmp :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EpayCitiEmp :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				retTabSepStrBuff = null;
				if( rs != null )
				{
					rs.close();
				}	
				rs = null;
				if (pstmt != null)
				{
					pstmt.close();
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}	
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return resultString;	
	}//END OF GETDATA(2)

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException 
	{
				Document detailDom = null;
				Document headerDom = null;
				E12GenericUtility genericUtility= new  E12GenericUtility();
				String retStr = "";
				try
				{	
					System.out.println("xmlString[process]::::::::::;;;"+xmlString);
					System.out.println("xmlString2[process]::::::::::;;;"+xmlString2);
					System.out.println("dummy[process]::::::::::;;;"+windowName);//TESTING PURPOSE
					System.out.println("xtraParams[process]:::::::::;;;"+xtraParams);

					System.out.println("parsing xml condition");
					if(xmlString != null && xmlString.trim().length()!=0)
					{
						headerDom = genericUtility.parseString(xmlString); 
						System.out.println("headerDom" + headerDom);
						System.out.println("xmlString >> "+xmlString);
					}
					System.out.println("parsing xml2 condition");
					if(xmlString2 != null && xmlString2.trim().length()!=0)
					{
						detailDom = genericUtility.parseString(xmlString2); 
						System.out.println("detailDom" + detailDom);
						System.out.println("xmlString2 >> "+xmlString2);
					}
					retStr = process(headerDom, detailDom, windowName, xtraParams);
				}
				catch (Exception e)
				{			
					System.out.println("Exception : :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
					System.out.println("headerDom" + headerDom);
					System.out.println("xmlString >> "+xmlString);
					System.out.println("parsing xml2 condition");
					System.out.println("detailDom" + detailDom);
					System.out.println("xmlString2 >> "+xmlString2);
					e.printStackTrace();
					throw new ITMException(e);
				}
				return retStr;
	}
	public String process( Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String tranId="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "" ,errString = "";
        String retString = "",textDoc ="";
        String nameOpt="";
		String fileDescription="",bankCode="",payMode="",tempFileName="",filePath = "",destinationPath="";
		String fileDescr="";
		Connection conn = null;
		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			System.out.println("@vkc::headerDom >>"+ headerDom);
			System.out.println("@vkc::detailDom >>"+ detailDom);
			System.out.println("@vkc::windowName >>"+ windowName);
			System.out.println("@vkc::xtraParams >>"+ xtraParams);
			tranIdList = new ArrayList<String>();
			String jbossPath = null;
			jbossPath = CommonConstants.JBOSSHOME;
			
			sundryType =  checkNull(genericUtility.getColumnValue("sundry_type",headerDom));
			System.out.println( ">>>sundryType :: " + sundryType);
            nameOpt=genericUtility.getColumnValue("nameoption", headerDom);
			payMode = checkNull(genericUtility.getColumnValue("pay_mode",headerDom));
			bankCode = checkNull(genericUtility.getColumnValue("bank_code",headerDom));
			System.out.println( ">>>sundryType["+sundryType+"]payMode["+payMode+"]bankCode["+bankCode+"]");
			System.out.println("xtraParams :::::::::::::::::::::::::::::::::: "+xtraParams);
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			
			//fileDescr = "SUNPH_PR_";//Commented by vinay on 08/03/21
			fileDescr = "SUNPR_";//Added by vinay on 08/03/21
			sql = "select '"+fileDescr+"' as descr from dual ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				fileDescr = checkNull(rs.getString("descr")).trim();
				System.out.println( "@vkc>>>fileDescr["+fileDescr+"]");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println( ">>>fileDescr["+fileDescr+"]");
			if(fileDescr.trim().length()==0 || fileDescr==null)
		    {
		    	System.out.println("inside fileDesc check");
		    	errString = itmDBAccessEJB.getErrorString("","VTEPFAIL",userId);
		    	return errString;
		    }
			
			sql = "select udf_str3 filePath, udf_str1 bankformat, udf_str2 batchpath from bank where bank_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,bankCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				filePath = checkNull(rs.getString("filePath")).trim();
				System.out.println( "@vkc>>>filePath["+filePath+"]");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println( ">>>filePath["+filePath+"]");
			if( filePath == null || filePath.trim().length() == 0 )
			{
				errString = itmDBAccessEJB.getErrorString("","VTNOFLELOC",userId);//Not found
				return errString;
			}
			Node currDetail = null;
			NodeList detailList = null;
			detailList = detailDom.getElementsByTagName( "Detail2" );
			int noOfDetails = 0;
			noOfDetails	= detailList.getLength();
			if(noOfDetails == 0)
			{
				System.out.println("@vkc::no data selected for process...");
				errString = itmDBAccessEJB.getErrorString("","VTNODATSEL",userId);//Not found
				return errString;
			}
			int flag = 0;
			for( int ctr = 0; ctr < noOfDetails; ctr++ )
			{
				tranIdList = new ArrayList<String>();
				String tId = null;
				String tranDateStr = null;
				currDetail = detailList.item( ctr );
				tId = genericUtility.getColumnValueFromNode( "tran_id", currDetail );
				tranDateStr = genericUtility.getColumnValueFromNode( "tran_date", currDetail );
				System.out.println( "tranDateStr :: " + tranDateStr );
				java.sql.Timestamp tranDateTStmap = null;
				tranId = tId;
				fileDescription=fileDescr;
				System.out.println( ">>>fileDescription["+fileDescr+"]");
				tempFileName =  fileDescription.trim()+tranId.trim() ;
				System.out.println( "Tran ID::[" + tranId +"]fileDescription["+fileDescription+"]" );	
				
				sql ="select count(1) from RPT_PRINT_LOG where PARAMETER_VAL = ? ";
				pstmt	= conn.prepareStatement( sql );
				pstmt.setString(1, tId);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					flag = rs.getInt(1);
				}
				rs.close(); 
				rs = null; 
				pstmt.close();
				pstmt=null;
				if( flag > 0 )
				{
					break;
				}
				if ("E".equalsIgnoreCase(sundryType))
				{
					sql =    "SELECT "
							+" DISTINCT CASE WHEN MISC_PAYMENT.PAY_MODE in ('T') THEN 'PYR' ELSE MISC_PAYMENT.PAY_MODE END ||'@'|| "//(01)
							+" CASE WHEN BANK.COUNT_CODE = 'IND' THEN 'IN' ELSE SUBSTR(BANK.COUNT_CODE,1,2) END ||'@'|| "//(02)
							+" BANK.AC_NO ||'@'||"//(03)
							+" CASE WHEN MISC_PAYDET.CURR_CODE = 'RS' THEN 'INR' ELSE SUBSTR(MISC_PAYDET.CURR_CODE,1,3) END ||'@'||"//(04)
							+" SUM(MISC_PAYDET.PAY_AMT - nvl(misc_paydet.DISCOUNT_AMT,0)) ||'@'||"//(05)
						    +" '@'|| " //FOR branch code (006)
							+ " CASE WHEN (CASE WHEN TRIM(TO_CHAR(MISC_PAYMENT.REF_DATE,'DAY')) = 'SUNDAY' THEN TO_CHAR(NVL((MISC_PAYMENT.REF_DATE+1),(SYSDATE+1)),'YYYYMMDD') ELSE TO_CHAR(NVL(MISC_PAYMENT.REF_DATE,SYSDATE),'YYYYMMDD') END) < TO_CHAR(SYSDATE,'YYYYMMDD') THEN TO_CHAR(SYSDATE,'YYYYMMDD') ELSE (CASE WHEN TRIM(TO_CHAR(MISC_PAYMENT.REF_DATE,'DAY')) = 'SUNDAY' THEN TO_CHAR(NVL((MISC_PAYMENT.REF_DATE+1),(SYSDATE+1)),'YYYYMMDD') ELSE TO_CHAR(NVL(MISC_PAYMENT.REF_DATE,SYSDATE),'YYYYMMDD') END) END ||'@'||" //(007)
							+" TRIM(MISC_PAYMENT.TRAN_ID)||'@'||" //Transaction Tran id (008)
+"'@'|| " //(009) 
+"'@'|| " //(010) 
+"'@'|| " //(011) 
+"'@'|| " //(012) 
+"'@'|| " //(013) 
+"'@'|| " //(014) 
+"'@'|| " //(015) 
+"'@'|| " //(016) 
+"'@'|| " //(017) 
+"'@'|| " //(018) 
+"'@'|| " //(019) 
+"substr(trim(ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"+nameOpt+"')),1,150)||'@'|| " //(020)
+"'@'|| " //(021) 
+"'@'|| " //(022) 
+"'@'|| " //(023) 
+" '2' ||'@'|| "//(024) 
+"substr(nvl(employee.bank_acct,'    '),1,4)||'@'|| "//(025) 
+" '' ||'@'|| "	//(026) 
+" '' ||'@'|| "	//(027) 
+" '' ||'@'|| "	//(028) 
+" '' ||'@'|| "	//(029) 
+" '' ||'@'|| "	//(030) 
+" '' ||'@'|| "	//(031) 
+"trim(employee.ifsc)||'@'|| " //(032) 
+" '' ||'@'|| "//(033) 
+" '' ||'@'|| "//(034) 
+" '' ||'@'|| "//(035) 
+" '' ||'@'|| "//(036) 
+" '' ||'@'|| "//(037) 
+" '' ||'@'|| "//(038) 
+" '' ||'@'|| "//(039) 
+" '' ||'@'|| "//(040) 
+" '' ||'@'|| "//(041) 
+" '' ||'@'|| "//(042) 
+" '' ||'@'|| "//(043) 
+" '' ||'@'|| "//(044)
+" '' ||'@'|| "//(045)
+" '' ||'@'|| "//(046)
+" '' ||'@'|| "//(047)
+" '' ||'@'|| "//(048)
+" '' ||'@'|| "//(049)
+" '' ||'@'|| "//(050)
+" '' ||'@'|| "//(051)
+" '' ||'@'|| "//(052)
+" '' ||'@'|| "//(053)
+" '' ||'@'|| "//(054)
+" '' ||'@'|| "//(055)
+" '' ||'@'|| "//(056)
+" '' ||'@'|| "//(057)
+" '' ||'@'|| "//(058)
+" '' ||'@'|| "//(059)
+" '' ||'@'|| "//(060)
+" '' ||'@'|| "//(061)
+" '' ||'@'|| "//(062)
+" '' ||'@'|| "//(063)
+" '' ||'@'|| "//(064)
+" '' ||'@'|| "//(065)
+" '' ||'@'|| "//(066)
+" '' ||'@'|| "//(067)
+" '' ||'@'|| "//(068)
+" '' ||'@'|| "//(069)
+" '' ||'@'|| "//(070)
+" '' ||'@'|| "//(071)
+" '' ||'@'|| "//(072)
+" '' ||'@'|| "//(073)
+" '' ||'@'|| "//(074)
+" '' ||'@'|| "//(075)
+" '' ||'@'|| "//(076)
+" '' ||'@'|| "//(077)
+" 'ST' ||'@'|| "//(78)
+" '' ||'@'|| " //(79)
+" '' ||'@'|| "//(80)
+" '' ||'@'|| "//(81)
+" '' ||'@'|| "//(82)
+" '' ||'@'|| "//(83)
+" '' ||'@'|| "//(84)
+" '' ||'@'|| "//(85)
+" '' ||'@'|| "//(86)
+" '' ||'@'|| "//(87)
+" '' ||'@'|| "//(88)
+" '' ||'@'|| "//(89)
+" '' ||'@'|| "//(90)
+" '' ||'@'|| "//(91)
+" '' ||'@'|| "//(92)
+" '' ||'@'|| "//(93)
+" '' ||'@'|| "//(94)              
+" '' ||'@'|| "//(95)
+" '' ||'@'|| "//(96)
+" '' ||'@'|| "//(97)
+" '' ||'@'|| "//(98)
+" '' ||'@'|| "//(99)
+" '' ||'@'|| "//(100)
+" '' ||'@'|| "//(101)
+" '' ||'@'|| "//(102)
+" '' ||'@'|| "//(103)
+" '' ||'@'|| "//(104)
+" '' ||'@'|| "//(105)
+" '' ||'@'|| "//(106)
+" '' ||'@'|| "//(107)
+" '' ||'@'|| "//(108)
+" '' ||'@'|| "//(109)
+" '' ||'@'|| "//(110)
+" '' ||'@'|| "//(111)
+" '' ||'@'|| ";//(112)
						    sql+=      " DATAS FROM misc_paydet, "
							+"         misc_payment, "  
							+"         employee, "
							+"			bank, "
							+"			bank_stan_serv "
							+"   WHERE ( misc_payment.tran_id = misc_paydet.tran_id ) and "
							+"         ( misc_paydet.sundry_code = employee.emp_code ) and "
							+"			( misc_paydet.sundry_type = 'E' ) and "
							+"			( misc_paydet.stan_code = bank_stan_serv.stan_code ) and "
							+"         ( misc_payment.bank_code = bank_stan_serv.bank_code ) and "
							+"			( misc_payment.bank_code = bank.bank_code ) and "
							+"			( misc_payment.eff_date is null ) and "
							+"         ( ( misc_paydet.sundry_type = 'E' ) AND "  
							+"         ( misc_payment.pay_mode = 'T' ) AND "
							+"	case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') AND "
							+"         ( misc_payment.tran_id between '" + tranId + "'  and '" + tranId + "' ) AND "
							+"			( misc_payment.tran_id not in (select payment_no from misc_payment_canc where tran_date >= ? ))) "
							+"	group by  nvl(employee.bank_acct,'            '), "
							+"			bank.ac_no, "
							+"			substr(nvl(misc_payment.curr_code,'   '),1,3), "
							+"			substr(nvl(employee.bank_acct,'    '),1,4), "
							+"			substr(nvl(misc_payment.tran_type,' '),1,1), "
							+"			rpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30), "
							+"			ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"+nameOpt+"'), "
							+"			misc_payment.tran_date,MISC_PAYMENT.REF_DATE ";
						    
						    
						    
						    if("N".equalsIgnoreCase("N"))
						    {
						    	sql+=", trim(employee.ifsc)";
						    }
						    sql+= " HAVING sum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0)) <> 0 ";
						    sql+=    " UNION "

							+"   SELECT "
							+" DISTINCT CASE WHEN MISC_PAYMENT.PAY_MODE in ('T') THEN 'PYR' ELSE MISC_PAYMENT.PAY_MODE END ||'@'|| "//(01)
							+" CASE WHEN BANK.COUNT_CODE = 'IND' THEN 'IN' ELSE SUBSTR(BANK.COUNT_CODE,1,2) END ||'@'|| "//(02)
							+" BANK.AC_NO ||'@'||"//(03)
							+" CASE WHEN MISC_PAYDET.CURR_CODE = 'RS' THEN 'INR' ELSE SUBSTR(MISC_PAYDET.CURR_CODE,1,3) END ||'@'||"//(04)
							+" SUM(MISC_PAYDET.PAY_AMT - nvl(misc_paydet.DISCOUNT_AMT,0)) ||'@'||"//(05)
						    +" '@'|| " //FOR branch code (006)
							+ " CASE WHEN (CASE WHEN TRIM(TO_CHAR(MISC_PAYMENT.REF_DATE,'DAY')) = 'SUNDAY' THEN TO_CHAR(NVL((MISC_PAYMENT.REF_DATE+1),(SYSDATE+1)),'YYYYMMDD') ELSE TO_CHAR(NVL(MISC_PAYMENT.REF_DATE,SYSDATE),'YYYYMMDD') END) < TO_CHAR(SYSDATE,'YYYYMMDD') THEN TO_CHAR(SYSDATE,'YYYYMMDD') ELSE (CASE WHEN TRIM(TO_CHAR(MISC_PAYMENT.REF_DATE,'DAY')) = 'SUNDAY' THEN TO_CHAR(NVL((MISC_PAYMENT.REF_DATE+1),(SYSDATE+1)),'YYYYMMDD') ELSE TO_CHAR(NVL(MISC_PAYMENT.REF_DATE,SYSDATE),'YYYYMMDD') END) END ||'@'||" //(007)
							+" TRIM(MISC_PAYMENT.TRAN_ID)||'@'||" //Transaction Tran id (008)
+"'@'|| " //(009) 
+"'@'|| " //(010) 
+"'@'|| " //(011) 
+"'@'|| " //(012) 
+"'@'|| " //(013) 
+"'@'|| " //(014) 
+"'@'|| " //(015) 
+"'@'|| " //(016) 
+"'@'|| " //(017) 
+"'@'|| " //(018) 
+"'@'|| " //(019) 
+"substr(trim(ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"+nameOpt+"')),1,150)||'@'|| " //(020)
+"'@'|| " //(021) 
+"'@'|| " //(022) 
+"'@'|| " //(023) 
+" '2' ||'@'|| "//(024) 
+"substr(nvl(employee.bank_acct,'    '),1,4)||'@'|| "//(025) 
+" '' ||'@'|| "	//(026) 
+" '' ||'@'|| "	//(027) 
+" '' ||'@'|| "	//(028) 
+" '' ||'@'|| "	//(029) 
+" '' ||'@'|| "	//(030) 
+" '' ||'@'|| "	//(031) 
+"trim(employee.ifsc)||'@'|| " //(032) 
+" '' ||'@'|| "//(033) 
+" '' ||'@'|| "//(034) 
+" '' ||'@'|| "//(035) 
+" '' ||'@'|| "//(036) 
+" '' ||'@'|| "//(037) 
+" '' ||'@'|| "//(038) 
+" '' ||'@'|| "//(039) 
+" '' ||'@'|| "//(040) 
+" '' ||'@'|| "//(041) 
+" '' ||'@'|| "//(042) 
+" '' ||'@'|| "//(043) 
+" '' ||'@'|| "//(044)
+" '' ||'@'|| "//(045)
+" '' ||'@'|| "//(046)
+" '' ||'@'|| "//(047)
+" '' ||'@'|| "//(048)
+" '' ||'@'|| "//(049)
+" '' ||'@'|| "//(050)
+" '' ||'@'|| "//(051)
+" '' ||'@'|| "//(052)
+" '' ||'@'|| "//(053)
+" '' ||'@'|| "//(054)
+" '' ||'@'|| "//(055)
+" '' ||'@'|| "//(056)
+" '' ||'@'|| "//(057)
+" '' ||'@'|| "//(058)
+" '' ||'@'|| "//(059)
+" '' ||'@'|| "//(060)
+" '' ||'@'|| "//(061)
+" '' ||'@'|| "//(062)
+" '' ||'@'|| "//(063)
+" '' ||'@'|| "//(064)
+" '' ||'@'|| "//(065)
+" '' ||'@'|| "//(066)
+" '' ||'@'|| "//(067)
+" '' ||'@'|| "//(068)
+" '' ||'@'|| "//(069)
+" '' ||'@'|| "//(070)
+" '' ||'@'|| "//(071)
+" '' ||'@'|| "//(072)
+" '' ||'@'|| "//(073)
+" '' ||'@'|| "//(074)
+" '' ||'@'|| "//(075)
+" '' ||'@'|| "//(076)
+" '' ||'@'|| "//(077)
+" 'ST' ||'@'|| "//(78)
+" '' ||'@'|| " //(79)
+" '' ||'@'|| "//(80)
+" '' ||'@'|| "//(81)
+" '' ||'@'|| "//(82)
+" '' ||'@'|| "//(83)
+" '' ||'@'|| "//(84)
+" '' ||'@'|| "//(85)
+" '' ||'@'|| "//(86)
+" '' ||'@'|| "//(87)
+" '' ||'@'|| "//(88)
+" '' ||'@'|| "//(89)
+" '' ||'@'|| "//(90)
+" '' ||'@'|| "//(91)
+" '' ||'@'|| "//(92)
+" '' ||'@'|| "//(93)
+" '' ||'@'|| "//(94)              
+" '' ||'@'|| "//(95)
+" '' ||'@'|| "//(96)
+" '' ||'@'|| "//(97)
+" '' ||'@'|| "//(98)
+" '' ||'@'|| "//(99)
+" '' ||'@'|| "//(100)
+" '' ||'@'|| "//(101)
+" '' ||'@'|| "//(102)
+" '' ||'@'|| "//(103)
+" '' ||'@'|| "//(104)
+" '' ||'@'|| "//(105)
+" '' ||'@'|| "//(106)
+" '' ||'@'|| "//(107)
+" '' ||'@'|| "//(108)
+" '' ||'@'|| "//(109)
+" '' ||'@'|| "//(110)
+" '' ||'@'|| "//(111)
+" '' ||'@'|| ";//(112)

						    sql+= " DATAS FROM misc_paydet,"
							+"         misc_payment, "  
							+"         employee, "   
							+"			bank, "
							+"			bank_stan_serv, "
							+"			sales_pers "
							+"    WHERE ( misc_payment.tran_id = misc_paydet.tran_id ) and "
							+"         ( misc_paydet.sundry_code = sales_pers.sales_pers ) and "
							+"			( sales_pers.emp_code  = employee.emp_code ) and "
							+"			( misc_paydet.sundry_type = 'P' ) and "
							+"			( misc_paydet.stan_code = bank_stan_serv.stan_code ) and "
							+"         ( misc_payment.bank_code = bank_stan_serv.bank_code ) and "
							+"			( misc_payment.bank_code = bank.bank_code ) and "
							+"			( misc_payment.eff_date is null ) and "
							+"         ( ( misc_paydet.sundry_type = 'P' ) AND "  
							+"         ( misc_payment.pay_mode = 'T' ) AND  "
							+"	case when MISC_PAYMENT.WF_STATUS is null then 'O' else MISC_PAYMENT.WF_STATUS end   in ('S','C') AND "
							+"         ( misc_payment.tran_id between '" + tranId + "' and '" + tranId+ "' ) AND "
							+"			( misc_payment.tran_id not in (select payment_no from misc_payment_canc where tran_date >= ? ))) "    
							+"	group by  nvl(employee.bank_acct,'            '), " 
							+"			bank.ac_no, "
							+"			substr(nvl(misc_payment.curr_code,'   '),1,3), "
							+"			substr(nvl(employee.bank_acct,'    '),1,4), "
							+"			substr(nvl(misc_payment.tran_type,' '),1,1), "
							+"			rpad(substr(nvl(ltrim(rtrim(misc_payment.remarks)),''),1,30),30), "
							+"		   ddf_sundry_name(misc_paydet.sundry_type,misc_paydet.sundry_code,'"+nameOpt+"'), "
							+"			misc_payment.tran_date,MISC_PAYMENT.REF_DATE ";
						    if("N".equalsIgnoreCase("N")) 
						    {
						    	sql+=", trim(employee.ifsc)";
						    } 
						    sql+= " HAVING sum(misc_paydet.pay_amt - nvl(misc_paydet.DISCOUNT_AMT,0)) <> 0 ";
					
			 }  //end of if 
		     
		     System.out.println("sql............."+sql);
			 pstmt	= conn.prepareStatement( sql );
			 tranDateTStmap = java.sql.Timestamp.valueOf( tranDateStr );
			 if ("E".equalsIgnoreCase(sundryType))
			 {
					pstmt.setTimestamp( 1, tranDateTStmap );
					pstmt.setTimestamp( 2, tranDateTStmap );
			 }
			 rs = pstmt.executeQuery();
			 StringBuffer dataBuff = new StringBuffer( "" );								
			 while ( rs.next() )
		     {
					
					textDoc	= rs.getString( "DATAS" );
					dataBuff.append(  "\n" + textDoc );
			 }
			 rs.close();
			 rs = null;
			 pstmt.close();
			 pstmt = null;
			 textDoc = dataBuff.toString();
			 System.out.println("@vkc::textDoc >>"+textDoc);
			 if(textDoc !=null && textDoc.trim().length() > 0)
			 {
				 errString = Util.writeEpayCitiEmp(filePath + tempFileName + ".txt" ,textDoc.substring( 1 ));
			 }
			 System.out.println("@vkc::errString >>"+errString);
			 if(errString !=null && errString.equals("success"))
			 {
				 tranIdList.add( tranId );
				 System.out.println("@vkc::tranIdList >>"+tranIdList);
				 Util.InsertLog(tranIdList,userId, conn);
				 Util.updateMiscPayment(tranIdList, conn);
				 Util.EncriptFileCITIEMP(tranIdList, filePath, destinationPath  );
			 }
			 tranIdList.clear();
			 System.out.println("@vkc::tranIdList clear >>"+tranIdList);
			} //end of for
			if(flag > 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTTXNRPT",userId);
				return errString;
			}
			
			System.out.println("@vkc::errString #>>"+errString);
			errString = itmDBAccessEJB.getErrorString("","PROCSUCC",userId);
			System.out.println("process completed .."+errString);
			//Util.EncriptFileCITIEMP(tranIdList, filePath, destinationPath  );
			
		} //end of try
		
		catch(Exception e)
		{
			System.out.println("Exception EpayCitiEmp"+e.getMessage());
			System.out.println("connection rollback.............");
			System.out.println("Returning Result "+errString);
			try
			{
				conn.rollback();
			}
			catch(Exception ex ){}
			errString = itmDBAccessEJB.getErrorString("","VTEPFAIL",userId);
			e.printStackTrace();
			return errString;
		}
		finally
		{
			try
			{	
				if( rs != null )
				{
					rs.close();
				}	
				rs = null;
				if (pstmt != null)
				{
					pstmt.close();
				}
				if( conn !=null )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
			   System.out.println("Error In closing connection::==> "+e);
		       e.printStackTrace();
			}
		}
		System.out.println("returning EpayCitiEmp "+retString);
	    return errString;
	}
	
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
	
}
