package ibase.webitm.ejb.sc;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;

class ArgumentListGenerator
{
	
	String finEntity="";
	String id="";
	String name="";
	String argType="";
	String value="";
	
	final static String OPENING_TAG="<Arguments>";
	final static String CLOSING_TAG="</Arguments>";
	String ARGUMENT_TEMPLATE="<Argument id=\"mfin_entity\" name=\"mfin_entity\"><argType>java.lang.String</argType><value>"+finEntity+"</value></Argument>";

	
	String profileId="SUN";

	/**
	 * 
	 * 
	 * @param jrxmlName
	 * @param profileId
	 * @return harcoded value of the argument list
	 */
	public String getArgumentList(String jrxmlName,String profileId){
		return "<Arguments>"
		+ "<Argument id=\"user_code\" name=\"user_code\"><argType>java.lang.StringArray</argType><value>"+profileId+"</value></Argument>"
		+ "<Argument id=\"x_path\" name=\"x_path\"><argType>java.lang.String</argType><value>/DocumentRoot/"+jrxmlName+"</value></Argument>"
		+ "<Argument id=\"design_source\" name=\"design_source\"><argType>java.lang.String</argType><value>"+jrxmlName+".jrxml</value></Argument>"
		+ "<Argument id=\"data_source\" name=\"data_source\"><argType>java.lang.String</argType><value>SQL</value></Argument>"
		+ "<Argument id=\"bind_type\" name=\"bind_type\"><argType>java.lang.Integer</argType><value>0</value></Argument>"
		+ "<Argument id=\"report_type\" name=\"report_type\"><argType>java.lang.String</argType><value>JASPER</value></Argument>"
		+ "<Argument id=\"report_save_type\" name=\"report_save_type\"><argType>java.lang.String</argType><value>PDF</value></Argument>"
		+ "</Arguments>";
		
	}
	
	
	public String getDynamicArgumentList(XSDParser xsdParser,String profileid)throws ITMException, Exception
	{
		String template="";
		int cursor=0;
		Node nNode=null;
		XSDParser xsdParser1=xsdParser;
		System.out.println("insie dynamic argument::"+xsdParser1.getArgumentMetaDataString());
		Document doc = DocumentBuilderFactory.newInstance()
                .newDocumentBuilder()
                .parse(new InputSource(new StringReader(xsdParser1.getArgumentMetaDataString())));

		NodeList argNodes = doc.getElementsByTagName("argument");
		
		System.out.println("Befor Setting value:::");
		for (int temp = 0; temp < argNodes.getLength(); temp++) {
		    nNode = argNodes.item(temp);

		 if (nNode.getNodeType() == Node.ELEMENT_NODE) {
		        Element eElement = (Element) nNode;
		        System.out.println("value : "
		                           + eElement.getAttribute("value"));
		        
		        if(eElement.getAttribute("name").equals("user_code")){
		        	eElement.setAttribute("value", profileid);
		        }
		        
		        System.out.println("name : "
		                           + eElement.getAttribute("name"));
		         System.out.println("label : "
	        		                + eElement.getAttribute("label"));
		         
		         if(cursor==0){
    		         template=template+"<Argument id=\""+eElement.getAttribute("id")+"\""+" name=\""+eElement.getAttribute("name")+"\""+"><argType>"+eElement.getAttribute("type")+"</argType><value>"+profileid+"</value></Argument>";
		         }
		         else{
    		         template=template+"<Argument id=\""+eElement.getAttribute("id")+"\""+" name=\""+eElement.getAttribute("name")+"\""+"><argType>"+eElement.getAttribute("type")+"</argType><value>"+ eElement.getAttribute("value")+"</value></Argument>";
		         }
		         cursor++;	         
		    }
		}
		
		System.out.println("After setting value:::");
		for (int temp = 0; temp < argNodes.getLength(); temp++) {
		    nNode = argNodes.item(temp);

		 if (nNode.getNodeType() == Node.ELEMENT_NODE) {
		        Element eElement = (Element) nNode;
		        System.out.println("value : "
		                           + eElement.getAttribute("value"));
		        
		        System.out.println("name : "
		                           + eElement.getAttribute("name"));
		         System.out.println("label : "
	        		                + eElement.getAttribute("label"));
		    }
		}
		
		
		DOMSource domSource = new DOMSource(doc);
	       StringWriter writer = new StringWriter();
	       StreamResult result = new StreamResult(writer);
	       TransformerFactory tf = TransformerFactory.newInstance();
	       Transformer transformer = tf.newTransformer();
	       transformer.transform(domSource, result);
		
		//return writer.toString().substring(38,writer.toString().length());
	       
	       
	     return OPENING_TAG+template+CLOSING_TAG; 
	       
	}
	
	
	//method which holds valus inside array list for multilple values reports
	
	public String getDynamicArgumentList(XSDParser xsdParser,ArrayList<Object> valueList)throws ITMException, Exception
	{
		String template="";
		int cursor=0;
		Node nNode=null;
		XSDParser xsdParser1=xsdParser;
		System.out.println("insie dynamic argument::"+xsdParser1.getArgumentMetaDataString());
		Document doc = DocumentBuilderFactory.newInstance()
                .newDocumentBuilder()
                .parse(new InputSource(new StringReader(xsdParser1.getArgumentMetaDataString())));

		NodeList argNodes = doc.getElementsByTagName("argument");
		
		System.out.println("Befor Setting value:::");
		for (int temp = 0; temp < argNodes.getLength(); temp++) {
		    nNode = argNodes.item(temp);

		 if (nNode.getNodeType() == Node.ELEMENT_NODE) {
		        Element eElement = (Element) nNode;
		        System.out.println("value : "
		                           + eElement.getAttribute("value"));
		        
		        /*if(eElement.getAttribute("name").equals("user_code")){
		        	eElement.setAttribute("value", profileid);
		        }*/
		        
		        System.out.println("name : "
		                           + eElement.getAttribute("name"));
		         System.out.println("label : "
	        		                + eElement.getAttribute("label"));
		         
		         if(cursor<valueList.size()){
		        	 System.out.println("valueList.get(temp)::"+valueList.get(temp));
	    		         template=template+"<Argument id=\""+eElement.getAttribute("id")+"\""+" name=\""+eElement.getAttribute("name")+"\""+"><argType>"+eElement.getAttribute("type")+"</argType><value>"+valueList.get(temp)+"</value></Argument>";
		         }
		         else{
    		         template=template+"<Argument id=\""+eElement.getAttribute("id")+"\""+" name=\""+eElement.getAttribute("name")+"\""+"><argType>"+eElement.getAttribute("type")+"</argType><value>"+ eElement.getAttribute("value")+"</value></Argument>";
		         }
		         cursor++;	         
		    }
		}
		
		System.out.println("After setting value:::");
		for (int temp = 0; temp < argNodes.getLength(); temp++) {
		    nNode = argNodes.item(temp);

		 if (nNode.getNodeType() == Node.ELEMENT_NODE) {
		        Element eElement = (Element) nNode;
		        System.out.println("value : "
		                           + eElement.getAttribute("value"));
		        
		        System.out.println("name : "
		                           + eElement.getAttribute("name"));
		         System.out.println("label : "
	        		                + eElement.getAttribute("label"));
		    }
		}
		
		
		DOMSource domSource = new DOMSource(doc);
	       StringWriter writer = new StringWriter();
	       StreamResult result = new StreamResult(writer);
	       TransformerFactory tf = TransformerFactory.newInstance();
	       Transformer transformer = tf.newTransformer();
	       transformer.transform(domSource, result);
		
		//return writer.toString().substring(38,writer.toString().length());
	       
	       
	     return OPENING_TAG+template+CLOSING_TAG; 
	       
	}
	

	
	
}
