package ibase.webitm.ejb.sc;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.MailInfo;
import ibase.utility.UserInfoBean;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;

public class ReportCreationSchedulerSfa implements Schedule{

	String mailAddress="";
	String userInfoXml = "";
	//String userInfoXml = "";

	UserInfoBean userInfo = null;

	@Override
	public String schedule(HashMap arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String schedule(String arg0) throws Exception {
		System.out.println("Inside schedule  "+arg0);
		return this.performOp(arg0);

	}

	@Override
	public String schedulePriority(String arg0) throws Exception {
		// TODO Auto-generated method stub
		System.out.println("Inside schedule priority "+arg0);
		return this.performOp(arg0);
	}


	public String performOp(String scheduleParamXML)throws ITMException
	{
		String retString = "";
		//Added By Amit Shrivastava [Start][11/08/20]
		/*Connection conn = null;*/
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs=null;
		//Added By Amit Shrivastava [End...][11/08/20]
		boolean isError = false;
		try
		{

			//printLog("STDOUT","ReportCreationScheduler : performOp => Scheduler Started");
			//printLog("STDOUT","ReportCreationScheduler : performOp : =>" + scheduleParamXML);

			//Added By Amit Shrivastava[Start][11/08/20]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB();*/

			this.userInfoXml = scheduleParamXML;
			System.out.println("userInfoXml:::[" + this.userInfoXml + "]"+"scheduleParamXML>> "+scheduleParamXML);
			userInfo = new UserInfoBean(this.userInfoXml);
			System.out.println("userInfo > Amit > " +userInfo);
			String transDB = userInfo.getTransDB();
			System.out.println("get TransDB connection in updateStatus : " + transDB);
			if ((transDB != null) && (transDB.trim().length() > 0))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			else
			{
				conn = connDriver.getConnectDB("DriverITM");
			}
			//Added By Amit Shrivastava[End....][11/08/20]

			retString = performOp(scheduleParamXML, conn);
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}

	public String performOp(String scheduleParamXML,Connection conn)throws ITMException, Exception
	{
		String retString="";
		String sql="",objName="",argumentString="",jrxmlName=""; 
		String sqlExpr="",sqlExpr1="",sqlExpr2="",sqlExpr3="",sqlExpr4="",sqlExpr5="",sqlExpr6="",errfilePath="";
		String compSql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList<String> objtNamelist=new ArrayList<String>();
		String objtNames="";
		String stateCode="",reportGroup = null;
		//ibase.utility.UserInfoBean userInfo = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ArrayList<Object> valueContainer=new ArrayList<Object>();
		boolean mailSent = false;
		String transInfo = "";
		//Added By Amit Shrivastava on 04/16/19 for create a variable [Start]
		String mailFormat="";
		//Added By Amit Shrivastava on 04/16/19 for create a variable [End]
		System.out.println("scheduler xml content:"+scheduleParamXML);
		//String reportGroup=scheduleParamXML.substring(scheduleParamXML.indexOf("<reportGroup>")+22, scheduleParamXML.indexOf("</reportGroup>")-3);
		String transDB = "";
		ConnDriver connDriver = new ConnDriver();
		try{
			//userInfo = new ibase.utility.UserInfoBean( scheduleParamXML );

			Document dom=genericUtility.parseString(scheduleParamXML);
			System.out.println(" before add parameter userInfo>>>>>" + userInfo);
			String chgUser = genericUtility.getColumnValue("empName", dom);
			String chgTerm = genericUtility.getColumnValue("hostIP", dom);
			String loginCode = genericUtility.getColumnValue("loginCode", dom);
			String loginEmpCode = genericUtility.getColumnValue("empCode", dom);
			String loginSiteCode = genericUtility.getColumnValue("siteCode", dom);
			System.out.println("chgUser>> " + chgUser + "chgTerm>>>" + chgTerm + "loginCode>>>" + loginCode + "loginEmpCode>>>" + loginEmpCode + "loginSiteCode>>>" + loginSiteCode);
			userInfo.setEmpCode(loginEmpCode);
			userInfo.setRemoteHost(chgTerm);
			userInfo.setSiteCode(loginSiteCode);
			userInfo.setLoginCode(loginCode);
			userInfo.setEntityCode(loginEmpCode);
			System.out.println(" add parameter userInfo>>>>>" + userInfo);
			//Dom related stuff goes here.....
			NodeList paramList = dom.getElementsByTagName( "SCHEDULE" );
			Node currDetail = null ;            
			int noOfParam = paramList.getLength();            
			NodeList parentNodeList = null,childNodeList = null;
			Node parentNode = null,childNode = null;
			String DisparmSites = "";
			int childNodeListLength = 0;
			String childNodeName = null;
			int index=0;

			parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");	

			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();

				if(childNodeName!=null && !"#text".equalsIgnoreCase(childNodeName))
				{
					if(ctr==0)
					{
						stateCode=checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("StateCode::"+stateCode);
					}
					else if(ctr==1)
					{
						reportGroup=checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("ReportGroup::"+reportGroup);
					}
					//Added By amit SHrivasatava on 04/06/19 for get the maol format value [Start]
					else if(ctr==2)
					{
						mailFormat=checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("@ MailFormat::"+mailFormat);
					}
					else if(ctr==3)
					{
						transDB=checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("@ transDB::"+transDB);
					}
					//Added By amit SHrivasatava on 04/06/19 for get the maol format value [end]

				}
			}

			userInfo.setTransDB(transDB);
			if ((transDB != null) && (transDB.trim().length() > 0))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			else
			{
				conn = connDriver.getConnectDB("DriverITM");
			}
			sql="select line_no,sql_expr,sql_input,sql_expr1,sql_expr2,sql_expr3,sql_expr4,"
					+ " sql_expr5,sql_expr6 from tax_bal_grp_det where bal_group=? ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, reportGroup);
			rs=pstmt.executeQuery();
			while(rs.next()){
				sqlExpr= checkNull(rs.getString("sql_expr"));
				sqlExpr1= checkNull(rs.getString("sql_expr1"));
				sqlExpr2= checkNull(rs.getString("sql_expr2"));
				sqlExpr3= checkNull( rs.getString("sql_expr3"));
				sqlExpr4= checkNull(rs.getString("sql_expr4"));
				sqlExpr5= checkNull(rs.getString("sql_expr5"));
				sqlExpr6= checkNull(rs.getString("sql_expr6"));  
				objtNames=checkNull(rs.getString("sql_input"));  
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;

			compSql= sqlExpr+" "+sqlExpr1+" "+sqlExpr2+" "+sqlExpr3+" "+sqlExpr4+" "+sqlExpr5+" "+sqlExpr6;
			System.out.println("Combine SQL::::"+compSql);

			String[] obj=objtNames.split(",");
			for(String s:obj){
				objtNamelist.add(s);
			}
			System.out.println("@narendra Obj name "+objtNamelist.get(0)+" Jrxml Name: "+objtNamelist.get(1));
			objName=objtNamelist.get(0);
			jrxmlName=objtNamelist.get(1);


			int count=0;
			if(compSql!=null && compSql.trim().length() > 0 )
			{

				pstmt=conn.prepareStatement(compSql);
				rs=pstmt.executeQuery();

				while(rs.next()){
					ResultSetMetaData rsmd = rs.getMetaData();
					for (int i = 1; i <= rsmd.getColumnCount(); i++) {
						int type = rsmd.getColumnType(i);
						if (type == Types.VARCHAR || type == Types.CHAR) {
							System.out.print("VARCHAR field:"+rs.getString(i));
							if(checkEmailAddress(rs.getString(i))){
								System.out.println("Mail id found");
							}else{
								valueContainer.add(rs.getString(i));
							}
						} 
						else if(type==Types.DATE){
							System.out.print("DATE field:"+rs.getDate(i));
							String dateAsString = rs.getDate(i).toString();
							DateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd");
							SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
							Date date = sourceFormat.parse(dateAsString);
							System.out.println(formatter.format(date)); 
							valueContainer.add(formatter.format(date));
						}
						else if(type==Types.TIMESTAMP){
							System.out.print("TIMESTAMP field:"+rs.getDate(i));
							valueContainer.add(rs.getTimestamp(i));
						}
						else {
							System.out.println("Exceptional case where data type may be different");
							//System.out.print(rs.getLong(i));
						}
					}

					System.out.println("Value container size:::"+valueContainer.size());

					count++;
					//argumentString=new ArgumentListGenerator().getArgumentList(objtNamelist.get(1),rs.getString(1));
					XSDParser xsdParser=new XSDParser(objName, userInfo);
					//argumentString=new ArgumentListGenerator().getDynamicArgumentList(xsdParser,rs.getString(1));
					argumentString=new ArgumentListGenerator().getDynamicArgumentList(xsdParser,valueContainer);

					valueContainer.clear();
					System.out.println("argumentString from dynamic ::==> ["+argumentString+"]");

					JasperReportGenerator jasperReport=new JasperReportGenerator(userInfo);
					TreeMap argMap = jasperReport.createArgMap(argumentString);	
					System.out.println("Value Of argMap >>>> "+argMap);
					String allType=(String) argMap.get("report_save_type");
					allType = allType == null ? "" : allType.trim();
					System.out.println("allType>>> Amit"+allType);
					if("PDF".equalsIgnoreCase(allType))
					{
						allType = "pdf";
					}
					else if("EXCEL".equalsIgnoreCase(allType) || "EXCELDATA".equalsIgnoreCase(allType) || "EXCEL-DATA".equalsIgnoreCase(allType) || "EXCEL DATA".equalsIgnoreCase(allType) || "ODS".equalsIgnoreCase(allType))
					{
						allType = "xls";
					}
					else if("CSV".equalsIgnoreCase(allType) || "CSVDATA".equalsIgnoreCase(allType))
					{
						allType = "csv";
					}
					else if("HTML".equalsIgnoreCase(allType))
					{
						allType = "html";
					}
					else if("TEXT".equalsIgnoreCase(allType))
					{
						allType = "txt";
					}
					else if("EXCEL(XLSX)".equalsIgnoreCase(allType))
					{
						allType = "xlsx";
					}
					else if("DOCX".equalsIgnoreCase(allType))
					{
						allType = "docx";
					}
					else if("RTF".equalsIgnoreCase(allType))
					{
						allType = "rtf";
					}
					else if("ODT".equalsIgnoreCase(allType))
					{
						allType = "odt";
					}
					System.out.println("allType>>> ::"+allType);
					System.out.println("Getting argument metadata::"+xsdParser.getArgumentMetaDataString());
					System.out.println("xsdParser::---->"+xsdParser);
					//argumnetMap get report_save_type value if report save type -- pdf ,xsl,//Amit

					/*      		
        			if (argNodes.getLength() > 0) {
        					Element err = (Element)argNodes.item(0);
        						System.out.println(err.getAttribute("value")+" "+err.getAttribute("name"));
        				} else { 
        						// success
        						}*/
					System.out.println(" add parameter userInfo>>>>>" + userInfo);

					jasperReport.createReport(jrxmlName, argMap, xsdParser, rs.getString("site_code"), rs.getString("tran_id")+"_"+count);

					String reportOutputFileName = jasperReport.getOutputFileName(); 
					System.out.println("[reportOutputFileName]:"+reportOutputFileName);
					String reportDestination = ResourceConstants.REPORTDESTINATION + File.separator + rs.getString("site_code") + File.separator 
							+ reportOutputFileName + "." +allType;

					transInfo = getDomString(rs.getString("email_addr"));
					//comment by amit shrivastava on 04/06/19 [Start]
					/*mailSent= sendMail(reportDestination,transInfo);*/
					String copyPath = ResourceConstants.REPORTDESTINATION + File.separator + "TempFolder";
					try
					{
						File copyFilePath = new File(copyPath);						
						if(!copyFilePath.exists()) {
							copyFilePath.mkdir();
						}
						else if(copyFilePath.exists())
						{
							try
							{
								if(count <= 1)
								{
									FileUtils.cleanDirectory(copyFilePath);
								}
							}
							catch(Exception exp)
							{
								exp.printStackTrace();
							}
						}
						File reportDestPath = new File(reportDestination);
						FileUtils.copyFileToDirectory(reportDestPath, copyFilePath);
						try
						{
							mailSent= sendMail(reportDestination,transInfo ,mailFormat, conn);
						}
						catch(Exception e)
						{
							System.out.println("Mail sending failed");
						}
					}
					catch(Exception e)
					{
						e.printStackTrace();
					}
					
					//comment by amit shrivastava on 04/06/19 [End]
					if(mailSent){
						printLog(rs.getString("email_addr"), rs.getString("tran_id"), reportOutputFileName,mailSent);//GENERATE LOG
						System.out.println("Succesfully send the mail");
					}else{
						printLog(rs.getString("email_addr"), rs.getString("tran_id"), reportOutputFileName,mailSent);//GENERATE LOG
						System.out.println("failure while sending the mail");
					}
					index++;
				}
				if(index==0){
					printLog("No Data Found", "Please Enter Valid Query to Return data");
				}

				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
		}
		catch(SQLException e1)
		{
			System.out.println("Error_Code::::"+e1.getErrorCode());
			System.out.println(e1);
			String err=String.valueOf(e1.getErrorCode());
			printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL ==>"+compSql);
			printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL ==>"+e1);

		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return retString; 
	}


	/**
	 * @param title
	 * @param msg
	 * This method is used for printing the logs in log file
	 */
	private void printLog(String title, String msg) 
	{
		String logFile = "";
		String logDir = "";
		File logFileDir = null;
		FileWriter fileWriter = null;

		try
		{
			String logFileName = "";
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			logFileName = "ReportScheduler_"+sdf.format(new Date());

			System.out.println("Inside the print log method");

			logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "ReportScheduler_";
			System.out.println("Log direction: "+logDir);

			logFileDir = new File(logDir);

			if (!logFileDir.exists()) 
			{
				logFileDir.mkdirs();
			}

			logFile = logDir + File.separator + logFileName + ".log";

			SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
			java.util.Date now = new java.util.Date();
			String strDate = sdfDate.format(now);

			fileWriter = new FileWriter(logFile, true);

			fileWriter.write("\r\n");
			fileWriter.write("[ERROR] "+msg);
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			printLog("STDERR", ex);
			printLog("STDOUT","Inside Exception [getLog]>>" + ex.toString());
		} 
		finally 
		{
			try 
			{
				if (fileWriter != null) 
				{
					fileWriter.flush();
					fileWriter.close();
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				printLog("STDERR", e);
			}
		}
	}

	private void printLog(String maildId, String tranId,String fileName,boolean mailSent) 
	{
		String logFile = "";
		String logDir = "";
		File logFileDir = null;
		FileWriter fileWriter = null;

		try
		{
			String logFileName = "";
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			logFileName = "ReportScheduler_"+sdf.format(new Date());

			System.out.println("Inside the print log method");

			logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "ReportScheduler_";
			System.out.println("Log direction: "+logDir);

			logFileDir = new File(logDir);

			if (!logFileDir.exists()) 
			{
				logFileDir.mkdirs();
			}

			logFile = logDir + File.separator + logFileName + ".log";

			SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
			java.util.Date now = new java.util.Date();
			String strDate = sdfDate.format(now);

			fileWriter = new FileWriter(logFile, true);

			fileWriter.write("\r\n");
			if(mailSent){
				fileWriter.write("Succesfully Sent mail to ["+tranId + "] " + "With File Name" + " ["+ fileName+"] on Mail Id "+"["+maildId+"]");
			}
			else{
				fileWriter.write("Mail is not Sent to ["+tranId + "] " + "With File Name" + " ["+ fileName+"] on Mail Id "+"["+maildId+"]");
			}		
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			printLog("STDERR", ex);
			printLog("STDOUT","Inside Exception [getLog]>>" + ex.toString());
		} 
		finally 
		{
			try 
			{
				if (fileWriter != null) 
				{
					fileWriter.flush();
					fileWriter.close();
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				printLog("STDERR", e);
			}
		}
	}


	private void printLog(String title, Exception e) 
	{	
		try
		{
			StringWriter strError = new StringWriter();
			e.printStackTrace(new PrintWriter(strError));
			String err = strError.toString();	
			printLog(title, err);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			printLog("STDERR","Inside Exception [getLog]>>" + ex.toString());
		}
	}


	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input.trim();
	}

	//Send mail method will send the mail to stockiest person
	//Comment by amit shrivastava on 04/06/19 [start]
	/*public boolean sendMail(String reportFilePath, String transInfo)throws ITMException*/
	public boolean sendMail(String reportFilePath, String transInfo, String mailFormat, Connection conn)throws ITMException
	///Comment by amit shrivastava on 04/06/19 [end]
	{

		boolean sentMail = false;

		String lineNo = "1";
		String emailType = "page";
		StringBuffer valueXmlString=null;
		String retValue="";

		try{

			valueXmlString = new StringBuffer("<ROOT>");
			/*valueXmlString = new StringBuffer("<ROOT><TRANS_INFO>");
		valueXmlString.append("<OBJ_NAME>").append("<![CDATA[" + "" + "]]>").append("</OBJ_NAME>");
		valueXmlString.append("<REF_SER>").append("<![CDATA[" + "" + "]]>").append("</REF_SER>");
		valueXmlString.append("<REF_ID>").append("<![CDATA[" + "" + "]]>").append("</REF_ID>");
		valueXmlString.append("<LINE_NO>").append("<![CDATA[" + lineNo + "]]>").append("</LINE_NO>");
		valueXmlString.append("</TRANS_INFO>");

		valueXmlString.append("<MAIL>");
		valueXmlString.append("<EMAIL_TYPE>").append("<![CDATA[" + emailType + "]]>").append("</EMAIL_TYPE>");
		valueXmlString.append("<ENTITY_CODE>").append("<![CDATA[" + "SUN" + "]]>").append("</ENTITY_CODE>");
		valueXmlString.append("<ENTITY_TYPE>").append("<![CDATA[" + "" + "]]>").append("</ENTITY_TYPE>");
		valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[" + "E" +"]]>").append("</FORMAT_CODE>");
		valueXmlString.append("<TO_ADD>").append("<![CDATA[" +mailAddress +"]]>").append("</TO_ADD>");
		valueXmlString.append("<CC_ADD>").append("<![CDATA[" + mailAddress+"]]>").append("</CC_ADD>");
		valueXmlString.append("<SUBJECT>").append("<![CDATA[" + "Reports" +"]]>").append("</SUBJECT>");
		valueXmlString.append("<BODY_TEXT>").append("<![CDATA[" + "PFA of Report(s)" +"]]>").append("</BODY_TEXT>");
		valueXmlString.append("<MESSAGE>").append("<![CDATA[" + "PFA of Report(s)" +"]]>").append("</MESSAGE>");
		valueXmlString.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" + reportFilePath + "]]>").append("</XML_DATA_FILE_PATH>");
		valueXmlString.append("</MAIL>");
		valueXmlString.append("</ROOT>");*/

			//valueXmlString.append("<ROOT>");
			valueXmlString.append("<MAILINFO>");
			valueXmlString.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
			//Added By amit Shrivastava on 04/06/19 for add mail format in send mail method.[Start]
			if(mailFormat !=null && mailFormat.trim().length()>0)
			{
				valueXmlString.append("<FORMAT_CODE>").append("<![CDATA["+mailFormat+"]]>").append("</FORMAT_CODE>");
			}else
			{
				valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[GEN_REPORT]]>").append("</FORMAT_CODE>");
			}
			/*valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[GEN_REPORT]]>").append("</FORMAT_CODE>");*/
			//Added By amit Shrivastava on 04/06/19 for add mail format in send mail method.[End]
			//commInfo.append("<TO_ADD>").append("<![CDATA[" + emailTo + "]]>").append("</TO_ADD>");
			valueXmlString.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" + reportFilePath + "]]>").append("</XML_DATA_FILE_PATH>");
			valueXmlString.append("</MAILINFO>");
			valueXmlString.append("<XML_DATA>").append(transInfo).append("</XML_DATA>");
			valueXmlString.append("</ROOT>");


			String mailDomStr = valueXmlString.toString();

			System.out.println("@@## [Generic Report]  :sendMail mailDomStr :-->" + mailDomStr);
			EMail email = new EMail();
			MailInfo info=new MailInfo();
			retValue=email.sendMail(mailDomStr, "ITM", conn);
			if("S".equalsIgnoreCase(retValue))
			{
				//printLog("STDOUT","ReportCreationScheduler : sendMail => Mail sent successfully" );
				sentMail = true;
			}
			System.out.println("[Pdf]  mail delivered successfully" );  
		}
		catch (ITMException itme)
		{
			System.out.println("@@## ITMException [[Generic Report]] :sendMail  :sendMail :sendMail() :==>\n");
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :[[Generic Report]] :sendMail() :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return sentMail;
	}

	/**
	 * boolean method which will check whether string contains mail address or not
	 */
	public boolean checkEmailAddress(String emailValue){
		Pattern pattern = Pattern.compile("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
		Matcher mat = pattern.matcher(emailValue);
		return mat.matches();
	}

	private String getDomString(String emailIdPer) throws ITMException
	{
		String retString = "";
		StringBuffer valueXmlString = new StringBuffer();
		try
		{
			valueXmlString.append("<ROOT>");
			valueXmlString.append("<Detail1>");
			valueXmlString.append("<email_id_cust>").append("<![CDATA[" + emailIdPer + "]]>").append("</email_id_cust>");
			valueXmlString.append("</Detail1>");
			valueXmlString.append("</ROOT>");
			retString = valueXmlString.toString();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			printLog("ERROR", e);
		}
		return retString;
	}

}
