/*     */ package ibase.webitm.ejb.sc;
/*     */ 
/*     */ import ibase.scheduler.utility.interfaces.Schedule;
/*     */ import ibase.system.config.ConnDriver;
/*     */ import ibase.utility.CommonConstants;
/*     */ import ibase.utility.E12GenericUtility;
/*     */ import ibase.utility.EMail;
/*     */ import ibase.utility.MailInfo;
/*     */ import ibase.utility.UserInfoBean;
/*     */ import ibase.webitm.reports.utility.JasperReportGenerator;
/*     */ import ibase.webitm.reports.utility.ResourceConstants;
/*     */ import ibase.webitm.reports.utility.XSDParser;
/*     */ import ibase.webitm.utility.ITMException;
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.text.DateFormat;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.TreeMap;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;

import org.apache.commons.io.FileUtils;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ReportCreationSchedulerSfa
/*     */   implements Schedule
/*     */ {
/*  41 */   String mailAddress = "";
/*  42 */   String userInfoXml = "";
/*     */ 
/*  45 */   UserInfoBean userInfo = null;
/*     */ 
/*     */   public String schedule(HashMap arg0)
/*     */     throws Exception
/*     */   {
/*  50 */     return null;
/*     */   }
/*     */ 
/*     */   public String schedule(String arg0) throws Exception
/*     */   {
/*  55 */     System.out.println("Inside schedule  " + arg0);
/*  56 */     return performOp(arg0);
/*     */   }
/*     */ 
/*     */   public String schedulePriority(String arg0)
/*     */     throws Exception
/*     */   {
/*  63 */     System.out.println("Inside schedule priority " + arg0);
/*  64 */     return performOp(arg0);
/*     */   }
/*     */ 
/*     */   public String performOp(String scheduleParamXML)
/*     */     throws ITMException
/*     */   {
/*  70 */     String retString = "";
/*     */ 
/*  73 */     ConnDriver connDriver = new ConnDriver();
/*  74 */     Connection conn = null;
/*  75 */     PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;
/*  76 */     ResultSet rs = null;
/*     */ 
/*  78 */     boolean isError = false;
/*     */     try
/*     */     {
/*  89 */       this.userInfoXml = scheduleParamXML;
/*  90 */       System.out.println("userInfoXml:::[" + this.userInfoXml + "]" + "scheduleParamXML>> " + scheduleParamXML);
/*  91 */       this.userInfo = new UserInfoBean(this.userInfoXml);
/*  92 */       System.out.println("userInfo > Amit > " + this.userInfo);
/*  93 */       String transDB = this.userInfo.getTransDB();
/*  94 */       System.out.println("get TransDB connection in updateStatus : " + transDB);
/*  95 */       if ((transDB != null) && (transDB.trim().length() > 0))
/*     */       {
/*  97 */         conn = connDriver.getConnectDB(transDB);
/*     */       }
/*     */       else
/*     */       {
/* 101 */         conn = connDriver.getConnectDB("DriverITM");
/*     */       }
/*     */ 
/* 105 */       retString = performOp(scheduleParamXML, conn);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 109 */       isError = true;
/* 110 */       e.printStackTrace();
/* 111 */       throw new ITMException(e);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 117 */         if (conn != null)
/*     */         {
/* 119 */           if (isError)
/*     */           {
/* 121 */             conn.rollback();
/*     */           }
/*     */           else
/*     */           {
/* 125 */             conn.commit();
/*     */           }
/* 127 */           conn.close();
/* 128 */           conn = null;
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 133 */         e.printStackTrace();
/* 134 */         throw new ITMException(e);
/*     */       }
/*     */     }
/* 137 */     return retString;
/*     */   }
/*     */ 
/*     */   public String performOp(String scheduleParamXML, Connection conn) throws ITMException, Exception
/*     */   {
/* 142 */     String retString = "";
/* 143 */     String sql = ""; String objName = ""; String argumentString = ""; String jrxmlName = "";
/* 144 */     String sqlExpr = ""; String sqlExpr1 = ""; String sqlExpr2 = ""; String sqlExpr3 = ""; String sqlExpr4 = ""; String sqlExpr5 = ""; String sqlExpr6 = ""; String errfilePath = "";
/* 145 */     String compSql = "";
/* 146 */     PreparedStatement pstmt = null;
/* 147 */     ResultSet rs = null;
/* 148 */     ArrayList objtNamelist = new ArrayList();
/* 149 */     String objtNames = "";
/* 150 */     String stateCode = ""; String reportGroup = null;
/*     */ 
/* 152 */     E12GenericUtility genericUtility = new E12GenericUtility();
/* 153 */     ArrayList valueContainer = new ArrayList();
/* 154 */     boolean mailSent = false;
/* 155 */     String transInfo = "";
/*     */ 
/* 157 */     String mailFormat = "";
/*     */ 
/* 159 */     System.out.println("scheduler xml content:" + scheduleParamXML);
/*     */ 
/* 161 */     String transDB = "";
/* 162 */     ConnDriver connDriver = new ConnDriver();
/*     */     try
/*     */     {
/* 166 */       Document dom = genericUtility.parseString(scheduleParamXML);
/* 167 */       System.out.println(" before add parameter userInfo>>>>>" + this.userInfo);
/* 168 */       String chgUser = genericUtility.getColumnValue("empName", dom);
/* 169 */       String chgTerm = genericUtility.getColumnValue("hostIP", dom);
/* 170 */       String loginCode = genericUtility.getColumnValue("loginCode", dom);
/* 171 */       String loginEmpCode = genericUtility.getColumnValue("empCode", dom);
/* 172 */       String loginSiteCode = genericUtility.getColumnValue("siteCode", dom);
/* 173 */       System.out.println("chgUser>> " + chgUser + "chgTerm>>>" + chgTerm + "loginCode>>>" + loginCode + "loginEmpCode>>>" + loginEmpCode + "loginSiteCode>>>" + loginSiteCode);
/* 174 */       this.userInfo.setEmpCode(loginEmpCode);
/* 175 */       this.userInfo.setRemoteHost(chgTerm);
/* 176 */       this.userInfo.setSiteCode(loginSiteCode);
/* 177 */       this.userInfo.setLoginCode(loginCode);
/* 178 */       this.userInfo.setEntityCode(loginEmpCode);
/* 179 */       System.out.println(" add parameter userInfo>>>>>" + this.userInfo);
/*     */ 
/* 181 */       NodeList paramList = dom.getElementsByTagName("SCHEDULE");
/* 182 */       Node currDetail = null;
/* 183 */       int noOfParam = paramList.getLength();
/* 184 */       NodeList parentNodeList = null; NodeList childNodeList = null;
/* 185 */       Node parentNode = null; Node childNode = null;
/* 186 */       String DisparmSites = "";
/* 187 */       int childNodeListLength = 0;
/* 188 */       String childNodeName = null;
/* 189 */       int index = 0;
/*     */ 
/* 191 */       parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");
/*     */ 
/* 193 */       parentNode = parentNodeList.item(0);
/* 194 */       childNodeList = parentNode.getChildNodes();
/* 195 */       childNodeListLength = childNodeList.getLength();
/*     */ 
/* 197 */       for (int ctr = 0; ctr < childNodeListLength; ctr++)
/*     */       {
/* 199 */         childNode = childNodeList.item(ctr);
/* 200 */         childNodeName = childNode.getNodeName();
/*     */ 
/* 202 */         if ((childNodeName == null) || ("#text".equalsIgnoreCase(childNodeName)))
/*     */           continue;
/* 204 */         if (ctr == 0)
/*     */         {
/* 206 */           stateCode = checkNull(childNode.getFirstChild().getNodeValue());
/* 207 */           System.out.println("StateCode::" + stateCode);
/*     */         }
/* 209 */         else if (ctr == 1)
/*     */         {
/* 211 */           reportGroup = checkNull(childNode.getFirstChild().getNodeValue());
/* 212 */           System.out.println("ReportGroup::" + reportGroup);
/*     */         }
/* 215 */         else if (ctr == 2)
/*     */         {
/* 217 */           mailFormat = checkNull(childNode.getFirstChild().getNodeValue());
/* 218 */           System.out.println("@ MailFormat::" + mailFormat);
/*     */         } else {
/* 220 */           if (ctr != 3)
/*     */             continue;
/* 222 */           transDB = checkNull(childNode.getFirstChild().getNodeValue());
/* 223 */           System.out.println("@ transDB::" + transDB);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 230 */       this.userInfo.setTransDB(transDB);
/* 231 */       if ((transDB != null) && (transDB.trim().length() > 0))
/*     */       {
/* 233 */         conn = connDriver.getConnectDB(transDB);
/*     */       }
/*     */       else
/*     */       {
/* 237 */         conn = connDriver.getConnectDB("DriverITM");
/*     */       }
/* 239 */       sql = "select line_no,sql_expr,sql_input,sql_expr1,sql_expr2,sql_expr3,sql_expr4, sql_expr5,sql_expr6 from tax_bal_grp_det where bal_group=? ";
/*     */ 
/* 241 */       pstmt = conn.prepareStatement(sql);
/* 242 */       pstmt.setString(1, reportGroup);
/* 243 */       rs = pstmt.executeQuery();
/* 244 */       while (rs.next()) {
/* 245 */         sqlExpr = checkNull(rs.getString("sql_expr"));
/* 246 */         sqlExpr1 = checkNull(rs.getString("sql_expr1"));
/* 247 */         sqlExpr2 = checkNull(rs.getString("sql_expr2"));
/* 248 */         sqlExpr3 = checkNull(rs.getString("sql_expr3"));
/* 249 */         sqlExpr4 = checkNull(rs.getString("sql_expr4"));
/* 250 */         sqlExpr5 = checkNull(rs.getString("sql_expr5"));
/* 251 */         sqlExpr6 = checkNull(rs.getString("sql_expr6"));
/* 252 */         objtNames = checkNull(rs.getString("sql_input"));
/*     */       }
/* 254 */       rs.close();
/* 255 */       rs = null;
/* 256 */       pstmt.close();
/* 257 */       pstmt = null;
/*     */ 
/* 259 */       compSql = sqlExpr + " " + sqlExpr1 + " " + sqlExpr2 + " " + sqlExpr3 + " " + sqlExpr4 + " " + sqlExpr5 + " " + sqlExpr6;
/* 260 */       System.out.println("Combine SQL::::" + compSql);
/*     */ 
/* 262 */       String[] obj = objtNames.split(",");
/* 263 */       for (String s : obj) {
/* 264 */         objtNamelist.add(s);
/*     */       }
/* 266 */       System.out.println("@narendra Obj name " + (String)objtNamelist.get(0) + " Jrxml Name: " + (String)objtNamelist.get(1));
/* 267 */       objName = (String)objtNamelist.get(0);
/* 268 */       jrxmlName = (String)objtNamelist.get(1);
/*     */ 
/* 271 */       int count = 0;
/* 272 */       if ((compSql != null) && (compSql.trim().length() > 0))
/*     */       {
/* 275 */         pstmt = conn.prepareStatement(compSql);
/* 276 */         rs = pstmt.executeQuery();
/*     */ 
/* 278 */         while (rs.next()) {
/* 279 */           ResultSetMetaData rsmd = rs.getMetaData();
/* 280 */           for (int i = 1; i <= rsmd.getColumnCount(); i++) {
/* 281 */             int type = rsmd.getColumnType(i);
/* 282 */             if ((type == 12) || (type == 1)) {
/* 283 */               System.out.print("VARCHAR field:" + rs.getString(i));
/* 284 */               if (checkEmailAddress(rs.getString(i)))
/* 285 */                 System.out.println("Mail id found");
/*     */               else {
/* 287 */                 valueContainer.add(rs.getString(i));
/*     */               }
/*     */             }
/* 290 */             else if (type == 91) {
/* 291 */               System.out.print("DATE field:" + rs.getDate(i));
/* 292 */               String dateAsString = rs.getDate(i).toString();
/* 293 */               DateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd");
/* 294 */               SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
/* 295 */               java.util.Date date = sourceFormat.parse(dateAsString);
/* 296 */               System.out.println(formatter.format(date));
/* 297 */               valueContainer.add(formatter.format(date));
/*     */             }
/* 299 */             else if (type == 93) {
/* 300 */               System.out.print("TIMESTAMP field:" + rs.getDate(i));
/* 301 */               valueContainer.add(rs.getTimestamp(i));
/*     */             }
/*     */             else {
/* 304 */               System.out.println("Exceptional case where data type may be different");
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 309 */           System.out.println("Value container size:::" + valueContainer.size());
/*     */ 
/* 311 */           count++;
/*     */ 
/* 313 */           XSDParser xsdParser = new XSDParser(objName, this.userInfo);
/*     */ 
/* 315 */           argumentString = new ArgumentListGenerator().getDynamicArgumentList(xsdParser, valueContainer);
/*     */ 
/* 317 */           valueContainer.clear();
/* 318 */           System.out.println("argumentString from dynamic ::==> [" + argumentString + "]");
/*     */ 
/* 320 */           JasperReportGenerator jasperReport = new JasperReportGenerator(this.userInfo);
/* 321 */           TreeMap argMap = jasperReport.createArgMap(argumentString);
/* 322 */           System.out.println("Value Of argMap >>>> " + argMap);
/* 323 */           String allType = (String)argMap.get("report_save_type");
/* 324 */           allType = allType == null ? "" : allType.trim();
/* 325 */           System.out.println("allType>>> Amit" + allType);
/* 326 */           if ("PDF".equalsIgnoreCase(allType))
/*     */           {
/* 328 */             allType = "pdf";
/*     */           }
/* 330 */           else if (("EXCEL".equalsIgnoreCase(allType)) || ("EXCELDATA".equalsIgnoreCase(allType)) || ("EXCEL-DATA".equalsIgnoreCase(allType)) || ("EXCEL DATA".equalsIgnoreCase(allType)) || ("ODS".equalsIgnoreCase(allType)))
/*     */           {
/* 332 */             allType = "xls";
/*     */           }
/* 334 */           else if (("CSV".equalsIgnoreCase(allType)) || ("CSVDATA".equalsIgnoreCase(allType)))
/*     */           {
/* 336 */             allType = "csv";
/*     */           }
/* 338 */           else if ("HTML".equalsIgnoreCase(allType))
/*     */           {
/* 340 */             allType = "html";
/*     */           }
/* 342 */           else if ("TEXT".equalsIgnoreCase(allType))
/*     */           {
/* 344 */             allType = "txt";
/*     */           }
/* 346 */           else if ("EXCEL(XLSX)".equalsIgnoreCase(allType))
/*     */           {
/* 348 */             allType = "xlsx";
/*     */           }
/* 350 */           else if ("DOCX".equalsIgnoreCase(allType))
/*     */           {
/* 352 */             allType = "docx";
/*     */           }
/* 354 */           else if ("RTF".equalsIgnoreCase(allType))
/*     */           {
/* 356 */             allType = "rtf";
/*     */           }
/* 358 */           else if ("ODT".equalsIgnoreCase(allType))
/*     */           {
/* 360 */             allType = "odt";
/*     */           }
/* 362 */           System.out.println("allType>>> ::" + allType);
/* 363 */           System.out.println("Getting argument metadata::" + xsdParser.getArgumentMetaDataString());
/* 364 */           System.out.println("xsdParser::---->" + xsdParser);
/*     */ 
/* 374 */           System.out.println(" add parameter userInfo>>>>>" + this.userInfo);
/*     */ 
/* 376 */           jasperReport.createReport(jrxmlName, argMap, xsdParser, rs.getString("site_code"), rs.getString("tran_id") + "_" + count);
/*     */ 
/* 378 */           String reportOutputFileName = jasperReport.getOutputFileName();
/* 379 */           System.out.println("[reportOutputFileName]:" + reportOutputFileName);
/* 380 */           String reportDestination = ResourceConstants.REPORTDESTINATION + File.separator + rs.getString("site_code") + File.separator + 
/* 381 */             reportOutputFileName + "." + allType;
/*     */ 
/* 383 */           transInfo = getDomString(rs.getString("email_addr"));
/*     */ 
/* 386 */           String copyPath = ResourceConstants.REPORTDESTINATION + File.separator + "TempFolder";
/*     */           try
/*     */           {
/* 389 */             File copyFilePath = new File(copyPath);
/* 390 */             if (!copyFilePath.exists()) {
/* 391 */               copyFilePath.mkdir();
/*     */             }
/* 393 */             else if (copyFilePath.exists())
/*     */             {
/*     */               try
/*     */               {
/* 397 */                 if (count <= 1)
/*     */                 {
/* 399 */                   FileUtils.cleanDirectory(copyFilePath);
/*     */                 }
/*     */               }
/*     */               catch (Exception exp)
/*     */               {
/* 404 */                 exp.printStackTrace();
/*     */               }
/*     */             }
/* 407 */             File reportDestPath = new File(reportDestination);
/* 408 */             FileUtils.copyFileToDirectory(reportDestPath, copyFilePath);
/*     */             try
/*     */             {
/* 411 */               mailSent = sendMail(reportDestination, transInfo, mailFormat, conn);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 415 */               System.out.println("Mail sending failed");
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 420 */             e.printStackTrace();
/*     */           }
/*     */ 
/* 424 */           if (mailSent) {
/* 425 */             printLog(rs.getString("email_addr"), rs.getString("tran_id"), reportOutputFileName, mailSent);
/* 426 */             System.out.println("Succesfully send the mail");
/*     */           } else {
/* 428 */             printLog(rs.getString("email_addr"), rs.getString("tran_id"), reportOutputFileName, mailSent);
/* 429 */             System.out.println("failure while sending the mail");
/*     */           }
/* 431 */           index++;
/*     */         }
/* 433 */         if (index == 0) {
/* 434 */           printLog("No Data Found", "Please Enter Valid Query to Return data");
/*     */         }
/*     */ 
/* 437 */         rs.close();
/* 438 */         rs = null;
/* 439 */         pstmt.close();
/* 440 */         pstmt = null;
/*     */       }
/*     */     }
/*     */     catch (SQLException e1)
/*     */     {
/* 445 */       System.out.println("Error_Code::::" + e1.getErrorCode());
/* 446 */       System.out.println(e1);
/* 447 */       String err = String.valueOf(e1.getErrorCode());
/* 448 */       printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL ==>" + compSql);
/* 449 */       printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL ==>" + e1);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 454 */       throw new Exception(e);
/*     */     }
/*     */     finally
/*     */     {
/* 458 */       if (rs != null)
/*     */       {
/* 460 */         rs.close();
/* 461 */         rs = null;
/*     */       }
/* 463 */       if (pstmt != null)
/*     */       {
/* 465 */         pstmt.close();
/* 466 */         pstmt = null;
/*     */       }
/*     */     }
/* 469 */     return retString;
/*     */   }
/*     */ 
/*     */   private void printLog(String title, String msg)
/*     */   {
/* 480 */     String logFile = "";
/* 481 */     String logDir = "";
/* 482 */     File logFileDir = null;
/* 483 */     FileWriter fileWriter = null;
/*     */     try
/*     */     {
/* 487 */       String logFileName = "";
/* 488 */       SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
/* 489 */       logFileName = "ReportScheduler_" + sdf.format(new java.util.Date());
/*     */ 
/* 491 */       System.out.println("Inside the print log method");
/*     */ 
/* 493 */       logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "ReportScheduler_";
/* 494 */       System.out.println("Log direction: " + logDir);
/*     */ 
/* 496 */       logFileDir = new File(logDir);
/*     */ 
/* 498 */       if (!logFileDir.exists())
/*     */       {
/* 500 */         logFileDir.mkdirs();
/*     */       }
/*     */ 
/* 503 */       logFile = logDir + File.separator + logFileName + ".log";
/*     */ 
/* 505 */       SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
/* 506 */       java.util.Date now = new java.util.Date();
/* 507 */       String strDate = sdfDate.format(now);
/*     */ 
/* 509 */       fileWriter = new FileWriter(logFile, true);
/*     */ 
/* 511 */       fileWriter.write("\r\n");
/* 512 */       fileWriter.write("[ERROR] " + msg);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 516 */       ex.printStackTrace();
/* 517 */       printLog("STDERR", ex);
/* 518 */       printLog("STDOUT", "Inside Exception [getLog]>>" + ex.toString());
/*     */       try
/*     */       {
/* 524 */         if (fileWriter != null)
/*     */         {
/* 526 */           fileWriter.flush();
/* 527 */           fileWriter.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 532 */         e.printStackTrace();
/* 533 */         printLog("STDERR", e);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 524 */         if (fileWriter != null)
/*     */         {
/* 526 */           fileWriter.flush();
/* 527 */           fileWriter.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 532 */         e.printStackTrace();
/* 533 */         printLog("STDERR", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void printLog(String maildId, String tranId, String fileName, boolean mailSent)
/*     */   {
/* 540 */     String logFile = "";
/* 541 */     String logDir = "";
/* 542 */     File logFileDir = null;
/* 543 */     FileWriter fileWriter = null;
/*     */     try
/*     */     {
/* 547 */       String logFileName = "";
/* 548 */       SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
/* 549 */       logFileName = "ReportScheduler_" + sdf.format(new java.util.Date());
/*     */ 
/* 551 */       System.out.println("Inside the print log method");
/*     */ 
/* 553 */       logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "ReportScheduler_";
/* 554 */       System.out.println("Log direction: " + logDir);
/*     */ 
/* 556 */       logFileDir = new File(logDir);
/*     */ 
/* 558 */       if (!logFileDir.exists())
/*     */       {
/* 560 */         logFileDir.mkdirs();
/*     */       }
/*     */ 
/* 563 */       logFile = logDir + File.separator + logFileName + ".log";
/*     */ 
/* 565 */       SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
/* 566 */       java.util.Date now = new java.util.Date();
/* 567 */       String strDate = sdfDate.format(now);
/*     */ 
/* 569 */       fileWriter = new FileWriter(logFile, true);
/*     */ 
/* 571 */       fileWriter.write("\r\n");
/* 572 */       if (mailSent) {
/* 573 */         fileWriter.write("Succesfully Sent mail to [" + tranId + "] " + "With File Name" + " [" + fileName + "] on Mail Id " + "[" + maildId + "]");
/*     */       }
/*     */       else {
/* 576 */         fileWriter.write("Mail is not Sent to [" + tranId + "] " + "With File Name" + " [" + fileName + "] on Mail Id " + "[" + maildId + "]");
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 581 */       ex.printStackTrace();
/* 582 */       printLog("STDERR", ex);
/* 583 */       printLog("STDOUT", "Inside Exception [getLog]>>" + ex.toString());
/*     */       try
/*     */       {
/* 589 */         if (fileWriter != null)
/*     */         {
/* 591 */           fileWriter.flush();
/* 592 */           fileWriter.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 597 */         e.printStackTrace();
/* 598 */         printLog("STDERR", e);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 589 */         if (fileWriter != null)
/*     */         {
/* 591 */           fileWriter.flush();
/* 592 */           fileWriter.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 597 */         e.printStackTrace();
/* 598 */         printLog("STDERR", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void printLog(String title, Exception e)
/*     */   {
/*     */     try
/*     */     {
/* 608 */       StringWriter strError = new StringWriter();
/* 609 */       e.printStackTrace(new PrintWriter(strError));
/* 610 */       String err = strError.toString();
/* 611 */       printLog(title, err);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 615 */       ex.printStackTrace();
/* 616 */       printLog("STDERR", "Inside Exception [getLog]>>" + ex.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private String checkNull(String input)
/*     */   {
/* 622 */     if (input == null) {
/* 623 */       input = "";
/*     */     }
/* 625 */     return input.trim();
/*     */   }
/*     */ 
/*     */   public boolean sendMail(String reportFilePath, String transInfo, String mailFormat, Connection conn)
/*     */     throws ITMException
/*     */   {
/* 635 */     boolean sentMail = false;
/*     */ 
/* 637 */     String lineNo = "1";
/* 638 */     String emailType = "page";
/* 639 */     StringBuffer valueXmlString = null;
/* 640 */     String retValue = "";
/*     */     try
/*     */     {
/* 644 */       valueXmlString = new StringBuffer("<ROOT>");
/*     */ 
/* 667 */       valueXmlString.append("<MAILINFO>");
/* 668 */       valueXmlString.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
/*     */ 
/* 670 */       if ((mailFormat != null) && (mailFormat.trim().length() > 0))
/*     */       {
/* 672 */         valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[" + mailFormat + "]]>").append("</FORMAT_CODE>");
/*     */       }
/*     */       else {
/* 675 */         valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[GEN_REPORT]]>").append("</FORMAT_CODE>");
/*     */       }
/*     */ 
/* 680 */       valueXmlString.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" + reportFilePath + "]]>").append("</XML_DATA_FILE_PATH>");
/* 681 */       valueXmlString.append("</MAILINFO>");
/* 682 */       valueXmlString.append("<XML_DATA>").append(transInfo).append("</XML_DATA>");
/* 683 */       valueXmlString.append("</ROOT>");
/*     */ 
/* 686 */       String mailDomStr = valueXmlString.toString();
/*     */ 
/* 688 */       System.out.println("@@## [Generic Report]  :sendMail mailDomStr :-->" + mailDomStr);
/* 689 */       EMail email = new EMail();
/* 690 */       MailInfo info = new MailInfo();
/* 691 */       retValue = email.sendMail(mailDomStr, "ITM", conn);
/* 692 */       if ("S".equalsIgnoreCase(retValue))
/*     */       {
/* 695 */         sentMail = true;
/*     */       }
/* 697 */       System.out.println("[Pdf]  mail delivered successfully");
/*     */     }
/*     */     catch (ITMException itme)
/*     */     {
/* 701 */       System.out.println("@@## ITMException [[Generic Report]] :sendMail  :sendMail :sendMail() :==>\n");
/* 702 */       throw itme;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 706 */       System.out.println("Exception :[[Generic Report]] :sendMail() :==>\n" + e.getMessage());
/* 707 */       throw new ITMException(e);
/*     */     }
/* 709 */     return sentMail;
/*     */   }
/*     */ 
/*     */   public boolean checkEmailAddress(String emailValue)
/*     */   {
/* 716 */     Pattern pattern = Pattern.compile("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
/* 717 */     Matcher mat = pattern.matcher(emailValue);
/* 718 */     return mat.matches();
/*     */   }
/*     */ 
/*     */   private String getDomString(String emailIdPer) throws ITMException
/*     */   {
/* 723 */     String retString = "";
/* 724 */     StringBuffer valueXmlString = new StringBuffer();
/*     */     try
/*     */     {
/* 727 */       valueXmlString.append("<ROOT>");
/* 728 */       valueXmlString.append("<Detail1>");
/* 729 */       valueXmlString.append("<email_id_cust>").append("<![CDATA[" + emailIdPer + "]]>").append("</email_id_cust>");
/* 730 */       valueXmlString.append("</Detail1>");
/* 731 */       valueXmlString.append("</ROOT>");
/* 732 */       retString = valueXmlString.toString();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 736 */       e.printStackTrace();
/* 737 */       printLog("ERROR", e);
/*     */     }
/* 739 */     return retString;
/*     */   }
/*     */ }

/* Location:           C:\Users\pravin.nevage\Desktop\ibase3-webitm-sc2-0-1-5.jar
 * Qualified Name:     ibase.webitm.ejb.sc.ReportCreationSchedulerSfa
 * JD-Core Version:    0.6.0
 */