/*     */ package ibase.webitm.ejb.sc;
/*     */ 
/*     */ import ibase.utility.CommonConstants;
/*     */ import ibase.webitm.ejb.dis.DistCommon;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileReader;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.sql.Connection;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.ArrayList;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
/*     */ 
/*     */ public class SFACSVToExcelConverter
/*     */ {
/*     */   public static final char FILE_DELIMITER = ',';
/*     */   public static final String FILE_EXTN = ".xlsx";
/*     */   public static final String FILE_NAME = "EXCEL_DATA";
/*     */ 
/*     */   public void convert(String fileName, String seperator)
/*     */     throws IOException
/*     */   {
/*  50 */     String jbossHome = CommonConstants.JBOSSHOME;
/*     */ 
/*  52 */     String fName = jbossHome + File.separator + 
/*  53 */       "SFACDailyReport" + File.separator + fileName;
/*     */ 
/*  55 */     ArrayList arList = null;
/*  56 */     ArrayList al = null;
/*     */ 
/*  58 */     int count = 0;
/*  59 */     FileReader reader = new FileReader(fName + ".csv");
/*     */ 
/*  62 */     BufferedReader bufferedReader = new BufferedReader(reader);
/*  63 */     int i = 0;
/*  64 */     arList = new ArrayList();
/*     */     String thisLine;
/*  66 */     while ((thisLine = bufferedReader.readLine()) != null)
/*     */     {
/*  69 */       al = new ArrayList();
/*  70 */       String[] strar = thisLine.split(seperator);
/*  71 */       for (int j = 0; j < strar.length; j++) {
/*  72 */         al.add(strar[j]);
/*     */       }
/*  74 */       arList.add(al);
/*  75 */       System.out.println();
/*  76 */       i++;
/*     */     }
/*     */     try
/*     */     {
/*  80 */       HSSFWorkbook hwb = new HSSFWorkbook();
/*  81 */       HSSFSheet sheet = hwb.createSheet("new sheet");
/*     */ 
/*  83 */       HSSFCellStyle style = hwb.createCellStyle();
/*  84 */       style.setAlignment((short) 3);
/*  85 */       for (int k = 0; k < arList.size(); k++) {
/*  86 */         ArrayList ardata = (ArrayList)arList.get(k);
/*  87 */         HSSFRow row = sheet.createRow(0 + k);
/*  88 */         for (int p = 0; p < ardata.size(); p++) {
/*  89 */           HSSFCell cell = row.createCell((short)p);
/*  90 */           String data = ardata.get(p).toString();
/*  91 */           System.out.println("data: " + data);
/*  92 */           if (data.startsWith("=")) {
/*  93 */             cell.setCellType(1);
/*  94 */             data = data.replaceAll("\"", "");
/*  95 */             data = data.replaceAll("=", "");
/*  96 */             cell.setCellValue(data);
/*  97 */           } else if (data.startsWith("\"")) {
/*  98 */             data = data.replaceAll("\"", "");
/*  99 */             cell.setCellType(1);
/* 100 */             cell.setCellValue(data);
/* 101 */           } else if ((isNumeric(data)) && (!data.startsWith("0")))
/*     */           {
/* 103 */             System.out.println("In Numeric");
/*     */ 
/* 105 */             cell.setCellStyle(style);
/* 106 */             cell.setCellType(0);
/* 107 */             cell.setCellValue(Double.parseDouble(data));
/*     */           }
/*     */           else
/*     */           {
/* 111 */             data = data.replaceAll("\"", "");
/* 112 */             cell.setCellType(1);
/* 113 */             cell.setCellValue(data);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 118 */         System.out.println();
/*     */       }
/* 120 */       FileOutputStream fileOut = new FileOutputStream(fName + ".xls");
/* 121 */       hwb.write(fileOut);
/* 122 */       fileOut.close();
/* 123 */       reader.close();
/* 124 */       bufferedReader.close();
/* 125 */       File f = new File(fName + ".csv");
/* 126 */       Boolean value = Boolean.valueOf(f.delete());
/* 127 */       f.deleteOnExit();
/* 128 */       System.out.println("Value: " + value);
/* 129 */       System.out.println("Your excel file has been generated");
/*     */     } catch (Exception ex) {
/* 131 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String convertCsvToXls(String fileName, String xlsFileLocation)
/*     */     throws IOException
/*     */   {
/* 139 */     String jbossHome = CommonConstants.JBOSSHOME;
/*     */ 
/* 141 */     String fName = jbossHome + File.separator + 
/* 142 */       "SFACDailyReport" + File.separator + fileName;
/*     */ 
/* 144 */     ArrayList arList = null;
/* 145 */     ArrayList al = null;
/*     */ 
/* 147 */     int count = 0;
/* 148 */     FileInputStream fis = null;
/*     */     try {
/* 150 */       fis = new FileInputStream(fName + ".csv");
/*     */     }
/*     */     catch (FileNotFoundException e) {
/* 153 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 156 */     DataInputStream myInput = new DataInputStream(fis);
/* 157 */     int i = 0;
/* 158 */     arList = new ArrayList();
/*     */     String thisLine;
/* 160 */     while ((thisLine = myInput.readLine()) != null)
/*     */     {
/* 163 */       al = new ArrayList();
/* 164 */       String[] strar = thisLine.split(xlsFileLocation);
/* 165 */       for (int j = 0; j < strar.length; j++) {
/* 166 */         al.add(strar[j]);
/*     */       }
/* 168 */       arList.add(al);
/* 169 */       System.out.println();
/* 170 */       i++;
/*     */     }
/*     */ 
/* 173 */     System.out.println("xlsFileLocation>> " + xlsFileLocation);
/*     */ 
/* 175 */     System.out.println("csvFilePath>> " + fileName);
/* 176 */     SXSSFSheet sheet = null;
/*     */ 
/* 178 */     Workbook workBook = null;
/* 179 */     String generatedXlsFilePath = "";
/* 180 */     FileOutputStream fileOutputStream = null;
/*     */     try
/*     */     {
/* 188 */       workBook = new SXSSFWorkbook();
/* 189 */       sheet = (SXSSFSheet)workBook.createSheet("Sheet");
/*     */ 
/* 191 */       int rowNum = 0;
/*     */ 
/* 206 */       generatedXlsFilePath = xlsFileLocation + "EXCEL_DATA" + ".xlsx";
/*     */ 
/* 209 */       fileOutputStream = new FileOutputStream(generatedXlsFilePath.trim());
/* 210 */       workBook.write(fileOutputStream);
/*     */     } catch (Exception exObj) {
/* 212 */       exObj.printStackTrace();
/*     */     }
/*     */ 
/* 230 */     return generatedXlsFilePath;
/*     */   }
/*     */ 
/*     */   public void convertMonthlyReport(String fileName, String seperator, String logFileName, Connection conn)
/*     */     throws IOException
/*     */   {
/* 239 */     String currTime = null;
/* 240 */     SimpleDateFormat sdf1 = null;
/*     */ 
/* 251 */     SFAMonthlyReport sf = new SFAMonthlyReport();
/* 252 */     System.out.println("fileName>> " + fileName);
/* 253 */     System.out.println("seperator>> " + seperator);
/* 254 */     DistCommon disCom = new DistCommon();
/* 255 */     String jbossHome = disCom.getDisparams("999999", "MONTHLY_REPORT_", conn);
/* 256 */     System.out.println("jbossHome File Path  >> " + jbossHome);
/*     */ 
/* 262 */     String fName = jbossHome + File.separator + fileName;
/*     */ 
/* 264 */     System.out.println("inside the convertMonthlyReport fName >>" + fName);
/* 265 */     ArrayList arList = null;
/* 266 */     ArrayList al = null;
/*     */ 
/* 268 */     int count = 0;
/*     */ 
/* 270 */     FileReader reader = new FileReader(fName + ".csv");
/*     */ 
/* 274 */     BufferedReader bufferedReader = new BufferedReader(reader);
/*     */ 
/* 277 */     int i = 0;
/* 278 */     arList = new ArrayList();
/*     */     String thisLine;
/* 281 */     while ((thisLine = bufferedReader.readLine()) != null)
/*     */     {
/* 283 */       System.out.println("Inside the csv file ");
/*     */ 
/* 285 */       al = new ArrayList();
/* 286 */       String[] strar = thisLine.split(seperator);
/* 287 */       for (int j = 0; j < strar.length; j++) {
/* 288 */         al.add(strar[j]);
/*     */       }
/* 290 */       arList.add(al);
/* 291 */       System.out.println();
/* 292 */       i++;
/*     */     }
/*     */     try
/*     */     {
/* 296 */       System.out.println("@V2 arList :- [" + arList.size() + "]");
/* 297 */       System.out.println("@V2 arList :- [" + arList + "]");
/* 298 */       if (arList.size() <= 67000)
/*     */       {
/* 300 */         System.out.println("Before XSSFWorkbook Call");
/* 301 */         XSSFWorkbook hwb = new XSSFWorkbook();
/*     */ 
/* 303 */         System.out.println("After XSSFWorkbook Call");
/* 304 */         XSSFSheet sheet = hwb.createSheet("new sheet");
/*     */ 
/* 306 */         String data = "";
/*     */ 
/* 308 */         XSSFCellStyle style = hwb.createCellStyle();
/* 309 */         System.out.println("style??" + style);
/*     */ 
/* 311 */         style.setAlignment((short) 3);
/* 312 */         for (int k = 0; k < arList.size(); k++)
/*     */         {
/* 314 */           System.out.println("Inside the arList loop " + arList.get(k));
/*     */ 
/* 316 */           ArrayList ardata = (ArrayList)arList.get(k);
/* 317 */           XSSFRow row = sheet.createRow(0 + k);
/* 318 */           System.out.println("row:>> " + row);
/* 319 */           System.out.println("ardata>> " + ardata);
/* 320 */           System.out.println("Ardata Size>> " + ardata.size());
/*     */ 
/* 322 */           for (int p = 0; p < ardata.size(); p++)
/*     */           {
/* 324 */             System.out.println("Inside the ardata loop ");
/*     */ 
/* 328 */             XSSFCell cell = row.createCell((short)p);
/* 329 */             System.out.println("cell:>>" + cell);
/*     */ 
/* 332 */             data = ardata.get(p).toString();
/* 333 */             System.out.println("data 1>> " + data);
/* 334 */             if (data.startsWith("=")) {
/* 335 */               System.out.println("Inside if data ");
/* 336 */               cell.setCellType(1);
/* 337 */               data = data.replaceAll("\"", "");
/* 338 */               data = data.replaceAll("=", "");
/*     */ 
/* 340 */               System.out.println("data 2>>" + data);
/* 341 */               cell.setCellValue(data);
/*     */             }
/* 343 */             else if ((data.startsWith(" ")) || (data.startsWith("\t"))) {
/* 344 */               System.out.println("Inside else if data ");
/* 345 */               cell.setCellType(1);
/* 346 */               data = data.replaceAll("\t", "");
/* 347 */               data = data.replaceAll(" ", "");
/* 348 */               System.out.println("data3>> " + data);
/* 349 */               cell.setCellValue(data);
/*     */             }
/* 352 */             else if (data.startsWith("\"")) {
/* 353 */               System.out.println("Insdie \\");
/* 354 */               data = data.replaceAll("\"", "");
/* 355 */               System.out.println("data 4>> " + data);
/* 356 */               cell.setCellType(1);
/* 357 */               cell.setCellValue(data);
/*     */             }
/* 359 */             else if ((isNumeric(data)) && (!data.startsWith("0")))
/*     */             {
/* 361 */               System.out.println("In Numeric");
/*     */ 
/* 363 */               cell.setCellStyle(style);
/* 364 */               cell.setCellType(0);
/* 365 */               cell.setCellValue(Double.parseDouble(data));
/*     */             }
/*     */             else
/*     */             {
/* 369 */               System.out.println("Insdie  replaceAll\\");
/* 370 */               data = data.replaceAll("\"", "");
/* 371 */               cell.setCellType(1);
/* 372 */               cell.setCellValue(data);
/*     */             }
/* 374 */             data = null;
/*     */           }
/*     */ 
/* 377 */           System.out.println();
/*     */         }
/* 379 */         FileOutputStream fileOut = new FileOutputStream(fName + ".xlsx");
/* 380 */         hwb.write(fileOut);
/* 381 */         fileOut.close();
/* 382 */         reader.close();
/*     */ 
/* 384 */         bufferedReader.close();
/*     */ 
/* 386 */         File f = new File(fName + ".csv");
/* 387 */         Boolean value = Boolean.valueOf(f.delete());
/* 388 */         f.deleteOnExit();
/* 389 */         System.out.println("Value: " + value);
/* 390 */         System.out.println("Your Excel File Has Been Generated With File Name= " + fName);
/*     */ 
/* 392 */         sf.printLogFile("STDOUT", "File  Generated Name:=  :: <" + fileName + ">", logFileName, conn);
/*     */       }
/*     */       else
/*     */       {
/* 396 */         System.out.println("No excel created........[" + arList.size());
/*     */       }
/*     */     } catch (Exception ex) {
/* 399 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean isNumeric(String str)
/*     */   {
/*     */     try {
/* 406 */       if ((str.toUpperCase().contains("A")) || 
/* 407 */         (str.toUpperCase().contains("B")) || 
/* 408 */         (str.toUpperCase().contains("C")) || 
/* 409 */         (str.toUpperCase().contains("D")) || 
/* 410 */         (str.toUpperCase().contains("E"))) {
/* 411 */         return false;
/*     */       }
/* 413 */       double d = Double.parseDouble(str);
/*     */     }
/*     */     catch (NumberFormatException nfe) {
/* 416 */       return false;
/*     */     }
/* 418 */     return true;
/*     */   }
/*     */ }

/* Location:           C:\Users\pravin.nevage\Desktop\ibase3-webitm-sc2-0-1-5.jar
 * Qualified Name:     ibase.webitm.ejb.sc.SFACSVToExcelConverter
 * JD-Core Version:    0.6.0
 */