<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/">
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="/ibase/webitm/css/summary.css" />
                <title>Manage SQL</title>

                <style>
    /* keep entire page fixed (no page scrollbar) */
    html, body {
        margin: 0;
        padding: 0;
        height: 100%;
       
    }

    /* container fills available area but won't create a page scrollbar */
    .sum_Container {
        height: 100%;
        box-sizing: border-box;
        overflow: visible;
    }

    /* content area — allow internal layout but not page scroll */
    .sum_Content {
        height: 100%;
        overflow: visible; /* allow children to manage overflow */
        padding: 10px 12px;
        box-sizing: border-box;
    }

    /* general data cell style */
    .content_Row .txtData {
        overflow: visible;
        white-space: normal;
    }

    /* ✅ SQL box: independent scrolling area only for SQL statements */
    .txtData.sqlBox {
    height: 150px !important;
    width:600px !important;
    overflow-y: auto !important;
    overflow-x: auto !important;
    border: 1px solid #ccc;
    padding: 8px;
    background: #f9f9f9;
    box-sizing: border-box;
    white-space: pre-wrap;
    word-wrap: break-word;
    font-family: monospace;
    scrollbar-gutter: stable;
}



</style>

            </head>

            <body>
                <div class="sum_Container">
                    <div class="sum_Content">
                        <form id="detail" method="POST" style="margin-bottom:0;">

                            <div class="sum_Header">
                                <img src="/ibase/webitm/images/Summary/Header.png" class="sum_Icon pdLeft_16" alt="Header Icon" />
                                Manage SQL
                            </div>

                            <xsl:for-each select="//Detail1">
                                <div class="content_BG colomn_View">

                                    <div class="content_Row">
                                        <div class="txtlbl txtdark">Add User:</div>
                                        <div class="txtData" contentEditable="false">
                                            <xsl:value-of select="concat(users_name, ' (', emp_code__merge, ')')" />
                                        </div>
                                    </div>

                                    <div class="content_Row">
   					 <div class="txtlbl txtdark">Enterprise:</div>
    					<div class="txtData" contentEditable="false">
        			<xsl:choose>
            <!-- if enterprises is not empty -->
        				    <xsl:when test="normalize-space(enterprises) != ''">
              				   <xsl:value-of select="enterprises"/>
           					 </xsl:when>

           					 <!-- if enterprises is empty or null, use appl_db -->
            					<xsl:otherwise>
                				All Enterprise
            					</xsl:otherwise>
     				   </xsl:choose>
  			  </div>
			</div>


                                    <!-- Scrollable SQL box (only this box scrolls) -->
                                    <div class="content_Row">
                                        <div class="txtlbl txtdark">SQL Statement:</div>
                                        <div class="txtData sqlBox">
                                            <xsl:for-each select="//Detail2">
                                                <div style="margin-bottom:8px;">
                                                    <xsl:number format="1. " />
                                                    <xsl:value-of select="ora_stmnt" />
                                                </div>
                                            </xsl:for-each>
                                        </div>
                                    </div>

                                </div>
                            </xsl:for-each>

                        </form>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>

