<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: black;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:black;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;

					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			
            <!--<body bgcolor='#EEEEEE' onload=""> -->
                   <body bgcolor=' #FFFFFF' onload="">
           <!-- <div style="background-color: #fff;"> -->

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					<!-- padding-left:8%; -->
					padding:10px;
					}
					.firstData
					{
					color:black;
					width:50%;
					}
					@media only screen and (min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					.normalFont
					{
					font-size:14px;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_BrandPresc" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

							<xsl:variable name="sp_name">
									<xsl:value-of select="sp_name" />
							</xsl:variable>
													
							<xsl:variable name="sales_pers">
									<xsl:value-of select="sales_pers" />
							</xsl:variable>
							
							<xsl:variable name="hostUrl">
								<xsl:value-of select="host_url" />
							</xsl:variable>
									
							<xsl:variable name="doctorName">
								<xsl:value-of select="cust_name" />
							</xsl:variable>
									
							<xsl:variable name="speciality">
								<xsl:value-of select="speciality" />
							</xsl:variable>
									
							<xsl:variable name="hostUrl">
								<xsl:value-of select="host_url" />
							</xsl:variable>
							
							<xsl:variable name="locality_descr">
								<xsl:value-of select="locality_descr" />
							</xsl:variable>
									
							<xsl:variable name="state_descr">
								<xsl:value-of select="state_descr" />
							</xsl:variable>
									
							<xsl:variable name="class_code">
								<xsl:value-of select="class_code" />
							</xsl:variable>
									
							<xsl:variable name="rx_cnt">
								<xsl:value-of select="rx_cnt" />
							</xsl:variable>
									
							<div class="headerTableDCR headerTableDCR1">
									
								<table id="brandTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">
									
									<xsl:for-each select="//Detail2">
										<tr >
											<td rowspan="2">
												<xsl:variable name="doctorName"><xsl:value-of select="cust_name" /></xsl:variable>
												<xsl:variable name="strg_code"><xsl:value-of select="strg_code" /></xsl:variable>
												<IMG
														
														SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doctorName)}"
														onerror='this.src="../webitm/images/Summary/errUser.png"'
														class="iw-header-userImage"
														style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
											
													</IMG>
											</td>
											
											<td>
												<xsl:value-of select="cust_name" /> , <xsl:value-of select="speciality" />
											</td>
										
											<td>
												<span class="{class_code}">
													<xsl:value-of select="class_code" />
												</span>
												
												
											</td>
											<br></br>
											
										<tr > 
											
											<td >
												<img 
												src="{normalize-space($hostUrl)}/ibase/images/Standard/rx_location.png" width="18" height="18" style="width: 10px;padding: 0 2px;height: 10px;"/>
												<xsl:value-of select="locality_descr" /> , <xsl:value-of select="state_descr" />
											</td>
											
										</tr>
										
											
									</tr>		
										
								</xsl:for-each>
							</table>
						</div>
						
						<div class="headerTableDCR headerTableDCR1" border="1">
						<!--  <table id="brandTable" class="tTitleD" 
									cellspacing="1" cellpadding="1" width="100%" HEIGHT="100%"> -->
									
							<table id="brandTable" class="tTitleD" 
									cellspacing="1" cellpadding="1" width="100%" HEIGHT="30">
									
								<xsl:for-each select="//Detail2">
									<tr style="font-size:18px;">
										<TD>Total Rx</TD>
										<TD align="right"><xsl:value-of select="rx_cnt" /> Rx</TD>
									</tr>
									
								</xsl:for-each>
							</table>
						</div>
							
						<div id="overlay"></div>
						
				</div>
				
						<xsl:for-each select="//Detail2">
							<xsl:variable name="rx_cnt">
								<xsl:value-of select="rx_cnt"/>
							</xsl:variable>
												
							<xsl:if test="normalize-space($rx_cnt) > '0'">
												
								<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%; height:0%;">
									<div class="headerTableDCR headerTableDCR1">
									   <table id="brandTable" class="tTitleD" 
											cellspacing="1" cellpadding="1" width="100%" >
											
											<xsl:for-each select="//DATWISE_CNT2">
												<xsl:variable name="rx_added_Date"><xsl:value-of select="rx_added_Date"/></xsl:variable>
												<xsl:variable name="datewise_rx_cnt"><xsl:value-of select="datewise_rx_cnt"/></xsl:variable>
												
												<tr style="font-size:18px;">
													<TD align="left"><xsl:value-of select="rx_added_Date" /></TD>
															
													<TD align="right"><xsl:value-of select="datewise_rx_cnt" /> Rx</TD>
												</tr>
													
												<tr class="space">
			      									<td colspan="2"></td>
			   									</tr>
										 </xsl:for-each>					
											
									</table>
								 </div>	
							</div>
						</xsl:if>
					</xsl:for-each>
			  </form>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
