<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
				
	<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/default.css" />
</head>

<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>

<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }
    
           
]]>

</script>

<body bgcolor='#EEEEEE' onload="">

<style type="text/css">

.tableClass_1
{margin-left:0px;margin-top:0px;}

.header_td
{border:inset 0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px ;color:white}

.custtype_td
{border:inset 0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

.input_editable_text
{text-align:left;width:600px;}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt; }

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.input_num_field
{text-align:right;width:100px;}

 div.mainDiv
 {	
    width: 100%;
 }
 table.mainTable
 {	
    max-width: 100%;
 }
 
 div.content
 {	
    float: left;
    width:auto;
    
 }
 div.content1
 {	
    float: left;
    width:100%;
    
 }
 div.innerDiv
 {
    width: 100%;
 }
 div.dataDiv
 {
    width: 100%;
    max-height:225px;
    overflow-y:auto;
 }
 div.dataDiv1
 {
    width: 100%;
    height:100%;
    overflow-y:auto;
 }
 table.innerTable
 {
    width: 100%;
 }
td.dataCol
{
    width: 100px;
    border-bottom: 1px solid grey;
    border-left: 1px solid grey;
    border-right: 1px solid grey;
    height: 28px;
    
}
.outerTable
{border:1px solid grey;}

 div.outerDiv
 {	
   overflow:hidden;
    
 }



</style>
<form name = "Wizard_TravelDSR" >
	<div ID ="dsrDiv" class="outerDiv" >
	<div class="mainDiv">
	<table class="tableClass" width="100%" cellSpacing="1" cellPadding="1"  border="0" >
		<xsl:variable name="conf_or_delete"><xsl:value-of select="//HeaderData/confirm_or_delete"/></xsl:variable>
		<thead class="table-head">
		<tr>
			<td class="header_td" nowrap="true" valign="bottom" align="center">
				<xsl:variable name="unconf_cnt"><xsl:value-of select="//HeaderData/unconf_cnt"/></xsl:variable>
				<input type="hidden" name="unconf_cnt" id="unconf_cnt" value="{$unconf_cnt}" />
		 
				<xsl:choose>
					<xsl:when  test="$conf_or_delete ='C'">
					Confirm DSR 
					</xsl:when>     					 
					<xsl:otherwise>
					Delete DSR
					</xsl:otherwise>
				</xsl:choose>
			</td>
		<td class="header_td" nowrap="true" valign="bottom" align="center">
			<xsl:value-of select="//HeaderData/event_date"/>
		</td>
		</tr>
              </thead>
	</table>
	</div>
	<div id='dataDiv' class="">
	<table id="travelTable" class="tableClass"  border="0" cellspacing="1" cellpadding="1" width="100%"  >
		<xsl:variable name="cust_type"><xsl:value-of select="//DoctorData/cust_type"/></xsl:variable>
		<xsl:if test="$cust_type = 'D'">
		<thead class="table-head">
			<tr>
				<td class="custtype_td" colspan="2" align="center">
				      Doctor
				</td>	
			</tr>
		</thead>
		</xsl:if>
		<tbody class="table-body">
		<xsl:for-each select="//DoctorData">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
			<xsl:variable name="cust_type1"><xsl:value-of select="cust_type"/></xsl:variable>
			
			<xsl:if test="$cust_type1 = 'D'">
			
			<tr class="trClass">
				<td colspan="2" class="">
					<span style='text-transform:capitalize;'><xsl:value-of select="cust_name"/></span>
				</td>
			</tr>
			</xsl:if>
			

		</xsl:for-each>
		</tbody>
	</table>
     						
	<table id="travelTable" class="tableClass" border="0" cellspacing="1" cellpadding="1" width="100%">
		<xsl:variable name="cust_type"><xsl:value-of select="//ChemData/cust_type"/></xsl:variable>
		<xsl:if test="$cust_type = 'C'">
		<thead class="table-head">
			<tr>
				<td class="custtype_td" colspan="2" align="center">
				      Chemist
				</td>	
			</tr>
		</thead>
		</xsl:if>
		<tbody class="table-body">
		<xsl:for-each select="//ChemData">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
			<xsl:variable name="cust_type1"><xsl:value-of select="cust_type"/></xsl:variable>
			
			<xsl:if test="$cust_type1 = 'C'">
			
			<tr>
				<td colspan="2" class="">
					<span style='text-transform:capitalize;'><xsl:value-of select="cust_name"/></span>
				</td>
			</tr>
			</xsl:if>
			

		</xsl:for-each>
		</tbody>
	</table>
	<table id="travelTable" class="tableClass" border="0" cellspacing="1" cellpadding="1" width="100%">
		<xsl:variable name="cust_type"><xsl:value-of select="//StockData/cust_type"/></xsl:variable>
		<xsl:if test="$cust_type = 'S'">
		<thead class="table-head">
			<tr>
				<td class="custtype_td" colspan="2" align="center">
				      Stockist
				</td>	
			</tr>
		</thead>
		</xsl:if>
		<tbody class="table-body">
		<xsl:for-each select="//StockData">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
			<xsl:variable name="cust_type1"><xsl:value-of select="cust_type"/></xsl:variable>
			<xsl:variable name="no_of_outlet"><xsl:value-of select="no_of_outlet"/></xsl:variable>
			
			<xsl:if test="$cust_type1 = 'S'">
			
			<tr class="trClass">
				<td class="">
					<span style='text-transform:capitalize;'><xsl:value-of select="cust_name"/></span>
				</td>
				<td class="" align="right">
					<xsl:value-of select="no_of_outlet"/>
				</td>
			</tr>
			</xsl:if>
			

		</xsl:for-each>
		</tbody>
	</table>
	<table id="travelTable"  class="tableClass"  border="0" cellspacing="1" cellpadding="1" width="100%">
		<xsl:variable name="cust_type"><xsl:value-of select="//DoctorData/cust_type"/></xsl:variable>
		<xsl:if test="$cust_type = 'OTH'">
		<thead class="table-head">
			<tr>
				<td class="custtype_td" colspan="2" align="center">
				      <xsl:value-of select="//DoctorData/act_type"/>
				</td>	
			</tr>
		</thead>
		</xsl:if>
		<tbody class="table-body">
		<xsl:for-each select="//DoctorData">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
			<xsl:variable name="cust_type1"><xsl:value-of select="cust_type"/></xsl:variable>
			<xsl:variable name="no_of_outlet"><xsl:value-of select="no_of_outlet"/></xsl:variable>
			
			<xsl:if test="$cust_type1 = 'OTH'">
			
			<tr>
				<td class="" colspan="2">
					<xsl:value-of select="cust_name"/>
				</td>
			</tr>
			</xsl:if>
			

		</xsl:for-each>
		</tbody>
	</table>
	</div>
	     <div id="actionDiv" class=""  >
		<table cellSpacing="1" cellPadding="1" width="100%" border="0">
		<xsl:variable name="conf_or_delete"><xsl:value-of select="//HeaderData/confirm_or_delete"/></xsl:variable>
		    <tr>
			  <td>
				<!--<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="history.back();"/>-->
				
				<xsl:choose>
					<xsl:when  test="$conf_or_delete ='C'">
						<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('ConfirmDSRReport.jsp','confirm');"/>
						<input type="button" style="cursor:hand; float:right"  class="button green-Btn" value="Confirm" id="Confirm" name="Confirm" title='' onclick="javascript:confirmZuviusDSR('confirm','DSR')"/>
					</xsl:when>     					 
					<xsl:otherwise>
						<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('DeleteDSRReport.jsp','delete');"/>
						<input type="button" style="cursor:hand; float:right"  class="button green-Btn" value="Delete" id="Delete" name="Delete" title='' onclick="javascript:confirmZuviusDSR('delete','DSR')"/>
					</xsl:otherwise>
				</xsl:choose>
				
			</td>
		      </tr>
		</table>
	    </div>
	</div>
	<!-- Prescription Reporting -->
	<div  > 
	<table class="tableClass" width="100%" cellSpacing="1" cellPadding="1"  border="0" >
		<xsl:variable name="conf_or_delete"><xsl:value-of select="//HeaderData/confirm_or_delete"/></xsl:variable>
		<xsl:variable name="cust_type"><xsl:value-of select="//DoctorDataPR/cust_type"/></xsl:variable>
		<xsl:variable name="act_type"><xsl:value-of select="//DoctorDataPR/act_type"/></xsl:variable>
	      
	      <xsl:if test="$act_type = 'PR'">
	      <thead class="table-head">
	     <tr>
		 <td class="header_td" nowrap="true" valign="bottom" align="center">
		 
			<xsl:choose>
                        	<xsl:when  test="$conf_or_delete ='C'">
				Confirm PR
				</xsl:when>     					 
				<xsl:otherwise>
				Delete PR
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="header_td" nowrap="true" valign="bottom" align="center">
			<xsl:value-of select="//HeaderData/event_date"/>
		</td>
              </tr>
	      </thead>
              </xsl:if>
	</table>
	<div id='dataDiv' class="">
	<table id="travelTable" class="tableClass" border="0" cellspacing="1" cellpadding="1" width="100%"  >
		<xsl:variable name="cust_type"><xsl:value-of select="//DoctorDataPR/cust_type"/></xsl:variable>
		<xsl:variable name="act_type"><xsl:value-of select="//DoctorDataPR/act_type"/></xsl:variable>
		<xsl:if test="$act_type = 'PR'">
		<xsl:if test="$cust_type = 'D'">
		<thead class="table-head">
			<tr>
				<td class="custtype_td" colspan="2" align="center">
				      Doctor
				</td>	
			</tr>
		</thead>
		</xsl:if>
		</xsl:if>
		<tbody class="table-body">
		<xsl:for-each select="//DoctorDataPR">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
			<xsl:variable name="cust_type1"><xsl:value-of select="cust_type"/></xsl:variable>
			<xsl:variable name="act_type1"><xsl:value-of select="//DoctorDataPR/act_type"/></xsl:variable>
			<xsl:if test="$act_type1 = 'PR'">
			<xsl:if test="$cust_type1 = 'D'">
			
			<tr>
				<td colspan="2" class="">
					<span style='text-transform:capitalize;'><xsl:value-of select="cust_name"/></span>
				</td>
			</tr>
			</xsl:if>
			</xsl:if>
			

		</xsl:for-each>
		</tbody>
	</table>
	</div>
	<div id="actionDiv" class=""  >
		<table cellSpacing="1" cellPadding="1" width="100%" border="0">
		<xsl:variable name="act_type"><xsl:value-of select="//DoctorDataPR/act_type"/></xsl:variable>
		<xsl:variable name="conf_or_delete"><xsl:value-of select="//HeaderData/confirm_or_delete"/></xsl:variable>
		<xsl:if test="$act_type = 'PR'">
		    <tr>
			  <td>
				<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="history.back();"/>
				
				
				<xsl:choose>
					<xsl:when  test="$conf_or_delete ='C'">
						<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('ConfirmDSRReport.jsp','confirm');"/>
						<input type="button" style="cursor:hand; float:right"  class="button green-Btn" value="Confirm" id="Confirm" name="Confirm" title='' onclick="javascript:confirmZuviusDSR('confirm','PR')"/>
					</xsl:when>     					 
					<xsl:otherwise>
						<input type="button" style="cursor:hand" class="button green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('DeleteDSRReport.jsp','delete');"/>
						<input type="button" style="cursor:hand; float:right"  class="button green-Btn" value="Delete" id="Delete" name="Delete" title='' onclick="javascript:confirmZuviusDSR('delete','PR')"/>
					</xsl:otherwise>
				</xsl:choose>
				
			</td>
		      </tr>
		</xsl:if>
		</table>
	</div>

	</div>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
