<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<style type="text/css">
.pg-normal {
	color: #333;
	font-size: 15px;
	cursor: pointer;
	background: #e7e7e7; 
	padding: 2px 4px 2px 4px;
	border-radius : 2px;
	
}
.input-cell {
	width:60px !important;
	max-width:60px !important;
	min-width:60px !important;
	
}
.pg-number {
	color: #333;
	font-size: 12px;
	cursor: pointer;
	background: #e7e7e7; 
	padding: 2px 4px 2px 4px;
	margin-left: 2px;
	border-radius : 2px;
}

.pg-selected {
	color: #fff;
	font-size: 15px;
	background: #679fdd;
	padding: 2px 4px 2px 4px;
	border-radius : 2px;
}

table.mt {
	border-spacing: 0px !important;
    border-style: none !important;
    border-collapse: collapse !important;

}

table.mt td {
	border-spacing: 0px !important;
    border-style: none !important;
    border-collapse: collapse !important;
    box-shadow: inset 1px 0 0 0 #0000003b !important;
    padding: 0 !important;
	
}

table.mt .even {
	background-color: #EEE8AC;
}

table.mt .odd {
	background-color: #F9FAD0;
}

table.mt th {
	padding: 0px !important;
    max-height: 90px !IMPORTANT;
    height: 90px;
    border-style: none !important;
    width: 50px !IMPORTANT;
    display: table-cell;
    border-spacing: 0px;
    min-width: 50px !IMPORTANT;
    max-width: 50px !IMPORTANT;
    border-collapse: collapse;
    text-rendering: optimizeLegibility;
    box-shadow: inset 1px 0 0 0 #0000003b !important
    background-color: white !important;
    color: grey !important;
}

table.mt th a {
	text-decoration: none;
	text-align: center;
	padding-right: 20px;
	font-weight: bold;
	white-space: nowrap;
}

table.mt tfoot td {
	border-top: 1px solid #7f7f7f;
	background-color: #E1ECF9;
}

table.mt thead td {
	vertical-align: middle;
	background-color: #E1ECF9;
	border: none;
}

table.mt thead .tableHeader {
	font-size: larger;
	font-weight: bold;
}

table.mt thead .filter {
	text-align: right;
}

table.mt tfoot {
	background-color: #E1ECF9;
	text-align: center;
}

table.mt .tablesorterPager {
	padding: 10px 0 10px 0;
}

table.mt .tablesorterPager span {
	padding: 0 5px 0 5px;
}

table.mt .tablesorterPager input.prev {
	width: auto;
	margin-right: 10px;
}

table.mt .tablesorterPager input.next {
	width: auto;
	margin-left: 10px;
}

table.mt .pagedisplay {
	font-size: 10pt;
	width: 30px;
	border: 0px;
	background-color: #E1ECF9;
	text-align: center;
	vertical-align: top;
}


table.kt {
	font-family: arial;
	border-collapse: collapse;
	border: solid 3px #7f7f7f;
	font-size: small;
}

table.kt td {
	padding: 5px;
	border-right: solid 1px #7f7f7f;
}

table.kt .even {
	background-color: #EEE8AC;
}

table.kt .odd {
	background-color: #F9FAD0;
}

<!--table.mt th {
	border: 1px solid #7f7f7f;
	padding: 5px;
	height: auto;
	background: #D0B389;
}-->

table.kt th a {
	text-decoration: none;
	text-align: center;
	padding-right: 20px;
	font-weight: bold;
	white-space: nowrap;
}

table.kt tfoot td {
	border-top: 1px solid #7f7f7f;
	background-color: #E1ECF9;
}

table.kt thead td {
	vertical-align: middle;
	background-color: #E1ECF9;
	border: none;
}

table.kt thead .tableHeader {
	font-size: larger;
	font-weight: bold;
}

table.kt thead .filter {
	text-align: right;
}

table.kt tfoot {
	background-color: #E1ECF9;
	text-align: center;
}

table.kt .tablesorterPager {
	padding: 10px 0 10px 0;
}

table.kt .tablesorterPager span {
	padding: 0 5px 0 5px;
}

table.kt .tablesorterPager input.prev {
	width: auto;
	margin-right: 10px;
}

table.kt .tablesorterPager input.next {
	width: auto;
	margin-left: 10px;
}

table.kt .pagedisplay {
	font-size: 10pt;
	width: 30px;
	border: 0px;
	background-color: #E1ECF9;
	text-align: center;
	vertical-align: top;
}


</style>
<script type="text/javascript">
<![CDATA[

]]>

</script>
</head>
<script type="text/javascript" src="/ibase/webitm/js/jquery-2.1.1.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/EventTrackReportingWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<!--<script type="text/javascript" src="/ibase/webitm/js/sortable_table.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/BranddescrFixedTableHeader.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/Branddescr_plan_request.js"></script>-->

<body onLoad="loadHeader();setcolor();setTotalOnLoad();" style="margin: -13px 0 0 10px;" >
<style type="text/css">

.sticky {
	position : sticky !important;
	<!--width : 100px !important; -->
	<!--min-width : 100px !important; -->
	<!--max-width : 100px !important; -->
	
}

.stickyhead
{
	<!--width : 104px !important; -->
	position: sticky;
	z-index: 1;
	<!--min-width : 104px !important; -->
	<!--max-width : 104px !important; -->
	vertical-align:middle;
}

.borderalign
{   
	line-height: 15px !important;
	padding: 0px !important;
    border-top: 0px !important;
    border-bottom: 1px solid #ddd !important;
	}

th {
    background-color: white;
    color: white;
    text-align: center;
    vertical-align: top;
    height: 110px;
    padding-bottom: 3px;
    padding-left: 5px;
    padding-right: 5px;
    border-bottom: 1px solid #ccc;
}

.verticalText {
  
    height: 23px;
   line-height: 1;
   -webkit-transform: rotate(-90deg);
   font-size: 11px;
    
}

.verticalText {
    width: 90px !important;
    text-align: left;
    -webkit-transform: rotate(-90deg);
    -moz-transform: rotate(-90deg);
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: start;
    margin: 0 !IMPORTANT;
    white-space: nowrap;
}

.verticalTextFixed {
   
    line-height: 1;
    font-size: 11px;
    display: flex;
    justify-content: center;
    align-items: center ;
};  
   
}
.thClass
{
border:inset 0;
background:white;
font-family:verdana;
font-size: 13px;
color: black;
border-left: 2px solid #ddd !important;
border-top: 2px solid #ddd !important;
border-right: 2px solid #ddd !important;


}

.tHeader
{
	line-height: 15px;
	padding: 0 10px;
	color: #555;
	text-shadow: none;
	border-width: 1px 1px 1px 0;
	border-style: solid;
	background-color: white;
	-webkit-box-shadow: inset 0 1px rgba(255,255,255,0.2), inset 0 0 0 1px rgba(255,255,255,0.06), 0 1px rgba(0,0,0,0.04);
	box-shadow: inset 0 1px rgba(255,255,255,0.2), inset 0 0 0 1px rgba(255,255,255,0.06), 0 1px rgba(0,0,0,0.04);
	text-rendering: optimizeLegibility;
	border-left: 1px solid #ddd;
	border-top: 1px solid #ddd;
	border-bottom: 2px solid #ddd;
	border-right: 1px solid #ddd;
	border-top-left-radius: 0 !important;
	font-size: 14px;
	font-weight: bold;
}

.table-head>tr>th {
	padding: 0 10px;
	border-left: 2px solid #ddd;
	border-top: 2px solid #ddd;
	border-right: 2px solid #ddd;
	font-family: Arial, Helvetica, Helvetica Neue, Verdana, sans-serif;
	text-rendering: optimizeLegibility;
	font-size: 14px;
	font-weight: bold;
}

.trClassOdd td
{
	line-height: 35px;
	padding: 0 10px;
	border: 1px solid #ddd;
	font-size: 12px;
	text-shadow: none;
	background: #f5f5f5;
	text-rendering: optimizeLegibility;
}
.trClassOdd:hover {
	background-color: #f5f5f5;
}
.error
{
	border: solid 1px red;
	color : #333;
	background : white;
	text-align : left;
	font-size : 14px;
	line-height: 20px;
}

        table.mt {border-width: 1px;border-spacing:0px ;border-style: solid;border-color: #cfcfcf;border-collapse: collapse;line-height: 25px;background-color: #FFF;}
        table.mt th {border-width: 1px;padding: 1px;border-style: solid;border-color: #cfcfcf;white-space: normal;text-rendering: optimizeLegibility; box-shadow: inset 1px 0 0 0 rgba(0,0,0,.1);}
        
	
	.tdClass>td{
	padding: 0 10px;
	border-right: 1px solid #eee;
	border-right-color: rgba(0, 0, 0, 0.07);
	font-family: Arial, Helvetica, Helvetica Neue, Verdana, sans-serif;
	font-size: 12px;
	text-shadow: 0 1px white;
	text-shadow: 0 1px 1px rgba(0, 0, 0, .2);
	text-rendering: optimizeLegib
	box-shadow: inset 1px 0 0 0 rgba(0,0,0,.1);
	}
	.search{
	
	padding: 3px;
    border: none;
    width: 100%;
    box-shadow: inset 0 -1px 0 0 rgba(0,0,0,.1);
	}
	.tooltip {
  position: relative;
  display: inline-block;
}

.tooltip .tooltiptext {
visibility: hidden;
    webkit-transform: rotate(90deg);
    transform: rotate(90deg);
    width: auto;
    line-height: 1;
    height: auto;
    background-color: #666666;
    color: #fff;
    opacity: 1;
    text-align: center;
    border-radius: 6px;
    padding: 5px;
    position: absolute;
    z-index: 30;
    top: 24px;
    display: block;
    left: -125px;
    right: -101px;
    margin: -3px -13px 7px -1px;
     botton:100%;
}

.tooltip:hover .tooltiptext {
  visibility: visible;
}

.tooltip .tooltiptext::after {
 content: "";
 position: absolute;
 bottom: 100%;
 left: 55%;
 margin-left: -5px;
 border-width: 5px;
 border-style: solid;
 border-color: transparent transparent #666666 transparent;
}
	
</style>
<link href="/ibase/webitm/xsl/Standard/WIZARD/css/htmlWizard.css" rel="stylesheet" type="text/css"/>
<link href="/ibase/webitm/xsl/Standard/WIZARD/css/dataAdjust.css" rel="stylesheet" type="text/css"/>
<link id="userThemeLink" type="text/css" rel="stylesheet" href=""/>
<form name = "Wizard_Travel" id = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" style="background-color: #f7f8fa; overflow:hidden" onSubmit="javascript:return validateEvent(2);" onkeyup="avoidFromSubmit()" >

<table id="errorTravelTable"  width="100%"  style="margin: 15px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0">
	<xsl:for-each select="//error">
			<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
			<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
			<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
			<xsl:if test="position() = 1">

					<tr  style="background: rgba(255, 204, 0, 0.66);">	
						<td class="tdss_leftAlign"     style="background: rgba(255, 204, 0, 0.66); padding-right:5px; padding-left:5xp"  nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Description :
						</td>
						<td class="tdss_rightAlign"    style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
							<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorTravelTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
						</td>

					</tr>
			</xsl:if>
			<tr  style="background: rgba(255, 204, 0, 0.66);">
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					<xsl:value-of select="message"/>
				</td>
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
					<xsl:value-of select="description"/>
				</td>
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
				</td>

				
			</tr>
	</xsl:for-each>
	<xsl:for-each select="//error">
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:if test="position() = 1">
				<xsl:if test="$type = 'W'">
				<tr  style="background: rgba(255, 204, 0, 0.66);">
					<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
						Override Warnings :
					</td>
					<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
						<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
					</td>
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					</td>

				</tr>
				</xsl:if>
			</xsl:if>	
	</xsl:for-each>
	</table>
		
		<TABLE border="0" width="99%" class="headerTd" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;">
			<TR>	  
					<td class="header_main" nowrap="true" align="left" valign="middle"  >
					<div >
                                                <table class="headerTd" ><tr>
						<xsl:for-each select="//HEADERDATA">
							<xsl:if test="position() = 1">
							<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
							<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
							<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
							<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>		
							<td width = "220px" class="header_main" style="float:left;font-size: 14px;"><b>Division:</b> <xsl:value-of select="itmdescr"/></td><!-- <td style="width:5%"></td> -->
							<td width = "150px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b> Station:</b>  <xsl:value-of select="standescr"/> </td><!-- <td style="width:5%"></td> -->
							<td width = "250px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"><b>Name :</b>  <xsl:value-of select="sales_pers_name"/></td><!-- <td style="width:5%"></td> -->
							<td width = "140px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Period :</b>  <xsl:value-of select="prd_code"/></td><!-- <td style="width:15%"></td> -->
							</xsl:if>
						</xsl:for-each>
						</tr></table>
						</div>
					</td>
			</TR>
		</TABLE>
		 <div style="float: left;height: 22px;" >
		 
			      <input type="text" id="myInput" onkeyup="myFunction()" placeholder="Search" title="Type in a Doctor Name"  />
			      
			       <input type="text" id="myInput1" onkeyup="myFunction1()" placeholder="Search" title="Type in a SC Code" />
			     
			      
			      <input type="text" id="myInput2" onkeyup="myFunction2()" placeholder="Search" title="Type in a Locality"  />
			      
			      <input type="text" id="myInput3" onkeyup="myFunction3()" placeholder="Search" title="Type in a Speciality"  />
			      
			      <input type="text" id="myInput4" onkeyup="myFunction4()" placeholder="Search" title="Type in a Class Code"  />
			     
			      
		</div>
		
		<table id="eventTable" name="eventTable" class="mt" border="0" cellspacing="0" cellpadding="0" style= "width:auto !important;" >
			<thead class="table-head">
			<tr class="thClass" >
			      <!--<td class="tHeader"></td>-->
			     
			      
			      <th class="thClass stickyhead" style="left: 0;z-index: 1;width : 100px !important;min-width:100px !important;max-width:100px !important;" >
			      <div class="verticalTextFixed" >Doctor Name</div>
			      </th>
			      
			       
			      <th class="thClass stickyhead" style="left: 100px;z-index: 1;width : 76px !important;min-width:80px !important;max-width:80px !important;">
				   
			      <div class="verticalTextFixed">SC Code</div>
			     
			      </th>
			      
			     
			      <th class="thClass stickyhead" style="left: 180px;z-index: 1;width : 76px !important;min-width:80px !important;max-width:80px !important;">
			      <div class="verticalTextFixed">Locality</div>
			      </th>
			     
			      <th class="thClass stickyhead" style="left: 260px;z-index: 1;width : 96px !important;min-width:100px !important;max-width:100px !important;">
			      <div class="verticalTextFixed">Speciality</div>
			       
			      </th>
			       <th class="thClass stickyhead" style="left: 360px;z-index: 1;width : 46px !important;min-width:50px !important;max-width:50px !important;">
			      <div class="verticalTextFixed">Class Code</div>
			       
			      </th>
			     <th class="thClass stickyhead" style="left: 410px;z-ind
				 ex: 1;width : 46px !important;min-width:50px !important;max-width:50px !important;">
				 <div class="verticalTextFixed">RX Support</div>
				 </th> <!--as per requirement added by shraddha M [05-mar-2020] -->
			     
			      <th class="thClass stickyhead" style="left: 460px;z-index: 1;width : 46px !important;min-width:50px !important;max-width:50px !important;">
				  <div class="verticalTextFixed">Category</div>
				  </th>
			      <th class="thClass" style="vertical-align:middle;">
				  <div class="verticalTextFixed">Label</div></th>
				  <th class="thClass" style="vertical-align:middle;">
				  <div class="verticalTextFixed">Activity Count</div></th>
			    
			    <xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<!--<xsl:value-of select="$dbID"/>::-->
				<xsl:variable name="i" select="position()" />
					<xsl:for-each select="//EVENT_DESC2">
						<xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
						<xsl:variable name="parentDbID"><xsl:value-of select="@parentDomID"/></xsl:variable>
						<xsl:variable name="event_type"><xsl:value-of select="event_type"/></xsl:variable>
						<xsl:variable name="event_descr"><xsl:value-of select="event_descr"/></xsl:variable>
						<xsl:variable name="event"><xsl:value-of select="event"/></xsl:variable>
						<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
						

						    <xsl:if test=" $parentDbID = 1 and $dbID = 1 ">
						   <!-- <xsl:value-of select="event_type"/>:::	-->	      
							<th class="thClass input-cell">
								 <!--<xsl:value-of select="$parentDbID"/>:<xsl:value-of select="$dbID"/>--><div class="verticalText tooltip"> <xsl:value-of select="event_descr"/>  <span class="tooltiptext"><xsl:value-of select="event"/></span> </div>
								<input  type="hidden"  name="EVENT_DESC3.{normalize-space($line_no)}.event_type" id="EVENT_DESC3.{normalize-space($line_no)}.event_type" style="width : 100%" value="{$event_type}"  ISCHANGED="false"/>
								<input  type="hidden"  name="EVENT_DESC3.{normalize-space($line_no)}.event_descr" id="EVENT_DESC3.{normalize-space($line_no)}.event_descr" style="width : 100%" value="{$event_descr}"  ISCHANGED="false"/>
							</th>
						    </xsl:if>

					</xsl:for-each>
							<!--<xsl:choose>
							  <xsl:when test="$editFlag ='E'">
									<xsl:if test=" $parentDbID = '1' ">
									    	
									      <td width="20%" class="tHeader" nowrap="true" valign="bottom">
										      <strong><xsl:value-of select="parentDbID"/><xsl:value-of select="event_type"/></strong>
									      </td>
									</xsl:if>
				  
							  </xsl:when>
							  <xsl:otherwise>
									      <td width="20%" class="tHeader" nowrap="true" valign="bottom">
										      <strong><xsl:value-of select="event_type"/></strong>
									      </td>
								  
							  </xsl:otherwise>
						</xsl:choose>-->
				</xsl:for-each>
				<!-- <th class="thClass"><div class="verticalText"> Total</div></th> -->
				
			</tr>
			</thead>
			<tbody class='table-body fadeInDown'>
			<xsl:for-each select="//Detail2">
			    <xsl:variable name="brand_nos"><xsl:value-of select="brand_nos"/></xsl:variable>
		
			    <xsl:variable name="sales_pers"><xsl:value-of select="sales_pers"/></xsl:variable>
			    <xsl:variable name="stan_code__from"><xsl:value-of select="stan_code__from"/></xsl:variable>
			    <xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
			    <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
			    <xsl:variable name="eventdata"><xsl:value-of select="eventdata"/></xsl:variable>
			    <xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			    <xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
			    <xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			    <xsl:variable name="sc_code"><xsl:value-of select="sc_code"/></xsl:variable>
			    <xsl:variable name="doctor_name"><xsl:value-of select="doctor_name"/></xsl:variable>
			    <xsl:variable name="so_visit"><xsl:value-of select="so_visit"/></xsl:variable>
			    <xsl:variable name="flm_visit"><xsl:value-of select="flm_visit"/></xsl:variable>
			    <xsl:variable name="locality"><xsl:value-of select="locality"/></xsl:variable>
			    <xsl:variable name="speciality"><xsl:value-of select="speciality"/></xsl:variable>
			    <xsl:variable name="class_code"><xsl:value-of select="class_code"/></xsl:variable>
			    <xsl:variable name="category"><xsl:value-of select="category"/></xsl:variable>
			    <xsl:variable name="bussiness_to_us"><xsl:value-of select="bussiness_to_us"/></xsl:variable> <!-- as per requirement added by shraddha M 05-mar-2020 -->
			    
			    <xsl:variable name="curr_horz_total"><xsl:value-of select="curr_horz_total"/></xsl:variable>
				<xsl:variable name="base_value_horz_tot"><xsl:value-of select="base_value_horz_tot"/></xsl:variable>
				<xsl:variable name="event_base_loc_val"><xsl:value-of select="event_base_loc_val"/></xsl:variable>
				<xsl:variable name="event_actualLY_loc_val"><xsl:value-of select="event_actualLY_loc_val"/></xsl:variable>
				<xsl:variable name="actualLY_horz_total"><xsl:value-of select="actualLY_horz_total"/></xsl:variable>
				<xsl:variable name="actualLY_vert_total"><xsl:value-of select="actualLY_vert_total"/></xsl:variable>
				<xsl:variable name="event_plancy_endb_val"><xsl:value-of select="event_plancy_endb_val"/></xsl:variable>
				<xsl:variable name="event_actually_endb_val"><xsl:value-of select="event_actually_endb_val"/></xsl:variable>
				<xsl:variable name="event_actualCY_loc_val"><xsl:value-of select="event_actualCY_loc_val"/></xsl:variable>
				

			    <xsl:choose>
			    <xsl:when test="$editFlag ='E'">
			    <tr class="tdClass" style="text-align:center">
				<!--<td>
				<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  />
				</td>-->
				
	
				<td align="left"  style="width : 100px !important;min-width:100px !important;max-width:100px !important;left:0px;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky borderalign" data-input="name">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.doctor_name" id="Detail2.{normalize-space($dbID)}.doctor_name" style="width : 100%" value="{$doctor_name}"  ISCHANGED="false"/>
					<xsl:value-of select="doctor_name"/><br />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.so_visit" id="Detail2.{normalize-space($dbID)}.so_visit" style="width : 100%" value="{$so_visit}"  ISCHANGED="false"/>
					SO Visit : <xsl:value-of select="so_visit"/><br />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.flm_visit" id="Detail2.{normalize-space($dbID)}.flm_visit" style="width : 100%" value="{$flm_visit}"  ISCHANGED="false"/>
					FLM Visit : <xsl:value-of select="flm_visit"/>
				</td>
				
				<td align="left"  style="width : 80px !important;min-width:80px !important;max-width:80px !important;left:100px;line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky" data-input="name">
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  />
<!-- 					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  /> -->
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.sc_code" id="Detail2.{normalize-space($dbID)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					<xsl:value-of select="sc_code"/>
				</td>

				<td align="left"  style="width : 80px !important;min-width:80px !important;max-width:80px !important;left:180px;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.locality" id="Detail2.{normalize-space($dbID)}.locality" style="width : 100%" value="{$locality}"  ISCHANGED="false"/>
					<xsl:value-of select="locality"/>
				</td>

				<td align="left" style="width : 100px !important;min-width:100px !important;max-width:100px !important;left:260px;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.speciality" id="Detail2.{normalize-space($dbID)}.speciality" style="width : 100%" value="{$speciality}"  ISCHANGED="false"/>
					<xsl:value-of select="speciality"/>
				</td>
				
				<td align="left" style="width : 50px !important;min-width:50px !important;max-width:50px !important;left:360px;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.class_code" id="Detail2.{normalize-space($dbID)}.class_code" style="width : 100%" value="{$class_code}"  ISCHANGED="false"/>
					<xsl:value-of select="class_code"/>
				</td>
				
				<!--as per requirement Added by shraddha M 05-mar-2020 :: start -->
				<td align="right" style="width : 50px !important;min-width:50px !important;max-width:50px !important;left:410px;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd;;border-bottom: 1px solid #ddd;padding:5px; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.bussiness_to_us" id="Detail2.{normalize-space($dbID)}.bussiness_to_us" style="width : 100%" value="{$bussiness_to_us}"  ISCHANGED="false"/>
					<xsl:value-of select="bussiness_to_us"/>
				</td>
				<!--as per requirement Added by shraddha M 05-mar-2020 :: end -->
								
				<td align="left" style="width : 50px !important;min-width:50px !important;max-width:50px !important;left:460px;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" style="width : 100%" value="{$category}"  ISCHANGED="false"/>
					<xsl:value-of select="category"/>
				</td>
				
				<!-- <td align="left" style="border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd;" class="td_leftAlign"> -->
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign">
					<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" class="input_editable" style="text-align: right;width:100%" size="5px"   ISCHANGED="false"/> -->
				 <xsl:if test=" $event_actualLY_loc_val= 'N' ">
						<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;
						">Actual LY</p>
						</xsl:if>
					 <xsl:if test=" $event_base_loc_val= 'N' ">
						<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" class="input_editable" readonly="readonly" maxlength="6" value="" style="text-align: right;width:100%;background-color:#f5f5f5" /> -->
						<!-- <input  type="hidden"  name="" id="" class="input_editable" value ="{$base_value_horz_tot}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5"/> -->
						<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Plan CY</p>
					</xsl:if> 
				<!-- 	<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}"   style="text-align: right;width:100%" /> -->
					<!-- <input  type="hidden"  name="" id="" class="input_editable"  value="{$curr_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;" /> -->
					<xsl:if test=" $event_actualCY_loc_val= 'N' ">
					<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Actual CY</p>
					</xsl:if>
				</td>
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" class="input_editable" style="text-align: right;width:100%" size="5px"   ISCHANGED="false"/> -->
					
					 <xsl:if test=" $event_actualLY_loc_val= 'N' ">
					 <xsl:if test=" $event_actually_endb_val= 'N' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.actualLY_horz_total" id="Detail2.{normalize-space($dbID)}.actualLY_horz_total" class="input_editable"  value="{$actualLY_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" />
      				</xsl:if>
       				<xsl:if test=" $event_actually_endb_val= 'Y' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.actualLY_horz_total" id="Detail2.{normalize-space($dbID)}.actualLY_horz_total" class="input_editable"  value="{$actualLY_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" />
       				</xsl:if>
					
					</xsl:if>
					 <xsl:if test=" $event_base_loc_val= 'N' ">
					 <xsl:if test=" $event_plancy_endb_val= 'N' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot"  value="{$base_value_horz_tot}" class="input_editable" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;"/>
      				</xsl:if>
       				<xsl:if test=" $event_plancy_endb_val= 'Y' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot"  value="{$base_value_horz_tot}" class="input_editable" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;"/>
       				</xsl:if>
						<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" class="input_editable" readonly="readonly" maxlength="6" value="" style="text-align: right;width:100%;background-color:#f5f5f5" /> -->
						
					</xsl:if>
					<xsl:if test=" $event_actualCY_loc_val= 'N' ">  
				<!-- 	<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}"   style="text-align: right;width:100%" /> -->
					<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable"  value="{$curr_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" /> 
					</xsl:if>
				</td>
				
				  <xsl:for-each select="//EVENT_DESC2">
				  
				      <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
				      <xsl:variable name="event_type"><xsl:value-of select="event_type"/></xsl:variable>
				      <xsl:variable name="event_descr"><xsl:value-of select="event_descr"/></xsl:variable>
				      <xsl:variable name="target_nos"><xsl:value-of select="target_nos"/></xsl:variable>
				      <xsl:variable name="dbID1"><xsl:value-of select="@domID1"/></xsl:variable>
				      <xsl:variable name="sc_code1"><xsl:value-of select="sc_code"/></xsl:variable>
				      <xsl:variable name="pitch_priority"><xsl:value-of select="pitch_priority"/></xsl:variable>
				      
				      <xsl:variable name="plan_cy"><xsl:value-of select="plan_cy"/></xsl:variable>
				      <xsl:variable name="actual_ly"><xsl:value-of select="actual_ly"/></xsl:variable>
				       <xsl:variable name="actualLY_vert_total"><xsl:value-of select="actualLY_vert_total"/></xsl:variable>
				       <xsl:variable name="tabindexid"><xsl:value-of select="actual_ly/@tabindex"/></xsl:variable>
				       <xsl:variable name="tabindexidplan"><xsl:value-of select="plan_cy/@tabindex"/></xsl:variable>
				       <xsl:variable name="tabindexidcurrent"><xsl:value-of select="target_nos/@tabindex"/></xsl:variable>
				      <!-- changes by shraddha to open actual ly & plan cy for current month only [20-dec-19 start] --> 
				       <xsl:variable name="actual_ly_endb_val"><xsl:value-of select="actual_ly_endb_val"/></xsl:variable>
				      <xsl:variable name="plan_cy_endb_val"><xsl:value-of select="plan_cy_endb_val"/></xsl:variable>
				      <!--  changes by shraddha to open actual ly & plan cy for current month only [20-dec-19 end] --> 
				      <xsl:if test=" $sc_code = $sc_code1 ">
				      <td class="td_leftAlign width:50px !important;min-width:50px;" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;">
				      
		    <!-- 		    <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.event_type" id="Detail2.{normalize-space($dbID)}.event_type" style="width : 100%" value="{$event_type}"  ISCHANGED="false"/> -->
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_type" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_type" style="width : 100%" value="{$event_type}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_descr" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_descr" style="width : 100%" value="{$event_descr}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" style="width : 100%" value="{$pitch_priority}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_plancy_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_plancy_endb_val" style="width : 100%" value="{$event_plancy_endb_val}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_actually_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_actually_endb_val" style="width : 100%" value="{$event_actually_endb_val}"  ISCHANGED="false"/>
					     
					     <!-- added by shraddha M for actual ly and plan cy open for current month only [19-dec-19:start]-->  
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly_endb_val" style="width : 100%" value="{$actual_ly_endb_val}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy_endb_val" style="width : 100%" value="{$plan_cy_endb_val}"  ISCHANGED="false"/>
					    <!-- added by shraddha M for actual ly and plan cy open for current month only [19-dec-19:end]-->
					    
<!-- 					    <input  type="hidden"  name="eventdata" id="eventdata" style="width : 100%" value=""  ISCHANGED="false"/> -->
					   <!--  <input  type="number"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;"/> -->
					   
					   <xsl:if test=" $event_actualLY_loc_val= 'N' ">
					   		<xsl:if test=" $event_actually_endb_val= 'N' ">
				       			 <xsl:if test=" $actual_ly_endb_val= 'Y'  ">
				                    <input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexid}" />
				                 </xsl:if>
				                 <xsl:if test=" $actual_ly_endb_val  = 'N'  ">
				                    <input  type="number"  min="0"  readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
				                 </xsl:if>
				       	  </xsl:if>
				        	<xsl:if test=" $event_actually_endb_val= 'Y' ">
				        		<input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexid}" />
				       	   </xsl:if>
				       	   <xsl:if test=" $actual_ly_endb_val= ''  ">
				                    <input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexid}" />
				           </xsl:if>
				       </xsl:if>
				        
				        <xsl:if test=" $event_actualLY_loc_val= 'Y' ">
					   	
				        <input  type="hidden"    readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
				       
				        </xsl:if>
				        
					   <xsl:if test=" $event_base_loc_val= 'N' ">
					      <xsl:if test=" $event_plancy_endb_val= 'N' ">
					    	 <xsl:if test=" $plan_cy_endb_val= 'Y' ">
					         	<input  type="number"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)" onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidplan}"  />					    	
					        </xsl:if>
					        <xsl:if test=" $plan_cy_endb_val= 'N' ">
					           <input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   readonly="readonly" class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)"  onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
					        </xsl:if>
					     </xsl:if>
					     <xsl:if test=" $event_plancy_endb_val= 'Y' ">
					    	  <input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidplan}"/>
					    </xsl:if>
					     <xsl:if test=" $plan_cy_endb_val= '' ">
					         	<input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)" onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidplan}"  />					    	
					     </xsl:if>		
					 </xsl:if>
					    
					    <xsl:if test=" $event_base_loc_val= 'Y' ">
					  
					    	<input  type="hidden"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   readonly="readonly" class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')" onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px; margin:3px;"/>
					    		
					    </xsl:if>
					     <!--  changes by Hariom S to Actual CY column non-editable for SAS and PMS [04-Nov-20 Start] -->  	
					    <!-- <input  type="number"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;height: 10%;font-size: 12px;" tabindex="{$dbID}{$tabindexidcurrent}"/>
					     -->
					  <xsl:if test=" $event_actualCY_loc_val= 'N' ">     
			 				<xsl:choose>	
					     	 <xsl:when test="$event_type ='PMS  ' or $event_type ='SAS  '">				    
					  	       	  <input  type="number" min="0"  readonly="readonly"   name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidcurrent}"/>				  
					    	 </xsl:when>
					     <xsl:otherwise>
					  	         <input  type="number"  min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidcurrent}"/>			    
					   	 </xsl:otherwise>
			 			</xsl:choose>	
					      </xsl:if>
					      <xsl:if test=" $event_actualCY_loc_val= 'Y' ">
					   	
				        <input  type="hidden"    readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px; margin:3px;"/>
				       
				        </xsl:if>
					   <!--  changes by Hariom S to Actual CY column non-editable for SAS and PMS [04-Nov-20 End] -->  	   
					     
				      </td>
 				     </xsl:if> 
				  </xsl:for-each>
				
				   <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.eventdata" id="Detail2.{normalize-space($dbID)}.eventdata" style="width : 100%;" value=""  ISCHANGED="false"/>

			    </tr>
			    </xsl:when>	
			    <xsl:otherwise>
			    
			     <tr class="tdClass">
				<!--<td>
				<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;" />
				</td>-->
				
	
				<td align="left"  style="z-index:1;left:0px;width : 100px !important;min-width:100px !important;max-width:100px !important;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky borderalign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.doctor_name" id="Detail2.{normalize-space($dbID)}.doctor_name" style="width : 100%" value="{$doctor_name}"  ISCHANGED="false"/>
					<xsl:value-of select="doctor_name"/><br />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.so_visit" id="Detail2.{normalize-space($dbID)}.so_visit" style="width : 100%" value="{$so_visit}"  ISCHANGED="false"/>
					SO Visit : <xsl:value-of select="so_visit"/><br />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.flm_visit" id="Detail2.{normalize-space($dbID)}.flm_visit" style="width : 100%" value="{$flm_visit}"  ISCHANGED="false"/>
					FLM Visit : <xsl:value-of select="flm_visit"/>
				</td>
				
				<td   align="left"  style="z-index:1;left:100px;width : 80px !important;min-width:80px !important;max-width:80px !important;line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;" />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.sc_code" id="Detail2.{normalize-space($dbID)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					<xsl:value-of select="sc_code"/>
				</td>

				<td align="left"  style="z-index:1;left:180px;width : 80px !important;min-width:80px !important;max-width:80px !important;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.locality" id="Detail2.{normalize-space($dbID)}.locality" style="width : 100%" value="{$locality}"  ISCHANGED="false"/>
					<xsl:value-of select="locality"/>
				</td>

				<td align="left"  style="z-index:1;left:260px;width : 100px !important;min-width:100px !important;max-width:100px !important;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.speciality" id="Detail2.{normalize-space($dbID)}.speciality" style="width : 100%" value="{$speciality}"  ISCHANGED="false"/>
					<xsl:value-of select="speciality"/>
				</td>
				
				<td align="left"  style="z-index:1;left:360px;width : 50px !important;min-width:50px !important;max-width:50px !important;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.class_code" id="Detail2.{normalize-space($dbID)}.class_code" style="width : 100%" value="{$class_code}"  ISCHANGED="false"/>
					<xsl:value-of select="class_code"/>
				</td>

                 <!--as per requirement Added by shraddha M 05-mar-2020 ::start -->
				<td   align="left"  style="z-index:1;left:410px;width : 50px !important;min-width:50px !important;max-width:50px !important;line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd;padding:5px; text-align:center;" class="sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.bussiness_to_us" id="Detail2.{normalize-space($dbID)}.bussiness_to_us" style="width : 100%;text-align: right;" value="{$bussiness_to_us}"  ISCHANGED="false"/>
					<xsl:value-of select="bussiness_to_us"/>
				</td>
				<!--as per requirement Added by shraddha M 05-mar-2020 ::end -->
				
				<td align="left"  style="z-index:1;left:460px;width : 50px !important;min-width:50px !important;max-width:50px !important;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign sticky">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" style="width : 100%" value="{$category}"  ISCHANGED="false"/>
					<xsl:value-of select="category"/>
				</td>
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd; text-align:center;" class="td_leftAlign">
				
				 <xsl:if test=" $event_actualLY_loc_val= 'N' ">
					<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Actual LY</p>
					</xsl:if> 
					 <xsl:if test=" $event_base_loc_val= 'N' ">
						<!-- <input  type="hidden"  name="" id="" readonly="readonly" class="input_editable" maxlength="6" value="Base" style="text-align: right;width:100%;background-color:#f5f5f5" ISCHANGED="false" size="5px"  /> -->
					<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Plan CY</p>	
					</xsl:if> 
					<!-- <input  type="hidden"  name="" id="" class="input_editabe" maxlength="6" value="Current" readonly="readonly" style="text-align: right;width:100%" ISCHANGED="false" size="5px"  /> -->
					 <xsl:if test=" $event_actualCY_loc_val= 'N' ">
					<p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Actual CY</p>
					 </xsl:if> 
					
					
				</td> 
				
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
				
				
				 <xsl:if test=" $event_actualLY_loc_val= 'N' ">
					 <xsl:if test=" $event_actually_endb_val= 'N' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.actualLY_horz_total" id="Detail2.{normalize-space($dbID)}.actualLY_horz_total" class="input_editable"  value="{$actualLY_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" />
      				</xsl:if>
       				<xsl:if test=" $event_actually_endb_val= 'Y' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.actualLY_horz_total" id="Detail2.{normalize-space($dbID)}.actualLY_horz_total" class="input_editable"  value="{$actualLY_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" />
       				</xsl:if>
					
					</xsl:if>
					 <xsl:if test=" $event_base_loc_val= 'N' ">
					 <xsl:if test=" $event_plancy_endb_val= 'N' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" readonly="readonly" class="input_editable" maxlength="6" value="{$base_value_horz_tot}" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" ISCHANGED="false" size="5px"  />
      				</xsl:if>
       				<xsl:if test=" $event_plancy_endb_val= 'Y' ">
       					<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" readonly="readonly" class="input_editable" maxlength="6" value="{$base_value_horz_tot}" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" ISCHANGED="false" size="5px"  />
       				</xsl:if>
						
					</xsl:if> 
					
					 <xsl:if test=" $event_actualCY_loc_val= 'N' "> 
					<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}" readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" ISCHANGED="false" size="5px"  />
					</xsl:if> 
					 
				</td> 
				  <xsl:for-each select="//EVENT_DESC2">
				  
				      <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
				      <xsl:variable name="event_type"><xsl:value-of select="event_type"/></xsl:variable>
				      <xsl:variable name="event_descr"><xsl:value-of select="event_descr"/></xsl:variable>
				      <xsl:variable name="target_nos"><xsl:value-of select="target_nos"/></xsl:variable>
				      <xsl:variable name="dbID1"><xsl:value-of select="@domID1"/></xsl:variable>
				      <xsl:variable name="sc_code1"><xsl:value-of select="sc_code"/></xsl:variable>
				      <xsl:variable name="pitch_priority"><xsl:value-of select="pitch_priority"/></xsl:variable>
				      <xsl:variable name="actual_ly"><xsl:value-of select="actual_ly"/></xsl:variable>
				      <xsl:variable name="actualLY_vert_total"><xsl:value-of select="actualLY_vert_total"/></xsl:variable>
				      <xsl:variable name="tabindexid"><xsl:value-of select="actual_ly/@tabindex"/></xsl:variable>
				      <xsl:variable name="tabindexidplan"><xsl:value-of select="plan_cy/@tabindex"/></xsl:variable>
				      <xsl:variable name="tabindexidcurrent"><xsl:value-of select="target_nos/@tabindex"/></xsl:variable>
				      <!-- added by shraddha M to open actual ly & plan cy for current month only [20-dec-19] start -->
				      <xsl:variable name="actual_ly_endb_val"><xsl:value-of select="actual_ly_endb_val"/></xsl:variable>
				      <xsl:variable name="plan_cy_endb_val"><xsl:value-of select="plan_cy_endb_val"/></xsl:variable>
				      <!-- added by shraddha M to open actual ly & plan cy for current month only [20-dec-19] end -->
				    <xsl:variable name="plan_cy"><xsl:value-of select="plan_cy"/></xsl:variable>
				    <xsl:if test=" $sc_code = $sc_code1 ">
				      <td class="td_leftAlign" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;">
				      
		    <!-- 		    <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.event_type" id="Detail2.{normalize-space($dbID)}.event_type" style="width : 100%" value="{$event_type}"  ISCHANGED="false"/> -->
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_type" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_type" style="width : 100%" value="{$event_type}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_descr" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_descr" style="width : 100%" value="{$event_descr}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" style="width : 100%" value="{$pitch_priority}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_plancy_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_plancy_endb_val" style="width : 100%" value="{$event_plancy_endb_val}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_actually_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.event_actually_endb_val" style="width : 100%" value="{$event_actually_endb_val}"  ISCHANGED="false"/>
					     <!-- added by shraddha M for actual ly and plan cy open for current month only [19-dec-19:start]--> 
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly_endb_val" style="width : 100%" value="{$actual_ly_endb_val}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy_endb_val" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy_endb_val" style="width : 100%" value="{$plan_cy_endb_val}"  ISCHANGED="false"/>
					      <!-- added by shraddha M for actual ly and plan cy open for current month only [19-dec-19:end]--> 
					     
					     
<!-- 					    <input  type="hidden"  name="eventdata" id="eventdata" style="width : 100%" value=""  ISCHANGED="false"/> -->
					   <!--  <input  type="number"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}" onkeyup="this.value=this.value.replace(/[^\d]/,'')" maxlength="6"  style="text-align: right;width:100%" size="5px"  ISCHANGED="false"/>
				      </td> -->
				      <!-- changes by shraddha to open actual ly & plan cy for current month only [20-dec-19 start] -->
				         <xsl:if test=" $event_actualLY_loc_val= 'N' ">
					     	 <xsl:if test=" $event_actually_endb_val= 'N' ">
				        		 <xsl:if test=" $actual_ly_endb_val= 'Y'  ">
				        				<input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexid}" />
				       			 </xsl:if>
				        	    <xsl:if test=" $actual_ly_endb_val  = 'N'  ">
				                       <input  type="number"  min="0"  readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
				                </xsl:if>
				            </xsl:if>
				        
				          <xsl:if test=" $event_actually_endb_val= 'Y' ">
				               <input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexid}" />
				         </xsl:if>
				      </xsl:if>
				  <!-- changes by shraddha to open actual ly & plan cy for current month only [20-dec-19]end -->    
				        <xsl:if test=" $event_actualLY_loc_val= 'Y' ">
					   
				        <input  type="hidden"    readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actual_ly"  value="{$actual_ly}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
				        
				        </xsl:if>
				    <!-- changes by shraddha to open actual ly & plan cy for current month only [20-dec-19 start]-->      
					   <xsl:if test=" $event_base_loc_val= 'N' ">
					       <xsl:if test=" $event_plancy_endb_val= 'N' ">
					    	    <xsl:if test=" $plan_cy_endb_val= 'Y' ">
						             <input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)" onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" tabindex="{$dbID}{$tabindexidplan}"  />					    	
					            </xsl:if>
					            <xsl:if test=" $plan_cy_endb_val= 'N' ">
					                 <input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   readonly="readonly" class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)"  onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px;"/>
					            </xsl:if>
					      </xsl:if>
					    <xsl:if test=" $event_plancy_endb_val= 'Y' ">
					    	<input  type="number"  min="0"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')" onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px" tabindex="{$dbID}{$tabindexidplan}"  />
					    </xsl:if>		
					    </xsl:if>
				  <!-- changes by shraddha to open actual ly & plan cy for current month only [20-dec-19 end] -->  
					    <xsl:if test=" $event_base_loc_val= 'Y' ">
					   
					    	<input  type="hidden"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.plan_cy" value="{$plan_cy}"   readonly="readonly" class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  onblur="calculatePlanTotal(this)" ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px"/>
					   	
					    </xsl:if>
					    
					     <!-- changes by Hariom to Actual CY column non-editable for SAS and PMS [04-Nov-20 Start] -->  			
					    <!-- <input  type="number"    name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')" maxlength="6"  style="text-align: right;width:100%;height: 10%;font-size: 12px;" size="5px"  ISCHANGED="false" tabindex="{$dbID}{$tabindexidcurrent}" />
					     -->
					      <xsl:if test=" $event_actualCY_loc_val= 'N' ">
					    <xsl:choose>	
					      <xsl:when test="$event_type ='PMS' or $event_type ='SAS'">				    
					    <input  type="number" min="0"  readonly="readonly"   name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')" maxlength="6"  style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" size="5px"  ISCHANGED="false" tabindex="{$dbID}{$tabindexidcurrent}" />
					   </xsl:when>
					    <xsl:otherwise>
					    <input  type="number" min="0" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}" onblur="calculateTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')" maxlength="6"  style="text-align: right;width:90%;height: 6%;font-size: 12px;margin:3px;" size="5px"  ISCHANGED="false" tabindex="{$dbID}{$tabindexidcurrent}" />
				    
					   </xsl:otherwise>
					       </xsl:choose>
					       </xsl:if>	
					        <xsl:if test=" $event_actualCY_loc_val= 'Y' ">					   
				        <input  type="hidden"    readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onblur="calculateActualTotal(this)" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:90%;background-color:#f5f5f5;height: 6%;font-size: 12px;margin:3px"/>				        
				        </xsl:if>
					   <!--  changes by Hariom to Actual CY column non-editable for SAS and PMS [04-Nov-20 End] -->  					    
				      </td>
 				      </xsl:if>
 				     
				  </xsl:for-each>
				
				   <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.eventdata" id="Detail2.{normalize-space($dbID)}.eventdata" style="width : 100%;" value=""  ISCHANGED="false"/>

			    </tr>
			    </xsl:otherwise>
			    </xsl:choose>
						
			</xsl:for-each>
			</tbody>
			      <input  type="hidden"  name="Detail2.1.is_confirm" id="Detail2.1.is_confirm" style="width : 100%" value=""  ISCHANGED="false"/>
		</table>
	<div id="footer" style="width:98.2%;position: relative;" onscroll="scrollDataDiv( this )">
		 <table id ="verTotalTable" class="kt" style="border-left:1px solid #ccc;border-right:1px solid #ccc;border-bottom:1px solid #ccc; " border="0" >
			<tfoot>
				<tr >
					<!-- <td style="width:20.3%;background:#fff;text-align: center;border-right:1px solid #ccc;color:black;">Total</td> -->
					<td  align="left"  style="line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd; background:#fff; font-weight: bold; text-color:black" class="td_leftAlign" colspan="7"> 
						<div id="totfoot" align="center" style="color:#000;text-align: right;font-size: 11px;" >Doctor Count 
						</div> 
					</td>  
					<xsl:for-each select="//Detail2">
						<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
						<xsl:variable name="event_base_loc_val"><xsl:value-of select="event_base_loc_val"/></xsl:variable>
						<xsl:variable name="event_actualLY_loc_val"><xsl:value-of select="event_actualLY_loc_val"/></xsl:variable>
						<xsl:variable name="event_actualCY_loc_val"><xsl:value-of select="event_actualCY_loc_val"/></xsl:variable>
						<xsl:variable name="event_actually_endb_val"><xsl:value-of select="event_actually_endb_val"/></xsl:variable>
						<xsl:variable name="event_plancy_endb_val"><xsl:value-of select="event_plancy_endb_val"/></xsl:variable>
						 <xsl:if test="position() = 1">
								<td align="left" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;background:#fff; " class="td_leftAlign">
								
									<xsl:if test=" $event_actualLY_loc_val= 'N' ">
							 			<input  type="hidden" readonly="readonly" name="actualLY_vert_total" id="actualLY_vert_total" class="input_editable" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5;height: 20%;font-size: 12px;" size="5px"  />
							 			
									</xsl:if>
								
									 <xsl:if test=" $event_base_loc_val= 'N' ">
							 			<input  type="hidden"  name="base_value_tot_ver" id="base_value_tot_ver" class="input_editable"  readonly="readonly" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5;height: 20%;font-size: 12px;" size="5px"  />
									</xsl:if> 	
									<input  type="hidden"  name="curr_vert_total" id="curr_vert_total" class="input_editable" maxlength="6" readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5;height: 20%;font-size: 12px;" size="5px"  />
									<!-- Added to display Doctor count field label  [shraddha::20-dec :: start] -->
									<xsl:if test=" $event_actualLY_loc_val= 'N' ">
					                    <p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Actual LY</p>
					                </xsl:if> 
					                <xsl:if test=" $event_base_loc_val= 'N' ">
					                    <p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Plan CY</p>	
					                </xsl:if>
					                 <xsl:if test=" $event_actualCY_loc_val= 'N' ">
					                 <p style="line-height:1;color:#000;font-weight:500;font-size: 9px;">Actual CY</p>
					                 </xsl:if>
									<!-- Added to display Doctor count field label  [shraddha::20-dec :: end] -->
								</td>
						  </xsl:if>
						<xsl:variable name="i" select="position()" />
							<xsl:for-each select="//EVENT_DESC2">
								<xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
								<xsl:variable name="parentDbID"><xsl:value-of select="@parentDomID"/></xsl:variable>
								<xsl:variable name="event_type"><xsl:value-of select="event_type"/></xsl:variable>
								<xsl:variable name="event_descr"><xsl:value-of select="event_descr"/></xsl:variable>
								<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
								<xsl:variable name="curr_vert_total"><xsl:value-of select="curr_vert_total"/></xsl:variable>
								<xsl:variable name="actualLY_vert_total"><xsl:value-of select="actualLY_vert_total"/></xsl:variable>
								<xsl:variable name="event_actualCY_loc_val"><xsl:value-of select="event_actualCY_loc_val"/></xsl:variable>
								<xsl:variable name="curr_vert_total"><xsl:value-of select="curr_vert_total"/></xsl:variable>
								
								
								    <xsl:if test=" $parentDbID = 1 and $dbID = 1 ">
									<!-- <td class="td_leftAlign" style="background:#fff;border-right:1px solid #ccc;padding: 3px 2px 3px 2px;"> -->
									<td  style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;background:#fff;" class="td_leftAlign">
										<xsl:if test=" $event_actualLY_loc_val= 'N' ">
										
										<xsl:if test=" $event_actually_endb_val= 'N' ">
				        					<input  type="number"  readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actualLY_vert_total"  id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actualLY_vert_total" class="input_editable" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" size="5px"  />
				        					</xsl:if>
				        					<xsl:if test=" $event_actually_endb_val= 'Y' ">
				        					<input  type="number"  readonly="readonly" name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actualLY_vert_total"  id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.actualLY_vert_total" class="input_editable" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" size="5px"  />
				        					</xsl:if>
										
									</xsl:if>
										 <xsl:if test=" $event_base_loc_val= 'N' ">
										 	<xsl:if test=" $event_plancy_endb_val= 'N' ">
				        					<input  type="number"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" class="input_editable" maxlength="6"  readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" size="5px"  />
				        					</xsl:if>
				        					<xsl:if test=" $event_plancy_endb_val= 'Y' ">
				        					<input  type="number"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" class="input_editable" maxlength="6"  readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" size="5px"  />
				        					</xsl:if>
										</xsl:if> 
										 <xsl:if test=" $event_actualCY_loc_val= 'N' ">
											<input  type="number"  name="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.curr_vert_total"  readonly="readonly" id="EVENT_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.curr_vert_total" class="input_editable" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5;height: 10%;font-size: 12px;" size="5px"  />
											</xsl:if> 
											
									</td>
								    </xsl:if>
						   </xsl:for-each>
					</xsl:for-each>
			</tr>
		</tfoot>
	</table> 
</div>
		 <div id="pageNavPosition" style="width: 50%;float:right;margin-top: 10px;margin-bottom: 0px;height: 36px;" align="right"></div>
	

	<div style="width: 50%;float:right;margin-top: 10px;margin-bottom: 0px;height: 36px;" >
	<table>
		<tr>
		    <td>
			<input  type="hidden"  value="2" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="strg_event_track" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

			
			<input type="submit" style="cursor:hand" value="Cancel" name="Cancel" id="Cancel" class="button" title='' onclick="javascript:setActionVal('previous')"/>
				
			<input type="submit" style="cursor:hand" value="Save" name ="Finish" id="Finish" class="button" title='' onclick="javascript:setActionVal('finish'),dissableFld();"/> 
			<input type="button" style="cursor:hand" value="Confirm" id="Confirm" class="button" title='' onclick="javascript:checkConfirm('finish');dissableFld();"/>   
<!-- 			<input type="button" style="cursor:hand" value="Finish" id="Finish" class="button" title=''  onclick="javascript:validatebrand();"/>   -->
			
		    </td>
                </tr>
	</table>
	</div>


					
</form>
</body>
<script type="text/javascript">
	var pager = new Pager('eventTable', 10);
	pager.init();
	pager.showPageNav('pager', 'pageNavPosition');
	pager.showPage(1);
</script>
</html>
</xsl:template>
</xsl:stylesheet>