<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: black;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:black;}
					p {font-size: 12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					<!-- padding-left:8%; -->
					padding:10px;
					}
					.firstData
					{
						color:black;
						width:50%;
					}
					@media only screen and (min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
								cellpadding="1" width="100%"> -->

							<div class="headerTableDCR headerTableDCR1">
								<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">
									<xsl:for-each select="//Detail1">
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Customer : </span>
											</td>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="first_name" /><xsl:text> </xsl:text>
													<xsl:value-of select="middle_name" /><xsl:text> </xsl:text>
													<xsl:value-of select="last_name" />
												</span>
											</td>
										</tr>

										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">locality : </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="locality_code" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Mobile No : </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="mobile_no" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Email Address : </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="email_addr" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Customer Type : </span>
											</td>
											<td class="firstData">
												<xsl:variable name="cust_type">
													<xsl:value-of select="cust_type" />
												</xsl:variable>
		
												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:if test="normalize-space($cust_type) = 'D' ">
															Doctor Customers
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'C' ">
															Chemist Customers
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'S' ">
															stockist customers
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'A' ">
															Army
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'F' ">
															Empanelled Distributors
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'L' ">
															Investor
													</xsl:if>
													<xsl:if test="normalize-space($cust_type) = 'O' ">
															Other
													</xsl:if>
													
												</span>
											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Status : </span>
											</td>
											<td class="firstData">
												<xsl:variable name="status">
													<xsl:value-of select="status" />
												</xsl:variable>
												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:if test="normalize-space($status) = 'A' ">
															Active
													</xsl:if>
													<xsl:if test="normalize-space($status) = 'N' ">
															Non Active
													</xsl:if>
													<xsl:if test="normalize-space($status) = 'U' ">
															Un-empaneled
													</xsl:if>
												</span>
											</td>
										</tr>
										
									</xsl:for-each>

								</table>
							</div>
<xsl:variable name="activity_type"><xsl:for-each select="//Detail1"><xsl:value-of select="activity_type" /></xsl:for-each></xsl:variable>
<xsl:if test="normalize-space($activity_type) = 'FW'">
<input type="button" id="button" value="-" onClick="expandAllDetails(this.id)" style="background-color: white;text-align:right;width:inherit;border:none;"/>
</xsl:if>


<!-- Detail2(start) -->
<xsl:variable name="detail2_listed_count">
<xsl:for-each select="//Detail2"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail2)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail2_listed_count) > '0'">
<xsl:variable name="detail2_form" ><xsl:for-each  select="//Detail2" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each></xsl:variable>
<xsl:variable name = "detail2_form_name"><xsl:value-of select="substring-before($detail2_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail2_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail2(end) -->
<!-- Detail3(start) -->
<xsl:variable name="detail3_listed_count">
<xsl:for-each select="//Detail3"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail3)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail3_listed_count) > '0'">
<xsl:variable name="detail3_form" >
<xsl:for-each  select="//Detail3" ><xsl:value-of select="concat(@formName,'(','3',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail3_form_name"><xsl:value-of select="substring-before($detail3_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail3_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail3(end) -->
<!-- Detail4(start) -->
<xsl:variable name="detail4_listed_count">
<xsl:for-each select="//Detail4"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail4)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail4_listed_count) > '0'">
<xsl:variable name="detail4_form" >
<xsl:for-each  select="//Detail4" ><xsl:value-of select="concat(@formName,'(','4',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail4_form_name"><xsl:value-of select="substring-before($detail4_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail4_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail4(end) -->
<!-- Detail5(start) -->
<xsl:variable name="detail5_listed_count">
<xsl:for-each select="//Detail5"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail5)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail5_listed_count) > '0'">
<xsl:variable name="detail5_form" >
<xsl:for-each  select="//Detail5" ><xsl:value-of select="concat(@formName,'(','5',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail5_form_name"><xsl:value-of select="substring-before($detail5_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail5_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail5(end) -->
<!-- Detail6(start) -->
<xsl:variable name="detail6_listed_count">
<xsl:for-each select="//Detail6"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail6)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail6_listed_count) > '0'">
<xsl:variable name="detail6_form" >
<xsl:for-each  select="//Detail6" ><xsl:value-of select="concat(@formName,'(','6',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail6_form_name"><xsl:value-of select="substring-before($detail6_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail6_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail6(end) -->
<!-- Detail7(start) -->
<xsl:variable name="detail7_listed_count">
<xsl:for-each select="//Detail7"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail7)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail7_listed_count) > '0'">
<xsl:variable name="detail7_form" >
<xsl:for-each  select="//Detail7" ><xsl:value-of select="concat(@formName,'(','7',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail7_form_name"><xsl:value-of select="substring-before($detail7_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail7_form_name" /></xsl:call-template>
</xsl:if>

<!-- Detail7(end) -->
<!-- Detail8(start) -->
<xsl:variable name="detail8_listed_count">
<xsl:for-each select="//Detail8"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail8)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail8_listed_count) > '0'">
<xsl:variable name="detail8_form" >
<xsl:for-each  select="//Detail8" ><xsl:value-of select="concat(@formName,'(','8',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail8_form_name"><xsl:value-of select="substring-before($detail8_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail8_form_name" /></xsl:call-template>
</xsl:if>

<!-- Detail8(end) -->
<!-- Detail9(start) -->
<xsl:variable name="detail9_listed_count">
<xsl:for-each select="//Detail9"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail9)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail9_listed_count) > '0'">
<xsl:variable name="detail9_form" >
<xsl:for-each  select="//Detail9" ><xsl:value-of select="concat(@formName,'(','9',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail9_form_name"><xsl:value-of select="substring-before($detail9_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail9_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail9(end) -->
<!-- Detail10(start) -->
<xsl:variable name="detail10_listed_count">
<xsl:for-each select="//Detail10"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail10)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail10_listed_count) > '0'">
<xsl:variable name="detail10_form" >
<xsl:for-each  select="//Detail10" ><xsl:value-of select="concat(@formName,'(','10',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail10_form_name"><xsl:value-of select="substring-before($detail10_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail10_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail10(end) -->
<!-- Detail11(start) -->
<xsl:variable name="detail11_listed_count">
<xsl:for-each select="//Detail11"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail11)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail11_listed_count) > '0'">
<xsl:variable name="detail11_form" >
<xsl:for-each  select="//Detail11" ><xsl:value-of select="concat(@formName,'(','11',',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail11_form_name"><xsl:value-of select="substring-before($detail11_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail11_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail11(end) -->
							<div width="40%" id="attachmentUpload" class="attachmentUpload"
								style="display: none;">
								<table width="100%" height="100%">
									<tr height="10%" width="100%">
										<td>
											<div class="close" onclick="closeMe('attachmentUpload');">x</div>
											<div width="100%">
												<div
													style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
													<input type="button" class="buttonZoomIN" style="float:right;"
														value="+" id="zoomInBtn" onclick="zoomImage('+')" />
													<input type="button" class="buttonZoomOUT" style="float:right;"
														value="(-)" id="zoomOutBtn" onclick="zoomImage('-')" />
												</div>
											</div>
										</td>
									</tr>

									<tr height="89%" width="100%">
										<td>
											<div id="uploadContent"
												style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
												<img id="targetImg" style="max-height: 100%; max-width:100%;"
													src="" setMinSize="false" setSize="false" oHeight=""
													oWidth=""></img>
											</div>
										</td>
									</tr>
									<tr height="1%" width="100%">
										<td>

										</td>
									</tr>
								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>

	<xsl:template name="tmpSplitString">
				<xsl:param name="stringtosplit" />
 				<xsl:variable name = "value"><xsl:value-of select="$stringtosplit" /></xsl:variable>
	    		<xsl:variable name = "form_no"><xsl:value-of select="substring-after($value,'(')"/></xsl:variable>
				<xsl:variable name = "form_name"><xsl:value-of select="substring-before($value,'(')"/></xsl:variable>
				<xsl:variable name = "detail"><xsl:value-of select="concat('Detail',$form_no)"/></xsl:variable>

 					 				<xsl:if test="normalize-space($form_no) = '2'">
 					 				<details open="true">
									<summary class="summary">Family</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Member Name</TH>
												<TH CLASS="cellttlblck heading">Relation</TH>
												<TH CLASS="cellttlblck heading">Occupation</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="member_name">
													<xsl:value-of select="member_name" />
												</xsl:variable>
												<xsl:variable name="relation">
													<xsl:value-of select="relation" />
												</xsl:variable>
												<xsl:variable name="occupation">
													<xsl:value-of select="occupation" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$member_name" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$relation" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$occupation" />
													</TD>
												</TR>
											</xsl:if>
										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '3'">
 					 			<details open="true">
									<summary class="summary">Qualification</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Qualification </TH>
												<TH CLASS="cellttlblck heading">Speciality</TH>
												<TH CLASS="cellttlblck heading">Institute</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="qual_descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												<xsl:variable name="speciality_descr">
													<xsl:value-of select="speciality_descr" />
												</xsl:variable>
												<xsl:variable name="institute">
													<xsl:value-of select="institute" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$qual_descr" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$speciality_descr" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$institute" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '4'">
 					 			<details open="true">
									<summary class="summary">Events</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Event Code </TH>
												<TH CLASS="cellttlblck heading">Event Date</TH>
												<TH CLASS="cellttlblck heading">Description</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="event_code">
													<xsl:value-of select="event_code" />
												</xsl:variable>
												<xsl:variable name="event_date">
													<xsl:value-of select="event_date" />
												</xsl:variable>
												<xsl:variable name="event_descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$event_code" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$event_date" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$event_descr" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '5'">
 					 			<details open="true">
									<summary class="summary">Institute</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Institute </TH>
												<TH CLASS="cellttlblck heading">Extention</TH>
												<TH CLASS="cellttlblck heading">Prefer Meeting</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="inst_descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												<xsl:variable name="ext_no">
													<xsl:value-of select="ext_no" />
												</xsl:variable>
												<xsl:variable name="prefer_metting">
													<xsl:value-of select="prefer_metting" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$inst_descr" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$ext_no" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$prefer_metting" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '6'">
 					 			<details open="true">
									<summary class="summary">Product</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Division </TH>
												<TH CLASS="cellttlblck heading">Item</TH>
												<TH CLASS="cellttlblck heading">Brand</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="item_ser">
													<xsl:value-of select="item_ser" />
												</xsl:variable>
												<xsl:variable name="item_descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												<xsl:variable name="brand_code">
													<xsl:value-of select="brand_code" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$item_ser" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$item_descr" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$brand_code" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '7'">
 					 			<details open="true">
									<summary class="summary">Series</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Sales Pers </TH>
												<TH CLASS="cellttlblck heading">Division</TH>
												<TH CLASS="cellttlblck heading">Customer</TH>
												<TH CLASS="cellttlblck heading">Status</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="sp_name">
													<xsl:value-of select="sp_name" />
												</xsl:variable>
												<xsl:variable name="item_ser">
													<xsl:value-of select="item_ser" />
												</xsl:variable>
												<xsl:variable name="sc_name">
													<xsl:value-of select="sc_name" />
												</xsl:variable>
												<xsl:variable name="ser_status">
													<xsl:value-of select="status" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$sp_name" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$item_ser" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$ser_status" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '8'">
 					 			<details open="true">
									<summary class="summary">Specialty</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Specialty</TH>
												<TH CLASS="cellttlblck heading">Specialty Code Main</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="specialty_descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												<xsl:variable name="spl_code__main">
													<xsl:value-of select="spl_code__main" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$specialty_descr" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$spl_code__main" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '9'">
 					 			<details open="true">
									<summary class="summary">Practice Hours</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Day</TH>
												<TH CLASS="cellttlblck heading">Visit Place</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="days">
													<xsl:value-of select="days" />
												</xsl:variable>
												<xsl:variable name="visit_place">
													<xsl:value-of select="visit_place" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:if test="normalize-space($days) = '1' ">
																Sunday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '2' ">
																Monday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '3' ">
																Tuesday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '4' ">
																Wednesday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '5' ">
																Thursday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '6' ">
																Friday
														</xsl:if>
														<xsl:if test="normalize-space($days) = '7' ">
																Saturday
														</xsl:if>
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$visit_place" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '10'">
 					 			<details open="true">
									<summary class="summary">Membership</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Member Type </TH>
												<TH CLASS="cellttlblck heading">Member No</TH>
												<TH CLASS="cellttlblck heading">Institute</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="member_type">
													<xsl:value-of select="member_type" />
												</xsl:variable>
												<xsl:variable name="member_no">
													<xsl:value-of select="member_no" />
												</xsl:variable>
												<xsl:variable name="institue">
													<xsl:value-of select="institue" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$member_type" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$member_no" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$institue" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 			<xsl:if test="normalize-space($form_no) = '11'">
 					 			<details open="true">
									<summary class="summary">Retailer</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Name </TH>
												<TH CLASS="cellttlblck heading">Contact</TH>
												<TH CLASS="cellttlblck heading">Location</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="name">
													<xsl:value-of select="name" />
												</xsl:variable>
												<xsl:variable name="contact">
													<xsl:value-of select="contact" />
												</xsl:variable>
												<xsl:variable name="location">
													<xsl:value-of select="location" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$name" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$contact" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$location" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 			</xsl:if>
 					 		</xsl:template>
</xsl:stylesheet>