<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
					.tdLeft
					{
					text-align: left;
					padding-left: 20px;
					}
					.tdRight
					{
					text-align: right;
					padding-right: 20px;
					}
					.normalFont
					{
					font-size:14px;
					color:black;
					}

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        width: calc(100% - 32px);
                        max-width: 1024px;
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

				</style>

			</head>

			<script type="text/javascript"
				src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">

<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: initial;
					font-size: 14px;
					color:
					#666;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}

					.heading
					{
					font-weight: 500;
					font-size:
					14px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					padding-left:8%;
					}
					.firstData
					{
					color:black;
					}
					@media only screen and
					(min-width: 100px)
					and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}

					}
					
					.headingl
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-LEFT: 4PX;
						width:15%;
						text-align:left;


					}
					.break:after
					{
					content:",";

					}
					.firstData
					{
					color:#fff;
					}
					.lineSpace
					{
					padding-top:6px;
					}
					.outerDivSummary
					{
                        background-color: #949494;
					    width: 99%;
					    BORDER: 1px solid #FFF;
					    opacity: 0.9;
					    
					    margin: auto;
					}
					.tdSpanh{
						font-size:13px;
					}
					.tdSpan{
						font-size:17px;
					}
				</style>

				<style>
				   
				    .tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 17px;
					font-weight: 700;
					padding-top: 10px;
					padding-bottom:10px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-RIGHT: 11PX;
						width:15%;
						text-align:right;


					}
					.headingl
					{
						font-weight: 400;
						font-size: 16px;
				    	color: #000000;
				    	padding-top: 7px;
				    	padding-bottom: 6px;
				    	PADDING-LEFT: 4PX;
						width:15%;
						text-align:left;


					}
					.break:after
					{
					content:",";

					}
					.firstData
					{
					color:#fff;
					}
					.lineSpace
					{
					padding-top:6px;
					}
					.outerDivSummary
					{
                        background-color: #949494;
					    width: 99%;
					    BORDER: 1px solid #FFF;
					    opacity: 0.9;
					    
					    margin: auto;
					}
					.tdSpanh{
						font-size:13px;
					}
					.tdSpan{
						font-size:17px;
					}
					
					
					
					.travelTableCss {
					padding: 10px;
					color: #666;
					font-size: 14px;
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					width: auto;
					grid-column-gap: 0.30em;
					grid-row-gap: 0.25em;
					}

					.travelTitle {
					width:
					auto;
					float: right;
					font-size: 14px;
					text-align: right;
					}

					.travelValue{
					width: auto;
					text-align: left;
					line-height: 1.2;
					}

					.valueFieldCss{
					font-size: 14px;
					color: #666;
					}

					.plcDetailCss {
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					grid-column-gap: 0.25em;
					grid-row-gap: 0.25em;
					width: 100%;
					}

					.custDetailCss{
					color: #666;
					width: 100%;
					font-size: 12px;
					display: grid !important;
					grid-template-columns: 35% 30% 30%;
					grid-column-gap: 0.75em;
					grid-row-gap: 0.75em;
					}

					.dataDivCss{
					height:100%;
					width:100%;
					overflow-x:hidden;
					overflow-y:auto;
					}

					.summaryborderPanel{
					display:
					block;
					border-top: #fff 1px solid;
					width: 98%;
					margin-top: 24px;
					}
					.headerTablediv
					{
					background: #fff;
					box-shadow: 0px -1px 0px 0
					rgba(0,0,0,.1);
					}
					.headerTable1
					{
					text-align:center;
					padding-left:
					0;
					}

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        max-width: 1024px;
                        width: calc(100% - 32px);
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

                    .containerfeed{
                        padding: 12px 0;
                        margin: 4px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff;
                        overflow: hidden;
                    }


                    .headerdata{
                        display: flex;
                        align-items: center;
                        white-space: nowrap;
                        /* height: 36px; */
                        margin: 0;
                        font-size: 12px;
                        padding: 0 12px;
                        color: #000;
                        cursor: pointer;
                    } 

                    .doctorDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: left;
                    }
                    .localityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .stateDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .qualificationDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .specialityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .brandsDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: right;
                    }

                    .single-colDiv{
                        display: inline-flex;
                        align-items: center;
                        text-align: left;
                        justify-content: center;
                        margin: 0 auto;
                        padding: 0 16px;
                        width: 100%;
                        height: 100px;
                        min-height: 100px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .imgicon{
                        width: 80px;
                        height: 80px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                .textcolor{
                    color:#969696 !Important;
                    font-weight: 500;
                }
                .prescription_btm_border {
                    margin: 4px 16px 0 40px;
                    border-bottom: 1px solid #eeeeee;
                }

                .text-rowgroup-2{
                    font-size: 14px;
                    font-weight: 600;
                    color: #000;
                    margin: 4px 0;
                    text-align: center;
                }
                .text-rowgroup-3{
                    font-size: 18px;
                    font-weight: 600;
                    text-align: center;
                    color: #000;
                }
                .activity-descr-text{
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .mainiconradius{
                    width: 30px;
                    height: 30px;
                    margin: 0 10px;
                }

                .stickysubforms{
                    position: relative;
                    display: contents;
                    -webkit-overflow-scrolling: touch;
                }
                .timeline::before {
                    content: '';
                    position: absolute;
                    height: 22px;
                    width: 1px;
                    background-color: #000;
                    left: 32px;
                    transform: translateY(-118%);
                    /*transform: translate(100%,-100%);*/
                }
                .timeline:first-child::before{
                    width: 0;
                }

                .customerDiv{
                    display: flex;
                    padding: 0 16px;
                    align-items: center;
                    margin-bottom: 16px;
                }

                .customerDiv:last-child{
                    margin-bottom: 0;
                }

                .outerIcon{
                    height: 24px;
                    width: 24px;
                    margin: 0 4px 0 0;
                }

                .large-font{
                    font-size: 14px;
                }
                .small-font{
                    font-size: 12px;
                }
                .row-div{
                    padding: 0 16px 0 40px;
                    display: flex;
                    align-items: center;
                    margin-bottom: 16px;
                }
                .prescription_det {
                    padding: 0 16px 0 40px;
                    display: flex;
                    align-items: center;
                }
                
                .hideoverflow{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 2;
                    display: -webkit-box;
                    -webkit-box-orient: vertical;
                    height: 35px;
                }

                .hideoverflowfeed{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    height: 20px;
                    min-width: 50px;
                    line-height: 24px;
                }

                .datafontsize{
                    font-size:14px !Important;
                    color: #000;
                }
                .headerfontsize{
                    font-size:12px !Important;
                    color:#969696 !Important;
                }
                .bradius{
                    border-radius: 100px;
		    height: 30px;
                    width: 30px;
                }
		.brandImg{
                    border-radius: 100px;
                    width: 30px;
                }

                .collapsibleIconRadius{
                    border-radius: 100px;
                    height: 30px;
                    width: 30px;
                }

                .rightcol-spacing{
                    margin-inline-start: auto;
                    text-align: right;
                    font-size: 12px;
                    align-self: baseline;
                    white-space: nowrap;
                }

                .imgradius{
                    border-radius: 100px;
                    height: 80px;
                    width: 80px;
                }

                .main-icon{
                    display: block; 
                    text-align:center;
                    margin: 4px 0;
                }

                .align-imgtext{
                    float:left;
                    text-align:right;
                }
				
				.prescription_data{
                    float:left;
                    text-align:right;
					height: 36px;
                }

                .columnsDiv {
                    display: flex;
                    align-items: center;
                    width: 100%;
                    height: 52px;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }

                .btnborder{
                    height: 24px;
                    width: 24px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    background-color: #f5f5f5;
                    border-radius: 28px;
                }

                .tab{
                    margin-inline-start: auto;
                    cursor: pointer;
                }
                .tablinks{
                    border:none;
                    outline:none;
                    background: none;
                }

                .tab button:active {
                    border: none;
                    outline: none;
                    box-shadow: none;
                }
               
                .left-spacing{
                    width: 60%;
                    padding: 0 8px 0 0;
                    min-width: 80px;
                    overflow: hidden;
                    text-align: left;
                    display: flex;
                    align-items: center;
                }

                .center-spacing{
                    width: 20%;
                    text-align: left;
                    padding: 0 8px 0;
                    min-width: 70px;
                    overflow: hidden;
                }
                .right-spacing{
                    text-align: right;
                    width: 20%;
                    padding: 0 0 0 8px;
                    min-width: 60px;
                    overflow: hidden;
                }

                .bgcolorform{
                    background-color: #f5f5f5;
                }
                .headingwidth{
                    border-bottom: 1px solid #0000001a;
                    white-space: nowrap;
                    display: flex;
                    align-items: flex-start;
                    height: 25px;
                    text-overflow: ellipsis;
                    overflow: hidden;
                    color: #666666 !important;
                    padding: 0 8px;
                }


                .detailswidth{
                    padding: 0 8px;
                    white-space: normal;
                    height: 38px;
                    display:grid;
                    align-items: center;
                    color: #000;
                }
                
                .seperatorDiv{
                    border-bottom: 1px solid #0000001a;
                }
                .firstcolumn{
                    text-align: left;
                    padding: 0 8px 0 0;
                    left: 0;
                }

                .lastcolumn{
                    justify-content: flex-end;
                    padding: 0 0 0 8px;
                }

                .containertable{
                    padding: 0 16px;
                    margin: 12px 0;
                    border-radius: 12px;
                    background:#fff;
                    overflow-x: hidden;
                }

                .doctorcontainer{
                    padding: 8px 0;
                    margin: 8px 0 8px 0;
                    border-radius: 12px;
                    background-color: #fff; 
                    overflow-x: auto;
                    overflow-y: hidden;
                }

                .doctordetails{
                    display: flex;
                    padding: 0px;
                    white-space: initial;
                    height: 25px;
                }
                .docdatadetails{
                    display: flex;
                    align-items: center;
                    padding: 0px;
                    height: 35px;
                    margin: 8px 0;
                }

                .sampleheading{
                    display:flex;
                    align-items:center;
                    padding: 8px 0;
                }

                .samplename{
                    display: flex;
                    align-items: center;
                    color: #666666;
                    padding: 0;
                    height: 25px;
                    border-bottom: 1px solid #0000001a;
                }

                .sampledata{
                    white-space: initial;
                    display: flex;
                    padding: 0;
                    margin: 8px 0;
                    height: 38px;
                    align-items: center;
                }

                .sampledetails{
                    background-color: #ededed;
                    padding: 16px;
                    /*width: 100%;*/
                    left: 0;
                    position: sticky;
                    position: -webkit-sticky;
                }

                .itemlabelDiv {
                    margin : 4px 16px 0 40px;
                    height: 16px;
                    text-align: left;
                }
                .itemOuterDiv{
                    margin-top: 16px;
                }

                .btniconborder{
                    height: 34px;
                    width: 34px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .feed_default_bg{
                    background-color: #0273d0;
                }

                .table_default_bg{
                    background-color: #e6f4ff;
                }

                .iconborder{
                    min-height: 30px;
                    min-width: 30px;
                    max-width: 30px;
                    max-height: 30px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .location-icon {
                    background-color: #98ccf4;
                }

                .date-icon {
                    background-color: #d5b3ff;
                }
                .remarks-icon {
                    background-color : #86e7d6;
                }

                .speciality-icon{
                    background-color: #91ecff;
                } 

                .class-icon{
                background-color: #ffa7a7;
                }

                .visitplan-icon {
                    background-color: #f4a8ff;
                }

                .state-icon {
                    background-color: #ffb98e;
                }

                .visitedwith-icon {
                    background-color: #b2bbff;
                }

                .pobvalue-icon {
                    background-color: #fbd607;
                }
                .product-icon  {
                    background-color: #cacaca;
                }
                .unlistedcust-icon{
                    background-color: #b2bbff;
                }

                .bluebg-icon{
                    background-color: #e6f4ff;
                }

                .redbg-icon{
                    background-color: #ffe8e9;
                }
				.al-icon{
                    background-color: #d1c5df;
                }
                .pc-icon{
                    background-color: #f4c1a4;
                }
                .ac-icon{
                    background-color: #8bd1bc;
                }
                .event-icon{
                    background-color: #fbcb68;
                }

                .namespacing{
                    padding: 0 0 0 16px;
                    text-align: left;
                    line-height: 1.5;
                }

                #section-n2 {
                    display:none;
                }

                button.rmvborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #f5f5f5;
                }

                button.rmborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #fff;
                }

                .tabs {
                    position: relative;
                    text-align: center;
                    background: #f5f5f5;
                    /*width: 100%;*/
                    border-radius: 5px;
                    min-width: 240px;
                    min-height: 500px;
                    overflow-x: auto;
                    overflow-y: hidden;
                    -webkit-overflow-scrolling: touch;
                }

                .tabs .uldiv {
                    list-style-type: none;
                    padding: 0 16px;
                    display: -webkit-box;
                    display: flex;
                    -webkit-box-orient: horizontal;
                    -webkit-box-direction: normal;
                            flex-direction: row;
                    margin-bottom: 4px;
                    -webkit-box-pack: justify;
                            justify-content: space-between;
                    -webkit-box-align: end;
                            align-items: center;
                    flex-wrap: wrap;
                    margin-top: 0;
                    width: 100%;
                }

                .rmv-Mrg{
                    margin: 0;
                }

                .tabs .uldiv li {
                    box-sizing: border-box;
                    -webkit-box-flex: 1;
                    text-align: center;
                    margin-right: 0;
                }
                .lidiv{
                    padding: 0 0 0 16px;
                }


                .tabs .uldiv li label {
                    -webkit-transition: all 0.3s ease-in-out;
                    transition: all 0.3s ease-in-out;
                    padding: 5px auto;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    display: block;
                    cursor: pointer;
                    -webkit-transition: all 0.2s ease-in-out;
                    transition: all 0.2s ease-in-out;
                    white-space: nowrap;
                    -webkit-touch-callout: none;
                    user-select: none;
                }

                .tabs .uldiv li label{
                    font-size: 18px;
                    color: #0273d0;
                }


                .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                    outline: 0;
                    color: #0273d0;
                }

                .tabs .slidertab {
                    position: relative;
                    width: calc(100% - 56px);
                    -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                }
                .tabs .slidertab .indicator {
                    position: relative;
                    width: 16px;
                    max-width: 100%;
                    margin-inline-start: auto;
                    height: 4px;
                    background: #0273d0;
                    border-radius: 1px;
                }

                .tabs .data-content section {
                    -webkit-animation-name: data-content;
                            animation-name: data-content;
                    -webkit-animation-direction: normal;
                            animation-direction: normal;
                    -webkit-animation-duration: 0.3s;
                            animation-duration: 0.3s;
                    -webkit-animation-timing-function: ease-in-out;
                            animation-timing-function: ease-in-out;
                    -webkit-animation-iteration-count: 1;
                            animation-iteration-count: 1;
                    line-height: 1.4;
                }

                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                    cursor: default;
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }

                .tabs input[name="tab-control"] {
                    display: none;
                }

                @-webkit-keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @media (max-width: 1000px) {
                    .tabs .uldiv li label {
                        white-space: initial;
                    }
                }


                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                    -webkit-transform: translateX(-18px);
                            transform: translateX(-18px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                    display: block;
                }*/
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                    cursor: default;
                }
                
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(32px);
                            transform: translateX(32px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                    display: block;
                }*/

                .multi-colDiv{
                    margin: 24px 0;
                    text-align: left;
                    padding: 0 16px;
                    
                }
                @media screen and  (min-width:580px) {
                    .multi-colDiv{
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                    }
                    .columnsDiv{
                        justify-content: center;
                    }
                }
				</style>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" class="bgcolorform">
				    <div ID="dsrDiv" class="outerDivSummary" style="MARGIN-BOTTOM: 10PX;">

						<div id='dataDiv' class="dataDiv" style="height:100%;width:100%;overflow-y:auto">
							<div>
							     <table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%" style="padding: 15px;padding-top: 8px;">
									<xsl:for-each select="//Detail1">
										
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Sales Person</span>
											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">
												<span CLASS="tdSpan" style="width:auto;float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="sales_pers" />
                                                </span>
											</td>
										</tr>
										
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Employee Name</span>
											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">
												<span CLASS="tdSpan" style="width:auto;float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="sales_pers_name" />
                                                </span>
											</td>
										</tr>
										
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Period Code</span>
											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">
												<span CLASS="tdSpan" style="width:auto;float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="prd_code" />
                                                </span>
											</td>
										</tr>
										
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="tdSpanh" style="width:auto;float: left;text-align:left;margin-bottom: -4px;">Financial Year</span>
											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto" style="padding-top:0px">
												<span CLASS="tdSpan" style="width:auto;float: left;text-align:left;margin-bottom: 2px;">
													<xsl:value-of select="financial_year" />
                                                </span>
											</td>
										</tr>
										
									</xsl:for-each>
								 </table>	
							</div>
							
							</div>
					       </div>	
			
					<div class="mainbody">
					      <xsl:variable name="hostUrl">
                                    <xsl:for-each select="//Detail1">
                                        <xsl:if test="attribute/@updateFlag!='D'">
                                            <xsl:value-of select="host_url" />
                                        </xsl:if>
                                    </xsl:for-each>
                          </xsl:variable>
                          
                          <xsl:variable name="feed">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed.svg')" />
                        </xsl:variable>
                        <xsl:variable name="feed_alt">
                          <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed_alt.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table_alt">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table_alt.svg')" />
                        </xsl:variable>
					    
					     <div class="tabs">
                            <input type="radio" id="tab1" name="tab-control" checked="true"  />
                            <input type="radio" id="tab2" name="tab-control" />
                            <ul class="uldiv">
                                <li class="rightcol-spacing" title="Feed View">
                                    <label for="tab1" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder feed_default_bg" id="feedbg" style="display: none">
                                                <IMG 
                                                    id="feedicon" width ="30" height="30"
                                                    onclick="focusView('focusOnFeed','{normalize-space($feed_alt)}','{normalize-space($table)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$feed_alt" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                                <li class="lidiv rmv-Mrg" title="Table View">
                                    
                                    <label for="tab2" role="button" class="tablinks" >
                                        <span style="display: none">
                                            <div class="btniconborder table_default_bg" id="tablebg">
                                                <IMG 
                                                    id="tableicon" width ="30" height="30"
                                                    onclick="focusView('focusOnTable','{normalize-space($table_alt)}','{normalize-space($feed)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$table" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                            </ul>
                            <div class="slidertab" style="display: none">
                                <div class="indicator"></div>
                            </div>

                            <xsl:variable name="host_url">
                                <xsl:for-each select="//Detail1">
                                    <xsl:value-of select="host_url" />
                                </xsl:for-each>
                            </xsl:variable>
                            <div class="data-content">

                                <section id="section-n1">

                                    <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail2(end) -->
                                    
                                </section>

                                <section id="section-n2">

                                    <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                  </xsl:if>
                                    <!-- Detail2(end) -->
                                    
                                    
                                </section>

                            </div>
                        </div>
					    
					    
					    
					</div>

				</form>
			</body>

		</html>
	</xsl:template>
 <xsl:variable name="host">
        <xsl:for-each select="//Detail2">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
<xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>

        <xsl:variable name="collapse">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/collapse.svg')" />
		</xsl:variable>
		<xsl:variable name="expand">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/expand.svg')" />
		</xsl:variable>

		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)][attribute/@updateFlag!='D'])" />
			</xsl:variable>
			
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

                <div class="headerdata datafontsize">
                    <!--<IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_doc.svg"
                        onerror='this.src="../webitm/images/Summary/summary_doc.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> -->
                    <svg class="outerIcon align-imgtext" xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 256 256">
					  <defs>
					    <style>
					      .cls-2 {
					        fill: #679b69;
					        fill-rule: evenodd;
					      }
					    </style>
					  </defs>
					  <path id="Doc" class="cls-2" d="M126.918,127.045c23.52,0,42.647-18.789,42.647-41.887v-21.7c0-23.1-19.127-41.887-42.647-41.887S84.271,40.363,84.271,63.459v21.7C84.271,108.256,103.4,127.045,126.918,127.045Zm94.052,54.581a107.865,107.865,0,0,0-61.462-47.708,1.722,1.722,0,0,0-1.7.407c-12.084,11.7-27.1,20.831-30.855,23.037-4.007-2.517-20.888-13.321-30.923-23.037a1.721,1.721,0,0,0-1.7-.407,107.832,107.832,0,0,0-61.458,47.71,1.646,1.646,0,0,0,0,1.694c19.385,32.44,55.423,52.593,94.05,52.593s74.67-20.153,94.054-52.593A1.64,1.64,0,0,0,220.97,181.626Zm-66.636,14.126H142.286a1.67,1.67,0,0,1-1.72-1.633v-10.1a1.7,1.7,0,0,1,1.72-1.67h12.048a1.6,1.6,0,0,0,1.584-1.68V168.925a1.782,1.782,0,0,1,1.827-1.652h10.263a1.551,1.551,0,0,1,1.557,1.652V180.7a1.8,1.8,0,0,0,1.855,1.643h11.665a1.837,1.837,0,0,1,1.835,1.707v10.065a1.774,1.774,0,0,1-1.835,1.633H171.534a1.972,1.972,0,0,0-1.967,1.718V209.2a1.445,1.445,0,0,1-1.444,1.627H157.749a1.763,1.763,0,0,1-1.827-1.627V197.47A1.634,1.634,0,0,0,154.334,195.752Z"/>
					</svg>
                    <xsl:value-of
                        select="normalize-space($doc_listed_cnt)" />
                    Doctor's Details
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext" style="display: none">
                                <IMG
                                    id="doc_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('doc_listed', 'doc_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>
                
                <div id="doc_listed">

						<xsl:for-each
							select="//node()[starts-with(name(), $detail)]">
							


							<xsl:if test="attribute/@updateFlag!='D'">
								
								<xsl:variable name="tran_id">
									<xsl:value-of select="tran_id" />
								</xsl:variable>
								
                                <div class="containerfeed datafontsize">

									<xsl:variable name="doctor_name">
										<xsl:value-of select="doctor_name" />
									</xsl:variable>
									
									<xsl:variable name="sc_code">
										<xsl:value-of select="sc_code" />
									</xsl:variable>
									
									<xsl:variable name="locality">
										<xsl:value-of select="locality" />
									</xsl:variable>
									<xsl:variable name="speciality">
										<xsl:value-of select="speciality" />
									</xsl:variable>
									
									 <xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									
									<xsl:variable name="bussiness_to_us">
										<xsl:value-of select="bussiness_to_us" />
									</xsl:variable>
									
									<xsl:variable name="class_code">
										<xsl:value-of select="class_code" />
									</xsl:variable>
									
									<xsl:variable name="flm_visit">
										<xsl:value-of select="flm_visit" />
									</xsl:variable>
									
									<xsl:variable name="total_actual_ly">
										<xsl:value-of select="actualLY_horz_total" />
									</xsl:variable>
									
									<xsl:variable name="total_plan_cy">
										<xsl:value-of select="base_value_horz_tot" />
									</xsl:variable>
									
									<xsl:variable name="total_target_nos">
										<xsl:value-of select="curr_horz_total" />
									</xsl:variable>
									
									<xsl:call-template name="tmpOrderFeed">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$doctor_name,'#',$speciality,'*',$sc_code,'!',$locality,'^',$class_code,'**',$total_actual_ly,'@@',$total_plan_cy,'$#',$detail,'####',$total_target_nos,'#####',$flm_visit,'***',$bussiness_to_us)" />
									</xsl:call-template>

                                </div>
									
							</xsl:if>
						</xsl:for-each>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>

			
		</xsl:if>

	
	</xsl:template>
	
	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="doctor_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_speciality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '*')" />
		</xsl:variable>
		
		<xsl:variable name="doc_sc_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '^')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_actual_ly">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'@@')" />
		</xsl:variable>
		
		<xsl:variable name="doc_class_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="doc_flm_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'#####'),'***')" />
		</xsl:variable>
	
	   <xsl:variable name="doc_bussiness_to_us">
			<xsl:value-of
				select="substring-after($ord_value,'***')" />
		</xsl:variable>

		
	 
	 	<xsl:variable name="doc_total_plan_cy">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'$#')" />
		</xsl:variable>
		
		 <xsl:variable name="doc_total_target_nos">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'#####')" />
		</xsl:variable>
		
		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'####')" />

		</xsl:variable>

		
		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][2]"> <!-- 1 change 2 pk -->
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>


		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail','3')" />
		</xsl:variable>
		
		
		<xsl:variable name="item_listed_count">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_sc_code">
							<xsl:value-of select="sc_code" />
						</xsl:variable>
						   <xsl:if
							test="normalize-space($item_sc_code) = normalize-space($doc_sc_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if> 
					</xsl:if>
				</xsl:for-each>
				
		</xsl:variable>
		<!-- Item Details End -->


		<xsl:choose>
			<xsl:when test="$item_listed_count > '0'">
                <div>
                    <div class="customerDiv">

                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_sc_code)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/errUser.png"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                <xsl:value-of
									select="$doctor_name" /> , 
								<xsl:value-of
									select="$doc_sc_code" />
                            </div>
                        </div>
                    
                    </div>

                    <xsl:if test="normalize-space($doc_locality) != ''">
                        
                        <div class="row-div">
                            <div class="iconborder location-icon align-imgtext">
                                <!-- <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                    class="bradius align-imgtext">
                                </IMG> -->
                                <svg class="bradius align-imgtext" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 256 256">
								    <defs>
									    <style>
									      .cls-1 {
									        fill: #fff;
									        fill-rule: evenodd;
									      }
									    </style>
									  </defs>
								  <path id="Location" class="cls-1" d="M128.3,52.837c-31.739,0-57.558,25.361-57.558,56.53,0,41.7,53.1,91.272,55.366,93.364a3.247,3.247,0,0,0,4.385,0c2.26-2.092,55.365-51.66,55.365-93.364C185.861,78.2,160.042,52.837,128.3,52.837Zm0,87.935c-17.63,0-31.977-14.09-31.977-31.4S110.673,77.961,128.3,77.961s31.976,14.09,31.976,31.406S145.934,140.772,128.3,140.772Z"/>
								</svg>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Locality
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:value-of select="$doc_locality" />
                                </div>
                            </div>
                        </div>
                        
                    </xsl:if>

                  
                  <div class="row-div">
                        <div class="iconborder speciality-icon align-imgtext">
                            <!-- <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>-->
                            <svg class="bradius align-imgtext" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 256 256">
								  <defs>
								    <style>
								      .cls-1 {
								        fill: #fff;
								        fill-rule: evenodd;
								      }
								    </style>
								  </defs>
								<path id="Speciality" class="cls-1" d="M124.845,156.71L85.207,137.276a7.051,7.051,0,0,0-10.14,6.368v18.271a7.083,7.083,0,0,0,4.188,6.474l45.823,20.453a7.011,7.011,0,0,0,5.723,0l45.821-20.453a7.085,7.085,0,0,0,4.188-6.474V143.64a7.052,7.052,0,0,0-10.141-6.368L131.027,156.71A7.021,7.021,0,0,1,124.845,156.71Zm3.091,1.515,74.3-54.393L129.7,68.268a4,4,0,0,0-3.518,0L53.639,103.832a4.043,4.043,0,0,0,0,7.25l72.539,35.564a4,4,0,0,0,3.518,0l54.928-26.932a4.013,4.013,0,0,1,5.771,3.625V148.5a4.023,4.023,0,0,0,4.013,4.033h1.56a4.022,4.022,0,0,0,4.012-4.033v-33.8a4.029,4.029,0,0,1,2.254-3.623h0A4.043,4.043,0,0,0,202.233,103.832Zm7.392,3.624"/>
							</svg>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Speciality
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_speciality" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder class-icon align-imgtext">
                            <!-- <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_class_code)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doc_class_code)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>-->
                             <!-- <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_class.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_class.svg"'
                                        class="bradius align-imgtext">
                                    </IMG> -->
                                    <svg class="bradius align-imgtext" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 256 256">
								    <defs>
								    <style>
								      .cls-1 {
								        fill: #fff;
								        fill-rule: evenodd;
								      }
								    </style>
								  </defs>
								  <path id="Class" class="cls-1" d="M197.783,111.456c-1.055-3.395-4.2-5.726-8.62-6.4L153.115,99.58,136.993,65.43c-1.978-4.19-5.07-6.594-8.484-6.594s-6.5,2.4-8.482,6.6L103.906,99.58l-36.049,5.477c-4.424.673-7.566,3-8.62,6.4s0.176,7.211,3.377,10.471L88.7,148.511l-6.158,37.536c-0.788,4.8.554,7.677,1.819,9.246a7.662,7.662,0,0,0,6.092,2.854,12.158,12.158,0,0,0,5.816-1.674l32.241-17.721,32.244,17.722a12.165,12.165,0,0,0,5.816,1.673h0a7.666,7.666,0,0,0,6.093-2.854c1.263-1.568,2.606-4.445,1.818-9.246l-6.158-37.536,26.085-26.584c3.2-3.26,4.43-7.078,3.376-10.471h0Zm0,0"/>
								</svg>
	                        </div>
	                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Class Code
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_class_code" />
                            </div>
                        </div>
                    </div>
                    
                     <div class="row-div">
                        <div class="iconborder al-icon align-imgtext">
                            <!--<IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_actual_ly)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>-->
                            <svg class="bradius align-imgtext" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 64 64">
                                   <defs>
                                       <style>
                                       .cls-1 {
                                           fill: #fff;
                                           fill-rule: evenodd;
                                       }
                                       </style>
                                   </defs>
                                   <path class="cls-1" d="M28.571,22.888V17.143a1.143,1.143,0,0,0-1.992-.765L16.293,27.807a1.143,1.143,0,0,0-.035,1.486L26.543,41.864a1.143,1.143,0,0,0,2.027-.721V35.448c9.029,0.294,14.663,4.153,17.2,11.771A1.143,1.143,0,0,0,46.857,48a1.1,1.1,0,0,0,.184-0.015A1.143,1.143,0,0,0,48,46.857C48,33.4,39.9,23.512,28.571,22.888Z"/>
                             </svg>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                              Total Actual Last Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_actual_ly" />
                            </div>
                        </div>
                    </div>
                    
                     <div class="row-div">
                        <div class="iconborder pc-icon align-imgtext">
                            <!--<IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_plan_cy)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>-->
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 64 64">
							  <defs>
							    <style>
							      .cls-1 {
							        fill: #fff;
							        fill-rule: evenodd;
							      }
							    </style>
							  </defs>
							  <path class="cls-1" d="M45.374,22.391H42.181v-5.05A1.338,1.338,0,0,0,40.845,16H36.84A1.338,1.338,0,0,0,35.5,17.341v5.05H28.829v-5.05A1.338,1.338,0,0,0,27.494,16H23.488a1.338,1.338,0,0,0-1.335,1.341v5.05H18.67A2.676,2.676,0,0,0,16,25.073V45.362a2.676,2.676,0,0,0,2.67,2.682h26.7a2.676,2.676,0,0,0,2.67-2.682V25.073A2.676,2.676,0,0,0,45.374,22.391Zm-3.193,19.4a1.338,1.338,0,0,1-1.335,1.341H23.488a1.338,1.338,0,0,1-1.335-1.341V31.712H42.181V41.794Z"/>
							</svg>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                              Total  Plan Current Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_plan_cy" />
                            </div>
                        </div>
                    </div>
                    
                     <div class="row-div">
                        <div class="iconborder ac-icon align-imgtext">
                            <!--<IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_target_nos)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>-->
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 64 64">
							  <defs>
							    <style>
							      .cls-1 {
							        fill: #fff;
							        fill-rule: evenodd;
							      }
							    </style>
							  </defs>
							  <path class="cls-1" d="M32.058,16.054A16.155,16.155,0,1,0,48.214,32.209,16.155,16.155,0,0,0,32.058,16.054Zm8.73,12.938L31.257,39.131a2.7,2.7,0,0,1-3.94,0l-3.988-4.243a2.7,2.7,0,1,1,3.94-3.7l2.018,2.147,7.561-8.043A2.7,2.7,0,1,1,40.788,28.992Z"/>
							</svg>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                               Total Actual Current Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_target_nos" />
                            </div>
                        </div>
                    </div>

                     
                    <xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                            select="concat($item_detail,'@',$doc_sc_code,'#',$item_listed_count,'*',$ord_host_url)" />
                    </xsl:call-template>
                
                </div>
					
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>

                <div>
                    <div class="customerDiv">

                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_sc_code)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/errUser.png"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                <xsl:value-of
									select="$doctor_name" /> , 
									<xsl:value-of
									select="$doc_sc_code" />
                            </div>
                        </div>
                    
                    </div>

                    <xsl:if test="normalize-space($doc_locality) != ''">
                        
                        <div class="row-div">
                            <div class="iconborder location-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Locality
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:value-of select="$doc_locality" />
                                </div>
                            </div>
                        </div>
                        
                    </xsl:if>

                  
                    <div class="row-div">
                        <div class="iconborder speciality-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Speciality
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_speciality" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_sc_code)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Class Code
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_class_code" />
                            </div>
                        </div>
                    </div>
                     <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_actual_ly)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                               Total Actual Last Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_actual_ly" />
                            </div>
                        </div>
                    </div>
                    
                    <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_plan_cy)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                               Total Plan Current Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_plan_cy" />
                            </div>
                        </div>
                    </div>
                    
                    <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_total_target_nos)}&amp;object=strg_event_track_wiz&amp;objName=strg_event_track_wiz&amp;ALT_FLD_VALUE={normalize-space($doctor_name)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                             Total Actual Current Year
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$doc_total_target_nos" />
                            </div>
                        </div>
                    </div>
                    
                </div>

			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
 
 <xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doctor_sc_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
            <xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>
        <xsl:variable name="ord_data_url">
            <xsl:value-of
				select="substring-after($order_data_value,'*')" />
        </xsl:variable>

	
            <div  class="headerdata datafontsize">
               Events
            </div>
            <div class="mobviewDiv">
					<xsl:for-each
						select="//node()[starts-with(name(), $item_details)]">
						
						<xsl:if test="attribute/@updateFlag!='D'">
						
							<xsl:variable name="actual_ly">
								<xsl:value-of select="actual_ly" />
							</xsl:variable>
							
							<xsl:variable name="plan_cy">
								<xsl:value-of select="plan_cy" />
							</xsl:variable>
						
							<xsl:variable name="target_nos">
								<xsl:value-of select="target_nos" />
							</xsl:variable>
							
							<xsl:variable name="event_descr">
								<xsl:value-of select="event_descr" />
							</xsl:variable>
							
							<xsl:variable name="item_sc_code">
								<xsl:value-of select="sc_code" />
							</xsl:variable>
							
							<xsl:if
								test="normalize-space($item_sc_code) = normalize-space($doctor_sc_code)">
								<div class="itemOuterDiv">
                                    <div class="prescription_det">
                                        <div class="iconborder product-icon align-imgtext">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 64 64">
                                                <defs>
                                                    <style>
                                                    .cls-1 {
                                                        fill: #fff;
                                                        fill-rule: evenodd;
                                                    }
                                                    </style>
                                                </defs>
                                                <path class="cls-1" d="M35.1,21.258L30.89,23.907a8.385,8.385,0,0,1-1.179.675,3.985,3.985,0,0,1-.857.247,8.336,8.336,0,0,1-1.355.056H21.333a5.364,5.364,0,0,0,0,10.728v6.7a2.667,2.667,0,1,0,5.333,0v-6.7H27.5a8.351,8.351,0,0,1,1.355.056,3.99,3.99,0,0,1,.857.247,8.409,8.409,0,0,1,1.179.675L35.1,39.241c1.6,1,2.4,1.507,3.056,1.453a2,2,0,0,0,1.445-.806C40,39.354,40,38.407,40,36.511V23.987c0-1.9,0-2.843-.394-3.377A2,2,0,0,0,38.16,19.8c-0.659-.053-1.458.449-3.056,1.453h0Zm11.459,9.913H43.438A1.446,1.446,0,0,1,42,29.726h0a1.446,1.446,0,0,1,1.438-1.446h3.125A1.446,1.446,0,0,1,48,29.726h0A1.446,1.446,0,0,1,46.563,31.171Zm0.1-9.706-2.21,2.222a1.436,1.436,0,0,1-2.033,0h0a1.456,1.456,0,0,1,0-2.045l2.21-2.222a1.436,1.436,0,0,1,2.033,0h0A1.456,1.456,0,0,1,46.662,21.465ZM44.629,40.03l-2.21-2.222a1.456,1.456,0,0,1,0-2.045h0a1.436,1.436,0,0,1,2.033,0l2.21,2.222a1.456,1.456,0,0,1,0,2.045h0A1.436,1.436,0,0,1,44.629,40.03Z"/>
                                                </svg>
                                        </div>
                                        <div class="hideoverflowfeed namespacing datafontsize prescription_data">
                                         <xsl:value-of select="$event_descr" />
                                        </div>
                                        <div class=" align-imgtext rightcol-spacing">
                                           <div class="headerfontsize">
                                                AL: <xsl:value-of select="$actual_ly" />
                                            </div>
                                            <div class="headerfontsize">
                                               PC: <xsl:value-of select="$plan_cy" />
                                            </div>
                                            <div class="headerfontsize">
                                               AC: <xsl:value-of select="$target_nos" />
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                                <div class="prescription_btm_border"></div>
							</xsl:if>
							
						</xsl:if>
						
					</xsl:for-each>	
            </div>	
				<!--</tbody>
			</TABLE>-->

		<!-- Item Details end -->

	</xsl:template>
 
<xsl:template name="tmpSplitString">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>
		
				 <xsl:variable name="host_url">
						<xsl:for-each select="//Detail1">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:value-of select="host_url" />
								</xsl:if>
							</xsl:for-each>
				</xsl:variable>


		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)])" />
			</xsl:variable>
			
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

			
                 <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($doc_listed_cnt)" />
                    Doctor's Details
                </div>

               <div class="containertable">
                   <div class="doctorcontainer"><!-- container starts -->
                        <div class="headerfontsize doctordetails textcolor">
                            <div class="headingwidth firstcolumn doctorDiv">DOCTOR NAME</div>
                            <div class="headingwidth localityDiv">SC Code</div>
                            <div class="headingwidth specialityDiv">Speciality</div>
                            <div class="headingwidth stateDiv"> Total Actual Last Year</div>                           
                            <div class="headingwidth qualificationDiv">Total Plan Current Year</div>
                            <div class="headingwidth specialityDiv">Total Actual Last Year</div>
                            <div class="headingwidth brandsDiv lastcolumn">Class Code</div>
                        </div>
					 <xsl:for-each
							select="//node()[starts-with(name(), $detail)]">

							<xsl:if test="attribute/@updateFlag!='D'">
								
								<xsl:variable name="doctor_name">
									<xsl:value-of select="doctor_name" />
								</xsl:variable>
								
                                  
									<xsl:variable name="sc_code">
										<xsl:value-of select="sc_code" />
									</xsl:variable>
									
									<xsl:variable name="speciality">
										<xsl:value-of select="speciality" />
									</xsl:variable>
									
									<xsl:variable name="total_actual_ly">
										<xsl:value-of select="total_actual_ly" />
									</xsl:variable>
									<xsl:variable name="total_plan_cy">
										<xsl:value-of select="total_plan_cy" />
									</xsl:variable>
									
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									
									<xsl:variable name="total_target_nos">
										<xsl:value-of select="total_target_nos" />
									</xsl:variable>
									
									<xsl:variable name="class_code">
										<xsl:value-of select="class_code" />
									</xsl:variable>
									
									<xsl:variable name="so_visit">
										<xsl:value-of select="so_visit" />
									</xsl:variable>
									
									<xsl:variable name="locality">
										<xsl:value-of select="locality" />
									</xsl:variable>
									
									<xsl:variable name="category">
										<xsl:value-of select="category" />
									</xsl:variable>
									
									<xsl:variable name="bussiness_to_us">
										<xsl:value-of select="bussiness_to_us" />
									</xsl:variable>
									 
									   
									<xsl:call-template name="tmpOrder">
										<xsl:with-param name="orderFormName"
											select="concat($host_url,'@',$doctor_name,'#',$sc_code,'*',$speciality,'!',$locality,'^',$total_actual_ly,'**',$total_target_nos,'@@',$class_code,'$#',$detail,'####',$category,'#####',$bussiness_to_us)" />
									</xsl:call-template>
									
							 </xsl:if>
					   </xsl:for-each>
                  </div>
          </div>
					<!--</TABLE>
				</details>-->
	    </xsl:if>

			
 </xsl:if>

	
	</xsl:template>
	
<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="doctor_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_sc_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '*')" />
		</xsl:variable>
		
		<xsl:variable name="doc_speciality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '^')" />
		</xsl:variable>
		
		<xsl:variable name="total_target_nos">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'@@')" />
		</xsl:variable>
		
		<xsl:variable name="total_actual_ly">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'**')" />
		</xsl:variable>
	
	   <xsl:variable name="bussiness_to_us">
			<xsl:value-of
				select="substring-after($ord_value,'#####')" />
		</xsl:variable>

		
	 
	 	<xsl:variable name="doc_class_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'$#')" />
		</xsl:variable>
		
		 <xsl:variable name="category">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'#####')" />
		</xsl:variable>
		
		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'####')" />

		</xsl:variable>

		
		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][2]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>


		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail',$item_form_no)" />
		</xsl:variable>
		
		
		<xsl:variable name="item_listed_count">
			<xsl:if test="normalize-space($item_form_no)!=''">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_sc_code">
							<xsl:value-of select="sc_code" />
						</xsl:variable>
						   <xsl:if
							test="normalize-space($item_sc_code) = normalize-space($doc_sc_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if> 
					</xsl:if>
				</xsl:for-each>
				
			</xsl:if>
		</xsl:variable>
		<!-- Item Details End -->


		</xsl:template>
	
	
  
</xsl:stylesheet>