<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--<xsl:output method="html" indent="no" version="4.0" /> -->

	<xsl:output omit-xml-declaration="yes" method="html"
		encoding="utf-8" indent="yes" />


	<xsl:template match="/">
		<html>
			<head>
				<title>Strg Customer Amd</title>
				<script type="text/javascript" src="../js/strg_customer_amd.js"></script>
				<script>
						var calendertop = 100;
						var calenderleft = 700;
						var selectedObj = null;
						var global_date_format ="MM/dd/yy";
						var global_date_type= "date";
						var objCur = "";
						var local_dom_id="";
						
					</script>
		</head>
		
		
	<xsl:for-each select="//DocumentRoot"><xsl:variable name="DEFAULTCOL"><xsl:value-of select="/DOCUMENTROOT/editFlag" /></xsl:variable></xsl:for-each>
	<xsl:for-each select="//Detail1">
		<xsl:variable name="tran_mode"><xsl:value-of select="tran_mode" /></xsl:variable>
		<xsl:variable name="editFlag1"><xsl:value-of select="@editFlag" /></xsl:variable>
		<xsl:variable name="updateFlagHeader"><xsl:value-of select="attribute/@updateFlag" /></xsl:variable>
						<xsl:variable name="confirm"><xsl:value-of select="confirm" /></xsl:variable>
		
     <body onload="windowOnLoad();clickLink();loadHeader();" >
     <style>
		

	@font-face 
	{
    	font-family: "myFirstFont";
    	src: url(../font/GothamRoundedBook.ttf) format("truetype");
	}
* 
{
    box-sizing: border-box;
}

h1, h2, h3, h4, h5, h6 
{
  font-family: myFirstFont, Helvetica, Arial, sans-serif;
}
html 
{
  margin: 0;
  padding: 0;
  height: 100%;
  font-size:100%;
}
body 
{
  font-family: myFirstFont, sans-serif, Arial;
  line-height: 1.8;
  background-color: #fff;
  -webkit-font-smoothing: antialiased;
   font-size: 100%;
  color: #384047;
  font-weight: 400;
  position: relative;
  padding: 0;
  width: 99%;
  min-height: 100vh;
  overflow-x: hidden;
  -webkit-overflow-scrolling: touch;
  -moz-overflow-scrolling: touch;
  -ms-overflow-scrolling: touch;
  -o-overflow-scrolling: touch;
  overflow-scrolling: touch;
  -webkit-font-kerning: auto;
  -moz-font-kerning: auto;
  font-kerning: auto;
  -o-font-kerning: auto;
}
body.preloader-active 
{
  overflow-y: hidden;
  -ms-touch-action: none;
}
.no-js body.preloader-active 
{
  overflow-y: auto;
  -ms-touch-action: auto;
}
* 
{
  font-family: inherit;
}
.organization-form
{
	box-shadow: 0px 0px 10px -3px rgba(0,0,0,0.19);
}
.container
{
	width:70%;
	margin:auto;
	box-shadow: 0px 0px 10px -3px rgba(0,0,0,0.19);
	background:#f7f8fa;
	height:auto;
}
.row
{
	padding:1em;
	margin-top:1em;
}

.row_title
{
	padding:0.5em;
}
.arrow_img{
	width:20px;
	float:right;
}
.row_section
{
	background:#fff;
	height:auto;
    padding: 0.5em;
}
.center
{
	font-size: 1em;
	text-align: left;
	margin-top:0; 
	color:#687285;
}
.cotainer
 {
    -webkit-column-count: 3;
    -moz-column-count: 3;
    column-count: 3;
    position: relative;
   -webkit-column-rule: 1px dashed #e6e6e6;
    -moz-column-rule: 1px dashed #e6e6e6;
    column-rule: 1px dashed #e6e6e6;
}

.heading
{
	font-size: 0.9em;
	text-align: left;
	padding-top: 0.5em;
	padding-left: 0.8em;
	background-color:#fff;
	color: #687285;
}

.circle 
{
  width: 30px;
  height: 30px;
  border-radius: 50%;
  font-size: 12px;
  color: #fff;
  line-height: 30px;
  text-align: center;
  background: #cfbebe;
}

.field_row 
{
    margin-left: auto;
    margin-right: auto;
}
.field_row1 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
    margin: 0em 0 1em;
}
.field_row2 
{
   
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
    margin: 0em 0 1em;
	padding-bottom:1em;
}
.field_row3 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
        margin: 0em 0 1em;
}
.field_row4 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
        margin: 0em 0 1em;
}
.textfield
{
	padding:0;
}
.img_field
{
	width: 7%;
	float:left;
	margin: 0.5em;
    margin-top: 1.2em;
}
.inputfield
{
	width: 98%;
	margin:auto;
	border-bottom:none;
}
input::placeholder 
{
  color: #ccc;
  font-size:0.8rem !important;
  
}
::-webkit-input-placeholder 
{ /* Chrome/Opera/Safari */  color: #ccc;font-size:0.8rem !important; 
} ::-moz-placeholder { /* Firefox 19+ */  color: #ccc;font-size:0.8rem !important; }
 
.styled-input
 {
  position: relative;
}

.styled-input label
 {
    color: #666666;
	/*color:#9e9e9e;*/
    position: absolute;
    top: 0.6rem;
    left: 1px;
    height: 100%;
    font-size: 1rem;
    cursor: text;
    -webkit-transform-origin: 0% 100%;
    transform-origin: 0% 100%;
    text-align: initial;
    -webkit-transform: translateY(13px);
    transform: translateY(13px);
    pointer-events: none;
	width: 93%;
    float: left;
}

.styled-input.wide 
{ 
	width: 100%;
}

input,
textarea 
{
 background-color: transparent;
    border: none;
    border-bottom: 1px solid #dadada;
    border-radius: 0;
    outline: none;
    height: 1.5rem;
    width: 100%;
    font-size: 1rem;
    margin: 0 0 2px 0;
    padding: 22px 1px 0px;
    -webkit-box-shadow: none;
    box-shadow: none;
    -webkit-box-sizing: content-box;
    box-sizing: content-box;
    -webkit-transition: all 0.3s;
    transition: all 0.3s;
    color: #000;
}

input ~ span,
textarea ~ span
 {
    display: block;
    width: 0;
    height: 3px;
    position: absolute;
    bottom: 0;
    left: 0;
    -webkit-transition: all 0.125s ease;
    transition: all 0.125s ease;
    font-size: 0.75em;
    color: #fd3e19;
    font-weight: 400;
	padding: 8px 0 0;
    
}

input:focus,
textarea:focus { outline: 0;}

input:focus ~ span,
textarea:focus ~ span {
  width: 99%;
  -webkit-transition: all 0.075s ease;
  transition: all 0.075s ease;
   
}

input[type=text]:focus:not([readonly])
 {
            border-bottom: 1px solid #fda786;
}
label.active 
{
    transform-origin: 0 0;
    transform: translateY(-0.4rem) scale(0.75);
    -webkit-transform: translateY(-0.4rem) scale(0.75);
    -webkit-transform-origin: 0 0;
}

textarea {
  width: 99%;
  min-height: 15em;
}
.right_arrow 
{
position: absolute;
padding: 10px 3px 5px 14px;
width: 35px;
height: 32px;
vertical-align: bottom;
right: 0;
bottom: 0;
cursor: pointer;
}


.galaxyButton {
    border: 1px solid #e7e7e7;
	border-radius: 2px;
	-moz-border-radius: 2px;
	-webkit-border-radius: 2px;
	-moz-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	-webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	color: #333;
	height: 22px;
	font-size: 12px;
	background-color: #e7e7e7;
	background: #e7e7e7;
	cursor: pointer;
	margin-right: 10px;
	width: auto;
	padding: 2px;
}


/*switch button*/
*,*:before,*:after{
box-sizing:border-box;
margin:0;
padding:0;
/*transition*/
-webkit-transition:.25s ease-in-out;
   -moz-transition:.25s ease-in-out;
     -o-transition:.25s ease-in-out;
        transition:.25s ease-in-out;
outline:none;

}
body{
background:#f1f1f1;
}
h1{
margin:75px auto 0 auto;
text-align:center;
font-weight:200;
color:#4b4b4b;
}
#toggles{
    width: 60px;
    margin: 0.8em;
    text-align: center;
    float: right;
}
.ios-toggle,.ios-toggle:active{
position:absolute;
top:-5000px;
height:0;
width:0;
opacity:0;
border:none;
outline:none;
}
.checkbox-label {
    display: block;
    position: relative;
    padding: 7px;
    margin-bottom: 15px;
    font-size: 12px;
    line-height: 10px;
    width: 100%;
    height: 31px;
    -webkit-border-radius: 18px;
    -moz-border-radius: 18px;
    border-radius: 18px;
    background: #f8f8f8;
    cursor: pointer;
}
.checkbox-label:before{
content:'';
display:block;
position:absolute;
z-index:1;
line-height:34px;
text-indent:40px;
height:25px;
width:25px;
/*border-radius*/
-webkit-border-radius:100%;
   -moz-border-radius:100%;
        border-radius:100%;
top:3px;
left:4px;
right:auto;
background:white;
/*box-shadow*/
-webkit-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
   -moz-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
        box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
}
.checkbox-label:after{
content:attr(data-off);
display:block;
position:absolute;
z-index:1;
top:0;
left:-268px;
padding:10px;
height:100%;
width:300px;
text-align:right;
color:#bfbfbf;
white-space:nowrap;
}
.ios-toggle:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
.ios-toggle:checked + .checkbox-label:before{
left:calc(100% - 28px);
/*box-shadow*/
-webkit-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
   -moz-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
        box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
}
.ios-toggle:checked + .checkbox-label:after{
content:attr(data-on);
left:26px;
width:36px;
z-index:9;
}
/* GREEN CHECKBOX */

#checkbox1 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
}
#checkbox1:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
#checkbox1:checked + .checkbox-label:after{
color:rgba(19,191,17,1);
}
/* RED CHECKBOX */

#checkbox2 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
}
#checkbox2:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
   -moz-box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
        box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
}
#checkbox2:checked + .checkbox-label:after{
color:#000;
}
/* BLUE CHECKBOX */

#checkbox3 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
}
#checkbox3:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
   -moz-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
        box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
}
#checkbox3:checked + .checkbox-label:after{
color:#1fc1c8;
}


/*On off button*/
*,*:before,*:after{
box-sizing:border-box;
margin:0;
padding:0;
/*transition*/
-webkit-transition:.25s ease-in-out;
   -moz-transition:.25s ease-in-out;
     -o-transition:.25s ease-in-out;
        transition:.25s ease-in-out;
outline:none;

}
body{
background:#f1f1f1;
}
h1{
margin:75px auto 0 auto;
text-align:center;
font-weight:200;
color:#4b4b4b;
}
#toggles_on_off{
    width: 60px;
    margin: 0.8em;
    text-align: center;
    float: right;
}
.ios-toggle_on_off,.ios-toggle_on_off:active{
position:absolute;
top:-5000px;
height:0;
width:0;
opacity:0;
border:none;
outline:none;
}
.checkbox-label_on {
    display: block;
    position: relative;
    padding: 7px;
    margin-bottom: 15px;
    font-size: 12px;
    line-height: 10px;
    width: 100%;
    height: 31px;
   
    background: #f8f8f8;
    cursor: pointer;
}
.checkbox-label_on:before{
content:'';
display:block;
position:absolute;
z-index:1;
line-height:34px;
text-indent:40px;
height:25px;
width:25px;
top:3px;
left:4px;
right:auto;
background:white;
/*box-shadow*/
-webkit-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
   -moz-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
        box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
}
.checkbox-label_on:after{
content:attr(data-off);
display:block;
position:absolute;
z-index:1;
top:0;
left:-268px;
padding:10px;
height:100%;
width:304px;
text-align:right;
color:#bfbfbf;
white-space:nowrap;
}
.ios-toggle_on_off:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
.ios-toggle_on_off:checked + .checkbox-label_on:before{
left:calc(100% - 28px);
/*box-shadow*/
-webkit-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
   -moz-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
        box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
}
.ios-toggle_on_off:checked + .checkbox-label_on:after{
content:attr(data-on);
left:26px;
width:36px;
z-index:9;
}
/* GREEN CHECKBOX */

#checkbox_on+ .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
}
#checkbox_on:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
#checkbox_on:checked + .checkbox-label_on:after{
color:rgba(19,191,17,1);
}
/* RED CHECKBOX */

#checkbox_on + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
}
#checkbox_on:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
   -moz-box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
        box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
}
#checkbox_on:checked + .checkbox-label_on:after{
color:#000;
}
/* BLUE CHECKBOX */

#checkbox3 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
}
#checkbox3:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
   -moz-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
        box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
}
#checkbox3:checked + .checkbox-label:after{
color:#1fc1c8;
}



/*select field*/
.selectoption {
    display: block;
    background: white;
    outline: none;
    -moz-outline: none;
    outline-color: transparent;
    font-weight: lighter;
    font-size: small;
    box-sizing: border-box;
    position: relative;
    background-color: transparent;
    border: 1px solid;
    border-top-color: #fff;
    border-left-color: #fff;
    border-right-color: #fff;
    border-bottom-color: #ccc;
    border-radius: 0;
    -webkit-appearance: menulist !important;
    padding-top:2em;
	width:100%;
}

/*map*/
.map{
    border: 1px solid #ccc;
    height: 150px;
	width:97%;
	}
	
/*Tooltip*/
.error:after{content: "?"; color: red;position: relative;
    display: inline-block;}
	
.error:after .tooltiptext {
    visibility: hidden;
    width: 120px;
    background-color: black;
    color: #fff;
    text-align: center;
    border-radius: 6px;
    padding: 5px 0;

    /* Position the tooltip */
    position: absolute;
    z-index: 1;
}

.error:after :hover .tooltiptext {
    visibility: visible;
}

.tooltip {
    position: relative;
    display: inline-block;
    border-bottom: 1px dotted black;
}

.tooltip .tooltiptext {
    visibility: hidden;
    width: 120px;
    background-color: black;
    color: #fff;
    text-align: center;
    border-radius: 6px;
    padding: 5px 0;

    /* Position the tooltip */
    position: absolute;
    z-index: 1;
}

.tooltip:hover .tooltiptext {
    visibility: visible;
}


/*checkbox*/
input[type=checkbox]{
	    width: 4%;
		vertical-align: middle;
		font-size:0.75em;
}


/*3 column */

#pagewrap {
	padding: 5px;
	width: 100%;
}

#content {
	width: 33%;
	float: left;
	padding: 5px;
}

#middle {
	width: 33%; /* Account for margins + border values */
	float: left;
	padding: 5px;
	margin: 0px 5px 5px 5px;
}

#sidebar {
	width: 32%;
	padding: 5px;
	float: left;
}


/************************************************************************************
MEDIA QUERIES
*************************************************************************************/
/* for 980px or less */
@media screen and (max-width: 980px) {
	
	#pagewrap {
		width: 94%;
	}
	#content {
		width: 41%;
		padding: 1% 4%;
	}
	#middle {
		width: 41%;
		padding: 1% 4%;
		margin: 0px 0px 5px 5px;
		float: right;
	}
	
	#sidebar {
		clear: both;
		padding: 1% 4%;
		width: auto;
		float: none;
	}

	
}

/* for 700px or less */
@media screen and (max-width: 600px) {

	#content {
		width: auto;
		float: none;
	}
	
	#middle {
		width: auto;
		float: none;
		margin-left: 0px;
	}
	
	#sidebar {
		width: auto;
		float: none;
	}

}

/* for 480px or less */
@media screen and (max-width: 480px) {

	
	#sidebar {
		display: none;
	}

}


#content, #middle, #sidebar {
	margin-bottom: 5px;
}

<!-- Add for toogle button -->
.toggle {
  -webkit-appearance: none;
  appearance: none;
  width: 62px;
  height: 32px;
  display: inline-block;
  position: relative;
  border-radius: 50px;
  overflow: hidden;
  outline: none;
  border: none;
  cursor: pointer;
  background-color: #a2a2a2;
  transition: background-color ease 0.3s;
}

.toggle:before {
  content: "yes no";
  display: block;
  position: absolute;
  z-index: 2;
  width: 28px;
  height: 28px;
  background: #fff;
  left: 2px;
  top: 2px;
  border-radius: 50%;
  font: 10px/28px Helvetica;
  text-transform: uppercase;
  font-weight: bold;
  text-indent: -22px;
  word-spacing: 37px;
  color: #fff;
  text-shadow: -1px -1px rgba(0,0,0,0.15);
  white-space: nowrap;
  box-shadow: 0 1px 2px rgba(0,0,0,0.2);
  transition: all cubic-bezier(0.3, 1.5, 0.7, 1) 0.3s;
}

.toggle:checked {
}

.toggle:checked:before {
  left: 32px;
}

	</style>   
	
<script src="/ibase/E12BROWSER/js/jquery-1.11.1.min.js"></script>
<script src="/ibase/E12BROWSER/js/expandy.min.js"></script>
<script><![CDATA[
    $('[id^="container"').makeExpander({
	toggleElement : 'h2',
	jqAnim : true,
	showFirst : false,
	accordion : true,
	speed : 400
	/*indicator: 'triangle'*/
    });
    
    
    window.onload = function() 
    {
		var themeColor = localStorage.getItem('themeColor');
  		if(document.getElementById("Detail1.1.first_name")!=null && document.getElementById("Detail1.1.first_name_ca").value!="" )
  		{
  			document.getElementById("Detail1.1.first_name").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.middle_name")!=null && document.getElementById("Detail1.1.middle_name_ca").value!="")
  		{
  			document.getElementById("Detail1.1.middle_name").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.last_name")!=null && document.getElementById("Detail1.1.last_name_ca").value!="")
  		{
  			 document.getElementById("Detail1.1.last_name").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.locality_code")!=null && document.getElementById("Detail1.1.locality_code_ca").value!="")
  		{
  			 document.getElementById("Detail1.1.locality_code").style.setProperty("text-decoration", "line-through");
  		}	
  		if(document.getElementById("Detail1.1.addr1")!=null && document.getElementById("Detail1.1.addr1_ca").value!="")
  		{
  			document.getElementById("Detail1.1.addr1").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.addr2")!=null && document.getElementById("Detail1.1.addr2_ca").value!="")
  		{
  			document.getElementById("Detail1.1.addr2").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.addr3")!=null && document.getElementById("Detail1.1.addr3_ca").value!="")
  		{
  			document.getElementById("Detail1.1.addr3").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.qualification")!=null && document.getElementById("Detail1.1.qualification_ca").value!="")
  		{
  			document.getElementById("Detail1.1.qualification").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.pin")!=null && document.getElementById("Detail1.1.pin_ca").value!="")
  		{
  			document.getElementById("Detail1.1.pin").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.mobile_no")!=null && document.getElementById("Detail1.1.mobile_no_ca").value!="")
  		{
  			document.getElementById("Detail1.1.mobile_no").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.email_addr")!=null && document.getElementById("Detail1.1.email_addr_ca").value!="")
  		{
  			document.getElementById("Detail1.1.email_addr").style.setProperty("text-decoration", "line-through");
  		}
  		if(document.getElementById("Detail1.1.confirm")!=null && document.getElementById("Detail1.1.confirm").value!="" && document.getElementById("Detail1.1.confirm").value=="Y" )
  		{
			document.getElementById("Detail1.1.confirm").style.setProperty("background-color", themeColor);
  		}

	};
]]></script>
	<form name="form1" method="POST" action="" style="width:98%;margin:1em auto;-webkit-box-shadow: 0 0 2px #ccc;-moz-box-shadow: 0 0 2px #ccc;">
		<div class="heading">
			<xsl:choose>
			<xsl:when  test="$updateFlagHeader ='A'"> 
  			<table width="100%" border="0" cellspacing="0" cellpadding="0" >
  				<tr>
					<td style="text-align:right;padding-right:0.5em;">
						<div class="heading" style="text-align: right;">
						<div style="text-align:right;display: inline-block;" class="buttondata">
						<button type="button" value="Save" class="galaxyButton" id="Save" onclick="return saveData(this)">Save</button>
						<button type="button" value="Close" class="galaxyButton" onclick="closeWindow();">Close</button></div>
						</div>
					</td>
				</tr>
  			</table>
			</xsl:when>
			<xsl:otherwise>
			<table  width="100%" border="0" cellspacing="0" cellpadding="0" >
  				<tr>
					<td style="text-align:right;padding-right:0.5em;">
						<div class="heading" style="text-align: right;">
						<div style="text-align:right;display: inline-block;" class="buttondata">
						
						<xsl:choose>
						<xsl:when  test="$confirm !='Y'"> 
						<button type="button" value="Save" class="galaxyButton" id="Save" onclick="saveData(this)">Save</button>
						</xsl:when>
						</xsl:choose>
						<button type="button" value="Close" class="galaxyButton" onclick="closeWindow();">Close</button>
						</div>
						</div>
					</td>
				</tr>
			</table>
			</xsl:otherwise>
			</xsl:choose>

		</div>
					
		<div id="mainDiv">
			<div id="tranDiv">
				<table height="208" border="0" align="center" class="" id="headerTable"  >
				<xsl:variable name="domIDHeader"><xsl:value-of select="@domID" /></xsl:variable>
				<xsl:variable name="statusHeader"><xsl:value-of select="attribute/@status" /></xsl:variable>
				<xsl:variable name="dbIDHeader"><xsl:value-of select="@dbID" /></xsl:variable>
				<xsl:variable name="pkNamesHeader"><xsl:value-of select="attribute/@pkNames" /></xsl:variable>
				<xsl:variable name="objNameHeader"><xsl:value-of select="@objName" /></xsl:variable>
				<xsl:variable name="editFlag"><xsl:value-of select="editFlag" /></xsl:variable>
				<xsl:variable name="chg_date"><xsl:value-of select="chg_date" /></xsl:variable>
				<xsl:variable name="chg_user"><xsl:value-of select="chg_user" /></xsl:variable>
				<xsl:variable name="chg_term"><xsl:value-of select="chg_term" /></xsl:variable>
				<xsl:variable name="sc_code"><xsl:value-of select="sc_code" /></xsl:variable>
				<xsl:variable name="first_name"><xsl:value-of select="first_name" /></xsl:variable>
				<xsl:variable name="middle_name"><xsl:value-of select="middle_name" /></xsl:variable>
				<xsl:variable name="last_name"><xsl:value-of select="last_name" /></xsl:variable>
				<xsl:variable name="first_name_ca"><xsl:value-of select="first_name_ca" /></xsl:variable>
				<xsl:variable name="middle_name_ca"><xsl:value-of select="middle_name_ca" /></xsl:variable>
				<xsl:variable name="last_name_ca"><xsl:value-of select="last_name_ca" /></xsl:variable>
				<xsl:variable name="addr1"><xsl:value-of select="addr1" /></xsl:variable>
				<xsl:variable name="addr2"><xsl:value-of select="addr2" /></xsl:variable>
				<xsl:variable name="addr3"><xsl:value-of select="addr3" /></xsl:variable>
				<xsl:variable name="addr1_ca"><xsl:value-of select="addr1_ca" /></xsl:variable>
				<xsl:variable name="addr2_ca"><xsl:value-of select="addr2_ca" /></xsl:variable>
				<xsl:variable name="addr3_ca"><xsl:value-of select="addr3_ca" /></xsl:variable>
				<xsl:variable name="qualification"><xsl:value-of select="qualification" /></xsl:variable>
				<xsl:variable name="qualification_ca"><xsl:value-of select="qualification_ca" /></xsl:variable>
				<xsl:variable name="sc_code"><xsl:value-of select="sc_code" /></xsl:variable>
				<xsl:variable name="city"><xsl:value-of select="city" /></xsl:variable>
				<xsl:variable name="city_ca"><xsl:value-of select="city_ca" /></xsl:variable>
				<xsl:variable name="pin"><xsl:value-of select="pin" /></xsl:variable>
				<xsl:variable name="pin_ca"><xsl:value-of select="pin_ca" /></xsl:variable>
                <xsl:variable name="attach_id"><xsl:value-of select="attach_id" /></xsl:variable>
				<xsl:variable name="mobile_no"><xsl:value-of select="mobile_no" /></xsl:variable>
				<xsl:variable name="mobile_no_ca"><xsl:value-of select="mobile_no_ca" /></xsl:variable>
				<xsl:variable name="email_addr"><xsl:value-of select="email_addr" /></xsl:variable>
				<xsl:variable name="email_addr_ca"><xsl:value-of select="email_addr_ca" /></xsl:variable>
				<xsl:variable name="address_as"><xsl:value-of select="address_as" /></xsl:variable>
				<xsl:variable name="stan_code"><xsl:value-of select="stan_code" /></xsl:variable>
				<xsl:variable name="state_code"><xsl:value-of select="state_code" /></xsl:variable>
				<xsl:variable name="acct_code__ap"><xsl:value-of select="acct_code__ap" /></xsl:variable>
				<xsl:variable name="cctr_code__ap"><xsl:value-of select="cctr_code__ap" /></xsl:variable>
				<xsl:variable name="count_code"><xsl:value-of select="count_code" /></xsl:variable>
				<xsl:variable name="status"><xsl:value-of select="status" /></xsl:variable>
				<xsl:variable name="tran_id"><xsl:value-of select="tran_id" /></xsl:variable>
				<xsl:variable name="sex"><xsl:value-of select="sex" /></xsl:variable>
				<xsl:variable name="locality_code"><xsl:value-of select="locality_code" /></xsl:variable>
				<xsl:variable name="strg_cust__initiator"><xsl:value-of select="strg_cust__initiator" /></xsl:variable>
				<xsl:variable name="initiator"><xsl:value-of select="initiator" /></xsl:variable>
				<xsl:variable name="locality_code_ca"><xsl:value-of select="locality_code_ca" /></xsl:variable>
				<xsl:variable name="stan_code_ca"><xsl:value-of select="stan_code_ca" /></xsl:variable>
				<xsl:variable name="state_code_ca"><xsl:value-of select="state_code_ca" /></xsl:variable>
				<xsl:variable name="count_code_ca"><xsl:value-of select="count_code_ca" /></xsl:variable>
				<xsl:variable name="district_off_ca"><xsl:value-of select="district_off_ca" /></xsl:variable>
				<xsl:variable name="emp_ho"><xsl:value-of select="emp_ho" /></xsl:variable>
				<xsl:variable name="item_ser"><xsl:value-of select="item_ser" /></xsl:variable>

				<input type="hidden" value="{$dbIDHeader}" name="Detail1.{normalize-space($domIDHeader)}.dbID" id="Detail1.{normalize-space($domIDHeader)}.dbID" />
				<input type="hidden" value="{$objNameHeader}" name="Detail1.{normalize-space($domIDHeader)}.objName" id="Detail1.{normalize-space($domIDHeader)}.objName" />
				<input type="hidden" value="{$pkNamesHeader}" name="Detail1.{normalize-space($domIDHeader)}.pkNames" id="Detail1.{normalize-space($domIDHeader)}.pkNames" />
				<input type="hidden" value="{$updateFlagHeader}" name="Detail1.{normalize-space($domIDHeader)}.updateFlag" id="Detail1.{normalize-space($domIDHeader)}.updateFlag" />
				<input type="hidden" value="{$updateFlagHeader}" name="updateFlag" id="Detail1.{normalize-space($domIDHeader)}.updateFlag" />
				<input type="hidden" value="{$objNameHeader}" name="OBJ_NAME" id="OBJ_NAME" />
				<input type="hidden" value="{$dbIDHeader}" name="pkValues" id="pkValues" />
				<input type="hidden" value="{$editFlag}" name="Detail1.{normalize-space($domIDHeader)}.editFlag" id="Detail1.{normalize-space($domIDHeader)}.editFlag" />
				<input type="hidden" value="{$editFlag1}" name="Detail1.{normalize-space($domIDHeader)}.editFlag" id="Detail1.{normalize-space($domIDHeader)}.editFlag" />
				<div style="overflow:auto;" id="mainDiv">
				
				<table id="headerTable" style="height:100%; font-size :12px;color:black; overflow:auto; background:#FFF; padding: 5px 0; padding:0px;" cellspacing="0" cellpadding="0" border="0" align="center" class="question1">
				
				
				<input type="hidden" style="width:250px;" id="Detail1.{normalize-space($domIDHeader)}.tran_id" name="Detail1.{normalize-space($domIDHeader)}.tran_id" value="{$tran_id}" ispopup="true" class="headerInputField" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"  maxlength="10"  tabindex="0" required="true"/>
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator" name="Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator" value="{$strg_cust__initiator}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator')" tabindex="65" required="true" />
				<!-- <input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.locality_code" name="Detail1.{normalize-space($domIDHeader)}.locality_code" value="{$locality_code}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.locality_code')" tabindex="65" required="true" /> -->
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.initiator" name="Detail1.{normalize-space($domIDHeader)}.initiator" value="{$initiator}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.initiator')" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.address_as" name="Detail1.{normalize-space($domIDHeader)}.address_as" value="{$address_as}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.address_as')" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.stan_code" name="Detail1.{normalize-space($domIDHeader)}.stan_code" value="{$stan_code}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.state_code" name="Detail1.{normalize-space($domIDHeader)}.state_code" value="{$state_code}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.count_code" name="Detail1.{normalize-space($domIDHeader)}.count_code" value="{$count_code}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.status" name="Detail1.{normalize-space($domIDHeader)}.status" value="{$status}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"  maxlength="5" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.sex" name="Detail1.{normalize-space($domIDHeader)}.sex" value="{$sex}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.chg_date" name="Detail1.{normalize-space($domIDHeader)}.chg_date" value="{$chg_date}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.chg_date')" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.chg_user" name="Detail1.{normalize-space($domIDHeader)}.chg_user" value="{$chg_user}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.chg_user')" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.chg_term" name="Detail1.{normalize-space($domIDHeader)}.chg_term" value="{$chg_term}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.chg_term')" tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.acct_code__ap" name="Detail1.{normalize-space($domIDHeader)}.acct_code__ap" value="{$acct_code__ap}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.cctr_code__ap" name="Detail1.{normalize-space($domIDHeader)}.cctr_code__ap" value="{$cctr_code__ap}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.emp_ho" name="Detail1.{normalize-space($domIDHeader)}.emp_ho" value="{$emp_ho}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.item_ser" name="Detail1.{normalize-space($domIDHeader)}.item_ser" value="{$item_ser}" ispopup="true" class="headerInputField"  isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  required="true" />
				
<!-- 				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.stan_code_ca" name="Detail1.{normalize-space($domIDHeader)}.stan_code_ca" value="{$stan_code_ca}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.state_code_ca" name="Detail1.{normalize-space($domIDHeader)}.state_code_ca" value="{$state_code_ca}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.count_code_ca" name="Detail1.{normalize-space($domIDHeader)}.count_code_ca" value="{$count_code_ca}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.district_off_ca" name="Detail1.{normalize-space($domIDHeader)}.district_off_ca" value="{$district_off_ca}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
 -->																						
					<div class="section_column">
					<div class="row_section" id="row_section1">
                          	 <div class="field_row1">
                              <div class="inputfield">
                               <div class="styled-input">
                               
                                        <xsl:choose>
                                        <xsl:when test="$sc_code = ''">
                                    	<input  type="text" id="Detail1.{normalize-space($domIDHeader)}.sc_code" name="Detail1.{normalize-space($domIDHeader)}.sc_code" value="{$sc_code}" ispopup="true" class="headerInputField" onFocus="gotFocus(this,this.id)" onblur="gotBlur(this)" isServerCallOnChange="true" size="40"  maxlength="10" onkeyup="getAutocompleteData(this,'PopUpIcon');" MINLENGTHAUTO="3" HELPOPTION="2" tabindex="10"  required="true"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        <input readonly="true"  type="text" id="Detail1.{normalize-space($domIDHeader)}.sc_code" name="Detail1.{normalize-space($domIDHeader)}.sc_code" value="{$sc_code}" ispopup="true" class="headerInputField" onFocus="gotFocus(this,this.id)" onblur="gotBlur(this)" isServerCallOnChange="true" size="40"  maxlength="10" onkeyup="getAutocompleteData(this,'PopUpIcon');" MINLENGTHAUTO="3" HELPOPTION="2" tabindex="10"  required="true"/>
                                        </xsl:otherwise>
										 </xsl:choose>

										<!-- <input  type="text" id="Detail1.{normalize-space($domIDHeader)}.sc_code" name="Detail1.{normalize-space($domIDHeader)}.sc_code" value="{$sc_code}" ispopup="true" class="headerInputField" onFocus="gotFocus(this,this.id)" onblur="gotBlur(this)" isServerCallOnChange="true" size="40"  maxlength="10" onkeyup="getAutocompleteData(this,'PopUpIcon');" MINLENGTHAUTO="3" HELPOPTION="2" tabindex="10"  required="true"/> -->
										 

                                         <xsl:choose>
										<xsl:when  test="$updateFlagHeader ='A'"> 
										 <label class="" id="sc_code">Strategic Customer</label>
										 </xsl:when>
										 <xsl:otherwise>
										 <label id="sc_code" class="active">Strategic Customer</label>
										 </xsl:otherwise>
										 </xsl:choose>

                                        <xsl:choose>
                                        <xsl:when test="$sc_code = ''">
									    <img src="/ibase/webitm/images/pophelp.png"  style="margin-right:1em;" name="PopUpIcon" id="PopUpIcon" class="pophelp-Btn right_arrow" onclick="getListOfValues(this.id);" border="0" z-index="1"  CUR_POPUP_PARAM="Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator" CUR_FIELD_NAME="Detail1.{normalize-space($domIDHeader)}.sc_code"/>
                                        </xsl:when>
                                        </xsl:choose>
                                        
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                       </div>
					
					<h6 class="heading"> Personal details</h6>
					<div class="row_section cotainer" id="row_section1" >
 						<div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.first_name" name="Detail1.{normalize-space($domIDHeader)}.first_name"  value="{$first_name}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.first_name')" tabindex="0" required="true"    />
                                 <input type="text" id="Detail1.{normalize-space($domIDHeader)}.first_name_ca" name="Detail1.{normalize-space($domIDHeader)}.first_name_ca" value="{$first_name_ca}" ispopup="true" class="textfield" placeholder="Enter New First Name " onkeydown="return onKeyDownFun(this,event)"  maxlength="25" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.first_name_ca');" size="12"   onkeyup="" tabindex="20" required="true" />
                                 <xsl:choose>
									<xsl:when  test="$updateFlagHeader ='A'"> 
                                    	<label class="" id="first_name_ca">First Name</label>
									</xsl:when>
									<xsl:otherwise>
                                    	<label class="active">First Name</label>
									</xsl:otherwise>
								</xsl:choose>
                                    <span></span>
                                 </div>
                              </div>
                           </div>					
							<div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
									<input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.middle_name" name="Detail1.{normalize-space($domIDHeader)}.middle_name" value="{$middle_name}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.middle_name')" tabindex="0" required="true"  />
                                   	<input type="text" id="Detail1.{normalize-space($domIDHeader)}.middle_name_ca" name="Detail1.{normalize-space($domIDHeader)}.middle_name_ca" value="{$middle_name_ca}" ispopup="true" class="textfield"  placeholder="Enter New Middle Name " onkeydown="return onKeyDownFun(this,event)" maxlength="25" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.middle_name_ca');" size="12"   onkeyup="" tabindex="30" required="true" />
                                   <xsl:choose>
									<xsl:when  test="$updateFlagHeader ='A'"> 
                                    	<label class="" id="middle_name_ca">Middle Name</label>
									</xsl:when>
									<xsl:otherwise>
                                    	<label class="active" >Middle Name</label>
									</xsl:otherwise>
								</xsl:choose>
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                           
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.last_name" name="Detail1.{normalize-space($domIDHeader)}.last_name" value="{$last_name}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" maxlength="25" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.last_name')" tabindex="0" required="true"/>
                                 <input type="text" id="Detail1.{normalize-space($domIDHeader)}.last_name_ca" placeholder="Enter New Last Name " name="Detail1.{normalize-space($domIDHeader)}.last_name_ca" value="{$last_name_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" maxlength="25" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.last_name_ca');" size="12"   onkeyup="" tabindex="40" required="true"/>
                                    <xsl:choose>
									<xsl:when  test="$updateFlagHeader ='A'"> 
                                    <label class="" id="last_name_ca">Last Name</label>
									</xsl:when>
									<xsl:otherwise>
                                    <label class="active">Last Name</label>
									</xsl:otherwise>
								</xsl:choose>
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                           
                            <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.qualification" name="Detail1.{normalize-space($domIDHeader)}.qualification" value="{$qualification}" ispopup="true"  maxlength="40" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.qualification')" tabindex="0" required="true" />														
                                 <input type="text"  placeholder="Enter New Qualification" id="Detail1.{normalize-space($domIDHeader)}.qualification_ca" maxlength="40" name="Detail1.{normalize-space($domIDHeader)}.qualification_ca" value="{$qualification_ca}"  ispopup="true" class="textfield"   onFocus="gotFocus(this,this.id)" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.qualification_ca');" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" MINLENGTHAUTO="3" HELPOPTION="2" size="40"   onkeyup="getAutocompleteData(this,'PopUpIconQual');" tabindex="50" required="true"/>														
                                    <xsl:choose>
										<xsl:when  test="$updateFlagHeader ='A'"> 
											<label class="" id="qualification_ca">Qualification</label>	
										</xsl:when>
										<xsl:otherwise>
											<label id="qualification_ca" class="active">Qualification</label>
										</xsl:otherwise>
									</xsl:choose>
 									<img src="/ibase/webitm/images/pophelp.png" id="PopUpIconQual" name="PopUpIcon" onclick="getListOfValues(this.id);" class="pophelp-Btn right_arrow" border="0" z-index="1" CUR_POPUP_PARAM="" CUR_FIELD_NAME="Detail1.{normalize-space($domIDHeader)}.qualification_ca" />
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                           
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.mobile_no" name="Detail1.{normalize-space($domIDHeader)}.mobile_no" value="{$mobile_no}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.mobile_no')" tabindex="0" required="true" />														
                                 <input type="text"  placeholder="Enter New Mobile Number" id="Detail1.{normalize-space($domIDHeader)}.mobile_no_ca" name="Detail1.{normalize-space($domIDHeader)}.mobile_no_ca" value="{$mobile_no_ca}" ispopup="true"  class="textfield" onkeyup="javascript:return numbersonly(this.id)" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotStrike(this.id)" size="40"  maxlength="10" onsubmit="return validate(this.id)" tabindex="60" required="true"/>														                  
                                    <xsl:choose>
										<xsl:when  test="$updateFlagHeader ='A'"> 
                                    <label class="" id="mobile_no_ca">Mobile No</label>
										</xsl:when>
										<xsl:otherwise>
                                    <label class="active">Mobile No</label>
										</xsl:otherwise>
									</xsl:choose>
                                    
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.email_addr" name="Detail1.{normalize-space($domIDHeader)}.email_addr" value="{$email_addr}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.email_addr')" maxlength="40" tabindex="0" required="true"/>														
                                 <input type="text" id="Detail1.{normalize-space($domIDHeader)}.email_addr_ca" placeholder="Enter New Email Address" name="Detail1.{normalize-space($domIDHeader)}.email_addr_ca" value="{$email_addr_ca}"  ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotStrike(this.id)" size="40"    maxlength="40" tabindex="70" required="true"/>														                                 
                                     <xsl:choose>
										<xsl:when  test="$updateFlagHeader ='A'"> 
                                    <label class="" id="email_addr_ca">Email Address</label>
										</xsl:when>
										<xsl:otherwise>
                                    <label class="active">Email Address</label>
										</xsl:otherwise>
									</xsl:choose>
                                    
                                    <span></span>
                                 </div>
                              </div>
                           </div>
                        </div>
					
						
						<h6 class="heading"> Address</h6>
                        <div class="row_section cotainer" id="row_section1" >
						 
                            <!--<div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.locality_code" maxlength="10" name="Detail1.{normalize-space($domIDHeader)}.locality_code" value="{$locality_code}" ispopup="true" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.locality_code')" tabindex="0" required="true"/>														
                                    <input type="text"  placeholder="Enter New Locality" id="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" maxlength="10" name="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" value="{$locality_code_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotBlur(this);gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.locality_code_ca')" size="40"   onkeyup="getAutocompleteData(this,'PopUpIconLoc');" MINLENGTHAUTO="3" HELPOPTION="2" tabindex="110" required="true"/>														
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="locality_code_ca">Locality Code</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label id="locality_code_ca" class="active" >Locality Code</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <img src="/ibase/webitm/images/pophelp.png" id="PopUpIconLoc" name="PopUpIcon" onclick="getListOfValues(this.id);" class="pophelp-Btn right_arrow" border="0" z-index="1" CUR_POPUP_PARAM="Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator" CUR_FIELD_NAME="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" />
                                        <span></span>
                                    </div>
                                </div>
                            </div>-->
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.addr1" name="Detail1.{normalize-space($domIDHeader)}.addr1" value="{$addr1}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" maxlength="40" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.addr1')" tabindex="0" required="true"  />
                                    <input type="text" id="Detail1.{normalize-space($domIDHeader)}.addr1_ca" placeholder="Enter New Address1" name="Detail1.{normalize-space($domIDHeader)}.addr1_ca" value="{$addr1_ca}" ispopup="true" class="textfield"  onkeydown="return onKeyDownFun(this,event)" maxlength="40" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.addr1_ca');" size="12"   onkeyup="" tabindex="80" required="true"  />
                                    <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="addr1_ca">Address1</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active">Address1</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <span></span>
                                    </div>
                                </div>
                            </div>					
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.addr2" name="Detail1.{normalize-space($domIDHeader)}.addr2" value="{$addr2}" ispopup="true" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" maxlength="40" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.addr2')" tabindex="0" required="true"  />
                                    <input type="text" id="Detail1.{normalize-space($domIDHeader)}.addr2_ca" placeholder="Enter New Address2" name="Detail1.{normalize-space($domIDHeader)}.addr2_ca" value="{$addr2_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" maxlength="40" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.addr2_ca');" size="12"   onkeyup="" tabindex="90" required="true" />
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="addr2_ca">Address2</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active" id="addr2_ca">Address2</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input type="text" disabled="true" id="Detail1.{normalize-space($domIDHeader)}.addr3" name="Detail1.{normalize-space($domIDHeader)}.addr3" value="{$addr3}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" maxlength="40" onblur="return onBlurFunction(this)" size="12"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.addr3')" tabindex="0" required="true" />
                                    <input type="text" id="Detail1.{normalize-space($domIDHeader)}.addr3_ca" placeholder="Enter New Address3" name="Detail1.{normalize-space($domIDHeader)}.addr3_ca" value="{$addr3_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" maxlength="40" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.addr3_ca');" size="12"   onkeyup="" tabindex="100" required="true"  />
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="addr3_ca">Address3</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active">Address3</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            
                                                    
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.locality_code" maxlength="10" name="Detail1.{normalize-space($domIDHeader)}.locality_code" value="{$locality_code}" ispopup="true" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.locality_code')" tabindex="0" required="true"/>														
                                    <input type="text"  placeholder="Enter New Locality" id="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" maxlength="10" name="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" value="{$locality_code_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotBlur(this);gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.locality_code_ca')" size="40"   onkeyup="getAutocompleteData(this,'PopUpIconLoc');" MINLENGTHAUTO="3" HELPOPTION="2" tabindex="110" required="true"/>														
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="locality_code_ca">Locality Code</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label id="locality_code_ca" class="active" >Locality Code</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <img src="/ibase/webitm/images/pophelp.png" id="PopUpIconLoc" name="PopUpIcon" onclick="getListOfValues(this.id);" class="pophelp-Btn right_arrow" border="0" z-index="1" CUR_POPUP_PARAM="Detail1.{normalize-space($domIDHeader)}.strg_cust__initiator" CUR_FIELD_NAME="Detail1.{normalize-space($domIDHeader)}.locality_code_ca" />
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.city" maxlength="40" name="Detail1.{normalize-space($domIDHeader)}.city" value="{$city}" ispopup="true" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.city')" tabindex="0" required="true"/>														
                                    <input type="text"  disabled="true" id="Detail1.{normalize-space($domIDHeader)}.city_ca" maxlength="40" name="Detail1.{normalize-space($domIDHeader)}.city_ca" value="{$city_ca}" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotStrike(this.id);upperCase('Detail1.{normalize-space($domIDHeader)}.city_ca');" size="40"   onkeyup="" tabindex="0" required="true"/>														
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="city_ca">City</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active" >City</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <span></span>
                                    </div>
                                </div>
                            </div>-->
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                    <input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.pin" name="Detail1.{normalize-space($domIDHeader)}.pin" maxlength="10" value="{$pin}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.pin')" tabindex="0" required="true" />														
                                    <input type="text"  placeholder="Enter New Pin Code" id="Detail1.{normalize-space($domIDHeader)}.pin_ca" name="Detail1.{normalize-space($domIDHeader)}.pin_ca" maxlength="10" value="{$pin_ca}" onkeyup="javascript:return numbersonly(this.id)" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotStrike(this.id)" size="40"    tabindex="120" required="true"/>														
                                        <xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="pin_ca">Pin Code</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active">Pin Code</label>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                           
                        </div>

                        <h6 class="heading"> Attachment </h6>
                        <div class="row_section cotainer" id="row_section1" >
                            <div class="field_row1">
                                <div class="inputfield">
                                    <div class="styled-input">
                                        <!--<input disabled="true" type="text"  id="Detail1.{normalize-space($domIDHeader)}.attach_id" name="Detail1.{normalize-space($domIDHeader)}.pin" maxlength="10" value="{$pin}" ispopup="true"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="40"   onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.pin')" tabindex="0" required="true" />												
                                        <input type="text"  placeholder="Enter New Pin Code" id="Detail1.{normalize-space($domIDHeader)}.pin_ca" name="Detail1.{normalize-space($domIDHeader)}.pin_ca" maxlength="10" value="{$pin_ca}" onkeyup="javascript:return numbersonly(this.id)" ispopup="true" class="textfield" onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="gotStrike(this.id)" size="40"    tabindex="120" required="true"/>-->
                                        <img  src ='/ibase/webitm/images/attachment.png' id="Detail1.{normalize-space($domIDHeader)}.attach_id" name="Detail1.{normalize-space($domIDHeader)}.attach_id" style='cursor:pointer;'  title='Add Attachments'  onclick = 'addAttachment({normalize-space($domIDHeader)})'> </img>											
                                        <!--<xsl:choose>
                                            <xsl:when  test="$updateFlagHeader ='A'"> 
                                        <label class="" id="attach_id">Attachment</label>
                                            </xsl:when>
                                            <xsl:otherwise>
                                        <label class="active">Attachment</label>
                                            </xsl:otherwise>
                                        </xsl:choose>-->
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                         <div class="field_row1" style="background-color: #fff;padding-bottom:10px;">
                              <div class="inputfield">
                                 <div class="styled-input" style="display: flex;">
                                 <!--<xsl:choose>
                                 <xsl:when  test="$updateFlagHeader ='A'"> 
                                 <input style="width:62px;padding:0;margin: 0 0 0 52px;" class="toggle" id="Detail1.{normalize-space($domIDHeader)}.confirm" name="Detail1.{normalize-space($domIDHeader)}.confirm" onChange="setConfirmValue(this.checked,this.id)" value="N" type="checkbox" disabled="true"/>
                                 </xsl:when>
								<xsl:otherwise>-->
                                    <xsl:choose>
                                        <xsl:when test="$confirm='Y'">
                                            <input style="width:62px;padding:0;margin: 0 0 0 52px;" class="toggle" id="Detail1.{normalize-space($domIDHeader)}.confirm" name="Detail1.{normalize-space($domIDHeader)}.confirm" onChange="setConfirmValue(this.checked,this.id)" value="Y" checked="true" type="checkbox"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <input style="width:62px;padding:0;margin: 0 0 0 52px;" class="toggle" id="Detail1.{normalize-space($domIDHeader)}.confirm" name="Detail1.{normalize-space($domIDHeader)}.confirm" onChange="setConfirmValue(this.checked,this.id)" value="N" type="checkbox"/>
                                        </xsl:otherwise>
                                    </xsl:choose> 
                                   <!--</xsl:otherwise>
                                   </xsl:choose>-->
                                		<label class="active" style="padding-top:0.5em">Confirm</label>
                                  
                                  <span></span>
                                 </div>
                              </div>
                           </div>
					</div>
					
					 

		
		</table>
 </div>
                                    
		<table id="detailTableDelete" class="deleteRowTable"></table>
</table>
</div>
		<div class="fieldSuggestionDiv" style="display:none" id="fieldSuggestionDiv"></div>
</div>
</form>
					
		<table class="detail3Table" id="detail3Table"></table> 
		<table class="detail3Table" id="detail3Table"></table> 
					
</body>
</xsl:for-each>

		</html>
	</xsl:template>
</xsl:stylesheet>
