<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
		<head>
				<link rel="stylesheet" type="text/css" href="/ibase/webitm/css/summary.css" />
				
				<style>
				
				* 
				{
				font-family: "MuseoLight-300", sans-serif !important;
				}
				.previewContainer
					{
					color: white;
					background: #999b9c;
					opacity: 1;
					/*Commented By Pankaj T. on 09-01-2019 for summary page footer align properly at bottom*/
					/* height: 100% !important; */
					width:calc(100% - 2em) !important;
					}
				/* Container */
				.sum_Container {
					margin: auto;
					height: 100%;
					width:calc(100% - 30px);
					/*Commented By Pankaj T. on 09-01-2019 for summary page footer align properly at bottom*/
					/* height: 460px; */
					min-height: 1px;
					z-index: 2;
					}
					.txtData
					{
					padding-bottom: .1em;
					min-height: 20px;
					line-height: 1;
					width: 100%;
					text-align: left;
					font-size: 15px;
					}

					/* Transaction ID */
					.tran_ID {
					height: 3em;
					color: #fff;
					text-align: center;
					line-height:
					3em;
					}

					/* Summary Content */
					.sum_Content {
					color: #666;
					border-radius: 4px;
					margin: auto;
					overflow-x: hidden;
					overflow-y: auto;
					height:calc(100% - 0.5em);
					font-size: 1em;
					}

					.sum_Header {
					width:
					calc(100% - 2em);
					display:
					inline-flex;
					padding: .8em 1em;
					align-items:
					center;
					background: #fff;

					}

					.sum_Icon {
					height: 1em;
					width: 1em;
					}

					.pdLeft_16 {
					padding-right: 1em;
					}

					.content_BG {
					background: #f2f2f2;
					padding: 16px
					16px;
					}
					.msg-label {
					height: 3em;
					color: #fff;
					text-align: center;
					line-height: 3em;
					}
					.content_Row
					{
					-webkit-column-break-inside: avoid;
					padding: .5em 0 0 0;
					width: 100%;
					display: block;
					border-bottom: 1px solid #e2e2e2;
					align-items: center;

					}

					.table_Row {
					border-bottom: 1px solid #e2e2e2;
					padding: .3em 0;
					align-items: center;
					min-height: 30px;
					display: inline-flex;
					line-height: 1;
					width: 100%;
					}

					.th_Num {
					text-align: right !important;
					padding: 0 3px;	
					}
					
					.th_Char {
					text-align: left !important;
					padding: 0 3px;	
					}

					.txtlbl {
					line-height: 1;
					float: left;
					text-align: left;
					width: 100%;
					min-width: 100px;
					padding-bottom: 0.45em;
					}

					.txtData {
					padding-bottom: .1em;
					line-height: 1;
					text-align: left !important;
					width: 100%;
					min-width: 100px;
					}

					.txtdark {
					font-weight: 600;
					font-size: 0.875em;
					color: black;
					text-align: left;
				<!-- 	padding: 0 3px; -->
					}

					/* Footer */
					.sum_Footer {
					margin:
					auto;
					border-top: 1px
					solid #fff;
					height: 4em;
					display: inline-flex;
					width: 80vw;
					padding:
					.5em 0;
					position: absolute;
					bottom: 0px;
					align-items: center;
					}

					.footer_Btn {
					width: 6em;
					min-width: 5em;
					}

					.footer_Lbl {
					text-shadow: 0
					0 1px
					#666666;
					margin: auto;
					max-width:
					6em;
					white-space: Nowrap;
					overflow:
					hidden;
					text-overflow: ellipsis;
					text-align: center;
					color:
					#fff;
					font-size: 1em;
					padding: .3em 0 0 0;
					font-weight: 500;
					}

					.circle_BG {
					margin: auto;
					background: #fff;
					height: 2em;
					width: 2em;
					border-radius: 50%;
					box-shadow: 0 0 1px 0
					rgba(0, 0, 0, .4);
					transition: .5s;
					}

					.circle_BG:hover {
					transition:
					.5s;
					background:
					#e8e8e8;
					}

					.circle_Icon {
					height: 1em;
					width: 1em;
					padding: .5em;
					}

					.floatRht {
					position: absolute;
					right: 0px;
					}

					/*.txt_Quantityc1,
					.txt_Ratec2, .txt_Discountc3,
					.txt_TaxAmountc4,.txt_itemCodec5,
					.txt_itemDescriptionc6,
					.txt_NetAmountc7,.txt_Remarksc8,
					.txt_DueDatec9*/

					.colomn_View {
					-webkit-column-count:
					3;
					-moz-column-count: 3;
					column-count: 3 !important;
					-webkit-column-rule: 1px dashed #e2e2e2;
					-moz-column-rule: 1px
					dashed #e2e2e2;
					column-rule: 1px dashed
					#e2e2e2;
					-webkit-column-gap:
					32px;
					-moz-column-gap: 32px;
					column-gap:
					32px;
					}

					@media only screen and
					(max-device-width: 767px) {
					body {
					font-size: 250%;
					}
					.colomn_View {
					-webkit-column-count: 1;
					-moz-column-count: 1;
					column-count: 1
					!important;
					-webkit-column-rule: 1px dashed #e2e2e2;
					-moz-column-rule: 1px
					dashed #e2e2e2;
					column-rule: 1px dashed
					#e2e2e2;
					-webkit-column-gap:
					32px;
					-moz-column-gap: 32px;
					column-gap:
					32px;
					}
					
					.sum_Container {
					margin: auto;
					height: 100%;
					width: 96vw;
					}
					.sum_Footer {
					margin: auto;
					width: 96vw;
					}
					}

					@media only
					screen and (min-device-width: 768px) and
					(max-device-width:
					1023px)
					{
					body {
					font-size: 130%;
					}
					.colomn_View {
					-webkit-column-count: 2;
					-moz-column-count: 2;
					column-count: 2
					!important;
					-webkit-column-rule: 1px dashed #e2e2e2;
					-moz-column-rule: 1px
					dashed #e2e2e2;
					column-rule: 1px dashed
					#e2e2e2;
					-webkit-column-gap:
					32px;
					-moz-column-gap: 32px;
					column-gap:
					32px;
					}
					
					.sum_Container {
					margin: auto;
					height: 100%;
					width: 96vw;
					}
					.sum_Footer {
					margin: auto;
					width: 96vw;
					}
					}

					@media only
					screen and (min-device-width: 1024px) {
					.colomn_View {
					-webkit-column-count: 3;
					-moz-column-count: 3;
					column-count: 3
					!important;
					-webkit-column-rule: 1px dashed #e2e2e2;
					-moz-column-rule: 1px dashed #e2e2e2;
					column-rule: 1px dashed
					#e2e2e2;
					-webkit-column-gap: 32px;
					-moz-column-gap: 32px;
					column-gap:
					32px;
					}
					}

				
				
				
				
				</style>
			</head>
			<body>
				<div class="sum_Container">
					<div class="sum_Content">
						<form id="detail" METHOD="POST" style="margin-bottom:0;">
							<div class="sum_Header ">
								<img src="/ibase/webitm/images/Summary/Header.png" class="sum_Icon pdLeft_16"></img>
								Retail Scheme
							</div>

					  <xsl:for-each select="//Detail1">
					  <xsl:variable name="scheme_code">
                                   <xsl:value-of select="scheme_code"></xsl:value-of>
                      </xsl:variable>
                      <xsl:variable name="descr">
                                   <xsl:value-of select="descr"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="sh_descr">
                                   <xsl:value-of select="sh_descr"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="det_descr">
                                   <xsl:value-of select="det_descr"></xsl:value-of>
                       </xsl:variable>
                        <xsl:variable name="scheme_type">
                                   <xsl:value-of select="scheme_type"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="benefit_type">
                                   <xsl:value-of select="benefit_type"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="dlv_mode">
                                   <xsl:value-of select="dlv_mode"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="eff_from">
                                   <xsl:value-of select="eff_from"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="valid_upto">
                                   <xsl:value-of select="valid_upto"></xsl:value-of>
                       </xsl:variable>
                        <xsl:variable name="outlet_type">
                                   <xsl:value-of select="outlet_type"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="class_code__outlet">
                                   <xsl:value-of select="class_code__outlet"></xsl:value-of>
                       </xsl:variable>
                        <xsl:variable name="payout_date">
                                   <xsl:value-of select="payout_date"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="last_claim_date">
                                   <xsl:value-of select="last_claim_date"></xsl:value-of>
                       </xsl:variable>
                       <xsl:variable name="outlet_type_descr">
                                   <xsl:value-of select="outlet_type_descr"></xsl:value-of>
                       </xsl:variable>
								<div class="content_BG colomn_View">
									<div class="content_Row">
										<div class="txtlbl txtdark">Scheme : </div>
										<div class="txtData" contentEditable="false">
												<xsl:choose>
													<xsl:when test="$scheme_code !=''">
															<xsl:value-of select="$scheme_code" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
											
										</div>
									</div>

									<div class="content_Row">
										<div class="txtlbl txtdark">Description : </div>
										<div class="txtData" contentEditable="false">
										<xsl:choose>
													<xsl:when test="$descr !=''">
																<xsl:value-of select="$descr" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										</div>
									</div>

									<!-- <div class="content_Row">
										<div class="txtlbl txtdark">Short Description : </div>
										<div class="txtData" contentEditable="false">
										<xsl:choose>
													<xsl:when test="$sh_descr !=''">
																<xsl:value-of select="$sh_descr" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										</div>
									</div> -->

									<div class="content_Row">
										<div class="txtlbl txtdark">Detail Description : </div>
										<div class="txtData" contentEditable="false">
										<xsl:choose>
													<xsl:when test="$det_descr !=''">
																<xsl:value-of select="$det_descr" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
										</div>
									</div>

									<div class="content_Row">
										<div class="txtlbl txtdark">Scheme Type : </div>
										<div class="txtData" contentEditable="false">
										<xsl:choose>
													<xsl:when test="$scheme_type = 0">
															<xsl:text>All Items invoice</xsl:text>
													</xsl:when>
													<xsl:when test="$scheme_type = 1">
															<xsl:text>Invoice Amount Based</xsl:text>
													</xsl:when>
													<xsl:when test="$scheme_type = 2">
															<xsl:text>Period Amount Based</xsl:text>
													</xsl:when>
													<xsl:when test="$scheme_type = 3">
															<xsl:text>Geography Specific</xsl:text>
													</xsl:when>
													<xsl:when test="$scheme_type = 4">
															<xsl:text>Item Group</xsl:text>
													</xsl:when>
													<xsl:otherwise>
														  <xsl:text>-</xsl:text>
													</xsl:otherwise>
													</xsl:choose>
											
										</div>
									</div>

									<div class="content_Row">
										<div class="txtlbl txtdark">Benifit Type : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
														<!-- <xsl:when test="$benefit_type !=''">
																	<xsl:value-of select="$benefit_type" />
														</xsl:when> -->
													<xsl:when test="$benefit_type = 1">
															<xsl:text>Free Quantity</xsl:text>
													</xsl:when>
													<xsl:when test="$benefit_type = 2">
															<xsl:text>Free Value</xsl:text>
													</xsl:when>
													<xsl:when test="$benefit_type = 3">
															<xsl:text>Gift Card</xsl:text>
													</xsl:when>
													<xsl:when test="$benefit_type = 4">
															<xsl:text>Credit Note</xsl:text>
													</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
										</div>
									</div>


                                    <div class="content_Row">
										<div class="txtlbl txtdark">Delivery Mode : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													    <!-- <xsl:when test="$benefit_type !=''">
																	<xsl:value-of select="$dlv_mode" />
														</xsl:when> -->
													<xsl:when test="$dlv_mode = 1">
															<xsl:text>Electronic</xsl:text>
													</xsl:when>
													<xsl:when test="$dlv_mode = 2">
															<xsl:text>Courier</xsl:text>
													</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
										</div>
									</div>

                                    <div class="content_Row">
										<div class="txtlbl txtdark">Effective From : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													<xsl:when test="$eff_from !=''">
																	<xsl:value-of select="$eff_from" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
										</div>
									</div>

                                    <div class="content_Row">
										<div class="txtlbl txtdark">Valid Upto : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													<xsl:when test="$valid_upto !=''">
																	<xsl:value-of select="$valid_upto" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
										
										</div>
									</div>
									
									<div class="content_Row">
										<div class="txtlbl txtdark">Customer Type : </div>
										<div class="txtData" contentEditable="false">
										<xsl:choose>
												<xsl:when test="$outlet_type_descr !=''">
														<xsl:value-of select="$outlet_type_descr" />
												</xsl:when>
												<xsl:otherwise>
													  	<xsl:text>-</xsl:text>
												</xsl:otherwise>
										</xsl:choose>
										</div>
									</div>
									
									<div class="content_Row">
										<div class="txtlbl txtdark">Outlet Class : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													<xsl:when test="$class_code__outlet !=''">
																	<xsl:value-of select="$class_code__outlet" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
											</xsl:choose>
										</div>
									</div>
									
									<div class="content_Row">
										<div class="txtlbl txtdark">Last Claim Date : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													<xsl:when test="$last_claim_date !=''">
																	<xsl:value-of select="$last_claim_date" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
											</xsl:choose>
										</div>
									</div>
									
									<div class="content_Row">
										<div class="txtlbl txtdark">Payout Date : </div>
										<div class="txtData" contentEditable="false">
											<xsl:choose>
													<xsl:when test="$payout_date !=''">
																	<xsl:value-of select="$payout_date" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
											</xsl:choose>
										</div>
									</div>

								</div>
							</xsl:for-each>
							<xsl:variable name="detail2_count">
									<xsl:for-each select="//Detail2">
										<xsl:if test="attribute/@updateFlag!='D'">
											<xsl:value-of select="count(//Detail2)" />
										</xsl:if>
									</xsl:for-each>
								</xsl:variable>
							<xsl:if test="normalize-space($detail2_count) > '0'">
							<div style="overflow:auto;width:100%;">
								<div class="sum_Header">
									<img src="/ibase/webitm/images/Summary/Item.png" class="sum_Icon pdLeft_16"></img>
								    Participant Items
								</div>

								<div class="content_BG">
									<div class="table_Row">
										<!-- <div class="th_Char txtdark" style="width: 4% ">Line#</div> -->
										<!--<div class="th_Char txtdark" style="width: 12% ">Scheme Code</div>-->
										<div class="th_Char txtdark" style="width: 65% "> Item </div>
										<!-- <div class="th_Char txtdark" style="width: 5%;"> Quantity </div> -->
									</div>
									<xsl:for-each select="//Detail2">
										<xsl:if test="attribute/@updateFlag!='D'">
											<xsl:variable name="line_no">
												<xsl:value-of select="line_no"></xsl:value-of>
											</xsl:variable>
											<xsl:variable name="scheme_code">
												<xsl:value-of select="scheme_code"></xsl:value-of>
											</xsl:variable>
											<xsl:variable name="item_code">
												<xsl:value-of select="item_code"></xsl:value-of>
											</xsl:variable>
											<xsl:variable name="item_descr">
												<xsl:value-of select="item_descr"></xsl:value-of>
											</xsl:variable>
											<xsl:variable name="quantity">
												<xsl:value-of select="quantity"></xsl:value-of>
											</xsl:variable>

											<div class="table_Row">
												<!-- <div class="th_Char" style="width: 4% " contentEditable="false">
												<xsl:choose>
													<xsl:when test="$line_no !=''">
																	<xsl:value-of select="$line_no" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
													
												</div> -->
												<!--<div class="th_Char" style="width: 12% " contentEditable="false">
													<xsl:choose>
													<xsl:when test="$scheme_code !=''">
																	<xsl:value-of select="$scheme_code" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
													
												</div>-->
												
												<div class="th_Char" style="width: 65% " contentEditable="false">
												<xsl:choose>
													<xsl:when test="$item_descr !='' and $item_code !=''">
															<xsl:value-of select="$item_descr" />  ( <xsl:value-of select="$item_code" /> )
													</xsl:when>
													<xsl:otherwise>
															  <xsl:text>-</xsl:text>
													</xsl:otherwise>
													
													<xsl:when test="$item_code !=''">
																	(<xsl:value-of select="$item_code" />)
													</xsl:when>
													<xsl:otherwise>
															  <xsl:text>-</xsl:text>
													</xsl:otherwise>
													
												</xsl:choose>
												</div>
												
												<!-- <div class=" th_Num" style="width: 5% " contentEditable="false">
													<xsl:choose>
													<xsl:when test="$quantity !=''">
															<xsl:value-of select="$quantity" />
														</xsl:when>
														<xsl:otherwise>
															  <xsl:text>-</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
													
												</div> -->
											</div>

										</xsl:if>
									</xsl:for-each>
								</div>
							</div>
							</xsl:if>
							
						</form>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>

