<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: #000;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;}
					p {font-size: 12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					.firstData
					{
					color:black;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%


					}
					.headerTableDCR {
					padding-left:8%;
					}
					@media only screen and
					(min-width: 100px) and
					(max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">

							<!-- <table id="travelTable" border="0" cellspacing="1" cellpadding="1" 
								width="100%"> -->

							<div class="headerTableDCR " style="display: inline-block;">

								<table id="travelTable" border="0" cellspacing="1"
									cellpadding="1" width="100%">
									<xsl:for-each select="//Detail1">
										<tr style="height: 25px;">
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Tran Date :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS=""
													style="width:auto;float: left;    font-weight: 600;">
													<xsl:value-of select="tran_date" />
												</span>
											</td>
										</tr>

										<tr style="height: 25px;">
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Scheme :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class=""
													style='text-transform:capitalize; float: left;    font-weight: 600;'>
													<xsl:value-of select="scheme_code" />
												</span>

											</td>
										</tr>

										<tr style="height: 25px;">
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Description :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class=""
													style='text-transform:capitalize;float: left;    font-weight: 600;'>
													<xsl:value-of select="scheme_descr" />
												</span>

											</td>
										</tr>
										<tr style="height: 25px;">
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Customer :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class=""
													style='text-transform:capitalize;float: left;    font-weight: 600;'>
													<xsl:value-of select="strg_customer_first_name" />
												</span>

											</td>
										</tr>
										<tr style="height: 25px;">
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Beat :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class=""
													style='text-transform:capitalize;float: left;    font-weight: 600;'>
													<!-- <xsl:value-of select="locality_code" /> -->
													<xsl:value-of select="locality_descr" />
												</span>

											</td>
										</tr>
										<xsl:variable name="stockist_code">
											<xsl:value-of select="stockist_code" />
										</xsl:variable>
										<xsl:if test="$stockist_code != ''">
											<tr style="height: 25px;">
												<td class="cellttl1 firstData" width="auto">
													<span CLASS="" style="width:auto;float: right;">Stockiest :</span>
												</td>
												<td class="cellttl1 firstData" width="auto">

													<span class=""
														style='text-transform:capitalize;float: left;    font-weight: 600;'>
														<!-- <xsl:value-of select="stockist_code" /> -->
														<xsl:value-of select="stck_customer_first_name" />
													</span>

												</td>
											</tr>
										</xsl:if>
									</xsl:for-each>

								</table>
							</div>

							<xsl:variable name="place_listed_count">
								<xsl:value-of select="count(//Detail2)" />
							</xsl:variable>

							<xsl:if test="normalize-space($place_listed_count) > '0'">
								<details id="RTR_SummaryPage_place_listed_count" open="true">
									<summary class="summary" id="RTR_SummaryPage_place_listed_count">Claim Details</summary>
									<TABLE border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX;border-bottom: 
													#e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Invoice No</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Date</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Invoice Amt</TH>

											</TR>
										</thead>

										<xsl:for-each select="//Detail2">
											<xsl:variable name="invoice_id">
												<xsl:value-of select="invoice_id" />
											</xsl:variable>
											<xsl:variable name="inv_date">
												<xsl:value-of select="inv_date" />
											</xsl:variable>
											<xsl:variable name="inv_amt">
												<xsl:value-of select="inv_amt" />
											</xsl:variable>

											<xsl:if test="attribute/@updateFlag!='D'">
												<TR>
													<TD CLASS="cellttl1 tdCenter title ">
														<xsl:value-of select="$invoice_id" />
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														<xsl:value-of select="$inv_date" />
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														<xsl:value-of select="$inv_amt" />
													</TD>

												</TR>
											</xsl:if>

										</xsl:for-each>
										<xsl:variable name="Sum">
											<xsl:value-of select="sum(//inv_amt)" />
										</xsl:variable>

											<xsl:if test="attribute/@updateFlag!='D'">
										<thead class="" style="height : 30px;">
											<TR>
												<TD CLASS="cellttl1 tdCenter title " style= "font-weight: bold;">Total</TD>
												<TD  CLASS="cellttl1 tdCenter title  ">
													
												</TD>
												<TD CLASS="cellttl1 tdCenter title  ">

													<xsl:value-of select="$Sum" />
												</TD>
												
											</TR>

										</thead>
										</xsl:if>

									</TABLE>
								</details>
							</xsl:if>

							<xsl:variable name="doctor_listed_count">
								<xsl:value-of select="count(//Detail2)" />
							</xsl:variable>
							<xsl:if test="normalize-space($doctor_listed_count) > '0'">
								<details id="RTR_SummaryPage_customer_listed_count"
									open="true">
									<summary class="summary">Invoice Attachmenet</summary>

									<table border="0" width="100%" style="z-index:9999999999;  ">
										<xsl:for-each select="//Detail2">
											<xsl:variable name="invoice_id">
												<xsl:value-of select="invoice_id" />
											</xsl:variable>
											<xsl:variable name="image_id">
												<xsl:value-of select="image_id" />
											</xsl:variable>
											<xsl:if test="attribute/@updateFlag!='D'">
												<tr>
													<td class="cellttl1 firstData" style="width: 100%">
														<span CLASS="" style="width:auto;">Invoice No :</span>
														<!-- </td> <td class="cellttl1 firstData" width="auto"> -->
														<span CLASS="" style="width:auto;">
															<xsl:value-of select="invoice_id" />
														</span>
													</td>
												</tr>
												<tr>
													<td class="cellttl1 tdCenter title" width="100%"
														colspan="2">
														<div align='center'
															id="__attachmentDiv.{normalize-space($image_id)}"></div>
														<img src="_"
															onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($image_id)}', 'retail_sch_claim', 'R-SCHC', '{normalize-space($image_id)}'); this.remove();" />
													</td>
												</tr>
											</xsl:if>
										</xsl:for-each>
									</table>

								</details>
							</xsl:if>

							<xsl:variable name="item_listed_count1">
								<xsl:value-of select="count(//Detail3)" />
							</xsl:variable>

							<xsl:if test="normalize-space($item_listed_count1) > '0'">
								<details id="RTR_SummaryPage_place_listed_count" open="true">
									<summary class="summary" id="RTR_SummaryPage_place_listed_count">Items</summary>
									<TABLE border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX;border-bottom: 
													#e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Item Code</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Quantity</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Remarks</TH>

											</TR>
										</thead>

										<xsl:for-each select="//Detail3">
											<xsl:variable name="item_code">
												<xsl:value-of select="item_code" />
											</xsl:variable>
											<xsl:variable name="item_descr">
												<xsl:value-of select="item_descr" />
											</xsl:variable>
											<xsl:variable name="quantity">
												<xsl:value-of select="quantity" />
											</xsl:variable>
											<xsl:variable name="remarks">
												<xsl:value-of select="remarks" />
											</xsl:variable>
                                            <xsl:variable name="selectbox">
												<xsl:value-of select="selectbox" />
											</xsl:variable>


											<xsl:if test="attribute/@updateFlag!='D'">
											<xsl:if test="$selectbox ='true'">
												<xsl:choose>
												<xsl:when test="$remarks !='null'">
												<TR>
													<TD CLASS="cellttl1 tdCenter title ">
														<xsl:value-of select="$item_descr" />
														(
														<xsl:value-of select="$item_code" />
														)
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														<xsl:value-of select="$quantity" />
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														<xsl:value-of select="$remarks" />
													</TD>

												</TR>
												</xsl:when>
												<xsl:otherwise>
												<TR>
													<TD CLASS="cellttl1 tdCenter title ">
														<xsl:value-of select="$item_descr" />
														(
														<xsl:value-of select="$item_code" />
														)
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														<xsl:value-of select="$quantity" />
													</TD>
													<TD CLASS="cellttl1 tdCenter title  ">
														 <xsl:text>-</xsl:text>
													</TD>

												</TR>
												
												</xsl:otherwise>
1												
												</xsl:choose>
												</xsl:if>
												
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
							</xsl:if>


							<div width="40%" id="attachmentUpload" class="attachmentUpload"
								style="display: none;">
								<table width="100%" height="100%">
									<tr height="10%" width="100%">
										<td>
											<div class="close" onclick="closeMe('attachmentUpload');">x</div>
											<div width="100%">
												<div
													style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
													<input type="button" class="buttonZoomIN" style="float:right;"
														value="+" id="zoomInBtn" onclick="zoomImage('+')" />
													<input type="button" class="buttonZoomOUT" style="float:right;"
														value="(-)" id="zoomOutBtn" onclick="zoomImage('-')" />
												</div>
											</div>
										</td>
									</tr>

									<tr height="89%" width="100%">
										<td>
											<div id="uploadContent"
												style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
												<img id="targetImg" style="max-height: 100%; max-width:100%;"
													src="" setMinSize="false" setSize="false" oHeight=""
													oWidth=""></img>
											</div>
										</td>
									</tr>
									<tr height="1%" width="100%">
										<td>

										</td>
									</tr>
								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>
