<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<head>
				<TITLE>Approval Details</TITLE>
				<script language="Javascript"
					src="/ibase/webitm/js/jsrsClient.js" />

				<link type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/ITMAttachmentView.css" />

				<style>
					.ImgErrDivClass
					{
					border-radius: 50%;
					width: 30px;
					background-color: #cfbebe;
					height: 30px;
					line-height: 30px;
					display: none;
					text-align: center;
					}

					.ImgErrDivClass1
					{
					display:none;
					color: #fff;
					}

					.ImgDivClass
					{
					width :30px;
					height: 30px;
					border-radius: 50%;
					background-color:#cfbebe;
					}
					.userNameCss
					{
					color: gray;
					-webkit-font-smoothing: antialiased;
					text-rendering: optimizeLegibility;
					font-weight: 600;
					}
					.chgUserCss
					{
					color: gray;
					-webkit-font-smoothing: antialiased;
					text-rendering: optimizeLegibility;
					font-weight: 100;
					}

					.tableClass
					{
					border-collapse: collapse !important;
					}

				</style>

			</head>

			<body id='groupDiv' onload=""
				style="font-family: MuseoLight-300, sans-serif !important;">

				<FORM id="brow" >
					<DIV ID="Tableborder"
						style="height: 100%; background-color: #FFF;">

						<DIV ID="TABLECONTAINER">
							<TABLE name="main" id="main" class="tableClass"
								cellpadding="0" cellspacing="0" width="100%"
								style="height: auto;">
								<xsl:for-each select="//prior_visit">

									<xsl:variable name="ref_id">
										<xsl:value-of select="ref_id" />
									</xsl:variable>
									<xsl:variable name="ref_ser">
										<xsl:value-of select="ref_ser" />
									</xsl:variable>
									<xsl:variable name="line_no">
										<xsl:value-of select="line_no" />
									</xsl:variable>
									<xsl:variable name="sign_status">
										<xsl:value-of select="sign_status" />
									</xsl:variable>
									<xsl:variable name="sign_remarks">
										<xsl:value-of select="sign_remarks" />
									</xsl:variable>
									<xsl:variable name="sign_reason">
										<xsl:value-of select="sign_reason" />
									</xsl:variable>
									<xsl:variable name="sign_date">
										<xsl:value-of select="sign_date" />
									</xsl:variable>
									<xsl:variable name="sign_date_disp">
										<xsl:value-of select="sign_date_disp" />
									</xsl:variable>
									<xsl:variable name="emp_code">
										<xsl:value-of select="emp_code" />
									</xsl:variable>
									<xsl:variable name="emp_name">
										<xsl:value-of select="emp_name" />
									</xsl:variable>
									<xsl:variable name="role_code">
										<xsl:value-of select="role_code" />
									</xsl:variable>
									<xsl:variable name="emp_designation">
										<xsl:value-of select="emp_designation" />
									</xsl:variable>
									<xsl:variable name="dbID">
										<xsl:value-of select="domID" />
									</xsl:variable>

									<xsl:variable name="CURVALUE">
										<xsl:value-of select="chg_id" />
									</xsl:variable>

									<xsl:variable name="CHGUSER">
										<xsl:value-of select="normalize-space(chg_user)" />
									</xsl:variable>

									<xsl:variable name="CHGTERM">
										<xsl:value-of select="chg_term" />
									</xsl:variable>
									<xsl:variable name="action_prfrm">
										<xsl:value-of select="action_prfrm" />
									</xsl:variable>

									<xsl:variable name="i" select="position()" />
									<xsl:if test="$sign_status != 'Y'">
									<tr id="attachList{$CURVALUE}">

										<td style="border:1px solid lightgray;">

											<div class="PanelLabel" name="feed"
												id="panelList{$CURVALUE}"
												style="padding: 0px !important;margin:0px;border-bottom:none;"
												onclick="changeRecord({$CURVALUE}, this, rec_ref_id, rec_obj_name); javascript:selectedRow('{$CURVALUE}');">

												<table style="border-collapse: collapse;width:100%"
													cellpadding="0" cellspacing="0">
													<tr>
														<td style="width:37px; padding-left:5px">
															<HTML>
																<TABLE>
																	<TR>
																		<TD>
																			<IMG
																				SRC="/ibase/CustomMenuImageServlet?fldValue={normalize-space($emp_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($emp_name)}"
																				onerror='this.src="images/map/user.png"'
																				class="iw-header-userImage "
																				style="height: 30px; width: 30px;border-radius:50%;;background:lightgray">
																			</IMG>
																		</TD>
																	</TR>
																</TABLE>
															</HTML>
														</td>

														<td style="padding: 3px 5px 3px 5px">
															<HTML>
																<TABLE style="width:100%;word-break:break-all"
																	cellpadding="0" cellspacing="0">
																	<TR>
																		<TD VALIGN='bottom' width="50%">

																			<span class='mainfeedStyle userNameCss'
																				style="font-size: 14px;">
																				<xsl:value-of select='emp_name' />
																				&#160;
																			</span>


																			<TD width="50%">
																				<span class='mainfeedStyle userNameCss'
																					style="font-size: 12px;float:right;margin-top: 0px;">
																					<xsl:if test="$sign_status = 'U'">
																						Unsigned
																					</xsl:if>
																					<xsl:if test="$sign_status = 'S'">
																						Approved
																					</xsl:if>
																					<xsl:if test="$sign_status = 'R'">
																						Rejected
																					</xsl:if>
																					<xsl:if test="$sign_status = 'Y'">
																						Confirmed
																					</xsl:if>

																					<xsl:if
																						test="($action_prfrm != 'E') and ($action_prfrm != 'A') and ($action_prfrm != 'C') and ($action_prfrm != 'DELETE_ATTACHMENT') and ($action_prfrm != 'UPLOAD_ATTACHMENT') and ($action_prfrm != 'ADD_TAG') and ($action_prfrm != 'DELETE_TAG') and ($action_prfrm != 'a') and ($action_prfrm != 'c') and ($action_prfrm != 'e')">
																						<xsl:value-of select='action_prfrm' />
																						&#160;
																					</xsl:if>

																				</span>
																			</TD>

																		</TD>

																	</TR>

																	<TR>
																		<TD width="50%">
																			<span class='mainfeedStyle chgUserCss'
																				style="font-size: 14px;">
																				<xsl:value-of select='emp_code' />
																				&#160;
																			</span>
																			<span class='mainfeedStyle chgUserCss'
																				style="font-size: 14px;">
																				<xsl:value-of select='emp_designation' />
																				&#160;
																			</span>
																		</TD>
																		<TD width="50%">
																			<span class='mainfeedStyle chgUserCss'
																				style="font-size: 12px;float:right;margin-top: 0px; padding-right: 5px;">
																				<xsl:value-of select='sign_date_disp' />
																			</span>
																		</TD>
																	</TR>

																	<TR>
																		<TD colspan="2">
																			<span class='mainfeedStyle'
																				style="font-size: 11px;color:gray; font-weight: 100;">
																				Remarks:&#160;&#160;
																				<xsl:value-of select='sign_remarks' />
																				&#160;
																			</span>
																		</TD>
																	</TR>

																</TABLE>
															</HTML>
														</td>
													</tr>
												</table>
											</div>
											<!-- <div> <iframe id='detailDiv{$CURVALUE}' src='' frameborder="0" 
												scrolling="no" onload="resizeIframe(this, '{$CURVALUE}')" style = "visibility:hidden;width: 
												100%;height: 0px"> </iframe> </div> -->
										</td>
									</tr>
									</xsl:if>
								</xsl:for-each>
							</TABLE>
						</DIV>
					</DIV>

				</FORM>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
