<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: black;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:black;}
					p {font-size: 12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			
			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					<!-- padding-left:8%; -->
					padding:10px;
					}
					.firstData
					{
						color:black;
						width:50%;
					}
					@media only screen and (min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
								cellpadding="1" width="100%"> -->

							<div class="headerTableDCR headerTableDCR1">
								<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">
									<xsl:for-each select="//Detail1">
									<xsl:variable name="downloadattchment">
													<xsl:value-of select="zip_path" />
									</xsl:variable>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Project Code </span>
											</td>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="project_code" />
												</span>
											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Period Code : </span>
											</td>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="period_code" />
												</span>
											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Download the attchment : </span>
											</td>
											<td class="firstData">

											    <span CLASS="" style="width:auto;float: left;">
												<a href="{normalize-space($downloadattchment)}" target="_blank"><xsl:value-of select="folder_path" /></a>
												</span>

											</td>
										</tr>
										
									
									</xsl:for-each>

								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>
	
</xsl:stylesheet>
