<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
                
            <title>Details</title>
            <style>
                *{
                    margin:0;
                    padding:0;
                    box-sizing: border-box;
                }
                .company-name{
                font-size: 1.8em;
                font-weight:bolder;
                color: #000;
                text-align: left;
                line-height: 1.2;
                padding: 0 0 10px 0;
                }
                .label-text{
                font-size: 1em;
                font-weight:bolder;
                color: #000;
                opacity: .6;
                text-align: left;
                }
                .data-value{
                font-size: 1em;
                line-height: 1.2;
                color: #000;
                font-weight:bolder;
                padding: 0 0 10px 0;
                text-align: left;
                }
                .header-label{
                font-size: 1.4em;
                font-weight:bolder;
                color: #000;
                text-align: left;
                margin-left: 10px;
                }
                .value-shown{
                display:flex;
                width:100%;
                align-items: center;
                justify-content :space-between;
                }
                .horizontal_dotted_line {
                 border-bottom: 4px dotted #808080;
                 width: 100%;
                 }
                .row-div{
                    <!--padding: 0 16px 0 40px;-->
                    display: flex;
                    align-items: center;
                    margin-bottom: 16px;
                }
                .mainbody{
                    background: #f5f5f5;
                    margin: auto;
                    width: calc(100% - 32px);
                    font-family: sans-serif !important;
                    font-weight: 500 !important;
                    margin-bottom: 0;
                }
                .datafontsize{
                    font-size:14px !Important;
                    color: #000;
                }
                .mobviewDiv{
                        margin: 16px 16px 0;
                      border: 1px solid #e2e2e2;
                      border-radius: 12px;
                      background-color: #fff;  
                          
                    }
                .align-imgtext{
                    float:left;
                    text-align:right;
                }
                .itemOuterDiv{
                        margin-top: 0;
                        padding: 0;
                        border-bottom: 1px solid #e2e2e2;
                    }
                 .itemOuterDiv{
                    margin-top: 16px;
                }
                 .columnsDiv:last-child, .itemOuterDiv:last-child{
                        border-bottom: none;
                    }
                .columnsDiv {
                    align-items: center;
                    width: 100%;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }
                .tab{
                    margin-inline-start: auto;
                    cursor: pointer;
                }
                .bgcolorform{
                    background-color: #f5f5f5;
                }
                .bluebg-icon{
                    background-color: #e6f4ff;
                }
                .redbg-icon{
                    background-color: #ffe8e9;
                }
                .namespacing{
                    padding: 0 0 0 16px;
                    text-align: left;
                    line-height: 1.5;
                }
                .activityspacing{
                    padding: 8px 0 0 0;
                    color: #000;
                }
                .nestedcontainer{
                    /*height:auto;*/
                    background-color:#d9d9d9;
                    padding:16px;
                    margin : 8px 16px;
                    border-radius:15px;
                }
                .column-center{
                    text-align:center;
                }
                .alignimg{
                    vertical-align:middle;
                }
                .clearfix{
                    clear:both;
                }
                .btnpadding{
                    padding: 0 0 0 4px;
                }
                .tabs {
                    position: relative;
                    text-align: center;
                    background: #f5f5f5;
                    /*width: 100%;*/
                    border-radius: 5px;
                    min-width: 240px;
                    min-height: 500px;
                    overflow-x: auto;
                    overflow-y: hidden;
                    -webkit-overflow-scrolling: touch;
                }
                .tabs .data-content section {
                    -webkit-animation-name: data-content;
                            animation-name: data-content;
                    -webkit-animation-direction: normal;
                            animation-direction: normal;
                    -webkit-animation-duration: 0.3s;
                            animation-duration: 0.3s;
                    -webkit-animation-timing-function: ease-in-out;
                            animation-timing-function: ease-in-out;
                    -webkit-animation-iteration-count: 1;
                            animation-iteration-count: 1;
                    line-height: 1.4;
                }
                @keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                .multi-colDiv{
                    margin: 24px 0;
                    text-align: left;
                    padding: 0 16px;
                    
                }
                {
                    .multi-colDiv{
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                    }
                    .columnsDiv{
                        justify-content: center;
                    }
                }
            </style>
			</head>
            <LINK type="text/css" rel="stylesheet"
                href="/ibase/webitm/css/MobDARSummary.css" />
                
            <body onload="javascript:focusView('focusOnFeed')">
				<form name="Wizard_TravelDSR" class="bgcolorform">
					<div class="mainbody">

                        <xsl:for-each select="//Detail1">

                                <div class="mobviewDiv">
                                    <div class="multi-colDiv">
                                        <div class="columnsDiv">
                                                <div class="company-name" >
                                                    M/s Langar Bidi Company Poona
                                                </div>
                                        </div>

                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    Address
                                                </div>
                                                <div class="data-value">
                                                    24,Pushpak Park,Orchid,Flatno 501,5th and 6th Floor,Aundh,Pune,Maharashtra 411007
                                                </div>
                                        </div>

                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    GSTIN No
                                                </div>
                                                <div class="data-value" >
                                                    27AAAFL5383K1Z0 /27 /Maharashtra                                                  
                                                </div>
                                        </div>                                    
                                    </div>
                                </div> 
                        </xsl:for-each>
                        
                        <div class="header-label">
              				 Supplier Details
            			</div>
            
                        <xsl:for-each select="//Detail1">


                                <div class="mobviewDiv">
                                    <div class="multi-colDiv">
                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    Supplier Name
                                                </div>
                                                <div class="data-value">
                                                    M/s Langar Bidi Company Poona,Gwalior Depo
                                                </div>
                                        </div>

                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    Address
                                                </div>
                                                <div class="data-value">
                                                    A-18/399 Transport Nagar,Near Water Tank,Gwalior
                                                </div>
                                        </div>

                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    GSTIN No
                                                </div>
                                                <div class="data-value" >
                                                    23AAAFL5383K1Z8                                                 
                                                </div>
                                        </div>
                                        <div class="columnsDiv">
                                                <div class="label-text" >
                                                    State
                                                </div>
                                                <div class="data-value" >
                                                    23 / Madhya Pradesh                                                
                                                </div>
                                        </div>                                       
                                    </div>
                                </div><!-- End 2nd container Feed for supplier details -->
                        </xsl:for-each>
                        <div class="tabs">
                   
                                <xsl:variable name="host_url">
                                    <xsl:for-each select="//Detail1">
                                        <xsl:value-of select="host_url" />
                                    </xsl:for-each>
                                </xsl:variable>
                                <div class="data-content">

                                    <!-- <section id="section-n1"> -->
                                        <!--Feed View Template Start-->
                                        <!-- Detail2(start) -->
                                        <xsl:variable name="detail2_listed_count">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail2)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                            <xsl:variable name="detail2_form">
                                                <xsl:for-each select="//Detail2">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','2',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail2_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail2_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail2_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail2(end) -->
                                        <!-- Detail3(start) -->
                                        <xsl:variable name="detail3_listed_count">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail3)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                            <xsl:variable name="detail3_form">
                                                <xsl:for-each select="//Detail3">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','3',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail3_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail3_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail3_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail3(end) -->
                                        <!-- Detail4(start) -->
                                        <xsl:variable name="detail4_listed_count">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail4)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                            <xsl:variable name="detail4_form">
                                                <xsl:for-each select="//Detail4">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','4',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail4_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail4_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail4_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail4(end) -->
                                        <!-- Detail5(start) -->
                                        <xsl:variable name="detail5_listed_count">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail5)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                            <xsl:variable name="detail5_form">
                                                <xsl:for-each select="//Detail5">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','5',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail5_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail5_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail5_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail5(end) -->
                                        <!-- Detail6(start) -->
                                        <xsl:variable name="detail6_listed_count">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail6)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                            <xsl:variable name="detail6_form">
                                                <xsl:for-each select="//Detail6">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','6',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail6_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail6_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail6_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail6(end) -->
                                        <!-- Detail7(start) -->
                                        <xsl:variable name="detail7_listed_count">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail7)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                            <xsl:variable name="detail7_form">
                                                <xsl:for-each select="//Detail7">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','7',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail7_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail7_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail7_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail7(end) -->
                                        <!-- Detail8(start) -->
                                        <xsl:variable name="detail8_listed_count">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail8)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                            <xsl:variable name="detail8_form">
                                                <xsl:for-each select="//Detail8">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','8',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail8_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail8_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail8_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail8(end) -->
                                        <!-- Detail9(start) -->
                                        <xsl:variable name="detail9_listed_count">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail9)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                            <xsl:variable name="detail9_form">
                                                <xsl:for-each select="//Detail9">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','9',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail9_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail9_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail9_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail9(end) -->
                                        <!-- Detail10(start) -->
                                        <xsl:variable name="detail10_listed_count">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail10)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail10_listed_count) > '0'">
                                            <xsl:variable name="detail10_form">
                                                <xsl:for-each select="//Detail10">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','10',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail10_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail10_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail10_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail10(end) -->
                                        <!-- Detail11(start) -->
                                        <xsl:variable name="detail11_listed_count">
                                            <xsl:for-each select="//Detail11">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail11)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail11_listed_count) > '0'">
                                            <xsl:variable name="detail11_form">
                                                <xsl:for-each select="//Detail11">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','11',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail11_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail11_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail11_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail11(end) -->
                                        <!-- Detail12(start) -->
                                        <xsl:variable name="detail12_listed_count">
                                            <xsl:for-each select="//Detail12">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail12)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail12_listed_count) > '0'">
                                            <xsl:variable name="detail12_form">
                                                <xsl:for-each select="//Detail12">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','12',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail12_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail12_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail12_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail12(end) -->

                                        <!-- Detail13(start) -->
                                        <xsl:variable name="detail13_listed_count">
                                            <xsl:for-each select="//Detail13">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail13)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail13_listed_count) > '0'">
                                            <xsl:variable name="detail13_form">
                                                <xsl:for-each select="//Detail13">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','13',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail13_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail13_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail13_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail13(end) -->
                                        <!-- Detail14(start) -->
                                        <xsl:variable name="detail14_listed_count">
                                            <xsl:for-each select="//Detail14">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail14)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail14_listed_count) > '0'">
                                            <xsl:variable name="detail14_form">
                                                <xsl:for-each select="//Detail14">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','14',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail14_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail14_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail14_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail14(end) -->
                                        <!-- Detail15(start) -->
                                        <xsl:variable name="detail15_listed_count">
                                            <xsl:for-each select="//Detail15">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail15)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail15_listed_count) > '0'">
                                            <xsl:variable name="detail15_form">
                                                <xsl:for-each select="//Detail15">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','15',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail15_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail15_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail15_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail15(end) -->
                                       
                                    <!-- </section> -->
                                    <!--Feed View Template End-->
                                </div>  <!-- End div data content class -->
                            </div> <!-- End class tabs -->

					</div> <!-- End mainform div body -->
				</form> <!-- End Form -->
			</body>
		</html>
	</xsl:template>

    <xsl:variable name="host">
        <xsl:for-each select="//Detail1">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>

	<xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>

		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)][attribute/@updateFlag!='D'][not(contains(cust_type, 'UNLISTED'))])" />
			</xsl:variable>
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">
                <div class="header-label"> 
                    <xsl:value-of
                        select="normalize-space($doc_listed_cnt)" />
                    Recipient Details
                </div>
                <div>
                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">

                        <xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <xsl:if test="not(contains($customer_type, 'UNLISTED'))">

                                <div class="mobviewDiv"><!-- container starts -->
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="invoice_form_no">
                                        <xsl:value-of select="invoice_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="collection_form_no">
                                        <xsl:value-of select="collection_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="addr1">
                                        <xsl:value-of select="addr1" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>

                                    <xsl:variable name="addr2">
                                        <xsl:value-of select="addr2" />
                                    </xsl:variable>
                                    <xsl:variable name="addr3">
                                        <xsl:value-of select="addr3" />
                                    </xsl:variable>
                                    <xsl:variable name="net_amt">
                                        <xsl:value-of select="net_amt" />
                                    </xsl:variable>
                                    <xsl:variable name="tax_amount">
                                        <xsl:value-of select="tax_amount" />
                                    </xsl:variable>
                                    <xsl:variable name="amount">
                                        <xsl:value-of select="amount" />
                                    </xsl:variable>
                                    <xsl:variable name="invoice_amount">
                                        <xsl:value-of select="invoice_amount" />
                                    </xsl:variable>
                                    <xsl:variable name="total_sgst_amt">
                                        <xsl:value-of select="total_sgst_amt" />
                                    </xsl:variable>
                                    <xsl:variable name="total_cgst_amt">
                                        <xsl:value-of select="total_cgst_amt" />
                                    </xsl:variable>
                                    <xsl:variable name="gst_no">
                                        <xsl:value-of select="gst_no" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_state">
                                        <xsl:value-of select="strg_state" />
                                    </xsl:variable>
                                    
                                     <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>
                                    
                                    <xsl:variable name="address_as">
                                         <xsl:value-of select="address_as" />
                                    </xsl:variable>
                                    
                                    <!-- <xsl:variable name="round_off">
                                         <xsl:value-of select="round_off" />
                                    </xsl:variable>
                                    
                                    <xsl:variable name="amount_in_words">
                                         <xsl:value-of select="amount_in_words" />
                                    </xsl:variable> -->
                                    
                                    <xsl:variable name="sales_type">
                                         <xsl:value-of select="sales_type" />
                                    </xsl:variable>

                                    <!--<xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$invoice_form_no,'#',$strg_name,'(',$collection_form_no,'*',$strg_code,'!',$addr1,'|',$addr2,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$invoice_amount,'%',$total_sgst_amt,'?',$total_cgst_amt,'{',$gst_no,'}',$customer_type,'@@',$strg_state,'][',$detail,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$address_as,'$%%%$',$round_off,'*%**',$amount_in_words,'*%#*',$sales_type,'#*%#')" />
                                    </xsl:call-template> -->
                                    
                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                             select="concat($host,'@',$invoice_form_no,'#',$strg_name,'(',$collection_form_no,'*',$strg_code,'!',$addr1,'|',$addr2,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$invoice_amount,'%',$total_sgst_amt,'?',$total_cgst_amt,'{',$gst_no,'}',$customer_type,'@@',$strg_state,'][',$detail,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$address_as,'$%%%$',$sales_type,'$*$*')" />
                                    </xsl:call-template>
                                </div> <!-- end customer details -->

                            </xsl:if>
                        
                        </xsl:if>
                    </xsl:for-each>
                </div>
			</xsl:if>
		</xsl:if>  <!-- End if form is doctor -->
	</xsl:template>

	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="invoice_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="collection_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_addr1">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="doc_addr2">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="doc_addr3">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="net_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>

		<xsl:variable name="tax_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="invoice_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="total_sgst_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="total_cgst_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="gst_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="strg_state">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'][')" />
		</xsl:variable>

		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,']['),'%%%$')" />
		</xsl:variable>

		<xsl:variable name="dcr_group">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%$'),'%%%%$')" />
		</xsl:variable>
		<xsl:variable name="type_of_customer">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%%$'),'$%%$')" />
		</xsl:variable> 
		<xsl:variable name="address_as">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%%$'),'$%%%$')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_sales_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%%%$'),'$*$*')" />
		</xsl:variable>
		
		<!-- <xsl:variable name="round_off">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%%%$'),'*%**')" />
		</xsl:variable>
		
		<xsl:variable name="amount_in_words">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'*%**'),'*%#*')" />
		</xsl:variable> -->
		<xsl:variable name="invoice_detail">
			<xsl:value-of select="concat('Detail',$invoice_form_no)" />
		</xsl:variable>
		<xsl:variable name="collection_detail">
			<xsl:value-of select="concat('Detail',$collection_form_no)" />
		</xsl:variable>

        <xsl:variable name="host_url">
            <xsl:for-each select="//Detail1">
                <xsl:if test="attribute/@updateFlag!='D'">
                    <xsl:value-of select="host_url" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

		<!-- Invoice Details Start -->
		<xsl:variable name="invoice_listed_count">
			<xsl:if test="normalize-space($invoice_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $invoice_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $invoice_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Invoice Details End -->

		<!-- Collection Details Start -->

		<xsl:variable name="collection_listed_count">
			<xsl:if test="normalize-space($collection_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $collection_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="collection_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($collection_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $collection_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
	<!-- Collection Details End -->
		<xsl:choose>
			<xsl:when
				test="$invoice_listed_count > '0' or $collection_listed_count > '0' ">
                <div>                        
                    <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                        
                        <div class="row-div">
                            <div class="namespacing">
                            <xsl:choose>
                            <xsl:when test="($doc_sales_type='I') ">
                                <div class="label-text">
                                    Recipient Name
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$doc_strg_name" />
                                </div>
                                </xsl:when>
                                </xsl:choose>
                            </div>
                        </div>
                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    Address
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="concat($doc_addr1,$doc_addr2,$doc_addr3)" />
                                </div>
                            </div>
                        </div>

                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    GST No
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$gst_no" />
                                </div>
                            </div>
                        </div>

                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    State
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$strg_state" />
                                </div>
                            </div>
                        </div>
                        
                        <div class="mobviewDiv">
                          <div class="namespacing">
                          	<div class="value-shown">
		                      <div class="label-text" >
		                          Tax is payabel on Reverse Charge
		                      </div>
		                      <div class="data-value">
		                          No
		                      </div>
                               </div>
                               <div class="value-shown">
		                      <div class="label-text" >
		                          Partial/Full Reverse Charge
		                      </div>
		                      <div class="data-value">
		                          No
		                      </div>
		               </div>
                          </div>
                      </div>            
                    </xsl:if>
                   
                   <xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                            select="concat($invoice_detail,'@',$doc_strg_code,'#',$invoice_listed_count,'*',$customer_types,'####',$collection_listed_count,'**',$collection_detail,'##',$host_url,'%%',$total_sgst_amt,'%%%',$total_cgst_amt,'%%**',$invoice_amount,'%*%*$',$amount,'#%#%$',$net_amt,'*%**%')" />
                    </xsl:call-template>
                    
                </div>
			</xsl:when>

			<xsl:otherwise>
				<div>						
                    <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                       	 	<div class="row-div">
                           	 <div class="namespacing">
                                <xsl:choose>
                            <xsl:when test="($doc_sales_type='I') ">
                                <div class="label-text">
                                    Recipient Name
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$doc_strg_name" />
                                </div>
                                </xsl:when>
                                </xsl:choose>
                            </div>
                       	 	</div>
                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    Address
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="concat($doc_addr1,$doc_addr2,$doc_addr3)" />
                                </div>
                            </div>
                        </div>

                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    GST No
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$gst_no" />
                                </div>
                            </div>
                        </div>

                        <div class="row-div">
                            <div class="namespacing">
                                <div class="label-text">
                                    State
                                </div>
                                <div class="data-value">
                                    <xsl:value-of select="$strg_state" />
                                </div>
                            </div>
                        </div>
                        
                        <div class="mobviewDiv">
                          <div class="namespacing">
                          <div class="value-shown">
                              <div class="label-text" >
                                  Tax is payabel on Reverse Charge 
                              </div>
                              <div class="data-value">
                                  No
                              </div>
                              </div>
                              <div class="value-shown">
                              <div class="label-text" >
                                  Partial/Full Reverse Charges
                              </div>
                              <div class="data-value">
                                  No
                              </div>
                              </div>
                          </div>
                       </div>
                          
                    </xsl:if>
                </div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="invoice_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
        
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="invoice_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>

        <xsl:variable name="customer_types">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*'),'####')" />
		</xsl:variable>
		
		<xsl:variable name="collection-form_cnt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'####'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="collection_details">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'**'),'##')" />
		</xsl:variable>

		<!-- <xsl:variable name="ord_data_host_url">
			<xsl:value-of select="substring-after($order_data_value,'##')" />
		</xsl:variable> -->
		
        <xsl:variable name="ord_data_host_url">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'##'),'%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_sgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%'),'%%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_cgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%%'),'%%**')" />
		</xsl:variable>
		
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%**'),'%*%*$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%*%*$'),'#%#%$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_net_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'#%#%$'),'*%**%')" />
		</xsl:variable>
		
		<!-- <xsl:variable name="doc_round_off">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%*%'),'**%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount_in_words">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'**%%'),'##**')" />
		</xsl:variable>-->

        <xsl:variable name="domID">
            <xsl:value-of select="@domID" />
        </xsl:variable>
		<xsl:if test="normalize-space($invoice_form_cnt) > 0 ">
				
			<xsl:variable name="invoiceCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $invoice_details)]">
                    <xsl:variable name="invoice_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($invoice_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="header-label">
                        <xsl:value-of select="string-length(normalize-space($invoiceCnt))" /> Item Details
                    </div>
                </xsl:when>
            </xsl:choose>
            
            <div class="mobviewDiv">
				<xsl:for-each
					select="//node()[starts-with(name(), $invoice_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="invoice_rate">
                            <xsl:value-of select="rate" />
                        </xsl:variable>
                        <xsl:variable name="invoice_remarks">
                            <xsl:value-of select="remarks_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoicevalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="total_sgst_amount">
							<xsl:value-of select="total_sgst_amount" />
						</xsl:variable>
						<xsl:variable name="total_cgst_amount">
                            <xsl:value-of select="total_cgst_amount" />
                        </xsl:variable>
						<xsl:variable name="total_amount">
                            <xsl:value-of select="total_amount" />
                        </xsl:variable>
                        <xsl:variable name="hsn_number">
                            <xsl:value-of select="hsn_number" />
                        </xsl:variable>
                        <xsl:variable name="tax_amt_inv">
                            <xsl:value-of select="tax_amt_inv" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                    <!-- <div class="sample-order-div">  -->
                                        <div class="row-div">
                                        <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                               <div class="label-text">
				                                   Item name
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$item_descr" />
				                               </div>
				                           </div>
				                       </div>
				                       </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Qty
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$quantity" />
				                               </div>
				                           </div>
				                           </div>
				
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   HSN No
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$hsn_number" />
				                               </div>
				                               </div>
				                           </div>
				
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Rate
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$invoice_rate" />
				                               </div>
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           	<div class="value-shown">
				                               <div class="label-text">
				                                   Basic Amount
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$invoicevalue" />
				                               </div>
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   SGST
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$total_sgst_amount" />(14.00%)
				                               </div>
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   CGST
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$total_cgst_amount" />(14.00%)
				                               </div>
				                              </div>
				                           </div>
                                    <!-- </div> -->
                                </xsl:if>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</div>
		</xsl:if>
		<!-- Invoice Details end -->
		<xsl:if test="normalize-space($collection-form_cnt) > 0">
            <xsl:variable name="collectionCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $collection_details)]">
                    <xsl:variable name="collection_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($collection_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="header-label">
                        <xsl:value-of select="string-length(normalize-space($collectionCnt))" /> Payment Details
                    </div>
                </xsl:when>
            </xsl:choose>
            
            <div class="mobviewDiv">
				<xsl:for-each
					select="//node()[starts-with(name(), $collection_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="collection_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="doc_pay_mode">
							<xsl:value-of select="pay_mode" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                    <!-- <div class="sample-order-div">  -->
                                    <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Payment Mode
				                               </div>
				                               <div class="data-value">
				                                   <!-- <xsl:value-of select="$doc_pay_mode" /> -->
				                                   <xsl:choose>
									<xsl:when test="($doc_pay_mode='C') ">
										CASH
									</xsl:when>
									<xsl:when test="($doc_pay_mode='Q') ">
										CHEQUE
									</xsl:when>
									<xsl:when test="($doc_pay_mode='O') ">
										ONLINE
									</xsl:when>
								</xsl:choose>
				                               </div>
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Taxable Amt
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_net_amt" />
				                               </div>
				                               </div>
				                           </div>
				
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total SGST
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_total_sgst_amt" />
				                               </div>
				                               </div>
				                           </div>
							<div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total CGST
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_total_cgst_amt" />
				                               </div>
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total Amount
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_amount" />
				                               </div>
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Invoice Amount
				                               </div>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_invoice_amount" />
				                               </div>
				                               </div>
				                           </div>
                                    <!-- </div> -->
                                </xsl:if>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</div>
		</xsl:if>
		<!-- End of collection details -->

	</xsl:template>

    
</xsl:stylesheet>
