<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}

					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color:white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					 padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}


                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                    .donebutton{
                        border-radius: 100%;
                        height: 20px;
                        width: 20px;
                        margin: 0 32px;
                    }
                    .mainbody{
                        background: #fff;
                        margin: auto;
                        width: calc(100% - 32px);
                        max-width: 1024px;
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                        /*margin: 24px 0;*/
                    	text-align: left;
                    	/*padding: 0 16px;*/
                    }
                    .tabs {
                        position: relative;
                        text-align: center;
                        /*width: 100%;*/
                        border-radius: 5px;
                        min-width: 240px;
                        min-height: 500px;
                        overflow-x: auto;
                        overflow-y: hidden;
                        -webkit-overflow-scrolling: touch;
                    }
                     .company-name{
	                font-size: 1.4em;
	                font-weight:bolder;
	                color: #000;
	                text-align: center;
	                line-height: 1.2;
	                padding: 0 0 10px 0;
	                }
	                .tax-challan-name{
	                font-size: 1.8em;
	                font-weight:bolder;
	                color: #000;
	                text-align: center;
	                line-height: 1.2;
	                padding: 0 0 10px 0;
	                }
	                .label-hardecode{
	                font-size: 1em;
	                font-weight:bolder;
	                color: #000;
	                text-align: left;
	                line-height: 1.2;
	                width:100%;
	                }
	                .label-text{
	                font-size: 1em;
	                font-weight:bolder;
	                color: #000;
	                text-align: left;
	                width:40%;
	                line-height: 1.2;
	                }
	                .label-text-large{
	                font-size: 1.2em;
	                font-weight:bolder;
	                color: #000;
	                text-align: left;
	                width:40%;
	                line-height: 1.2;
	                }
	                .colon{
	                color: #000;
	                margin-right:3px;
	                }
	                .colon-num{
	                color: #000;
	                }
	                .data-value{
	                font-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:60%;
	                }
	                .data-value-large{
	                font-size: 1.2em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:60%;
	                }
	                .tax-payable{
	                font-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:40%;
	                }
	                .tax-payable-data{
	                ffont-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 0 2px;
	                width:60%;
	                }
	                .value-shown{
	                display:flex;
	                width:100%;
	                align-items: center;
	                justify-content :space-between;
	                text-align: right;
    				/*padding-right: 10%;*/
	                }
	                .value-shown-tax{
	                display:flex;
	                width:100%;
	                align-items: center;
	                justify-content :space-between;
	                }
	                .horizontal_dotted_line {
	                 width:100%;
	                 border-bottom:1px dashed #000;
	                 
	                 }
					.bgcolorform{
	                        background-color: #fff;
	                  }
	                .namespacing{
	                        padding: 0 0 0 16px;
	                        text-align: left;
	                        line-height: 1.5;
	                        display: flex;
	                        width:100%;
	                 }
				</style>

			</head>



			<body bgcolor='#EEEEEE' onload="">
				<form name="Wizard_TravelDSR" style="margin-bottom:0" class="bgcolorform" id= " form formIDsummary ">			
                    <div class="mainbody">
                    
                        <div class="tabs ">
                          
                                <section id="section-n1">      
                                    <!-- Detail1(start) -->
                                    <xsl:variable name="activity_type">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="activity_type" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="place_required">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="place_required" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="host_url">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="host_url" />
                                        </xsl:for-each>
                                    </xsl:variable>

                                    <xsl:if test="normalize-space($place_required) = 'Y'">

                                        <xsl:variable name="detail1_listed_count">
                                            <xsl:for-each select="//Detail1">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail1)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>

                                        <xsl:if test="normalize-space($detail1_listed_count) > '0'">

                                            <xsl:variable name="detail1_form">
                                                <xsl:for-each select="//Detail1">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','1','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>

                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail1_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail1(end) -->
                                        <!-- Detail2(start) -->
                                        <xsl:variable name="detail2_listed_count">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail2)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                            <xsl:variable name="detail2_form">
                                                <xsl:for-each select="//Detail2">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','2','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail2_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail2(end) -->
                                        <!-- Detail3(start) -->
                                        <xsl:variable name="detail3_listed_count">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail3)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                            <xsl:variable name="detail3_form">
                                                <xsl:for-each select="//Detail3">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','3','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail3_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail3(end) -->
                                        <!-- Detail4(start) -->
                                        <xsl:variable name="detail4_listed_count">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail4)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                            <xsl:variable name="detail4_form">
                                                <xsl:for-each select="//Detail4">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','4','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail4_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail4(end) -->
                                        <!-- Detail5(start) -->
                                        <xsl:variable name="detail5_listed_count">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail5)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                            <xsl:variable name="detail5_form">
                                                <xsl:for-each select="//Detail5">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','5','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail5_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail5(end) -->
                                        <!-- Detail6(start) -->
                                        <xsl:variable name="detail6_listed_count">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail6)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                            <xsl:variable name="detail6_form">
                                                <xsl:for-each select="//Detail6">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','6','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail6_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail6(end) -->
                                        <!-- Detail7(start) -->
                                        <xsl:variable name="detail7_listed_count">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail7)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                            <xsl:variable name="detail7_form">
                                                <xsl:for-each select="//Detail7">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','7','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail7_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail7(end) -->
                                        <!-- Detail8(start) -->
                                        <xsl:variable name="detail8_listed_count">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail8)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                            <xsl:variable name="detail8_form">
                                                <xsl:for-each select="//Detail8">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','8','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail8_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail8(end) -->
                                        <!-- Detail9(start) -->
                                        <xsl:variable name="detail9_listed_count">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail9)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                            <xsl:variable name="detail9_form">
                                                <xsl:for-each select="//Detail9">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','9','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail9_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail9(end) -->
                                        <!-- Detail10(start) -->
                                        <xsl:variable name="detail10_listed_count">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail10)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail10_listed_count) > '0'">
                                            <xsl:variable name="detail10_form">
                                                <xsl:for-each select="//Detail10">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','10','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail10_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                    </xsl:if>
							        <!-- Detail10(end) -->
							        
                                </section>
						</div>
					</div>

				</form>
			</body>
		</html>
	</xsl:template>

    <xsl:variable name="host_Url">
        <xsl:for-each select="//Detail1">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
   <!--  <xsl:variable name="pay_modes">
                <xsl:for-each select="//Detail10">
		  <xsl:value-of select="pay_mode" />
	</xsl:for-each>
    </xsl:variable>-->

    <xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />


		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>

		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>

		<xsl:variable name="form_no">
			<xsl:value-of select="substring-before(substring-after($value, '('), '|')" />
		</xsl:variable>

		<xsl:variable name="activity">
			<xsl:value-of select="substring-before(substring-after($value, '|'), '*')" />
		</xsl:variable>
		<xsl:variable name="place_mandatory">
			<xsl:value-of select="substring-before(substring-after($value, '*'), '#')" />
		</xsl:variable>
		<xsl:variable name="host">
			<xsl:value-of select="substring-after($value,'#')" />
		</xsl:variable>

		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>
		
		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)][attribute/@updateFlag!='D'][not(contains(cust_type, 'UNLISTED'))])" />
			</xsl:variable>
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">
								<xsl:for-each select="//Detail1">
									<xsl:variable name="strg_name">
										<xsl:value-of select="strg_name" />
									</xsl:variable>
									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>
									<xsl:variable name="invoice_form_no">
										<xsl:value-of select="invoice_form_no" />
									</xsl:variable>
									<xsl:variable name="collection_form_no">
										<xsl:value-of select="collection_form_no" />
									</xsl:variable>
									<xsl:variable name="addr1">
										<xsl:value-of select="addr1" />
									</xsl:variable>
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									<xsl:variable name="addr2">
										<xsl:value-of select="addr2" />
									</xsl:variable>
									<xsl:variable name="addr3">
										<xsl:value-of select="addr3" />
									</xsl:variable>
									<xsl:variable name="net_amt">
										<xsl:value-of select="net_amt" />
									</xsl:variable>
									<xsl:variable name="tax_amount">
										<xsl:value-of select="tax_amount" />
									</xsl:variable>
									<xsl:variable name="amount">
										<xsl:value-of select="amount" />
									</xsl:variable>
									<xsl:variable name="invoice_amount">
										<xsl:value-of select="invoice_amount" />
									</xsl:variable>
									<xsl:variable name="total_sgst_amt">
										<xsl:value-of select="total_sgst_amt" />
									</xsl:variable>
									<xsl:variable name="total_cgst_amt">
										<xsl:value-of select="total_cgst_amt" />
									</xsl:variable>
									<xsl:variable name="strg_gst_no">
                                        					<xsl:value-of select="gst_no" />
									</xsl:variable>
									<xsl:variable name="customer_type">
										<xsl:value-of select="cust_type" />
									</xsl:variable>
									<xsl:variable name="strg_type">
										<xsl:value-of select="strg_type" />
									</xsl:variable>
									<xsl:variable name="address_as">
										<xsl:value-of select="address_as" />
									</xsl:variable>

									    <xsl:variable name="round_off">
										<xsl:value-of select="round_off" />
									    </xsl:variable>
									    <xsl:variable name="amount_in_word">
										<xsl:value-of select="amount_in_word" />
									    </xsl:variable>
									    <xsl:variable name="sales_type">
										 <xsl:value-of select="sales_type" />
									    </xsl:variable>
									    <xsl:variable name="strg_state">
										 <xsl:value-of select="strg_state" />
									    </xsl:variable>
									    <xsl:variable name="sales_pers_name">
										 <xsl:value-of select="sales_pers_sp_name" />
									    </xsl:variable>
									    <xsl:variable name="event_date">
											<xsl:value-of select="event_date" />
										    </xsl:variable>
									    <xsl:variable name="event_time_start">
										<xsl:value-of select="event_time_start" />
									</xsl:variable>
									<xsl:variable name="event_time_end">
										<xsl:value-of select="event_time_end" />
									</xsl:variable>
									<xsl:variable name="load_no">
										<xsl:value-of select="load_no" />
									</xsl:variable>
									<xsl:variable name="vehicle_no">
										<xsl:value-of select="vehicle_no" />
									</xsl:variable>
									<xsl:variable name="reference_no">
										<xsl:value-of select="reference_no" />
									</xsl:variable>
									<xsl:variable name="minimum_invoice">
										<xsl:value-of select="minimum_invoice" />
									</xsl:variable>
									<xsl:variable name="invoice_ref_id">
										<xsl:value-of select="invoice_no" />
									</xsl:variable>
									<xsl:variable name="gst_code">
										<xsl:value-of select="gst_code" />
									</xsl:variable>
									<xsl:call-template name="tmpOrderFeed">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$invoice_form_no,'#',$strg_name,'(',$addr1,'*',$strg_code,'!',$collection_form_no,'|',$addr2,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$strg_gst_no,'%',$invoice_amount,'?',$total_sgst_amt,'{',$total_cgst_amt,'}',$customer_type,'@@',$strg_type,'[',$address_as,'||',$round_off,'$%',$amount_in_word,'$$%',$sales_type,'%%$',$strg_state,'%%$$',$sales_pers_name,'[%]',$event_date,'(^|',$event_time_start,'([|',$event_time_end,'%|]',$load_no,'[%*',$vehicle_no,'%^*$',$reference_no,'*$^|',$minimum_invoice,'|^$*%',$invoice_ref_id,'#*#',$gst_code)" />
									</xsl:call-template>

								</xsl:for-each>
					</xsl:if>
				</xsl:if>
			
	</xsl:template>
	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="invoice_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_addr1">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="collection_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="doc_addr2">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="doc_addr3">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="doc_net_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="doc_tax_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="doc_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="strg_gst_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="total_sgst_amt">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="total_cgst_amt">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="strg_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'[')" />
		</xsl:variable>

		<xsl:variable name="address_as">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'['),'||')" />
		</xsl:variable>


		<xsl:variable name="doc_round_off">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount_in_word">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$%'),'%%$')" />
		</xsl:variable>
        
        <xsl:variable name="strg_state">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%$'),'%%$$')" />
		</xsl:variable>
		
		<xsl:variable name="sales_pers_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%$$'),'[%]')" />
		</xsl:variable>
		
		<xsl:variable name="event_date">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'[%]'),'(^|')" />
		</xsl:variable>
		
		<xsl:variable name="event_time_start">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'(^|'),'([|')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'([|'),'%|]')" />
		</xsl:variable>
		<xsl:variable name="load_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%|]'),'[%*')" />
		</xsl:variable>
		
		<xsl:variable name="vehicle_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'[%*'),'%^*$')" />
		</xsl:variable>
		<xsl:variable name="reference_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%^*$'),'*$^|')" />
		</xsl:variable>
		<xsl:variable name="minimum_invoice">
			<xsl:value-of select="substring-before(substring-after($ord_value,'*$^|'),'|^$*%')" />
		</xsl:variable>
		
		<xsl:variable name="invoice_ref_id">
			<xsl:value-of select="substring-before(substring-after($ord_value,'|^$*%'),'#*#')" />
		</xsl:variable>
		
		<xsl:variable name="strg_gst_code">
			<xsl:value-of select="substring-after($ord_value,'#*#')" />
		</xsl:variable>
		

		<xsl:variable name="invoice_detail">
			<xsl:value-of select="concat('Detail',$invoice_form_no)" />
		</xsl:variable>
		<xsl:variable name="collection_detail">
			<xsl:value-of select="concat('Detail',$collection_form_no)" />
		</xsl:variable>
		<xsl:variable name="invoice_listed_count">
			<xsl:if test="normalize-space($invoice_form_no)!=''">

				<xsl:for-each select="//node()[starts-with(name(), $invoice_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of select="count(//node()[starts-with(name(), $invoice_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="collection_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $collection_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="collection_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($collection_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of select="count(//node()[starts-with(name(), $collection_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="collection_pay_mode">
		<xsl:for-each select="//node()[starts-with(name(), $collection_detail)]">
			<xsl:value-of select="pay_mode" />
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="inv_ref_start">
			<xsl:value-of select="substring-before($invoice_ref_id,'/')" />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="($collection_pay_mode!='C') ">
                <div>
                        <xsl:if
                       		 test="not(contains($customer_types, 'UNLISTED'))">
								<xsl:choose>
									<xsl:when test="$invoice_listed_count > '0'">
                                  	<xsl:choose>
                           	 		<xsl:when test="(normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
	                                <div class="tax-challan-name">
	                                    Delivery Challan
	                                </div>
                               		 </xsl:when>
                               		 <xsl:when test="(normalize-space($doc_sales_type) = 'C')">
                               		 	<div class="tax-challan-name">
	                                    TAX Invoice
	                                	</div>
                               		 </xsl:when>
                                	 <xsl:otherwise>
                                	 	<div class="tax-challan-name">
	                                    TAX Invoice
	                                	</div>
                                	</xsl:otherwise>
                                	</xsl:choose>
									</xsl:when>
                                	 <xsl:otherwise>
									</xsl:otherwise>
                                </xsl:choose> 
                      		  	<div class="horizontal_dotted_line">
	                                      <div class="company-name" >
	                                          M/s Langar Bidi Company Poona
	                                      </div>
	                            </div>	                              
	                          	<div class="horizontal_dotted_line">
									<div class="namespacing">
											<div class="label-text" >
												Supplier Name
											</div>
											<span class="colon">:</span>
											<div class="data-value">
												M/s Langar Bidi Company Poona, Gwalior Depo
											</div>
									</div>
									<div class="namespacing">
											<div class="label-text" >
												Address
											</div>
											<span class="colon">:</span>
											<div class="data-value">
												A-18/399 Transport Nagar, Near Water Tank, Gwalior
											</div>
									</div>
									<div class="namespacing">
											<div class="label-text" >
												GSTIN No
											</div>
											<span class="colon">:</span>
											<div class="data-value" >
												23AAAFL5383K1Z8                                                 
											</div>
									</div>
									<div class="namespacing">
											<div class="label-text" >
												State
											</div>
											<span class="colon">:</span>
											<div class="data-value" >
									 			23 / Madhya Pradesh                                            
											</div>  
									</div>                                     
								</div>
               			</xsl:if>
               	</div>
				<xsl:choose>
					<xsl:when test="$invoice_listed_count > '0'">
						<div>
							<xsl:if
								test="not(contains($customer_types, 'UNLISTED'))">
									
								<div class="horizontal_dotted_line">
									<div class="namespacing">
										<div class="label-text-large">
											Recipient Name
										</div>
										<span class="colon">:</span>
										<xsl:choose>
											<xsl:when test="($doc_sales_type='I') ">
												<div class="data-value-large">
												<xsl:value-of select="$doc_strg_name" />
												</div>
											</xsl:when>
											<xsl:otherwise>
												<div class="data-value-large">
													Cash Sale
												</div>
											</xsl:otherwise>
										</xsl:choose>
										
									</div>
									<div class="namespacing">
										<div class="label-text">
											Address
										</div>
										<span class="colon">:</span>
										<div class="data-value">
											<xsl:value-of select="concat($doc_addr1,' ',$doc_addr2,' ',$doc_addr3)" />
										</div>
									</div>

									<div class="namespacing">
										<div class="label-text">
											GST No
										</div>
										<span class="colon">:</span>
										<div class="data-value">
											<xsl:value-of select="$strg_gst_no" />
										</div>
									</div>

									<div class="namespacing">
										<div class="label-text">
											State
										</div>
										<span class="colon">:</span>
										<div class="data-value">
							<!-- 				<xsl:value-of select="$strg_state" />	-->
											<xsl:variable name="strg_state_code">
												<xsl:value-of select="substring-before($strg_state, '(')" />
											</xsl:variable>
											<xsl:value-of select = "concat($strg_gst_code,' ','/',' ',$strg_state_code)" />
										</div>
									</div>
									<div class="namespacing">
										<xsl:choose>
											<xsl:when test="(($collection_pay_mode='Q' or $collection_pay_mode='C') and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
												<div class="label-text">
													Challan No/Date
												</div>
												<span class="colon">:</span>
											</xsl:when>
											<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
												<div class="label-text">
													Invoice No/Date
												</div>
												<span class="colon">:</span>
											</xsl:when>
											<xsl:otherwise>
												<div class="label-text">
													Invoice No/Date
												</div>
												<span class="colon">:</span>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:choose>
											<xsl:when test="(normalize-space($inv_ref_start) != '') ">
												<div class="data-value">
											<xsl:value-of select="concat($inv_ref_start,'/',$minimum_invoice,' / ',$event_date)" />
										</div>
											</xsl:when>
											<xsl:otherwise>
												<div class="data-value">
											<xsl:value-of select="concat($minimum_invoice,' / ',$event_date)" />
										</div>
											</xsl:otherwise>
										</xsl:choose>
										
									</div>
									
								</div>
									<div class="horizontal_dotted_line">
									<div class="namespacing">
										<div class="value-shown-tax">
											<div class="tax-payable" >
												Partial/Full Reverse Charge
											</div>
											<span class="colon-num">:</span>
											<div class="tax-payable-data">
												No
											</div>
										</div>
										</div>
									</div> 
							</xsl:if>
						
						</div>
							<xsl:call-template name="tempOrderDataFeed">
							<xsl:with-param name="orderData"
								select="concat($invoice_detail,'@',$doc_strg_code,'#',$invoice_listed_count,'*',$customer_types,'####',$collection_listed_count,'**',$collection_detail,'##',$ord_host_url,'%%',$total_sgst_amt,'%%%',$total_cgst_amt,'%%**',$doc_invoice_amount,'%*%*$',$doc_amount,'#%#%$',$doc_net_amt,'*%**%',$doc_round_off,'~^',$doc_amount_in_word,'%~^',$sales_pers_name,'%%^^',$event_date,'[%]',$event_time_start,'([||',$event_time_end,'~^%}]',$strg_gst_no,'*%]^',$doc_sales_type,'[%*',$load_no,'%|]',$vehicle_no,'*~*',$minimum_invoice,'*~**~',$inv_ref_start)" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>  
								<div class="horizontal_dotted_line">
									<div class="namespacing">
										<div class="label-text-large">
											Recipient Name
										</div>
										<span class="colon">:</span>
										<div class="data-value-large">
												<xsl:value-of select="$doc_strg_name" />
										</div>
									</div>
									<div class="namespacing">
										<div class="label-text">
											Address
										</div>
										<span class="colon">:</span>
										<div class="data-value">
											<xsl:value-of select="concat($doc_addr1,' ',$doc_addr2,' ',$doc_addr3)" />
										</div>
									</div>
									<div class="namespacing">
										<div class="label-text">
											GST No
										</div>
										<span class="colon">:</span>
										<div class="data-value">
											<xsl:value-of select="$strg_gst_no" />
										</div>
									</div>
									<div class="namespacing">
										<div class="label-text">
											State
										</div>
										<span class="colon">:</span>
										<div class="data-value">
											<xsl:variable name="strg_state_code">
												<xsl:value-of select="substring-before($strg_state, '(')" />
											</xsl:variable>
							<!--  				<xsl:value-of select="$strg_state" /> -->
											<xsl:value-of select = "concat($strg_gst_code,' ','/',' ',$strg_state_code)" />
										</div>
									</div>  
									</div>       
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
						<xsl:call-template name="payModeCash">
										<xsl:with-param name="payModeCashIDs"
										select="concat($ord_host_url,'@',$invoice_form_no,'#',$doc_strg_name,'(',$doc_addr1,'*',$doc_strg_code,'!',$collection_form_no,'|',$doc_addr2,'^',$doc_addr3,'+',$doc_net_amt,'**',$doc_tax_amount,'~',$doc_amount,'##',$strg_gst_no,'%',$doc_invoice_amount,'?',$total_sgst_amt,'{',$total_cgst_amt,'}',$customer_types,'@@',$strg_type,'[',$address_as,'||',$doc_round_off,'$%',$doc_amount_in_word,'$$%',$doc_sales_type,'%%$',$strg_state,'%%$$',$sales_pers_name,'[%]',$event_date,'(^|',$event_time_start,'([|',$event_time_end,'%|]',$load_no,'[%*',$vehicle_no,'%^*$',$reference_no,'*$^|',$minimum_invoice,'%^$*%',$inv_ref_start,'#**#',$strg_gst_code)" />
									
						</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="invoice_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
        
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="invoice_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>

        <xsl:variable name="customer_types">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*'),'####')" />
		</xsl:variable>
		
		<xsl:variable name="collection-form_cnt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'####'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="collection_details">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'**'),'##')" />
		</xsl:variable>
        <xsl:variable name="ord_data_host_url">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'##'),'%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_sgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%'),'%%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_cgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%%'),'%%**')" />
		</xsl:variable>
		
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%**'),'%*%*$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%*%*$'),'#%#%$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_net_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'#%#%$'),'*%**%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_round_off">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%**%'),'~^')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_amt_in_word">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'~^'),'%~^')" />
		</xsl:variable>
		
		<xsl:variable name="sales_pers_name">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%~^'),'%%^^')" /> 
		</xsl:variable>
		<xsl:variable name="event_date">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%^^'),'[%]')" /> 
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'[%]'),'([||')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'([||'),'~^%}]')" /> 
		</xsl:variable>
		<xsl:variable name="strg_gst_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'~^%}]'),'*%]^')" /> 
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%]^'),'[%*')" /> 
		</xsl:variable>
		<xsl:variable name="doc_load_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'[%*'),'%|]')" /> 
		</xsl:variable> 
		<xsl:variable name="doc_vehicle_no">
	<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%|]'),'*~*')" /> 		
		</xsl:variable>
		<xsl:variable name="doc_minimum_invoice">
	<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*~*'),'*~**~')" /> 		
		</xsl:variable>
		<xsl:variable name="inv_ref_start">
			<xsl:value-of 
			    select="substring-after($order_data_value,'*~**~')" /> 
		</xsl:variable>

        <xsl:variable name="domID">
            <xsl:value-of select="@domID" />
        </xsl:variable>
		<xsl:if test="normalize-space($invoice_form_cnt) > 0 ">
				
			<xsl:variable name="invoiceCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $invoice_details)]">
                    <xsl:variable name="invoice_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($invoice_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
				<xsl:for-each
					select="//node()[starts-with(name(), $invoice_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="invoice_rate">
                            <xsl:value-of select="rate" />
                        </xsl:variable>
                        <xsl:variable name="invoice_remarks">
                            <xsl:value-of select="remarks_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoicevalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="total_sgst_amount">
							<xsl:value-of select="total_sgst_amount" />
						</xsl:variable>
						<xsl:variable name="total_cgst_amount">
                            <xsl:value-of select="total_cgst_amount" />
                        </xsl:variable>
						<xsl:variable name="total_amount">
                            <xsl:value-of select="total_amount" />
                        </xsl:variable>
                        <xsl:variable name="hsn_number">
                            <xsl:value-of select="hsn_number" />
                        </xsl:variable>
                        <xsl:variable name="tax_amt_inv">
                            <xsl:value-of select="tax_amt_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoice_id">
                            <xsl:value-of select="invoice_id" />
                        </xsl:variable>
						<xsl:if test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="normalize-space($quantity) > 0">
									<xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                        <!--<div class="horizontal_dotted_line">-->
				                           <div class="namespacing">
				                               <div class="label-text">
				                                   Item name
				                               </div>
				                               <span class="colon">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$item_descr" />
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Qty
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$quantity" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   HSN No
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$hsn_number" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Rate
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                       <!--            <xsl:value-of select="$invoice_rate" />	-->
				                       			<xsl:choose>
				                               	<xsl:when test="contains($invoice_rate,'.')"> 
				                               		<xsl:value-of select="$invoice_rate" />
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select='format-number($invoice_rate, "00.00")' />
			                               		</xsl:otherwise>
			                               		</xsl:choose>
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Basic Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:choose>
				                               	<xsl:when test="contains($invoice_rate,'.')"> 
				                               		<xsl:value-of select="$invoicevalue" />
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select='format-number($invoicevalue, "00.00")' />
			                               		</xsl:otherwise>
			                               		</xsl:choose>
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   SGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                    <!--                <xsl:value-of select="$total_sgst_amount" />(14.00%)-->
				                    			<xsl:value-of select='format-number($total_sgst_amount, "00.00")' />(14.00%)
				                               </div>
				                           </div>
				                       </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   CGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                      <!--            <xsl:value-of select="$total_cgst_amount" />(14.00%)  -->
				                      				<xsl:value-of select='format-number($total_cgst_amount, "00.00")' />(14.00%)
				                               </div>
				                           </div>
				                           </div>
                                    <!-- </div>-->
                                    </xsl:if>
                                <div class="horizontal_dotted_line"></div>
                                </xsl:if>                                
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
		</xsl:if>
		<!-- Invoice Details end -->
		<xsl:if test="normalize-space($collection-form_cnt) > 0">
            <xsl:variable name="collectionCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $collection_details)]">
                    <xsl:variable name="collection_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($collection_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
				<xsl:for-each
					select="//node()[starts-with(name(), $collection_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="collection_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="doc_pay_mode">
							<xsl:value-of select="pay_mode" />
						</xsl:variable>
						<xsl:variable name="cheque_amt">
							<xsl:value-of select="amount" />
						</xsl:variable>
						<xsl:variable name="cheque_date">
							<xsl:value-of select="ref_date" />
						</xsl:variable>
						<xsl:variable name="cheque_no">
							<xsl:value-of select="ref_no" />
						</xsl:variable>
						<xsl:variable name="bank_name">
							<xsl:value-of select="ref_bank" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                <xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode='Q' and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '') ">
					                             		</xsl:when>
					                              		<xsl:otherwise>
							                           <div class="namespacing">
							                               			<div class="label-text">
							                                  			 Payment Mode
							                               			</div>
							                               			<span class="colon">:</span>
							                              		 	<div class="data-value">
							                                   			<xsl:choose>
														<xsl:when test="($doc_pay_mode='C') ">
															CASH
														</xsl:when>
														<xsl:when test="($doc_pay_mode='Q') ">
															CHEQUE
														</xsl:when>
														<xsl:when test="($doc_pay_mode='R') ">
															RTGS
														</xsl:when>
														<xsl:when test="($doc_pay_mode='N') ">
															NEFT
														</xsl:when>
														<xsl:when test="($doc_pay_mode='U') ">
															UPI
														</xsl:when>
														<xsl:when test="($doc_pay_mode='O') ">
															ONLINE
														</xsl:when>
																		</xsl:choose>
							                               			</div>
							                           </div>
					                                  	</xsl:otherwise>
					                                  	
					                              </xsl:choose>
					                           <xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode='Q' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='U' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='N' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='R' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                              		<xsl:otherwise>
					                                  	</xsl:otherwise>
					                                  	</xsl:choose>
					                                  	<xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode!='Q' or($doc_pay_mode='Q' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = ''))) ">
					                                  	<div class="horizontal_dotted_line">
                                 					    </div>
                                 					  </xsl:when>
                                 					  </xsl:choose>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Taxable Amt
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:choose>
				                               	<xsl:when test="not(contains($doc_net_amt,'.'))">
				                               		<xsl:value-of select='format-number($doc_net_amt, "00.00")' />   	
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select="$doc_net_amt" />
			                               		</xsl:otherwise>
			                               		</xsl:choose>
				                               </div>
				                           </div>
											</div>

				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total SGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                            <!--         <xsl:value-of select="$doc_total_sgst_amt" />	-->
				                            		<xsl:value-of select='format-number($doc_total_sgst_amt, "00.00")' />
				                               </div>
				                           </div>
				                           </div>
				
				                       <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total CGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                           <!--         <xsl:value-of select="$doc_total_cgst_amt" />	-->
				                           		<xsl:value-of select='format-number($doc_total_sgst_amt, "00.00")' />
				                               </div>
				                           </div>
				                           </div>
				                       </div>
									
				                       <xsl:choose>
                           	           <xsl:when test="(normalize-space($doc_round_off) !=0 or normalize-space($doc_round_off) !=0.0) ">
	                                <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Total Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_amount" />
				                               </div>
				                           </div>
				                           </div>
				                           
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Round off
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_round_off" />
				                               </div>
				                           </div>
				                           </div>
                                </xsl:when>
                                <xsl:otherwise>
                                </xsl:otherwise>
                                </xsl:choose>
				                           <!--<div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Total Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_amount" />
				                               </div>
				                           </div>
				                           </div>
				                           
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Round off
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_round_off" />
				                               </div>
				                           </div>
				                           </div>-->
				                       
				                           <div class="namespacing">
				                           	<div class="value-shown">
				                           		<xsl:choose>
			                           	 		<xsl:when test="(($doc_pay_mode='Q' or $doc_pay_mode='C') and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
				                                	<div class="label-text-large">
				                                   Challan Amount
				                               </div>
				                               <span class="colon-num">:</span>
			                               		</xsl:when>
			                               		<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
													<div class="label-text-large">
				                                   Invoice Amount
				                               </div>
				                               <span class="colon-num">:</span>
												</xsl:when>
			                                	<xsl:otherwise>
				                                <div class="label-text-large">
				                                   Invoice Amount
				                               </div>
				                               <span class="colon-num">:</span>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                               <div class="data-value-large">
				                               	   <xsl:value-of select='format-number($doc_invoice_amount, "00.00")' />
				                               </div>
				                           	</div>
				                           </div>
				                           <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text-large">
					                                   Amount in Words
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value-large">
					                                   <xsl:value-of select="$doc_amt_in_word" />
					                               </div>
					                           </div>
					                           </div>
				                           </div>
				                           <div class="namespacing">
					                               <div class="label-text">
					                                   Transport Mode
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   Vehicle
					                               </div>
					                        </div>
					                        <div class="namespacing">
					                               <div class="label-text">
					                                   Load No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$doc_load_no" />
					                               </div>
					                        </div>
					                        <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Vehicle No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$doc_vehicle_no" />
					                               </div>
					                           </div>
				                           </div>
				                           <!-- <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Eway Bill
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   
					                               </div>
					                           </div>
				                           </div> -->
				                           <div class="namespacing">
					                               <div class="label-text">
					                                   Printed On
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value" id="printed-on">
					                                </div>
					                        </div>
				                           <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Prepared By
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$sales_pers_name" />
					                               </div>
					                           </div>
				                           </div>
				                           <xsl:choose>
			                           	 		<xsl:when test="($doc_pay_mode='Q' and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '') ">
			                               		</xsl:when>
			                                	<xsl:otherwise>
			                                	<div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Ref.No/Date
					                               </div>
					                               <span class="colon">:</span>
												   <xsl:choose>
														<xsl:when test="(normalize-space($inv_ref_start) != '') ">
															<div class="data-value">
														<xsl:value-of select="concat($inv_ref_start,'/',$doc_minimum_invoice,' / ',$event_date)" />
													</div>
														</xsl:when>
														<xsl:otherwise>
															<div class="data-value">
														<xsl:value-of select="concat($doc_minimum_invoice,' / ',$event_date)" />
													</div>
														</xsl:otherwise>
													</xsl:choose>
					                           </div>
				                           </div>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                           		<xsl:choose>
			                           	 		<xsl:when test="(($doc_pay_mode='Q' or $doc_pay_mode='C') and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
			                           	 		<div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-hardecode">
					                                   Since computer generated challan,Signature is not mandatory
					                               </div>
					                           </div>											   
				                          	 </div>
			                           	 		<div class="namespacing">
				                                	<div class="label-hardecode">
					                                   1. Goods are sent on approval basis in terms of section 31 of the Central Goods and Service Tax Act, 2017 read with Rule 55 of the said rules.
					                                </div>
					                                </div>
					                                <div class="namespacing">
					                               <div class="label-hardecode">
					                                   2.Intimation for acceptance or rejection of goods shall be provided within 72 hours of issuance of Delivery Challan.In case of no intimation, it would be deemed to be accepted. 
					                               </div>
					                               </div>
			                               		</xsl:when>
			                               		<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
				                               		<div class="namespacing">
						                               <div class="label-hardecode">
						                                   Since computer generated invoice,Signature is not mandatory
						                               </div>
						                           </div>
			                               		</xsl:when>
			                                	<xsl:otherwise>
					                           <div class="namespacing">
					                               <div class="label-hardecode">
					                                   Since computer generated invoice,Signature is not mandatory
					                               </div>
					                           </div>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                           
				                       
                                </xsl:if>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
		</xsl:if>
		<div style="margin-top:50px">
		<div class="horizontal_dotted_line">
			<div class="namespacing">
				<div class="label-hardecode" style="text-align: center;display:none;" id="print-label">
					Received By
				</div>
			</div>
		</div>
		<div class="">
			<div class="namespacing">
				<div class="label-hardecode" style="display:none;text-align: center;" id="cust_copy_text">
					Customer Copy
				</div>
			</div>
			<div class="namespacing">
				<div class="label-hardecode" style="display:none;text-align: center;" id="sup_copy_text">
					Supplier Copy
				</div>
			</div>
		</div>
		</div>
		<!-- End of collection details -->

	</xsl:template>
	<xsl:template name="payModeCash">
		<xsl:param name="payModeCashIDs" />
		<xsl:variable name="cashvalue">
			<xsl:value-of select="$payModeCashIDs" />
		</xsl:variable>
		<xsl:variable name="invoice_form_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($cashvalue,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_addr1">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="collection_form_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="doc_addr2">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="doc_addr3">
			<xsl:value-of select="substring-before(substring-after($cashvalue,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="doc_net_amt">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="doc_tax_amount">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'**'),'~')" />
		</xsl:variable>
		<xsl:variable name="doc_amount">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="strg_gst_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of select="substring-before(substring-after($cashvalue,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="total_sgst_amt">
			<xsl:value-of select="substring-before(substring-after($cashvalue,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="total_cgst_amt">
			<xsl:value-of select="substring-before(substring-after($cashvalue,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'}'),'@@')" />
		</xsl:variable>
		<xsl:variable name="strg_type">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'@@'),'[')" />
		</xsl:variable>
		<xsl:variable name="address_as">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'['),'||')" />
		</xsl:variable>
		<xsl:variable name="doc_round_off">
		    <xsl:value-of
				select="substring-before(substring-after($cashvalue,'||'),'$%')" />
		</xsl:variable>
		<xsl:variable name="doc_amount_in_word">
		    <xsl:value-of
				select="substring-before(substring-after($cashvalue,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'$$%'),'%%$')" />
		</xsl:variable>
        <xsl:variable name="strg_state">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'%%$'),'%%$$')" />
		</xsl:variable>
		<xsl:variable name="sales_pers_name">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'%%$$'),'[%]')" />
		</xsl:variable>
		<xsl:variable name="event_date">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'[%]'),'(^|')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'(^|'),'([|')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'([|'),'%|]')" />
		</xsl:variable>
		<xsl:variable name="load_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'%|]'),'[%*')" />
		</xsl:variable>
		<xsl:variable name="vehicle_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'[%*'),'%^*$')" />
		</xsl:variable>
		<xsl:variable name="reference_no">
			<xsl:value-of
				select="substring-before(substring-after($cashvalue,'%^*$'),'*$^|')" />
		</xsl:variable>
		<xsl:variable name="minimum_invoice">
			<xsl:value-of 
			   select="substring-before(substring-after($cashvalue,'*$^|'),'%^$*%')" />
		</xsl:variable>
		<xsl:variable name="inv_ref_start">
			<xsl:value-of select="substring-before(substring-after($cashvalue,'%^$*%'),'#**#')" />
		</xsl:variable>
		<xsl:variable name="strg_gst_code">
			<xsl:value-of select="substring-after($cashvalue,'#**#')" />
		</xsl:variable>
		<xsl:variable name="firstInvId">
			<xsl:value-of select="substring-before($reference_no,',')" />
		</xsl:variable>
		<xsl:variable name="remainingInvID">
			<xsl:value-of select="substring-after($reference_no,',')" />
		</xsl:variable>
		<!--<xsl:variable name="invformRefId">
			<xsl:choose>
				<xsl:when test="(normalize-space($inv_ref_start) != '') ">
					<xsl:value-of select="concat($inv_ref_start,'/',$firstInvId)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$firstInvId" />
				</xsl:otherwise>
              </xsl:choose>
		</xsl:variable>-->
		<xsl:variable name="invformRefId">
			<xsl:value-of select="$firstInvId" />
		</xsl:variable>
					<xsl:call-template name="payModeCashFeed">
							<xsl:with-param name="payModeCashFeed"
								select="concat($ord_host_url,'@',$invoice_form_no,'#',$doc_strg_name,'(',$doc_addr1,'*',$doc_strg_code,'!',$collection_form_no,'|',$doc_addr2,'^',$doc_addr3,'+',$doc_net_amt,'**',$doc_tax_amount,'~',$doc_amount,'##',$strg_gst_no,'%',$doc_invoice_amount,'?',$total_sgst_amt,'{',$total_cgst_amt,'}',$customer_types,'@@',$strg_type,'[',$address_as,'||',$doc_round_off,'$%',$doc_amount_in_word,'$$%',$doc_sales_type,'%%$',$strg_state,'%%$$',$sales_pers_name,'[%]',$event_date,'(^|',$event_time_start,'([|',$event_time_end,'%|]',$load_no,'[%*',$vehicle_no,'%^*$',$invformRefId,'*$^|',$minimum_invoice,'*~^%*',$inv_ref_start,'#$%^',$strg_gst_code)" />
					</xsl:call-template>
		<xsl:if test="normalize-space($remainingInvID)!=''">
					<xsl:call-template name="payModeCash">
							<xsl:with-param name="payModeCashIDs"
								select="concat($ord_host_url,'@',$invoice_form_no,'#',$doc_strg_name,'(',$doc_addr1,'*',$doc_strg_code,'!',$collection_form_no,'|',$doc_addr2,'^',$doc_addr3,'+',$doc_net_amt,'**',$doc_tax_amount,'~',$doc_amount,'##',$strg_gst_no,'%',$doc_invoice_amount,'?',$total_sgst_amt,'{',$total_cgst_amt,'}',$customer_types,'@@',$strg_type,'[',$address_as,'||',$doc_round_off,'$%',$doc_amount_in_word,'$$%',$doc_sales_type,'%%$',$strg_state,'%%$$',$sales_pers_name,'[%]',$event_date,'(^|',$event_time_start,'([|',$event_time_end,'%|]',$load_no,'[%*',$vehicle_no,'%^*$',$remainingInvID,'*$^|',$minimum_invoice,'%^$*%',$inv_ref_start,'#**#',$strg_gst_code)" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="payModeCashFeed">
		<xsl:param name="payModeCashFeed" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$payModeCashFeed" />
		</xsl:variable>
		<xsl:variable name="invoice_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_addr1">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="collection_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="doc_addr2">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="doc_addr3">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="doc_net_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="doc_tax_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="doc_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="strg_gst_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="total_sgst_amt">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="total_cgst_amt">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="strg_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'[')" />
		</xsl:variable>

		<xsl:variable name="address_as">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'['),'||')" />
		</xsl:variable>


		<xsl:variable name="doc_round_off">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount_in_word">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$%'),'%%$')" />
		</xsl:variable>
        
        <xsl:variable name="strg_state">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%$'),'%%$$')" />
		</xsl:variable>
		
		<xsl:variable name="sales_pers_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%$$'),'[%]')" />
		</xsl:variable>
		
		<xsl:variable name="event_date">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'[%]'),'(^|')" />
		</xsl:variable>
		
		<xsl:variable name="event_time_start">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'(^|'),'([|')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'([|'),'%|]')" />
		</xsl:variable>
		<xsl:variable name="load_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%|]'),'[%*')" />
		</xsl:variable>
		
		<xsl:variable name="vehicle_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'[%*'),'%^*$')" />
		</xsl:variable>
		<xsl:variable name="cash_invoice_id">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%^*$'),'*$^|')" /> 
		</xsl:variable>
		<xsl:variable name="minimum_invoice">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'*$^|'),'*~^%*')" /> 
		</xsl:variable>
		<xsl:variable name="inv_ref_start">
			<xsl:value-of select="substring-before(substring-after($ord_value,'*~^%*'),'#$%^')" />
		</xsl:variable>
		<xsl:variable name="strg_gst_code">
			<xsl:value-of select="substring-after($ord_value,'#$%^')" />
		</xsl:variable>

		<xsl:variable name="invoice_detail">
			<xsl:value-of select="concat('Detail',$invoice_form_no)" />
		</xsl:variable>
		<xsl:variable name="collection_detail">
			<xsl:value-of select="concat('Detail',$collection_form_no)" />
		</xsl:variable>
		<xsl:variable name="invoice_listed_count">
			<xsl:if test="normalize-space($invoice_form_no)!=''">

				<xsl:for-each select="//node()[starts-with(name(), $invoice_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of select="count(//node()[starts-with(name(), $invoice_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="collection_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $collection_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="collection_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($collection_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of select="count(//node()[starts-with(name(), $collection_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="collection_pay_mode">
		<xsl:for-each select="//node()[starts-with(name(), $collection_detail)]">
			<xsl:value-of select="pay_mode" />
			</xsl:for-each>
		</xsl:variable>
                <div>
                        <xsl:if
                       		 test="not(contains($customer_types, 'UNLISTED'))">
                       		 
                       		 <xsl:choose>
                           	 		<xsl:when test="(normalize-space($strg_gst_no) != 'URD' and  normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I' ) ">
	                                <div class="tax-challan-name">
	                                    Delivery Challan
	                                </div>
                               		 </xsl:when>
                               		 <xsl:when test="(normalize-space($doc_sales_type) = 'C')">
                               		 	<div class="tax-challan-name">
	                                    TAX Invoice
	                                	</div>
                               		 </xsl:when>
                                	 <xsl:otherwise>
                                	 	<div class="tax-challan-name">
	                                    TAX Invoice
	                                	</div>
                                	</xsl:otherwise>
                                	</xsl:choose>
                                		                                	
                      		  	<div class="horizontal_dotted_line">
	                                      <div class="company-name" >
	                                          M/s Langar Bidi Company Poona
	                                      </div>
	                              </div>
	                              
	                          	<div class="horizontal_dotted_line">
	                          	<div class="namespacing">
	                                      <div class="label-text" >
	                                          Supplier Name
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value">
	                                          M/s Langar Bidi Company Poona, Gwalior Depo
	                                      </div>
								</div>
								<div class="namespacing">
	                                      <div class="label-text" >
	                                          Address
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value">
	                                          A-18/399 Transport Nagar, Near Water Tank, Gwalior
	                                      </div>
                                </div>
                                <div class="namespacing">
	                                      <div class="label-text" >
	                                          GSTIN No
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value" >
	                                          23AAAFL5383K1Z8                                                 
	                                      </div>
                                 </div>
                                 <div class="namespacing">
	                                      <div class="label-text" >
	                                          State
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value" >
	                                            23 / Madhya Pradesh   	                            				                                           
	                                      </div>  
	                                 </div>                                     
	                          	</div>
               		</xsl:if>
               	</div>
		<xsl:choose>
			<xsl:when test="$invoice_listed_count > '0'">
                <div>
                        <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                            
                        <div class="horizontal_dotted_line">
                            <div class="namespacing">
                           		 <div class="label-text-large">
                                    Recipient Name
                                </div>
                                <span class="colon">:</span>
                                <xsl:choose>
                           	 <xsl:when test="($doc_sales_type='I') ">
	                                <div class="data-value-large">
	                                    <xsl:value-of select="$doc_strg_name" />
	                                </div>
                                </xsl:when>
                                <xsl:otherwise>
	                                <div class="data-value-large">
	                                    Cash Sale
	                                </div>
                                </xsl:otherwise>
                                </xsl:choose>
                                
                            </div>
                            <div class="namespacing">
                                <div class="label-text">
                                    Address
                                </div>
                                <span class="colon">:</span>
                                <div class="data-value">
                                    <xsl:value-of select="concat($doc_addr1,' ',$doc_addr2,' ',$doc_addr3)" />
                                </div>
                            </div>

                            <div class="namespacing">
                                <div class="label-text">
                                    GST No
                                </div>
                                <span class="colon">:</span>
                                <xsl:choose>
                           	 	<xsl:when test="($doc_sales_type='I') ">
	                                <div class="data-value">
	                                    <xsl:value-of select="$strg_gst_no" />
	                                </div>
                                </xsl:when>
                                <xsl:otherwise>
	                                <div class="data-value">
	                                
	                                </div>
                                </xsl:otherwise>
                                </xsl:choose>
                            </div>

                            <div class="namespacing">
                                <div class="label-text">
                                    State
                                </div>
                                <span class="colon">:</span>
                                <div class="data-value">
                                	<xsl:variable name="strg_state_code">
										<xsl:value-of select="substring-before($strg_state, '(')" />
									</xsl:variable>
                           <!--          <xsl:value-of select="$strg_state" />	-->
                           			<xsl:value-of select = "concat($strg_gst_code,' ','/',' ',$strg_state_code)" />
                                </div>
                            </div>
                            <div class="namespacing">
	                             <!--    	<div class="label-text">
                                    		Invoice No/Date
                                		</div>
                                		<span class="colon">:</span> -->
                                		<xsl:choose>
											<xsl:when test="(($collection_pay_mode='Q' or $collection_pay_mode='C') and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
												<div class="label-text">
													Challan No/Date
												</div>
												<span class="colon">:</span>
											</xsl:when>
											<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
												<div class="label-text">
													Invoice No/Date
												</div>
												<span class="colon">:</span>
											</xsl:when>
											<xsl:otherwise>
												<div class="label-text">
													Invoice No/Date
												</div>
												<span class="colon">:</span>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:choose>
											<xsl:when test="(normalize-space($inv_ref_start) != '') ">
												<div class="data-value">
											<xsl:value-of select="concat($inv_ref_start,'/',$cash_invoice_id,' / ',$event_date)" />
										</div>
											</xsl:when>
											<xsl:otherwise>
												<div class="data-value">
											<xsl:value-of select="concat($cash_invoice_id,' / ',$event_date)" />
										</div>
											</xsl:otherwise>
										</xsl:choose>
                             </div>
                            
                        </div>
                       					<div class="horizontal_dotted_line">
	                                	<!-- <div class="namespacing">
		                                 <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Tax is payabel on Reverse Charge 
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
		                           </div>-->
		                           <div class="namespacing">
		                              <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Partial/Full Reverse Charge
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
	                         	 </div>
	                          </div> 
                    </xsl:if>
                    
                </div>
						<xsl:call-template name="payModeCashData">
                        <xsl:with-param name="payModeCashData"
                            select="concat($invoice_detail,'@',$doc_strg_code,'#',$invoice_listed_count,'*',$customer_types,'####',$collection_listed_count,'**',$collection_detail,'##',$ord_host_url,'%%',$total_sgst_amt,'%%%',$total_cgst_amt,'%%**',$doc_invoice_amount,'%*%*$',$doc_amount,'#%#%$',$doc_net_amt,'*%**%',$doc_round_off,'~^',$doc_amount_in_word,'%~^',$sales_pers_name,'%%^^',$event_date,'[%]',$event_time_start,'([||',$event_time_end,'~^%}]',$strg_gst_no,'*%]^',$doc_sales_type,'[%*',$load_no,'%|]',$vehicle_no,'%^*$',$cash_invoice_id,'*~^%*',$inv_ref_start)" />
                    </xsl:call-template>
			</xsl:when>
			<xsl:otherwise>       
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="payModeCashData">
		<xsl:param name="payModeCashData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$payModeCashData" />
		</xsl:variable>

		<xsl:variable name="invoice_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
        
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="invoice_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>

        <xsl:variable name="customer_types">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*'),'####')" />
		</xsl:variable>
		
		<xsl:variable name="collection-form_cnt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'####'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="collection_details">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'**'),'##')" />
		</xsl:variable>
        <xsl:variable name="ord_data_host_url">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'##'),'%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_sgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%'),'%%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_cgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%%'),'%%**')" />
		</xsl:variable>
		
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%**'),'%*%*$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%*%*$'),'#%#%$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_net_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'#%#%$'),'*%**%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_round_off">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%**%'),'~^')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_amt_in_word">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'~^'),'%~^')" />
		</xsl:variable>
		
		<xsl:variable name="sales_pers_name">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%~^'),'%%^^')" /> 
		</xsl:variable>
		<xsl:variable name="event_date">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%^^'),'[%]')" /> 
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'[%]'),'([||')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'([||'),'~^%}]')" /> 
		</xsl:variable>
		<xsl:variable name="strg_gst_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'~^%}]'),'*%]^')" /> 
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%]^'),'[%*')" /> 
		</xsl:variable>
		<xsl:variable name="doc_load_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'[%*'),'%|]')" /> 
		</xsl:variable> 
		<xsl:variable name="doc_vehicle_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%|]'),'%^*$')" /> 
		</xsl:variable>
		<xsl:variable name="cash_invoice_id">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%^*$'),'*~^%*')" /> 
		</xsl:variable>
		<xsl:variable name="inv_ref_start">
			<xsl:value-of 
			    select="substring-after($order_data_value,'*~^%*')" /> 
		</xsl:variable>

        <xsl:variable name="domID">
            <xsl:value-of select="@domID" />
        </xsl:variable>
        
        <xsl:variable name="inv_basic_sum">
                <xsl:for-each
                    select="//node()[starts-with(name(), $invoice_details)]">
                    <xsl:variable name="invoice_id_check">
                        <xsl:value-of select="invoice_id" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
                        <xsl:value-of select="concat(inv_basic_value,'/')" /> 
                    </xsl:if>
                </xsl:for-each>
       	</xsl:variable>
         <xsl:variable name="inv_basic_value_sum">
			<xsl:value-of 
	    		select="substring-before($inv_basic_sum,'/')" /> 
		</xsl:variable>
		
	<xsl:variable name="inv_gst_sum">
		<xsl:for-each select="//node()[starts-with(name(), $invoice_details)]">
			<xsl:variable name="invoice_id_check">
				<xsl:value-of select="invoice_id" />            
			</xsl:variable>
			<xsl:if test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
            <!-- Check if total_sgst_amount is not blank -->
            <xsl:if test="normalize-space(total_sgst_amount)">
				<xsl:value-of select="concat(total_sgst_amount, '/')" />
			</xsl:if>
        </xsl:if>
		</xsl:for-each>
	</xsl:variable>

   <xsl:variable name="inv_total_gst_parent_value1">
    <xsl:choose>
        <xsl:when test="string(substring-before($inv_gst_sum, '/'))">
            <xsl:value-of select="substring-before($inv_gst_sum, '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

	<xsl:variable name="inv_total_gst_child_value1">
    <xsl:choose>
        <xsl:when test="contains(substring-after($inv_gst_sum, '/'), '/')">
            <xsl:value-of select="substring-before(substring-after($inv_gst_sum, '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
	</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value2">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value2">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value3">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value3">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value4">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value4">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value5">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value5">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value6">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value6">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_parent_value7">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

<xsl:variable name="inv_total_gst_child_value7">
    <xsl:choose>
        <xsl:when test="contains(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')">
            <xsl:value-of select="substring-before(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after(substring-after($inv_gst_sum, '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/'), '/')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>0</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:variable>

	<xsl:variable name="inv_total_gst_sum">
    	<xsl:value-of select="$inv_total_gst_parent_value1 + $inv_total_gst_child_value1 + $inv_total_gst_parent_value2 + $inv_total_gst_child_value2 + $inv_total_gst_parent_value3 + $inv_total_gst_child_value3 + $inv_total_gst_parent_value4 + $inv_total_gst_child_value4 + $inv_total_gst_parent_value5 + $inv_total_gst_child_value5 + $inv_total_gst_parent_value6 + $inv_total_gst_child_value6 + $inv_total_gst_parent_value7 + $inv_total_gst_child_value7" />
	</xsl:variable>

        <xsl:variable name="inv_total_sum">
            <xsl:for-each
                select="//node()[starts-with(name(), $invoice_details)]">
                <xsl:variable name="invoice_id_check">
                    <xsl:value-of select="invoice_id" />
                </xsl:variable>
                <xsl:if
                    test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
                    <xsl:value-of select="concat(inv_total_value,'/')" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="inv_total_value_sum">
			<xsl:value-of 
    			select="substring-before($inv_total_sum,'/')" /> 
		</xsl:variable>
		
        <xsl:variable name="inv_invoice_sum">
            <xsl:for-each
                select="//node()[starts-with(name(), $invoice_details)]">
                <xsl:variable name="invoice_id_check">
                    <xsl:value-of select="invoice_id" />
                </xsl:variable>
                <xsl:if
                    test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
                    <xsl:value-of select="concat(inv_invoice_value,'/')" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="inv_invoice_value_sum">
			<xsl:value-of 
    			select="substring-before($inv_invoice_sum,'/')" /> 
		</xsl:variable>
		
        <xsl:variable name="inv_rndoff_sum">
            <xsl:for-each
                select="//node()[starts-with(name(), $invoice_details)]">
               <xsl:variable name="invoice_id_check">
                    <xsl:value-of select="invoice_id" />
                </xsl:variable>
                <xsl:if
                    test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
                    <xsl:value-of select="concat(inv_rndoff_value,'/')" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="inv_rndoff_value_sum">
			<xsl:value-of 
    			select="substring-before($inv_rndoff_sum,'/')" /> 
		</xsl:variable>
		
        <xsl:variable name="inv_amtword_sum">
            <xsl:for-each
                select="//node()[starts-with(name(), $invoice_details)]">
                <xsl:variable name="invoice_id_check">
                    <xsl:value-of select="invoice_id" />
                </xsl:variable>
                <xsl:if
                    test="normalize-space($cash_invoice_id) = normalize-space($invoice_id_check)">
                    <xsl:value-of select="concat(inv_amtword_value,'/')" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="inv_amtword_value_sum">
			<xsl:value-of 
    			select="substring-before($inv_amtword_sum,'/')" /> 
		</xsl:variable>
		
		<xsl:if test="normalize-space($invoice_form_cnt) > 0 ">
				
			<xsl:variable name="invoiceCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $invoice_details)]">
                    <xsl:variable name="invoice_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($invoice_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            
				<xsl:for-each
					select="//node()[starts-with(name(), $invoice_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="invoice_rate">
                            <xsl:value-of select="rate" />
                        </xsl:variable>
                        <xsl:variable name="invoice_remarks">
                            <xsl:value-of select="remarks_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoicevalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="total_sgst_amount">
							<xsl:value-of select="total_sgst_amount" />
						</xsl:variable>
						<xsl:variable name="total_cgst_amount">
                            <xsl:value-of select="total_cgst_amount" />
                        </xsl:variable>
						<xsl:variable name="total_amount">
                            <xsl:value-of select="total_amount" />
                        </xsl:variable>
                        <xsl:variable name="hsn_number">
                            <xsl:value-of select="hsn_number" />
                        </xsl:variable>
                        <xsl:variable name="tax_amt_inv">
                            <xsl:value-of select="tax_amt_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoice_id">
                            <xsl:value-of select="invoice_id" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
							<xsl:if test="normalize-space($cash_invoice_id) = normalize-space($invoice_id)">
							<xsl:if test="normalize-space($quantity) > 0">
							
	                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Item name
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$item_descr" />
					                               </div>
					                           </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   Qty
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$quantity" />
					                               </div>
					                           </div>
					                           </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   HSN No
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$hsn_number" />
					                               </div>
					                           </div>
					                           </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   Rate
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                   <!--                <xsl:value-of select="$invoice_rate" />	-->
					                   			<xsl:choose>
				                               	<xsl:when test="contains($invoice_rate,'.')"> 
				                               		<xsl:value-of select="$invoice_rate" />
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select='format-number($invoice_rate, "00.00")' />
			                               		</xsl:otherwise>
			                               		</xsl:choose>
					                               </div>
					                           </div>
					                           </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   Basic Amount
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                                   <xsl:choose>
				                               	<xsl:when test="contains($invoice_rate,'.')"> 
				                               		<xsl:value-of select="$invoicevalue" />
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select='format-number($invoicevalue, "00.00")' />
			                               		</xsl:otherwise>
			                               		</xsl:choose>
					                               </div>
					                           </div>
					                           </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   SGST
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                       <!--          <xsl:value-of select="$total_sgst_amount" />(14.00%)	-->
					                       			<xsl:value-of select='format-number($total_sgst_amount, "00.00")' />(14.00%)	
					                               </div>
					                           </div>
					                       </div>
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text">
					                                   CGST
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value">
					                    <!--              <xsl:value-of select="$total_cgst_amount" />(14.00%)  -->
					                    			<xsl:value-of select='format-number($total_cgst_amount, "00.00")' />(14.00%)
					                               </div>
					                           </div>
					                           </div>
	                                    <!-- </div>-->
	                                </xsl:if>
	                                  <div class="horizontal_dotted_line"></div>
	                                </xsl:if>
                                </xsl:if>

                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
		</xsl:if>
		<!-- Invoice Details end -->
		<xsl:if test="normalize-space($collection-form_cnt) > 0">
            <xsl:variable name="collectionCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $collection_details)]">
                    <xsl:variable name="collection_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($collection_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
				<xsl:for-each
					select="//node()[starts-with(name(), $collection_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="collection_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="doc_pay_mode">
							<xsl:value-of select="pay_mode" />
						</xsl:variable>
						<xsl:variable name="cheque_amt">
							<xsl:value-of select="amount" />
						</xsl:variable>
						<xsl:variable name="cheque_date">
							<xsl:value-of select="ref_date" />
						</xsl:variable>
						<xsl:variable name="cheque_no">
							<xsl:value-of select="ref_no" />
						</xsl:variable>
						<xsl:variable name="bank_name">
							<xsl:value-of select="ref_bank" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                <xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode='Q' and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '') ">
					                             		</xsl:when>
					                              		<xsl:otherwise>
							                           <div class="namespacing">
							                               			<div class="label-text">
							                                  			 Payment Mode
							                               			</div>
							                               			<span class="colon">:</span>
							                              		 	<div class="data-value">
							                                   			<xsl:choose>
														<xsl:when test="($doc_pay_mode='C') ">
															CASH
														</xsl:when>
														<xsl:when test="($doc_pay_mode='Q') ">
															CHEQUE
														</xsl:when>
														<xsl:when test="($doc_pay_mode='R') ">
															RTGS
														</xsl:when>
														<xsl:when test="($doc_pay_mode='N') ">
															NEFT
														</xsl:when>
														<xsl:when test="($doc_pay_mode='U') ">
															UPI
														</xsl:when>
														<xsl:when test="($doc_pay_mode='O') ">
															ONLINE
														</xsl:when>
																		</xsl:choose>
							                               			</div>
							                           </div>
					                                  	</xsl:otherwise>
					                                  	
					                              </xsl:choose>
					                           <xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode='Q' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Cheque No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='U' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 UPI No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='N' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 NEFT No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                             		<xsl:when test="($doc_pay_mode='R' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = '')) ">
					                           			<div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS Amount
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_amt" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS Date
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_date" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 RTGS No
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$cheque_no" />
					                               			</div>
					                          			 </div>
					                          			 <div class="namespacing">
					                         	 			<div class="label-text">
					                                  			 Bank Name
					                               			</div>
					                               			<span class="colon">:</span>
					                              		 	<div class="data-value">
					                                   			<xsl:value-of select="$bank_name" />
					                               			</div>
					                          			 </div>
					                             		</xsl:when>
					                              		<xsl:otherwise>
					                                  	</xsl:otherwise>
					                                  	</xsl:choose>
					                                  	<xsl:choose>
					                         	 		<xsl:when test="($doc_pay_mode!='Q' or($doc_pay_mode='Q' and (normalize-space($strg_gst_no) = 'URD' or normalize-space($strg_gst_no) = ''))) ">
					                                  	<div class="horizontal_dotted_line">
                                 					    </div>
                                 					  </xsl:when>
                                 					  </xsl:choose>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Taxable Amt
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                    <xsl:choose>
				                               	<xsl:when test="not(contains($inv_basic_value_sum,'.'))"> 
				                               		<xsl:value-of select='format-number($inv_basic_value_sum, "00.00")' />                 		
			                               		</xsl:when>
			                               		<xsl:otherwise>
			                               			<xsl:value-of select="$inv_basic_value_sum" />  
			                               		</xsl:otherwise>
			                               		</xsl:choose>
				                               </div>
				                           </div>
											</div>					

				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total SGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                    <!--<xsl:value-of select="$inv_total_gst_sum div 2" />  -->
				                      			<xsl:value-of select='format-number($inv_total_gst_sum, "00.00")' />												
				                               </div>
				                           </div>
				                           </div>
				
				                       <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total CGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <!-- <xsl:value-of select="$inv_total_gst_sum div 2" /> -->
				                        		<xsl:value-of select='format-number($inv_total_gst_sum, "00.00")' />												
				                               </div>
				                           </div>
				                           </div>
				                       </div>									   										

				                       <xsl:choose>
                           	           <xsl:when test="(normalize-space($inv_rndoff_value_sum) !=0 or normalize-space($inv_rndoff_value_sum) !=0.0) ">
	                                <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Total Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                    <xsl:value-of select="$inv_total_value_sum" />
				                               </div>
				                           </div>
				                           </div>
				                           
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Round off
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                    <xsl:value-of select="$inv_rndoff_value_sum" />
				                               </div>
				                           </div>
				                           </div>
                                </xsl:when>
                                <xsl:otherwise>
                                </xsl:otherwise>
                                </xsl:choose>
				                           <!--<div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Total Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_amount" />
				                               </div>
				                           </div>
				                           </div>
				                           
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Round off
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_round_off" />
				                               </div>
				                           </div>
				                           </div>-->
				                       
				                           <div class="namespacing">
				                           	<div class="value-shown">
				                           		<xsl:choose>
			                           	 		<xsl:when test="(($doc_pay_mode='Q' or $doc_pay_mode='C') and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '' and normalize-space($doc_sales_type) = 'I') ">
				                                	<div class="label-text-large">
				                                   Challan Amount
				                               </div>
				                               <span class="colon-num">:</span>
			                               		</xsl:when>
			                               		<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
													<div class="label-text-large">
				                                   Invoice Amount
				                               </div>
				                               <span class="colon-num">:</span>
												</xsl:when>
			                                	<xsl:otherwise>
				                                <div class="label-text-large">
				                                   Invoice Amount
				                               </div>
				                               <span class="colon-num">:</span>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                               <div class="data-value-large">
				                               		<xsl:value-of select='format-number($inv_invoice_value_sum, "00.00")' />
				                               </div>
				                           	</div>
				                           </div>
				                           <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                           <div class="value-shown">
					                               <div class="label-text-large">
					                                   Amount in Words
					                               </div>
					                               <span class="colon-num">:</span>
					                               <div class="data-value-large">
					                                  <xsl:value-of select="$inv_amtword_value_sum" /> 
					                               </div>
					                           </div>
					                           </div>
				                           </div>
				                           <div class="namespacing">
					                               <div class="label-text">
					                                   Transport Mode
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   Vehicle
					                               </div>
					                        </div>
					                        <div class="namespacing">
					                               <div class="label-text">
					                                   Load No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$doc_load_no" />
					                               </div>
					                        </div>
					                        <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Vehicle No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$doc_vehicle_no" />
					                               </div>
					                           </div>
				                           </div>
				                           <!-- <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Eway Bill
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   
					                               </div>
					                           </div>
				                           </div> -->
										   <xsl:choose>
												<xsl:when test="(normalize-space($inv_ref_start) != '') ">
													<xsl:variable name="printed-on-time">
																	<xsl:value-of select="concat('printed_on_',$inv_ref_start,'/',$cash_invoice_id)" />
													</xsl:variable>
													<div class="namespacing">
															<div class="label-text">
																Printed On
															</div>
															<span class="colon">:</span>
															
															<div class="data-value" id='{normalize-space($printed-on-time)}'>
							
																<!--<xsl:value-of select="concat($event_date,' / ',$event_time_start)" />-->
															</div>
													</div>
												</xsl:when>
												<xsl:otherwise>
												<xsl:variable name="printed-on-time">
																	<xsl:value-of select="concat('printed_on_',$cash_invoice_id)" />
													</xsl:variable>
													<div class="namespacing">
															<div class="label-text">
																Printed On
															</div>
															<span class="colon">:</span>
															
															<div class="data-value" id='{normalize-space($printed-on-time)}'>
							
																<!--<xsl:value-of select="concat($event_date,' / ',$event_time_start)" />-->
															</div>
													</div>
												</xsl:otherwise>
											</xsl:choose>	
				                           <div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Prepared By
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$sales_pers_name" />
					                               </div>
					                           </div>
				                           </div>
				                           <xsl:choose>
			                           	 		<xsl:when test="($doc_pay_mode='Q' and normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '') ">
			                               		</xsl:when>
			                                	<xsl:otherwise>
													<div class="horizontal_dotted_line">
														<div class="namespacing">
															<div class="label-text">
																Ref.No/Date
															</div>
															<span class="colon">:</span>
																<xsl:choose>
																		<xsl:when test="(normalize-space($inv_ref_start) != '') ">
																			<div class="data-value">
																				<xsl:value-of select="concat($inv_ref_start,'/',$cash_invoice_id,' / ',$event_date)" />
																			</div>
																		</xsl:when>
																		<xsl:otherwise>
																			<div class="data-value">
																				<xsl:value-of select="concat($cash_invoice_id,' / ',$event_date)" />
																			</div>
																		</xsl:otherwise>
																	</xsl:choose>
														</div>
													</div>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                           		<xsl:choose>
			                           	 		<xsl:when test="(($doc_pay_mode='Q' or $doc_pay_mode='C') and (normalize-space($strg_gst_no) != 'URD' and normalize-space($strg_gst_no) != '') and normalize-space($doc_sales_type) = 'I') ">
			                           	 		<div class="horizontal_dotted_line">
					                           <div class="namespacing">
					                               <div class="label-hardecode">
					                                   Since computer generated challan,Signature is not mandatory
					                               </div>
					                           </div>
				                          	 </div>
			                           	 		<div class="namespacing">
				                                	<div class="label-hardecode">
					                                   1. Goods are sent on approval basis in terms of section 31 of the Central Goods and Service Tax Act, 2017 read with Rule 55 of the said rules.
					                                </div>
					                                </div>
					                                <div class="namespacing">
					                               <div class="label-hardecode">
					                                   2.Intimation for acceptance or rejection of goods shall be provided within 72 hours of issuance of Delivery Challan.In case of no intimation, it would be deemed to be accepted. 
					                               </div>
					                               </div>
			                               		</xsl:when>
			                               		<xsl:when test="(normalize-space($doc_sales_type) = 'C') ">
			                               			<div class="namespacing">
					                               <div class="label-hardecode">
					                                   Since computer generated invoice,Signature is not mandatory
					                               </div>
					                           </div>
			                               		</xsl:when>
			                                	<xsl:otherwise>
					                           <div class="namespacing">
					                               <div class="label-hardecode">
					                                   Since computer generated invoice,Signature is not mandatory
					                               </div>
					                           </div>
			                                    </xsl:otherwise>
			                                	</xsl:choose>
				                           
				                       
                                </xsl:if>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
		</xsl:if>
		<div style="margin-top:50px">
			<xsl:choose>
				<xsl:when test="(normalize-space($inv_ref_start) != '') ">
					<xsl:variable name="print_label"><xsl:value-of select="concat('print_label_',$inv_ref_start,'/',$cash_invoice_id)" /></xsl:variable>
					<xsl:variable name="cust_copy_text"><xsl:value-of select="concat('cust_copy_text_',$inv_ref_start,'/',$cash_invoice_id)" /></xsl:variable>
					<xsl:variable name="sup_copy_text"><xsl:value-of select="concat('sup_copy_text_',$inv_ref_start,'/',$cash_invoice_id)" /></xsl:variable>
					<div class="horizontal_dotted_line">
				<div class="namespacing">
					<div class="label-hardecode" style="text-align: center;display:none;" id='{normalize-space($print_label)}'>
						Received By
					</div>
				</div>
			</div>
			<div class="">
				<div class="namespacing">
					<div class="label-hardecode" style="display:none;text-align: center;" id='{normalize-space($cust_copy_text)}'>
						Customer Copy
					</div>
				</div>
				<div class="namespacing">
					<div class="label-hardecode" style="display:none;text-align: center;" id='{normalize-space($sup_copy_text)}'>
						Supplier Copy
					</div>
				</div>
			</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="print_label"><xsl:value-of select="concat('print_label_',$cash_invoice_id)" /></xsl:variable>
					<xsl:variable name="cust_copy_text"><xsl:value-of select="concat('cust_copy_text_',$cash_invoice_id)" /></xsl:variable>
					<xsl:variable name="sup_copy_text"><xsl:value-of select="concat('sup_copy_text_',$cash_invoice_id)" /></xsl:variable>
					<div class="horizontal_dotted_line">
				<div class="namespacing">
					<div class="label-hardecode" style="text-align: center;display:none;" id='{normalize-space($print_label)}'>
						Received By
					</div>
				</div>
			</div>
			<div class="">
				<div class="namespacing">
					<div class="label-hardecode" style="display:none;text-align: center;" id='{normalize-space($cust_copy_text)}'>
						Customer Copy
					</div>
				</div>
				<div class="namespacing">
					<div class="label-hardecode" style="display:none;text-align: center;" id='{normalize-space($sup_copy_text)}'>
						Supplier Copy
					</div>
				</div>
			</div>
				</xsl:otherwise>
			</xsl:choose>
		
		</div>
		<!-- End of collection details -->

	</xsl:template>
</xsl:stylesheet>
