<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />
	<xsl:template match="/">
		<html>
			<body>
				<div class="tTitleD">
					<div style="margin-bottom: 10px;">
					<xsl:choose>
						<xsl:when test="//Detail1">
							<xsl:variable name="event_date">
								<xsl:value-of select="//Detail1/event_date" />
							</xsl:variable>
							<xsl:variable name="name">
								<xsl:value-of select="//Detail1/name" />
							</xsl:variable>
							<div style="color: #666; padding: 5px;">
								<b>From <xsl:value-of select="$name" /> dated on <xsl:value-of select="$event_date" /></b>
							</div>
						</xsl:when>
					</xsl:choose>
					<xsl:for-each select="//Detail1">
						<xsl:sort select="result" order="descending" />
						<xsl:variable name="event_date">
							<xsl:value-of select="event_date" />
						</xsl:variable>
						<xsl:variable name="survey_descr">
							<xsl:value-of select="descr" />
						</xsl:variable>
						<xsl:variable name="survey_code">
							<xsl:value-of select="survey_code" />
						</xsl:variable>
						<xsl:variable name="correctAns">
							<xsl:value-of select="correct_ans" />
						</xsl:variable>
						<xsl:variable name="result">
							<xsl:value-of select="result" />
						</xsl:variable>
						<xsl:variable name="ord_host_url">
							<xsl:value-of select="host_url" />
						</xsl:variable>
                       
						<div style="background-color: white;border-bottom: 1px inset;padding: 8px 4px 8px 6px;height: auto;table-layout: fixed;display: flex;">
							<span>
								<xsl:choose>
									<xsl:when test="$result = 'Y'">
										<img src="{normalize-space($ord_host_url)}/ibase/webitm/images/coachingResGreen.png"
											onerror='this.src="images/map/user.png"'
											class="iw-header-userImage"
											style="height: 30px;width: 30px;background-position :100%; border-radius: 50%;">
										</img>
									</xsl:when>
									<xsl:otherwise>
										<img src="{normalize-space($ord_host_url)}/ibase/webitm/images/coachingResRed.png"
											onerror='this.src="images/map/user.png"'
											class="iw-header-userImage"
											style="height: 30px;width: 30px;background-position :100%; border-radius: 50%;">
										</img>
									</xsl:otherwise>
								</xsl:choose>
							</span>
							<span CLASS="cellttl1 tdCenter title tdLeft" style="margin: 5px;">
								<xsl:value-of select="$survey_descr" />
							</span>
						</div>
					</xsl:for-each>
					</div>
					
					<div>
					<xsl:choose>
						<xsl:when test="//Detail2">
							<xsl:variable name="event_date">
								<xsl:value-of select="//Detail2/event_date" />
							</xsl:variable>
							<xsl:variable name="name">
								<xsl:value-of select="//Detail2/name" />
							</xsl:variable>
							<div style="color: #666; padding: 5px;">
								<!-- <b>To <xsl:value-of select="$name" /> dated on <xsl:value-of select="$event_date" /></b> -->
								<b>Coaching on <xsl:value-of select="$event_date" /></b>
							</div>
						</xsl:when>
					</xsl:choose>
					<xsl:for-each select="//Detail2">
                     <xsl:sort select="result" order="descending" />
						<xsl:variable name="event_date">
							<xsl:value-of select="event_date" />
						</xsl:variable>
						<xsl:variable name="survey_descr">
							<xsl:value-of select="descr" />
						</xsl:variable>
						<xsl:variable name="survey_code">
							<xsl:value-of select="survey_code" />
						</xsl:variable>
						<xsl:variable name="correctAns">
							<xsl:value-of select="correct_ans" />
						</xsl:variable>
						<xsl:variable name="result">
							<xsl:value-of select="result" />
						</xsl:variable>
						<xsl:variable name="ord_host_url">
							<xsl:value-of select="host_url" />
						</xsl:variable>
                       
						<div style="background-color: white;border-bottom: 1px inset;padding: 8px 4px 8px 6px;height: auto;table-layout: fixed;display: flex;">
							<span>
								<xsl:choose>
									<xsl:when test="$result = 'Y'">
										<img src="{normalize-space($ord_host_url)}/ibase/webitm/images/coachingResGreen.png"
											onerror='this.src="images/map/user.png"'
											class="iw-header-userImage"
											style="height: 30px;width: 30px;background-position :100%; border-radius: 50%;">
										</img>
									</xsl:when>
									<xsl:otherwise>
										<img src="{normalize-space($ord_host_url)}/ibase/webitm/images/coachingResRed.png"
											onerror='this.src="images/map/user.png"'
											class="iw-header-userImage"
											style="height: 30px;width: 30px;background-position :100%; border-radius: 50%;">
										</img>
									</xsl:otherwise>
								</xsl:choose>
							</span>
							<span CLASS="cellttl1 tdCenter title tdLeft" style="margin: 5px;">
								<xsl:value-of select="$survey_descr" />
							</span>
						</div>
					</xsl:for-each>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
