package ibase.webitm.utility.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.naming.InitialContext;

import ibase.webitm.utility.E12ExternalAPICall;
import org.json.JSONArray;
import org.json.JSONObject;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.WSFACommon;


public class SalesSFAToSAPService extends ValidatorEJB
{
    private E12GenericUtility e12GenericUtility = new E12GenericUtility();
    WSFACommon wsfaCommon = new WSFACommon();

	public String callTheJsonCaseWise (String dcrID,String xtraParam,Connection conn) throws ITMException
	{
		System.out.println("inside SalesSFAToSAPService callTheJsonCaseWise");
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		boolean isLocalConn = false;
		ResultSet rs=null;
        UserInfoBean userInfo = null;
		//JSONObject obj = new JSONObject();
        boolean isError = false;
        String enterprise="";
		String returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
		try
		{
			String userId = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			String aproverEmpCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginEmpCode");

			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( userId ) );
			}
			if ( conn == null )
			{
				String transDB = getUserInfo().getTransDB();
				
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;
				
				isLocalConn = true;
				System.out.println("Connection created...");
            }
			OrgStructure orgStructure=new OrgStructure();

            userInfo = getUserInfo();
            if(userInfo!=null)
            {
            	enterprise=userInfo.getEnterprise();
            }

			String loadNo = "";
			String loadStatus = "";
			String salesPersLoad = "";
			String vehNo = "",invoiceSrNo="";
		
			String loadNoSql = "SELECT A.SALES_PERS,A.LOAD_NO,B.LOAD_STATUS, B.VEH_NO,B.INVOICE_SR_NO FROM SPRS_ACT_TRAN A, SPRS_DAY_SUMM B WHERE A.DCR_ID = ? AND A.SALES_PERS = B.SALES_PERS AND A.LOAD_NO = B.LOAD_NO ";
			pstmt = conn.prepareStatement(loadNoSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				salesPersLoad = checkNull(rs.getString("SALES_PERS"));
				loadNo = checkNull(rs.getString("LOAD_NO"));
				loadStatus = checkNull(rs.getString("LOAD_STATUS"));
				vehNo = checkNull(rs.getString("VEH_NO"));
				invoiceSrNo=checkNull(rs.getString("INVOICE_SR_NO"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("loadNo from SPRS_ACT_TRAN =["+loadNo+"], salesPersLoad=["+salesPersLoad+"], loadStatus=["+loadStatus+"], invoiceSrNo=["+invoiceSrNo+"]");
			
			if(!"Y".equalsIgnoreCase(loadStatus))
			{
	            E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall("SAP",userInfo);
				ArrayList<String> dcrIdList=getDcrIDListInFormat(dcrID,conn);
				String dcrIdInForm=orgStructure.getFormattedList(dcrIdList);
				if(dcrIdInForm==null || dcrIdInForm.trim().length()==0)
				{
					dcrIdInForm="'X'";
				}
				String lastDcrID=dcrIdList.get(dcrIdList. size()-1) ;
				
				//split api start [18-MAR-23]
				JSONObject salesInvSplitJSONobj = new JSONObject();
				
				//This is called in case of Stock Break
				salesInvSplitJSONobj = getSplitInvoiceDetails(dcrID,dcrIdInForm,conn,loadNo);
				if(salesInvSplitJSONobj != null)
				{
					System.out.println("Posting Of Split Bundle API ...........");
					String splitInvoiceUrl = "https://lbcp.rpminfotech.com/api/SplitBundle";
					String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("SplitBundle", splitInvoiceUrl, "A", "E", lastDcrID, "F-DCR", "POST", salesInvSplitJSONobj, userInfo,"");
					if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
					{
						apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
					}
					
					if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
					{
						JSONObject obj = new JSONObject(apiCallResponseJsonStr);
						
						String errorCode=obj.getString("errorCode");
						if("000".equalsIgnoreCase(errorCode))
						{
							returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
						}
						else
						{
							String errorMessage=obj.getString("errorMessage");
							returnValue=getErrorString(errorMessage);
						}
	
	
					}
					else if(apiCallResponseJsonStr.indexOf("error")!=-1)
					{
						JSONObject obj = new JSONObject(apiCallResponseJsonStr);
						JSONObject error = obj.getJSONObject("error");
						JSONObject message = error.getJSONObject("message");
						String value=message.getString("value");
						System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
						returnValue=getErrorString(value);
	
					}
					JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
				}
	
				//splitapi end[18-MAR-23]
				
				
				//FOR VanToVanAPI start[17-MAR-23]
				ArrayList<String> tranIdList=getStockTransferTranIDFormat(dcrID,conn);
	
				JSONObject salesVanJSONobj = new JSONObject();
				
				if(!(tranIdList.isEmpty()))
				{
					String tranIDInForm=orgStructure.getFormattedList(tranIdList);
					if(tranIDInForm==null || tranIDInForm.trim().length()==0)
					{
						tranIDInForm="'X'";
					}
	
					salesVanJSONobj = callVanToVanAPI(tranIdList,tranIDInForm,conn, loadNo);
					System.out.println("Posting Of Van Stock API ...........");
					String vanStockUrl = "https://lbcp.rpminfotech.com/api/VanToVanTransfer";
					String apiCallResponseVanJsonStr = e12ExternalAPICall.apiCallToPostData("VanToVanTransfer", vanStockUrl, "A", "E", lastDcrID, "F-DCR", "POST", salesVanJSONobj, userInfo,"");
					if(apiCallResponseVanJsonStr.indexOf("[")==0 && apiCallResponseVanJsonStr.lastIndexOf("]")==apiCallResponseVanJsonStr.length()-1)
					{
						apiCallResponseVanJsonStr=apiCallResponseVanJsonStr.substring(1, apiCallResponseVanJsonStr.length()-1);
					}
					
					if(apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
					{
						JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
						
						String errorCode=obj.getString("errorCode");
						if("000".equalsIgnoreCase(errorCode))
						{
							returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
						}
						else
						{
							String errorMessage=obj.getString("errorMessage");
							returnValue=getErrorString(errorMessage);
						}
	
	
					}
					else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
					{
						JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
						JSONObject error = obj.getJSONObject("error");
						JSONObject message = error.getJSONObject("message");
						String value=message.getString("value");
						System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
						returnValue=getErrorString(value);
	
					}
					JSONObject apiCallResponseVanJSON = new JSONObject(apiCallResponseVanJsonStr);
				}
				//FOR VanToVanAPI END[17-MAR-23]
	
				String empSite="";
				//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
				/*String headerSql="SELECT SC.GST_NO,SM.TRAN_ID ,SM.STRG_CODE,SM.EVENT_DATE,SM.REMARKS,SM.SALES_PERS,SMC.PAY_MODE,SMC.REF_NO,SC.STATE_CODE ,E.EMP_SITE,SP.STATE_CODE AS SP_STATE_CODE,L.LOC_GROUP,L.LOC_PHY_AREA,SM.AMOUNT AS TOTALAMOUNT " + 
						"FROM STRG_MEET SM,STRG_MEET_COLLECT SMC ,STRG_CUSTOMER SC,SALES_PERS SP ,LOCATION L,EMPLOYEE E " + 
						"WHERE SM.DCR_ID IN("+dcrIdInForm+") AND SM.TRAN_ID=SMC.TRAN_ID AND SM.STRG_CODE=SC.SC_CODE AND " + 
						"E.EMP_CODE=SM.SALES_PERS AND SM.SALES_PERS=SP.SALES_PERS AND SP.SALES_PERS=E.EMP_CODE AND E.EMP_CODE=L.LOC_CODE ";*/
				String headerSql="SELECT SC.GST_NO,SM.TRAN_ID ,SM.STRG_CODE,SM.EVENT_DATE,SM.REMARKS,SM.SALES_PERS,SMC.PAY_MODE,SMC.REF_NO,SC.STATE_CODE ,E.EMP_SITE,SP.STATE_CODE AS SP_STATE_CODE,L.LOC_GROUP,L.LOC_PHY_AREA,SM.AMOUNT AS TOTALAMOUNT, SMC.REF_BANK, SM.SALES_TYPE " + 
						"FROM STRG_MEET SM,STRG_MEET_COLLECT SMC ,STRG_CUSTOMER SC,SALES_PERS SP ,LOCATION L,EMPLOYEE E " + 
						"WHERE SM.DCR_ID IN("+dcrIdInForm+") AND SM.TRAN_ID=SMC.TRAN_ID AND SM.STRG_CODE=SC.SC_CODE AND " + 
						"E.EMP_CODE=SM.SALES_PERS AND SM.SALES_PERS=SP.SALES_PERS AND SP.SALES_PERS=E.EMP_CODE AND E.EMP_CODE=L.LOC_CODE ";
				//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
				System.out.println("inside headerSql ::"+headerSql);
				pstmt = conn.prepareStatement(headerSql);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					empSite = checkNull(rs.getString("EMP_SITE"));
					String stateCode = checkNull(rs.getString("SP_STATE_CODE"));
					String locGroup = checkNull(rs.getString("LOC_GROUP"));
					String BinAbsEntry = checkNull(rs.getString("LOC_PHY_AREA"));
					String strgCode=checkNull(rs.getString("STRG_CODE"));
					//String tranDate=checkNull(rs.getString("EVENT_DATE"));
					String tranDate= (rs.getDate("EVENT_DATE")).toString();
					String remarks=checkNull(rs.getString("REMARKS"));
					String salesPers=checkNull(rs.getString("SALES_PERS"));
					String custStateCode=checkNull(rs.getString("STATE_CODE"));
					String tranId=checkNull(rs.getString("TRAN_ID"));
					String payMode=checkNull(rs.getString("PAY_MODE"));
					String totalAmount=checkNull(rs.getString("TOTALAMOUNT"));
					String gstNo=checkNull(rs.getString("GST_NO"));
					String chequeNo=checkNull(rs.getString("REF_NO"));
					String refBank=checkNull(rs.getString("REF_BANK"));		
					String salesType=checkNull(rs.getString("SALES_TYPE"));
	
					if("URD".equalsIgnoreCase(gstNo))
					{
						gstNo="";
					}
					JSONObject salesInvJSONobj = new JSONObject();
					JSONObject invJPaymentSONobj = new JSONObject();
					//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,conn);
					
					System.out.println("gstNo =["+gstNo+"], payMode=["+payMode+"]");
					System.out.println("tranDate =["+tranDate+"]");
					String sql="SELECT DISTINCT INVOICE_ID FROM STRG_MEET_INVOICE WHERE TRAN_ID=? AND INVOICE_ID IS NOT NULL";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, tranId);
					rs1 = pstmt1.executeQuery();
					while(rs1.next())
					{
						String invoiceID=checkNull(rs1.getString("INVOICE_ID"));
						
						System.out.println("invoiceID =["+invoiceID+"]");
	
						//if((gstNo == null || gstNo.trim().length()== 0 || "C".equalsIgnoreCase(salesType)) && ("C".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode) ))
						if(gstNo != null && gstNo.length() > 0 && "I".equalsIgnoreCase(salesType) )
						{

							System.out.println("Posting Of Delivery Note ...........");
							//String deliverNoteApiURL = "https://20.219.186.30:50000/b1s/v1/DeliveryNotes";
							//String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
							//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"DeliveryNotes",conn, loadNo);
							salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"DeliveryNotes",conn, loadNo,refBank);
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
							String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/DeliveryNotes";
							//String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(salesInvJSONobj, deliverNoteApiURL,"POST");
							String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("DeliveryNotes", deliverNoteApiURL, "A", "E", lastDcrID, "F-DCR", "POST", salesInvJSONobj, userInfo,"") ;
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
	
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
							if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
	
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
								}
								else
								{
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
	
							}
							else if(apiCallResponseJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");
								returnValue=getErrorString(value);
	
							}
							JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
						}
						else
						{

							System.out.println("Posting Of Invoice data ...........");
							String docEntry = "";
							String cardCode = "";
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
							//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"Invoices",conn, loadNo);
							salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"Invoices",conn, loadNo,refBank);
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
	
							String salesInvoiceApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
							String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("Invoices", salesInvoiceApiURL, "A", "E", lastDcrID, "F-DCR", "POST", salesInvJSONobj,userInfo,"") ;
							//String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(salesInvJSONobj, salesInvoiceApiURL,"POST");
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
	
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
							if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
							{
	
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
								}
								else
								{
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
	
							}
							else if(apiCallResponseJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");
	
								returnValue=getErrorString(value);
	
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.trim().length() > 0 )
							{
								JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
	
								System.out.println("before Cast");
								docEntry = apiCallResponseJSON.getInt("DocEntry")+"";
								cardCode = apiCallResponseJSON.getString("CardCode")+"";
								System.out.println("after Cast["+docEntry+"], cardCode=["+cardCode+"]");
	
							}
							System.out.println("docEntry =["+docEntry+"]");
							if (docEntry != null && docEntry.trim().length() > 0)
							{
								invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,totalAmount,docEntry,invoiceID,conn, chequeNo, loadNo, cardCode);
	
								System.out.println("invJPaymentSONobj =["+invJPaymentSONobj.toString()+"]");
	
								String paymentApiURL = "https://20.219.186.30:50000/b1s/v1/IncomingPayments";
								String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("IncomingPayments", paymentApiURL, "A", "E", lastDcrID, "F-DCR", "POST", invJPaymentSONobj, userInfo,"") ;
	
								//String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(invJPaymentSONobj, paymentApiURL,"POST");
								System.out.println("paymentApiCallResponseJsonStr =["+paymentApiCallResponseJsonStr+"]");
								if(paymentApiCallResponseJsonStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(paymentApiCallResponseJsonStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value=message.getString("value");
									System.out.println("paymentApiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue=getErrorString(value);
								}
							}
						}
						/*
						if((gstNo == null || gstNo.trim().length()== 0 || "C".equalsIgnoreCase(salesType)) && ("C".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode) ))
						{
							System.out.println("Posting Of Invoice data ...........");
							String docEntry = "";
							String cardCode = "";
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
							//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"Invoices",conn, loadNo);
							salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"Invoices",conn, loadNo,refBank);
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
	
							String salesInvoiceApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
							String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("Invoices", salesInvoiceApiURL, "A", "E", lastDcrID, "F-DCR", "POST", salesInvJSONobj,userInfo,"") ;
							//String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(salesInvJSONobj, salesInvoiceApiURL,"POST");
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
	
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
							if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
							{
	
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
								}
								else
								{
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
	
							}
							else if(apiCallResponseJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");
	
								returnValue=getErrorString(value);
	
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.trim().length() > 0 )
							{
								JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
	
								System.out.println("before Cast");
								docEntry = apiCallResponseJSON.getInt("DocEntry")+"";
								cardCode = apiCallResponseJSON.getString("CardCode")+"";
								System.out.println("after Cast["+docEntry+"], cardCode=["+cardCode+"]");
	
							}
							System.out.println("docEntry =["+docEntry+"]");
							if (docEntry != null && docEntry.trim().length() > 0)
							{
								invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,totalAmount,docEntry,invoiceID,conn, chequeNo, loadNo, cardCode);
	
								System.out.println("invJPaymentSONobj =["+invJPaymentSONobj.toString()+"]");
	
								String paymentApiURL = "https://20.219.186.30:50000/b1s/v1/IncomingPayments";
								String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("IncomingPayments", paymentApiURL, "A", "E", lastDcrID, "F-DCR", "POST", invJPaymentSONobj, userInfo,"") ;
	
								//String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(invJPaymentSONobj, paymentApiURL,"POST");
								System.out.println("paymentApiCallResponseJsonStr =["+paymentApiCallResponseJsonStr+"]");
								if(paymentApiCallResponseJsonStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(paymentApiCallResponseJsonStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value=message.getString("value");
									System.out.println("paymentApiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue=getErrorString(value);
								}
							}
						}
						else
						{
							System.out.println("Posting Of Delivery Note ...........");
							//String deliverNoteApiURL = "https://20.219.186.30:50000/b1s/v1/DeliveryNotes";
							//String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
							//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"DeliveryNotes",conn, loadNo);
							salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranId,payMode,gstNo,invoiceID,chequeNo,"DeliveryNotes",conn, loadNo,refBank);
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
							String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/DeliveryNotes";
							//String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(salesInvJSONobj, deliverNoteApiURL,"POST");
							String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("DeliveryNotes", deliverNoteApiURL, "A", "E", lastDcrID, "F-DCR", "POST", salesInvJSONobj, userInfo,"") ;
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
	
							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
							if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
	
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
								}
								else
								{
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
	
							}
							else if(apiCallResponseJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");
								returnValue=getErrorString(value);
	
							}
							JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
	
						}
						*/
					}//End of While loop
				
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
	
				int totalApiCnt=0;
				String Sql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? ";
				pstmt = conn.prepareStatement(Sql);
				pstmt.setString(1, lastDcrID);
				pstmt.setString(2, userInfo.getEnterprise());
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalApiCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}	
				int totalApiSucessCnt=0;
				String apiSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' ";
				pstmt = conn.prepareStatement(apiSql);
				pstmt.setString(1, lastDcrID);
				pstmt.setString(2, userInfo.getEnterprise());
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalApiSucessCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("totalApiCnt = ["+totalApiCnt+"], totalApiSucessCnt=["+totalApiSucessCnt+"]");
				if(totalApiSucessCnt==totalApiCnt)
				{
					int stockCnt = 0;
					String locCode= getLocCode(dcrID, conn);
					String stockSql="SELECT COUNT(1) AS COUNT FROM STOCK S ,ITEM I,LOCATION L , SALES_PERS SL "
							+ "WHERE S.ITEM_CODE=I.ITEM_CODE AND S.LOC_CODE=L.LOC_CODE "
							+ "AND SL.ITEM_SER = I.ITEM_SER "
							+ "AND SL.SALES_PERS = S.LOC_CODE "
							+ "AND S.LOC_CODE= ? "
							+ "AND S.SITE_CODE=? AND S.QUANTITY > 0";
					pstmt =  conn.prepareStatement(stockSql);
					pstmt.setString(1, locCode);
					pstmt.setString(2, empSite);
					
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockCnt = rs.getInt("COUNT");
					}
					System.out.println("stockCnt = ["+stockCnt+"]");
					if(stockCnt > 0)
					{
						JSONObject vanToWareHouseJson = new JSONObject();
					
						StockTransactionCreation stockTransactionCreation=new StockTransactionCreation();
						vanToWareHouseJson = stockTransactionCreation.transactionCreation(locCode,aproverEmpCode, userId, empSite, dcrID, loadNo, vehNo, conn);
						//if(vanToWareHouseJson != null)
						{
							String vanStockUrl = "https://lbcp.rpminfotech.com/api/VanToWarehouseTransfer";
							String apiCallResponseVanJsonStr = e12ExternalAPICall.apiCallToPostData("VanToWarehouseTransfer", vanStockUrl, "A", "E", lastDcrID, "F-DCR", "POST", vanToWareHouseJson, userInfo,"");
							if(apiCallResponseVanJsonStr.indexOf("[")==0 && apiCallResponseVanJsonStr.lastIndexOf("]")==apiCallResponseVanJsonStr.length()-1)
							{
								apiCallResponseVanJsonStr=apiCallResponseVanJsonStr.substring(1, apiCallResponseVanJsonStr.length()-1);
							}
							
							if(apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
								
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
		
								}
								else
								{
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
		
		
							}
							else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
								returnValue=getErrorString(value);
		
							}
							int vanSucessCnt=0;
							String sql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME='VanToWarehouseTransfer' " ; 
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, lastDcrID);
							pstmt.setString(2, userInfo.getEnterprise());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								vanSucessCnt=rs.getInt("COUNT");
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}	
							if(vanSucessCnt>0)
							{
								AppConnectParm appConnect = new AppConnectParm();
								InitialContext initialContext = new InitialContext(appConnect.getProperty());
								
								java.util.Date date = Calendar.getInstance().getTime();
								DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
								String currentDate = dtFormat.format( date );
		
								String transactionID="";
								String sql1="SELECT REQUEST_DATA FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME='VanToWarehouseTransfer' " ;
								pstmt = conn.prepareStatement(sql1);
								pstmt.setString(1, lastDcrID);
								pstmt.setString(2, userInfo.getEnterprise());
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									String requestData=checkNull(rs.getString("REQUEST_DATA"));
									JSONObject object = new JSONObject(requestData);
									transactionID = checkNull(object.getString("U_MTID"));
								}
								if( rs !=null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt !=null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("transactionID::::::::::::::::::["+transactionID+"]");
								if(transactionID!=null && transactionID.trim().length()>0)
								{
									StringBuffer processDynXmlString=new StringBuffer();
									processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
									processDynXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
									processDynXmlString.append("<objName><![CDATA[stock_transfer]]></objName>");
									processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
									processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
									processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
									processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
									processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
									processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
									processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
									processDynXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
									processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
									processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
									processDynXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
									
									String siteCode="";
									String stockTrasferSql="SELECT  * FROM STOCK_TRANSFER WHERE  TRAN_ID=? ";
									pstmt = conn.prepareStatement(stockTrasferSql);
									pstmt.setString(1, transactionID);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										String objContext="1";
										siteCode=checkNull(rs.getString("SITE_CODE"));
										System.out.println("for detail1");
		
										processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='"+objContext+"'  objName='stock_transfer'>");
										processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
										processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
										processDynXmlString.append("<tran_date><![CDATA[").append( currentDate ).append("]]></tran_date>");
										processDynXmlString.append("<site_code><![CDATA[").append( checkNull(rs.getString("SITE_CODE")) ).append("]]></site_code>");
										processDynXmlString.append("<ref_ser__for><![CDATA[").append("XFRX").append("]]></ref_ser__for>");
										processDynXmlString.append("<ref_id__for><![CDATA[").append( checkNull(rs.getString("REF_ID__FOR")) ).append("]]></ref_id__for>");
										processDynXmlString.append("<reas_code><![CDATA[").append( checkNull(rs.getString("REAS_CODE"))  ).append("]]></reas_code>");
										processDynXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>");
										processDynXmlString.append("<confirmed><![CDATA[").append( "N" ).append("]]></confirmed>");
										processDynXmlString.append("<conf_date><![CDATA[]]></conf_date>");
										processDynXmlString.append("<emp_code__aprv><![CDATA[").append(aproverEmpCode).append("]]></emp_code__aprv>");
										processDynXmlString.append("<chg_date><![CDATA[").append(currentDate).append("]]></chg_date>");
										processDynXmlString.append("<chg_term><![CDATA[").append("SYSTEM").append("]]></chg_term>");
										processDynXmlString.append("<chg_user><![CDATA[").append(userId).append("]]></chg_user>");
										processDynXmlString.append("<full_name><![CDATA[").append("").append("]]></full_name>");
										processDynXmlString.append("<tran_type><![CDATA[").append("I").append("]]></tran_type>");
										processDynXmlString.append("<truck_no><![CDATA[").append(checkNull(rs.getString("TRUCK_NO"))).append("]]></truck_no>");
										processDynXmlString.append("<ref_date><![CDATA[").append(currentDate).append("]]></ref_date>");
										processDynXmlString.append("</Detail1>");
									}
									if( rs !=null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt !=null )
									{
										pstmt.close();
										pstmt = null;
									}
									String locationCodeFrom="",locationCodeFromDescr="";
		
									
									String locCodeToSql="SELECT LOC_CODE,DESCR FROM LOCATION WHERE SITE_CODE=? AND LOC_TYPE='DP'";
									pstmt =  conn.prepareStatement(locCodeToSql);
									pstmt.setString(1, siteCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										locationCodeFrom = checkNull(rs.getString("LOC_CODE"));
										locationCodeFromDescr = checkNull(rs.getString("DESCR"));
		
									}
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									
									int lineNo=1;
									String stockTrasferDetSql="SELECT  * FROM STOCK_TRANSFER_DET WHERE  TRAN_ID=? ";
									pstmt = conn.prepareStatement(stockTrasferDetSql);
									pstmt.setString(1, transactionID);
									rs = pstmt.executeQuery();
									int noart=2;
		
									while(rs.next())
									{
										String objContext="2";
										System.out.println("for detail2");
		
										processDynXmlString.append("<Detail2 dbID='' domID='"+lineNo+"'  objContext='"+objContext+"'  objName='stock_transfer'>");
										processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
										processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
										processDynXmlString.append("<line_no><![CDATA[").append( lineNo ).append("]]></line_no>");
										processDynXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>");
										processDynXmlString.append("<quantity><![CDATA[").append(checkNull(rs.getString("QUANTITY"))).append("]]></quantity>");
										processDynXmlString.append("<loc_code__fr><![CDATA[").append(locationCodeFrom).append("]]></loc_code__fr>");
										processDynXmlString.append("<loc_code__to><![CDATA[").append( "DMYLOC" ).append("]]></loc_code__to>");
										processDynXmlString.append("<lot_no__fr><![CDATA[").append(checkNull(rs.getString("LOT_NO__FR"))).append("]]></lot_no__fr>");
										processDynXmlString.append("<lot_no__to><![CDATA[").append(checkNull(rs.getString("LOT_NO__TO"))).append("]]></lot_no__to>");
										processDynXmlString.append("<lot_sl__fr><![CDATA[").append(checkNull(rs.getString("LOT_SL__FR"))).append("]]></lot_sl__fr>");
										processDynXmlString.append("<lot_sl__to><![CDATA[").append(checkNull(rs.getString("LOT_SL__TO"))).append("]]></lot_sl__to>");
										processDynXmlString.append("<remarks><![CDATA[]]></remarks>");
										processDynXmlString.append("<acct_code__cr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__CR"))).append("]]></acct_code__cr>");
										processDynXmlString.append("<acct_code__dr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__DR"))).append("]]></acct_code__dr>");
										processDynXmlString.append("<cctr_code__dr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__DR"))).append("]]></cctr_code__dr>");
										processDynXmlString.append("<cctr_code__cr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__CR"))).append("]]></cctr_code__cr>");
										processDynXmlString.append("<location_descr__fr><![CDATA[").append(locationCodeFromDescr).append("]]></location_descr__fr>");
										processDynXmlString.append("<no_art><![CDATA[").append(noart).append("]]></no_art>");			
										processDynXmlString.append("</Detail2>");								
										lineNo++;
									}
									if( rs !=null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt !=null )
									{
										pstmt.close();
										pstmt = null;
									}
									
									processDynXmlString.append("</Header0></group0></DocumentRoot>");
									String XmlString = processDynXmlString.toString();
									System.out.println("returnString:::::FOR XmlString"+XmlString);
		
									MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
									String reString = masterStateful.processRequest( getUserInfo(), XmlString, false, conn);
									System.out.println("returnString:::::FOR DUMY"+reString);
								}
								
								returnValue = closeLoad(salesPersLoad, loadNo, e12ExternalAPICall, userInfo, lastDcrID, conn);
								/*
								JSONObject closeLoadJSON = new JSONObject();
								closeLoadJSON.put("U_LDCL", "CL");
								
								String closeLoadUrl = "https://20.219.186.30:50000/b1s/v1/StockTransfers("+loadNo+")";
								String apiCallResponseStr = e12ExternalAPICall.apiCallToPostData("CLOSE_LOAD", closeLoadUrl, "A", "E", lastDcrID, "F-DCR", "PATCH", closeLoadJSON, userInfo,"");
								if(apiCallResponseStr.indexOf("[")==0 && apiCallResponseStr.lastIndexOf("]")==apiCallResponseStr.length()-1)
								{
									apiCallResponseVanJsonStr=apiCallResponseStr.substring(1, apiCallResponseStr.length()-1);
								}
								
								if(apiCallResponseStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(apiCallResponseStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value=message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
									returnValue=getErrorString(value);
		
								}
								else
								{
									String updLoadStatSql = "UPDATE SPRS_DAY_SUMM SET LOAD_STATUS = 'Y' WHERE SALES_PERS = ? AND LOAD_NO = ?";
									pstmt = conn.prepareStatement(updLoadStatSql);
									pstmt.setString(1, salesPersLoad);
									pstmt.setString(2, loadNo);
									int updCnt = pstmt.executeUpdate();
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("SPRS_DAY_SUMM LOAD_STATUS updCnt =["+updCnt+"]");
									
								}
								*/
							}//if(vanSucessCnt>0)
							JSONObject apiCallResponseVanJSON = new JSONObject(apiCallResponseVanJsonStr);
							
							
						}//if(vanToWareHouseJson != null)
					}//stockCnt > 0
					else
					{
						returnValue = closeLoad(salesPersLoad, loadNo, e12ExternalAPICall, userInfo, lastDcrID, conn);
					}
				}//if(totalApiSucessCnt==totalApiCnt)
			}//Load Status
		}
		catch (Exception e) 
		{
			isError = true;
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( conn != null && isLocalConn )
				{
					if ( ! isError )
					{
						conn.commit();
						System.out.println("API Calling Connection commited........");
					}
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
	    }
		System.out.println("returnValue =["+returnValue+"]");
		return returnValue;
	}
	
	//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
	//public JSONObject getARInvoiceDetails(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String gstNo,String invoiceID,String cheqNo,String apiName,Connection conn, String loadNo) throws ITMException
	public JSONObject getARInvoiceDetails(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String gstNo,String invoiceID,String cheqNo,String apiName,Connection conn, String loadNo, String refBank) throws ITMException
	//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
	{

		JSONObject obj = new JSONObject();
		PreparedStatement pstmt=null;
		PreparedStatement pst1=null;
		ResultSet rs1=null;
		ResultSet rs=null;
		try 
		{
			System.out.print("Inside getARInvoiceDetails for json");

			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_PASS_VAL",conn);


			JSONArray batchJsonArray = new JSONArray();

			//String displayDate=genericUtility.getValidDateString( tranDate, "yyyy-MM-dd", "dd/MM/yyy") ;

			int itemLine=0;
			String salesType = "";
			String invoiceStatus = "";
			
			String invoiceSql="SELECT SMI.LINE_NO,SMI.QUANTITY,SMI.ITEM_CODE,SMI.RATE,STOCK.LOT_NO"
					+ ", (CASE WHEN SM.SALES_TYPE ='I' THEN 'B2B' WHEN SM.SALES_TYPE ='C' THEN 'Sales' ELSE SM.SALES_TYPE END ) AS SALES_TYPE "
					+ ",SMI.INVOICE_STATUS AS INVOICE_STATUS "
					+ "FROM STRG_MEET_INVOICE SMI,STOCK STOCK, STRG_MEET SM WHERE SMI.TRAN_ID = SM.TRAN_ID AND SMI.TRAN_ID= ? AND SMI.ITEM_CODE=STOCK.ITEM_CODE AND STOCK.SITE_CODE= ?  "
					+ "AND STOCK.LOC_CODE=? AND SMI.INVOICE_ID=? AND nvl(SMI.QUANTITY,0)<>0 ";
			pst1 = conn.prepareStatement(invoiceSql);
			pst1.setString(1, tranID);
			pst1.setString(2, empSite);
			pst1.setString(3, salesPers);
			pst1.setString(4, invoiceID);

			rs1 = pst1.executeQuery();
			
			System.out.println("before the resultset.........");
			
			while(rs1.next())
			{
				System.out.println("Inside the resultset.........");
				JSONObject batchJsonObj = new JSONObject();					

				JSONObject BatchNumbersObj = new JSONObject();
				JSONArray BatchNumbersArray = new JSONArray();
				
				JSONArray DocumentLinesBinAllocationsArray = new JSONArray();
				JSONObject DocumentLinesBinAllocationsObj = new JSONObject();


				String itemCode=checkNull(rs1.getString("ITEM_CODE"));
				String lotNo=rs1.getString("LOT_NO");
				double quantity=rs1.getDouble("QUANTITY");
				double rate=rs1.getDouble("RATE");
				
				salesType=checkNull(rs1.getString("SALES_TYPE"));
				invoiceStatus=checkNull(rs1.getString("INVOICE_STATUS"));
				
				System.out.println("itemCode =["+itemCode+"], lotNo=["+lotNo+"],quantity=["+quantity+"],rate=["+rate+"], salesType=["+salesType+"]");

				BatchNumbersObj.put("BatchNumber", lotNo);
				BatchNumbersObj.put("Quantity", quantity);
				BatchNumbersObj.put("BaseLineNumber", itemLine);
				BatchNumbersObj.put("ItemCode", itemCode);
				//BatchNumbersArray.add(BatchNumbersObj);
				BatchNumbersArray.put(BatchNumbersObj);

				DocumentLinesBinAllocationsObj.put("BinAbsEntry", BinAbsEntry);
				DocumentLinesBinAllocationsObj.put("Quantity", quantity);
				//DocumentLinesBinAllocationsObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				DocumentLinesBinAllocationsObj.put("SerialAndBatchNumbersBaseLine", "0");
				DocumentLinesBinAllocationsObj.put("BaseLineNumber", itemLine);
				//DocumentLinesBinAllocationsArray.add(DocumentLinesBinAllocationsObj);
				DocumentLinesBinAllocationsArray.put(DocumentLinesBinAllocationsObj);


				batchJsonObj.put("LineNum", itemLine);
				batchJsonObj.put("ItemCode", itemCode);
				batchJsonObj.put("Quantity", quantity);
				System.out.println("Sales Person stateCode["+stateCode+"] custStateCode =["+custStateCode+"]");
				if(stateCode.trim().equalsIgnoreCase(custStateCode.trim()))
				{
					batchJsonObj.put("TaxCode", "CG+SG@28");
				}
				else
				{
					batchJsonObj.put("TaxCode", "IGST@28");
				}
				batchJsonObj.put("UnitPrice", rate);
				batchJsonObj.put("DiscountPercent", "0");
				batchJsonObj.put("WarehouseCode", locGroup);
				batchJsonObj.put("BatchNumbers", BatchNumbersArray);
				batchJsonObj.put("DocumentLinesBinAllocations", DocumentLinesBinAllocationsArray);
				//batchJsonArray.add(batchJsonObj);
				batchJsonArray.put(batchJsonObj);
				itemLine++;
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}
			
			obj.put("CardCode", strgCode);
			obj.put("BPL_IDAssignedToInvoice", empSite);
			obj.put("DocDate", tranDate);
			obj.put("DocType", "I");
			obj.put("Comments", remarks);
			//obj.put("SalesPersonCode", "U_SLPRN");
			obj.put("SalesPersonCode", salesPers);
			
			/*--Commented and changed by Gulzar on 15FEB24 
			if(gstNo==null || gstNo.trim().length()==0)
			{
				if("C".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode) )
				{
					obj.put("GSTTransactionType", "GA");

				}
			}*/
			obj.put("GSTTransactionType", "GA");
			//End changed by Gulzar on 15FEB24 
			
			obj.put("DiscountPercent", "0.0");
			obj.put("U_SOM", "M");
			obj.put("U_MTID",tranID);
			obj.put("U_MIN",invoiceID);
			
			/*--Commented and changed by Gulzar on 22MAR2024 
			if("DeliveryNotes".equalsIgnoreCase(apiName) && "Q".equalsIgnoreCase(payMode))
			{
				obj.put("U_CHKN",cheqNo);
				obj.put("U_MOPT",payMode);//Added by Gulzar on 250423 as changes requested from RPM
			}
			else //if("DeliveryNotes".equalsIgnoreCase(apiName))
			{
				obj.put("U_CHKN","");
				obj.put("U_MOPT",payMode);//Added by Gulzar on 250423 as changes requested from RPM
			}
			*/
			obj.put("U_CHKN",cheqNo);
			obj.put("U_MOPT",payMode);
			//changed by Gulzar on 22MAR2024 ENDs
			
			//Added by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
			obj.put("U_BNKNM", refBank);
			//Added by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
			obj.put("U_MSaleType", salesType);
			obj.put("U_AINVSTAT", invoiceStatus);//Added by Guzar 25FEB24 to post invoice status

			obj.put("CompanyDB", companyDB);
			obj.put("Password", passwordDB);
			obj.put("UserName", userNameDB);
			obj.put("U_MLDN", loadNo);
				
			obj.put("DocumentLines",batchJsonArray);
			
			System.out.println("getCashWiseInvoiceDetails for json :: "+obj.toString());
		}
		catch(Exception e)
		{
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return obj;
	}
	public JSONObject getIncomingPayment(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String totalAmount,String docEntry,String invoiceID, Connection conn, String chequeNo, String loadNo, String cardCode) throws ITMException
	{

		JSONObject customerJsonObj = new JSONObject();
		PreparedStatement pst1=null;
		ResultSet rs1=null;
		try
		{

            JSONArray PaymentInvoiceJsonArray = new JSONArray();
            String SumApplied="";
            String acctCodeTrf = "";

			String safParmSql="SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT='ALL' AND PARM_NAME ='ACCT_CODE_TRANSFER' AND ACTIVE='Y'";
					
			pst1 = conn.prepareStatement(safParmSql);
	
			rs1 = pst1.executeQuery();
			if(rs1.next())
			{
				acctCodeTrf = checkNull(rs1.getString("PARM_VALUE"));
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}

			String invoiceSql="SELECT DISTINCT SMI.STRG_CODE, "
						+ "round((SUM(smi.quantity*smi.rate) + SUM(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'CGST' )/100) +SUM(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'SGST' )/100)),0) AS TOTAL, "
						+ "SMI.INVOICE_ID "
						+ "FROM STRG_MEET_INVOICE SMI,ITEM I  "
						+ "WHERE "
						+ "SMI.ITEM_CODE = I.ITEM_CODE AND SMI.TRAN_ID=? AND SMI.INVOICE_ID=? "
						+ "GROUP BY SMI.STRG_CODE,SMI.TRAN_ID,SMI.INVOICE_ID ";
						
			pst1 = conn.prepareStatement(invoiceSql);
			pst1.setString(1, tranID);
			pst1.setString(2, invoiceID);

			rs1 = pst1.executeQuery();
			int itemLine=0;
			if(rs1.next())
			{
				JSONObject PaymentInvoicesjsonObj = new JSONObject();
				SumApplied=checkNull(rs1.getString("TOTAL"));

				PaymentInvoicesjsonObj.put("LineNum",itemLine);
				PaymentInvoicesjsonObj.put("DocEntry", docEntry);
				PaymentInvoicesjsonObj.put("SumApplied", SumApplied);
				PaymentInvoicesjsonObj.put("InvoiceType", "it_Invoice");	
				//PaymentInvoiceJsonArray.add(PaymentInvoicesjsonObj);
				PaymentInvoiceJsonArray.put(PaymentInvoicesjsonObj);
				itemLine++;

			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}

			customerJsonObj.put("DocType", "rCustomer");
			customerJsonObj.put("DocDate", tranDate);
			//Commented and changed by Gulzar on 15-Feb-2024
			//customerJsonObj.put("CardCode", strgCode);
			customerJsonObj.put("CardCode", cardCode);
			//End changed by Gulzar on 15-Feb-2024
			//customerJsonObj.put("CashSum", totalAmount);
			if("O".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode))
			{
				customerJsonObj.put("TransferAccount", acctCodeTrf);
				customerJsonObj.put("TransferSum", SumApplied);
			}
			else if("C".equalsIgnoreCase(payMode)) 
			{
				customerJsonObj.put("CashSum", SumApplied);
			}
			else if("Q".equalsIgnoreCase(payMode))
			{
				//Commented and changed by Sanket 
				// In case of Cheque Payment the CashSum and TransferSum should be 0
				//customerJsonObj.put("CashSum", SumApplied);
				customerJsonObj.put("CashSum", "0");
				customerJsonObj.put("TransferSum", "0");
			}

			customerJsonObj.put("TransferDate", tranDate);
			customerJsonObj.put("Remarks", remarks);
			customerJsonObj.put("TaxDate",tranDate);
			customerJsonObj.put("BPLID",empSite);
			customerJsonObj.put("U_SOM","M");
			customerJsonObj.put("U_MIN",invoiceID);
			customerJsonObj.put("U_MTID",tranID);
			customerJsonObj.put("U_MLDN",loadNo);//Gulzar 210523

			customerJsonObj.put("PaymentInvoices",PaymentInvoiceJsonArray);
			
			//Changed by Sanket - Start
			if(payMode.equalsIgnoreCase("Q"))
			{

				JSONObject paymentChecksObj = new JSONObject();
				JSONArray paymentChecksArray = new JSONArray();

				paymentChecksObj.put("CheckNumber", chequeNo);
				paymentChecksObj.put("CheckSum", SumApplied);

				paymentChecksArray.put(paymentChecksObj);
				customerJsonObj.put("PaymentChecks",paymentChecksArray);
			}
			//Changed by Sanket - END
			
			System.out.println( "Inside getCustomerWiseIncomingPayment objArray["+customerJsonObj.toString()+"]" );
		}
		catch(Exception e){
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pst1 !=null )
				{
					pst1.close();
					pst1 = null;
				}
			}
			catch(Exception e) {}
		}
		return 	customerJsonObj;

	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String getErrorString(String message)
	{
		StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );

		try
		{
			valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
			valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append(message).append("]]></description>\r\n");
			valueXmlErrorString.append("<type>E</type>\r\n");
			valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
			valueXmlErrorString.append("<redirect>1</redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Header>\r\n");
			valueXmlErrorString.append( "</Root>\r\n" );
			System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
			

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return valueXmlErrorString.toString();
	}
	public ArrayList<String> getDcrIDListInFormat(String dcrID,Connection conn)
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		ArrayList<String> dcrIdList =new ArrayList<String>();
		String getTranId = "";
		try
		{
			String eventDate="";
			String salesPers="";
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
				salesPers=checkNull(rs.getString("SALES_PERS"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			/* -- Commented and changed by Gulzar on 15DEC23 - if more than one load is created in the same day.
			String maxDaySummDate="";
			String minDaySummDate="";

			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  conn.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE > ? ";
			pstmt =  conn.prepareStatement(daySummMinSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{

				minCon=" AND EVENT_DATE < ? ";
				
			}

			String getTranId = "SELECT DCR_ID FROM  STRG_MEET WHERE EVENT_DATE >= ?  "+
					minCon+" "+
					" AND SALES_PERS =? order by event_date";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");

			pstmt = conn.prepareStatement(getTranId);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pstmt.setString( 3, salesPers);
			}
			else
			{
				pstmt.setString( 2, salesPers);
			}
			*/
			String loadNo = wsfaCommon.getLoadNo(salesPers, conn);
			
			getTranId = "SELECT DISTINCT DCR_ID FROM  STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO =? ) "; 
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			pstmt.setString(3, loadNo);

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				dcrID = checkNull(rs.getString("DCR_ID"));
				if(dcrID != null && dcrID.trim().length()>0)
				{
					if(!dcrIdList.contains(dcrID))
					{
						dcrIdList.add(dcrID);
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("dcrIdList["+dcrIdList+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1) 
			{
				// TODO: handle exception
			}
			
		}
		
		return dcrIdList;
	}
	public JSONObject getSplitInvoiceDetails(String dcrID,String dcrIdInForm, Connection conn, String loadNo) throws ITMException 
	{
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		JSONArray splitBundleArray = new JSONArray();
		int counter = 1;
		try 
		{
			String salesPers = "",remarks="";
			java.sql.Timestamp eventDate = null;
			String sql = "SELECT SALES_PERS,EVENT_DATE,REMARK FROM SPRS_ACT_TRAN WHERE DCR_ID = ?";
			System.out.println("inside transactionsql ::"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				salesPers = checkNull(rs.getString("SALES_PERS"));
				eventDate = rs.getTimestamp("EVENT_DATE");
				remarks = checkNull(rs.getString("REMARK"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_PASS_VAL",conn);
			
			System.out.println("salespers ::["+salesPers+"] eventdate ::["+eventDate+"] remarks ::["+remarks+"]");
			String splitInvoiceSql =  "SELECT DISTINCT EMP.EMP_CODE,EMP.EMP_SITE,SMI.ITEM_CODE AS CHILD_ITEM,SMI.BREAK_ITEM__REF AS PARENT_ITEM,L.LOC_GROUP,L.LOC_PHY_AREA,"
					+ "FN_GET_STOCK_TRANFER_API_DATA('BREAK_ADD_QTY',SMI.ITEM_CODE,?,trunc(?)) AS BREAK_ADD_QTY,"
					+ "FN_GET_STOCK_TRANFER_API_DATA('BREAK_DEDUCT_QTY',SMI.BREAK_ITEM__REF,?,trunc(?)) AS BREAK_DEDUCT_QTY FROM STRG_MEET_INVOICE SMI,"
					+ "SPRS_ACT_TRAN SAT,EMPLOYEE EMP,LOCATION L WHERE SAT.DCR_ID IN("+dcrIdInForm+") AND SAT.DCR_ID=SMI.DCR_ID AND EMP.EMP_CODE=SAT.SALES_PERS AND EMP.EMP_CODE=L.LOC_CODE AND SMI.BREAK_ITEM__REF IS NOT NULL GROUP BY EMP.EMP_CODE,EMP.EMP_SITE,SMI.ITEM_CODE,SMI.BREAK_ITEM__REF,SAT.EVENT_DATE,SAT.SALES_PERS,L.LOC_GROUP,L.LOC_PHY_AREA";
			
			System.out.println("inside splitInvoiceSql ::"+splitInvoiceSql);
			pstmt1 = conn.prepareStatement(splitInvoiceSql);
			pstmt1.setString(1, salesPers);
			pstmt1.setTimestamp(2, eventDate);
			pstmt1.setString(3,salesPers);
			pstmt1.setTimestamp(4,eventDate);
			rs1 = pstmt1.executeQuery();
		
			while(rs1.next())
			{
				String empCode = checkNull(rs1.getString("EMP_CODE"));
				String empSite = checkNull(rs1.getString("EMP_SITE"));
				String itemCode = checkNull(rs1.getString("CHILD_ITEM"));
				String parentItem = checkNull(rs1.getString("PARENT_ITEM"));
				String locGroup = checkNull(rs1.getString("LOC_GROUP"));
				String BinAbsEntry = checkNull(rs1.getString("LOC_PHY_AREA"));
				int breakAddQty = rs1.getInt("BREAK_ADD_QTY");
				int breakDeductQty = rs1.getInt("BREAK_DEDUCT_QTY");
				
				//dcrID = checkNull(rs1.getString("DCR_ID"));
				
				JSONObject splitBundleObj = new JSONObject();
				
				if(counter == 1)
				{
					/*obj.put("CompanyDB", "Z_LBCP_MOB_APP");
					obj.put("Password", "Sap@1234");
					obj.put("UserName", "manager");*/
					
					obj.put("CompanyDB", companyDB);
					obj.put("Password", passwordDB);
					obj.put("UserName", userNameDB);
					
					obj.put("BPL_IDAssignedToInvoice",empSite);
					obj.put("Comments", remarks);
					obj.put("SalesPersonCode",empCode);
					obj.put("U_SOM", "M");
					obj.put("U_MLDN", loadNo);
				}
				splitBundleObj.put("O_ItemCode", parentItem);
				splitBundleObj.put("O_Quantity",breakDeductQty);
				splitBundleObj.put("O_WarehouseCode",locGroup);
				splitBundleObj.put("O_BinAbsEntry", BinAbsEntry);
				splitBundleObj.put("C_ItemCode",itemCode);
				splitBundleObj.put("C_Quantity",breakAddQty);
				splitBundleObj.put("C_WarehouseCode",locGroup);
				splitBundleObj.put("C_BinAbsEntry",BinAbsEntry);
				
				splitBundleArray.put(splitBundleObj);
				obj.put("ApplicationJson_SplitBundle_RequestList", splitBundleArray);
				counter++;
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pstmt1 !=null )
			{
				pstmt1.close();
				pstmt1 = null;
			}
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("splitinvoice json :: "+obj.toString());
		if(obj.toString().equalsIgnoreCase("{}"))
		{
			return null;
		}
		else
		{
			return obj;
		}

	}
	
	public ArrayList<String> getStockTransferTranIDFormat(String dcrID,Connection conn)
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		ArrayList<String> tranIDList =new ArrayList<String>();
		String getTranId = "";
		try
		{
			String eventDate="";
			String salesPers="";
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
				salesPers=checkNull(rs.getString("SALES_PERS"));
		
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			/*--Commented and Changes by Gulzar on 16DEC2023
			String maxDaySummDate="";
			String minDaySummDate="";
		
			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  conn.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE >? ";
			pstmt =  conn.prepareStatement(daySummMinSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));
		
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0)
			{
		
				minCon=" AND ST.TRAN_DATE< ? ";
		
			}
			getTranId = "SELECT ST.TRAN_ID AS TRAN_ID FROM  STOCK_TRANSFER ST,STOCK_TRANSFER_DET STD WHERE ST.TRAN_DATE >= ?" +minCon+"AND STD.LOC_CODE__FR =? AND ST.TRAN_ID=STD.TRAN_ID "+
			" AND STD.LOC_CODE__TO NOT IN(SELECT LOC_CODE FROM LOCATION WHERE SITE_CODE= (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ?) AND LOC_TYPE='DP') "+
			" order by ST.TRAN_DATE";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");
		
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0)
			{
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pstmt.setString( 3, salesPers);
				pstmt.setString( 4, salesPers);
			}
			else
			{
				pstmt.setString( 2, salesPers);
				pstmt.setString( 3, salesPers);
			}
			*/
			//End Changes by Gulzar on 16DEC23
			
			getTranId = "SELECT ST.TRAN_ID AS TRAN_ID FROM  STOCK_TRANSFER ST,STOCK_TRANSFER_DET STD "
					+ " WHERE TRUNC(ST.TRAN_DATE) = (SELECT TRUNC(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE LOAD_NO =(SELECT LOAD_NO FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND DCR_ID =?) ) AND STD.LOC_CODE__FR =? AND ST.TRAN_ID=STD.TRAN_ID "
					+ " AND STD.LOC_CODE__TO NOT IN(SELECT LOC_CODE FROM LOCATION "
					+ " WHERE SITE_CODE= (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE=?) AND LOC_TYPE='DP') order by ST.TRAN_DATE ";
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, dcrID);
			pstmt.setString(3, salesPers);
			pstmt.setString(4, salesPers);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String tranID = checkNull(rs.getString("TRAN_ID"));
				if(tranID != null && tranID.trim().length()>0)
				{
					if(!tranIDList.contains(tranID))
					{
						tranIDList.add(tranID);
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("tranIDList["+tranIDList+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				// TODO: handle exception
			}
	
		}
	
		return tranIDList;
	}

	public JSONObject callVanToVanAPI(ArrayList<String> tranidList, String tranIdIn, Connection conn, String loadNo) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		JSONArray VanStockArray = new JSONArray();
		int counter = 1;
		try 
		{
			
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_PASS_VAL",conn);
			
			System.out.println("tranidList["+tranidList+"]");
			String allTranId = "";
			for(int i = 0; i<tranidList.size(); i++)
			{
				String tranId = tranidList.get(i);
				if(allTranId!= null && allTranId.trim().length() > 0)
				{
					allTranId = allTranId + "," + tranId;
				}
				else
				{
					allTranId = tranId;
				}
			}

			int itemLine=0;
			String vanSql = "SELECT ST.TRAN_DATE,LOC_FROM.LOC_GROUP AS FROM_WARE_HOUSE,LOC_TO.LOC_GROUP AS TO_WARE_HOUSE,ST.TRAN_ID," + 
					"STD.ITEM_CODE,ITEM.DESCR AS ITEM_DESCR,STD.LOT_NO__FR AS BATCH,STD.QUANTITY,LOC_FROM.LOC_PHY_AREA AS FR_BIN," + 
					"2 AS FR_BIN_ACTION,LOC_TO.LOC_PHY_AREA AS TO_BIN,1 AS TO_BIN_ACTION FROM stock_transfer ST,STOCK_TRANSFER_DET STD," + 
					"LOCATION LOC_FROM,LOCATION LOC_TO,ITEM ITEM WHERE ST.TRAN_ID=STD.TRAN_ID AND ST.TRAN_ID IN("+tranIdIn+") AND ITEM.ITEM_CODE=STD.ITEM_CODE AND LOC_FROM.LOC_CODE=STD.LOC_CODE__FR AND LOC_TO.LOC_CODE=LOC_CODE__TO";
			System.out.println("inside vanstocksql ::"+vanSql);
			pstmt = conn.prepareStatement(vanSql);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String tranDate= (rs.getDate("TRAN_DATE")).toString();
				String locGroupFrom = rs.getString("FROM_WARE_HOUSE");
				String locGroupTo = rs.getString("TO_WARE_HOUSE");
				//String tranID = rs.getString("TRAN_ID");
				String itemCode = rs.getString("ITEM_CODE");
				String itemDescr = rs.getString("ITEM_DESCR");
				String batch = rs.getString("BATCH");
				double quantity = rs.getDouble("QUANTITY");
				String binAbsEntryFrom = rs.getString("FR_BIN");
				int frBinAction = rs.getInt("FR_BIN_ACTION");
				String binAbsEntryTo = rs.getString("TO_BIN");
				int toBinAction = rs.getInt("TO_BIN_ACTION");
				
				JSONObject BinAllocationObj = new JSONObject();
				JSONObject BatchNumbersObj = new JSONObject();
				JSONObject VanStockObj = new JSONObject();
				
				JSONArray BinAllocationArray = new JSONArray();
				JSONArray BatchNumbersArray = new JSONArray();
				if(counter == 1)
				{
					/*obj.put("CompanyDB", "Z_LBCP_MOB_APP");
					obj.put("Password", "Sap@1234");
					obj.put("UserName", "manager");*/
					
					obj.put("CompanyDB", companyDB);
					obj.put("Password", passwordDB);
					obj.put("UserName", userNameDB);
					
					obj.put("DocDate",tranDate);
					obj.put("FromWarehouse", locGroupFrom);
					obj.put("ToWarehouse",locGroupTo);
					obj.put("U_SOM", "M");
					obj.put("U_MTID", allTranId);
					obj.put("U_MLDN", loadNo);
				}
				
				VanStockObj.put("LineNum", itemLine);
				VanStockObj.put("ItemCode", itemCode);
				VanStockObj.put("ItemDescription", itemDescr);
				VanStockObj.put("Quantity", quantity);
				
				BatchNumbersObj.put("BatchNumber", batch);
				BatchNumbersObj.put("Quantity", quantity);
				BatchNumbersObj.put("BaseLineNumber", itemLine);
				BatchNumbersObj.put("ItemCode",itemCode);
				
				BatchNumbersArray.put(BatchNumbersObj);
				VanStockObj.put("BatchNumbers",BatchNumbersArray);
				
				BinAllocationObj.put("BinAbsEntry",binAbsEntryFrom);
				BinAllocationObj.put("Quantity", quantity);
				BinAllocationObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				BinAllocationObj.put("BinActionType", frBinAction);
				BinAllocationObj.put("BaseLineNumber",itemLine);
				
				BinAllocationArray.put(BinAllocationObj);
				
				BinAllocationObj = new JSONObject();
				
				BinAllocationObj.put("BinAbsEntry",binAbsEntryTo);
				BinAllocationObj.put("Quantity", quantity);
				BinAllocationObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				BinAllocationObj.put("BinActionType", toBinAction);
				BinAllocationObj.put("BaseLineNumber",itemLine);
				
				BinAllocationArray.put(BinAllocationObj);
								
				VanStockObj.put("StockTransferLinesBinAllocations", BinAllocationArray);
				VanStockArray.put(VanStockObj);
				obj.put("StockTransferLines", VanStockArray);
				counter++;
				itemLine++;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("vanstock json :: "+obj.toString());
		return obj;
	}
	
	public String getLocCode(String dcrID,Connection conn)
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String salesPers="";
		try
		{			
			String sprsSql="SELECT SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				salesPers=checkNull(rs.getString("SALES_PERS"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1) 
			{
				// TODO: handle exception
			}
			
		}
		
		return salesPers;
	}
	private String getLoadNo(String dcrID, Connection conn)
	{
		String loadNo = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String eventDate = "";
		String salesPers = "";
		
		try
		{
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
				salesPers=checkNull(rs.getString("SALES_PERS"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String loadNoSql="SELECT MAX(TO_NUMBER(CASE WHEN LOAD_NO IS NULL THEN '0' ELSE LOAD_NO END)) as LOAD_NO "
					+ "FROM SPRS_DAY_SUMM WHERE SALES_PERS =? AND EVENT_DATE = (SELECT MAX(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE SALES_PERS= ?)";
			pstmt =  conn.prepareStatement(loadNoSql);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loadNo = checkNull(rs.getString("LOAD_NO"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1) 
			{
				// TODO: handle exception
			}
			
		}
		return loadNo;
	}
	public String closeLoad(String salesPersLoad, String loadNo, E12ExternalAPICall e12ExternalAPICall, UserInfoBean userInfo, String lastDcrID, Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String returnValue = "";
		String apiCallResponseVanJsonStr = "";
		try
		{
			JSONObject closeLoadJSON = new JSONObject();
			closeLoadJSON.put("U_LDCL", "CL");
			
			String closeLoadUrl = "https://20.219.186.30:50000/b1s/v1/StockTransfers("+loadNo+")";
			String apiCallResponseStr = e12ExternalAPICall.apiCallToPostData("CLOSE_LOAD", closeLoadUrl, "A", "E", lastDcrID, "F-DCR", "PATCH", closeLoadJSON, userInfo,"");
			if(apiCallResponseStr.indexOf("[")==0 && apiCallResponseStr.lastIndexOf("]")==apiCallResponseStr.length()-1)
			{
				apiCallResponseVanJsonStr = apiCallResponseStr.substring(1, apiCallResponseStr.length()-1);
			}
			
			if(apiCallResponseStr.indexOf("error")!=-1)
			{
				JSONObject obj = new JSONObject(apiCallResponseStr);
				JSONObject error = obj.getJSONObject("error");
				JSONObject message = error.getJSONObject("message");
				String value = message.getString("value");
				System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
				returnValue = getErrorString(value);

			}
			else
			{
				String updLoadStatSql = "UPDATE SPRS_DAY_SUMM SET LOAD_STATUS = 'Y' WHERE SALES_PERS = ? AND LOAD_NO = ?";
				pstmt = conn.prepareStatement(updLoadStatSql);
				pstmt.setString(1, salesPersLoad);
				pstmt.setString(2, loadNo);
				int updCnt = pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("SPRS_DAY_SUMM LOAD_STATUS updCnt =["+updCnt+"]");
				
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1) 
			{
				// TODO: handle exception
			}
			
		}
		return returnValue;
	}
}