/*
 * Changed By Sata 7/19/2010 [WS90NOV049] To implement previous remarks ,from date & todate
 *
 */

package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.CommonConstants;
import ibase.utility.*;
import ibase.utility.BaseLogger;
import java.util.*;
import java.sql.*;
import java.io.*;
import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.InitialContext;
import java.text.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class  SubordinateEvalProcess extends ProcessEJB implements SubordinateEvalProcessRemote,SubordinateEvalProcessLocal//implements SessionBean
{
	SessionContext cSessionContext;
	protected static String database = CommonConstants.DB_NAME;
	/*
 	public void ejbCreate() throws RemoteException, CreateException
	{
		try
		{
			System.out.println("SubordinateEvalProcessEJB ejbCreate called.........");
		}
		catch (Exception e)
		{
			System.out.println("Exception :SubordinateEvalProcessEJB :ejbCreate :==>"+e);
			throw new CreateException();
		}
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
	}
	*/
	public void setSessionContext(SessionContext mSessionContext)
	{
		try
		{
			CommonConstants.setIBASEHOME();
			ProcessEJB.DB_NAME = CommonConstants.DB_NAME;
			this.cSessionContext = mSessionContext;
		}
		catch (Exception e)
		{
			System.out.println("Exception :SubordinateEvalProcessEJB :setSessionContext :==>"+e);
		}
	}

	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println("xmlString   ["+xmlString+"]");
			System.out.println("xmlString2   ["+xmlString2+"]");
			System.out.println("windowName   ["+windowName+"]");
			System.out.println("xtraParams   ["+xtraParams+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
		    retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :SubordinateEvalProcessEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}


	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rset = null ;

		String columnValue ="";
		String childNodeName = "";
		String insertSQL = "";
		String returnString = "";

		String salesPers = "";
		String apprDate = "";
		String wrkDate = "";
		String lstWrkdt = "";
		String specId = "";
		String descr  = "";
		String grade = "";
		String remarks = "";
		String apprTblNo = "";
		String score = "";
		boolean toSaved = true;
		String toDateStr = null;
		String frDateStr = null;
		int status = 0;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");

		String database = CommonConstants.DB_NAME;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			String tranID = generateTransID( conn, loginCode );

			for(int noOfForm= 1; noOfForm <= 2; noOfForm++)
			{
				NodeList parentNodeList = detailDom.getElementsByTagName("Detail"+noOfForm);
				int parentNodeListLength = parentNodeList.getLength();
				for(int parent = 0; parent < parentNodeListLength; parent++)
				{
					Node parentNode = parentNodeList.item(parent);
					NodeList childNodeList = parentNode.getChildNodes();
					int childNodeListLength = childNodeList.getLength();
					for(int ctr = 0; ctr < childNodeListLength; ctr++)
					{
						Node childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						columnValue = "";
						if( childNode.getFirstChild() != null)
						{
						columnValue = checkNull( childNode.getFirstChild().getNodeValue() );
						}
						else
						{
						columnValue = "";
						}
						System.out.println("columnName ["+childNodeName+"] columnValue ["+columnValue+"]");

						if(childNodeName == "sales_pers")
						{
								salesPers = columnValue;
						}
						else if(childNodeName == "appr_date")
						{
								apprDate = columnValue;
						}
						else if(childNodeName == "joint_wrk_dt")
						{
							wrkDate = columnValue;
						}
						else if(childNodeName == "spec_id")
						{
								specId = columnValue;
						}
						else if(childNodeName == "spec_grade")
						{
								grade = columnValue;
						}
						else if(childNodeName == "remarks")
						{
								remarks = columnValue;
						}
						else if(childNodeName == "last_joint_wrk_dt")
						{
								lstWrkdt = columnValue;
						}
						else if(childNodeName == "to_date")
						{
								toDateStr = columnValue;
						}
						else if(childNodeName == "from_date")
						{
								frDateStr = columnValue;
						}
					}
					if( noOfForm == 1 && toSaved )
					{
						String selectQuery = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ( SELECT TRIM(PROFILE_ID) FROM USERS WHERE CODE =? ) ||  '_APPR_TBL_NO'  ";
						pstmt = conn.prepareStatement( selectQuery );
						pstmt.setString( 1, salesPers);
						rset = pstmt.executeQuery();
						if( rset.next() )
						{
							apprTblNo = checkNull(rset.getString("PROP_VALUE"));
						}
						if(rset != null)
						{
							rset.close(); rset = null;
						}
						if(pstmt != null)
						{
							pstmt.close(); pstmt = null;
						}
						if(!wrkDate.equals(lstWrkdt))
						{
							SimpleDateFormat sdfDb = new SimpleDateFormat("yyyy-MM-dd");
							String insertQuery = "INSERT INTO SPRS_APPR(TRAN_ID, APPR_DATE, EMP_CODE, EMP_CODE__BY, APPR_TBLNO, WORK_DATE__APPR, FROM_DATE,TO_DATE) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
							pstmt = conn.prepareStatement( insertQuery );
							pstmt.setString( 1, tranID);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(apprDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString( 3, salesPers);
							pstmt.setString( 4, loginCode);
							pstmt.setString( 5, apprTblNo);
							pstmt.setString( 6, wrkDate);
							pstmt.setDate(7,java.sql.Date.valueOf(sdfDb.format(genericUtility.getDateObject(frDateStr))));
							pstmt.setDate(8,java.sql.Date.valueOf(sdfDb.format(genericUtility.getDateObject(toDateStr))));
							status = pstmt.executeUpdate();
							toSaved = false;
						}
					}
					else
					{
						String selectQuery = "SELECT APPR_SCORE FROM APPRAISAL_SPEC_DET WHERE APPR_SPEC =? AND APPR_GRADE = ? ";
						pstmt = conn.prepareStatement( selectQuery );
						pstmt.setString( 1, specId);
						pstmt.setString( 2, grade);
						rset = pstmt.executeQuery();
						if( rset.next() )
						{
							score = checkNull(rset.getString("APPR_SCORE"));
						}

						String insertQuery = "INSERT INTO SPRS_APPR_DET(TRAN_ID, SPEC_ID , SPEC_GRADE, SPEC_WEIGHTAGE, REMARKS) VALUES(?, ?, ?, ?, ?)";
						pstmt = conn.prepareStatement( insertQuery );
						pstmt.setString( 1, tranID);
						pstmt.setString( 2, specId);
						pstmt.setString( 3, grade);
						pstmt.setString( 4, score);
						pstmt.setString( 5, remarks);

						rset = pstmt.executeQuery();
						grade = "";
						score = "";
						remarks = "";
					}
				}
			}

			if(status > 0)
			{
				conn.commit();
				returnString = tranID;
			}
		}
		catch( Exception e)
		{
			try
			{
			  conn.rollback();
              System.out.println("Exception: [SubordinateEvalProcess]Rolling Back......" );
			}
			catch(Exception e1)
			{
			}
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					rset.close();
				}
				if( conn != null )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return returnString;
	}

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			rtrStr = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rset = null ;
		String sql = "";

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		StringBuffer valueXmlString  = null;

		try
		{
			conn = new ConnDriver().getConnectDB( "DriverITM" );

			int i =2;

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");

			String salesPers = genericUtility.getColumnValue( "sales_pers", headerDom );
			String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			sql = "SELECT AST.APPR_SPEC AS APPR_SPEC, ASEC.SPEC_DETAILS AS SPEC_DETAILS FROM APPRAISAL_SPEC_TABLE AST, APPRAISAL_SPEC ASEC WHERE APPR_TBLNO = (SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ( SELECT TRIM(PROFILE_ID) FROM USERS WHERE CODE =? ) || '_APPR_TBL_NO') AND AST.APPR_SPEC = ASEC.APPR_SPEC ORDER BY APPR_SPEC";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rset = pstmt.executeQuery();
			HashMap prevRemarkMap = getPrevRemarks(salesPers,loginCode,conn) ;
			while( rset.next() )
			{
				String specId = checkNull(rset.getString("APPR_SPEC"));
				String prevRem = (String)prevRemarkMap.get(specId);
				valueXmlString.append("<Detail2 domID='"+i+"' >\r\n");
				valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				valueXmlString.append("<spec_id><![CDATA[").append(specId).append("]]></spec_id>\r\n");
				valueXmlString.append("<descr><![CDATA[").append(checkNull(rset.getString("SPEC_DETAILS"))).append("]]></descr>\r\n");
				valueXmlString.append("<spec_grade><![CDATA[").append("").append("]]></spec_grade>\r\n");
				valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");
				valueXmlString.append("<prev_remarks protected='1'><![CDATA[").append(checkNull(prevRem)).append("]]></prev_remarks>\r\n");
				valueXmlString.append("</Detail2>\r\n");
				i++;
			}

			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");
			valueXmlString.append("</DocumentRoot>\r\n");
		}
		catch( Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					rset.close();
				}
				if(conn != null)
				{
					conn.close();
				}
			}
			catch( Exception expClrRsc )
			{
				expClrRsc.printStackTrace();
			}
		}
		System.out.println("valueXmlString "+valueXmlString.toString() );
		return valueXmlString.toString();

	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	private String generateTransID( Connection connection, String loginCode ) throws ITMException
	{
		String uniqueKey = null;
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rset = null;

		String tranSer = null;
		String keyString = null;
		String keyCol = null;

		try
		{
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_sub_eval' ";
			//Commented & Below Changes Done By Shahu Mali on 04-10-13
			//stmt = connection.createStatement();
			//rset = stmt.executeQuery( keyStringQuery );
			pstmt = connection.prepareStatement(keyStringQuery);
			rset = pstmt.executeQuery();
			if(rset.next())
			{
				keyString = rset.getString("KEY_STRING");
				keyCol = rset.getString("TRAN_ID_COL");
				tranSer = rset.getString("REF_SER");
			}

			TransIDGenerator tg = new TransIDGenerator("<Root></Root>", loginCode, database);
			uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, connection);
		}
		catch(Exception exp)
		{
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				/*if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}*/
				if(rset != null)
				{
					rset.close();
					rset = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	private HashMap getPrevRemarks(String salesPers,String loginCode,Connection conn)
	{
		HashMap retMap = new HashMap();
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
	//	String sql =	"SELECT SPEC_ID,REMARKS FROM SPRS_APPR_DET "+
		//				"WHERE TRAN_ID=(SELECT TRAN_ID FROM SPRS_APPR WHERE APPR_DATE = ("+
		//				"SELECT MAX(APPR_DATE) FROM SPRS_APPR "+
			//			"WHERE EMP_CODE = ? AND EMP_CODE__BY =? ))";
		String sql =	"SELECT SPEC_ID,REMARKS FROM SPRS_APPR_DET "+
						"WHERE TRAN_ID=(SELECT TRAN_ID FROM SPRS_APPR WHERE APPR_DATE = ("+
						"SELECT MAX(APPR_DATE) FROM SPRS_APPR "+
						"WHERE EMP_CODE = ? ))";
		try
		{
			if (conn != null )
			{
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				//pstmt.setString(2,loginCode);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					retMap.put(rs.getString("SPEC_ID"),rs.getString("REMARKS"));
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}

	return retMap;
	}
	//added by satya on 17/07/10 in order to get previous remarks[WS90NOV053].end
}