package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class StrgSellStk extends ValidatorEJB 
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			BaseLogger.log("3",null,null,"Val xmlString :: " + xmlString );
			BaseLogger.log("3",null,null,"Val xmlString1 :: " + xmlString1 );
			BaseLogger.log("3",null,null,"Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		int ctr = 0;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer(); 

		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
			case 1:

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail1>");

				for( ctr = 0; ctr < childNodeListLength; ctr ++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"childNodeName= "+childNodeName);
					if( childNodeName.equalsIgnoreCase("sc_code") )
					{   
						String scCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sc_code", dom) ).trim();
						BaseLogger.log("3",null,null,"scCode = "+scCode);
						if( scCode == null || scCode.length() <= 0 ) 
						{
							errString = getErrorString("sc_code", "VTPMSSCNL", userId);
							break;
						}
						else
						{
							String scCodeSql =  "SELECT COUNT(1) FROM STRG_CUSTOMER WHERE SC_CODE = ?";
							pstmt=conn.prepareStatement(scCodeSql);
							pstmt.setString(1, scCode);
							rs = pstmt.executeQuery();
							int cnt = 0;
							if( rs.next() ) 
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errString = getErrorString("sc_code", "VTPMSISCNL", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("stan_code") )
					{   
						String stanCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("stan_code", dom) ).trim();
						BaseLogger.log("3",null,null,"stanCode = "+stanCode);
						if( stanCode == null || stanCode.length() <= 0 ) 
						{
							errString = getErrorString("stan_code", "VTPMSOSCNL", userId);
							break;
						}
						else
						{
							String scCodeSql =  "SELECT COUNT(1) FROM STATION WHERE STAN_CODE = ?";
							pstmt=conn.prepareStatement(scCodeSql);
							pstmt.setString(1, stanCode);
							rs = pstmt.executeQuery();
							int cnt = 0;
							if( rs.next() ) 
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errString = getErrorString("stan_code", "VTPMSOSCSD", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("item_code") )
					{   
						String itemCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_code", dom) ).trim();
						BaseLogger.log("3",null,null,"itemCode = "+itemCode);
						if( itemCode == null || itemCode.length() <= 0 ) 
						{
							errString = getErrorString("item_code", "VTPMSIICNL", userId);
							break;
						}
						else
						{
							String scCodeSql = "SELECT COUNT(1) FROM ITEM WHERE ITEM_CODE = ?";
							pstmt=conn.prepareStatement(scCodeSql);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();
							int cnt = 0;
							if( rs.next() ) 
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errString = getErrorString("item_code", "VTPMSIICCD", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("prd_code") )
					{   
						String prdCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("prd_code", dom) ).trim();
						BaseLogger.log("3",null,null,"prdCode = "+prdCode);
						if( prdCode == null || prdCode.length() <= 0 ) 
						{
							errString = getErrorString("prd_code", "VTPMSIPCNL", userId);
							break;
						}
						else 
						{
							String scCodeSql =  "SELECT COUNT(1) FROM PERIOD WHERE CODE = ?";
							pstmt=conn.prepareStatement(scCodeSql);
							pstmt.setString(1, prdCode);
							rs = pstmt.executeQuery();
							int cnt = 0;
							if( rs.next() ) 
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errString = getErrorString("prd_code", "VTPMSIPCCD", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
				}		
			valueXmlString.append("</Detail1>");	
			break;	
		}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{ 
			BaseLogger.log("3",null,null,"xmlString : ["+xmlString +"]");
			dom = parseString(xmlString);
			BaseLogger.log("3",null,null,"xmlString1 : ["+xmlString1 + "]");
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : In StrgSellStk itemChanged : [" + e.getMessage()+"]");
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;

		try 
		{
			conn = getConnection();
			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			BaseLogger.log("3",null,null,"[" + getClass().getSimpleName()+ "] currentFormNo: ["+ currentFormNo +"]" );

			String loginCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println("loginCode " + loginCode );

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			valueXmlString.append("<Detail1>");
			if ( currentColumn.trim().equalsIgnoreCase( "sc_code" ) ) 
			{
				String stanCode = "";
				String scCode = genericUtility.getColumnValue("sc_code", dom);
				
				String sql1 ="SELECT SC_CODE, STAN_CODE FROM STRG_CUSTOMER WHERE SC_CODE = ?";
				
				pstmt = conn.prepareStatement(sql1);
				pstmt.setString(1, scCode);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					stanCode = rs.getString("STAN_CODE");
				}
				valueXmlString.append("<stan_code protect = \"1\"><![CDATA[" + stanCode + "]]></stan_code>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			valueXmlString.append("</Detail1>");
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"Exception : In StrgSellStk itemChanged 22 : ["+ e.getMessage() +"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
					rs.close();
				if(pstmt != null)
					pstmt.close();
				rs = null;
				pstmt = null;
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}

}
