package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SprsSellTarget extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			BaseLogger.log("3",null,null,"Val xmlString :: " + xmlString );
			BaseLogger.log("3",null,null,"Val xmlString1 :: " + xmlString1 );
			BaseLogger.log("3",null,null,"Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		int ctr = 0;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer(); 

		try
		{
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams,"loginCode" );

			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
			case 1:

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail1>");

				for( ctr = 0; ctr < childNodeListLength; ctr ++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"childNodeName= "+childNodeName);
					/*if( childNodeName.equalsIgnoreCase("SALES_PERS") )
					{   
						String salesPers = E12GenericUtility.checkNull( genericUtility.getColumnValue("sales_pers", dom) );
						BaseLogger.log("3",null,null,"salesPers = "+salesPers);

						BaseLogger.log("3",null,null,"salesPers FULl ");
						String salesPersSql =  "SELECT SALES_PERS, SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						pstmt=conn.prepareStatement(salesPersSql);
						pstmt.setString(1, salesPers);
						rs = pstmt.executeQuery();

						if( !rs.next() ) 
						{
							errString = getErrorString("sales_pers", "INVSLSPERS", userId);
							break;
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}*/
					if( childNodeName.equalsIgnoreCase("stan_code__hq") )
					{   
						BaseLogger.log("3",null,null,"stan_code__hq ");
						String stanCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("stan_code__hq", dom) );
						BaseLogger.log("3",null,null,"stanCode = "+stanCode);

						String itemSerSql = "SELECT STAN_CODE FROM STATION WHERE STAN_CODE = ?";
						pstmt=conn.prepareStatement(itemSerSql);
						pstmt.setString(1, stanCode);
						rs = pstmt.executeQuery();

						if( !rs.next() ) 
						{
							errString = getErrorString("stan_code__hq", "VESTACD1", userId);
							break;
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					else if( childNodeName.equalsIgnoreCase("item_ser") )
					{   
						BaseLogger.log("3",null,null,"item_ser ");
						BaseLogger.log("3",null,null,"item_ser userId = "+userId);
						String itemSer = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_ser", dom) );
						BaseLogger.log("3",null,null,"itemSer = "+itemSer);
						String itemSerSql =  "SELECT ITEM_SER FROM ITEMSER WHERE ITEM_SER = ?";
						pstmt=conn.prepareStatement(itemSerSql);
						pstmt.setString(1, itemSer);
						rs = pstmt.executeQuery();

						if( !rs.next() ) 
						{
							errString = getErrorString("item_ser", "WRGITEMSER", userId);
							break;
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					else if( childNodeName.equalsIgnoreCase("prd_code") )
					{   
						String periodCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("prd_code", dom) );
						BaseLogger.log("3",null,null,"periodCode = "+periodCode);

						if( periodCode == null || periodCode.length() <= 0 ) 
						{
							errString = getErrorString("prd_code", "VPATDPRC01", userId);
							break;
						}
						else
						{
							String periodCodeSql = "SELECT CODE FROM PERIOD WHERE CODE = ?";
							pstmt=conn.prepareStatement(periodCodeSql);
							pstmt.setString(1, periodCode);
							rs = pstmt.executeQuery();

							if( !rs.next() ) 
							{
								errString = getErrorString("prd_code", "VTMONATD10", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("product_code") )
					{   
						String productCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("product_code", dom) );
						BaseLogger.log("3",null,null,"productCode = "+productCode);

						if( productCode.length() > 0 )
						{
							String productCodeSql =  "SELECT PRODUCT_CODE,DESCR FROM PRODUCT WHERE PRODUCT_CODE = ?";
							pstmt=conn.prepareStatement(productCodeSql);
							pstmt.setString(1, productCode);
							rs = pstmt.executeQuery();

							if( !rs.next() ) 
							{
								errString = getErrorString("product_code", "VMSPRDCODE", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("item_code") )
					{   
						String itemCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_code", dom) );
						BaseLogger.log("3",null,null,"itemCode = "+itemCode);

						if( itemCode.length() > 0 )
						{
							String itemCodeSql = "SELECT ITEM_CODE, DESCR FROM ITEM WHERE ITEM_CODE = ?";
							pstmt=conn.prepareStatement(itemCodeSql);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();

							if( !rs.next() ) 
							{
								errString = getErrorString("item_code", "INVITM", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("grp_code") )
					{   
						String grpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("grp_code", dom) );
						BaseLogger.log("3",null,null,"itemCode = "+grpCode);
						String grpCodeSql =  "SELECT RTRIM(FLD_VALUE) VALUE, DESCR FROM GENCODES WHERE FLD_NAME='GRP_CODE' AND MOD_NAME='W_ITEM' AND FLD_VALUE = ?";
						pstmt=conn.prepareStatement(grpCodeSql);
						pstmt.setString(1, grpCode);
						rs = pstmt.executeQuery();

						if( !rs.next() ) 
						{
							errString = getErrorString("grp_code", "VMGRPCODE", userId);
							break;
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					else if( childNodeName.equalsIgnoreCase("sgrp_code") )
					{   
						String sgrpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sgrp_code", dom) );
						BaseLogger.log("3",null,null,"sgrpCode = "+sgrpCode);
						String sgrpCodeSql =  "SELECT RTRIM(FLD_VALUE) VALUE,DESCR FROM GENCODES WHERE FLD_NAME='SGRP_CODE' AND FLD_VALUE = ?";
						pstmt=conn.prepareStatement(sgrpCodeSql);
						pstmt.setString(1, sgrpCode);
						rs = pstmt.executeQuery();

						if( !rs.next() ) 
						{
							errString = getErrorString("sgrp_code", "VMSGRPCODE", userId);
							break;
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
				}
				valueXmlString.append("</Detail1>");	
				break;	
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{ 
			BaseLogger.log("3",null,null,"xmlString"+xmlString);
			dom = parseString(xmlString);
			BaseLogger.log("3",null,null,"xmlString1"+xmlString1);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [ItemLot][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		String tranDate="", period = "";
		Connection conn = null;
		String itemDescr="", sprsDescr = "", grpdescr = "", sgrpdescr = "", prdDescr ="", itemSerDescr = "";

		try 
		{
			conn = getConnection();
			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			BaseLogger.log("3",null,null,"[" + getClass().getSimpleName()+ "NOW currentFormNo:" + currentFormNo);
			BaseLogger.log("3",null,null,"IC currentColumn:::::" + currentColumn);

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			System.out.println("Current time of the day using Date - 12 hour format: " + tranDate);

			DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
			period = LocalDate.now().format(formatter);

			String loginCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams,"loginCode" );
			System.out.println("loginCode " + loginCode );

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch (currentFormNo) 
			{
			case 1: 
				valueXmlString.append("<Detail1>");
				BaseLogger.log("3",null,null,"IC CURRENT COLUMN 111 " + currentColumn + "]");

				if ( currentColumn.trim().equalsIgnoreCase("itm_default") )
				{
					valueXmlString.append("<tran_date protect = \"1\"><![CDATA["+ tranDate +"]]></tran_date>");
					/*valueXmlString.append("<sales_pers protect = \"0\"><![CDATA["+ loginCode +"]]></sales_pers>");*/
					/*String spDescr = getSalesPersName( conn, loginCode);
					valueXmlString.append("<sp_name><![CDATA[" + spDescr + "]]></sp_name>");*/

					String stanCodeHQ = getSalesPersStanCode( conn, loginCode);
					System.out.println("stanCodeHQ " + stanCodeHQ );
					valueXmlString.append("<stan_code__hq><![CDATA[" + stanCodeHQ + "]]></stan_code__hq>");

					System.out.println("period " + period );
					valueXmlString.append("<prd_code><![CDATA[" + period + "]]></prd_code>");

					String itemSeries = getItemSeries( conn, loginCode);
					System.out.println("itemSeries " + itemSeries );
					valueXmlString.append("<item_ser><![CDATA[" + itemSeries + "]]></item_ser>");

					itemSerDescr = getItemSeriesDesc( conn, itemSeries );
					System.out.println("itemSerDescr " + itemSerDescr );
					valueXmlString.append("<itemser_descr><![CDATA[" + itemSerDescr + "]]></itemser_descr>");
				}
				/*else if (currentColumn.trim().equalsIgnoreCase("SALES_PERS"))
				{
					String sprsCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sales_pers", dom) );
					BaseLogger.log("3",null,null,"sprsCode = "+sprsCode);
					sprsDescr = getSalesPersName( conn, sprsCode);
					BaseLogger.log("3",null,null,"sprsDescr = "+sprsDescr);
					valueXmlString.append("<sp_name protect = \"1\"><![CDATA["+ sprsDescr +"]]></sp_name>");
				}*/
				else if (currentColumn.trim().equalsIgnoreCase("product_code"))
				{
					String prdCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("product_code", dom) );
					BaseLogger.log("3",null,null,"prdCode = "+prdCode);
					String sql2= "SELECT DESCR FROM PRODUCT WHERE  PRODUCT_CODE = ?";

					System.out.println("IC ==> hello amey 3 "+sql2);
					pstmt = conn.prepareStatement(sql2);
					pstmt.setString(1, prdCode);
					rs = pstmt.executeQuery();
					if(rs.next()) 
					{
						prdDescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<product_descr><![CDATA[" + prdDescr + "]]></product_descr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("ITEM_SER"))
				{
					String itemSeries = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_ser", dom) );
					BaseLogger.log("3",null,null,"itemSeries = "+itemSeries);

					itemSerDescr = getItemSeriesDesc( conn, itemSeries );
					valueXmlString.append("<itemser_descr><![CDATA[" + itemSerDescr + "]]></itemser_descr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("ITEM_CODE"))
				{
					String itemCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_code", dom) );
					BaseLogger.log("3",null,null,"itemCode = "+itemCode);
					String sql2= "SELECT DESCR FROM ITEM WHERE ITEM_CODE = ?";
					pstmt = conn.prepareStatement(sql2);
					pstmt.setString(1, itemCode);
					rs = pstmt.executeQuery();
					if(rs.next()) 
					{
						itemDescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<descr><![CDATA[" + itemDescr + "]]></descr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("GRP_CODE"))
				{
					String grpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("grp_code", dom) );
					BaseLogger.log("3",null,null,"grpCode = "+grpCode);
					String sql3 = "SELECT RTRIM(FLD_VALUE) VALUE, DESCR FROM GENCODES WHERE FLD_NAME='GRP_CODE' AND MOD_NAME='W_ITEM' and FLD_VALUE = ?";
					pstmt = conn.prepareStatement(sql3);
					pstmt.setString(1, grpCode);
					rs = pstmt.executeQuery();
					if(rs.next()) 
					{
						grpdescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<grpcodedescr><![CDATA[" + grpdescr + "]]></grpcodedescr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("SGRP_CODE"))
				{
					String sgrpCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sgrp_code", dom) ).trim();
					BaseLogger.log("3",null,null,"grpCode = "+sgrpCode);
					String sql4 = "SELECT RTRIM(FLD_VALUE) VALUE,DESCR FROM GENCODES WHERE FLD_NAME='SGRP_CODE' and FLD_VALUE = ?";
					pstmt = conn.prepareStatement(sql4);
					pstmt.setString(1, sgrpCode);
					rs = pstmt.executeQuery();
					if(rs.next()) 
					{
						sgrpdescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<sgrpcodedescr><![CDATA[" + sgrpdescr + "]]></sgrpcodedescr>");
				}

				valueXmlString.append("</Detail1>");
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
					rs.close();
				if(pstmt != null)
					pstmt.close();
				rs = null;
				pstmt = null;
				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}

	/*private String getSalesPersName( Connection conn, String sprsCode)
	{
		String sprsDescr  = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String sql1= "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = conn.prepareStatement(sql1);
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				sprsDescr = E12GenericUtility.checkNull(rs.getString("SP_NAME"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception d)
		{
			d.printStackTrace();
		}	
		return sprsDescr;
	}*/
	private String getItemSeries( Connection conn, String sprsCode)
	{
		String itmSer  = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String sql1= "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = conn.prepareStatement(sql1);
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				itmSer = E12GenericUtility.checkNull(rs.getString("ITEM_SER"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception d)
		{
			d.printStackTrace();
		}	
		System.out.println("IC ==> hello itmSer "+itmSer);
		return itmSer;
	}
	private String getItemSeriesDesc( Connection conn, String itemSer)
	{
		String itemSerDescr  = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String sql2= "SELECT ITEM_SER, DESCR FROM ITEMSER WHERE ITEM_SER = ?";
			pstmt = conn.prepareStatement(sql2);
			pstmt.setString(1, itemSer);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				itemSerDescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception d)
		{
			d.printStackTrace();
		}	
		System.out.println("IC ==> hello itemSerDescr "+itemSerDescr);
		return itemSerDescr;
	}
	private String getSalesPersStanCode( Connection conn, String sprsCode)
	{
		String stanCode  = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			String sql1= "SELECT STAN_CODE__HQ FROM employee WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(sql1);
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				stanCode = E12GenericUtility.checkNull(rs.getString("STAN_CODE__HQ"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception d)
		{
			d.printStackTrace();
		}	
		System.out.println("IC ==> hello stanCode "+stanCode);
		return stanCode;
	}
}