/**
Title : SFAPlanParamConf
Date  : 02/02/2017
Author: Samadhan Pawar
Request Id: W16JJOH003
*/
package ibase.webitm.ejb.wsfa.masters;
import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.SignTrans;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.naming.InitialContext;

import org.w3c.dom.Document;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class SFAPlanParamConf extends ActionHandlerEJB implements SFAPlanParamConfLocal,SFAPlanParamConfRemote
{
	public String confirm( String tranId,String xtraParams , String forceFlag ) throws RemoteException,ITMException
	{
		System.out.println("SFAPlanParamConf called.............");
		System.out.println("tranId:"+tranId);
		System.out.println("xtraParams:"+xtraParams);
		System.out.println("forceFlag:"+forceFlag);
		String errString = "";
		String sqlStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rsWfStat = null;

		PreparedStatement pstmtIns = null;
		String insertSql = "";

		Connection conn = null;
		int holidayCnt = 0;
		String empCode = "",paramTable = "",prdCode = "", confirmVal = "";
		Timestamp currDate = null;
		int updCnt = 0;
		String tranIdArr[] = null;
		String processInstanceId = "";
		String entityCode = "";
		SignTrans signTrans = null;
		boolean isConfirmed = false;
		String signTranResult = "";
		String signFor = "";
		int seqCntr = 1;
		Document signTranRes = null;
		String signTranStatus = "";
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{
			conn = getConnection();
			conn.setAutoCommit(false);
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			tranIdArr = tranId.split(":");
			paramTable = tranIdArr[0];
			prdCode = tranIdArr[1];
			confirmVal = "Y";
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			currDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

			sqlStr = "SELECT COUNT(1) FROM SF_PLAN_PARAM WHERE PARAM_TABLE = ? AND PRD_CODE = ? AND CONFIRMED = ?";
			pstmt = conn.prepareStatement( sqlStr );

			pstmt.setString(1, paramTable);
			pstmt.setString(2, prdCode );
			pstmt.setString(3, confirmVal );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				int count = rs.getInt(1);
				if (count > 0)
				{
					isConfirmed = true;
				}
			}
			if(isConfirmed)
			{
				errString = itmDBAccessLocal.getErrorString("","VTWORCONF","");
			}
			else
			{
				sqlStr = "UPDATE SF_PLAN_PARAM SET CONFIRMED = ?, CONF_DATE = ?, EMP_CODE__APRV = ? WHERE PARAM_TABLE = ? AND PRD_CODE = ?";
				pstmt = conn.prepareStatement( sqlStr );

				pstmt.setString(1, confirmVal);
				pstmt.setTimestamp(2, currDate );
				pstmt.setString(3, empCode );
				pstmt.setString(4, paramTable );
				pstmt.setString(5, prdCode );
				updCnt= pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("SFAPlanParamConf : confirm : updCnt => "+updCnt);
				if( updCnt > 0 )
				{
					sqlStr = "SELECT TO_CHAR(PROCESS_ID||':'||INSTANCE_ID||':'||ACTIVITY_ID) AS PROCESS_INSTANCE_ID," +
							"PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT,ENTITY_CODE__INIT,ROLE_CODE__PERF," +
							"ENTITY_CODE__PERF,ROLE_CODE__PERF_ACT, ENTITY_CODE__PERF_ACT,ENTITY_TYPE__PERF_ACT,OBJ_NAME,REF_SER,REF_ID," +
							"STATUS_REMARKS,PREVIOUS_ACTIVITY,SEQ_ID,ERR_STATUS,EVAL_DETAIL,PROCESS_BUSY,WF_ABORT,RETRY_COUNTER,ACT_START_DATE," +
							"ACT_END_DATE,ACTIVITY_DESCR FROM WF_PRC_STATUS WHERE REF_ID = ? AND (WF_ABORT IS NULL OR WF_ABORT = ? )";

					pstmt = conn.prepareStatement( sqlStr );
				//	pstmt.setString(1, tranId);  // commented by rupali on 01/09/17 for solving confrim plan issue
					pstmt.setString(1, paramTable.trim()+":"+prdCode); // added by rupali on 01/09/17 for solving confrim plan issue
					pstmt.setString(2, "N");
					rsWfStat = pstmt.executeQuery();

					insertSql = "Insert into WF_PRC_STATUS (PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT," +
							"ENTITY_CODE__INIT,ROLE_CODE__PERF,ENTITY_CODE__PERF,ROLE_CODE__PERF_ACT,ENTITY_CODE__PERF_ACT," +
							"ENTITY_TYPE__PERF_ACT,OBJ_NAME,REF_SER,REF_ID,STATUS_REMARKS,PREVIOUS_ACTIVITY,SEQ_ID,ERR_STATUS,EVAL_DETAIL," +
							"PROCESS_BUSY,WF_ABORT,RETRY_COUNTER,ACT_START_DATE,ACT_END_DATE,ACTIVITY_DESCR) values " +
							"(?,?,?,?,?,?,?,?," +
							"?,?,?,?,?,?,?,?,?,?,?,?," +
							"?,?,?,?,?,?)";
					pstmtIns = conn.prepareStatement(insertSql);

					if (rsWfStat.next())
					{
						processInstanceId = genericUtility.checkNull(rsWfStat.getString("process_instance_id"));
						pstmtIns.setString(1, rsWfStat.getString("PROCESS_ID"));//	PROCESS_ID            NOT NULL VARCHAR2(20)
						pstmtIns.setInt(2, rsWfStat.getInt("INSTANCE_ID"));//INSTANCE_ID           NOT NULL NUMBER(16)
						pstmtIns.setString(3, rsWfStat.getString("ACTIVITY_ID"));//ACTIVITY_ID           NOT NULL VARCHAR2(20)
						pstmtIns.setInt(4, rsWfStat.getInt("PROCESS_STATUS"));//PROCESS_STATUS                 NUMBER(16)
						pstmtIns.setTimestamp(5, rsWfStat.getTimestamp("STATUS_DATE"));//STATUS_DATE                    DATE
						pstmtIns.setString(6, rsWfStat.getString("ROLE_CODE__INIT"));//ROLE_CODE__INIT                VARCHAR2(10)
						pstmtIns.setString(7, rsWfStat.getString("ENTITY_CODE__INIT"));//ENTITY_CODE__INIT              VARCHAR2(20)
						pstmtIns.setString(8, rsWfStat.getString("ROLE_CODE__PERF"));//ROLE_CODE__PERF                VARCHAR2(10)
						pstmtIns.setString(9, rsWfStat.getString("ENTITY_CODE__PERF"));//ENTITY_CODE__PERF              VARCHAR2(10)
						pstmtIns.setString(10, rsWfStat.getString("ROLE_CODE__PERF_ACT"));//ROLE_CODE__PERF_ACT            VARCHAR2(10)
						pstmtIns.setString(11, rsWfStat.getString("ENTITY_CODE__PERF_ACT"));//ENTITY_CODE__PERF_ACT          VARCHAR2(10)
						pstmtIns.setString(12, rsWfStat.getString("ENTITY_TYPE__PERF_ACT"));//ENTITY_TYPE__PERF_ACT          VARCHAR2(1)
						pstmtIns.setString(13, rsWfStat.getString("OBJ_NAME"));//OBJ_NAME                       VARCHAR2(20)
						pstmtIns.setString(14, rsWfStat.getString("REF_SER"));//REF_SER                        VARCHAR2(6)
						pstmtIns.setString(15, rsWfStat.getString("REF_ID"));//REF_ID                         VARCHAR2(50)
						pstmtIns.setString(16, rsWfStat.getString("STATUS_REMARKS"));//STATUS_REMARKS                 VARCHAR2(2000)
						pstmtIns.setString(17, rsWfStat.getString("PREVIOUS_ACTIVITY"));//PREVIOUS_ACTIVITY              VARCHAR2(20)
						pstmtIns.setInt(18, rsWfStat.getInt("SEQ_ID"));//SEQ_ID                NOT NULL NUMBER(16)
						pstmtIns.setString(19, rsWfStat.getString("ERR_STATUS"));//ERR_STATUS                     VARCHAR2(1)
						pstmtIns.setString(20, rsWfStat.getString("EVAL_DETAIL"));//EVAL_DETAIL                    VARCHAR2(1000)
						pstmtIns.setInt(21, rsWfStat.getInt("PROCESS_BUSY"));//PROCESS_BUSY                   NUMBER(10)
						pstmtIns.setString(22, rsWfStat.getString("WF_ABORT"));//WF_ABORT                       CHAR(1)
						pstmtIns.setInt(23, rsWfStat.getInt("RETRY_COUNTER"));//RETRY_COUNTER                  NUMBER(3)
						pstmtIns.setTimestamp(24, rsWfStat.getTimestamp("ACT_START_DATE"));//ACT_START_DATE                 DATE
						pstmtIns.setTimestamp(25, rsWfStat.getTimestamp("ACT_END_DATE"));//ACT_END_DATE                   DATE
						pstmtIns.setString(26, rsWfStat.getString("ACTIVITY_DESCR"));//ACTIVITY_DESCR                 VARCHAR2(40)
					}
					pstmt.close();
					rsWfStat.close();

					sqlStr = "SELECT ENTITY_CODE FROM USERS WHERE PROFILE_ID = ?";

					pstmt = conn.prepareStatement( sqlStr );
					pstmt.setString(1, getParamValue(conn, "MR_PROFILE_ID", "ALL"));

					rs = pstmt.executeQuery();
					signTrans = new SignTrans();

					String day = new SimpleDateFormat("d").format(currDate);
					String month = new SimpleDateFormat("MMM").format(currDate);
					signFor = day +getDayNumberSuffix(Integer.parseInt(day) )+" "+ month;

					while (rs.next())
					{
						if(seqCntr != 1)
						{
							pstmtIns.setInt(18,seqCntr);
							System.out.println("Insert Result:"+ pstmtIns.executeUpdate());
						}

						entityCode = genericUtility.checkNull(rs.getString("ENTITY_CODE"));
						signTranResult = signTrans.insertSignCtx(processInstanceId+":"+seqCntr, "ADMIN_PLAN", entityCode, "", "ADMIN_PLAN", "Plan notification received on "+signFor, "Planning", "Locality based planning", tranId, "K", conn);
						System.out.println("SFAPlanParamConf : confirm : signTranResult: "+ signTranResult);
						signTranRes = genericUtility.parseString(signTranResult);
						signTranStatus = checkNull(genericUtility.getColumnValue("STATUS", signTranRes));
						System.out.println("SFAPlanParamConf : confirm : signTranStatus:"+signTranStatus);
						if(signTranStatus.trim().equalsIgnoreCase("0"))
						{
							try
							{
								conn.rollback();
							} catch (SQLException e1)
							{
								e1.printStackTrace();
							}
							return itmDBAccessLocal.getErrorString("","VTNOTCONF","");
						}
						seqCntr++;
					}
					errString = itmDBAccessLocal.getErrorString("","VTCONF","");
					conn.commit();
				}
			}

		}
		catch ( Exception e )
		{
			System.out.println("SFAPlanParamConf : confirm => ");
			e.printStackTrace();
			try
			{
				conn.rollback();
			} catch (SQLException e1)
			{
				e1.printStackTrace();
			}
			errString = itmDBAccessLocal.getErrorString("","VTNOTCONF","");
			//throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
				}
				if(pstmtIns != null)
				{
					pstmtIns.close();
				}
				if(rsWfStat != null)
				{
					rsWfStat.close();
				}
				if(rs != null)
				{
					rs.close();
				}
				if(conn != null)
				{
					conn.close();
				}
			}
			catch(Exception closeRsc )
			{
				closeRsc.printStackTrace();
				throw new ITMException(closeRsc);
			}
		}

		return errString;
	}
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			System.out.println("getInitialContext");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :SimpleTransactionEditorServlet :getInitialContext :==>"+itme);
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :SimpleTransactionEditorServlet :getInitialContext :==>"+e);
			throw new ITMException(e);
		}
		return ctx;
	}
	private String getDayNumberSuffix(int day)
	{
	    if (day >= 11 && day <= 13) {
	        return "th";
	    }
	    switch (day % 10) {
	    case 1:
	        return "st";
	    case 2:
	        return "nd";
	    case 3:
	        return "rd";
	    default:
	        return "th";
	    }
	}

	private String getParamValue(Connection conn ,String paramName, String orgUnit) throws ITMException // throws added by kailash on 11-04-18.
	{
    	PreparedStatement pstmt = null;
    	ResultSet rs = null;

    	String parameterVal="N";
    	try
 		{
			String param=" SELECT PARM_VALUE FROM SFAPARM  WHERE ORG_UNIT =? AND ACTIVE='Y' AND PARM_NAME= ? ";

			pstmt = conn.prepareStatement(param);
			pstmt.setString(1,orgUnit);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				parameterVal  = checkNull(rs.getString(1));
			}
			if ( rs != null )
			{
			rs.close();
			rs = null;
			}
			if ( pstmt != null )
			{
			pstmt.close();
			pstmt = null;
			}

			System.out.println("Is isVisitAllowed value is........."+parameterVal);
 		}
    	catch (Exception e)
		{
    		e.printStackTrace();
    		throw new ITMException(e); //added by Kailash on 11-04-2018.
		}

    	finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
			}
		}
    	if(parameterVal.trim().length()==0)
    	{
    		parameterVal = "N";
    	}
    	return parameterVal;
    }
	private String checkNull(String inputVal)
	{
		if (inputVal == null)
		{
			inputVal = "";
		}
		return inputVal;
	}
}



