package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailScheme extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			BaseLogger.log("3",null,null,"Val xmlString :: " + xmlString );
			BaseLogger.log("3",null,null,"Val xmlString1 :: " + xmlString1 );
			BaseLogger.log("3",null,null,"Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "", sql = "";
		int ctr = 0;
		Date lastClaimDateParse = null;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer(); 

		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
			case 1:

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail1>");

				for( ctr = 0; ctr < childNodeListLength; ctr ++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if( childNodeName.equalsIgnoreCase("DESCR") )
					{   
						String descr = checkNull(genericUtility.getColumnValue("descr", dom)).trim();
						String schemeCode = checkNull(genericUtility.getColumnValue("scheme_code", dom)).trim();
						BaseLogger.log("3",null,null,"Retail Scheme descr = "+descr+" and schemeCode = "+schemeCode);
						if(descr == null || descr.length() <= 0) 
						{
							errString = getErrorString("descr", "RETSCHDESC", userId);
							break;
						}
						else
						{
							BaseLogger.log("3",null,null,"Retail Scheme IN esle = "+editFlag);
							if( editFlag != null )
							{
								BaseLogger.log("3",null,null,"Retail Scheme editFlag = "+editFlag);
								if( editFlag.equalsIgnoreCase("A") )
								{
									sql="SELECT DESCR FROM RETAIL_SCHEME WHERE DESCR = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, descr);
									rs = pstmt.executeQuery();
									if( rs.next() ) 
									{
										errString = getErrorString("descr", "RETSCHDESD", userId);
										break;
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
								}
								else if ( editFlag.equalsIgnoreCase("E") )
								{
									String sql2="SELECT DESCR FROM RETAIL_SCHEME WHERE DESCR = ? and scheme_code != ?";
									pstmt = conn.prepareStatement(sql2);
									pstmt.setString(1, descr);
									pstmt.setString(2, schemeCode);
									rs = pstmt.executeQuery();
									if( rs.next() ) 
									{
										errString = getErrorString("descr", "RETSCHDESD", userId);
										break;
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
								}
							}
						}
					}
					else if( childNodeName.equalsIgnoreCase("dlv_mode") )
					{   
						String dlvMode = checkNull(genericUtility.getColumnValue("dlv_mode", dom)).trim();
						BaseLogger.log("3",null,null,"dlvMode = "+dlvMode);
						if(dlvMode == null || dlvMode.length() <= 0) 
						{
							errString = getErrorString("dlv_mode", "RETSCHDLVM", userId);
							break;
						}
					}
					else if( childNodeName.equalsIgnoreCase("EFF_FROM") )
					{   
						String effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom)).trim();
						BaseLogger.log("3",null,null,"effFrom = "+effFrom);
						if(effFrom == null || effFrom.length() <= 0) 
						{
							errString = getErrorString("effFrom", "RETSCHEFEC", userId);
							break;
						}
					}
					else if( childNodeName.equalsIgnoreCase("VALID_UPTO") )
					{   
						String validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom)).trim();
						BaseLogger.log("3",null,null,"validUpto = "+validUpto);
						String effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom)).trim();
						BaseLogger.log("3",null,null,"effFrom = "+effFrom);
						if(validUpto == null || validUpto.length() <= 0) 
						{
							errString = getErrorString("valid_upto", "RETSCHVALD", userId);
							break;
						}
						else
						{
							BaseLogger.log("3",null,null,"else validUpto = "+validUpto);
							SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
							SimpleDateFormat sdf1=new SimpleDateFormat(genericUtility.getDBDateFormat());

							Date dateTo = sdf.parse(validUpto);
							BaseLogger.log("3",null,null,"else dateTo = "+dateTo);
							Date dateFrom = sdf.parse(effFrom);
							BaseLogger.log("3",null,null,"else dateFrom = "+dateFrom);

							if ( ( dateTo.compareTo( getDateObject( sdf.format( new Date() ) ) ) ) < 0 )
							{	
								errString = getErrorString("valid_upto", "RETSCHVLDT", userId);
								break;
							}
							if(dateTo.compareTo(dateFrom) < 0)
							{	
								errString = getErrorString("valid_upto", "RETSCHVLEF", userId);
								break;
							}
						}
					}
					else if( childNodeName.equalsIgnoreCase("scope_data") )
					{   
						String scopeData = checkNull(genericUtility.getColumnValue("scope_data", dom)).trim();
						String scopeBasis = checkNull(genericUtility.getColumnValue("scope_basis", dom)).trim();
						BaseLogger.log("3",null,null,"scopeData = "+scopeData+" scopeBasis = "+scopeBasis);
						if( scopeBasis.length() > 0 || scopeBasis.equalsIgnoreCase("") || scopeBasis != null ) 
						{
							if( scopeData == null || scopeData.length() <= 0 ) 
							{
								errString = getErrorString("scopeData", "RETSCHSCPD", userId);
								break;
							}
						}
					}
					else if( childNodeName.equalsIgnoreCase("class_code__outlet") )
					{   
						String classCodeOutlet = checkNull(genericUtility.getColumnValue("class_code__outlet", dom)).trim();
						BaseLogger.log("3",null,null,"classCodeOutlet = "+classCodeOutlet );
						if( classCodeOutlet.length() > 0 ) 
						{
							if( classCodeOutlet.equalsIgnoreCase("ALL") ) 
							{
								BaseLogger.log("3",null,null,"classCodeOutlet = ALL ="+classCodeOutlet );
								errString = getErrorString("class_code__outlet", "RETSCHCLAS", userId);
								break;
							}
						}
					}
					else if( childNodeName.equalsIgnoreCase("LAST_CLAIM_DATE") )
					{   
						String lastClaimDate = checkNull(genericUtility.getColumnValue("last_claim_date", dom)).trim();
						BaseLogger.log("3",null,null,"lastClaimDate = "+lastClaimDate);
						if(lastClaimDate == null || lastClaimDate.length() <= 0) 
						{
							errString = getErrorString("lastClaimDate", "RETSCHLCLM", userId);
							break;
						}
						//Added by Pooja on 28/06/19 [to check payout date logic] START
						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						lastClaimDateParse = sdf.parse(lastClaimDate);
						//Added by Pooja on 28/06/19 [to check payout date logic] END
					}
					else if( childNodeName.equalsIgnoreCase("payout_date") )
					{   
						String payoutDate = checkNull(genericUtility.getColumnValue("payout_date", dom)).trim();
						BaseLogger.log("3",null,null,"payoutDate  = "+payoutDate );
						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status", dom)).trim();
						BaseLogger.log("3",null,null,"wfStatus = "+wfStatus);

						if(payoutDate == null || payoutDate.length() <= 0) 
						{
							errString = getErrorString("payout_date", "RETSCHPAYD", userId);
							break;
						}
						//Added by Pooja on 28/06/19 [to check payout date logic] START
						else if( payoutDate != null && payoutDate.length() > 0 )
						{
							SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							Date payOutDateParse = sdf.parse( payoutDate );
							if( payOutDateParse.before( lastClaimDateParse ) )
							{
								System.out.print("in the error message payOutDateParse.before(lastClaimDateParse)");
								errString = getErrorString("payout_date", "RETCLMPAY", userId);
							}
						}
						//Added by Pooja on 28/06/19 [to check payout date logic] END
						/*else
						{
							BaseLogger.log("3",null,null,"IN ELSE [payout_date] payoutDate  = "+payoutDate );

							SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
							SimpleDateFormat sdf1=new SimpleDateFormat(genericUtility.getDBDateFormat());

							Object dateTo = sdf.parse(payoutDate);
							BaseLogger.log("3",null,null,"else dateTo = "+dateTo);

							Timestamp s1 = Timestamp.valueOf(sdf1.format(dateTo)+" 00:00:00.0");
							Timestamp s2 = new Timestamp(System.currentTimeMillis());
							BaseLogger.log("3",null,null,"else payout_date s1= "+s1+" and s2 current= "+s2);

							if( s2.after(s1) ) //s1.after(s2)
							{
								if( wfStatus.equalsIgnoreCase("S") )
								{
									BaseLogger.log("3",null,null,"IN IF ...end");
									errString = getErrorString("payout_date", "RETSCHPAYO", userId);
									break;
								}
							}
							else
							{
								BaseLogger.log("3",null,null,"payout_date wfStatus s2.after(s1) ELSE");
							}

						}*/
					}
					else if( childNodeName.equalsIgnoreCase("CONFIRMED") )
					{   
						String confirmed = checkNull(genericUtility.getColumnValue("confirmed", dom)).trim();
						BaseLogger.log("3",null,null,"confirmed = "+confirmed);
						if(confirmed == null || confirmed.length() <= 0) 
						{
							errString = getErrorString("confirmed", "RETSCHCONF", userId);
							break;
						}
					}
					else if( childNodeName.equalsIgnoreCase("wf_status") )
					{   
						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status", dom)).trim();
						BaseLogger.log("3",null,null,"wfStatus = "+wfStatus);
						String lastClaimDate = checkNull(genericUtility.getColumnValue("last_claim_date", dom)).trim();
						BaseLogger.log("3",null,null,"lastClaimDate  = "+lastClaimDate );

						if( wfStatus.length() > 0) 
						{
							SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
							SimpleDateFormat sdf1=new SimpleDateFormat(genericUtility.getDBDateFormat());

							Date dateTo = sdf.parse(lastClaimDate);
							BaseLogger.log("3",null,null,"else dateTo = "+dateTo);

							if ( ( dateTo.compareTo( getDateObject( sdf.format( new Date() ) ) ) ) < 0 )
							{
								BaseLogger.log("3",null,null,"else validUpto dateTo= IN CONDITIONNNN!!! "+dateTo);
								if( wfStatus.equalsIgnoreCase("S") )
								{
									errString = getErrorString("wf_status", "RETSCHWFST", userId);
									break;
								}
							}
							else
							{
								BaseLogger.log("3",null,null,"wfStatus = ELSE");
							}
							if( wfStatus.equalsIgnoreCase("D") )
							{
								errString = getErrorString("wf_status", "SLCTSUBMIT", userId);
								break;
							}
						}
					}
				}//end of for
				valueXmlString.append("</Detail1>");	
				break;	

			case 2: 
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail2>");

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if ( childNodeName.equalsIgnoreCase("ITEM_CODE") ) 
					{
						String itemCode = checkNull(genericUtility.getColumnValue("item_code", dom)).trim();
						BaseLogger.log("3",null,null,"itemCode "+itemCode);
						if( itemCode ==null || itemCode.length() <= 0 ) 
						{
							errString = getErrorString("itemCode", "RETSCHITM", userId);
							break;
						}
						else
						{
							String sql4 = "SELECT ITEM_CODE FROM ITEM WHERE ITEM_CODE = ?";
							pstmt=conn.prepareStatement(sql4);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();

							if( !rs.next() ) 
							{
								errString = getErrorString("itemCode", "RETSCHITN", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if( childNodeName.equalsIgnoreCase("quantity") )
					{   
						String quantity = checkNull(genericUtility.getColumnValue("quantity", dom)).trim();
						BaseLogger.log("3",null,null,"quantity = "+quantity);
						if( quantity == null || quantity.length() <= 0 ) 
						{
							errString = getErrorString("quantity", "RETSCHQTY", userId);
							break;
						}
						else
						{
							int qnty = Integer.parseInt(quantity);
							if( qnty <= 0 )
							{
								errString = getErrorString("quantity", "RETSCHIQTY", userId);
								break;
							}
						}
					}
				}
				valueXmlString.append("</Detail2>");	
				break;		
			}//End of switch
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{ 
			BaseLogger.log("3",null,null,"xmlString"+xmlString);
			dom = parseString(xmlString);
			BaseLogger.log("3",null,null,"xmlString1"+xmlString1);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [ItemLot][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		Node parentNode = null;
		String itemDescr = "",loginEmpCode ="" , itemSer = "",tranDate="";
		String hoLoginCode="";
		String nullVar = "";
		Connection conn = null;
		String outletType = "", outletTypeDescr = "";
		String description="";

		try 
		{
			conn = getConnection();
			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			BaseLogger.log("3",null,null,"[" + getClass().getSimpleName()+ "NOW currentFormNo:" + currentFormNo);
			BaseLogger.log("3",null,null,"IC currentColumn:::::" + currentColumn);

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			System.out.println("Current time of the day using Date - 12 hour format: " + tranDate);

			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams,"loginEmpCode" );
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams,"loginCode" );
			if( loginEmpCode.trim().length() == 0 )
			{
				itemSer = checkNull( getItemSer( userId.trim(), conn ) );
			}
			else
			{
				itemSer = checkNull( getItemSer( loginEmpCode.trim(), conn ) );
			}

			hoLoginCode = getDivisionHO( itemSer.trim(), conn );
			System.out.println("userId: in post save:"+userId+"loginEmpCode: saasd::"+loginEmpCode.trim());
			System.out.println("hoLoginCode hoLoginCode = "+hoLoginCode);

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch (currentFormNo) 
			{
			case 1: 
				BaseLogger.log("3",null,null," case 1 current column"+currentColumn);
				BaseLogger.log("3",null,null,"itemChanged:currentFormNo:" + currentFormNo);
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				//childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				//childNodeListLength = childNodeList.getLength();
				/*do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						childNode.getFirstChild();
					}
					ctr++;
				} 
				while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));*/
				BaseLogger.log("3",null,null,"IC CURRENT COLUMN 111 " + currentColumn + "]");

				if ( currentColumn.trim().equalsIgnoreCase("itm_default") )
				{
					BaseLogger.log("3",null,null,"In item_default() 111");
					valueXmlString.append("<tran_date><![CDATA[" + tranDate  + "]]></tran_date>");
					valueXmlString.append("<confirmed protect = \"1\"><![CDATA[N]]></confirmed>");
					valueXmlString.append("<wf_status protect = \"0\"><![CDATA[D]]></wf_status>");
					valueXmlString.append("<conf_date protect = \"1\"><![CDATA["+ nullVar +"]]></conf_date>");
					valueXmlString.append("<emp_code__aprv protect = \"1\"><![CDATA["+ nullVar +"]]></emp_code__aprv>");
					valueXmlString.append("<emp_code__login protect = \"1\"><![CDATA["+ loginEmpCode.trim() +"]]></emp_code__login>");
					valueXmlString.append("<div_ho_scheme protect = \"1\"><![CDATA["+ hoLoginCode.trim() +"]]></div_ho_scheme>");
					if( hoLoginCode.trim().length() > 0 )
					{
						System.out.println("IN IF =ITM D= > hoLoginCode hoLoginCode = [ "+hoLoginCode+" ]");
						valueXmlString.append("<schem_wrkflw_init protect = \"1\"><![CDATA[Y]]></schem_wrkflw_init>");
					}
					else
					{
						System.out.println("IN ELSE =ITM D= > hoLoginCode hoLoginCode = [ "+hoLoginCode+" ]");
						valueXmlString.append("<schem_wrkflw_init protect = \"1\"><![CDATA[N]]></schem_wrkflw_init>");
					}
					// added by rupali on 12/07/19 for displaying customer type on default item change [start]
					String strgCusType = "";
					String custTypeSql = "SELECT TYPE,SH_DESCR FROM STRG_CUST_TYPE WHERE ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE = ?) " +
							"IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL ) " +
							"ORDER BY TYPE ";
					System.out.println("custTypeSql:::::"+custTypeSql);
					pstmt = conn.prepareStatement(custTypeSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();	
					if(rs.next())
					{
						strgCusType  = rs.getString("TYPE") ==  null ? "" :rs.getString("TYPE");
						outletTypeDescr  = rs.getString("SH_DESCR") ==  null ? "" :rs.getString("SH_DESCR");
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<outlet_type><![CDATA[").append(strgCusType).append("]]></outlet_type>\r\n");
					valueXmlString.append("<outlet_type_descr><![CDATA[").append(outletTypeDescr).append("]]></outlet_type_descr>\r\n");
					// added by rupali on 12/07/19 for displaying customer type on default item change [start]

				}
				else if ( currentColumn.trim().equalsIgnoreCase("itm_defaultedit") )
				{
					tranDate = checkNull(genericUtility.getColumnValue("tran_date", dom)).trim();; 
					outletType = checkNull(genericUtility.getColumnValue("outlet_type", dom)).trim();; 
					valueXmlString.append("<tran_date protect = \"1\"><![CDATA["+ tranDate +"]]></tran_date>");
					valueXmlString.append("<confirmed protect = \"1\"><![CDATA[N]]></confirmed>");
					String wfStatus = checkNull(genericUtility.getColumnValue("wf_status", dom)).trim();
					valueXmlString.append("<wf_status protect = \"0\"><![CDATA["+ wfStatus +"]]></wf_status>");
					valueXmlString.append("<conf_date protect = \"1\"><![CDATA["+ nullVar +"]]></conf_date>");
					valueXmlString.append("<emp_code__aprv protect = \"1\"><![CDATA["+ nullVar +"]]></emp_code__aprv>");
					valueXmlString.append("<emp_code__login protect = \"1\"><![CDATA["+ loginEmpCode.trim() +"]]></emp_code__login>");
					valueXmlString.append("<div_ho_scheme protect = \"1\"><![CDATA["+ hoLoginCode.trim() +"]]></div_ho_scheme>");
					if( hoLoginCode.trim().length() > 0 )
					{
						valueXmlString.append("<schem_wrkflw_init protect = \"1\"><![CDATA[Y]]></schem_wrkflw_init>");
					}
					else
					{
						valueXmlString.append("<schem_wrkflw_init protect = \"1\"><![CDATA[N]]></schem_wrkflw_init>");
					}
					outletTypeDescr = checkNull(getOutetTypeDescr(outletType,conn));
					valueXmlString.append("<outlet_type_descr><![CDATA[").append(outletTypeDescr).append("]]></outlet_type_descr>\r\n");
				}
				//Added by Amey W. [To clear the scope data after change in scope_basis] on 19-06-2019 START
				else if ( currentColumn.trim().equalsIgnoreCase("scope_basis") )
				{
					valueXmlString.append("<scope_data><![CDATA["+ nullVar +"]]></scope_data>");
				}
				else if ( currentColumn.trim().equalsIgnoreCase("outlet_type") )
				{
					outletType = checkNull(genericUtility.getColumnValue("outlet_type", dom)).trim();
					outletTypeDescr = checkNull(getOutetTypeDescr(outletType,conn));
					valueXmlString.append("<outlet_type_descr><![CDATA[").append(outletTypeDescr).append("]]></outlet_type_descr>\r\n");
				}
				//Added by Amey W. [To clear the scope data after change in scope_basis] on 19-06-2019 END
				else if ( currentColumn.trim().equalsIgnoreCase("descr"))
				{
					description=checkNull(genericUtility.getColumnValue("descr",dom));
					if ( currentColumn.trim().equalsIgnoreCase("descr"))
					{
						if(description.length()<20)
						{
							valueXmlString.append("<sh_descr><![CDATA[" ).append(description).append( "]]></sh_descr>\r\n" );
						}
						else
						{
							valueXmlString.append("<sh_descr><![CDATA[" ).append(description.substring(0, 20)).append( "]]></sh_descr>\r\n" );
						}
					}
				}

				valueXmlString.append("</Detail1>");
				break;

			case 2:

				BaseLogger.log("3",null,null,"case 2 current column"+currentColumn);
				BaseLogger.log("3",null,null,"itemChanged:currentFormNo:" + currentFormNo);

				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				//childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail2>");
				//childNodeListLength = childNodeList.getLength();
				/*do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						childNode.getFirstChild();
					}
					ctr++;
				} 
				while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));*/
				BaseLogger.log("3",null,null,"IC CURRENT COLUMN 111 " + currentColumn + "]");

				if (currentColumn.trim().equalsIgnoreCase("ITEM_CODE"))
				{
					String itemCode = checkNull(genericUtility.getColumnValue("item_code", dom)).trim();
					BaseLogger.log("3",null,null,"In item_changed ITEM_CODE itemCode = "+itemCode);
					if( itemCode != null && itemCode.trim().length()!=0 )
					{
						String sql5 = "SELECT ITEM_CODE,DESCR FROM ITEM WHERE ITEM_CODE = ?";
						pstmt=conn.prepareStatement(sql5);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();

						if( rs.next() ) 
						{
							itemDescr = checkNull(rs.getString("descr"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					BaseLogger.log("3",null,null,"Random itemDescr: "+itemDescr );
					valueXmlString.append("<item_descr protect = \"1\"><![CDATA[" + itemDescr + "]]></item_descr>");
				}

				valueXmlString.append("</Detail2>");
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
					rs.close();
				if(pstmt != null)
					pstmt.close();
				rs = null;
				pstmt = null;
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}

	private String checkNull(String input) 
	{
		return input == null ? "" : input.trim();
	}

	private String getItemSer( String empCode, Connection conn ) throws Exception //Gulzar - 17/02/10
	{
		ResultSet rs = null;
		Statement stmt = null;
		String itemSer = "";

		String distanceSql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+empCode+"'";
		try
		{
			stmt = conn.createStatement();
			rs = stmt.executeQuery(distanceSql);
			while(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		return itemSer;
	}

	public String getDivisionHO(String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		System.out.println("In side getDivisionHO............itemSer = "+itemSer+" conn  = "+conn);
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String hoCode="";

		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='SCHEME_DIVISION_HO' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				hoCode  = checkNull(rs.getString(1));
			}
			System.out.println("hoCode:::["+hoCode+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("hoCode..:::=["+hoCode+"]");
		return hoCode.trim();
	}
	public String getOutetTypeDescr(String type,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String shDescr = "";
		try
		{

			String sql  = "SELECT SH_DESCR FROM STRG_CUST_TYPE WHERE TYPE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, type);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				shDescr = checkNull(rs.getString("SH_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("shDescr val:- "+shDescr);
		return shDescr;
	}
}