// created by shweta 12-Jul-2021 
package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;  

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class OrgRoleAssign extends ValidatorEJB
{

	E12GenericUtility genericUtility = new E12GenericUtility();
	//protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		try
		{
			// System.out.println("xmlString ["+xmlString+"]");
			// System.out.println("xmlString1 ["+xmlString1+"]");
			// System.out.println("xmlString2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			// System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			// System.out.println("Exception: OrgRoleAssign: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		// System.out.println("Returning from OrgRoleAssign wfValData");
		return (errString); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws  ITMException
	{
		// System.out.println("Inside the wfValdata:::::::");
		String errString = "";
		Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
	   GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{
			String columnValue = "";

			int currentFormNo = 0;
			String updateFlag = "";
			conn = getConnection();
			conn.setAutoCommit(false);
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			 System.out.println("editFlag::::::"+editFlag);

			switch (currentFormNo)
			{

			case 1:
			{
				NodeList parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
				NodeList childList = parentList.item( 0 ).getChildNodes();
				int noOfChilds = childList.getLength();
				// System.out.println("noOfChilds::::::"+noOfChilds);
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}

					if ("role_code".equalsIgnoreCase(childNodeName) )
					{

						if(childNode.getFirstChild() == null)
						{
							errString = getErrorString("cust_type","NULLROLCOD",userId);
							break;
						}
						else
						{
							int roleCodeCount=0;
							String roleCode=checkNull(genericUtility.getColumnValue("role_code", dom));
							
								String roleCodeSql="SELECT COUNT(*) AS COUNT FROM WF_ROLE WHERE ROLE_PURPOSE ='2' AND ROLE_CODE=? ";
								pstmt=conn.prepareStatement(roleCodeSql);
								pstmt.setString(1, roleCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									roleCodeCount=rs.getInt("COUNT");

								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if (roleCodeCount == 0) 
								{
									errString = getErrorString("role_code", "INVROLECOD", userId); 
									break;
								}
								
								
								if ( editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
								{
									int uniqueCnt=0;
									String orgUnit = checkNull(genericUtility.getColumnValue("org_unit",dom));
									String orgUnitTyp = checkNull(genericUtility.getColumnValue("org_unit_type",dom));

									String uniqueSql="SELECT COUNT(*) AS CNT FROM ORG_ROLE_ASSIGN WHERE ROLE_CODE=? AND ORG_UNIT=? AND ORG_UNIT_TYPE=?";
									pstmt=conn.prepareStatement(uniqueSql);
									pstmt.setString(1, roleCode);
									pstmt.setString(2, orgUnit);
									pstmt.setString(3, orgUnitTyp);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										uniqueCnt=rs.getInt("CNT");

									}
									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									if ( uniqueCnt > 0 )
									{
										errString = getErrorString( "role_code", "UNQPRESENT", userId );
										break;
									}
								}

							
						}
						
					}

					else if("org_unit".equalsIgnoreCase(childNodeName))
					{

						if(childNode.getFirstChild() == null)
						{
							errString = getErrorString("cust_type","NULLORGUNT",userId);
							break;
						}
						else
						{
							int orgUnitCount=0;
							String orgUnit=checkNull(genericUtility.getColumnValue("org_unit", dom));
							String orgUnitType=checkNull(genericUtility.getColumnValue("org_unit_type", dom));
							
							if(orgUnitType.equalsIgnoreCase("I"))
							{
								String orgUnitSql="SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE ITEM_SER =?";
								pstmt=conn.prepareStatement(orgUnitSql);
								pstmt.setString(1, orgUnit);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									orgUnitCount=rs.getInt("COUNT");

								}

								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if (orgUnitCount == 0) 
								{
									errString = getErrorString("org_unit", "INVITEMSER", userId); 
									break;
								}
							}
							else if(orgUnitType.equalsIgnoreCase("S"))
							{
								String orgUnitSiteSql="SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE =?";
								pstmt=conn.prepareStatement(orgUnitSiteSql);
								pstmt.setString(1, orgUnit);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									orgUnitCount=rs.getInt("COUNT");

								}

								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if (orgUnitCount == 0) 
								{
									errString = getErrorString("org_unit", "INVILDSITE", userId); 
									break;
								}


							}
							else if(orgUnitType.equalsIgnoreCase("D"))
							{
								String orgUnitDeptSql="SELECT COUNT(*) AS COUNT FROM DEPARTMENT WHERE DEPT_CODE =?";
								pstmt=conn.prepareStatement(orgUnitDeptSql);
								pstmt.setString(1, orgUnit);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									orgUnitCount=rs.getInt("COUNT");

								}

								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if (orgUnitCount == 0) 
								{
									errString = getErrorString("org_unit", "INVILDDEPT", userId); 
									break;
								}



							}

						
						}
						
					}
					
					else if("entity_code".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() == null && "entity_code".equalsIgnoreCase(childNodeName))
						{
							errString = getErrorString("entity_code","NULLCODEEN",userId);
							break;

						}
						else
						{
							int entityCodeCount=0;

							String entityCode=checkNull(genericUtility.getColumnValue("entity_code", dom));
							String entityCodetype=checkNull(genericUtility.getColumnValue("entity_type", dom));

								if(entityCodetype.equalsIgnoreCase("E"))
								{
									String entityCodeSql="SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE IN "+E12GenericUtility.getFormattedProfileId(entityCode);
									pstmt=conn.prepareStatement(entityCodeSql);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										entityCodeCount=rs.getInt("COUNT");

									}

									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (entityCodeCount == 0) 
									{
										errString = getErrorString("entity_code", "INVIEMPLOY", userId); 
										break;
									}
								}
								else if(entityCodetype.equalsIgnoreCase("S"))
								{
									String entityEmployeeSql="SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS IN"+E12GenericUtility.getFormattedProfileId(entityCode);
									pstmt=conn.prepareStatement(entityEmployeeSql);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										entityCodeCount=rs.getInt("COUNT");

									}

									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (entityCodeCount == 0) 
									{
										errString = getErrorString("entity_code", "INVILDSALE", userId); 
										break;
									}


								}
								else if(entityCodetype.equalsIgnoreCase("U"))
								{
									String entityUserSql="SELECT COUNT(*) AS COUNT FROM USERS WHERE EMP_CODE IN"+E12GenericUtility.getFormattedProfileId(entityCode);
									pstmt=conn.prepareStatement(entityUserSql);
									//	pstmt.setString(1, entityCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										entityCodeCount=rs.getInt("COUNT");

									}

									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (entityCodeCount == 0) 
									{
										errString = getErrorString("entity_code", "INVILDUSER", userId); 
										break;
									}



								}

							
						}
					}
					  else if ("org_unit_visited".equalsIgnoreCase(childNodeName)) 
					  {
                          if (childNode.getFirstChild() == null) 
                          {
                              errString = getErrorString("org_unit_visited", "NULLCODEEN", userId);
                              break;
                          }
                          else
                          {
                        	  String visitedWith = checkNull(genericUtility.getColumnValue("org_unit_visited", dom));
                              String[] temp = visitedWith.split(",");
                              for (int i = 0; i < temp.length; ++i) 
                              {
                            	  String visitTeam = temp[i];
                            	  if (visitTeam.lastIndexOf("(") == -1 || visitTeam.lastIndexOf(")") == -1) 
                            	  {
                            		  errString = getErrorString("visited_with", "INVIEMPLOY", userId);
                            		  return errString;
                            	  }
                            	  else
                            	  {
                                	  int rolCnt = 0;
                                	  String selTeam = checkNull(visitTeam.substring(visitTeam.lastIndexOf("(") + 1, visitTeam.lastIndexOf(")")));
                                	  String entityCodeSql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE  (RELIEVE_DATE IS NULL OR (RELIEVE_DATE+30 >= SYSDATE)) AND EMP_CODE=?";
                                	  pstmt = conn.prepareStatement(entityCodeSql);
                                	  pstmt.setString(1, selTeam);
                                	  rs = pstmt.executeQuery();
                                	  if (rs.next()) 
                                	  {
                                		  rolCnt = rs.getInt("COUNT");
                                	  }
                                	  if (rs != null) {
                                		  rs.close();
                                		  rs = null;
                                	  }
                                	  if (pstmt != null) {
                                		  pstmt.close();
                                		  pstmt = null;
                                	  }
                                	  if (rolCnt == 0) 
                                	  {
                                		  errString = getErrorString("visited_with", "INVIEMPLOY", userId);
                                		  return errString;
                                	  }
                            	  }

                              } 
                          }
                          
                      }

				}
			}
			}
		}
		catch (Exception e)
		{
			System.out.println ( "Exception: ProdcutCreationwfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;

				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;

				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				// System.out.println( "Exception :ProdcutCreationwfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		// System.out.println("xmlString ["+xmlString+"]");
		// System.out.println("xmlString1 ["+xmlString1+"]");
		// System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :ORGROLEASSIGN(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from ORGROLEASSIGN:itemChanged" );
		return errString;
	}
	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String resultString = "";
		String userId = "";
		String chgTerm="";
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		Connection connectionObject = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();


		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			connectionObject = getConnection();
			connectionObject.setAutoCommit(false);
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			// System.out.println("userId::"+userId);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
			// System.out.println("currentFormNo====["+currentFormNo+"]currentColumn======["+currentColumn+"]");

			switch ( currentFormNo )
			{
			case 1:

				valueXmlString.append( "<Detail1 domID='1' >\r\n" );
				/*if("itm_default".equalsIgnoreCase(currentColumn))
				{}
				else*/
				if("itm_defaultedit".equalsIgnoreCase(currentColumn)) 
				{

					// System.out.println("inside the org_unit itm_defaultedit ");
					String orgUnitDecr = "";
					String orgUnit = checkNull(genericUtility.getColumnValue("org_unit", dom));
					String orgUnitType  = checkNull(genericUtility.getColumnValue("org_unit_type", dom));

					// System.out.println(" orgUnit line no 589 ::::["+orgUnit+"]");
					if (orgUnit.length()> 0) 
					{
						// System.out.println("inside the if orgUnit condition line no 593");
						if(orgUnitType.equalsIgnoreCase("I"))
						{
							// System.out.println("inside the if orgUnit I  line no 596");
							String orgUnitSql="SELECT DESCR FROM ITEMSER WHERE ITEM_SER =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount I DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("ItemSer Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}
						else if(orgUnitType.equalsIgnoreCase("S"))
						{
							// System.out.println("inside the if orgUnit I  line no 596");
							String orgUnitSql="SELECT DESCR FROM SITE WHERE SITE_CODE =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount S DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("SITE Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}
						else if(orgUnitType.equalsIgnoreCase("D"))
						{
							// System.out.println("inside the if orgUnit I  line no 596");
							String orgUnitSql="SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount D DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("SITE Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}

					}
				} 
				else if("org_unit".equalsIgnoreCase(currentColumn))
				{
					// System.out.println("inside the org_unit itemchange ");
					String orgUnitDecr = "";
					String orgUnit = checkNull(genericUtility.getColumnValue("org_unit", dom));
					String orgUnitType  = checkNull(genericUtility.getColumnValue("org_unit_type", dom));

					// System.out.println(" orgUnit line no 589 ::::["+orgUnit+"]");
					if (orgUnit.length()> 0) 
					{
						// System.out.println("inside the if orgUnit condition line no 593");
						if(orgUnitType.equalsIgnoreCase("I"))
						{
							// System.out.println("inside the if orgUnit I  line no 596");
							String orgUnitSql="SELECT DESCR FROM ITEMSER WHERE ITEM_SER =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount I DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("ItemSer Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}
						else if(orgUnitType.equalsIgnoreCase("S"))
						{
							// System.out.println("inside the if orgUnit S  line no 596");
							String orgUnitSql="SELECT DESCR FROM SITE WHERE SITE_CODE =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount S DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("SITE Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}
						else if(orgUnitType.equalsIgnoreCase("D"))
						{
							// System.out.println("inside the if orgUnit I  line no 596");
							String orgUnitSql="SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE =?";
							pstmt=connectionObject.prepareStatement(orgUnitSql);
							pstmt.setString(1, orgUnit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								orgUnitDecr=checkNull(rs.getString("DESCR"));

							}
							// System.out.println("inside the orgUnitCount D DESCR ::::: ["+orgUnitDecr+"]");

							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							// System.out.println("SITE Descr["+orgUnitDecr+"]");
							valueXmlString.append("<orgunit_descr><![CDATA[").append(orgUnitDecr).append("]]></orgunit_descr>\r\n");
						}

					}


				}
				else if("entity_code".equalsIgnoreCase(currentColumn))
				{
					// System.out.println("inside the entity_code line no 882");
					String visitedWith="";
					String empCode="";
					String empCodevist = checkNull(genericUtility.getColumnValue("entity_code", dom));
					// System.out.println("inside the entity_code empCodevist line no 710:::::::["+empCodevist );
					String entityType  = checkNull(genericUtility.getColumnValue("entity_type", dom)); 
					// System.out.println("inside the entity_code empCodevist line no 712:::::::["+entityType );
					if(entityType.equalsIgnoreCase("E"))
					{

						// System.out.println("inside the entity_code if employee contition line no 716::::::");
						String sqlEmp="SELECT LTRIM(RTRIM(A.EMP_CODE))  AS EMP_CODE, LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) ||' (' || LTRIM(RTRIM(EMP_CODE)) || ') '  AS VISITEDEMP " + 
								"FROM EMPLOYEE A WHERE EMP_CODE IN "+E12GenericUtility.getFormattedProfileId(empCodevist);
						pstmt =  connectionObject.prepareStatement(sqlEmp);
						//pstmt.setString(1, empCodevist);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							visitedWith= visitedWith+rs.getString("VISITEDEMP")+", ";
							empCode=empCode+rs.getString("EMP_CODE")+", ";


						}

						// System.out.println("inside the entity_code if  line no 725::::::["+visitedWith+"]");
						// System.out.println("inside the entity_code if  line no 725::::::["+empCode+"]");
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}                                          
						/*if(visitedWith.endsWith(", "))
	                    {
							visitedWith = visitedWith.substring(0, visitedWith.length()-2);
	                    } */
						if(empCode.endsWith(", "))
						{
							empCode = empCode.substring(0, empCode.length()-2);
						}

						//valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" );
						valueXmlString.append("<entity_code><![CDATA[" ).append(checkNull(empCode)).append( "]]></entity_code>\r\n" );



					}
					else if(entityType.equalsIgnoreCase("S"))
					{

						// System.out.println("inside the visited_with if employee contition line no 716::::::");
						String sqlEmp="SELECT LTRIM(RTRIM(S.SALES_PERS)) AS EMP_CODE,LTRIM(RTRIM(S.SP_NAME))||' (' || LTRIM(RTRIM(SALES_PERS)) || ') ' "
								+     " AS VISITEDEMP FROM SALES_PERS S WHERE SALES_PERS IN"+E12GenericUtility.getFormattedProfileId(empCodevist);
						pstmt =  connectionObject.prepareStatement(sqlEmp);
						//	pstmt.setString(1, empCodevist);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							visitedWith= visitedWith+rs.getString("VISITEDEMP")+", ";
							empCode=empCode+rs.getString("EMP_CODE")+", ";


						}

						// System.out.println("inside the entity_code if  line no 725::::::["+visitedWith+"]");
						// System.out.println("inside the entity_code if  line no 725::::::["+empCode+"]");
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}                                          
						if(visitedWith.endsWith(", "))
							/*if(visitedWith.endsWith(", "))
			                    {
									visitedWith = visitedWith.substring(0, visitedWith.length()-2);
			                    } */
							if(empCode.endsWith(", "))
							{
								empCode = empCode.substring(0, empCode.length()-2);
							}

						//valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" );
						valueXmlString.append("<entity_code><![CDATA[" ).append(checkNull(empCode)).append( "]]></entity_code>\r\n" );


					}
				}
					else if ("role_code".equalsIgnoreCase(currentColumn)) 
					{
						String roleDescr = "";
						String roleCode = checkNull(genericUtility.getColumnValue("role_code", dom));
						String orgUnitSql2 = "SELECT  DESCR  FROM WF_ROLE  WHERE ROLE_PURPOSE ='2' AND ROLE_CODE=?";
						pstmt = connectionObject.prepareStatement(orgUnitSql2);
						pstmt.setString(1, roleCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							roleDescr = checkNull(rs.getString("DESCR"));
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<wf_role_descr><![CDATA[").append(roleDescr).append("]]></wf_role_descr>\r\n");
					}
					else if (currentColumn.equalsIgnoreCase("org_unit_visited"))
					{
						String sprsCodeWW = "";
						String visitedWith2 = checkNull(genericUtility.getColumnValue("org_unit_visited", dom));
						System.out.println("visitedWith:::: [" + visitedWith2 + "]");
						String workWithCodeList = "";
						if (visitedWith2.indexOf(",") != -1) 
						{
							String[] workwith = visitedWith2.split(",");
							for (int i = 0; i < workwith.length; ++i) 
							{
								String code = workwith[i];
								if (code.lastIndexOf("(") != -1 && code.lastIndexOf(")") != -1) 
								{
									code = code.substring(code.lastIndexOf("(")+1,code.lastIndexOf(")")).trim();
									workWithCodeList = workWithCodeList + code + ",";
								}
							}
							workWithCodeList = workWithCodeList.substring(0, workWithCodeList.lastIndexOf(","));
							sprsCodeWW=workWithCodeList;
						}
						else if (visitedWith2.lastIndexOf("(") != -1 && visitedWith2.lastIndexOf(")") != -1)
						{
							if(visitedWith2.lastIndexOf("(") != -1 && visitedWith2.lastIndexOf(")") != -1)
							{
								String codeSe = visitedWith2.substring(visitedWith2.lastIndexOf("(")+1,visitedWith2.lastIndexOf(")")).trim();
								sprsCodeWW=codeSe;

							}						
						}
						System.out.println("sprsCodeWW:::: [" + sprsCodeWW + "]");
						valueXmlString.append("<entity_code><![CDATA[").append(sprsCodeWW).append("]]></entity_code>\r\n");
					}

					valueXmlString.append("</Detail1>\r\n");
					break;
				}
				valueXmlString.append("</Root>\r\n");
			}
		
		catch(Exception e)
		{
			// System.out.println( "Exception :OrgRoleAssign:itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				} 
			}
			catch(Exception e)
			{
				// System.out.println( "Exception :OrgRoleAssign:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		resultString = valueXmlString.toString();
		// System.out.println("OrgRoleAssign:itemChanged.....::["+resultString+"]");

		return resultString;
	}
	private String checkNull(String input)
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}
	
}
