/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.notification.bean;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.notification.bean.NotifiactionMetadata;
import ibase.webitm.notification.bean.PublishPushNotification;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;

public class IOSNotification
implements PublishPushNotification {
    @Override
    public void publish(NotifiactionMetadata notificationMetadata) throws ITMException {
        try {
            BaseLogger.log("3", null, null, "========111111===============");
            String userMessage = notificationMetadata.getMessage();
            boolean isProductionIOSFile = CommonConstants.isApnsProduction;
            HashMap<String, String> getDeviceAppIdDataMap = notificationMetadata.getDeviceAppIdDataMap();
            String iosNotificationFile = "";
            String certificatePassword = "";
            if (getDeviceAppIdDataMap != null && getDeviceAppIdDataMap.size() > 0) {
                if (getDeviceAppIdDataMap.containsKey("IOS_NOTIFICATION_FILE")) {
                    iosNotificationFile = E12GenericUtility.checkNull((String)getDeviceAppIdDataMap.get("IOS_NOTIFICATION_FILE"));
                }
                if (getDeviceAppIdDataMap.containsKey("APP_CERTIFICATE_PASSWORD")) {
                    certificatePassword = E12GenericUtility.checkNull((String)getDeviceAppIdDataMap.get("APP_CERTIFICATE_PASSWORD"));
                }
                if (getDeviceAppIdDataMap.containsKey("APNS_IS_PRODUCTION")) {
                    isProductionIOSFile = Boolean.parseBoolean(E12GenericUtility.checkNull((String)getDeviceAppIdDataMap.get("APNS_IS_PRODUCTION")));
                }
            }
            iosNotificationFile = iosNotificationFile != null && iosNotificationFile.length() > 0 ? iosNotificationFile : CommonConstants.IOS_NOTIFICATION_FILE;
            BaseLogger.log("3", null, null, "@@@@@ IOSNotification :: publish() : iosNotificationFile[" + iosNotificationFile + "]");
            certificatePassword = certificatePassword != null && certificatePassword.length() > 0 ? certificatePassword : "base123";
            BaseLogger.log("3", null, null, "@@@@@ IOSNotification :: publish() : certificatePassword[" + certificatePassword + "]");
            String userName = notificationMetadata.getUserName();
            String IOS_NOTIFICATION_FILE_PATH = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "device" + File.separator + iosNotificationFile;
            BaseLogger.log("3", null, null, "@@@@@ IOSNotification :: publish() : IOS_NOTIFICATION_FILE_PATH[" + IOS_NOTIFICATION_FILE_PATH + "]");
            HashMap<String, String> getRegisteredIdList = notificationMetadata.getPushDeviceTokenId();
            if (getRegisteredIdList != null) {
                BaseLogger.log("3", null, null, "========222222===============");
                PushNotificationManager pushManager = new PushNotificationManager();
                for (Map.Entry m : getRegisteredIdList.entrySet()) {
                    String userId = (String)m.getKey();
                    String deviceId = (String)m.getValue();
                    BaseLogger.log("3", null, null, "UserId[" + userId + "]---DeviceId[" + deviceId + "]");
                    pushManager.addDevice(userId, deviceId);
                }
                BaseLogger.log("3", null, null, "========3333333===============IOS");
                PushedNotification pushedNotification = null;
                try {
                    pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)IOS_NOTIFICATION_FILE_PATH, certificatePassword, isProductionIOSFile));
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Excetion getting IOS_NOTIFICATION_FILE " + e);
                    e.printStackTrace();
                }
                for (Map.Entry pushNotify : getRegisteredIdList.entrySet()) {
                    String userId = (String)pushNotify.getKey();
                    PushNotificationPayload simplePayLoad = new PushNotificationPayload();
                    simplePayLoad.addAlert(String.valueOf(userName) + " : " + userMessage);
                    simplePayLoad.addCustomDictionary("openTarget", notificationMetadata.getOpenTaget());
                    simplePayLoad.addCustomDictionary("XMLData", notificationMetadata.getXMLData());
                    simplePayLoad.addCustomDictionary("UUID", notificationMetadata.getUuid());
                    simplePayLoad.addSound("default");
                    BaseLogger.log("3", null, null, "@@@@@@@@@ IOSNotification :: publish() : notificationMetadata.getXMLData() : " + notificationMetadata.getXMLData());
                    if (!"".equals(notificationMetadata.getNotificationType()) || notificationMetadata.getNotificationType() != null) {
                        simplePayLoad.addCategory(notificationMetadata.getNotificationType());
                    }
                    pushedNotification = pushManager.sendNotification(pushManager.getDevice(userId), (Payload)simplePayLoad);
                    BaseLogger.log("3", null, null, "***** IOSNotification :: publish() : pushedNotification.toString()[" + pushedNotification.toString() + "]");
                    pushedNotification = null;
                }
            }
            BaseLogger.log("3", null, null, "========444444===============");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
    }
}

