/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class ItemAttributesJB {
    public String getAttributes(String refSer, String refId, String tranId, String itemCode, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.getAttributes()");
        String result = "";
        Connection con = null;
        Statement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String itemType = "";
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = ?";
                pstmt = con.prepareStatement(itemSql);
                pstmt.setString(1, itemCode);
                resultSet = pstmt.executeQuery();
                JSONObject resultObj = new JSONObject();
                ArrayList<String> mandatoryFieldList = new ArrayList<String>();
                if (resultSet.next()) {
                    itemType = resultSet.getString("ITEM_TYPE");
                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() ITEM_TYPE : [" + itemType + "]");
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                CommonDBAccessEJB commonDBAccess = new CommonDBAccessEJB();
                String mandatoryList = E12GenericUtility.checkNull(commonDBAccess.getDBColumnValue("ITEM_TYPE", "MANDATORY_LIST", "WHERE ITEM_TYPE = '" + itemType + "'", userInfo.getTransDB()));
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() mandatoryList : [" + mandatoryList + "]");
                if (mandatoryList != null && !mandatoryList.isEmpty()) {
                    String[] rangeParts;
                    String[] stringArray = rangeParts = mandatoryList.split(",");
                    int n = rangeParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        if (part.contains("-")) {
                            String[] range = part.split("-");
                            int mandatoryMin = Integer.parseInt(range[0].trim());
                            int mandatoryMax = Integer.parseInt(range[1].trim());
                            int i = mandatoryMin;
                            while (i <= mandatoryMax) {
                                String sql = "SELECT PHY_ATTRIB_" + i + " FROM ITEM_TYPE WHERE ITEM_TYPE = ?";
                                pstmt = con.prepareStatement(sql);
                                pstmt.setString(1, itemType);
                                resultSet = pstmt.executeQuery();
                                if (resultSet.next()) {
                                    String value = resultSet.getString(1);
                                    mandatoryFieldList.add(value);
                                }
                                resultSet.close();
                                resultSet = null;
                                pstmt.close();
                                pstmt = null;
                                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() 80 mandatoryFieldList : [" + mandatoryFieldList + "]");
                                ++i;
                            }
                        }
                        ++n2;
                    }
                }
                JSONObject itemAttribObj = new JSONObject();
                if (itemType != null && itemType.length() > 0) {
                    String sql = "SELECT ATTRIB_HEADING, ATTRIB_VALUE, ATTRIB_NO FROM TRANS_ITEM_ATTRIBUTES WHERE REF_SER = ? AND REF_ID = ? AND ITEM_TYPE = ?";
                    pstmt = con.prepareStatement(sql);
                    pstmt.setString(1, refSer);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, itemType);
                    resultSet = pstmt.executeQuery();
                    while (resultSet.next()) {
                        JSONObject itemAttribSubObj = new JSONObject();
                        String attribheading = ItemAttributesJB.checkNull(resultSet.getString("ATTRIB_HEADING"));
                        String attribValue = ItemAttributesJB.checkNull(resultSet.getString("ATTRIB_VALUE"));
                        int attribNo = resultSet.getInt("ATTRIB_NO");
                        if (attribheading == null || "".equals(attribheading)) continue;
                        itemAttribSubObj.put(attribheading, (Object)attribValue);
                        itemAttribObj.put(Integer.toString(attribNo), (Object)itemAttribSubObj);
                    }
                    resultSet.close();
                    resultSet = null;
                    pstmt.close();
                    pstmt = null;
                    if (itemAttribObj.length() == 0) {
                        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                        String startDynAttr = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ITEM_TYPE", "START_DYN_ATTR", "WHERE ITEM_TYPE = '" + itemType + "'", userInfo.getTransDB()));
                        BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() START_DYN_ATTR index : [" + startDynAttr + "]");
                        int startDynamicIndex = 0;
                        if (!"".equals(startDynAttr)) {
                            startDynamicIndex = Integer.valueOf(startDynAttr);
                        }
                        BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() startDynamicIndex : [" + startDynamicIndex + "]");
                        String attriRangeValue = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ITEM_TYPE", "ATTRIB_RANGE_DEF_VAL", "WHERE ITEM_TYPE = '" + itemType + "'", userInfo.getTransDB()));
                        String previousTranId = null;
                        String sqlRefQuery = "SELECT REF_ID FROM TRANS_ITEM_ATTRIBUTES WHERE ITEM_TYPE = ? AND REF_ID LIKE ? GROUP BY REF_ID ORDER BY REF_ID";
                        pstmt = con.prepareStatement(sqlRefQuery);
                        pstmt.setString(1, itemType);
                        pstmt.setString(2, "%" + tranId + "%");
                        resultSet = pstmt.executeQuery();
                        if (resultSet.next()) {
                            previousTranId = resultSet.getString("REF_ID");
                        }
                        resultSet.close();
                        pstmt.close();
                        JSONObject attribJson = new JSONObject();
                        if (previousTranId != null && !previousTranId.isEmpty()) {
                            String sqlAttribQuery = "SELECT ATTRIB_HEADING, ATTRIB_VALUE FROM TRANS_ITEM_ATTRIBUTES WHERE REF_SER = ? AND REF_ID = ? AND ITEM_TYPE = ?";
                            pstmt = con.prepareStatement(sqlAttribQuery);
                            pstmt.setString(1, refSer);
                            pstmt.setString(2, previousTranId);
                            pstmt.setString(3, itemType);
                            resultSet = pstmt.executeQuery();
                            while (resultSet.next()) {
                                String attribHeading = resultSet.getString("ATTRIB_HEADING");
                                String attribValue = resultSet.getString("ATTRIB_VALUE");
                                attribJson.put(attribHeading, (Object)attribValue);
                            }
                            resultSet.close();
                            pstmt.close();
                        }
                        String selectQry = "SELECT ATTRIBUTE.* FROM ITEM_TYPE ATTRIBUTE WHERE ITEM_TYPE = ?";
                        pstmt = con.prepareStatement(selectQry);
                        pstmt.setString(1, itemType);
                        resultSet = pstmt.executeQuery();
                        ResultSetMetaData rsmd = resultSet.getMetaData();
                        int numberOfColumns = rsmd.getColumnCount();
                        if (resultSet.next()) {
                            int colCount = 1;
                            while (colCount <= numberOfColumns) {
                                JSONObject itemAttribSubObj = new JSONObject();
                                String colName = rsmd.getColumnLabel(colCount).toUpperCase();
                                if (colName.startsWith("PHY_ATTRIB_")) {
                                    int lastIndex = colName.lastIndexOf(95);
                                    String lastNumberStr = colName.substring(lastIndex + 1);
                                    int phyAttrbNum = Integer.parseInt(lastNumberStr);
                                    int minRange = 0;
                                    int maxRange = 0;
                                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() attriRangeValue : [" + attriRangeValue + "]");
                                    if (attriRangeValue != null && attriRangeValue.contains("-")) {
                                        String[] attrRangValueArr = attriRangeValue.split("-");
                                        BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() attrRangValueArr : [" + attrRangValueArr + "]");
                                        if (attrRangValueArr.length == 2) {
                                            minRange = Integer.parseInt(attrRangValueArr[0].trim());
                                            maxRange = Integer.parseInt(attrRangValueArr[1].trim());
                                        }
                                    }
                                    if (resultSet.getString(colName) != null && (startDynamicIndex == 0 || startDynamicIndex <= phyAttrbNum)) {
                                        if (phyAttrbNum >= minRange && phyAttrbNum <= maxRange) {
                                            String colValue = resultSet.getString(colName);
                                            String attribValue = attribJson.optString(colValue, "");
                                            itemAttribSubObj.put(colValue, (Object)attribValue);
                                        } else {
                                            itemAttribSubObj.put(resultSet.getString(colName), (Object)"");
                                        }
                                    }
                                    if (itemAttribSubObj.length() > 0) {
                                        itemAttribObj.put(Integer.toString(phyAttrbNum), (Object)itemAttribSubObj);
                                    }
                                }
                                ++colCount;
                            }
                        }
                    }
                }
                TreeMap sortedMap = new TreeMap(itemAttribObj.toMap());
                JSONObject sortedItemAttribObj = new JSONObject(sortedMap);
                resultObj.put("ITEM_ATTRIBUTES_JSON", (Object)sortedItemAttribObj);
                resultObj.put("MANDATORY_FIELD_LIST", mandatoryFieldList);
                result = resultObj.toString();
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() itemAttribObj : [" + result + "]");
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "Exception inside getAttributes[" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
        }
        return result;
    }

    public String getAttributesFormat(String itemCode, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.getAttributesFormat()");
        String result = "";
        Connection con = null;
        Statement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String itemType = "";
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = ?";
                pstmt = con.prepareStatement(itemSql);
                pstmt.setString(1, itemCode);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    itemType = resultSet.getString("ITEM_TYPE");
                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributesFormat() ITEM_TYPE : [" + itemType + "]");
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                JSONObject itemAttribObj = new JSONObject();
                if (itemType != null && itemType.length() > 0) {
                    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                    String startDynAttr = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ITEM_TYPE", "START_DYN_ATTR", "WHERE ITEM_TYPE = '" + itemType + "'", userInfo.getTransDB()));
                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributesFormat() START_DYN_ATTR index : [" + startDynAttr + "]");
                    int startDynamicIndex = 0;
                    if (!"".equals(startDynAttr)) {
                        startDynamicIndex = Integer.valueOf(startDynAttr);
                    }
                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributesFormat() startDynamicIndex : [" + startDynamicIndex + "]");
                    String selectQry = "SELECT ATTRIBUTE.* FROM ITEM_TYPE ATTRIBUTE WHERE ITEM_TYPE = ?";
                    pstmt = con.prepareStatement(selectQry);
                    pstmt.setString(1, itemType);
                    resultSet = pstmt.executeQuery();
                    ResultSetMetaData rsmd = resultSet.getMetaData();
                    int numberOfColumns = rsmd.getColumnCount();
                    if (resultSet.next()) {
                        int colCount = 1;
                        while (colCount <= numberOfColumns) {
                            int lastIndex;
                            String lastNumberStr;
                            String colName = rsmd.getColumnLabel(colCount).toUpperCase();
                            if (colName.startsWith("ATTRIB_FORMAT_") && !(lastNumberStr = colName.substring((lastIndex = colName.lastIndexOf(95)) + 1)).isEmpty()) {
                                int phyAttrbNum = Integer.parseInt(lastNumberStr);
                                String attrName = "PHY_ATTRIB_" + phyAttrbNum;
                                if (resultSet.getString(colName) != null && resultSet.getString(attrName) != null && (startDynamicIndex == 0 || startDynamicIndex <= phyAttrbNum)) {
                                    itemAttribObj.put(resultSet.getString(attrName), (Object)resultSet.getString(colName));
                                }
                            }
                            ++colCount;
                        }
                    }
                }
                result = itemAttribObj.toString();
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributesFormat() itemAttribObj : [" + result + "]");
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributesFormat() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "Exception inside getAttributesFormat[" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
        }
        return result;
    }

    public String saveAttributes(String refSer, String refId, String itemCode, String itemAttributeObj, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.saveAttributes()");
        String result = "";
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        Connection con = null;
        ResultSet resultSet = null;
        Statement pstmt = null;
        int attribNo = 0;
        String attribHeading = "";
        String attribValue = "";
        int selectCount = 0;
        try {
            try {
                String itemType = "";
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = ?";
                pstmt = con.prepareStatement(itemSql);
                pstmt.setString(1, itemCode);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    itemType = E12GenericUtility.checkNull(resultSet.getString("ITEM_TYPE"));
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                if (itemType != null && itemType.length() > 0) {
                    String sqlcount = "SELECT COUNT(*) FROM TRANS_ITEM_ATTRIBUTES WHERE REF_SER = ? AND REF_ID = ? AND ITEM_TYPE = ?";
                    pstmt = con.prepareStatement(sqlcount);
                    pstmt.setString(1, refSer);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, itemType);
                    resultSet = pstmt.executeQuery();
                    if (resultSet.next()) {
                        selectCount = resultSet.getInt(1);
                    }
                    resultSet.close();
                    resultSet = null;
                    pstmt.close();
                    pstmt = null;
                    JSONObject itemAttribObj = new JSONObject(itemAttributeObj);
                    Iterator keys = itemAttribObj.keys();
                    while (keys.hasNext()) {
                        String itemAttribObjKey = (String)keys.next();
                        attribNo = Integer.parseInt(itemAttribObjKey);
                        JSONObject itemAttribSubObj = itemAttribObj.getJSONObject(itemAttribObjKey);
                        Iterator itemAttribSubObjKeys = itemAttribSubObj.keys();
                        while (itemAttribSubObjKeys.hasNext()) {
                            String objKey = (String)itemAttribSubObjKeys.next();
                            if ("FORMAT".equals(objKey) || "FIELDNAME".equals(objKey) || "FIELDVALUE".equals(objKey) || "VALUES".equals(objKey) || "isImage".equals(objKey)) continue;
                            Object objValue = itemAttribSubObj.get(objKey);
                            String valueToSet = "";
                            if (objValue instanceof JSONArray) {
                                JSONArray jsonArray = (JSONArray)objValue;
                                StringBuilder sb = new StringBuilder();
                                int i = 0;
                                while (i < jsonArray.length()) {
                                    sb.append(jsonArray.getString(i));
                                    if (i < jsonArray.length() - 1) {
                                        sb.append(", ");
                                    }
                                    ++i;
                                }
                                valueToSet = sb.toString();
                            } else if (objValue instanceof String) {
                                valueToSet = (String)objValue;
                            }
                            attribHeading = objKey;
                            attribValue = valueToSet;
                            if (selectCount == 0) {
                                String insertSql = "Insert into TRANS_ITEM_ATTRIBUTES (REF_SER, REF_ID, ATTRIB_NO, ATTRIB_HEADING, ATTRIB_VALUE, ITEM_TYPE) values (?,?,?,?,?,?)";
                                pstmt = con.prepareStatement(insertSql);
                                pstmt.setString(1, refSer);
                                pstmt.setString(2, refId);
                                pstmt.setInt(3, attribNo);
                                pstmt.setString(4, attribHeading);
                                pstmt.setString(5, attribValue);
                                pstmt.setString(6, itemType);
                                pstmt.executeUpdate();
                                if (pstmt == null) continue;
                                pstmt.close();
                                pstmt = null;
                                continue;
                            }
                            String sqlUpdate = "UPDATE TRANS_ITEM_ATTRIBUTES SET ATTRIB_HEADING=?, ATTRIB_VALUE=? WHERE REF_SER=? AND REF_ID =? And ATTRIB_NO =?";
                            pstmt = con.prepareStatement(sqlUpdate);
                            pstmt.setString(1, attribHeading);
                            pstmt.setString(2, attribValue);
                            pstmt.setString(3, refSer);
                            pstmt.setString(4, refId);
                            pstmt.setInt(5, attribNo);
                            pstmt.executeUpdate();
                            if (pstmt == null) continue;
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    if (con != null) {
                        con.commit();
                    }
                }
                result = e12GenericUtility.getErrorString("", "VTTRANSUCC", userInfo.getLoginUserId());
            }
            catch (Exception e) {
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "ItemAttributesJB.saveAttributes() Exception :[" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
        }
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.saveAttributes() result: [" + result + "]");
        return result;
    }

    public String updateItemAttributesRefId(String refId, String refSer, String editorId, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.updateItemAttributesRefId() - Start");
        String result = "";
        Connection con = null;
        ResultSet resultSet = null;
        Statement pstmt = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT REF_ID FROM TRANS_ITEM_ATTRIBUTES WHERE REF_ID LIKE ? ORDER BY REF_ID DESC";
                pstmt = con.prepareStatement(itemSql);
                String currentRefId = "id-" + userInfo.getLoginCode() + "-editotid-" + editorId + "-";
                pstmt.setString(1, "%" + currentRefId + "%");
                resultSet = pstmt.executeQuery();
                ArrayList<String> refIdList = new ArrayList<String>();
                String latestRefId = null;
                while (resultSet.next()) {
                    latestRefId = resultSet.getString("REF_ID");
                    if (refIdList == null || refIdList.contains(latestRefId)) continue;
                    refIdList.add(latestRefId);
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", userInfo, null, "ItemAttributesJB.updateItemAttributesRefId() refIdList for update : [" + refIdList + "]");
                if (refIdList.size() > 0) {
                    int i = 0;
                    while (i < refIdList.size()) {
                        String dbRefId = (String)refIdList.get(i);
                        String lineNo = dbRefId.substring(dbRefId.lastIndexOf("-") + 1);
                        String updatedRefId = String.valueOf(refId.trim()) + ":" + lineNo.trim();
                        String updateSql = "UPDATE TRANS_ITEM_ATTRIBUTES SET REF_ID = ? WHERE REF_ID = ?";
                        pstmt = con.prepareStatement(updateSql);
                        pstmt.setString(1, updatedRefId);
                        pstmt.setString(2, dbRefId);
                        int rowsUpdated = pstmt.executeUpdate();
                        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.updateItemAttributesRefId() rowsUpdated : [" + rowsUpdated + "]");
                        pstmt.close();
                        pstmt = null;
                        ++i;
                    }
                    result = "Success";
                    con.commit();
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "ItemAttributesJB.updateItemAttributesRefId() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "ItemAttributesJB.updateItemAttributesRefId() in conn Exception : [" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (con != null) {
                con.close();
                con = null;
            }
        }
        return result;
    }

    public static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input;
    }
}

