/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ibase.ai.entityid.DocumentProcessTrail;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.AuditTrailExtEJB;
import ibase.webitm.ejb.BckgrndProcessEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerWrapperLocal;
import ibase.webitm.ejb.DocumentHandlerWrapperRemote;
import ibase.webitm.ejb.Messages;
import ibase.webitm.servlet.SocialComponentActionServlet;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RepositoryHandler;
import ibase.webitm.utility.TransIDGenerator;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class DocumentHandlerWrapperEJB
implements DocumentHandlerWrapperRemote,
DocumentHandlerWrapperLocal {
    private RepositoryHandler repositoryHandler;
    private String activeContentServiceConn = null;
    private UserInfoBean userInfo = null;
    private String database = "";

    public DocumentHandlerWrapperEJB() {
        BaseLogger.log("2", this.userInfo, null, "DocumentHandlerWrapperEJB Conctructor Called");
    }

    @PostConstruct
    public void ejbCreate() {
        BaseLogger.log("2", this.userInfo, null, "DocumentHandlerWrapperEJB Created");
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void remove() {
        if (this.repositoryHandler != null) {
            this.repositoryHandler.remove();
        }
        this.userInfo = null;
    }

    private void setRepositoryHandler(String fileLoc, UserInfoBean userInfo) throws ITMException, RemoteException {
        this.repositoryHandler = null;
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        fileLoc = E12GenericUtility.checkNull(fileLoc);
        String enterpriseContentMgmt = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("ENTERPRISE", "CONTENT_MGMT", "ENTERPRISE = '" + userInfo.getEnterprise() + "'", userInfo.getTransDB()));
        BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB.setRepositoryHandler() enterpriseContentMgmt \t\t\t  : [" + enterpriseContentMgmt + "]");
        BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB.setRepositoryHandler() fileLoc \t\t\t\t\t\t\t  : [" + fileLoc + "]");
        BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB.setRepositoryHandler() CommonConstants.CONTENT_MGMT \t  : [" + CommonConstants.CONTENT_MGMT + "]");
        BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB.setRepositoryHandler() CommonConstants.contentServicesMap : [" + CommonConstants.contentServicesMap + "]");
        if ((!"".equals(fileLoc) && !"Oracle".equalsIgnoreCase(fileLoc) || "".equals(fileLoc) && !"Oracle".equalsIgnoreCase(enterpriseContentMgmt) || "".equals(fileLoc) && "".equals(enterpriseContentMgmt)) && CommonConstants.CONTENT_MGMT != null && CommonConstants.contentServicesMap != null) {
            String docServerID = "";
            if (userInfo != null) {
                try {
                    docServerID = dbAccessEJB.getDBColumnValue("ENTERPRISE", " DOC_SERVER_ID", "ENTERPRISE  = '" + userInfo.getEnterprise() + "'", userInfo.getTransDB());
                }
                catch (ITMException | RemoteException e) {
                    e.printStackTrace();
                }
            }
            BaseLogger.log("3", userInfo, null, "setRepositoryHandler Repository(CommonConstants.contentServicesMap) gsb [" + CommonConstants.contentServicesMap + "]");
            fileLoc = this.checkNull(fileLoc);
            if (fileLoc.length() == 0) {
                this.activeContentServiceConn = this.checkNull((String)CommonConstants.contentServicesMap.get("active"));
                BaseLogger.log("3", userInfo, null, "activeContentServiceConn gsb [" + this.activeContentServiceConn + "]");
                if (this.activeContentServiceConn.equalsIgnoreCase(docServerID) || "".equalsIgnoreCase(this.checkNull(docServerID))) {
                    fileLoc = this.activeContentServiceConn;
                } else {
                    fileLoc = docServerID;
                    this.activeContentServiceConn = docServerID;
                }
            }
            BaseLogger.log("3", userInfo, null, "fileLoc [" + fileLoc + "]");
            if (fileLoc.length() > 0) {
                HashMap<String, String> contentServiceDetMap = this.getContentServiceCredential(fileLoc, userInfo);
                this.repositoryHandler = new RepositoryHandler(contentServiceDetMap, userInfo);
            }
        }
        BaseLogger.log("3", userInfo, null, "repositoryHandler object created : [" + this.repositoryHandler + "]");
    }

    @Override
    public String getComment(String refSer, String tranID, String transDB) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        Statement mPstmt = null;
        try {
            try {
                int selCount = -1;
                conn = this.getConnection(transDB);
                String selQry = "SELECT COMM_TEXT FROM COMMENTS WHERE REF_SER = '" + refSer + "' AND REF_ID = '" + tranID + "' ORDER BY CHG_DATE DESC";
                BaseLogger.log("3", this.userInfo, null, "selectQry :" + selQry);
                mPstmt = conn.prepareStatement(selQry);
                ResultSet rs = mPstmt.executeQuery();
                String comment = null;
                if (rs.next()) {
                    comment = rs.getString("COMM_TEXT");
                }
                retString = "<Root><Detail><comm_text><![CDATA[" + (comment != null ? comment : "") + "]]></comm_text></Detail></Root>";
                rs.close();
                mPstmt.close();
                mPstmt = null;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", this.userInfo, null, "SQLException :DocumentHandlerEJB :getComment:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB :getComment :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    @Override
    public String getDocumentInfoList(String refSer, String tranID, String refCol, String transDB) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        StringBuffer documentInfoXMLBuff = null;
        String mQuery = null;
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "refCol in docHandler[" + refCol + "]");
                if (refCol == null || "null".equalsIgnoreCase(refCol)) {
                    refCol = "";
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                if (refCol == null || "null".equalsIgnoreCase(refCol) || refCol.trim().length() == 0) {
                    mQuery = "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,DOC_CONTENTS.CHG_DATE,DOC_CONTENTS.CHG_USER, DOC_CONTENTS.ADD_DATE,DOC_CONTENTS.ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, USERS.NAME, DOC_TRANSACTION_LINK.PAGE_INFO, DOC_CONTENTS.FILE_METADATA, DOC_CONTENTS.DOC_META_DATA FROM DOC_TRANSACTION_LINK, DOC_CONTENTS LEFT OUTER JOIN USERS ON USERS.CODE = DOC_CONTENTS.ADD_USER WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' " + "AND REF_ID = '" + tranID + "' " + "ORDER BY DOC_CONTENTS.DOC_ID";
                    BaseLogger.log("3", this.userInfo, null, "mQuery generated inside if :  " + mQuery);
                } else {
                    mQuery = "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,DOC_CONTENTS.CHG_DATE,DOC_CONTENTS.CHG_USER, DOC_CONTENTS.ADD_DATE,DOC_CONTENTS.ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, USERS.NAME, DOC_TRANSACTION_LINK.PAGE_INFO,  DOC_CONTENTS.FILE_METADATA, DOC_CONTENTS.DOC_META_DATA FROM DOC_TRANSACTION_LINK, DOC_CONTENTS LEFT OUTER JOIN USERS ON USERS.CODE = DOC_CONTENTS.ADD_USER WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' " + "AND REF_ID = '" + tranID + "' " + "AND RTRIM(REF_COL) = '" + refCol + "' " + "ORDER BY DOC_CONTENTS.DOC_ID";
                    BaseLogger.log("3", this.userInfo, null, "mQuery generated  inside else : " + mQuery);
                }
                BaseLogger.log("3", this.userInfo, null, "Final query generated : " + mQuery);
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                documentInfoXMLBuff = new StringBuffer();
                documentInfoXMLBuff.append("<Document>");
                while (mRs.next()) {
                    String docId = mRs.getString("DOC_ID");
                    String docName = mRs.getString("DOC_NAME");
                    String docType = mRs.getString("DOC_TYPE");
                    String chgDate = "";
                    String addDate = "";
                    try {
                        chgDate = genericUtility.getValidDateTimeString(mRs.getString("CHG_DATE"), genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateTimeFormat());
                        addDate = genericUtility.getValidDateTimeString(mRs.getString("ADD_DATE"), genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateTimeFormat());
                    }
                    catch (Exception e1) {
                        BaseLogger.log("0", this.userInfo, null, "Exception " + e1.getMessage());
                    }
                    String chgUser = mRs.getString("CHG_USER");
                    String addUser = mRs.getString("ADD_USER");
                    String userChkOut = mRs.getString("USER_ID__CHKOUT");
                    String docTypeAttach = this.checkNull(mRs.getString("DOC_TYPE_ATTACH"));
                    String fileTypeAttach = this.checkNull(mRs.getString("FILE_TYPE_ATTACH"));
                    String addUserName = this.checkNull(mRs.getString("NAME"));
                    String referenceDescription = mRs.getString("REF_DESCR");
                    referenceDescription = this.checkNull(referenceDescription);
                    String deleteFlag = this.checkNull(mRs.getString("DELETE_FLAG"));
                    String pageInfo = this.checkNull(mRs.getString("PAGE_INFO"));
                    String fileMetadata = this.checkNull(mRs.getString("FILE_METADATA"));
                    String docMetaData = this.checkNull(mRs.getString("DOC_META_DATA"));
                    if (docId == null || docId.equalsIgnoreCase("null") || docId.length() == 0) {
                        docId = null;
                    }
                    if (docName == null || docName.equalsIgnoreCase("null") || docName.length() == 0) {
                        docName = null;
                    }
                    if (docType == null || docType.equalsIgnoreCase("null") || docType.length() == 0) {
                        docType = null;
                    }
                    if (chgDate == null || chgDate.equalsIgnoreCase("null") || chgDate.length() == 0) {
                        chgDate = null;
                    }
                    if (chgUser == null || chgUser.equalsIgnoreCase("null") || chgUser.length() == 0) {
                        chgUser = null;
                    }
                    if (addDate == null || addDate.equalsIgnoreCase("null") || addDate.length() == 0) {
                        addDate = null;
                    }
                    if (addUser == null || addUser.equalsIgnoreCase("null") || addUser.length() == 0) {
                        addUser = null;
                    }
                    if (userChkOut == null || userChkOut.equalsIgnoreCase("null") || userChkOut.length() == 0) {
                        userChkOut = null;
                    }
                    if (docTypeAttach.length() == 0) {
                        docTypeAttach = null;
                    }
                    if (fileTypeAttach.length() == 0) {
                        fileTypeAttach = null;
                    }
                    if (addUserName.length() == 0) {
                        addUserName = null;
                    }
                    if (deleteFlag == null || deleteFlag.equalsIgnoreCase("null") || deleteFlag.length() == 0) {
                        deleteFlag = "N";
                    }
                    if (docMetaData == null || docMetaData.equalsIgnoreCase("null") || docMetaData.length() == 0) {
                        docMetaData = null;
                    }
                    documentInfoXMLBuff.append("\n<ID Document_Id='" + docId + "'>");
                    documentInfoXMLBuff.append("<Name><![CDATA[" + docName + "]]></Name>\n");
                    documentInfoXMLBuff.append("<Type><![CDATA[" + docType + "]]></Type>\n");
                    documentInfoXMLBuff.append("<docTypeAttach><![CDATA[" + docTypeAttach + "]]></docTypeAttach>\n");
                    documentInfoXMLBuff.append("<fileTypeAttach><![CDATA[" + fileTypeAttach + "]]></fileTypeAttach>\n");
                    documentInfoXMLBuff.append("<Last_Modified><![CDATA[" + chgDate + "]]></Last_Modified>\n");
                    documentInfoXMLBuff.append("<Modified_By><![CDATA[" + chgUser + "]]></Modified_By>\n");
                    documentInfoXMLBuff.append("<Created_Date><![CDATA[" + addDate + "]]></Created_Date>\n");
                    documentInfoXMLBuff.append("<Created_By><![CDATA[" + addUser + "]]></Created_By>\n");
                    documentInfoXMLBuff.append("<CheckOut><![CDATA[" + userChkOut + "]]></CheckOut>\n");
                    documentInfoXMLBuff.append("<Created_By_Name><![CDATA[" + addUserName + "]]></Created_By_Name>\n");
                    documentInfoXMLBuff.append("<refDescr><![CDATA[" + referenceDescription + "]]></refDescr>\n");
                    documentInfoXMLBuff.append("<DeleteFlag><![CDATA[" + deleteFlag + "]]></DeleteFlag>\n");
                    documentInfoXMLBuff.append("<Page_Info><![CDATA[" + pageInfo + "]]></Page_Info>\n");
                    documentInfoXMLBuff.append("<FileMetadata><![CDATA[" + fileMetadata + "]]></FileMetadata>\n");
                    BaseLogger.log("3", this.userInfo, null, " getDocumentInfoList ::  fileMetadata :" + fileMetadata);
                    documentInfoXMLBuff.append("<docMetaData><![CDATA[" + docMetaData + "]]></docMetaData>\n");
                    documentInfoXMLBuff.append("</ID>");
                }
                documentInfoXMLBuff.append("\n</Document>");
                BaseLogger.log("3", this.userInfo, null, " getDocumentInfoList :: documentInfoXMLBuff :" + documentInfoXMLBuff);
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException: DBAccess: getDocumentInfoList:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getDocumentInfoList:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getElemItemChangeList \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return documentInfoXMLBuff.toString();
    }

    @Override
    public String getMultiDocumentInfoList(String refSer, String tranIDs, String refCol, String transDB) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        StringBuffer documentInfoXMLBuff = null;
        String mQuery = "";
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "refCol in docHandler[" + refCol + "]");
                if (refCol == null || "null".equalsIgnoreCase(refCol)) {
                    refCol = "";
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                String tranId = tranIDs;
                if (tranIDs != null && tranIDs.indexOf(",") != -1) {
                    String[] transactionIDs = tranIDs.split(",");
                    tranId = "";
                    int i = 0;
                    while (i < transactionIDs.length) {
                        tranId = String.valueOf(tranId) + "'" + transactionIDs[i].trim() + "',";
                        ++i;
                    }
                    if (tranId.trim().length() >= 2) {
                        tranId = tranId.substring(1, tranId.trim().length() - 2);
                    }
                }
                BaseLogger.log("3", this.userInfo, null, "tranId [" + tranId + "]");
                mQuery = refCol == null || "null".equalsIgnoreCase(refCol) || refCol.trim().length() == 0 ? "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,CHG_DATE,CHG_USER,ADD_DATE,ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, DOC_CONTENTS.DOC_META_DATA  FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID IN ('" + tranId + "')  ORDER BY DOC_CONTENTS.DOC_ID" : "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,CHG_DATE,CHG_USER,ADD_DATE,ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, DOC_CONTENTS.DOC_META_DATA  FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID IN ('" + tranId + "') AND RTRIM(REF_COL) = '" + refCol + "' ORDER BY DOC_CONTENTS.DOC_ID";
                BaseLogger.log("3", this.userInfo, null, "Final query generated : " + mQuery);
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                documentInfoXMLBuff = new StringBuffer();
                documentInfoXMLBuff.append("<Document>");
                while (mRs.next()) {
                    String docId = mRs.getString("DOC_ID");
                    String docName = mRs.getString("DOC_NAME");
                    String docType = mRs.getString("DOC_TYPE");
                    String chgDate = "";
                    String addDate = "";
                    try {
                        chgDate = genericUtility.getValidDateTimeString(mRs.getDate("CHG_DATE"), genericUtility.getDispDateTimeFormat());
                        addDate = genericUtility.getValidDateTimeString(mRs.getDate("ADD_DATE"), genericUtility.getDispDateTimeFormat());
                    }
                    catch (Exception e1) {
                        BaseLogger.log("0", this.userInfo, null, "Exception " + e1.getMessage());
                    }
                    String chgUser = mRs.getString("CHG_USER");
                    String addUser = mRs.getString("ADD_USER");
                    String userChkOut = mRs.getString("USER_ID__CHKOUT");
                    String docTypeAttach = this.checkNull(mRs.getString("DOC_TYPE_ATTACH"));
                    String fileTypeAttach = this.checkNull(mRs.getString("FILE_TYPE_ATTACH"));
                    String referenceDescription = mRs.getString("REF_DESCR");
                    referenceDescription = this.checkNull(referenceDescription);
                    String deleteFlag = this.checkNull(mRs.getString("DELETE_FLAG"));
                    String docMetaData = this.checkNull(mRs.getString("DOC_META_DATA"));
                    if (docId == null || docId.equalsIgnoreCase("null") || docId.length() == 0) {
                        docId = null;
                    }
                    if (docName == null || docName.equalsIgnoreCase("null") || docName.length() == 0) {
                        docName = null;
                    }
                    if (docType == null || docType.equalsIgnoreCase("null") || docType.length() == 0) {
                        docType = null;
                    }
                    if (chgDate == null || chgDate.equalsIgnoreCase("null") || chgDate.length() == 0) {
                        chgDate = null;
                    }
                    if (chgUser == null || chgUser.equalsIgnoreCase("null") || chgUser.length() == 0) {
                        chgUser = null;
                    }
                    if (addDate == null || addDate.equalsIgnoreCase("null") || addDate.length() == 0) {
                        addDate = null;
                    }
                    if (addUser == null || addUser.equalsIgnoreCase("null") || addUser.length() == 0) {
                        addUser = null;
                    }
                    if (userChkOut == null || userChkOut.equalsIgnoreCase("null") || userChkOut.length() == 0) {
                        userChkOut = null;
                    }
                    if (docTypeAttach.length() == 0) {
                        docTypeAttach = null;
                    }
                    if (fileTypeAttach.length() == 0) {
                        fileTypeAttach = null;
                    }
                    if (deleteFlag == null || deleteFlag.equalsIgnoreCase("null") || deleteFlag.length() == 0) {
                        deleteFlag = "N";
                    }
                    if (docMetaData == null || docMetaData.equalsIgnoreCase("null") || docMetaData.length() == 0) {
                        docMetaData = null;
                    }
                    documentInfoXMLBuff.append("\n<ID Document_Id='" + docId + "'>");
                    documentInfoXMLBuff.append("<Name><![CDATA[" + docName + "]]></Name>\n");
                    documentInfoXMLBuff.append("<Type><![CDATA[" + docType + "]]></Type>\n");
                    documentInfoXMLBuff.append("<docTypeAttach><![CDATA[" + docTypeAttach + "]]></docTypeAttach>\n");
                    documentInfoXMLBuff.append("<fileTypeAttach><![CDATA[" + fileTypeAttach + "]]></fileTypeAttach>\n");
                    documentInfoXMLBuff.append("<Last_Modified><![CDATA[" + chgDate + "]]></Last_Modified>\n");
                    documentInfoXMLBuff.append("<Modified_By><![CDATA[" + chgUser + "]]></Modified_By>\n");
                    documentInfoXMLBuff.append("<Created_Date><![CDATA[" + addDate + "]]></Created_Date>\n");
                    documentInfoXMLBuff.append("<Created_By><![CDATA[" + addUser + "]]></Created_By>\n");
                    documentInfoXMLBuff.append("<CheckOut><![CDATA[" + userChkOut + "]]></CheckOut>\n");
                    documentInfoXMLBuff.append("<refDescr><![CDATA[" + referenceDescription + "]]></refDescr>\n");
                    documentInfoXMLBuff.append("<DeleteFlag><![CDATA[" + deleteFlag + "]]></DeleteFlag>\n");
                    documentInfoXMLBuff.append("<docMetaData><![CDATA[" + docMetaData + "]]></docMetaData>\n");
                    documentInfoXMLBuff.append("</ID>");
                }
                documentInfoXMLBuff.append("\n</Document>");
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException: DBAccess: getMultiDocumentInfoList:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getMultiDocumentInfoList:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getMultiDocumentInfoList \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return documentInfoXMLBuff.toString();
    }

    public String getMultiDocumentInfoListJSON(String refSer, String tranIDs, String refCol, String transDB) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        String mQuery = "";
        JSONObject rootJsonObject = new JSONObject();
        JSONArray documentInfoJSONArr = new JSONArray();
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "refCol in docHandler[" + refCol + "]");
                if (refCol == null || "null".equalsIgnoreCase(refCol)) {
                    refCol = "";
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                String tranId = tranIDs;
                if (tranIDs != null && tranIDs.indexOf(",") != -1) {
                    List<String> transactionIDs = Arrays.asList(tranIDs.split(","));
                    tranId = String.join((CharSequence)",", (CharSequence[])transactionIDs.stream().map(id -> "'" + id.trim() + "'").toArray(String[]::new));
                }
                BaseLogger.log("3", this.userInfo, null, "tranId [" + tranId + "]");
                mQuery = refCol.isEmpty() ? "SELECT DOC_CONTENTS.DOC_ID, DOC_NAME, DOC_CONTENTS.DOC_TYPE, CHG_DATE, CHG_USER, ADD_DATE, ADD_USER, USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, DOC_CONTENTS.DOC_META_DATA FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID IN (" + tranId + ") ORDER BY DOC_CONTENTS.DOC_ID" : "SELECT DOC_CONTENTS.DOC_ID, DOC_NAME, DOC_CONTENTS.DOC_TYPE, CHG_DATE, CHG_USER, ADD_DATE, ADD_USER, USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, DOC_CONTENTS.DOC_META_DATA FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID IN (" + tranId + ") AND RTRIM(REF_COL) = '" + refCol + "' ORDER BY DOC_CONTENTS.DOC_ID";
                BaseLogger.log("3", this.userInfo, null, "Final query generated : " + mQuery);
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                while (mRs.next()) {
                    JSONObject docJson = new JSONObject();
                    String docId = this.checkNull(mRs.getString("DOC_ID"));
                    String docName = this.checkNull(mRs.getString("DOC_NAME"));
                    String docType = this.checkNull(mRs.getString("DOC_TYPE"));
                    String chgDate = this.checkNull(genericUtility.getValidDateTimeString(mRs.getDate("CHG_DATE"), genericUtility.getDispDateTimeFormat()));
                    String addDate = this.checkNull(genericUtility.getValidDateTimeString(mRs.getDate("ADD_DATE"), genericUtility.getDispDateTimeFormat()));
                    String chgUser = this.checkNull(mRs.getString("CHG_USER"));
                    String addUser = this.checkNull(mRs.getString("ADD_USER"));
                    String userChkOut = this.checkNull(mRs.getString("USER_ID__CHKOUT"));
                    String docTypeAttach = this.checkNull(mRs.getString("DOC_TYPE_ATTACH"));
                    String fileTypeAttach = this.checkNull(mRs.getString("FILE_TYPE_ATTACH"));
                    String referenceDescription = this.checkNull(mRs.getString("REF_DESCR"));
                    String deleteFlag = this.checkNull(mRs.getString("DELETE_FLAG"));
                    String docMetaData = this.checkNull(mRs.getString("DOC_META_DATA"));
                    docJson.put("Document_Id", (Object)docId);
                    docJson.put("Name", (Object)docName);
                    docJson.put("Type", (Object)docType);
                    docJson.put("Last_Modified", (Object)chgDate);
                    docJson.put("Modified_By", (Object)chgUser);
                    docJson.put("Created_Date", (Object)addDate);
                    docJson.put("Created_By", (Object)addUser);
                    docJson.put("CheckOut", (Object)userChkOut);
                    docJson.put("docTypeAttach", (Object)docTypeAttach);
                    docJson.put("fileTypeAttach", (Object)fileTypeAttach);
                    docJson.put("refDescr", (Object)referenceDescription);
                    docJson.put("DeleteFlag", (Object)deleteFlag);
                    docJson.put("docMetaData", (Object)docMetaData);
                    documentInfoJSONArr.put((Object)docJson);
                }
                rootJsonObject.put("Documents", (Object)documentInfoJSONArr);
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException: DBAccess: getMultiDocumentInfoList:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getMultiDocumentInfoList:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getMultiDocumentInfoList \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return documentInfoJSONArr.toString();
    }

    public String getDocumentInfoListJSON(String refSer, String tranID, String refCol, String transDB) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        JsonObject rootJsonObject = new JsonObject();
        JsonArray documentArray = new JsonArray();
        String mQuery = null;
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "refCol in docHandler[" + refCol + "]");
                if (refCol == null || "null".equalsIgnoreCase(refCol)) {
                    refCol = "";
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                if (refCol == null || "null".equalsIgnoreCase(refCol) || refCol.trim().length() == 0) {
                    mQuery = "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,DOC_CONTENTS.CHG_DATE,DOC_CONTENTS.CHG_USER, DOC_CONTENTS.ADD_DATE,DOC_CONTENTS.ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, USERS.NAME, DOC_TRANSACTION_LINK.PAGE_INFO, DOC_CONTENTS.FILE_METADATA, DOC_CONTENTS.DOC_META_DATA FROM DOC_TRANSACTION_LINK, DOC_CONTENTS LEFT OUTER JOIN USERS ON USERS.CODE = DOC_CONTENTS.ADD_USER WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' " + "AND REF_ID = '" + tranID + "' " + "ORDER BY DOC_CONTENTS.DOC_ID";
                    BaseLogger.log("3", this.userInfo, null, "mQuery generated inside if :  " + mQuery);
                } else {
                    mQuery = "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_CONTENTS.DOC_TYPE,DOC_CONTENTS.CHG_DATE,DOC_CONTENTS.CHG_USER, DOC_CONTENTS.ADD_DATE,DOC_CONTENTS.ADD_USER,USER_ID__CHKOUT, DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH, DOC_TRANSACTION_LINK.REF_DESCR, DOC_TRANSACTION_LINK.DELETE_FLAG, USERS.NAME, DOC_TRANSACTION_LINK.PAGE_INFO,  DOC_CONTENTS.FILE_METADATA, DOC_CONTENTS.DOC_META_DATA FROM DOC_TRANSACTION_LINK, DOC_CONTENTS LEFT OUTER JOIN USERS ON USERS.CODE = DOC_CONTENTS.ADD_USER WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' " + "AND REF_ID = '" + tranID + "' " + "AND RTRIM(REF_COL) = '" + refCol + "' " + "ORDER BY DOC_CONTENTS.DOC_ID";
                    BaseLogger.log("3", this.userInfo, null, "mQuery generated  inside else : " + mQuery);
                }
                BaseLogger.log("3", this.userInfo, null, "Final query generated : " + mQuery);
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                while (mRs.next()) {
                    JsonObject documentInfoJson = new JsonObject();
                    String docId = mRs.getString("DOC_ID");
                    documentInfoJson.addProperty("Document_Id", docId);
                    documentInfoJson.addProperty("Name", mRs.getString("DOC_NAME"));
                    documentInfoJson.addProperty("Type", mRs.getString("DOC_TYPE"));
                    String chgDate = "";
                    String addDate = "";
                    try {
                        chgDate = genericUtility.getValidDateTimeString(mRs.getString("CHG_DATE"), genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateTimeFormat());
                        addDate = genericUtility.getValidDateTimeString(mRs.getString("ADD_DATE"), genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateTimeFormat());
                    }
                    catch (Exception e1) {
                        BaseLogger.log("0", this.userInfo, null, "Exception " + e1.getMessage());
                    }
                    documentInfoJson.addProperty("Last_Modified", chgDate);
                    documentInfoJson.addProperty("Modified_By", mRs.getString("CHG_USER"));
                    documentInfoJson.addProperty("Created_Date", addDate);
                    documentInfoJson.addProperty("Created_By", mRs.getString("ADD_USER"));
                    documentInfoJson.addProperty("CheckOut", mRs.getString("USER_ID__CHKOUT"));
                    documentInfoJson.addProperty("docTypeAttach", this.checkNull(mRs.getString("DOC_TYPE_ATTACH")));
                    documentInfoJson.addProperty("fileTypeAttach", this.checkNull(mRs.getString("FILE_TYPE_ATTACH")));
                    documentInfoJson.addProperty("Created_By_Name", this.checkNull(mRs.getString("NAME")));
                    documentInfoJson.addProperty("refDescr", this.checkNull(mRs.getString("REF_DESCR")));
                    documentInfoJson.addProperty("DeleteFlag", this.checkNull(mRs.getString("DELETE_FLAG")));
                    documentInfoJson.addProperty("Page_Info", this.checkNull(mRs.getString("PAGE_INFO")));
                    documentInfoJson.addProperty("FileMetadata", this.checkNull(mRs.getString("FILE_METADATA")));
                    documentInfoJson.addProperty("docMetaData", this.checkNull(mRs.getString("DOC_META_DATA")));
                    documentArray.add((JsonElement)documentInfoJson);
                }
                rootJsonObject.add("Documents", (JsonElement)documentArray);
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException: DBAccess: getDocumentInfoListAsJson:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getDocumentInfoListAsJson:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception: DBAccess: getDocumentInfoListAsJson \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return rootJsonObject.toString();
    }

    @Override
    public String saveComment(String refSer, String tranID, String commentText, String userCode, String transDB) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        Statement mPstmt = null;
        try {
            try {
                int selCount = -1;
                conn = this.getConnection(transDB);
                String selectQry = "SELECT COUNT(*) FROM COMMENTS WHERE REF_SER= '" + refSer + "' AND REF_ID = '" + tranID + "'";
                BaseLogger.log("3", this.userInfo, null, "selectQry :" + selectQry);
                mPstmt = conn.prepareStatement(selectQry);
                ResultSet rs = mPstmt.executeQuery();
                if (rs.next()) {
                    selCount = rs.getInt(1);
                    BaseLogger.log("3", this.userInfo, null, "Total record found :" + selCount + ":");
                }
                rs.close();
                mPstmt.close();
                mPstmt = null;
                if (selCount > 0) {
                    String updateQry = "UPDATE COMMENTS SET COMM_TEXT = '" + commentText + "' WHERE REF_SER = '" + refSer + "' AND REF_ID = '" + tranID + "'";
                    mPstmt = conn.prepareStatement(updateQry);
                    int noOfRows = mPstmt.executeUpdate();
                    mPstmt.close();
                    mPstmt = null;
                    BaseLogger.log("3", this.userInfo, null, "...ROWS UPDATED...=>" + noOfRows);
                    conn.commit();
                } else {
                    BaseLogger.log("3", this.userInfo, null, "...before ROW INSERTED...=>");
                    String insertQry = "INSERT INTO COMMENTS(REF_SER,REF_ID,COMM_TEXT,CHG_USER,CHG_DATE,CHG_TERM) VALUES(?, ?, ?, ?, ?, ?)";
                    mPstmt = conn.prepareStatement(insertQry);
                    mPstmt.setString(1, refSer);
                    mPstmt.setString(2, tranID);
                    mPstmt.setString(3, commentText);
                    mPstmt.setString(4, userCode);
                    mPstmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    mPstmt.setString(6, "SYSTEM");
                    int noOfRows = mPstmt.executeUpdate();
                    mPstmt.close();
                    mPstmt = null;
                    BaseLogger.log("3", this.userInfo, null, "...ROW INSERTED...=>" + noOfRows);
                    conn.commit();
                }
                retString = "<Root><Detail>Success</Detail></Root>";
            }
            catch (SQLException ie) {
                BaseLogger.log("0", this.userInfo, null, "SQLException :DocumentHandlerEJB :saveComment:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB :saveComment :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private boolean isFileInRepository(String docId, Connection conn) throws SQLException {
        boolean isFileLocFound;
        String file_loc;
        block10: {
            file_loc = "";
            PreparedStatement mPstmt = null;
            ResultSet rs = null;
            isFileLocFound = false;
            String sql = "SELECT FILE_LOC FROM DOC_TRANSACTION_LINK WHERE DOC_ID =?";
            try {
                try {
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, docId);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        file_loc = rs.getString("FILE_LOC");
                    }
                    BaseLogger.log("3", this.userInfo, null, "Inside isFileInRepository : value of file_loc => [ " + file_loc + " ] ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rs != null) {
                        rs.close();
                    }
                    mPstmt.close();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    rs.close();
                }
                mPstmt.close();
                throw throwable;
            }
            if (rs != null) {
                rs.close();
            }
            mPstmt.close();
        }
        if ("Alfresco".equalsIgnoreCase(file_loc)) {
            isFileLocFound = true;
        }
        BaseLogger.log("2", this.userInfo, null, "Returning isFileLocFound [ " + isFileLocFound + " ]");
        return isFileLocFound;
    }

    private String getCmsPath(String objName, Connection conn) {
        String cmsPath;
        block18: {
            cmsPath = "";
            PreparedStatement mPstmt = null;
            ResultSet rs = null;
            String sql = "SELECT CMS_PATH FROM DOC_FOLDER WHERE OBJ_NAME = ? ";
            try {
                try {
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, objName);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        cmsPath = rs.getString("CMS_PATH");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", this.userInfo, null, "cms path for obj name is [ " + cmsPath + " ] ");
        return cmsPath;
    }

    @Override
    public byte[] getDocument(String docId, UserInfoBean userInfo) throws RemoteException, ITMException {
        String transDB = "";
        if (userInfo != null) {
            transDB = userInfo.getTransDB();
        }
        return this.getDocument(docId, transDB, userInfo);
    }

    @Override
    public byte[] getDocument(String docId, UserInfoBean userInfo, String module) throws RemoteException, ITMException {
        String transDB = "";
        if (userInfo != null) {
            transDB = userInfo.getTransDB();
        }
        return this.getDocument(docId, transDB, userInfo, module);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getDocument(String docId, String transDB, UserInfoBean userInfo, String module) throws RemoteException, ITMException {
        InputStream documentInputStream = null;
        byte[] result = null;
        try {
            try {
                documentInputStream = this.getDocumentInputStream(docId, transDB, userInfo, module);
                InputStreamReader reader = new InputStreamReader(documentInputStream, "ISO-8859-1");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int readed = -1;
                while ((readed = reader.read()) != -1) {
                    baos.write(readed);
                }
                result = baos.toByteArray();
                return result;
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                if (documentInputStream == null) return result;
                try {
                    documentInputStream.close();
                    return result;
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                return result;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                if (documentInputStream == null) return result;
                try {
                    documentInputStream.close();
                    return result;
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
                return result;
            }
        }
        finally {
            if (documentInputStream != null) {
                try {
                    documentInputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public InputStream getDocumentInputStream(String docId, String transDB, UserInfoBean userInfo, String module) throws RemoteException, ITMException {
        return this.getDocumentInputStream(docId, transDB, userInfo, module, "DTL");
    }

    @Override
    public InputStream getDocumentInputStream(String docId, String transDB, UserInfoBean userInfo, String module, String targetLinkTable) throws RemoteException, ITMException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String refSer = null;
        String refId = null;
        String docUuid = null;
        InputStream documentInputStream = null;
        int docObjectLength = 0;
        try {
            try {
                conn = this.getConnection(transDB);
                String documentPath = "";
                String dmsTenant = "";
                String fileLoc = "";
                Map<String, String> alfrescoFileDetailMap = this.getAlfrescoFileDetailMap(targetLinkTable, docId, userInfo.getLoginCode(), conn);
                if (alfrescoFileDetailMap == null && targetLinkTable == null) {
                    alfrescoFileDetailMap = this.getAlfrescoFileDetailMap("UDC", docId, userInfo.getLoginCode(), conn);
                }
                BaseLogger.log("3", userInfo, null, "alfrescoFileDetailMap [" + alfrescoFileDetailMap + "]");
                if (alfrescoFileDetailMap != null && alfrescoFileDetailMap.size() > 0) {
                    fileLoc = alfrescoFileDetailMap.get("FILE_LOC");
                    refId = alfrescoFileDetailMap.get("REF_ID");
                    refSer = alfrescoFileDetailMap.get("REF_SER");
                    docUuid = alfrescoFileDetailMap.get("DOC_UUID");
                    documentPath = alfrescoFileDetailMap.get("DOCUMENT_PATH");
                    dmsTenant = alfrescoFileDetailMap.get("DMS_TENANT");
                }
                String enterprise = userInfo.getEnterprise();
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                fileLoc = E12GenericUtility.checkNull(fileLoc);
                String enterpriseContentMgmt = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("ENTERPRISE", "CONTENT_MGMT", "ENTERPRISE = '" + userInfo.getEnterprise() + "'", userInfo.getTransDB()));
                if (CommonConstants.CONTENT_MGMT != null && CommonConstants.contentServicesMap != null && !"Oracle".equalsIgnoreCase(fileLoc) && !"Oracle".equalsIgnoreCase(enterpriseContentMgmt)) {
                    BaseLogger.log("3", userInfo, null, "fileLoc [" + fileLoc + "]");
                    this.setRepositoryHandler(fileLoc, userInfo);
                    if (this.repositoryHandler != null) {
                        documentInputStream = this.repositoryHandler.getFileStream(refSer, docId, refId, docUuid, enterprise, module, documentPath, dmsTenant);
                        docObjectLength = documentInputStream.available();
                    } else {
                        BaseLogger.log("3", userInfo, null, "Error while downloading file : unable to find DMS Server.");
                    }
                } else {
                    BaseLogger.log("3", userInfo, null, "Downloading file from DBMS for [ " + docId + "]");
                    String selQry = "SELECT (case when LENGTH(DOC_OBJECT) is null then 0 else LENGTH(DOC_OBJECT) end ) AS LEN, DOC_OBJECT FROM DOC_CONTENTS WHERE DOC_ID = ?";
                    BaseLogger.log("3", userInfo, null, "selectQry :" + selQry);
                    preparedStatement = conn.prepareStatement(selQry);
                    preparedStatement.setString(1, docId);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        docObjectLength = Integer.parseInt(resultSet.getString("LEN"));
                        documentInputStream = resultSet.getBinaryStream("DOC_OBJECT");
                    }
                }
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerEJB :getDocument:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerEJB :getDocument :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (documentInputStream == null) {
                    this.closeObject(resultSet);
                    this.closeObject(preparedStatement);
                    this.closeObject(conn);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (documentInputStream == null) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                this.closeObject(conn);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.wrapInputStream(documentInputStream, docObjectLength, conn, resultSet, preparedStatement);
    }

    private Map<String, String> getAlfrescoFileDetailMap(String targetLinkTable, String documentId, String userId, Connection connection) throws Exception {
        if ("UDC".equalsIgnoreCase(targetLinkTable)) {
            return this.getAlfrescoFileDetailMapUDC(documentId, userId, connection);
        }
        return this.getAlfrescoFileDetailMapDTL(documentId, connection);
    }

    private Map<String, String> getAlfrescoFileDetailMapDTL(String documentId, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, String> alfreskoFileDetailMap = null;
        try {
            String sqlQuery = "SELECT FILE_LOC, REF_ID, REF_SER, DOC_UUID, DOCUMENT_PATH, DMS_TENANT FROM DOC_TRANSACTION_LINK WHERE DOC_ID = ?";
            BaseLogger.log("3", this.userInfo, null, "selectQry :" + sqlQuery);
            preparedStatement = connection.prepareStatement(sqlQuery);
            preparedStatement.setString(1, documentId);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSet.next()) {
                alfreskoFileDetailMap = new HashMap<String, String>();
                int columnCount = resultSetMetaData.getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    String columnName = resultSetMetaData.getColumnLabel(i);
                    alfreskoFileDetailMap.put(columnName, resultSet.getString(columnName));
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alfreskoFileDetailMap;
    }

    private Map<String, String> getAlfrescoFileDetailMapUDC(String documentId, String userId, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, String> alfreskoFileDetailMap = null;
        try {
            String sqlQuery = "SELECT FILE_LOC, DOC_UUID, DOCUMENT_PATH, DMS_TENANT FROM USER_DOC_CONTENTS WHERE DOC_ID = ?";
            BaseLogger.log("3", this.userInfo, null, "selectQry :" + sqlQuery);
            preparedStatement = connection.prepareStatement(sqlQuery);
            preparedStatement.setString(1, documentId);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSet.next()) {
                alfreskoFileDetailMap = new HashMap<String, String>();
                int columnCount = resultSetMetaData.getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    String columnName = resultSetMetaData.getColumnLabel(i);
                    alfreskoFileDetailMap.put(columnName, resultSet.getString(columnName));
                    ++i;
                }
                alfreskoFileDetailMap.put("REF_SER", "CLM");
                alfreskoFileDetailMap.put("REF_ID", userId);
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alfreskoFileDetailMap;
    }

    private InputStream wrapInputStream(final InputStream inputStream, final int available, final AutoCloseable ... closeables) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return inputStream.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return inputStream.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return inputStream.read(b, off, len);
            }

            @Override
            public int available() throws IOException {
                return available;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void close() throws IOException {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                finally {
                    var5_3 = closeables;
                    var4_5 = closeables.length;
                    var3_7 = 0;
                    if (true) ** GOTO lbl21
                }
                {
                }
                do {
                    closeable = var5_3[var3_7];
                    try {
                        closeable.close();
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", DocumentHandlerWrapperEJB.access$0(DocumentHandlerWrapperEJB.this), null, "Exception in closing autoclosables : " + closeable + " : " + ex);
                    }
                    ++var3_7;
lbl21:
                    // 2 sources

                } while (var3_7 < var4_5);
            }

            protected void finalize() throws Throwable {
                this.close();
            }
        };
    }

    @Override
    public String updateDocument(String xmlString, byte[] docObjectArray, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement pStmt = null;
        String retString = null;
        ResultSet rs = null;
        String docId = null;
        String refId = null;
        String refSer = null;
        String docName = null;
        String objName = "";
        String storageCode = "";
        boolean updateFlag = false;
        String docType = null;
        String user = null;
        Object insertQuery = null;
        int noOfRows = -1;
        String module = "";
        try {
            try {
                BaseLogger.log("3", userInfo, null, "Update Document Ejb");
                conn = this.getConnection(userInfo.getTransDB());
                conn.setAutoCommit(false);
                Document dom = new E12GenericUtility().parseString(xmlString);
                NodeList nodeList = dom.getElementsByTagName("header");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                if (childList != null) {
                    int i = 0;
                    while (i < childList.getLength()) {
                        Node childNode = childList.item(i);
                        String childNodeName = childNode.getNodeName();
                        if (childNodeName.equalsIgnoreCase("ref_id")) {
                            refId = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("ref_ser")) {
                            refSer = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("doc_id")) {
                            docId = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("doc_name")) {
                            docName = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("doc_type")) {
                            docType = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("Modified_By")) {
                            user = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("obj_name")) {
                            objName = childNode.getFirstChild().getNodeValue();
                        }
                        if (childNodeName.equalsIgnoreCase("module")) {
                            module = childNode.getFirstChild().getNodeValue();
                        }
                        ++i;
                    }
                }
                String sql = null;
                if (("mssql".equalsIgnoreCase(this.database) || "db2".equalsIgnoreCase(this.database) || "mysql".equalsIgnoreCase(this.database) || "pgsql".equalsIgnoreCase(this.database)) && this.repositoryHandler == null) {
                    sql = "UPDATE DOC_CONTENTS SET DOC_OBJECT = ? where DOC_ID =?";
                    pStmt = conn.prepareStatement(sql);
                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(docObjectArray);
                    pStmt.setBinaryStream(1, byteArrayIn, byteArrayIn.available());
                    pStmt.setString(2, docId);
                    int noOfRow = pStmt.executeUpdate();
                    BaseLogger.log("3", userInfo, null, "noOfRow" + noOfRow);
                    pStmt.close();
                    pStmt = null;
                    updateFlag = true;
                } else if (this.repositoryHandler == null) {
                    sql = "UPDATE DOC_CONTENTS SET DOC_OBJECT = EMPTY_BLOB() where DOC_ID =?";
                    pStmt = conn.prepareStatement(sql);
                    pStmt.setString(1, docId);
                    int noOfRow = pStmt.executeUpdate();
                    BaseLogger.log("3", userInfo, null, "noOfRow" + noOfRow);
                    pStmt.close();
                    pStmt = null;
                } else {
                    String[] pathUuid;
                    String docUuid = this.getDOC_UUID(docId, conn);
                    String enterprise = userInfo.getEnterprise();
                    if (this.repositoryHandler != null) {
                        this.repositoryHandler.delete(refSer, docId, refId, docUuid, enterprise, null, null);
                    }
                    String cmsPath = this.getCMSPath(objName, conn);
                    List<String> list1 = this.getUUID(cmsPath, conn);
                    String uuidrefID = this.getUUIDRefID(refSer, refId, conn);
                    String uuid = "";
                    String documentPath = "";
                    String dmsTenant = "";
                    if (this.repositoryHandler != null) {
                        HashMap<String, String> dataMap = this.repositoryHandler.upload(refSer, refId, docId, docName, docObjectArray, cmsPath, list1, uuidrefID, enterprise, module);
                        uuid = dataMap.get("DOC_UUID");
                        documentPath = dataMap.get("DOCUMENT_PATH");
                        dmsTenant = dataMap.get("DMS_TENANT");
                    }
                    BaseLogger.log("3", userInfo, null, "cmsPath ===1 " + cmsPath);
                    if (cmsPath != null && !"".equals(cmsPath)) {
                        if (uuid.startsWith("UpdateCMSPath")) {
                            pathUuid = uuid.split("_");
                            this.updatecmsPath(list1.get(0), pathUuid[2], objName, conn);
                        } else {
                            this.insertPathUUID(cmsPath, uuid, objName, conn, user);
                        }
                    }
                    if (uuid.startsWith("UpdateUUID") || uuid.startsWith("UpdateCMSPath")) {
                        pathUuid = uuid.split("_");
                        this.updateDocUUID(docId, pathUuid[1], documentPath, dmsTenant, conn);
                    } else {
                        this.updateDocUUID(docId, uuid, documentPath, dmsTenant, conn);
                    }
                    updateFlag = true;
                }
                if (!("mssql".equalsIgnoreCase(this.database) || "db2".equalsIgnoreCase(this.database) || "mysql".equalsIgnoreCase(this.database) || "pgsql".equalsIgnoreCase(this.database) || this.repositoryHandler != null)) {
                    pStmt = conn.prepareStatement("SELECT DOC_OBJECT FROM DOC_CONTENTS WHERE DOC_ID =? FOR UPDATE");
                    pStmt.setString(1, docId);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        updateFlag = true;
                        Blob mapBlob = rs.getBlob(1);
                        OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                        blobOutputStream.write(docObjectArray);
                        blobOutputStream.flush();
                        blobOutputStream.close();
                    }
                    pStmt.close();
                    pStmt = null;
                }
                if (updateFlag) {
                    BaseLogger.log("3", userInfo, null, "updateFlag" + updateFlag);
                    pStmt = conn.prepareStatement("UPDATE DOC_CONTENTS SET DOC_NAME ='" + docName + "',DOC_TYPE ='" + docType + "',CHG_USER ='" + user + "' WHERE DOC_ID =?");
                    pStmt.setString(1, docId);
                    retString = this.getUpdatedDocInfo(docId, docName, docType, user);
                    int no = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    conn.commit();
                    updateFlag = false;
                } else {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_notProperlyUpdated") + "</Detail></Root>";
                    conn.rollback();
                }
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerEJB :updateDocument:==>" + ie);
                ie.printStackTrace();
                try {
                    if (conn != null) {
                        BaseLogger.log("0", userInfo, null, "SQLException : addDocument :: Connection rollback");
                        conn.rollback();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerEJB :updateDocument :==>" + e);
                e.printStackTrace();
                try {
                    if (conn != null) {
                        BaseLogger.log("0", userInfo, null, "Exception : addDocument :: Connection rollback");
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private void updateDocUUID(String docId, String uuid, String documentPath, String dmsTenant, Connection conn) {
        this.updateDocUUID(docId, uuid, documentPath, dmsTenant, "DOC_TRANSACTION_LINK", conn);
    }

    private void updateDocUUID(String docId, String uuid, String documentPath, String dmsTenant, String tableName, Connection conn) {
        String cmsPath;
        block16: {
            cmsPath = "";
            PreparedStatement mPstmt = null;
            int cnt = 0;
            String uuidRefID = "";
            String docUUID = "";
            if (uuid != null && uuid.indexOf("~") != -1) {
                docUUID = uuid.substring(0, uuid.indexOf("~"));
                uuidRefID = uuid.substring(uuid.indexOf("~") + 1);
            } else {
                docUUID = uuid;
            }
            BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB >> updateDocUUID >> uuidRefID =[" + uuidRefID + "]");
            String sql = "UPDATE " + tableName + " SET DOC_UUID = ?, UUID_REFID = ?, DOCUMENT_PATH = ?, DMS_TENANT = ? WHERE DOC_ID = ? ";
            try {
                try {
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, docUUID);
                    mPstmt.setString(2, uuidRefID);
                    mPstmt.setString(3, documentPath);
                    mPstmt.setString(4, dmsTenant);
                    mPstmt.setString(5, docId);
                    cnt = mPstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        break block16;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", this.userInfo, null, "CMS_PATH for objName is [ " + cmsPath + " ] ");
    }

    @Override
    public String removeAttach(String docId, String refSer, String refId, String objName, String refCol, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        String sqlQry = null;
        try {
            try {
                BaseLogger.log("3", userInfo, null, "repositoryHandler object in removeAttach --- " + this.repositoryHandler);
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "refCol in docHandler[" + refCol + "] transDB[" + transDB + "]");
                if (refCol == null || "null".equalsIgnoreCase(refCol)) {
                    refCol = "";
                }
                conn = this.getConnection(transDB);
                String deleteAttach = CommonConstants.DELETE_ATTACHMENT;
                BaseLogger.log("3", userInfo, null, "deleteAttach : [" + deleteAttach + "]");
                int deletedRow = 0;
                if ("Y".equals(deleteAttach)) {
                    this.deleteAuditTrailDocAttachments(docId, conn);
                    sqlQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID ='" + this.checkNull(docId) + "'";
                    BaseLogger.log("3", userInfo, null, "Execute in 'Y' deleteAttachment : [" + sqlQry + "]");
                    preparedStatement = conn.prepareStatement(sqlQry);
                    deletedRow = preparedStatement.executeUpdate();
                    preparedStatement.close();
                    preparedStatement = null;
                    String fileLoc = "";
                    String docUuid = "";
                    String documentPath = "";
                    String dmsTenant = "";
                    String enterprise = userInfo.getEnterprise();
                    sqlQry = "SELECT FILE_LOC, REF_ID, REF_SER, DOC_UUID, DOCUMENT_PATH, DMS_TENANT FROM DOC_TRANSACTION_LINK WHERE RTRIM(DOC_ID) ='" + this.checkNull(docId) + "'";
                    preparedStatement = conn.prepareStatement(sqlQry);
                    ResultSet rs = preparedStatement.executeQuery();
                    if (rs.next()) {
                        fileLoc = rs.getString("FILE_LOC");
                        docUuid = rs.getString("DOC_UUID");
                        documentPath = rs.getString("DOCUMENT_PATH");
                        dmsTenant = rs.getString("DMS_TENANT");
                    }
                    preparedStatement.close();
                    preparedStatement = null;
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (CommonConstants.CONTENT_MGMT != null && CommonConstants.contentServicesMap != null && !"Oracle".equalsIgnoreCase(fileLoc)) {
                        BaseLogger.log("3", userInfo, null, "Trying to download file from repository(DMS) for docId [ " + docId + " ] fileLoc : [" + fileLoc + "]");
                        this.setRepositoryHandler(fileLoc, userInfo);
                        if (this.repositoryHandler != null) {
                            this.repositoryHandler.delete(refSer, docId, refId, docUuid, enterprise, documentPath, dmsTenant);
                        }
                    }
                } else {
                    deletedRow = 1;
                }
                sqlQry = "Y".equals(deleteAttach) ? "DELETE FROM DOC_TRANSACTION_LINK WHERE RTRIM(DOC_ID) ='" + this.checkNull(docId) + "'" : (refCol.length() == 0 ? "UPDATE DOC_TRANSACTION_LINK SET DELETE_FLAG ='Y' WHERE TRIM(DOC_ID)='" + this.checkNull(docId) + "' AND RTRIM(REF_ID) = '" + this.checkNull(refId) + "' AND RTRIM(REF_SER) = '" + this.checkNull(refSer) + "'" : "UPDATE DOC_TRANSACTION_LINK SET DELETE_FLAG ='Y' WHERE TRIM(DOC_ID)='" + this.checkNull(docId) + "' AND RTRIM(REF_ID) = '" + this.checkNull(refId) + "' AND RTRIM(REF_SER) = '" + this.checkNull(refSer) + "' AND RTRIM(REF_COL)='" + this.checkNull(refCol) + "'");
                preparedStatement = conn.prepareStatement(sqlQry);
                int updatedRows = preparedStatement.executeUpdate();
                this.updateCountOfAttachments(objName, refId, refSer, conn, transDB);
                if (updatedRows == 1 && deletedRow == 1) {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_deletedSuccessfully") + "[ <doc_title> ]</Detail></Root>";
                    conn.commit();
                } else {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_deletedFailure") + "[ <doc_title> ]</Detail></Root>";
                    conn.rollback();
                }
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerEJB :getDocument:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerEJB :getDocument :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(preparedStatement);
                this.closeObject(conn);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
            throw throwable;
        }
        try {
            this.closeObject(preparedStatement);
            this.closeObject(conn);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "In DocumentHandlerWrapperEJB : removeAttach :retString[" + retString + "]");
        return retString;
    }

    @Override
    public String addDocument(String xmlString, byte[] docObjectArray, byte[] videoFrameByteArray, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retString;
        block114: {
            Statement pStmt;
            Connection conn;
            block113: {
                this.setUserInfo(userInfo);
                conn = null;
                pStmt = null;
                retString = null;
                ResultSet rs = null;
                String docId = null;
                String refId = null;
                String refSer = null;
                String docName = null;
                String documentType = "";
                String fileType = "";
                String objName = "";
                String storageCode = "";
                boolean updateFlag = false;
                String docType = null;
                String user = null;
                String refCol = null;
                String insertQuery = null;
                int noOfRows = -1;
                String docPages = null;
                boolean repositoryUpload = false;
                String docLinkOpt = "";
                String refDescr = "";
                String extractedData = "";
                String fileMetadata = "";
                String module = "";
                String expDate = null;
                String cacheOpt = null;
                String docMetaData = "";
                String majorVersion = "";
                boolean isMajorVersion = false;
                String checkinComment = "";
                boolean isForCheckIn = false;
                String docProcessTrail = "";
                String procStatus = "";
                String docOcrData = "";
                String overviewData = "";
                try {
                    try {
                        float docSize = (float)docObjectArray.length / 1024.0f / 1024.0f;
                        Document dom = new E12GenericUtility().parseString(xmlString);
                        NodeList nodeList = dom.getElementsByTagName("header");
                        Node node = nodeList.item(0);
                        NodeList childList = node.getChildNodes();
                        if (childList != null) {
                            int i = 0;
                            while (i < childList.getLength()) {
                                String childNodeName;
                                Node childNode = childList.item(i);
                                if (childNode != null && this.checkNull(childNodeName = childNode.getNodeName()).length() > 0) {
                                    if (childNodeName.equalsIgnoreCase("ref_id") && childNode.getFirstChild() != null) {
                                        refId = childNode.getFirstChild().getNodeValue();
                                    }
                                    if (childNodeName.equalsIgnoreCase("ref_ser") && childNode.getFirstChild() != null) {
                                        refSer = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_name") && childNode.getFirstChild() != null) {
                                        docName = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_type") && childNode.getFirstChild() != null) {
                                        docType = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("created_by") && childNode.getFirstChild() != null) {
                                        user = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("ref_col") && childNode.getFirstChild() != null) {
                                        refCol = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_pages") && childNode.getFirstChild() != null) {
                                        docPages = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("obj_name") && childNode.getFirstChild() != null) {
                                        objName = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("document_type") && childNode.getFirstChild() != null) {
                                        documentType = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("file_type") && childNode.getFirstChild() != null) {
                                        fileType = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_link_optn") && childNode.getFirstChild() != null) {
                                        docLinkOpt = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("ref_descr") && childNode.getFirstChild() != null) {
                                        refDescr = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("extracted_data") && childNode.getFirstChild() != null) {
                                        extractedData = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("file_metadata") && childNode.getFirstChild() != null) {
                                        fileMetadata = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("module") && childNode.getFirstChild() != null) {
                                        module = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("exp_date") && childNode.getFirstChild() != null) {
                                        expDate = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("cache_opt") && childNode.getFirstChild() != null) {
                                        cacheOpt = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_meta_data") && childNode.getFirstChild() != null) {
                                        docMetaData = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_id") && childNode.getFirstChild() != null) {
                                        docId = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("is_major_version") && childNode.getFirstChild() != null) {
                                        majorVersion = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("checkin_comment") && childNode.getFirstChild() != null) {
                                        checkinComment = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("doc_proc_trail") && childNode.getFirstChild() != null) {
                                        docProcessTrail = this.checkNull(childNode.getFirstChild().getNodeValue());
                                        docProcessTrail = URLDecoder.decode(docProcessTrail, "UTF-8");
                                    }
                                    if (childNodeName.equalsIgnoreCase("proc_status") && childNode.getFirstChild() != null) {
                                        procStatus = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                    if (childNodeName.equalsIgnoreCase("ocr_data") && childNode.getFirstChild() != null) {
                                        docOcrData = this.checkNull(childNode.getFirstChild().getNodeValue());
                                        docOcrData = URLDecoder.decode(docOcrData, "UTF-8");
                                    }
                                    if (childNodeName.equalsIgnoreCase("overview_data") && childNode.getFirstChild() != null) {
                                        overviewData = this.checkNull(childNode.getFirstChild().getNodeValue());
                                    }
                                }
                                ++i;
                            }
                            BaseLogger.log("3", userInfo, null, "refCol in docHandler[" + refCol + "]");
                            BaseLogger.log("3", userInfo, null, "docPages [" + docPages + "]");
                            BaseLogger.log("3", userInfo, null, "docLinkOpt [" + docLinkOpt + "]");
                            BaseLogger.log("3", userInfo, null, "refDescr [" + refDescr + "]");
                            BaseLogger.log("3", userInfo, null, "expDate [" + expDate + "]");
                            BaseLogger.log("3", userInfo, null, "docId [" + docId + "]");
                            BaseLogger.log("3", userInfo, null, "majorVersion [" + majorVersion + "]");
                            BaseLogger.log("3", userInfo, null, "checkinComment [" + checkinComment + "]");
                            BaseLogger.log("3", userInfo, null, "procStatus [" + procStatus + "]");
                            if (docPages == null || docPages.trim().length() == 0 || "null".equalsIgnoreCase(docPages)) {
                                docPages = "0";
                            }
                            if (refCol == null || refCol.trim().length() == 0 || "null".equalsIgnoreCase(refCol)) {
                                refCol = " ";
                            }
                            try {
                                if (majorVersion.length() > 0) {
                                    isMajorVersion = Boolean.parseBoolean(majorVersion);
                                }
                            }
                            catch (Exception e) {
                                isMajorVersion = false;
                                e.printStackTrace();
                            }
                            if (docId != null && docId.length() > 0) {
                                isForCheckIn = true;
                            }
                        }
                        String transDB = userInfo.getTransDB();
                        BaseLogger.log("3", userInfo, null, "xmlString ======== " + xmlString + "========= transDB[" + transDB + "]");
                        conn = this.getConnection(transDB);
                        conn.setAutoCommit(false);
                        BaseLogger.log("3", userInfo, null, "getDocument objName : [" + objName + "]");
                        boolean isFileSizeValid = true;
                        DBAccessEJB dbAccessEjb = new DBAccessEJB();
                        String maxFileUploadSize = dbAccessEjb.getMaxFileUploadSize(objName, conn, userInfo);
                        BaseLogger.log("3", userInfo, null, "maxFileUploadSize : - [" + maxFileUploadSize + "]");
                        if (maxFileUploadSize != null && maxFileUploadSize.length() > 0) {
                            double maxUploadSize = Double.parseDouble(maxFileUploadSize);
                            boolean bl = isFileSizeValid = (double)docSize <= maxUploadSize;
                            if (!isFileSizeValid) {
                                retString = this.getMaxUploadSizeErrorString(maxUploadSize, docSize);
                                BaseLogger.log("3", userInfo, null, "retString : [" + retString + "]");
                            }
                        }
                        BaseLogger.log("3", userInfo, null, "isFileSizeValid : [" + isFileSizeValid + "]");
                        if (!isFileSizeValid) break block113;
                        this.setRepositoryHandler(null, userInfo);
                        if (!isForCheckIn) {
                            docId = this.generateTranSeqID(user, conn);
                            BaseLogger.log("3", userInfo, null, "docId : [" + docId + "]");
                            boolean isFileLoc = false;
                            if ("mssql".equalsIgnoreCase(this.database) || "db2".equalsIgnoreCase(this.database) || "mysql".equalsIgnoreCase(this.database) || "pgsql".equalsIgnoreCase(this.database)) {
                                insertQuery = "INSERT INTO DOC_CONTENTS(DOC_ID,DOC_NAME, STORAGE_CODE,DOC_TYPE,CHG_DATE, CHG_USER, CHG_TERM,ADD_DATE,ADD_USER, DOC_SECURITY,USER_ID__CHKOUT,DOC_OBJECT,DOC_PAGES, ICON,EXTRACTED_DATA, FILE_METADATA, DOC_SIZE, DOC_META_DATA,OVERVIEW_DATA )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                isFileLoc = false;
                                if (this.repositoryHandler != null) {
                                    isFileLoc = true;
                                    insertQuery = "INSERT INTO DOC_CONTENTS(DOC_ID,DOC_NAME, STORAGE_CODE,DOC_TYPE,CHG_DATE, CHG_USER, CHG_TERM,ADD_DATE,ADD_USER, DOC_SECURITY,USER_ID__CHKOUT,DOC_OBJECT,DOC_PAGES,ICON,EXTRACTED_DATA, FILE_METADATA,DOC_SIZE, DOC_META_DATA,OVERVIEW_DATA)VALUES(?,?,?,?,?,?,?,?,?,?,?,NULL,?,?,?,?,?,?,?)";
                                }
                                BaseLogger.log("3", userInfo, null, "Document Obj ..Inserting into Document Object [" + insertQuery + "]");
                                pStmt = conn.prepareStatement(insertQuery);
                                pStmt.setString(1, docId);
                                pStmt.setString(2, docName);
                                pStmt.setString(3, "N");
                                pStmt.setString(4, docType);
                                pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                                pStmt.setString(6, user);
                                pStmt.setString(7, user);
                                pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                                pStmt.setString(9, user);
                                pStmt.setString(10, "N");
                                pStmt.setString(11, user);
                                if (this.repositoryHandler == null) {
                                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(docObjectArray);
                                    pStmt.setBinaryStream(12, byteArrayIn, byteArrayIn.available());
                                    pStmt.setInt(13, Integer.parseInt(docPages));
                                    if (videoFrameByteArray != null) {
                                        ByteArrayInputStream frameArrayIS = new ByteArrayInputStream(videoFrameByteArray);
                                        pStmt.setBinaryStream(14, frameArrayIS, frameArrayIS.available());
                                    } else {
                                        pStmt.setNull(14, -2);
                                    }
                                    pStmt.setString(15, extractedData);
                                    pStmt.setString(16, fileMetadata);
                                    pStmt.setFloat(17, docSize);
                                    pStmt.setString(18, docMetaData);
                                    pStmt.setString(19, overviewData);
                                } else {
                                    pStmt.setInt(12, Integer.parseInt(docPages));
                                    if (videoFrameByteArray != null) {
                                        ByteArrayInputStream frameArrayIS = new ByteArrayInputStream(videoFrameByteArray);
                                        pStmt.setBinaryStream(13, frameArrayIS, frameArrayIS.available());
                                    } else {
                                        pStmt.setNull(13, -2);
                                    }
                                    pStmt.setString(14, extractedData);
                                    pStmt.setString(15, fileMetadata);
                                    pStmt.setFloat(16, docSize);
                                    pStmt.setString(17, docMetaData);
                                    pStmt.setString(18, overviewData);
                                }
                                noOfRows = pStmt.executeUpdate();
                                pStmt.close();
                                pStmt = null;
                                updateFlag = true;
                            } else {
                                isFileLoc = false;
                                insertQuery = "INSERT INTO DOC_CONTENTS(DOC_ID,DOC_NAME, STORAGE_CODE,DOC_TYPE,CHG_DATE, CHG_USER, CHG_TERM,ADD_DATE,ADD_USER, DOC_SECURITY,USER_ID__CHKOUT,DOC_OBJECT,DOC_PAGES,ICON,EXTRACTED_DATA, FILE_METADATA, DOC_SIZE, DOC_META_DATA,OVERVIEW_DATA)VALUES(?,?,?,?,?,?,?,?,?,?,?,EMPTY_BLOB(),?,?,?,?,?,?,?)";
                                if (this.repositoryHandler != null) {
                                    isFileLoc = true;
                                    insertQuery = "INSERT INTO DOC_CONTENTS(DOC_ID,DOC_NAME, STORAGE_CODE,DOC_TYPE,CHG_DATE, CHG_USER, CHG_TERM,ADD_DATE,ADD_USER, DOC_SECURITY,USER_ID__CHKOUT,DOC_OBJECT,DOC_PAGES,ICON, EXTRACTED_DATA, FILE_METADATA, DOC_SIZE, DOC_META_DATA,OVERVIEW_DATA)VALUES(?,?,?,?,?,?,?,?,?,?,?,NULL,?,?,?,?,?,?,?)";
                                }
                                BaseLogger.log("3", userInfo, null, "Document Obj ..Inserting into Document Object [" + insertQuery + "]");
                                pStmt = conn.prepareStatement(insertQuery);
                                pStmt.setString(1, docId);
                                pStmt.setString(2, docName);
                                pStmt.setString(3, "N");
                                pStmt.setString(4, docType);
                                pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                                pStmt.setString(6, user);
                                pStmt.setString(7, user);
                                pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                                pStmt.setString(9, user);
                                pStmt.setString(10, "N");
                                pStmt.setString(11, user);
                                pStmt.setInt(12, Integer.parseInt(docPages));
                                if (videoFrameByteArray != null) {
                                    ByteArrayInputStream inputStream = new ByteArrayInputStream(videoFrameByteArray);
                                    pStmt.setBinaryStream(13, inputStream, inputStream.available());
                                } else {
                                    pStmt.setNull(13, -2);
                                }
                                if ("oracle".equalsIgnoreCase(this.database)) {
                                    CLOB clob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                    BaseLogger.log("3", userInfo, null, "---extractedData:: extractedData" + extractedData);
                                    clob.putString(1L, extractedData);
                                    BaseLogger.log("3", userInfo, null, "---extractedData:: clob" + clob);
                                    pStmt.setClob(14, (Clob)clob);
                                } else {
                                    pStmt.setString(14, extractedData);
                                }
                                pStmt.setString(15, fileMetadata);
                                pStmt.setFloat(16, docSize);
                                pStmt.setString(17, docMetaData);
                                if ("oracle".equalsIgnoreCase(this.database)) {
                                    CLOB clobb = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                    BaseLogger.log("3", userInfo, null, "---overviewData:: overviewData" + overviewData);
                                    clobb.putString(1L, overviewData);
                                    BaseLogger.log("3", userInfo, null, "---overviewData:: clob" + clobb);
                                    pStmt.setClob(18, (Clob)clobb);
                                } else {
                                    pStmt.setString(18, overviewData);
                                }
                                noOfRows = pStmt.executeUpdate();
                                pStmt.close();
                                pStmt = null;
                            }
                            try {
                                if (docLinkOpt.equalsIgnoreCase("DOC_CONTENT")) {
                                    this.saveLinkToUserDocumentContents(user, docId, documentType, refDescr, docName, expDate, cacheOpt, "N", "A", "", conn, procStatus);
                                } else if (docLinkOpt.equalsIgnoreCase("BOTH")) {
                                    this.saveLinkToDocTransactionLink(docId, refSer, refId, refCol, isFileLoc, documentType, fileType, conn, transDB, refDescr);
                                    this.saveLinkToUserDocumentContents(user, docId, documentType, refDescr, docName, expDate, cacheOpt, "N", "A", "", conn, procStatus);
                                } else {
                                    this.saveLinkToDocTransactionLink(docId, refSer, refId, refCol, isFileLoc, documentType, fileType, conn, transDB, refDescr);
                                }
                            }
                            catch (Exception ex) {
                                conn.rollback();
                                throw ex;
                            }
                            if (!("mssql".equalsIgnoreCase(this.database) || "db2".equalsIgnoreCase(this.database) || "mysql".equalsIgnoreCase(this.database) || "pgsql".equalsIgnoreCase(this.database) || this.repositoryHandler != null)) {
                                pStmt = conn.prepareStatement("SELECT DOC_OBJECT FROM DOC_CONTENTS WHERE DOC_ID =? FOR UPDATE");
                                pStmt.setString(1, docId);
                                rs = pStmt.executeQuery();
                                if (rs.next()) {
                                    updateFlag = true;
                                    Blob mapBlob = rs.getBlob(1);
                                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                                    blobOutputStream.write(docObjectArray);
                                    blobOutputStream.close();
                                }
                                pStmt.close();
                                pStmt = null;
                            }
                        }
                        if (this.repositoryHandler != null) {
                            BaseLogger.log("3", userInfo, null, "Uploading document into repository: REF_ID=" + refId + ", DOC_ID=" + docId + ", DOC_NAME=" + docName);
                            String cmsPath = this.getCMSPath(objName, conn);
                            List<String> list1 = null;
                            String uuidrefID = this.getUUIDRefID(refSer, refId, conn);
                            String enterprise = userInfo.getEnterprise();
                            String uuid = "";
                            String documentPath = "";
                            String dmsTenant = "";
                            String _refSer = refSer;
                            String _refId = refId;
                            if ("DOC_CONTENT".equalsIgnoreCase(docLinkOpt)) {
                                _refSer = "CLM";
                                _refId = user;
                            }
                            HashMap<Object, Object> dataMap = new HashMap();
                            if (isForCheckIn) {
                                String fileLoc = "";
                                String docUuid = "";
                                Map<String, String> alfrescoFileDetailMap = this.getAlfrescoFileDetailMap(null, docId, userInfo.getLoginCode(), conn);
                                if (alfrescoFileDetailMap == null) {
                                    alfrescoFileDetailMap = this.getAlfrescoFileDetailMap("UDC", docId, userInfo.getLoginCode(), conn);
                                }
                                BaseLogger.log("3", userInfo, null, "alfrescoFileDetailMap [" + alfrescoFileDetailMap + "]");
                                if (alfrescoFileDetailMap != null && alfrescoFileDetailMap.size() > 0) {
                                    fileLoc = this.checkNull(alfrescoFileDetailMap.get("FILE_LOC"));
                                    refId = this.checkNull(alfrescoFileDetailMap.get("REF_ID"));
                                    refSer = this.checkNull(alfrescoFileDetailMap.get("REF_SER"));
                                    docUuid = this.checkNull(alfrescoFileDetailMap.get("DOC_UUID"));
                                    documentPath = this.checkNull(alfrescoFileDetailMap.get("DOCUMENT_PATH"));
                                    dmsTenant = this.checkNull(alfrescoFileDetailMap.get("DMS_TENANT"));
                                }
                                if (CommonConstants.contentServicesMap != null && !"Oracle".equalsIgnoreCase(fileLoc)) {
                                    if (!this.activeContentServiceConn.equalsIgnoreCase(fileLoc)) {
                                        this.setRepositoryHandler(fileLoc, userInfo);
                                    }
                                    if (this.repositoryHandler != null) {
                                        dataMap = this.repositoryHandler.checkInDocument(docUuid, docName, docObjectArray, isMajorVersion, checkinComment);
                                        this.updateDocContent(docId, docName, docType, userInfo, conn);
                                    } else {
                                        BaseLogger.log("3", userInfo, null, "Error while downloading file : unable to find DMS Server.");
                                    }
                                } else {
                                    BaseLogger.log("3", userInfo, null, "Error while downloading file : unable to find DMS Server.");
                                }
                            } else {
                                dataMap = this.repositoryHandler.upload(_refSer, _refId, docId, docName, docObjectArray, cmsPath, list1, uuidrefID, enterprise, module);
                            }
                            BaseLogger.log("3", userInfo, null, "dataMap : [" + dataMap + "]");
                            uuid = (String)dataMap.get("DOC_UUID");
                            documentPath = (String)dataMap.get("DOCUMENT_PATH");
                            dmsTenant = (String)dataMap.get("DMS_TENANT");
                            BaseLogger.log("3", userInfo, null, "cmsPath === [" + cmsPath + "] === uuid === [" + uuid + "]");
                            if (!uuid.equalsIgnoreCase("error")) {
                                if (cmsPath != null && !"".equals(cmsPath)) {
                                    if (uuid.startsWith("UpdateCMSPath")) {
                                        String[] pathUuid = uuid.split("_");
                                        this.updatecmsPath(null, pathUuid[2], objName, conn);
                                    } else {
                                        this.insertPathUUID(cmsPath, uuid, objName, conn, user);
                                    }
                                }
                                if (uuid.startsWith("UpdateUUID") || uuid.startsWith("UpdateCMSPath")) {
                                    uuid = uuid.split("_")[1];
                                }
                                if ("DOC_CONTENT".equalsIgnoreCase(docLinkOpt)) {
                                    this.updateDocUUID(docId, uuid, documentPath, dmsTenant, "USER_DOC_CONTENTS", conn);
                                } else if ("BOTH".equalsIgnoreCase(docLinkOpt)) {
                                    this.updateDocUUID(docId, uuid, documentPath, dmsTenant, "USER_DOC_CONTENTS", conn);
                                    this.updateDocUUID(docId, uuid, documentPath, dmsTenant, "DOC_TRANSACTION_LINK", conn);
                                } else {
                                    this.updateDocUUID(docId, uuid, documentPath, dmsTenant, "DOC_TRANSACTION_LINK", conn);
                                }
                                repositoryUpload = true;
                            } else {
                                repositoryUpload = false;
                            }
                            updateFlag = true;
                        }
                        this.updateCountOfAttachments(objName, refId, refSer, conn, transDB);
                        if (this.repositoryHandler != null) {
                            if (updateFlag && repositoryUpload) {
                                retString = this.getUpdatedDocInfo(docId, docName, docType, user, fileMetadata);
                                conn.commit();
                                updateFlag = false;
                            } else {
                                retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_notProperlyUploaded") + "</Detail></Root>";
                                conn.rollback();
                            }
                        } else if (updateFlag) {
                            retString = this.getUpdatedDocInfo(docId, docName, docType, user, fileMetadata);
                            conn.commit();
                            updateFlag = false;
                        } else {
                            retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_notProperlyUploaded") + "</Detail></Root>";
                            conn.rollback();
                        }
                        this.saveDocProcessTrail(docId, docProcessTrail, userInfo);
                        this.trainDocument(docId, documentType, docOcrData, userInfo);
                        AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
                        if (!isForCheckIn) {
                            auditTrailExt.saveActionPerformedInAuditTrailDoc(docId, "A", documentType, objName, "", userInfo.getLoginCode(), userInfo.getRemoteHostName(), transDB, userInfo);
                        }
                    }
                    catch (SQLException ie) {
                        BaseLogger.log("0", userInfo, null, "SQLException : DocumentHandlerEJB :: addDocument : [" + ie.getMessage() + "]");
                        ie.printStackTrace();
                        try {
                            if (conn != null) {
                                BaseLogger.log("0", userInfo, null, "SQLException : addDocument :: Connection rollback");
                                conn.rollback();
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        throw new ITMException("CUSTOM_MESSAGE:Unable to store document in database", ie);
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", userInfo, null, "Exception : DocumentHandlerEJB :: addDocument : [" + e.getMessage() + "]");
                        e.printStackTrace();
                        try {
                            if (conn != null) {
                                BaseLogger.log("0", userInfo, null, "Exception : addDocument :: Connection rollback");
                                conn.rollback();
                            }
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                        if (!this.isRepositoryException(e)) {
                            throw new ITMException(e);
                        }
                        retString = new E12GenericUtility().createErrorString(e);
                        retString = this.updateExcetionMessage(retString);
                        try {
                            if (conn != null) {
                                if (pStmt != null) {
                                    pStmt.close();
                                    pStmt = null;
                                }
                                conn.close();
                                conn = null;
                            }
                            break block114;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        break block114;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            if (pStmt != null) {
                                pStmt.close();
                                pStmt = null;
                            }
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
            }
            try {
                if (conn != null) {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", userInfo, null, "addDocument :: retString : [" + retString + "]");
        return retString;
    }

    private String getCMSPath(String objName, Connection conn) {
        String cmsPath;
        block18: {
            cmsPath = "";
            PreparedStatement mPstmt = null;
            ResultSet rs = null;
            BaseLogger.log("2", this.userInfo, null, "objName in getCMSPath [" + objName + " ] ");
            String sql = "SELECT CMS_PATH FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
            try {
                try {
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, "w_" + objName);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        cmsPath = rs.getString("CMS_PATH");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", this.userInfo, null, "CMS_PATH for objName is [ " + cmsPath + " ] ");
        return cmsPath;
    }

    private List<String> getUUID(String cmsPath, Connection conn) {
        ArrayList<String> cmsPathUUID;
        block18: {
            cmsPath = "";
            String pathUuid = "";
            PreparedStatement mPstmt = null;
            ResultSet rs = null;
            cmsPathUUID = new ArrayList<String>();
            BaseLogger.log("2", this.userInfo, null, "cmsPath in getUUID [" + cmsPath + " ] ");
            String sql = "SELECT CMS_PATH, PATH_UUID FROM DOC_FOLDER WHERE CMS_PATH = ? ";
            try {
                try {
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, cmsPath);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        cmsPath = rs.getString("CMS_PATH");
                        pathUuid = rs.getString("PATH_UUID");
                        cmsPathUUID.add(cmsPath);
                        cmsPathUUID.add(pathUuid);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", this.userInfo, null, "cmsPathUUID for objName is [ " + cmsPathUUID + " ] ");
        return cmsPathUUID;
    }

    private void insertPathUUID(String cmsPath, String pathUuid, String objName, Connection conn, String user) {
        PreparedStatement mPstmt = null;
        int cnt = 0;
        String sysdateStr = E12GenericUtility.getSysdate();
        String sql = "INSERT INTO DOC_FOLDER (CMS_PATH, PATH_UUID, OBJ_NAME, CHG_DATE, CHG_USER, CHG_TERM) VALUES (?, ?, ?, " + sysdateStr + ", ?, ?)";
        try {
            try {
                mPstmt = conn.prepareStatement(sql);
                mPstmt.setString(1, cmsPath);
                mPstmt.setString(2, pathUuid);
                mPstmt.setString(3, objName);
                mPstmt.setString(4, user);
                mPstmt.setString(5, String.valueOf(InetAddress.getLocalHost()));
                cnt = mPstmt.executeUpdate();
                if (cnt != -1) {
                    BaseLogger.log("3", this.userInfo, null, "DOC_FOLDER INSERTED successfully.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updatePathUUID(String cmsPath, String pathUuid, String objName, Connection conn) {
        PreparedStatement mPstmt = null;
        int cnt = 0;
        String sql = "UPDTE DOC_FOLDER SET PATH_UUID = ? WHERE CMS_PATH = ?";
        try {
            try {
                mPstmt = conn.prepareStatement(sql);
                mPstmt.setString(1, pathUuid);
                mPstmt.setString(2, cmsPath);
                cnt = mPstmt.executeUpdate();
                if (cnt != -1) {
                    BaseLogger.log("3", this.userInfo, null, "DOC_FOLDER UPDATED successfully.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updatecmsPath(String cmsPath, String uuid, String objName, Connection conn) {
        PreparedStatement mPstmt = null;
        int cnt = 0;
        String sql = "UPDATE DOC_FOLDER SET CMS_PATH = ?, PATH_UUID = ? WHERE OBJ_NAME = ?";
        try {
            try {
                mPstmt = conn.prepareStatement(sql);
                mPstmt.setString(1, cmsPath);
                mPstmt.setString(2, uuid);
                mPstmt.setString(3, objName);
                cnt = mPstmt.executeUpdate();
                if (cnt != -1) {
                    BaseLogger.log("3", this.userInfo, null, "DOC_FOLDER UPDATED successfully.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getDocumentName(String docId, String transDB) throws RemoteException, ITMException {
        return this.getDocumentName(docId, transDB, null);
    }

    public String getDocumentName(String docId, String transDB, Connection conn) throws RemoteException, ITMException {
        String retDocumentName = "";
        boolean isLocalConn = false;
        Statement mPstmt = null;
        try {
            try {
                if (conn == null) {
                    conn = this.getConnection(transDB);
                    isLocalConn = true;
                }
                String selQry = "SELECT DOC_NAME FROM DOC_CONTENTS WHERE DOC_ID =?";
                BaseLogger.log("3", this.userInfo, null, " SELECT DOC_NAME selectQry :" + selQry);
                mPstmt = conn.prepareStatement(selQry);
                mPstmt.setString(1, docId);
                ResultSet rs = mPstmt.executeQuery();
                if (rs.next()) {
                    String string = retDocumentName = rs.getString(1) == null ? "" : rs.getString(1);
                }
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException ie) {
                BaseLogger.log("0", this.userInfo, null, "SQLException :DocumentHandlerEJB :getDocumentName:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB :getDocumentName :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (conn != null && isLocalConn) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return retDocumentName;
    }

    public Connection getConnection(String transDB) throws RemoteException, ITMException {
        Connection conn = null;
        try {
            BaseLogger.log("3", this.userInfo, null, "IN getConnection METHOD");
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(transDB);
            conn.setAutoCommit(false);
            this.database = connDriver.getDBName();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [DocumentHandlerEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private String getUpdatedDocInfo(String docId, String docName, String docType, String user) throws ITMException {
        return this.getUpdatedDocInfo(docId, docName, docType, user, "");
    }

    private String getUpdatedDocInfo(String docId, String docName, String docType, String user, String fileMetadata) throws ITMException {
        String retStr = "";
        StringBuffer documentInfoXMLBuff = null;
        try {
            documentInfoXMLBuff = new StringBuffer();
            documentInfoXMLBuff.append("<Document>\n");
            documentInfoXMLBuff.append("<ID Document_Id='" + docId + "'>\n");
            documentInfoXMLBuff.append("<Name><![CDATA[" + docName + "]]></Name>\n");
            documentInfoXMLBuff.append("<Type><![CDATA[" + docType + "]]></Type>\n");
            documentInfoXMLBuff.append("<Last_Modified><![CDATA[" + new Date(System.currentTimeMillis()) + "]]></Last_Modified>\n");
            documentInfoXMLBuff.append("<Modified_By><![CDATA[" + user + "]]></Modified_By>\n");
            documentInfoXMLBuff.append("<Created_Date><![CDATA[" + new Date(System.currentTimeMillis()) + "]]></Created_Date>\n");
            documentInfoXMLBuff.append("<Created_By><![CDATA[" + user + "]]></Created_By>\n");
            documentInfoXMLBuff.append("<CheckOut><![CDATA[" + user + "]]></CheckOut>\n");
            if (fileMetadata != null && fileMetadata.length() > 0) {
                documentInfoXMLBuff.append("<FileMetadata><![CDATA[" + fileMetadata + "]]></FileMetadata>\n");
            }
            documentInfoXMLBuff.append("</ID>\n");
            documentInfoXMLBuff.append("</Document>");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "documentInfoXMLBuff: " + documentInfoXMLBuff.toString());
        return documentInfoXMLBuff.toString();
    }

    @Override
    public String getAttachmentsInfoList(String refSer, String refID, String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        StringBuffer documentInfoXMLBuff = null;
        String mQuery = null;
        String transDB = "";
        try {
            try {
                mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                mQuery = "SELECT DOC_CONTENTS.DOC_ID, DOC_NAME, DOC_CONTENTS.DOC_TYPE, ADD_DATE, ADD_USER FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID = '" + refID + "' ORDER BY DOC_CONTENTS.DOC_ID";
                if (this.repositoryHandler != null) {
                    mQuery = "SELECT DOC_CONTENTS.DOC_ID, DOC_NAME, DOC_CONTENTS.DOC_TYPE, ADD_DATE, ADD_USER FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = '" + refSer + "' AND REF_ID = '" + refID + "' AND DOC_OBJECT IS NULL ORDER BY DOC_CONTENTS.DOC_ID";
                }
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                documentInfoXMLBuff = new StringBuffer();
                documentInfoXMLBuff.append("<DIV> </BR> " + Messages.getString("DocumentHandlerEJB_attachmentInformation") + "</BR> </DIV><TABLE border='1'>");
                documentInfoXMLBuff.append("<TR><TH>" + Messages.getString("DocumentHandlerEJB_name") + "</TH><TH>" + Messages.getString("DocumentHandlerEJB_type") + "</TH><TH>" + Messages.getString("DocumentHandlerEJB_createdBy") + "</TH><TH>" + Messages.getString("DocumentHandlerEJB_createdDate") + "</TH><TH></TH></TR>");
                while (mRs.next()) {
                    String docId = mRs.getString("DOC_ID");
                    String docName = mRs.getString("DOC_NAME");
                    String docType = mRs.getString("DOC_TYPE");
                    String addDate = mRs.getString("ADD_DATE");
                    String addUser = mRs.getString("ADD_USER");
                    if (docId == null || docId.equalsIgnoreCase("null") || docId.length() == 0) {
                        docId = null;
                    }
                    if (docName == null || docName.equalsIgnoreCase("null") || docName.length() == 0) {
                        docName = null;
                    }
                    if (docType == null || docType.equalsIgnoreCase("null") || docType.length() == 0) {
                        docType = null;
                    }
                    if (addDate == null || addDate.equalsIgnoreCase("null") || addDate.length() == 0) {
                        addDate = null;
                    }
                    if (addUser == null || addUser.equalsIgnoreCase("null") || addUser.length() == 0) {
                        addUser = null;
                    }
                    documentInfoXMLBuff.append("<TR><TD>" + docName + "</TD>");
                    documentInfoXMLBuff.append("<TD>" + docType + "</TD>");
                    documentInfoXMLBuff.append("<TD>" + addUser + "</TD>");
                    documentInfoXMLBuff.append("<TD>" + addDate + "</TD>");
                    documentInfoXMLBuff.append("<TD><a href = \"/ibase/WebITMDocumentHandlerServlet?REF_SER=" + refSer + "&OBJ_NAME=" + objName + "&REF_ID=" + refID + "&ACTION=GET_DOCUMENT&CLIENT=WEB1&DOC_ID=" + docId + "&DOC_TYPE=" + docType + "\">Download</a></TD></TR>");
                }
                documentInfoXMLBuff.append("</TABLE>");
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException: DBAccess: getDocumentInfoList:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: DBAccess: getDocumentInfoList:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: DBAccess: getElemItemChangeList \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return documentInfoXMLBuff.toString();
    }

    @Override
    public boolean getAttachmentsInfo(String refId, String refSer, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver mConnDriver = new ConnDriver();
        Connection mConn = null;
        Statement pStamt = null;
        ResultSet rs = null;
        boolean flag = false;
        String transDB = "";
        try {
            try {
                transDB = userInfo.getTransDB();
                mConn = mConnDriver.getConnectDB(transDB);
                String query = "SELECT * FROM DOC_TRANSACTION_LINK WHERE REF_ID='" + refId + "' AND REF_SER='" + refSer + "'";
                pStamt = mConn.prepareStatement(query);
                rs = pStamt.executeQuery();
                if (rs.next()) {
                    flag = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : " + e.getMessage());
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStamt != null) {
                        pStamt.close();
                        pStamt = null;
                    }
                    if (mConn != null) {
                        mConn.close();
                        mConn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStamt != null) {
                    pStamt.close();
                    pStamt = null;
                }
                if (mConn != null) {
                    mConn.close();
                    mConn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage());
            }
        }
        return flag;
    }

    @Override
    public boolean isEditable(String objName, String pkValues, UserInfoBean userInfo) throws ITMException {
        boolean isEditable = true;
        Connection mConn = null;
        Statement pStamt = null;
        ResultSet rs = null;
        String transDB = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            String colName = (String)objDetailMap.get("CONFIRM_COL");
            String cofColVal = (String)objDetailMap.get("CONFIRM_VAL");
            String tranIdCol = (String)objDetailMap.get("TRAN_ID_COL");
            String tableName = (String)objDetailMap.get("TABLE_NAME");
            String attachAllow = (String)objDetailMap.get("ALLOW_ATTACH");
            if (!"1".equalsIgnoreCase(attachAllow) || cofColVal == null || colName == null || tranIdCol == null || tableName == null) {
                BaseLogger.log("3", userInfo, null, "confirmation checks not set.. check TRANSETUP");
                return true;
            }
            try {
                String tempFlag;
                ConnDriver mConnDriver = new ConnDriver();
                mConn = mConnDriver.getConnectDB(transDB);
                String query = "SELECT " + colName + " FROM " + tableName + " WHERE " + tranIdCol + "='" + pkValues + "'";
                BaseLogger.log("3", userInfo, null, "query[" + query + "]");
                pStamt = mConn.prepareStatement(query);
                rs = pStamt.executeQuery();
                if (rs.next() && (tempFlag = rs.getString(1)).equalsIgnoreCase(cofColVal)) {
                    isEditable = false;
                }
                BaseLogger.log("3", userInfo, null, "isEditable [" + isEditable + "]");
                dbAccess = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : MasterStatefulEJB : isEditable :" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStamt != null) {
                    pStamt.close();
                    pStamt = null;
                }
                if (mConn != null) {
                    mConn.close();
                    mConn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage());
            }
        }
        return isEditable;
    }

    private boolean isWorkflowPending(String objName, boolean isWrkflwToBeInitiated, String pkValues, UserInfoBean userInfo) throws ITMException {
        boolean isExists = false;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            if (isWrkflwToBeInitiated) {
                Class[] paramSpec = new Class[4];
                Object[] params = new String[4];
                paramSpec[0] = Class.forName("java.lang.String");
                paramSpec[1] = Class.forName("java.lang.String");
                paramSpec[2] = Class.forName("java.lang.String");
                paramSpec[3] = Class.forName("java.lang.String");
                params[0] = (String)objDetailMap.get("WRKFLW_INIT");
                params[1] = objName;
                params[2] = (String)objDetailMap.get("REF_SER");
                params[3] = pkValues;
                WorkflowProcessInstanceMonitorEJB comp = null;
                comp = new WorkflowProcessInstanceMonitorEJB();
                Class<?> classObj = Class.forName(comp.getClass().getName());
                Method metObj = classObj.getMethod("getProcessStatus", paramSpec);
                metObj.setAccessible(true);
                String returnValue = (String)metObj.invoke((Object)comp, params);
                if ("P".equalsIgnoreCase(returnValue)) {
                    isExists = true;
                }
            }
            dbAccess = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("0", userInfo, null, "Returning Process Exists Status :[" + isExists + "]");
        return isExists;
    }

    @Override
    public String updateDocumentType(HashMap dataMap, String transDB) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "Document Handler ejb called" + dataMap);
        String retStr = "Failure";
        int j = -1;
        Connection con = null;
        PreparedStatement pstmt = null;
        int size = dataMap.size() / 2;
        BaseLogger.log("3", this.userInfo, null, "size = " + size);
        int i = 0;
        while (i < size) {
            con = this.getConnection(transDB);
            BaseLogger.log("3", this.userInfo, null, "docId = " + (String)dataMap.get("DOC_ID" + i));
            BaseLogger.log("3", this.userInfo, null, "docType = " + (String)dataMap.get("DOC_TYPE" + i));
            String docId = (String)dataMap.get("DOC_ID" + i);
            String docType = (String)dataMap.get("DOC_TYPE" + i);
            if (docId != null && docType != null) {
                try {
                    try {
                        String updateQuery = "UPDATE DOC_CONTENTS SET DOC_TYPE = ?  WHERE DOC_ID = ?";
                        pstmt = con.prepareStatement(updateQuery);
                        pstmt.setString(1, docType);
                        pstmt.setString(2, docId);
                        j = pstmt.executeUpdate();
                        if (j != -1) {
                            retStr = "Success";
                        }
                        con.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new ITMException(e);
                    }
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (con != null) {
                            con.close();
                            con = null;
                        }
                    }
                    catch (Exception e) {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                                throw new ITMException(e1);
                            }
                            con = null;
                        }
                        BaseLogger.log("3", this.userInfo, null, "Exception :" + e.getMessage());
                    }
                }
            }
            ++i;
        }
        BaseLogger.log("2", this.userInfo, null, "retStr = " + retStr);
        return retStr;
    }

    @Override
    public String getDocType(UserInfoBean userInfo) throws RemoteException, ITMException {
        StringBuffer documentInfoXMLBuff;
        block27: {
            Statement pstmt = null;
            ResultSet resultSet = null;
            Connection mConnection = null;
            documentInfoXMLBuff = new StringBuffer();
            String transDB = "";
            try {
                try {
                    transDB = userInfo.getTransDB();
                    ConnDriver mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    String mQuery = "SELECT DOC_TYPE FROM DOCTYPE";
                    pstmt = mConnection.prepareStatement(mQuery);
                    resultSet = pstmt.executeQuery(mQuery);
                    while (resultSet.next()) {
                        documentInfoXMLBuff.append("<TypesAvailable><![CDATA[" + resultSet.getString("DOC_TYPE") + "]]></TypesAvailable>\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        if (mConnection != null) {
                            try {
                                mConnection.close();
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                                throw new ITMException(e1);
                            }
                            mConnection = null;
                        }
                        BaseLogger.log("3", userInfo, null, "Exception :" + e2.getMessage());
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    if (mConnection != null) {
                        try {
                            mConnection.close();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                            throw new ITMException(e1);
                        }
                        mConnection = null;
                    }
                    BaseLogger.log("3", userInfo, null, "Exception :" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                if (mConnection != null) {
                    try {
                        mConnection.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        throw new ITMException(e1);
                    }
                    mConnection = null;
                }
                BaseLogger.log("3", userInfo, null, "Exception :" + e.getMessage());
            }
        }
        BaseLogger.log("2", userInfo, null, "RESULT = " + documentInfoXMLBuff.toString());
        return documentInfoXMLBuff.toString();
    }

    protected void tagCollabDocuments(String postId, String docId, PreparedStatement docTransactionLinkStatement, String transDB) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "[" + this.getClass().getSimpleName() + "] Tagging post with transactions: postId: " + postId + ", docId: " + docId);
        String query = "SELECT WIN_NAME, REF_NO FROM COLLAB_TAGS WHERE GROUP_ID IN (SELECT GROUP_ID__COLLAB FROM COLLAB_POSTS WHERE POST_ID = '" + postId + "')";
        try {
            Connection connection = null;
            Statement selectStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    try {
                        connection = this.getConnection(transDB);
                        connection.setAutoCommit(false);
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                    selectStatement = connection.prepareStatement(query);
                    resultSet = selectStatement.executeQuery();
                    while (resultSet.next()) {
                        String refSer;
                        String refNo;
                        block20: {
                            refNo = resultSet.getString("REF_NO");
                            if (refNo == null || "".equals(refNo.trim())) continue;
                            String winName = resultSet.getString("WIN_NAME");
                            if (winName == null || !winName.toLowerCase().startsWith("w_")) {
                                throw new RuntimeException("Win name is improper: " + winName);
                            }
                            query = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName + "'";
                            PreparedStatement selectStatement2 = connection.prepareStatement(query);
                            refSer = null;
                            try (ResultSet resultSet2 = selectStatement2.executeQuery();){
                                if (resultSet2.next()) {
                                    refSer = resultSet2.getString("REF_SER");
                                    break block20;
                                }
                                throw new RuntimeException("REF_SER not found for TRAN_WINDOW: " + winName);
                            }
                        }
                        docTransactionLinkStatement.setString(1, docId);
                        docTransactionLinkStatement.setString(2, refSer);
                        docTransactionLinkStatement.setString(3, refNo);
                        docTransactionLinkStatement.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (selectStatement != null) {
                    selectStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        catch (RuntimeException e) {
            throw new ITMException(e);
        }
    }

    @Override
    public String addDocument(String xmlString, File file, String transDB) throws RemoteException, ITMException {
        BufferedInputStream bfr = null;
        ByteArrayOutputStream bout = null;
        String retString = null;
        byte[] byteArray = null;
        try {
            try {
                FileInputStream input = new FileInputStream(file);
                bfr = new BufferedInputStream(input);
                bout = new ByteArrayOutputStream();
                int i = -1;
                while ((i = bfr.read()) != -1) {
                    bout.write(i);
                }
                byteArray = bout.toByteArray();
                retString = this.addDocument(xmlString, byteArray, null, this.userInfo);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (bfr != null) {
                        bfr.close();
                        bfr = null;
                    }
                    if (bout != null) {
                        bout.close();
                        bout = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bfr != null) {
                        bfr.close();
                        bfr = null;
                    }
                    if (bout != null) {
                        bout.close();
                        bout = null;
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
                if (bout != null) {
                    bout.close();
                    bout = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retString;
    }

    @Override
    public String getDocumentFile(String docId, String transDB) throws RemoteException, ITMException {
        File dwnldBolbFile = null;
        Connection conn = null;
        Statement mPstmt = null;
        FileOutputStream outputFileOutputStream = null;
        InputStream blobInputStream = null;
        String dirName = "";
        String fileName = "";
        if (CommonConstants.J2EE_VERSION.equals("1")) {
            dirName = String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump";
        } else if (CommonConstants.J2EE_VERSION.equals("2")) {
            dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
        }
        fileName = String.valueOf(dirName) + File.separator + docId;
        BaseLogger.log("3", this.userInfo, null, "dirName[" + dirName + "]\n" + fileName);
        try {
            try {
                int selCount = -1;
                conn = this.getConnection(transDB);
                String selQry = "SELECT DOC_OBJECT, DOC_TYPE FROM DOC_CONTENTS WHERE DOC_ID =?";
                BaseLogger.log("3", this.userInfo, null, "selectQry :" + selQry);
                mPstmt = conn.prepareStatement(selQry);
                mPstmt.setString(1, docId);
                ResultSet rs = mPstmt.executeQuery();
                if (rs.next()) {
                    int chunkSize = 0;
                    String docType = rs.getString("DOC_TYPE");
                    docType = docType != null ? docType.trim() : "tmp";
                    Blob blobData = rs.getBlob("DOC_OBJECT");
                    if (blobData != null) {
                        blobInputStream = blobData.getBinaryStream();
                        chunkSize = "ORACLE".equalsIgnoreCase(this.database) ? ((BLOB)blobData).getChunkSize() : blobInputStream.available();
                        BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB :getDocumentFile:==> BlobData chunkSize :" + chunkSize);
                    } else {
                        blobInputStream = this.getDocumentInputStream(docId, transDB, this.userInfo, null, null);
                        chunkSize = blobInputStream.available();
                        BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB :getDocumentFile:==> BlobInputStream chunkSize :" + chunkSize);
                    }
                    fileName = String.valueOf(fileName) + "." + docType;
                    dwnldBolbFile = new File(fileName);
                    outputFileOutputStream = new FileOutputStream(dwnldBolbFile);
                    int bytesRead = 0;
                    int totBytesRead = 0;
                    int totBytesWritten = 0;
                    byte[] binaryBuffer = new byte[chunkSize];
                    while ((bytesRead = blobInputStream.read(binaryBuffer)) != -1) {
                        outputFileOutputStream.write(binaryBuffer, 0, bytesRead);
                        totBytesRead += bytesRead;
                        totBytesWritten += bytesRead;
                    }
                    outputFileOutputStream.close();
                    blobInputStream.close();
                    BaseLogger.log("3", this.userInfo, null, "\n==========================================================\n  INPUT STREAMS METHOD\n==========================================================\nWrote BLOB column data to file " + fileName + " = " + dwnldBolbFile.getName() + ".\n" + totBytesRead + " bytes read.\n" + totBytesWritten + " bytes written.\n");
                }
                rs.close();
                mPstmt.close();
                mPstmt = null;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", this.userInfo, null, "SQLException :DocumentHandlerEJB :getDocument:==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB :getDocument :==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return fileName;
    }

    @Override
    public void updateAttachments(String tranId, String attachmentString, boolean isSaved, UserInfoBean userInfo) throws ITMException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String transDB = userInfo.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                Document dom = genericUtility.parseString(attachmentString);
                Node node = dom.getElementsByTagName("ATTACHMENTS").item(0);
                String tempTranId = "";
                if (node != null) {
                    tempTranId = node.getAttributes().getNamedItem("editorId").getNodeValue();
                    NodeList attachmentList = node.getChildNodes();
                    int attachmentListLen = attachmentList.getLength();
                    int cnt = 0;
                    cnt = 0;
                    while (cnt < attachmentListLen) {
                        Node attachmentNode = attachmentList.item(cnt);
                        String attachmentFlag = "";
                        if (attachmentNode != null) {
                            AppConnectParm appConnect = new AppConnectParm();
                            InitialContext ctx = new InitialContext(appConnect.getProperty());
                            DBAccessEJB dbAccess = new DBAccessEJB();
                            attachmentFlag = attachmentNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                            String docId = genericUtility.getColumnValueFromNode("doc_id", attachmentNode);
                            String objName = genericUtility.getColumnValueFromNode("obj_name", attachmentNode);
                            String refCol = genericUtility.getColumnValueFromNode("ref_col", attachmentNode);
                            String currentRefId = genericUtility.getColumnValueFromNode("ref_id", attachmentNode);
                            String refSer = dbAccess.getRefSer(conn, objName);
                            BaseLogger.log("3", userInfo, null, "attachmentFlag[" + attachmentFlag + "]");
                            BaseLogger.log("3", userInfo, null, "docId[" + docId + "]");
                            BaseLogger.log("3", userInfo, null, "objName[" + objName + "]");
                            BaseLogger.log("3", userInfo, null, "refCol[" + refCol + "]");
                            BaseLogger.log("3", userInfo, null, "currentRefId[" + currentRefId + "]");
                            if (isSaved) {
                                if ("D".equalsIgnoreCase(attachmentFlag)) {
                                    this.removeAttach(docId, refSer, currentRefId, objName, refCol, userInfo);
                                } else if ("A".equalsIgnoreCase(attachmentFlag) && tempTranId != null && tempTranId.trim().length() > 0 && !tempTranId.trim().equalsIgnoreCase(tranId.trim())) {
                                    String refId = currentRefId.replaceFirst(tempTranId, tranId);
                                    System.err.println("refId>>>>[" + refId + "]");
                                    String sql = "UPDATE DOC_TRANSACTION_LINK SET REF_ID='" + refId.trim() + "' WHERE REF_ID = '" + currentRefId.trim() + "' AND " + "REF_SER = '" + refSer + "' AND DOC_ID= '" + docId + "' AND REF_COL='" + refCol + "' ";
                                    pstmt = conn.prepareStatement(sql);
                                    int counter = pstmt.executeUpdate();
                                    BaseLogger.log("3", userInfo, null, "RowUpdated count[" + counter + "]");
                                    pstmt.close();
                                    pstmt = null;
                                }
                            } else if ("A".equalsIgnoreCase(attachmentFlag)) {
                                this.removeAttach(docId, refSer, currentRefId, objName, refCol, userInfo);
                            }
                            dbAccess = null;
                        }
                        ++cnt;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception : :==>\n" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    @Override
    public boolean isAuthorizedToDelete(String docId, String userLevel, String profileId, String loginCode, String objName, String transDB) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String sql = "";
        boolean isAuthorized = false;
        String documentAddedBy = "";
        try {
            try {
                if ("0".equalsIgnoreCase(userLevel)) {
                    isAuthorized = true;
                } else {
                    sql = " SELECT ADD_USER FROM DOC_CONTENTS WHERE DOC_ID = ?";
                    conn = connDriver.getConnectDB(transDB);
                    pStmt = conn.prepareStatement(sql);
                    pStmt.setString(1, docId);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        String string = documentAddedBy = rs.getString("ADD_USER") == null ? "" : rs.getString("ADD_USER");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (loginCode != null) {
                        loginCode = loginCode.trim();
                    }
                    if (documentAddedBy != null) {
                        documentAddedBy = documentAddedBy.trim();
                    }
                    isAuthorized = loginCode.equals(documentAddedBy);
                }
                BaseLogger.log("3", this.userInfo, null, "In isAuthorizedToDelete : isAuthorized[" + isAuthorized + "]");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB : isAuthorizedToDelete()" + e.getMessage());
                    throw new ITMException(e);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB : isAuthorizedToDelete()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return isAuthorized;
    }

    private String getUUIDRefID(String refSer, String refID, Connection conn) throws ITMException {
        String uuiddRefID = "";
        PreparedStatement pstmtUUID = null;
        ResultSet rsUUID = null;
        try {
            try {
                String uuidSql = "SELECT UUID_REFID FROM DOC_TRANSACTION_LINK WHERE REF_SER = ? AND REF_ID = ?";
                pstmtUUID = conn.prepareStatement(uuidSql);
                pstmtUUID.setString(1, refSer);
                pstmtUUID.setString(2, refID);
                rsUUID = pstmtUUID.executeQuery();
                if (rsUUID.next()) {
                    uuiddRefID = rsUUID.getString("UUID_REFID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rsUUID != null) {
                    rsUUID.close();
                    rsUUID = null;
                }
                if (pstmtUUID != null) {
                    pstmtUUID.close();
                    pstmtUUID = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB : getUUIDRefID()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", this.userInfo, null, "uuiddRefID >> getUUIDRefID >> DocumentHandlerWrapperEJB =[" + uuiddRefID + "]");
        return uuiddRefID;
    }

    @Override
    public String docAddedBy(String docId, String transDB) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String sql = "";
        String documentAddedBy = "";
        try {
            try {
                conn = connDriver.getConnectDB(transDB);
                sql = " SELECT ADD_USER FROM DOC_CONTENTS WHERE DOC_ID = ?";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, docId);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    documentAddedBy = rs.getString("ADD_USER") == null ? "" : rs.getString("ADD_USER");
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                conn.close();
                if (documentAddedBy != null) {
                    documentAddedBy = documentAddedBy.trim();
                }
                BaseLogger.log("3", this.userInfo, null, "documentAddedBy = [" + documentAddedBy + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : DocumentHandlerWrapperEJB : docAddedBy()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :" + e.getMessage());
            }
        }
        return documentAddedBy;
    }

    @Override
    public String getBulkAttachment(String objName, String advQuery, UserInfoBean userInfo) throws RemoteException, ITMException {
        String tagName = "Detail";
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        String tranIdCol = null;
        String refSer = null;
        String tblName = null;
        Statement mStmt = null;
        Statement mStmt1 = null;
        Statement mStmt2 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String sql2 = null;
        String tranIdColVal = "'";
        boolean count = false;
        StringBuffer bulkDeleteBuff = null;
        String winName = "w_" + objName;
        String transDB = "";
        try {
            try {
                if (advQuery == null || "null".equalsIgnoreCase(advQuery)) {
                    advQuery = "";
                }
                mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                BaseLogger.log("3", userInfo, null, "repositoryHandler object in getBulkAttachment --- ");
                String sql = "SELECT TRAN_ID_COL, REF_SER , TABLE_NAME FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName + "' ";
                BaseLogger.log("3", userInfo, null, "Final query generated (1): " + sql);
                mStmt = mConnection.createStatement();
                rs = mStmt.executeQuery(sql);
                bulkDeleteBuff = new StringBuffer();
                while (rs.next()) {
                    tranIdCol = rs.getString("TRAN_ID_COL");
                    refSer = rs.getString("REF_SER");
                    tblName = rs.getString("TABLE_NAME");
                    BaseLogger.log("3", userInfo, null, "TRAN_ID_COL IS================= " + tranIdCol);
                    BaseLogger.log("3", userInfo, null, "REF_SER IS================== " + refSer);
                }
                mStmt.close();
                tranIdCol = tranIdCol.replaceAll(":", "||':'||");
                BaseLogger.log("3", userInfo, null, "TRAN_ID_COL ================= " + tranIdCol);
                String sql1 = "SELECT " + tranIdCol + " FROM " + tblName + " WHERE " + advQuery + " ";
                BaseLogger.log("3", userInfo, null, "Final query generated (1): " + sql1);
                mStmt1 = mConnection.createStatement();
                rs1 = mStmt1.executeQuery(sql1);
                bulkDeleteBuff.append("\n<Document>");
                sql2 = "SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_TYPE,CHG_DATE,CHG_USER,ADD_DATE,ADD_USER,USER_ID__CHKOUT FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_ID IN(" + sql1 + ")";
                BaseLogger.log("3", userInfo, null, "Final query generated (3): " + sql2);
                mStmt2 = mConnection.createStatement();
                rs2 = mStmt2.executeQuery(sql2);
                while (rs2.next()) {
                    String docId = rs2.getString("DOC_ID");
                    String docName = rs2.getString("DOC_NAME");
                    String docType = rs2.getString("DOC_TYPE");
                    String chgDate = rs2.getString("CHG_DATE");
                    String chgUser = rs2.getString("CHG_USER");
                    String addDate = rs2.getString("ADD_DATE");
                    String addUser = rs2.getString("ADD_USER");
                    String usrIdChkout = rs2.getString("USER_ID__CHKOUT");
                    bulkDeleteBuff.append("<" + tagName + 1 + ">\n");
                    bulkDeleteBuff.append("<Document_Id><![CDATA[" + docId + "]]></Document_Id>\n");
                    bulkDeleteBuff.append("<Name><![CDATA[" + docName + "]]></Name>\n");
                    bulkDeleteBuff.append("<Type><![CDATA[" + docType + "]]></Type>\n");
                    bulkDeleteBuff.append("<Last_Modified><![CDATA[" + chgDate + "]]></Last_Modified>\n");
                    bulkDeleteBuff.append("<Modified_By><![CDATA[" + chgUser + "]]></Modified_By>\n");
                    bulkDeleteBuff.append("<Created_Date><![CDATA[" + addDate + "]]></Created_Date>\n");
                    bulkDeleteBuff.append("<Created_By><![CDATA[" + addUser + "]]></Created_By>\n");
                    bulkDeleteBuff.append("<CheckOut><![CDATA[" + usrIdChkout + "]]></CheckOut>\n");
                    bulkDeleteBuff.append("</" + tagName + 1 + ">\n");
                }
                mStmt2.close();
                mStmt2 = null;
                mStmt1.close();
                mStmt1 = null;
                bulkDeleteBuff.append("\n</Document>");
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException: DBAccess: getBulkAttachment:");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: DBAccess: getBulkAttachment:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: DBAccess: getBulkAttachment \n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "bulkDeleteBuff IS================= " + bulkDeleteBuff.toString());
        return bulkDeleteBuff.toString();
    }

    @Override
    public String deleteBulkAttachments(String id, String userCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        String sql = "";
        String documentName = "";
        String transDB = "";
        try {
            try {
                id = id.replaceAll(":", "','");
                id = id.substring(0, id.length() - 3);
                transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                sql = " SELECT DOC_NAME, DOC_ID FROM DOC_CONTENTS WHERE DOC_ID in ('" + id + "')";
                pStmt = conn.prepareStatement(sql);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String docId;
                    documentName = rs.getString("DOC_NAME") == null ? "" : rs.getString("DOC_NAME");
                    String string = docId = rs.getString("DOC_ID") == null ? "" : rs.getString("DOC_ID");
                    if (documentName != null) {
                        this.deleteAuditTrailDocAttachments(docId, conn);
                        documentName = documentName.trim();
                        String delQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID ='" + docId + "'";
                        BaseLogger.log("3", userInfo, null, "Execute --- " + delQry);
                        PreparedStatement pStmt2 = conn.prepareStatement(delQry);
                        int deletedRow = pStmt2.executeUpdate();
                        pStmt2.close();
                        pStmt2 = null;
                        String insertQry = "INSERT INTO DOC_TRANS_DEL_LOG( doc_id, del_user, del_date, doc_name ) VALUES(?, ?, ?, ?)";
                        PreparedStatement pStmt3 = conn.prepareStatement(insertQry);
                        pStmt3.setString(1, docId.trim());
                        pStmt3.setString(2, userCode);
                        pStmt3.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                        pStmt3.setString(4, documentName.trim());
                        int noOfRows = pStmt3.executeUpdate();
                        pStmt3.close();
                        pStmt3 = null;
                    }
                    BaseLogger.log("3", userInfo, null, "documentName = [" + documentName + "]");
                }
                conn.commit();
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                conn.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : DocumentHandlerWrapperEJB : docAddedBy()" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage());
            }
        }
        return "success";
    }

    @Override
    public void updateCountOfAttachments(String objName, String refId, String refSer, Connection conn, String transDB) throws ITMException {
        ConnDriver mConnDriver = new ConnDriver();
        Statement pStamt = null;
        ResultSet resultSet = null;
        boolean localConn = false;
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "In updateCountOfAttachments - objName = [" + objName + "] refId = [" + refId + "] refSer = [" + refSer + "]");
                if (conn == null) {
                    conn = mConnDriver.getConnectDB(transDB);
                    localConn = true;
                }
                String tranIdCol = "";
                String tableName = "";
                String tranWin = "";
                if (this.checkNull(objName).length() > 0) {
                    BaseLogger.log("3", this.userInfo, null, "in if objName = [" + objName + "]");
                    AppConnectParm appConnect = new AppConnectParm();
                    InitialContext ctx = new InitialContext(appConnect.getProperty());
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    HashMap objDetailMap = dbAccess.getObjDetailMap(objName, transDB);
                    tranIdCol = (String)objDetailMap.get("TRAN_ID_COL");
                    tableName = (String)objDetailMap.get("TABLE_NAME");
                    dbAccess = null;
                } else if (this.checkNull(refSer).length() > 0) {
                    BaseLogger.log("3", this.userInfo, null, "in else objName = [" + objName + "]");
                    String sql = "SELECT TRAN_WINDOW, TRAN_ID_COL, TABLE_NAME FROM TRANSETUP WHERE REF_SER = ? ";
                    pStamt = conn.prepareStatement(sql);
                    pStamt.setString(1, refSer);
                    resultSet = pStamt.executeQuery();
                    if (resultSet.next()) {
                        tranWin = resultSet.getString(1);
                        tranIdCol = resultSet.getString(2);
                        tableName = resultSet.getString(3);
                    }
                    pStamt.close();
                    pStamt = null;
                    resultSet.close();
                    resultSet = null;
                    BaseLogger.log("3", this.userInfo, null, "tranWin = [" + tranWin + "] tranIdCol = [" + tranIdCol + "] tableName = [" + tableName + "]");
                    if (this.checkNull(tranWin).length() > 0) {
                        objName = tranWin.replace("w_", "");
                    }
                }
                BaseLogger.log("3", this.userInfo, null, "objName = [" + objName + "] tranIdCol = [" + tranIdCol + "] tableName = [" + tableName + "]");
                if (this.checkNull(objName).length() > 0 && tableName != null && tableName.trim().length() > 0 && tranIdCol != null && tranIdCol.trim().length() > 0) {
                    BaseLogger.log("3", this.userInfo, null, "in if tableName = [" + tableName + "] tranIdCol = [" + tranIdCol + "]");
                    DatabaseMetaData metadata = conn.getMetaData();
                    resultSet = metadata.getTables(null, null, tableName.toUpperCase(), null);
                    if (resultSet.next()) {
                        BaseLogger.log("3", this.userInfo, null, "[" + tableName + "] -- table exists");
                        resultSet.close();
                        resultSet = null;
                        resultSet = metadata.getColumns(null, null, tableName.toUpperCase(), "NO_ATTACHMENTS");
                        if (resultSet.next()) {
                            String[] refIds;
                            String[] tranIdCols;
                            BaseLogger.log("3", this.userInfo, null, "[NO_ATTACHMENTS] -- column exists");
                            E12GenericUtility genericUtility = new E12GenericUtility();
                            if (tranIdCol.contains(":")) {
                                tranIdCol = tranIdCol.replaceAll(":", ",");
                            }
                            if ((tranIdCols = tranIdCol.split(",")).length == (refIds = refId.split("~")).length) {
                                StringBuffer advQuery = new StringBuffer(" WHERE ");
                                String sql = "SELECT " + tranIdCol + "  FROM " + tableName + " WHERE 1 = 2";
                                pStamt = conn.prepareStatement(sql);
                                ResultSet rs = pStamt.executeQuery();
                                ResultSetMetaData md = rs.getMetaData();
                                String columnNames = "";
                                String columnValue = "";
                                int i = 1;
                                while (i <= md.getColumnCount()) {
                                    columnNames = md.getColumnName(i);
                                    columnValue = E12GenericUtility.checkNull(refIds[i - 1]);
                                    if (md.getColumnTypeName(i).toUpperCase().indexOf("DATE") != -1 || md.getColumnTypeName(i).toUpperCase().indexOf("TIMESTAMP") != -1) {
                                        String string = columnValue = columnValue.length() > 0 ? genericUtility.getValidDateString(columnValue, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat()) : columnValue;
                                    }
                                    if (i == md.getColumnCount()) {
                                        advQuery.append(String.valueOf(columnNames) + " = '" + columnValue + "'");
                                    } else {
                                        advQuery.append(String.valueOf(columnNames) + " = '" + columnValue + "' AND ");
                                    }
                                    ++i;
                                }
                                if (pStamt != null) {
                                    pStamt.close();
                                    pStamt = null;
                                }
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                String query = "UPDATE " + tableName + " " + " SET NO_ATTACHMENTS = ( SELECT COUNT(*) FROM DOC_TRANSACTION_LINK WHERE REF_ID = ? AND REF_SER = ? AND (DELETE_FLAG <> 'Y' OR DELETE_FLAG is NULL) ) " + advQuery.toString();
                                pStamt = conn.prepareStatement(query);
                                pStamt.setString(1, refId);
                                pStamt.setString(2, refSer);
                                BaseLogger.log("3", this.userInfo, null, "query = [" + query + "]");
                                int updateCnt = pStamt.executeUpdate();
                                if (pStamt != null) {
                                    pStamt.close();
                                    pStamt = null;
                                }
                                if (localConn) {
                                    conn.commit();
                                    BaseLogger.log("3", this.userInfo, null, "Connection Commited....");
                                }
                                BaseLogger.log("3", this.userInfo, null, "updateCnt = [" + updateCnt + "]");
                            }
                        }
                        resultSet.close();
                        resultSet = null;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : DocumentHandlerWrapperEJB : updateCountOfAttachments :" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStamt != null) {
                    pStamt.close();
                    pStamt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (localConn && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    @Override
    public String removeMultiAttach(String docId, String refSer, String refId, String objName, String refCol, String loginCode, String chgTerm, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        Statement mPstmt = null;
        String selQry = null;
        try {
            try {
                BaseLogger.log("3", userInfo, null, "refCol in docHandler[" + refCol + "] transDB[" + transDB + "]");
                refCol = this.checkNull(refCol);
                conn = this.getConnection(transDB);
                this.deleteAuditTrailDocAttachments(docId, conn);
                selQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID IN (" + docId + ")";
                BaseLogger.log("3", userInfo, null, "Execute --- " + selQry);
                mPstmt = conn.prepareStatement(selQry);
                int deletedRow = mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                selQry = refCol.length() == 0 ? "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID IN (" + docId + ") AND REF_ID = '" + refId + "' AND REF_SER = '" + refSer + "'" : "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID IN (" + docId + ") AND REF_ID = '" + refId + "' AND REF_SER = '" + refSer + "' AND REF_COL='" + refCol + "'";
                mPstmt = conn.prepareStatement(selQry);
                int deletedTranRow = mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                this.updateCountOfAttachments(objName, refId, refSer, conn, transDB);
                BaseLogger.log("3", userInfo, null, "deletedRow - [" + deletedRow + "] : deletedTranRow - [" + deletedTranRow + "]");
                if (deletedRow == deletedTranRow) {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_deletedSuccessfully") + "[ <doc_title> ]</Detail></Root>";
                    conn.commit();
                    if (this.checkNull(retString).indexOf("Success") != -1) {
                        String auditTranId = "";
                        AppConnectParm appConnect = new AppConnectParm();
                        InitialContext ctx = new InitialContext(appConnect.getProperty());
                        AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
                        auditTranId = auditTrailExt.saveActionPerformedInAudit(objName, refId, "DELETE_ATTACHMENT", "DELETE_ATTACHMENT", loginCode, chgTerm, transDB, userInfo);
                        auditTrailExt.updateAuditResponse(auditTranId, "Success", retString, transDB);
                    }
                } else {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_deletedFailure") + "[ <doc_title> ]</Detail></Root>";
                    conn.rollback();
                }
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerEJB :removeMultiAttach:==>" + ie.getMessage());
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerEJB :removeMultiAttach :==>" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "In DocumentHandlerWrapperEJB : removeMultiAttach :retString[" + retString + "]");
        return retString;
    }

    @Override
    public int updateAttachRefId(String objName, String refId, String docId, String transDB) throws ITMException {
        int updateCount = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                String sql = "UPDATE DOC_TRANSACTION_LINK  SET REF_ID = ?  WHERE TRIM(REF_SER) = ( SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ? )  AND DOC_ID IN ( " + docId + " )";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refId);
                pstmt.setString(2, "w_" + objName);
                updateCount = pstmt.executeUpdate();
                if (updateCount > 0) {
                    conn.commit();
                }
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", this.userInfo, null, "updateCount : [" + updateCount + "]");
            }
            catch (SQLException e) {
                updateCount = 0;
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                updateCount = 0;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                conn.close();
                conn = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return updateCount;
    }

    @Override
    public String getFileConfigurationsMetadata(String objName, String transDB) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "DocumentHandlerWrapperEJB.getFileConfigurationsMetadata()");
        String retStr = null;
        String sqlQuery = null;
        Connection conn = null;
        ConnDriver connDriver = null;
        float MAX_FILE_SIZE = 0.0f;
        float valueOfMaxSize = 0.0f;
        int FILE_NAME_LENGTH = 0;
        String trackValidity = null;
        String allowDownload = null;
        JSONObject object = null;
        JSONArray JSONArrayData = new JSONArray();
        String RESTRICT_SPECIAL_CHAR = this.checkNull(CommonConstants.RESTRICT_SPECIAL_CHAR);
        BaseLogger.log("2", this.userInfo, null, "commonConstants =====>" + CommonConstants.MAX_FILE_SIZE);
        if (CommonConstants.MAX_FILE_SIZE != null && !"".equals(this.checkNull(CommonConstants.MAX_FILE_SIZE))) {
            MAX_FILE_SIZE = Float.parseFloat(CommonConstants.MAX_FILE_SIZE);
        }
        valueOfMaxSize = MAX_FILE_SIZE;
        if (CommonConstants.FILE_NAME_LENGTH != null && !"".equals(this.checkNull(CommonConstants.FILE_NAME_LENGTH))) {
            FILE_NAME_LENGTH = Integer.parseInt(CommonConstants.FILE_NAME_LENGTH);
        }
        try {
            try {
                sqlQuery = "SELECT OAC.MAX_FILE_SIZE, OAC.DOC_TYPE, DT.OBJ_NAME__IMP, OAC.FILE_TYPE, OAC.MIN_ATTACH_REQ, OAC.MAX_ATTACH_ALLOW, OAC.Allow_download, OAC.Track_validity \nFROM OBJ_ATTACH_CONFIG OAC, DOC_TYPE DT WHERE DT.DOC_TYPE=OAC.DOC_TYPE AND OBJ_NAME= ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                try {
                    Throwable throwable = null;
                    Object var16_19 = null;
                    try (PreparedStatement preparedStatement = conn.prepareStatement(sqlQuery);){
                        preparedStatement.setString(1, objName);
                        Throwable throwable2 = null;
                        Object var19_24 = null;
                        try (ResultSet resultSet = preparedStatement.executeQuery();){
                            while (resultSet.next()) {
                                BaseLogger.log("2", this.userInfo, null, "Inside resultSet =====>");
                                object = new JSONObject();
                                String MAX_SIZE_MB_from_DB = E12GenericUtility.checkNull(resultSet.getString("MAX_FILE_SIZE"));
                                BaseLogger.log("2", this.userInfo, null, "MAX_SIZE_MB_from_DB =====>" + MAX_SIZE_MB_from_DB + "==");
                                MAX_FILE_SIZE = MAX_SIZE_MB_from_DB != null && !"".equals(MAX_SIZE_MB_from_DB) ? Float.parseFloat(MAX_SIZE_MB_from_DB) : valueOfMaxSize;
                                String DOC_TYPE_FROM_DB = E12GenericUtility.checkNull(resultSet.getString("DOC_TYPE"));
                                String FILE_TYPE_FROM_DB = E12GenericUtility.checkNull(resultSet.getString("FILE_TYPE"));
                                String MIN_ATTACH_REQ_FROM_DB = E12GenericUtility.checkNull(resultSet.getString("MIN_ATTACH_REQ"));
                                String MAX_ATTACH_ALLOW_FROM_DB = E12GenericUtility.checkNull(resultSet.getString("MAX_ATTACH_ALLOW"));
                                trackValidity = E12GenericUtility.checkNull(resultSet.getString("Track_validity"));
                                allowDownload = E12GenericUtility.checkNull(resultSet.getString("Allow_download"));
                                String OBJ_NAME__IMP_FROM_DB = E12GenericUtility.checkNull(resultSet.getString("OBJ_NAME__IMP"));
                                BaseLogger.log("2", this.userInfo, null, "-MAX_FILE_SIZE  =====>" + MAX_FILE_SIZE + "==");
                                object.put("MAX_FILE_SIZE", MAX_FILE_SIZE);
                                object.put("FILE_NAME_LENGTH", FILE_NAME_LENGTH);
                                object.put("RESTRICT_SPECIAL_CHAR", (Object)RESTRICT_SPECIAL_CHAR);
                                object.put("DOC_TYPE", (Object)DOC_TYPE_FROM_DB);
                                object.put("FILE_TYPE", (Object)FILE_TYPE_FROM_DB);
                                object.put("MIN_ATTACH_REQ", (Object)MIN_ATTACH_REQ_FROM_DB);
                                object.put("MAX_ATTACH_ALLOW", (Object)MIN_ATTACH_REQ_FROM_DB);
                                object.put("Track_validity", (Object)trackValidity);
                                object.put("Allow_download", (Object)allowDownload);
                                object.put("OBJ_NAME__IMP", (Object)OBJ_NAME__IMP_FROM_DB);
                                BaseLogger.log("2", this.userInfo, null, "Object =====>" + object + ":::");
                                JSONArrayData.put((Object)object);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BaseLogger.log("2", this.userInfo, null, "JSONARRAYDATA =====>" + JSONArrayData + "==");
                retStr = JSONArrayData.toString();
                BaseLogger.log("2", this.userInfo, null, "retStr =====>" + retStr + "==");
            }
            catch (Exception ex) {
                throw new ITMException(ex);
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(conn);
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception while closing connection : " + ex);
            }
            throw throwable;
        }
        try {
            this.closeObject(conn);
        }
        catch (Exception ex) {
            BaseLogger.log("0", this.userInfo, null, "Exception while closing connection : " + ex);
        }
        return retStr;
    }

    @Override
    public String getAttachmentsMetaData(String objName, String refId, UserInfoBean userInfo, String isCLM) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "DocumentHandlerWrapperEJB :: getAttachmentsMetaData() : \nobjName[" + objName + "]" + "\nrefId[" + refId + "]");
        String retStr = null;
        String sqlQuery = null;
        String transDB = userInfo.getTransDB();
        String loginCode = userInfo.getLoginCode();
        Connection conn = null;
        ConnDriver connDriver = null;
        try {
            try {
                JSONObject obj;
                ResultSet resultSet;
                Object var20_34;
                Throwable throwable;
                PreparedStatement preparedStatement;
                Throwable throwable2;
                String docTypeAttch;
                Throwable throwable3;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("objName", (Object)objName);
                BaseLogger.log("3", userInfo, null, "jsonObject" + jsonObject);
                sqlQuery = "SELECT DOC_TYPE, MIN_ATTACH_REQ, MAX_ATTACH_ALLOW, FILE_TYPE, MAX_FILE_SIZE, META_DATA_DEF FROM OBJ_ATTACH_CONFIG WHERE OBJ_NAME= ? ORDER BY DISPLY_ORDER";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                JSONArray docTypesArray = new JSONArray();
                ArrayList<String> docTypesList = new ArrayList<String>();
                try {
                    Throwable throwable4 = null;
                    Object var15_20 = null;
                    try (PreparedStatement preparedStatement2 = conn.prepareStatement(sqlQuery);){
                        preparedStatement2.setString(1, objName);
                        throwable3 = null;
                        Object var18_29 = null;
                        try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                            while (resultSet2.next()) {
                                JSONObject docTypeInfo = new JSONObject();
                                String docType = E12GenericUtility.checkNull(resultSet2.getString("DOC_TYPE"));
                                docTypesList.add(docType);
                                docTypeInfo.put("docType", (Object)docType);
                                docTypeInfo.put("minAttachmentRequired", resultSet2.getInt("MIN_ATTACH_REQ"));
                                docTypeInfo.put("maxAttachmentAllowed", resultSet2.getInt("MAX_ATTACH_ALLOW"));
                                docTypeInfo.put("metaDataDef", (Object)resultSet2.getString("META_DATA_DEF"));
                                String fileType = resultSet2.getString("FILE_TYPE");
                                JSONArray fileTypeArray = new JSONArray();
                                if (fileType != null && !"".equals(fileType)) {
                                    StringTokenizer tokenizer = new StringTokenizer(fileType, ",");
                                    while (tokenizer.hasMoreTokens()) {
                                        String ft = this.checkNull(tokenizer.nextToken());
                                        if ("".equals(ft)) continue;
                                        fileTypeArray.put((Object)ft);
                                    }
                                }
                                docTypeInfo.put("contentType", (Object)fileTypeArray);
                                docTypesArray.put((Object)docTypeInfo);
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable4 == null) {
                            throwable4 = throwable6;
                        } else if (throwable4 != throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BaseLogger.log("3", userInfo, null, "@@@@ #1 generated array : [" + docTypesArray + "]");
                if (isCLM.equalsIgnoreCase("true")) {
                    sqlQuery = "SELECT COUNT(1) FROM user_doc_contents WHERE TRIM(DOC_TYPE)=? AND TRIM(USER_ID)=? AND DOC_STAT LIKE ?";
                    int i = 0;
                    while (i < docTypesList.size()) {
                        docTypeAttch = (String)docTypesList.get(i);
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            preparedStatement = conn.prepareStatement(sqlQuery);
                            try {
                                preparedStatement.setString(1, E12GenericUtility.checkNull(docTypeAttch));
                                preparedStatement.setString(2, E12GenericUtility.checkNull(loginCode));
                                preparedStatement.setString(3, "A");
                                throwable = null;
                                var20_34 = null;
                                try {
                                    resultSet = preparedStatement.executeQuery();
                                    try {
                                        if (resultSet.next()) {
                                            int attached = resultSet.getInt(1);
                                            obj = (JSONObject)docTypesArray.get(i);
                                            obj.put("attached", attached);
                                        }
                                    }
                                    finally {
                                        if (resultSet != null) {
                                            resultSet.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable7) {
                                    if (throwable == null) {
                                        throwable = throwable7;
                                    } else if (throwable != throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable2 == null) {
                                throwable2 = throwable8;
                            } else if (throwable2 != throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                            throw throwable2;
                        }
                        ++i;
                    }
                } else {
                    sqlQuery = "SELECT COUNT(1) FROM DOC_TRANSACTION_LINK WHERE TRIM(REF_ID)=? AND TRIM(REF_SER)=TRIM((SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW=?)) AND TRIM(DOC_TYPE_ATTACH)=? AND ( DELETE_FLAG is null or DELETE_FLAG <> 'Y') ";
                    int i = 0;
                    while (i < docTypesList.size()) {
                        docTypeAttch = (String)docTypesList.get(i);
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            preparedStatement = conn.prepareStatement(sqlQuery);
                            try {
                                preparedStatement.setString(1, E12GenericUtility.checkNull(refId));
                                preparedStatement.setString(2, "w_" + objName);
                                preparedStatement.setString(3, E12GenericUtility.checkNull(docTypeAttch));
                                throwable = null;
                                var20_34 = null;
                                try {
                                    resultSet = preparedStatement.executeQuery();
                                    try {
                                        if (resultSet.next()) {
                                            int attached = resultSet.getInt(1);
                                            obj = (JSONObject)docTypesArray.get(i);
                                            obj.put("attached", attached);
                                        }
                                    }
                                    finally {
                                        if (resultSet != null) {
                                            resultSet.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable9) {
                                    if (throwable == null) {
                                        throwable = throwable9;
                                    } else if (throwable != throwable9) {
                                        throwable.addSuppressed(throwable9);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable2 == null) {
                                throwable2 = throwable10;
                            } else if (throwable2 != throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            throw throwable2;
                        }
                        ++i;
                    }
                }
                BaseLogger.log("3", userInfo, null, "@@@@ #2 generated array : [" + docTypesArray + "]");
                jsonObject.put("docTypes", (Object)docTypesArray);
                retStr = jsonObject.toString();
                BaseLogger.log("3", userInfo, null, "@@@@ #3 final object : [" + jsonObject + "]");
            }
            catch (Exception ex) {
                throw new ITMException(ex);
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(conn);
            }
            catch (Exception ex) {
                BaseLogger.log("0", userInfo, null, "Exception while closing connection : " + ex);
                throw new ITMException(ex);
            }
            throw throwable;
        }
        try {
            this.closeObject(conn);
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "Exception while closing connection : " + ex);
            throw new ITMException(ex);
        }
        return retStr;
    }

    @Override
    public void updateRefId(String attachmentList, String refId, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection mConnection = null;
        Statement mPstmt = null;
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                String formatedDocId = new SocialComponentActionServlet().getFormattedDocId(E12GenericUtility.checkNull(attachmentList));
                BaseLogger.log("3", userInfo, null, "formatedDocId List ::::::::: " + formatedDocId);
                if (!"".equals(formatedDocId)) {
                    String updateQuery = "UPDATE DOC_TRANSACTION_LINK SET REF_ID = ? WHERE DOC_ID IN (" + formatedDocId + " )";
                    mPstmt = mConnection.prepareStatement(updateQuery);
                    mPstmt.setString(1, refId);
                    int updateCount = mPstmt.executeUpdate();
                    BaseLogger.log("3", userInfo, null, "Update ref_id count ::: " + updateCount);
                }
                mConnection.commit();
                mPstmt.close();
                mPstmt = null;
            }
            catch (ITMException e) {
                BaseLogger.log("0", userInfo, null, "updateRefId : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :DocumentHandlerWrapperEJB :updateRefId :==>finally" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "updateRefId : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e3) {
                    System.err.println("Exception :DocumentHandlerWrapperEJB :updateRefId :==>finally" + e3.getMessage());
                    throw new ITMException(e3);
                }
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DocumentHandlerWrapperEJB :updateRefId :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    @Override
    public void updateNoOfAttachmnets(String noOfAttachments, String refId, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection mConnection = null;
        Statement mPstmt = null;
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                String updateAttachCount = "UPDATE COLLAB_POSTS SET NO_ATTACHMENTS = ? WHERE POST_ID = ?";
                mPstmt = mConnection.prepareStatement(updateAttachCount);
                mPstmt.setString(1, noOfAttachments);
                mPstmt.setString(2, refId);
                int updateAttachCnt = mPstmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "Update Attached Cnt ::: " + updateAttachCnt);
                mConnection.commit();
                mPstmt.close();
                mPstmt = null;
            }
            catch (ITMException e) {
                BaseLogger.log("0", userInfo, null, "updateNoOfAttachments : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :DocumentHandlerWrapperEJB :updateNoOfAttachments :==>finally" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "updateNoOfAttachments : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e3) {
                    System.err.println("Exception :DocumentHandlerWrapperEJB :updateNoOfAttachments :==>finally" + e3.getMessage());
                    throw new ITMException(e3);
                }
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DocumentHandlerWrapperEJB :updateNoOfAttachments :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    @Override
    public void updateDoc(String docIds, String id, String postDescription, String refId, String groupId, String noOfAttachments, String docTypeAttach, String fileTypeAttach, String shareSource, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection mConnection = null;
        Statement mPstmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String noOfAttach = "";
        BaseLogger.log("2", userInfo, null, "docIds :::::" + docIds + "\nId :::: " + id + "postDescription :::::" + postDescription + "\nRef Id ::: " + refId + "\nGroup Id :::: " + groupId);
        BaseLogger.log("2", userInfo, null, "docTypeAttach :::::" + docTypeAttach + "\nfileTypeAttach Names :::: " + fileTypeAttach);
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                if (this.checkNull(id).trim().length() > 0) {
                    String sql = "SELECT NO_ATTACHMENTS FROM COLLAB_POSTS WHERE POST_ID = ?";
                    mPstmt = mConnection.prepareStatement(sql);
                    mPstmt.setString(1, id);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        noOfAttach = rs.getString("NO_ATTACHMENTS");
                    }
                    mPstmt.close();
                    mPstmt = null;
                    rs.close();
                    rs = null;
                } else {
                    noOfAttach = noOfAttachments;
                }
                String updateAttachCount = "UPDATE COLLAB_POSTS SET NO_ATTACHMENTS = ? WHERE POST_ID = ?";
                mPstmt = mConnection.prepareStatement(updateAttachCount);
                mPstmt.setString(1, noOfAttach);
                mPstmt.setString(2, refId);
                int updateAttachCnt = mPstmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "Update Attached Cnt ::: " + updateAttachCnt);
                mPstmt.close();
                mPstmt = null;
                if (this.checkNull(docIds).length() > 0) {
                    String[] docIdArr = docIds.split(",");
                    String[] docTypeArr = docTypeAttach.split(",");
                    String[] fileTypeArr = fileTypeAttach.split(",");
                    String[] docDescriptionArr = postDescription.split(",");
                    String insertQry = "INSERT INTO DOC_TRANSACTION_LINK(DOC_ID, REF_SER, REF_ID, FILE_LOC, DOC_TYPE_ATTACH, FILE_TYPE_ATTACH, REF_DESCR, DOC_UUID, DOCUMENT_PATH, DMS_TENANT) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    pstmt = mConnection.prepareStatement(insertQry);
                    mConnection.setAutoCommit(false);
                    int i = 0;
                    while (i < docIdArr.length) {
                        String docuId = docIdArr[i];
                        Map<String, String> alfrescoFileDetails = this.getAlfrescoFileDetailMap(shareSource, docuId, userInfo.getLoginCode(), mConnection);
                        String fileLocation = alfrescoFileDetails.get("FILE_LOC");
                        String documentUUID = alfrescoFileDetails.get("DOC_UUID");
                        String documentPath = alfrescoFileDetails.get("DOCUMENT_PATH");
                        String dmsTenant = alfrescoFileDetails.get("DMS_TENANT");
                        String fileType = fileTypeArr[i].substring(fileTypeArr[i].lastIndexOf(".") + 1);
                        String refDumId = String.valueOf(refId) + "~" + groupId;
                        pstmt.setString(1, docuId);
                        pstmt.setString(2, "COLPST");
                        pstmt.setString(3, refDumId);
                        pstmt.setString(4, fileLocation);
                        pstmt.setString(5, docTypeArr[i]);
                        pstmt.setString(6, fileType);
                        pstmt.setString(7, docDescriptionArr[i]);
                        pstmt.setString(8, documentUUID);
                        pstmt.setString(9, documentPath);
                        pstmt.setString(10, dmsTenant);
                        pstmt.addBatch();
                        ++i;
                    }
                    int[] updateCnt = pstmt.executeBatch();
                    BaseLogger.log("3", userInfo, null, "Update Count :: using Batch " + updateCnt);
                    mConnection.commit();
                    pstmt.close();
                    pstmt = null;
                }
                mConnection.commit();
            }
            catch (ITMException e) {
                BaseLogger.log("0", userInfo, null, "updateDoc : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB :updateDoc :==>finally" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "updateDoc : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (mConnection != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e3) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB :updateDoc :==>finally" + e3.getMessage());
                    throw new ITMException(e3);
                }
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                        pstmt.close();
                        pstmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB :updateDoc :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
    }

    @Override
    public String getDocUsageData(String docIds, String tranDB) throws RemoteException, Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String docUsageDataJSONString = "";
        try {
            ConnDriver connDriver = new ConnDriver();
            String formattedDocIds = this.getFormattedDocIdsString(docIds);
            String sqlQuery = this.getDocUsageLogQuery(formattedDocIds);
            connection = connDriver.getConnectDB(tranDB);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            docUsageDataJSONString = this.getDocUsageDataJSONString(resultSet);
        }
        catch (Throwable throwable) {
            this.closeObject(resultSet);
            this.closeObject(statement);
            this.closeObject(connection);
            throw throwable;
        }
        this.closeObject(resultSet);
        this.closeObject(statement);
        this.closeObject(connection);
        return docUsageDataJSONString;
    }

    private String getFormattedDocIdsString(String docIds) {
        if (docIds == null) {
            return "";
        }
        String[] docIdArray = docIds.split(",");
        String formattedDocIdsString = "";
        String[] stringArray = docIdArray;
        int n = docIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            String docId = stringArray[n2];
            if (docId != null && !"".equals(docId)) {
                formattedDocIdsString = String.valueOf(formattedDocIdsString) + "'" + docId + "',";
            }
            ++n2;
        }
        if (formattedDocIdsString.length() > 0) {
            formattedDocIdsString = formattedDocIdsString.substring(0, formattedDocIdsString.length() - 1);
        }
        return formattedDocIdsString;
    }

    private String getDocUsageLogQuery(String formattedDocIds) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT U.CODE, U.NAME, DC.DOC_NAME, DC.DOC_TYPE, DUL.START_TIME, DUL.END_TIME, DUL.TOTAL_TIME, DUL.USAGE_DETAIL_DATA ").append("FROM DOC_USAGE_LOG DUL INNER JOIN USERS U ").append("ON RTRIM(U.CODE) = RTRIM(DUL.USER_ID) INNER JOIN DOC_CONTENTS DC ").append("ON RTRIM(DC.DOC_ID) = RTRIM(DUL.DOC_ID) WHERE DUL.DOC_ID IN (" + formattedDocIds + ") ").append("ORDER BY DUL.START_TIME DESC");
        return query.toString();
    }

    private String getDocUsageDataJSONString(ResultSet resultSet) throws SQLException, JSONException {
        JSONObject docUsageDataJSONObject = new JSONObject();
        JSONArray docUsageDataArray = new JSONArray();
        docUsageDataJSONObject.put("DATA", (Object)docUsageDataArray);
        while (resultSet.next()) {
            String userId = resultSet.getString("CODE");
            String userName = resultSet.getString("NAME");
            String docName = resultSet.getString("DOC_NAME");
            String fileType = resultSet.getString("DOC_TYPE");
            Timestamp startTimeStamp = resultSet.getTimestamp("START_TIME");
            Timestamp endTimeStamp = resultSet.getTimestamp("END_TIME");
            long totalTime = resultSet.getLong("TOTAL_TIME");
            String detailUsageData = resultSet.getString("USAGE_DETAIL_DATA");
            JSONObject detailUsageDataJSONObject = new JSONObject(detailUsageData);
            JSONObject docData = new JSONObject();
            docData.put("USER_ID", (Object)userId);
            docData.put("USER_NAME", (Object)userName);
            docData.put("DOC_NAME", (Object)docName);
            docData.put("FILE_TYPE", (Object)fileType);
            docData.put("START_TIME", startTimeStamp != null ? startTimeStamp.getTime() : 0L);
            docData.put("END_TIME", endTimeStamp != null ? endTimeStamp.getTime() : 0L);
            docData.put("TOTAL_TIME", totalTime);
            docData.put("DETAIL_USAGE_DATA", (Object)detailUsageDataJSONObject);
            docUsageDataArray.put((Object)docData);
        }
        return docUsageDataJSONObject.toString();
    }

    @Override
    public int saveDocUsageData(String details, UserInfoBean userInfoBean) throws Exception {
        int updateCount = 0;
        JSONObject jsnObj = new JSONObject(details);
        Connection conn = null;
        PreparedStatement pstmt = null;
        long start = 0L;
        long pause = 0L;
        long end = 0L;
        String userId = userInfoBean.getLoginCode();
        String docId = (String)jsnObj.get("DOC_ID");
        String docType = "";
        String deviceId = "";
        String useSource = "";
        String deviceType = "";
        String accLocation = "";
        docType = jsnObj.has("DOC_TYPE") ? (String)jsnObj.get("DOC_TYPE") : "Presentation";
        useSource = jsnObj.has("USE_SOURCE") ? (String)jsnObj.get("USE_SOURCE") : "";
        if (jsnObj.has("DEVICE_ID")) {
            deviceId = (String)jsnObj.get("DEVICE_ID");
        } else if (userInfoBean != null) {
            deviceId = userInfoBean.getDeviceID();
        }
        if (jsnObj.has("DEVICE_TYPE")) {
            deviceType = (String)jsnObj.get("DEVICE_TYPE");
        } else if (userInfoBean != null) {
            deviceType = userInfoBean.getDeviceType();
        }
        accLocation = jsnObj.has("ACC_LOCATION") ? (String)jsnObj.get("ACC_LOCATION") : "";
        String docName = (String)jsnObj.get("DOC_NAME");
        Object usageDetailsData = jsnObj.get("USAGE_DETAIL_DATA");
        JSONObject usageDetailData = null;
        JSONObject sortedObject = null;
        BaseLogger.log("3", this.userInfo, null, "sortedObject : [" + usageDetailsData.getClass().getName() + "]");
        if (usageDetailsData instanceof JSONObject) {
            usageDetailData = (JSONObject)usageDetailsData;
            sortedObject = this.sortJSON(usageDetailData);
        } else if (usageDetailsData instanceof JSONArray) {
            JSONArray usageDetailDataArray = (JSONArray)usageDetailsData;
            usageDetailData = sortedObject = this.createJsonObejct(usageDetailDataArray);
        }
        BaseLogger.log("3", this.userInfo, null, "sortedObject : [" + sortedObject + "]");
        int i = 1;
        while (i <= sortedObject.length()) {
            JSONObject jsnObjDtl = sortedObject.getJSONObject("" + i);
            Iterator objKeys = jsnObjDtl.keys();
            String objKey = "";
            if (objKeys.hasNext()) {
                objKey = (String)objKeys.next();
            }
            if (objKey.contains("[")) {
                objKey = objKey.substring(1, objKey.length() - 1);
            }
            if (objKey.equalsIgnoreCase("start") || objKey.equalsIgnoreCase("end")) {
                String objValue = jsnObjDtl.getString(objKey);
                if (objValue.contains("[")) {
                    objValue = objValue.substring(1, objValue.length() - 1);
                }
                Long timeVal = new Long(objValue);
                if (objKey.equals("start") && i != 1) {
                    pause += timeVal - end;
                }
                if (i == 1) {
                    start = timeVal;
                }
                end = timeVal;
            }
            ++i;
        }
        long totTime = end - start - pause;
        Timestamp startTmst = new Timestamp(start);
        Timestamp endTmst = new Timestamp(end);
        conn = this.getConnection(userInfoBean.getTransDB());
        TransIDGenerator idGenerator = new TransIDGenerator("<Root></Root>", userId, CommonConstants.DB_NAME);
        String usageId = idGenerator.generateTranSeqID("CMMTID", "COMMENT_ID", "seq10", conn);
        try {
            try {
                String insertQry = "INSERT INTO DOC_USAGE_LOG(USAGE_ID, USER_ID, DOC_ID, START_TIME, END_TIME, DOC_TYPE, DOC_NAME, TOTAL_TIME, USE_SOURCE, USAGE_DETAIL_DATA, DEVICE_ID, DEVICE_TYPE, ACC_LOCATION ) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmt = conn.prepareStatement(insertQry);
                pstmt.setString(1, usageId);
                pstmt.setString(2, userId);
                pstmt.setString(3, docId);
                pstmt.setTimestamp(4, startTmst);
                pstmt.setTimestamp(5, endTmst);
                pstmt.setString(6, docType);
                pstmt.setString(7, docName);
                pstmt.setLong(8, totTime);
                pstmt.setString(9, useSource);
                pstmt.setString(10, usageDetailData.toString());
                pstmt.setString(11, deviceId);
                pstmt.setString(12, deviceType);
                pstmt.setString(13, accLocation);
                updateCount = pstmt.executeUpdate();
                conn.commit();
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: saveDocUsageData() : " + ex);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            try {
                this.closeObject(pstmt);
                this.closeObject(conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.closeObject(pstmt);
            this.closeObject(conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updateCount;
    }

    private JSONObject sortJSON(JSONObject jsonObject) throws JSONException {
        JSONObject sortedObject = new JSONObject();
        try {
            int i = 1;
            while (i <= jsonObject.length()) {
                sortedObject.put(String.valueOf(i), jsonObject.get(String.valueOf(i)));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: sortJSON() : " + e);
        }
        return sortedObject;
    }

    private JSONObject createJsonObejct(JSONArray jsonArray) throws JSONException {
        JSONObject sortedObject = new JSONObject();
        try {
            int i = 0;
            while (i < jsonArray.length()) {
                sortedObject.put(String.valueOf(i + 1), jsonArray.get(i));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: createJsonObejct() : " + e);
        }
        return sortedObject;
    }

    private void closeObject(AutoCloseable closableObject) throws Exception {
        if (closableObject != null) {
            closableObject.close();
        }
    }

    private boolean saveLinkToUserDocumentContents(String userId, String documentId, String documentType, String description, String shortDescription, String expDate, String cacheOpt, String pinned, String documentStatus, String lastAction, Connection conn, String procStatus) throws Exception {
        if (shortDescription.length() > 40) {
            shortDescription = shortDescription.substring(0, 40);
        }
        String insertQuery = "INSERT INTO USER_DOC_CONTENTS(USER_ID,DOC_ID,DOC_TYPE,DESCR,SH_DESCR,PINNED,DOC_STAT,LAST_ACC_ACTION, CREA_DATE,LAST_USER_ACC_DATE,LAST_GEN_ACC_DATE,ATTACH_COUNT,FILE_LOC, EXP_DATE, CACHE_OPT, PROC_STATUS)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        boolean isDocumentLinked = false;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = conn.prepareStatement(insertQuery);
                preparedStatement.setString(1, userId);
                preparedStatement.setString(2, documentId);
                preparedStatement.setString(3, documentType);
                preparedStatement.setString(4, description);
                preparedStatement.setString(5, shortDescription);
                preparedStatement.setString(6, "N");
                preparedStatement.setString(7, "A");
                preparedStatement.setString(8, "");
                Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
                preparedStatement.setTimestamp(9, currentTimestamp);
                preparedStatement.setTimestamp(10, currentTimestamp);
                preparedStatement.setTimestamp(11, currentTimestamp);
                preparedStatement.setInt(12, 0);
                if (this.repositoryHandler != null && this.activeContentServiceConn != null && this.activeContentServiceConn.length() > 0) {
                    preparedStatement.setString(13, this.activeContentServiceConn);
                } else {
                    preparedStatement.setString(13, "Oracle");
                }
                Date sqlDateObj = null;
                java.util.Date convertedDate = null;
                SimpleDateFormat formatter = null;
                E12GenericUtility genericUtility = new E12GenericUtility();
                if (this.checkNull(expDate).length() > 0) {
                    try {
                        String sourceDateFormat = genericUtility.getDispDateFormat();
                        String targetDateFormat = genericUtility.getDBDateFormat();
                        String expDateStr = genericUtility.getValidDateString(expDate, sourceDateFormat, targetDateFormat);
                        formatter = new SimpleDateFormat(CommonConstants.DB_DATE_FORMAT);
                        convertedDate = formatter.parse(expDateStr);
                        long longDate = convertedDate.getTime();
                        sqlDateObj = new Date(longDate);
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception :saveLinkToUserDocumentContents for ExpiryDate :==>" + e);
                    }
                }
                if (this.checkNull(cacheOpt).length() == 0) {
                    cacheOpt = "1";
                }
                preparedStatement.setDate(14, sqlDateObj);
                preparedStatement.setString(15, cacheOpt);
                preparedStatement.setString(16, procStatus);
                int affectedRows = preparedStatement.executeUpdate();
                isDocumentLinked = affectedRows > 0;
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exceptin in DocumentHandlerWrapperEjb saveLiknToDocumentContent [" + ex + "]");
                throw ex;
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception saveLiknToDocumentContent in finally block  " + ex);
            }
        }
        return isDocumentLinked;
    }

    private boolean saveLinkToDocTransactionLink(String docId, String refSer, String refId, String refCol, boolean isFileLoc, String documentType, String fileType, Connection conn, String transDB, String refDescr) throws Exception {
        BaseLogger.log("3", this.userInfo, null, "Save Link to DOC TRANSACTION LINK ");
        Statement pStmt = null;
        ResultSet rs = null;
        boolean isLinked = false;
        try {
            try {
                String fileLoc = "";
                String docUUID = "";
                String documentPath = "";
                String dmsTenant = "";
                String userDocContentsSQL = "SELECT FILE_LOC, DOC_UUID, DOCUMENT_PATH, DMS_TENANT FROM USER_DOC_CONTENTS WHERE USER_ID = ? AND DOC_ID = ?";
                pStmt = conn.prepareStatement(userDocContentsSQL);
                pStmt.setString(1, this.userInfo.getLoginCode());
                pStmt.setString(2, docId);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    fileLoc = rs.getString("FILE_LOC");
                    docUUID = rs.getString("DOC_UUID");
                    documentPath = rs.getString("DOCUMENT_PATH");
                    dmsTenant = rs.getString("DMS_TENANT");
                    BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB.saveLinkToDocTransactionLink() FILE_LOC      : [" + fileLoc + "]");
                    BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB.saveLinkToDocTransactionLink() DOC_UUID      : [" + docUUID + "]");
                    BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB.saveLinkToDocTransactionLink() DOCUMENT_PATH : [" + documentPath + "]");
                    BaseLogger.log("3", this.userInfo, null, "DocumentHandlerWrapperEJB.saveLinkToDocTransactionLink() DMS_TENANT    : [" + dmsTenant + "]");
                }
                pStmt.close();
                pStmt = null;
                rs.close();
                rs = null;
                String insertQuery = "INSERT INTO DOC_TRANSACTION_LINK(DOC_ID,REF_SER,REF_ID,REF_COL,FILE_LOC,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,REF_DESCR,DOC_UUID,DOCUMENT_PATH,DMS_TENANT)VALUES(?, ?, ?, ?, ?, ?, ?, ?,?,?,?)";
                BaseLogger.log("3", this.userInfo, null, "Document Obj ..Inserting into DOC_TRANSACTION_LINK [" + insertQuery + "]");
                pStmt = conn.prepareStatement(insertQuery);
                pStmt.setString(1, docId);
                pStmt.setString(2, refSer);
                pStmt.setString(3, refId);
                pStmt.setString(4, refCol);
                pStmt.setString(5, fileLoc);
                pStmt.setString(6, documentType);
                pStmt.setString(7, fileType);
                pStmt.setString(8, refDescr);
                pStmt.setString(9, docUUID);
                pStmt.setString(10, documentPath);
                pStmt.setString(11, dmsTenant);
                int noOfRows = pStmt.executeUpdate();
                if (noOfRows > 0) {
                    isLinked = true;
                }
                if ("COLPST".equalsIgnoreCase(refSer)) {
                    this.tagCollabDocuments(refId, docId, (PreparedStatement)pStmt, transDB);
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception saveLinkToDocTransactionLink [" + E12GenericUtility.getStackTrace(ex) + "]");
                throw ex;
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", this.userInfo, null, "Exception saveLinkToDocTransactionLink in finally block  " + e2);
            }
        }
        return isLinked;
    }

    private boolean saveLinkToDocTransactionLinkShared(String docId, String refSer, String refId, String refCol, boolean isFileLoc, String documentType, String fileType, Connection conn, String transDB, String refDescr) throws Exception {
        BaseLogger.log("3", this.userInfo, null, "Save Link to DOC TRANSACTION LINK [" + CommonConstants.DB_NAME + "]");
        Statement pStmt = null;
        Statement pStmt1 = null;
        ResultSet rs = null;
        boolean isLinked = false;
        try {
            try {
                int count = 0;
                String countSQL = "SELECT COUNT(*) AS COUNT FROM DOC_TRANSACTION_LINK WHERE DOC_ID = ?";
                pStmt = conn.prepareStatement(countSQL);
                pStmt.setString(1, docId);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt("COUNT");
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (count > 0) {
                    String selSql = "";
                    String insertQuery = "INSERT INTO DOC_TRANSACTION_LINK(DOC_ID,REF_SER,REF_ID,REF_COL,FILE_LOC,UUID_REFID,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,DOC_UUID,REF_DESCR,DELETE_FLAG, PAGE_INFO, ANNOT_INFO, DOCUMENT_PATH, DMS_TENANT, SHARED_DOC)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    BaseLogger.log("3", this.userInfo, null, "Document Obj ..Inserting into DOC_TRANSACTION_LINK [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    if ("mysql".equalsIgnoreCase(this.database) || "pgsql".equalsIgnoreCase(this.database)) {
                        selSql = "SELECT DOC_ID, REF_SER, REF_ID, REF_COL, FILE_LOC, UUID_REFID, DOC_TYPE_ATTACH, FILE_TYPE_ATTACH, DOC_UUID, REF_DESCR, DELETE_FLAG, PAGE_INFO, ANNOT_INFO, DOCUMENT_PATH, DMS_TENANT, SHARED_DOC FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? LIMIT 1";
                    } else if ("oracle".equalsIgnoreCase(this.database)) {
                        selSql = "SELECT DOC_ID, REF_SER, REF_ID, REF_COL, FILE_LOC, UUID_REFID, DOC_TYPE_ATTACH, FILE_TYPE_ATTACH, DOC_UUID, REF_DESCR, DELETE_FLAG, PAGE_INFO, ANNOT_INFO, DOCUMENT_PATH, DMS_TENANT, SHARED_DOC FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND ROWNUM='1'";
                    }
                    if (selSql.length() > 0) {
                        int noOfRows;
                        BaseLogger.log("3", this.userInfo, null, "Document Obj ..selecting from DOC_TRANSACTION_LINK [" + selSql + "]");
                        pStmt1 = conn.prepareStatement(selSql);
                        pStmt1.setString(1, docId);
                        rs = pStmt1.executeQuery();
                        while (rs.next()) {
                            pStmt.setString(1, rs.getString("DOC_ID"));
                            pStmt.setString(2, refSer);
                            pStmt.setString(3, refId);
                            pStmt.setString(4, refCol);
                            pStmt.setString(5, rs.getString("FILE_LOC"));
                            pStmt.setString(6, rs.getString("UUID_REFID"));
                            pStmt.setString(7, rs.getString("DOC_TYPE_ATTACH"));
                            pStmt.setString(8, rs.getString("FILE_TYPE_ATTACH"));
                            pStmt.setString(9, rs.getString("DOC_UUID"));
                            pStmt.setString(10, rs.getString("REF_DESCR"));
                            pStmt.setString(11, rs.getString("DELETE_FLAG"));
                            pStmt.setString(12, rs.getString("PAGE_INFO"));
                            pStmt.setString(13, rs.getString("ANNOT_INFO"));
                            pStmt.setString(14, rs.getString("DOCUMENT_PATH"));
                            pStmt.setString(15, rs.getString("DMS_TENANT"));
                            pStmt.setString(16, "1");
                        }
                        if (pStmt1 != null) {
                            pStmt1.close();
                            pStmt1 = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if ((noOfRows = pStmt.executeUpdate()) > 0) {
                            isLinked = true;
                        }
                    }
                    if ("COLPST".equalsIgnoreCase(refSer)) {
                        this.tagCollabDocuments(refId, docId, (PreparedStatement)pStmt, transDB);
                    }
                    pStmt.close();
                    pStmt = null;
                } else {
                    isLinked = this.saveLinkToDocTransactionLink(docId, refSer, refId, refCol, isFileLoc, documentType, fileType, conn, transDB, refDescr);
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception saveLinkToDocTransactionLink [" + E12GenericUtility.getStackTrace(ex) + "]");
                throw ex;
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (pStmt1 != null) {
                    pStmt1.close();
                    pStmt1 = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", this.userInfo, null, "Exception saveLinkToDocTransactionLink in finally block  " + e2);
            }
        }
        return isLinked;
    }

    @Override
    public boolean checkAndSaveUserDocumentContents(String details) throws RemoteException, Exception {
        boolean isDocumentAlreadyPresent = false;
        boolean isDocumentLinked = false;
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                String description;
                JSONObject detailsJobj = new JSONObject(details);
                String documentId = detailsJobj.getString("DOC_ID");
                String documentName = detailsJobj.getString("DOC_NAME");
                String documentType = detailsJobj.getString("DOC_TYPE");
                String shortDescription = detailsJobj.getString("SHORT_DESCR");
                String userId = detailsJobj.getString("USER_ID");
                String transDB = detailsJobj.getString("TRANS_DB");
                String expDate = null;
                String allowDownload = null;
                if (detailsJobj.has("EXP_DATE")) {
                    expDate = detailsJobj.getString("EXP_DATE");
                }
                if (detailsJobj.has("ALLOW_DOWNLOAD")) {
                    allowDownload = detailsJobj.getString("ALLOW_DOWNLOAD");
                }
                String insertQuery = "SELECT USER_ID, DOC_ID FROM USER_DOC_CONTENTS WHERE USER_ID = ? AND  DOC_ID = ?";
                connection = this.getConnection(transDB);
                preparedStatement = connection.prepareStatement(insertQuery);
                preparedStatement.setString(1, this.checkNull(userId));
                preparedStatement.setString(2, this.checkNull(documentId));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    isDocumentAlreadyPresent = true;
                }
                BaseLogger.log("3", this.userInfo, null, "isDocPresent : " + isDocumentAlreadyPresent);
                if (!isDocumentAlreadyPresent && (isDocumentLinked = this.saveLinkToUserDocumentContents(userId, documentId, documentType, description = this.getReferenceDescription(documentId, connection), shortDescription, expDate, allowDownload, "N", "A", "", connection, ""))) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exceptin in DocumentHandlerWrapperEjb checkAndSaveUserDocumentContents [" + e + "]");
                isDocumentLinked = false;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEjb checkAndSaveToUserDocumentContents at finally block  " + e2);
                }
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEjb checkAndSaveToUserDocumentContents at finally block  " + e2);
            }
        }
        return isDocumentLinked;
    }

    private String getReferenceDescription(String documentId, Connection connection) {
        String referenceDescription;
        block12: {
            referenceDescription = null;
            String query = "SELECT REF_DESCR FROM DOC_TRANSACTION_LINK WHERE DOC_ID='" + documentId + "'";
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(query);
                    if (resultSet.next()) {
                        referenceDescription = resultSet.getString("REF_DESCR");
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: getReferenceDescription() : " + ex);
                    try {
                        this.closeObject(resultSet);
                        this.closeObject(statement);
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeObject(resultSet);
                    this.closeObject(statement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.closeObject(resultSet);
                this.closeObject(statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return referenceDescription;
    }

    @Override
    public String getUserDocContentsLinkByUserId(String data, String transDB) {
        JSONArray docLinks;
        block12: {
            String sql = " SELECT udc.DOC_ID, udc.DESCR, udc.SH_DESCR, dc.DOC_NAME, length(dc.doc_object) as doc_size FROM USER_DOC_CONTENTS udc,  DOC_CONTENTS dc  WHERE  UDC.DOC_ID = DC.DOC_ID  AND UDC.USER_ID= ? AND UDC.DOC_ID NOT IN (select DOC_ID from DOC_TRANSACTION_LINK where REF_ID =? AND REF_SER = ?)";
            PreparedStatement pstm = null;
            ResultSet resultSet = null;
            Connection con = null;
            docLinks = new JSONArray();
            try {
                try {
                    JSONObject dataJson = new JSONObject(data);
                    String userId = dataJson.getString("userId");
                    String refId = dataJson.getString("refId");
                    String refSerise = dataJson.getString("refSerise");
                    con = this.getConnection(transDB);
                    BaseLogger.log("3", this.userInfo, null, "query :" + sql);
                    pstm = con.prepareStatement(sql);
                    pstm.setString(1, userId);
                    pstm.setString(2, refId);
                    pstm.setString(3, refSerise);
                    resultSet = pstm.executeQuery();
                    while (resultSet.next()) {
                        JSONObject docLink = new JSONObject();
                        String docId = resultSet.getString("DOC_ID");
                        String name = resultSet.getString("DOC_NAME");
                        String desc = resultSet.getString("DESCR");
                        String shDesc = resultSet.getString("SH_DESCR");
                        String size = resultSet.getString("DOC_SIZE");
                        docLink.put("docId", (Object)this.checkNull(docId));
                        docLink.put("name", (Object)this.checkNull(name));
                        docLink.put("desc", (Object)this.checkNull(desc));
                        docLink.put("shDesc", (Object)this.checkNull(shDesc));
                        docLink.put("size", (Object)this.checkNull(size));
                        docLinks.put((Object)docLink);
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: getUserDocContentsLinkByUserId() : " + ex);
                    try {
                        this.closeObject(resultSet);
                        this.closeObject(pstm);
                        this.closeObject(con);
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeObject(resultSet);
                    this.closeObject(pstm);
                    this.closeObject(con);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.closeObject(resultSet);
                this.closeObject(pstm);
                this.closeObject(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return docLinks.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getArObjectDocContentsLinkByUserId(String data, String transDB) {
        block19: {
            sql = null;
            rs = null;
            con = null;
            docLinks = null;
            pstmt = null;
            try {
                con = this.getConnection(transDB);
                docLinks = new JSONArray();
                dataJson = new JSONObject(data);
                userId = dataJson.has("userId") != false ? dataJson.getString("userId") : null;
                BaseLogger.log("2", this.userInfo, null, "****User ID=[" + userId + "]");
                docTypes = dataJson.has("docTypes") != false ? dataJson.getString("docTypes") : null;
                BaseLogger.log("3", this.userInfo, null, "docTypes :[" + docTypes + "]");
                if (docTypes == null) {
                    return "";
                }
                sql = " SELECT udc.DOC_ID,udc.DESCR, udc.SH_DESCR, dc.DOC_NAME,  LENGTH(dc.doc_object) AS doc_size FROM USER_DOC_CONTENTS udc, DOC_CONTENTS dc  WHERE UDC.DOC_ID = DC.DOC_ID AND UDC.USER_ID  = ? AND DC.DOC_TYPE IN(" + docTypes + ")";
                BaseLogger.log("3", this.userInfo, null, "query :" + sql);
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
lbl21:
                // 2 sources

                while (true) {
                    block20: {
                        if (rs.next()) break block19;
                        BaseLogger.log("3", this.userInfo, null, "****docLinks=[" + docLinks.toString() + "]");
                        if (docLinks.length() != 0) break block20;
                        ** try [egrp 3[TRYBLOCK] [1 : 513->534)] { 
lbl26:
                        // 1 sources

                        break;
                    }
                    var18_23 = docLinks.toString();
                    ** try [egrp 5[TRYBLOCK] [2 : 582->603)] { 
lbl30:
                    // 1 sources

                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: getArObjectDocContentsLinkByUserId() : " + ex);
                return docLinks.toString();
            }
            {
                this.closeObject(rs);
                this.closeObject(pstmt);
                this.closeObject(con);
                return "";
            }
lbl38:
            // 1 sources

            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: Inside finally blockgetArObjectDocContentsLinkByUserId() : " + ex.getMessage());
                ex.printStackTrace();
                return "";
            }
        }
        docLink = new JSONObject();
        docId = rs.getString("DOC_ID");
        name = rs.getString("DOC_NAME");
        desc = rs.getString("DESCR");
        shDesc = rs.getString("SH_DESCR");
        size = rs.getString("DOC_SIZE");
        docLink.put("docId", (Object)this.checkNull(docId));
        docLink.put("name", (Object)this.checkNull(name));
        docLink.put("desc", (Object)this.checkNull(desc));
        docLink.put("shDesc", (Object)this.checkNull(shDesc));
        docLink.put("size", (Object)this.checkNull(size));
        docLinks.put((Object)docLink);
        ** while (true)
lbl-1000:
        // 1 sources

        {
            this.closeObject(rs);
            this.closeObject(pstmt);
            this.closeObject(con);
            return var18_23;
        }
lbl66:
        // 1 sources

        catch (Exception ex) {
            BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: Inside finally blockgetArObjectDocContentsLinkByUserId() : " + ex.getMessage());
            ex.printStackTrace();
        }
        return var18_23;
        finally {
            try {
                this.closeObject(rs);
                this.closeObject(pstmt);
                this.closeObject(con);
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: Inside finally blockgetArObjectDocContentsLinkByUserId() : " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getDocUsage(String documentId, String transDB) throws Exception {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String jsonDocUsage = "";
        try {
            String sqlQuery = this.getUsageSQL(documentId);
            ConnDriver connDriver = new ConnDriver();
            connection = connDriver.getConnectDB(transDB);
            preparedStatement = connection.prepareStatement(sqlQuery);
            resultSet = preparedStatement.executeQuery();
            jsonDocUsage = this.createJson(resultSet, documentId);
        }
        catch (Throwable throwable) {
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            this.closeObject(connection);
            throw throwable;
        }
        this.closeObject(resultSet);
        this.closeObject(preparedStatement);
        this.closeObject(connection);
        return jsonDocUsage;
    }

    private String getUsageSQL(String documentId) {
        String formattedDocumentIds = this.getFormattedDocIdsString(documentId);
        String sql = "SELECT DUL.USER_ID, U.NAME, DUL.DOC_NAME, DUL.USAGE_DETAIL_DATA, DUL.START_TIME,DUL.END_TIME FROM DOC_USAGE_LOG DUL INNER JOIN USERS U ON DUL.USER_ID = U.CODE WHERE DUL.DOC_ID IN (" + formattedDocumentIds + ") ORDER BY DUL.USER_ID";
        return sql;
    }

    private String createJson(ResultSet resultSet, String doc_Id) throws ITMException {
        JSONObject obj_1 = new JSONObject();
        try {
            String docName = "";
            String userId = "";
            String userName = "";
            String usageDetails = "";
            String KEY = "";
            JSONObject usageDetailJsonObj = null;
            JSONObject obj_2 = new JSONObject();
            JSONObject obj_3 = null;
            JSONObject obj_4 = null;
            JSONArray usageDataJsonArray = null;
            HashSet<String> userIdSet = new HashSet<String>();
            HashMap<String, String> userNameMap = new HashMap<String, String>();
            while (resultSet.next()) {
                docName = this.checkNull(resultSet.getString("DOC_NAME"));
                userId = this.checkNull(resultSet.getString("USER_ID"));
                userName = this.checkNull(resultSet.getString("NAME"));
                Date startDate = resultSet.getDate("START_TIME");
                long startTime = startDate.getTime();
                Date endDate = resultSet.getDate("END_TIME");
                long endTime = endDate.getTime();
                usageDetails = this.checkNull(resultSet.getString("USAGE_DETAIL_DATA"));
                try {
                    usageDetailJsonObj = new JSONObject(usageDetails);
                }
                catch (JSONException ex) {
                    usageDetailJsonObj = new JSONObject();
                    BaseLogger.log("0", this.userInfo, null, "#### Exception in createJson:: WHILE : " + (Object)((Object)ex));
                }
                if (!userIdSet.contains(userId)) {
                    userIdSet.add(userId);
                    userNameMap.put(userId, userName);
                    userNameMap.put("DOC_NAME", docName);
                    KEY = String.valueOf(userId) + userName + docName;
                }
                if (userNameMap.get(KEY) == null) {
                    try {
                        obj_4 = new JSONObject();
                        obj_4.put("START_TIME", startTime);
                        obj_4.put("END_TIME", endTime);
                        obj_4.put("USAGE_DETAILS", (Object)usageDetailJsonObj);
                        usageDataJsonArray = new JSONArray();
                        usageDataJsonArray.put((Object)obj_4);
                        obj_3 = new JSONObject();
                        obj_3.put("USAGE_DATA", (Object)usageDataJsonArray);
                        obj_3.put("NAME", (Object)userName);
                        obj_3.put("TOTAL_VIEW_TIME", (Object)"");
                        obj_2.put(userId, (Object)obj_3);
                        obj_1.put("DATA", (Object)obj_2);
                        userNameMap.put(KEY, KEY);
                    }
                    catch (JSONException e) {
                        BaseLogger.log("0", this.userInfo, null, "#### Exception in createJson:: IF : " + (Object)((Object)e));
                    }
                    continue;
                }
                try {
                    obj_4 = new JSONObject();
                    obj_4.put("START_TIME", startTime);
                    obj_4.put("END_TIME", endTime);
                    obj_4.put("USAGE_DETAILS", (Object)usageDetailJsonObj);
                    usageDataJsonArray.put((Object)obj_4);
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "#### Exception in createJson:: ELSE : " + e);
                }
            }
            try {
                obj_1.put("DOC_ID", (Object)doc_Id);
                obj_1.put("DOC_NAME", (Object)docName);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "#### Exception in createJson:: ParentJSON : " + e);
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", this.userInfo, null, "#### Exception in createJson () AT LAST : " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return obj_1.toString();
    }

    @Override
    public String saveToDocTransLink(String data, String transDB) throws RemoteException, Exception {
        BaseLogger.log("2", this.userInfo, null, " saveToDocTransLink start data : " + data);
        JSONObject dataJobj = new JSONObject(data);
        String docId = this.checkNull(dataJobj.getString("docId"));
        String refSer = this.checkNull(dataJobj.getString("refSer"));
        String refId = this.checkNull(dataJobj.getString("refId"));
        String documentType = this.checkNull(dataJobj.getString("documentType"));
        String fileType = this.checkNull(dataJobj.getString("fileType"));
        String refDescr = this.checkNull(dataJobj.getString("refDescr"));
        String fileName = this.checkNull(dataJobj.getString("fileName"));
        String userId = this.checkNull(dataJobj.getString("userId"));
        String resultStr = "";
        boolean islinked = false;
        Connection con = null;
        try {
            try {
                con = this.getConnection(transDB);
                islinked = this.saveLinkToDocTransactionLinkShared(docId, refSer, refId, " ", false, documentType, fileType, con, transDB, refDescr);
                if (islinked) {
                    resultStr = this.getUpdatedDocInfo(docId, fileName, fileType, userId);
                    con.commit();
                } else {
                    resultStr = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_notProperlyUploaded") + "</Detail></Root>";
                }
                BaseLogger.log("3", this.userInfo, null, " saveToDocTransLink commited ");
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: saveToDocTransLink() : " + E12GenericUtility.getStackTrace(ex));
                throw ex;
            }
        }
        finally {
            try {
                this.closeObject(con);
            }
            catch (Exception ex) {
                BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: finally :: saveToDocTransLink() : " + ex);
            }
        }
        return resultStr;
    }

    private String getDOC_UUID(String docId, Connection conn) throws ITMException {
        Statement mPstmt = null;
        ResultSet rs = null;
        String docUuid = "";
        try {
            try {
                String sql = "SELECT REF_ID, REF_SER, DOC_UUID FROM DOC_TRANSACTION_LINK WHERE DOC_ID = ?";
                BaseLogger.log("3", this.userInfo, null, "selectQry :" + sql);
                mPstmt = conn.prepareStatement(sql);
                mPstmt.setString(1, docId);
                rs = mPstmt.executeQuery();
                if (rs.next()) {
                    docUuid = rs.getString("DOC_UUID");
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", this.userInfo, null, "SQLException : [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return docUuid;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfoBean) {
        this.userInfo = userInfoBean;
        if (this.repositoryHandler != null) {
            this.repositoryHandler.setUserInfo(userInfoBean);
        }
    }

    @Override
    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public String getDocumentDetails(String searchText, String searchModule, UserInfoBean userInfo, String resultFormat) throws ITMException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        JSONObject resultJsonData = new JSONObject();
        JSONArray jsonRowDataArr = new JSONArray();
        JSONArray resultJsonArr = new JSONArray();
        E12GenericUtility genericUtility = new E12GenericUtility();
        StringBuffer xmlStrBuff = new StringBuffer("<root>");
        try {
            this.setRepositoryHandler(null, userInfo);
            ArrayList<String> docUUIdList = this.getSearchResult(searchText, userInfo.getEnterprise(), searchModule);
            if (docUUIdList == null || docUUIdList.size() == 0) {
                return "";
            }
            try {
                String docUUIdListStr = this.checkNull(docUUIdList.toString());
                BaseLogger.log("3", userInfo, null, "documentIdListstr = " + docUUIdListStr);
                docUUIdListStr = docUUIdListStr.replace("[", "").replace("]", "");
                docUUIdListStr = docUUIdListStr.replaceAll(", ", "','");
                BaseLogger.log("3", userInfo, null, "documentIdListstr = " + docUUIdListStr);
                connection = this.getConnection(userInfo.getTransDB());
                String sql = "SELECT C.DOC_ID, T.REF_SER, T.REF_ID, T.DOC_TYPE_ATTACH, C.DOC_NAME, C.DOC_TYPE, C.ADD_USER, C.ADD_DATE, C.ADD_TERM, U.NAME, ( SELECT TRAN_WINDOW FROM TRANSETUP WHERE TRIM(REF_SER)=TRIM(T.REF_SER) AND ROWNUM=1) TRAN_WINDOW  FROM DOC_TRANSACTION_LINK T,DOC_CONTENTS C,USERS U  WHERE T.DOC_ID=C.DOC_ID  AND C.ADD_USER=U.CODE AND T.DOC_UUID IN ( '" + docUUIdListStr + "' )";
                statement = connection.prepareStatement(sql);
                resultSet = statement.executeQuery(sql);
                JSONArray jsonColArray = new JSONArray();
                jsonColArray.put((Object)"DOC NAME");
                jsonColArray.put((Object)"DOC TYPE ATTACH");
                jsonColArray.put((Object)"REF SER");
                jsonColArray.put((Object)"REF ID");
                jsonColArray.put((Object)"ADD USER");
                jsonColArray.put((Object)"ADD DATE");
                resultJsonData.put("cols", (Object)jsonColArray);
                while (resultSet.next()) {
                    String docId1 = resultSet.getString("DOC_ID");
                    String docName = resultSet.getString("DOC_NAME");
                    String refSer = this.checkNull(resultSet.getString("REF_SER"));
                    if (refSer.length() == 0) {
                        refSer = "-";
                    }
                    String refId = resultSet.getString("REF_ID");
                    String docTypeAttch = this.checkNull(resultSet.getString("DOC_TYPE_ATTACH"));
                    if (docTypeAttch.length() == 0) {
                        docTypeAttch = "-";
                    }
                    String docType = resultSet.getString("DOC_TYPE");
                    String adduser = resultSet.getString("ADD_USER");
                    String addDate = resultSet.getString("ADD_DATE");
                    String addterm = resultSet.getString("ADD_TERM");
                    String userName = this.checkNull(resultSet.getString("NAME"));
                    String tranWin = resultSet.getString("TRAN_WINDOW");
                    String formattedDate = genericUtility.getValidDateString(addDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateTimeFormat());
                    if (resultFormat.equalsIgnoreCase("JSON")) {
                        JSONArray jsonRowArr = new JSONArray();
                        jsonRowArr.put((Object)docName);
                        jsonRowArr.put((Object)docTypeAttch);
                        jsonRowArr.put((Object)refSer);
                        jsonRowArr.put((Object)refId);
                        if (userName == null || userName.length() == 0) {
                            jsonRowArr.put((Object)adduser);
                        } else {
                            jsonRowArr.put((Object)(String.valueOf(userName) + " (" + adduser.trim() + ")"));
                        }
                        jsonRowArr.put((Object)formattedDate);
                        jsonRowDataArr.put((Object)jsonRowArr);
                        continue;
                    }
                    xmlStrBuff.append("<DOCS>");
                    xmlStrBuff.append("<DOC_ID>" + docId1 + "</DOC_ID>");
                    xmlStrBuff.append("<DOC_NAME>" + docName + "</DOC_NAME>");
                    xmlStrBuff.append("<REF_SER>" + refSer + "</REF_SER>");
                    xmlStrBuff.append("<REF_ID>" + refId + "</REF_ID>");
                    xmlStrBuff.append("<DOC_TYPE_ATTACH>" + docTypeAttch + "</DOC_TYPE_ATTACH>");
                    xmlStrBuff.append("<DOC_TYPE>" + docType + "</DOC_TYPE>");
                    if (userName == null || userName.length() == 0) {
                        xmlStrBuff.append("<ADD_USER>" + adduser + "</ADD_USER>");
                    } else {
                        xmlStrBuff.append("<ADD_USER>" + userName + " (" + adduser.trim() + ")" + "</ADD_USER>");
                    }
                    xmlStrBuff.append("<ADD_DATE>" + formattedDate + "</ADD_DATE>");
                    xmlStrBuff.append("<ADD_TERM>" + addterm + "</ADD_TERM>");
                    if (tranWin.startsWith("w_")) {
                        tranWin = tranWin.replace("w_", "");
                        xmlStrBuff.append("<OBJ_NAME>" + tranWin + "</OBJ_NAME>");
                    }
                    xmlStrBuff.append("</DOCS>");
                }
                xmlStrBuff.append("</root>");
                BaseLogger.log("2", userInfo, null, "valxmlStr : [" + xmlStrBuff + "]");
                resultJsonData.put("rows", (Object)jsonRowDataArr);
                BaseLogger.log("2", userInfo, null, "resultJsonData: [" + resultJsonData + "]");
                resultJsonArr.put((Object)resultJsonData);
                BaseLogger.log("2", userInfo, null, "resultJsonArr : [" + resultJsonArr + "]");
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "DocumentHandlerWrapperEJB.getDocumentDetails() : [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (resultFormat.equalsIgnoreCase("JSON")) {
            return resultJsonArr.toString();
        }
        return xmlStrBuff.toString();
    }

    private ArrayList<String> getSearchResult(String searchText, String enterprise, String searchModule) throws ITMException {
        enterprise = this.checkNull(enterprise);
        BaseLogger.log("2", this.userInfo, null, "Trying to Search text in document for [ " + searchText + " ], enterprises [" + enterprise + "]");
        if (this.repositoryHandler != null) {
            return this.repositoryHandler.searchDocumentId(searchModule, enterprise, searchText);
        }
        BaseLogger.log("3", this.userInfo, null, "Error while Searching Document : unable to Search file.");
        return null;
    }

    @Override
    public byte[] getDocument(String docId, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException {
        return this.getDocument(docId, transDB, userInfo, null);
    }

    private String generateTranSeqID(String userCode, Connection conn) throws ITMException {
        String docId = "";
        Statement lstmt = null;
        ResultSet lrs = null;
        try {
            try {
                String tranSer = "";
                String keyString = "";
                String keyCol = "";
                String sqlStr = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
                lstmt = conn.prepareStatement(sqlStr);
                lstmt.setString(1, "w_cms_file_attach");
                lrs = lstmt.executeQuery();
                if (lrs.next()) {
                    keyString = lrs.getString("KEY_STRING");
                    tranSer = lrs.getString("REF_SER");
                }
                lrs.close();
                lrs = null;
                lstmt.close();
                lstmt = null;
                StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"").append(CommonConstants.ENCODING).append("\"?><Root>");
                xmlValues.append("<Header></Header><Detail1><site_code>").append(userCode).append("</site_code>");
                xmlValues.append("</Detail1></Root>");
                TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), userCode, CommonConstants.DB_NAME);
                docId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
                tg = null;
            }
            catch (ITMException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (lrs != null) {
                    lrs.close();
                }
                if (lstmt != null) {
                    lstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return docId;
    }

    public String saveAnnotationData(String docId, String newAnnotatedData, UserInfoBean userInfo) {
        String result = "";
        String transDb = null;
        String existingAnnotedData = null;
        String annotationDataforUPDATE = null;
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                if (docId != null && newAnnotatedData != null) {
                    transDb = userInfo.getTransDB();
                    conn = this.getConnection(transDb);
                    existingAnnotedData = this.getExistingAnnotedData(conn, docId, transDb);
                    annotationDataforUPDATE = this.getAnnotationDataforUPDATE(newAnnotatedData, existingAnnotedData, docId);
                    String sql = "UPDATE DOC_CONTENTS SET ANNOT_INFO = ? WHERE DOC_ID = '" + docId + "' ";
                    pstmt = conn.prepareStatement(sql);
                    if ("oracle".equalsIgnoreCase(this.database)) {
                        CLOB annotationClobData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        annotationClobData.putString(1L, annotationDataforUPDATE);
                        pstmt.setClob(1, (Clob)annotationClobData);
                    } else {
                        pstmt.setString(1, annotationDataforUPDATE);
                    }
                    BaseLogger.log("3", userInfo, null, "sqlStr : " + sql);
                    int i = pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    if (i > 0) {
                        conn.commit();
                        result = "success";
                    }
                }
            }
            catch (Exception e) {
                result = "Exception " + e.getMessage();
                BaseLogger.log("0", userInfo, null, "DocumentHandlerWrapperEJB.saveAnnotationData() : [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    result = "SQLException" + e2.getMessage();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                result = "SQLException" + e.getMessage();
            }
        }
        return result;
    }

    public String getAnnotationData(String docIds, UserInfoBean userInfoBean) {
        String transDb = null;
        Connection conn = null;
        String annotationData = null;
        try {
            try {
                transDb = userInfoBean.getTransDB();
                conn = this.getConnection(transDb);
                annotationData = this.getExistingAnnotedData(conn, docIds, transDb);
                annotationData = annotationData == null ? "No Annotation Data Found." : annotationData;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "[getAnnotationData] Exception: [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException ae) {
                    BaseLogger.log("0", null, null, "[getAnnotationData] SQLException: [" + ae.getMessage() + "]");
                    ae.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException ae) {
                BaseLogger.log("0", null, null, "[getAnnotationData] SQLException: [" + ae.getMessage() + "]");
                ae.printStackTrace();
            }
        }
        return annotationData;
    }

    private String getExistingAnnotedData(Connection connection, String docId, String transDB) {
        String annotationData = null;
        String sql = null;
        Statement pstmt = null;
        ResultSet rs = null;
        JSONObject annotationJsonData = null;
        try {
            if (connection == null) {
                connection = transDB != null ? this.getConnection(transDB) : this.getConnection("DriverITM");
            }
            if (docId != null) {
                docId = this.checkNull(docId);
                annotationJsonData = new JSONObject();
                String docIds = this.getAllDocIds(docId);
                sql = "SELECT DOC_ID, ANNOT_INFO FROM DOC_CONTENTS WHERE DOC_ID IN( " + docIds + " ) ";
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String docID = rs.getString(1);
                    Clob annotClob = rs.getClob(2);
                    InputStream is = annotClob.getAsciiStream();
                    String annotationArrStr = this.readStreamAsString(is);
                    if (docID == null || annotationArrStr == null) continue;
                    JSONArray annotationJsonArr = new JSONArray(annotationArrStr);
                    annotationJsonData.put(docID, (Object)annotationJsonArr);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            if (annotationJsonData != null && annotationJsonData.length() > 0) {
                String string = annotationData = annotationJsonData.toString();
                return string;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[getExistingAnnotedData] Exception : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException ae) {
                BaseLogger.log("0", null, null, "[getExistingAnnotedData] SQLException : [" + ae.getMessage() + "]");
                ae.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "[getExistingAnnotedData] AnnotationData ::[ " + annotationData + " ]");
        return annotationData;
    }

    private String readStreamAsString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int readed = -1;
        while ((readed = is.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, readed);
        }
        return new String(os.toByteArray());
    }

    private String getAllDocIds(String docids) {
        StringBuffer docidSb = null;
        try {
            if (docids != null) {
                if (docids.indexOf(",") != -1) {
                    String[] docidArr;
                    String[] stringArray = docidArr = docids.split(",");
                    int n = docidArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String docId = stringArray[n2];
                        if (docidSb == null) {
                            docidSb = new StringBuffer("'").append(docId).append("'");
                        } else {
                            docidSb.append(",").append("'").append(docId).append("'");
                        }
                        ++n2;
                    }
                } else {
                    docidSb = new StringBuffer("'").append(docids).append("'");
                }
                if (docidSb != null) {
                    return docidSb.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getAnnotationDataforUPDATE(String newAnnotatedData, String existingAnnotedData, String docId) {
        String annotationDataforUPDATE = null;
        JSONArray annotationJsonArray = null;
        try {
            if (newAnnotatedData != null) {
                JSONObject annotationDataJsonObject = new JSONObject(newAnnotatedData);
                if (existingAnnotedData != null) {
                    if (existingAnnotedData.length() > 0) {
                        JSONObject existingAnnotJsonObj = new JSONObject(existingAnnotedData);
                        annotationJsonArray = (JSONArray)existingAnnotJsonObj.get(docId);
                        annotationJsonArray.put((Object)annotationDataJsonObject);
                    }
                } else {
                    annotationJsonArray = new JSONArray();
                    annotationJsonArray.put((Object)annotationDataJsonObject);
                }
            }
            if (annotationJsonArray != null) {
                if (annotationJsonArray.length() > 0) {
                    annotationDataforUPDATE = annotationJsonArray.toString();
                    return annotationDataforUPDATE;
                }
            } else {
                annotationDataforUPDATE = " NO ANNOTATION DATA for UPDATE ";
            }
        }
        catch (Exception e) {
            annotationDataforUPDATE = "Exception: " + e.getMessage();
            BaseLogger.log("0", null, null, "DocumentHandlerWrapperEJB.getAnnotationDataforUPDATE() : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "annotationDataforUPDATE---->> ::[ " + annotationDataforUPDATE + " ]");
        return annotationDataforUPDATE;
    }

    @Override
    public String documentMigration(String refSer, String docIds, String fromDt, String toDt, String maxDocs, String fromServer, String toServer, String fromFileLoc, String toFileLoc, UserInfoBean userInfo, String isBackgrndProcess, String isDeleteFromServer) throws ITMException {
        PreparedStatement pstm = null;
        ResultSet resultSet = null;
        Connection conn = null;
        String bckgndResStr = "";
        String objName = "DOC_MIGRATION";
        StringBuilder migrationStatus = new StringBuilder();
        try {
            try {
                BaseLogger.info("Document Migration ---------------------- START");
                BaseLogger.info("Method call with following parameters");
                StringBuilder param = new StringBuilder();
                param.append("DOC_ID : [").append(docIds).append("]").append(", ");
                param.append("REF_SER : [").append(refSer).append("]").append(", ");
                param.append("FROM_DATE : [").append(fromDt).append("]").append(", ");
                param.append("TO_DATE : [").append(toDt).append("]").append(", ");
                param.append("FROM_FILE_LOC : [").append(fromFileLoc).append("]").append(", ");
                param.append("TO_FILE_LOC : [").append(toFileLoc).append("]").append(", ");
                param.append("MAX_DOCS : [").append(maxDocs).append("]").append(", ");
                param.append("FROM_SERVER : [").append(fromServer).append("]").append(", ");
                param.append("TO_SERVER : [").append(toServer).append("]");
                BaseLogger.info(param);
                docIds = this.checkNull(docIds);
                if (docIds.length() > 0) {
                    docIds = docIds.replaceAll(" ", "");
                    if ((docIds = "'" + docIds + "'").indexOf(",") != -1) {
                        docIds = docIds.replaceAll(",", "','");
                    }
                }
                BaseLogger.log("3", userInfo, null, "docIds - [" + docIds + "]");
                refSer = this.checkNull(refSer);
                if (refSer.length() > 0) {
                    refSer = refSer.replaceAll(" ", "");
                    if ((refSer = "'" + refSer + "'").indexOf(",") != -1) {
                        refSer = refSer.replaceAll(",", "','");
                    }
                }
                BaseLogger.log("3", userInfo, null, "refSer - [" + refSer + "]");
                fromFileLoc = this.checkNull(fromFileLoc);
                BaseLogger.log("3", userInfo, null, "fromFileLoc - [" + fromFileLoc + "]");
                toFileLoc = this.checkNull(toFileLoc);
                BaseLogger.log("3", userInfo, null, "toFileLoc - [" + toFileLoc + "]");
                fromDt = this.checkNull(fromDt);
                toDt = this.checkNull(toDt);
                maxDocs = this.checkNull(maxDocs);
                if (maxDocs.length() == 0) {
                    maxDocs = "10";
                }
                int maxDocNum = Integer.parseInt(maxDocs);
                BaseLogger.log("3", userInfo, null, "maxDocNum - [" + maxDocNum + "]");
                BaseLogger.log("3", userInfo, null, "fromServer : [" + fromServer + "]");
                HashMap<String, String> contentServiceDetMap = this.getContentServiceCredential(fromFileLoc, userInfo);
                RepositoryHandler fromRepositoryHandler = new RepositoryHandler(contentServiceDetMap, userInfo);
                BaseLogger.log("3", userInfo, null, "toServer : [" + toServer + "]");
                contentServiceDetMap = this.getContentServiceCredential(toFileLoc, userInfo);
                RepositoryHandler toRepositoryHandler = new RepositoryHandler(contentServiceDetMap, userInfo);
                isBackgrndProcess = this.checkNull(isBackgrndProcess);
                boolean isBackgroundProcess = "true".equalsIgnoreCase(isBackgrndProcess);
                isDeleteFromServer = this.checkNull(isDeleteFromServer);
                boolean toDeleteFromServer = "true".equalsIgnoreCase(isDeleteFromServer);
                BckgrndProcessEJB bckgrndProcess = new BckgrndProcessEJB();
                conn = this.getConnection(userInfo.getTransDB());
                StringBuffer docIdSql = new StringBuffer("SELECT D_LINK.DOC_ID, D_CONTENTS.DOC_NAME, D_LINK.REF_SER, D_LINK.REF_ID, D_LINK.DOC_UUID, D_LINK.DOCUMENT_PATH, D_LINK.DMS_TENANT, D_CONTENTS.ADD_DATE ");
                docIdSql.append("FROM DOC_TRANSACTION_LINK D_LINK, DOC_CONTENTS D_CONTENTS ");
                docIdSql.append("WHERE D_LINK.DOC_ID = D_CONTENTS.DOC_ID ");
                docIdSql.append("AND D_LINK.FILE_LOC = ? ");
                if (refSer.length() > 0) {
                    docIdSql.append("AND D_LINK.REF_SER in ( " + refSer + " ) ");
                }
                if (docIds.length() > 0) {
                    docIdSql.append("AND D_LINK.DOC_ID IN ( " + docIds + " ) ");
                }
                if (fromDt.length() > 0 && toDt.length() > 0) {
                    docIdSql.append("AND TRUNC(D_CONTENTS.ADD_DATE) >= ? AND TRUNC(D_CONTENTS.ADD_DATE) <= ?");
                }
                docIdSql.append("AND D_LINK.MIGRATION_STATUS IS NULL AND D_LINK.DOC_UUID IS NOT NULL ORDER BY DOC_ID ASC");
                pstm = conn.prepareStatement(docIdSql.toString());
                pstm.setString(1, fromFileLoc);
                if (fromDt.length() > 0 && toDt.length() > 0) {
                    pstm.setString(2, fromDt);
                    pstm.setString(3, toDt);
                }
                resultSet = pstm.executeQuery();
                ResultSetMetaData rsmd = resultSet.getMetaData();
                String enterprise = userInfo.getEnterprise();
                StringBuffer docIdStr = new StringBuffer();
                StringBuffer successDocIdStr = new StringBuffer();
                StringBuffer failDocIdStr = new StringBuffer();
                int cntr = 0;
                int successMigrateCount = 0;
                int failMigrateCount = 0;
                while (resultSet.next()) {
                    if (maxDocNum == cntr) break;
                    String docId = resultSet.getString("DOC_ID");
                    String refSeries = resultSet.getString("REF_SER");
                    String refId = resultSet.getString("REF_ID");
                    String uuId = resultSet.getString("DOC_UUID");
                    String documentPath = resultSet.getString("DOCUMENT_PATH");
                    String dmsTenant = resultSet.getString("DMS_TENANT");
                    String documentName = resultSet.getString("DOC_NAME");
                    StringBuilder logData = new StringBuilder();
                    int noOfColumns = rsmd.getColumnCount();
                    int ctr = 1;
                    while (ctr <= noOfColumns) {
                        if ("mysql".equalsIgnoreCase(this.database)) {
                            logData.append(rsmd.getColumnName(ctr).toUpperCase()).append(" : ").append(resultSet.getString(ctr));
                        } else {
                            logData.append(rsmd.getColumnName(ctr)).append(" : ").append(resultSet.getString(ctr));
                        }
                        if (ctr < noOfColumns - 1) {
                            logData.append(", ");
                        }
                        ++ctr;
                    }
                    BaseLogger.info(logData);
                    BaseLogger.log("3", userInfo, null, "isBackgrndProcess:::[ " + isBackgrndProcess + " ]");
                    bckgndResStr = "";
                    if (isBackgroundProcess) {
                        bckgndResStr = bckgrndProcess.saveBckgrndProcessData(isBackgrndProcess, objName, "M", "", "<Root></Root>", "", "", userInfo.getLoginCode(), userInfo.getSiteCode(), userInfo);
                        BaseLogger.log("3", userInfo, null, "saveBckgrndProcessData bckgndResStr : [" + bckgndResStr + "]");
                    }
                    try {
                        byte[] docByte = fromRepositoryHandler.download(refSeries, docId, refId, uuId, null, null, documentPath, dmsTenant);
                        String response = "docByte is null";
                        if (docByte != null) {
                            HashMap<String, String> dataMap = toRepositoryHandler.upload(refSeries, refId, docId, documentName, docByte, null, null, null, userInfo.getEnterprise(), null);
                            uuId = dataMap.get("DOC_UUID");
                            response = this.updateMigrationStatus(docId, uuId, toFileLoc, documentPath = dataMap.get("DOCUMENT_PATH"), dmsTenant = dataMap.get("DMS_TENANT"), userInfo);
                            if ("success".equalsIgnoreCase(response)) {
                                if (successMigrateCount >= 1) {
                                    successDocIdStr.append(",");
                                }
                                successDocIdStr.append("'").append(docId).append("'");
                                ++successMigrateCount;
                                docIdStr.append("(").append(docId).append(") : Success \n");
                                BaseLogger.info("(" + docId + ") : Success");
                            }
                            if (toDeleteFromServer && fromRepositoryHandler != null) {
                                documentPath = resultSet.getString("DOCUMENT_PATH");
                                BaseLogger.log("3", userInfo, null, "documentPath : [" + documentPath + "]");
                                fromRepositoryHandler.delete(refSeries, docId, refId, uuId, enterprise, documentPath, dmsTenant);
                            }
                        }
                        if (!"success".equalsIgnoreCase(response)) {
                            if (failMigrateCount >= 1) {
                                failDocIdStr.append(",");
                            }
                            failDocIdStr.append("'").append(docId).append("'");
                            ++failMigrateCount;
                            docIdStr.append("(").append(docId).append(") : Fail :: [").append(response).append("] \n");
                            BaseLogger.info("(" + docId + ") : Fail :: [" + response + "]");
                        }
                        if (this.checkNull(bckgndResStr).length() > 0) {
                            String jobId = bckgrndProcess.getJobIdFromXML(bckgndResStr);
                            BaseLogger.log("3", userInfo, null, "jobId - [" + jobId + "]");
                            HashMap<String, String> updateColumnSet = new HashMap<String, String>();
                            if ("success".equals(response)) {
                                updateColumnSet.put("JOB_STAT", "C");
                            } else {
                                updateColumnSet.put("JOB_STAT", "E");
                            }
                            updateColumnSet.put("EXEC_RESULT", response);
                            bckgrndProcess.updateBackgroundJob(jobId, updateColumnSet, objName, userInfo.getLoginCode(), userInfo);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (failMigrateCount > 1) {
                            failDocIdStr.append(",");
                        }
                        failDocIdStr.append("'").append(docId).append("'");
                        ++failMigrateCount;
                        docIdStr.append("(").append(docId).append(") : Exception :: [").append(e.getMessage()).append("] \n");
                        BaseLogger.info("(" + docId + ") : Exception :: [" + e.getMessage() + "]");
                    }
                    ++cntr;
                }
                BaseLogger.log("3", userInfo, null, "docIdStr - [" + docIdStr + "]");
                resultSet.close();
                resultSet = null;
                pstm.close();
                pstm = null;
                migrationStatus.append(successMigrateCount).append("/").append(cntr).append(" records migrated.");
                if (successMigrateCount > 0) {
                    migrationStatus.append("\nFollowing document migrated succussfully.");
                    migrationStatus.append("\n[").append(successDocIdStr).append("]");
                }
                if (failMigrateCount > 0) {
                    migrationStatus.append("\nFollowing document migration failed.");
                    migrationStatus.append("\n[").append(failDocIdStr).append("]");
                }
            }
            catch (SQLException e) {
                migrationStatus = new StringBuilder();
                migrationStatus.append(e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (RemoteException e) {
                migrationStatus = new StringBuilder();
                migrationStatus.append(e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            BaseLogger.info(migrationStatus);
            BaseLogger.info("Document Migration ---------------------- END");
        }
        return migrationStatus.toString();
    }

    private String updateMigrationStatus(String docId, String uuid, String fileLoc, String documentPath, String dmsTenant, UserInfoBean userInfo) {
        String response;
        block23: {
            response = "";
            Statement mPstmt = null;
            Connection conn = null;
            try {
                try {
                    String uuidRefID = "";
                    String docUUID = "";
                    conn = this.getConnection(userInfo.getTransDB());
                    conn.setAutoCommit(false);
                    if (uuid != null && uuid.indexOf("~") != -1) {
                        docUUID = uuid.substring(0, uuid.indexOf("~"));
                        uuidRefID = uuid.substring(uuid.indexOf("~") + 1);
                    } else {
                        docUUID = uuid;
                    }
                    BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB >> updateDocUUID >> uuidRefID =[" + uuidRefID + "]");
                    String sql = "UPDATE DOC_TRANSACTION_LINK  SET DOC_UUID = ?, UUID_REFID = ?, DOCUMENT_PATH = ?, DMS_TENANT = ?, FILE_LOC = ?, MIGRATION_STATUS = ?  WHERE DOC_ID = ? ";
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, docUUID);
                    mPstmt.setString(2, uuidRefID);
                    mPstmt.setString(3, documentPath);
                    mPstmt.setString(4, dmsTenant);
                    mPstmt.setString(5, fileLoc);
                    mPstmt.setString(6, "Y");
                    mPstmt.setString(7, docId);
                    int cnt = mPstmt.executeUpdate();
                    if (cnt > 0) {
                        conn.commit();
                        response = "success";
                    }
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    response = e.getMessage();
                    e.printStackTrace();
                    try {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block23;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", userInfo, null, "response [" + response + "]");
        return response;
    }

    public boolean isContainsDeviceEntry(String userId, UserInfoBean userInfoBean) {
        boolean isExist;
        block24: {
            isExist = false;
            String sql = null;
            String transDB = null;
            ResultSet rs = null;
            Connection conn = null;
            Statement pstmt = null;
            try {
                try {
                    if (userInfoBean != null) {
                        transDB = userInfoBean.getTransDB();
                    }
                    if ((rs = (pstmt = (conn = transDB != null ? this.getConnection(transDB) : this.getConnection("DriverITM")).prepareStatement(sql = "SELECT DEVICE_ID__PUSH FROM USER_DEVICE WHERE USER_ID = '" + userId + "' " + "AND DEVICE_OS IN('Android','iOS')")).executeQuery()).next()) {
                        isExist = true;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "[isContainsDeviceEntry] Exception : [" + e.getMessage() + "]");
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block24;
                    }
                    catch (SQLException sqEx) {
                        BaseLogger.log("0", null, null, "[isContainsDeviceEntry] SQLException : [" + sqEx.getMessage() + "]");
                        sqEx.printStackTrace();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sqEx) {
                    BaseLogger.log("0", null, null, "[isContainsDeviceEntry] SQLException : [" + sqEx.getMessage() + "]");
                    sqEx.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException sqEx) {
                BaseLogger.log("0", null, null, "[isContainsDeviceEntry] SQLException : [" + sqEx.getMessage() + "]");
                sqEx.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "[isContainsDeviceEntry] isExist Device Entry ::[ " + isExist + " ]");
        return isExist;
    }

    public int updateAttachIdRefId(String objName, String refId, String attachId, String transDB) throws ITMException {
        int updateCount = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                String sql = "UPDATE DOC_TRANSACTION_LINK  SET REF_ID = ?  WHERE TRIM(REF_SER) = ( SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ? )  AND REF_ID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refId);
                pstmt.setString(2, "w_" + objName);
                pstmt.setString(3, attachId);
                updateCount = pstmt.executeUpdate();
                if (updateCount > 0) {
                    conn.commit();
                }
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", this.userInfo, null, "updateAttachIdRefId :: updateCount : [" + updateCount + "]");
            }
            catch (SQLException e) {
                updateCount = 0;
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                updateCount = 0;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                conn.close();
                conn = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return updateCount;
    }

    public String getDocContentDetails(String docId, UserInfoBean userInfo) {
        JSONObject jsonObject;
        block21: {
            BaseLogger.log("0", null, null, "In DocumentHandlerServlet :: getDocContentDetails() : " + docId);
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            Object inputStream = null;
            jsonObject = new JSONObject();
            try {
                try {
                    String sql = "SELECT DOC_ID,DOC_NAME,DOC_TYPE,DOC_PAGES,EXTRACTED_DATA,FILE_METADATA,DOC_SIZE,OVERVIEW_DATA FROM DOC_CONTENTS WHERE DOC_ID = " + docId;
                    BaseLogger.log("3", null, null, "DocumentHandlerServlet :: getVideoFrame() : sql [" + sql + "]");
                    String transDB = userInfo.getTransDB();
                    conn = new ConnDriver().getConnectDB(transDB);
                    st = conn.createStatement();
                    rs = st.executeQuery(sql);
                    if (rs.next()) {
                        Clob clob = rs.getClob("EXTRACTED_DATA");
                        InputStream is = clob.getAsciiStream();
                        BaseLogger.log("0", null, null, " getDocContentDetails() :EXTRACTED_DATA:" + clob);
                        String extractedData = clob.getSubString(1L, (int)clob.length());
                        Clob clobb = rs.getClob("OVERVIEW_DATA");
                        InputStream inputstream = clobb.getAsciiStream();
                        String overviewData = clobb.getSubString(1L, (int)clobb.length());
                        jsonObject.put("DOC_NAME", (Object)this.checkNull(rs.getString("DOC_NAME")));
                        jsonObject.put("DOC_TYPE", (Object)this.checkNull(rs.getString("DOC_TYPE")));
                        jsonObject.put("DOC_PAGES", (Object)this.checkNull(rs.getString("DOC_PAGES")));
                        jsonObject.put("EXTRACTED_DATA", (Object)this.checkNull(extractedData));
                        jsonObject.put("FILE_METADATA", (Object)this.checkNull(rs.getString("FILE_METADATA")));
                        jsonObject.put("DOC_SIZE", (Object)this.checkNull(rs.getString("DOC_SIZE")));
                        jsonObject.put("OVERVIEW_DATA", (Object)this.checkNull(overviewData));
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in DocumentHandlerServlet :: getDocContentDetails() : " + ex);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        if (st != null) {
                            st.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        break block21;
                    }
                    catch (Exception ex2) {
                        BaseLogger.log("0", null, null, "Exception in DocumentHandlerServlet :: closing connection: " + ex2);
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in DocumentHandlerServlet :: closing connection: " + ex);
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                if (st != null) {
                    st.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception in DocumentHandlerServlet :: closing connection: " + ex);
            }
        }
        BaseLogger.log("0", null, null, "getDocContentDetails()::jsonObject: " + jsonObject);
        return jsonObject.toString();
    }

    @Override
    public String removeFromContentLibrary(String docId, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retString = "";
        Connection conn = null;
        Statement mPstmt = null;
        String selQry = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "In DocumentHandlerWrapperEJB :removeFromContentLibrary docId [" + docId + "]");
                conn = this.getConnection(transDB);
                this.deleteAuditTrailDocAttachments(docId, conn);
                selQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID IN (" + docId + ")";
                BaseLogger.log("3", userInfo, null, "Execute --- " + selQry);
                mPstmt = conn.prepareStatement(selQry);
                int deletedDocRow = mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                selQry = "DELETE FROM USER_DOC_CONTENTS WHERE DOC_ID IN (" + docId + ")";
                mPstmt = conn.prepareStatement(selQry);
                int deletedUserDocRow = mPstmt.executeUpdate();
                mPstmt.close();
                mPstmt = null;
                conn.commit();
                retString = "ATTACHMENT REMOVED SUCCESSFULLY FROM CONTENT LIBRARY";
                BaseLogger.log("3", userInfo, null, "In DocumentHandlerWrapperEJB :removeFromContentLibrary deletedDocRow - [" + deletedDocRow + "] : deletedUserDocRow - [" + deletedUserDocRow + "]");
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :DocumentHandlerWrapperEJB :removeFromContentLibrary:==>" + ie.getMessage());
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB :removeFromContentLibrary :==>" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "In DocumentHandlerWrapperEJB :removeFromContentLibrary :retString[" + retString + "]");
        return retString;
    }

    public String saveYML(String dataStr) {
        String result = "";
        BaseLogger.log("3", null, null, "saveYML::dataStr :" + dataStr);
        try {
            JSONObject dataObj = new JSONObject(dataStr);
            String fileName = dataObj.getString("fileName");
            String ymlData = "";
            String logPath = String.valueOf(File.separator) + "inv2data_templates";
            BaseLogger.log("3", null, null, "saveYML::logPath --:" + logPath);
            File file = new File(String.valueOf(logPath) + File.separator + fileName + ".yml");
            File userFolder = new File(logPath);
            boolean isDirExist = false;
            if (!userFolder.exists()) {
                BaseLogger.log("3", null, null, "created new folder:" + file);
                isDirExist = userFolder.mkdir();
            } else {
                isDirExist = true;
            }
            if (isDirExist) {
                if (file.exists()) {
                    BaseLogger.log("3", null, null, "template file is present..");
                    ymlData = this.getUpdatedYmldata(file, dataObj);
                } else {
                    BaseLogger.log("3", null, null, "Creating new template file ..");
                    file.createNewFile();
                    ymlData = this.getNewYMLData(dataObj);
                }
                FileWriter fos = new FileWriter(file, false);
                fos.write(ymlData);
                fos.flush();
                fos.close();
                result = "successful";
                BaseLogger.log("3", null, null, "Activity Log Saved######### :" + file);
            } else {
                BaseLogger.log("3", null, null, "folder nor created :" + file);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DocumentHandlerWrapperEJB::saveYML" + e);
            result = "failed";
        }
        BaseLogger.log("3", null, null, "Activity Log Saved ::result:" + result);
        return result;
    }

    private String getUpdatedYmldata(File file, JSONObject dataObj) {
        String ymlData;
        block24: {
            BaseLogger.log("3", null, null, "in getUpdatedYmldata :: dataObj:" + dataObj);
            Scanner myReader = null;
            ymlData = "";
            boolean isLinePresentInFile = false;
            boolean isLinePresentInData = false;
            String tableStart = "";
            String tableEnd = "";
            String line = "";
            try {
                try {
                    StringBuffer ymlDataBfr = new StringBuffer();
                    myReader = new Scanner(file);
                    JSONObject newFields = this.getNewFields(dataObj);
                    while (myReader.hasNextLine()) {
                        String data = myReader.nextLine();
                        boolean isFieldsPresent = false;
                        String firstKeyword = dataObj.getString("keywords");
                        firstKeyword = firstKeyword.trim();
                        BaseLogger.log("3", null, null, "firstKeyword:[" + firstKeyword);
                        if (data.startsWith("keywords:") && firstKeyword.length() > 0) {
                            JSONObject keywordsMap = new JSONObject();
                            while (myReader.hasNextLine()) {
                                data = myReader.nextLine();
                                if (!data.startsWith(" ")) break;
                                BaseLogger.log("3", null, null, "..keywords::data" + data);
                                int coIndx = data.indexOf("-");
                                boolean notInfile = false;
                                if (coIndx == -1) continue;
                                String expr = data.substring(coIndx + 1);
                                expr = expr.trim();
                                BaseLogger.log("3", null, null, " firstKeyword[" + expr + "]");
                                BaseLogger.log("3", null, null, "is data key Present in new [" + keywordsMap.has(expr) + "] data:" + data);
                                if (keywordsMap.has(expr)) continue;
                                keywordsMap.put(expr, (Object)"");
                            }
                            if (!keywordsMap.has(firstKeyword)) {
                                keywordsMap.put(firstKeyword, (Object)"");
                            }
                            BaseLogger.log("3", null, null, " firstKeyword::[" + firstKeyword + "]");
                            String fieldsData = this.getKeywords(keywordsMap);
                            ymlDataBfr.append(fieldsData);
                            ymlDataBfr.append(System.getProperty("line.separator"));
                        }
                        if (data.startsWith("fields:")) {
                            BaseLogger.log("3", null, null, "newFields" + newFields);
                            while (myReader.hasNextLine()) {
                                data = myReader.nextLine();
                                if (!data.startsWith(" ")) break;
                                BaseLogger.log("3", null, null, "....data" + data);
                                int coIndx = data.indexOf(":");
                                boolean notInfile = false;
                                if (coIndx == -1) continue;
                                isFieldsPresent = true;
                                String lbl = data.substring(0, coIndx);
                                lbl = lbl.trim();
                                String Expr = data.substring(coIndx + 1);
                                lbl = lbl.trim();
                                lbl.toLowerCase();
                                Expr = Expr.trim();
                                BaseLogger.log("3", null, null, "lbl[" + lbl + "].Expr[" + Expr + "]");
                                BaseLogger.log("3", null, null, "is data key Present in new [" + newFields.has(lbl) + "] data:" + data);
                                if (newFields.has(lbl)) continue;
                                newFields.put(lbl, (Object)Expr);
                            }
                            if (isFieldsPresent) {
                                String fieldsData = this.getFieldsData(newFields);
                                ymlDataBfr.append(fieldsData);
                                ymlDataBfr.append(System.getProperty("line.separator"));
                            }
                        }
                        if (data.startsWith("lines:")) {
                            isLinePresentInFile = true;
                            ymlDataBfr.append(String.valueOf(data) + System.getProperty("line.separator"));
                            BaseLogger.log("3", null, null, "lines:");
                            if (dataObj.has("lines")) {
                                JSONObject linesObj = new JSONObject(dataObj.optString("lines"));
                                BaseLogger.log("3", null, null, " getUpdatedYmldata ::linesObj:" + linesObj);
                                if (linesObj.has("tableStart") && linesObj.has("tableEnd") && linesObj.has("line")) {
                                    tableStart = linesObj.getString("tableStart");
                                    tableEnd = linesObj.getString("tableEnd");
                                    line = linesObj.getString("line");
                                }
                            }
                            while (myReader.hasNextLine()) {
                                data = myReader.nextLine();
                                if (!data.startsWith(" ")) break;
                                BaseLogger.log("3", null, null, "....data" + data);
                                int coIndx = data.indexOf(":");
                                boolean notInfile = false;
                                if (coIndx == -1) continue;
                                isFieldsPresent = true;
                                String lbl = data.substring(0, coIndx);
                                lbl = lbl.trim();
                                BaseLogger.log("3", null, null, "is data lbl[" + lbl + "]");
                                if ("start".equals(lbl)) {
                                    if (tableStart.length() > 0) {
                                        ymlDataBfr.append("  start: " + tableStart + System.getProperty("line.separator"));
                                        continue;
                                    }
                                    ymlDataBfr.append(String.valueOf(data) + System.getProperty("line.separator"));
                                    continue;
                                }
                                if ("end".equals(lbl)) {
                                    if (tableEnd.length() > 0) {
                                        ymlDataBfr.append("  end: " + tableEnd + System.getProperty("line.separator"));
                                        continue;
                                    }
                                    ymlDataBfr.append(String.valueOf(data) + System.getProperty("line.separator"));
                                    continue;
                                }
                                if (!"line".equals(lbl)) continue;
                                if (line.length() > 0) {
                                    ymlDataBfr.append("  line: " + line + System.getProperty("line.separator"));
                                } else {
                                    ymlDataBfr.append(String.valueOf(data) + System.getProperty("line.separator"));
                                }
                                data = "";
                            }
                        }
                        ymlDataBfr.append(data);
                        ymlDataBfr.append(System.getProperty("line.separator"));
                    }
                    BaseLogger.log("0", null, null, "isLinePresentInFile[" + isLinePresentInFile + "] :: isLinePresentInData:" + isLinePresentInData);
                    if (!isLinePresentInFile) {
                        JSONObject linesObj = new JSONObject(dataObj.optString("lines"));
                        BaseLogger.log("3", null, null, " getUpdatedYmldata ::linesObj:" + linesObj);
                        if (linesObj.has("tableStart") && linesObj.has("tableEnd") && linesObj.has("line")) {
                            tableStart = linesObj.getString("tableStart");
                            tableEnd = linesObj.getString("tableEnd");
                            line = linesObj.getString("line");
                            ymlDataBfr.append("lines:" + System.getProperty("line.separator"));
                            ymlDataBfr.append("  start: " + tableStart + System.getProperty("line.separator"));
                            ymlDataBfr.append("  end: " + tableEnd + System.getProperty("line.separator"));
                            ymlDataBfr.append("  line: " + line + System.getProperty("line.separator"));
                        }
                    }
                    ymlData = ymlDataBfr.toString();
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Exception in getUpdatedYmldata : " + e);
                    e.printStackTrace();
                    myReader.close();
                    break block24;
                }
            }
            catch (Throwable throwable) {
                myReader.close();
                throw throwable;
            }
            myReader.close();
        }
        BaseLogger.log("3", null, null, "getUpdatedYmldata ymlData" + ymlData);
        return ymlData;
    }

    private String getKeywords(JSONObject dataObj) {
        BaseLogger.log("0", null, null, "getKeywords :: dataObj:" + dataObj);
        StringBuffer result = new StringBuffer();
        result.append("keywords:");
        try {
            JSONArray keys = dataObj.names();
            int i = 0;
            while (i < keys.length()) {
                String key = keys.getString(i);
                String value = dataObj.getString(key);
                result.append(System.getProperty("line.separator"));
                result.append("  - " + key);
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DocumentHandlerWrapperEJB::getKeywords" + e);
        }
        BaseLogger.log("0", null, null, "getKeywords::result" + result);
        return result.toString();
    }

    private String getFieldsData(JSONObject dataObj) {
        BaseLogger.log("0", null, null, "getFieldsData :: dataObj:" + dataObj);
        StringBuffer result = new StringBuffer();
        result.append("fields:");
        try {
            JSONArray keys = dataObj.names();
            int i = 0;
            while (i < keys.length()) {
                String key = keys.getString(i);
                String value = dataObj.getString(key);
                result.append(System.getProperty("line.separator"));
                result.append(String.format("  %s : %s", key.toLowerCase(), value));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DocumentHandlerWrapperEJB::getFieldsData" + e);
        }
        BaseLogger.log("0", null, null, "getFieldsData::result" + result);
        return result.toString();
    }

    private String getFirstFieldsData(JSONObject dataObj) {
        BaseLogger.log("0", null, null, "getFirstFieldsData :: dataObj:" + dataObj);
        StringBuffer result = new StringBuffer();
        try {
            JSONArray keys = dataObj.names();
            if (keys.length() > 0) {
                String key = keys.getString(0);
                result.append(System.getProperty("line.separator"));
                result.append("  -" + key.toLowerCase() + System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DocumentHandlerWrapperEJB::getFirstFieldsData" + e);
        }
        BaseLogger.log("0", null, null, "getFirstFieldsData::result" + result);
        return result.toString();
    }

    private JSONObject getNewFields(JSONObject dataObj) {
        JSONObject fields = new JSONObject();
        try {
            JSONArray fieldsArr = dataObj.getJSONArray("fields");
            BaseLogger.log("3", null, null, "getNewFields fieldsArr:" + fieldsArr);
            int i = 0;
            while (i < fieldsArr.length()) {
                JSONObject fieldObj = (JSONObject)fieldsArr.get(i);
                String label = fieldObj.getString("regularExpLabel");
                String regularExp = fieldObj.getString("regularExp");
                label = label.trim();
                fields.put(label.toLowerCase(), (Object)regularExp.trim());
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DocumentHandlerWrapperEJB::getNewFields" + e);
        }
        BaseLogger.log("3", null, null, "getNewFields result::fields:" + fields);
        return fields;
    }

    private String getNewYMLData(JSONObject dataObj) {
        StringBuffer dataYML = new StringBuffer();
        try {
            BaseLogger.log("3", null, null, "getNewYMLData::dataObj :" + dataObj);
            String issuer = dataObj.getString("issuer");
            String requiredFields = "";
            StringBuffer fieldsYML = new StringBuffer();
            JSONArray fieldsArr = dataObj.getJSONArray("fields");
            BaseLogger.log("3", null, null, "fieldsArr:" + fieldsArr);
            String keywords = "";
            int i = 0;
            while (i < fieldsArr.length()) {
                JSONObject fieldObj = (JSONObject)fieldsArr.get(i);
                String label = fieldObj.getString("regularExpLabel");
                String regularExp = fieldObj.getString("regularExp");
                fieldsYML.append(String.format("  %s : %s", label.toLowerCase(), regularExp));
                fieldsYML.append(System.getProperty("line.separator"));
                if (i == 0) {
                    requiredFields = label;
                    keywords = fieldObj.getString("labelOnFile");
                }
                ++i;
            }
            dataYML.append("issuer: " + issuer + System.getProperty("line.separator"));
            dataYML.append("keywords:" + System.getProperty("line.separator"));
            String firstKeyword = dataObj.getString("keywords");
            BaseLogger.log("3", null, null, "getNewYMLData ::firstKeyword:" + firstKeyword);
            if (firstKeyword.length() > 0) {
                dataYML.append("  - " + firstKeyword + System.getProperty("line.separator"));
            }
            dataYML.append("  - " + keywords + System.getProperty("line.separator"));
            dataYML.append("fields:" + System.getProperty("line.separator"));
            dataYML.append(fieldsYML);
            BaseLogger.log("3", null, null, "..fieldsYML:" + fieldsYML);
            dataYML.append("options:" + System.getProperty("line.separator"));
            dataYML.append("  remove_whitespace: false" + System.getProperty("line.separator"));
            dataYML.append("  currency: INR" + System.getProperty("line.separator"));
            if (requiredFields.length() > 0) {
                dataYML.append("required_fields:" + System.getProperty("line.separator"));
                dataYML.append("  - " + requiredFields.toLowerCase() + System.getProperty("line.separator"));
            }
            BaseLogger.log("3", null, null, "getNewYMLData ::lineslines:" + dataObj.optString("lines"));
            if (dataObj.has("lines")) {
                JSONObject linesObj = new JSONObject(dataObj.optString("lines"));
                BaseLogger.log("3", null, null, " getNewYMLData ::linesObj:" + linesObj);
                if (linesObj.has("tableStart") && linesObj.has("tableEnd") && linesObj.has("line")) {
                    String tableStart = linesObj.getString("tableStart");
                    String tableEnd = linesObj.getString("tableEnd");
                    String line = linesObj.getString("line");
                    dataYML.append("lines: " + System.getProperty("line.separator"));
                    dataYML.append("  start: " + tableStart + System.getProperty("line.separator"));
                    dataYML.append("  end: " + tableEnd + System.getProperty("line.separator"));
                    dataYML.append("  line: " + line + System.getProperty("line.separator"));
                }
            }
            BaseLogger.log("3", null, null, " getNewYMLData ::dataYML:" + dataYML);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception getNewYMLData:" + e);
        }
        return dataYML.toString();
    }

    private String getMaxUploadSizeErrorString(double maxUploadFileSize, double maxDocSize) {
        String msgNo = "MaxUploadExceed";
        String msgType = "E";
        String columnName = "";
        String msgString = "Max attachment size exceed";
        String msgDescription = "File size is greater than maximum size \nMaximum file size : " + maxUploadFileSize * 1024.0 + " KB \nSelected file size : " + maxDocSize * 1024.0 + " KB";
        return new E12GenericUtility().getErrorString(msgNo, msgType, columnName, msgString, msgDescription, "");
    }

    private boolean isRepositoryException(Exception e) {
        return e.getMessage().toLowerCase().indexOf("connection refused") != -1 || e.getMessage().toLowerCase().indexOf("gateway timeout") != -1;
    }

    private String updateExcetionMessage(String reString) throws ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        Document dom = genericUtility.parseString(reString);
        NodeList detailNList = dom.getElementsByTagName("error");
        Node eachDetailNode = detailNList.item(0);
        eachDetailNode.getAttributes().getNamedItem("type").setNodeValue("W");
        NodeList eachDetailChildNList = eachDetailNode.getChildNodes();
        int i = 0;
        while (i < eachDetailChildNList.getLength()) {
            Node node = eachDetailChildNList.item(i);
            if (node.getNodeType() == 1) {
                String nodeName = eachDetailChildNList.item(i).getNodeName();
                if (nodeName.equalsIgnoreCase("description")) {
                    String descr = eachDetailChildNList.item(i).getFirstChild().getNodeValue();
                    String msgDescr = String.valueOf(descr) + "\n\n" + Messages.getString("DocumentHandlerEJB_tryAgain");
                    eachDetailChildNList.item(i).getFirstChild().setNodeValue(msgDescr);
                } else if (nodeName.equalsIgnoreCase("type")) {
                    eachDetailChildNList.item(i).getFirstChild().setNodeValue("W");
                } else if (nodeName.equalsIgnoreCase("trace")) {
                    eachDetailChildNList.item(i).getFirstChild().setNodeValue("");
                }
            }
            ++i;
        }
        return genericUtility.serializeDom(dom);
    }

    private HashMap<String, String> getContentServiceCredential(String contentServiceName, UserInfoBean userInfo) {
        HashMap<String, String> contentServiceCredentialMap = new HashMap<String, String>();
        try {
            String multiTenant;
            HashMap serviceDetailsMap = (HashMap)CommonConstants.contentServicesMap.get(String.valueOf(contentServiceName) + "_DET");
            String userName = "admin";
            String password = "admin";
            if (serviceDetailsMap.containsKey("USER") && serviceDetailsMap.get("USER") != null) {
                userName = this.checkNull((String)serviceDetailsMap.get("USER"));
            }
            if (serviceDetailsMap.containsKey("PASSWORD") && serviceDetailsMap.get("PASSWORD") != null) {
                password = this.checkNull((String)serviceDetailsMap.get("PASSWORD"));
            }
            if ("Y".equalsIgnoreCase(multiTenant = this.checkNull((String)serviceDetailsMap.get("MULTI_TENANT")))) {
                String enterprise = userInfo.getEnterprise();
                userName = this.checkNull("admin@" + enterprise);
                JSONObject enterpriseDetailJson = CommonConstants.ENTERPRISE_DET_JSON;
                if (enterpriseDetailJson != null && enterpriseDetailJson.has(enterprise)) {
                    JSONObject enterpriseJson = (JSONObject)enterpriseDetailJson.get(enterprise);
                    password = this.checkNull(enterpriseJson.getString("CONTENT_SRV_PASS"));
                } else {
                    password = enterprise;
                }
            }
            contentServiceCredentialMap.put("USER", userName);
            contentServiceCredentialMap.put("PASSWORD", password);
            String connectionName = this.getContentServiceSessionMapKey(serviceDetailsMap, contentServiceName, userInfo);
            contentServiceCredentialMap.put("CONNECTION_NAME", connectionName);
            contentServiceCredentialMap.put("CONNECTION_ID", connectionName);
            contentServiceCredentialMap.put("BINDING_TYPE", this.checkNull((String)serviceDetailsMap.get("BINDING_TYPE")));
            String serverUrl = this.checkNull((String)CommonConstants.contentServicesMap.get(contentServiceName));
            contentServiceCredentialMap.put("SERVER_URL", serverUrl);
            contentServiceCredentialMap.put("HOST", this.checkNull((String)serviceDetailsMap.get("HOST")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return contentServiceCredentialMap;
    }

    private String getContentServiceSessionMapKey(HashMap<String, String> serviceDetailsMap, String contentServiceName, UserInfoBean userInfo) {
        String sessionMapKey = "";
        BaseLogger.log("3", userInfo, null, "serviceDetailsMap : [" + serviceDetailsMap + "]");
        String enterprise = userInfo.getEnterprise();
        String userId = userInfo.getLoginCode();
        String bindingType = this.checkNull(serviceDetailsMap.get("BINDING_TYPE"));
        String sessionMaintain = this.checkNull(serviceDetailsMap.get("SESSION_MAINTAIN"));
        sessionMapKey = "T".equalsIgnoreCase(sessionMaintain) ? enterprise : ("U".equalsIgnoreCase(sessionMaintain) ? userId : contentServiceName);
        sessionMapKey = String.valueOf(sessionMapKey) + "_" + bindingType;
        BaseLogger.log("3", null, null, "sessionMapKey : [" + sessionMapKey + "]");
        return sessionMapKey;
    }

    public String getExtractionTemplatePath(String objName, String docType, UserInfoBean userInfo) {
        String templatePath;
        block21: {
            BaseLogger.log("3", null, null, "getExtractionTemplatePath : objName[" + objName + "],docType[" + docType + "]");
            templatePath = "";
            Connection conn = null;
            String transDB = null;
            Statement mPstmt = null;
            ResultSet rs = null;
            String sql = "select EXTRACT_TEMPL from obj_attach_config where obj_name = ? and doc_type = ?";
            try {
                try {
                    transDB = userInfo.getTransDB();
                    conn = this.getConnection(transDB);
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, objName);
                    mPstmt.setString(2, docType);
                    rs = mPstmt.executeQuery();
                    BaseLogger.log("3", null, null, "getExtractionTemplatePath : sql[" + sql + "]");
                    if (rs.next()) {
                        templatePath = this.checkNull(rs.getString("EXTRACT_TEMPL"));
                    }
                    BaseLogger.log("3", null, null, "getExtractionTemplatePath : templatePath[" + templatePath + "]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (conn != null) {
                            conn.close();
                            BaseLogger.log("3", null, null, "getExtractionTemplatePath : conn.closed");
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                        BaseLogger.log("3", null, null, "getExtractionTemplatePath : conn.closed");
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    conn.close();
                    BaseLogger.log("3", null, null, "getExtractionTemplatePath : conn.closed");
                }
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "getExtractionTemplatePath : sql " + templatePath + " ] ");
        return templatePath;
    }

    public String updateFieldInputDetails(String docId, String docMetaData, String docType, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "In updateFieldInputDetails");
        String retString = "";
        Connection conn = null;
        Statement pStmt = null;
        try {
            try {
                String chgTerm = userInfo.getRemoteHost();
                conn = this.getConnection(userInfo.getTransDB());
                String sqlQry = "UPDATE DOC_CONTENTS SET DOC_META_DATA = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE DOC_ID = ?";
                BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                pStmt = conn.prepareStatement(sqlQry);
                pStmt.setString(1, docMetaData);
                pStmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pStmt.setString(3, userInfo.getLoginCode());
                pStmt.setString(4, chgTerm);
                pStmt.setString(5, docId);
                int updateCount = pStmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "updateCount : [" + updateCount + "]");
                if (updateCount == 1) {
                    String docName = this.getDocumentName(docId, userInfo.getTransDB(), conn);
                    retString = this.getUpdatedDocInfo(docId, docName, docType, userInfo.getLoginCode(), docMetaData);
                    if (conn != null) {
                        conn.commit();
                    }
                } else {
                    retString = "<Root><Detail>" + Messages.getString("DocumentHandlerEJB_notProperlyUpdated") + "</Detail></Root>";
                    if (conn != null) {
                        conn.rollback();
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return retString;
    }

    public HashMap<String, String> getFTPCredentials(UserInfoBean userInfo) {
        HashMap<String, String> ftpUserDetails;
        block13: {
            System.out.println("New changes on documenthandlerejb ");
            ftpUserDetails = new HashMap<String, String>();
            Connection conn = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    conn = this.getConnection(userInfo.getTransDB());
                    String sqlQuery1 = "select FTP_HOST,FTP_PORT ,FTP_USER ,FTP_PASS_WD  from ENTERPRISE where enterprise=?";
                    BaseLogger.log("3", userInfo, null, "sqlQuery1 [" + sqlQuery1 + "]");
                    String enterprise = userInfo.getEnterprise();
                    preparedStatement = conn.prepareStatement(sqlQuery1);
                    preparedStatement.setString(1, enterprise);
                    resultSet = preparedStatement.executeQuery();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (resultSet.next()) {
                        ftpUserDetails = new HashMap();
                        int columnCount = resultSetMetaData.getColumnCount();
                        int i = 1;
                        while (i <= columnCount) {
                            String columnName = resultSetMetaData.getColumnLabel(i);
                            ftpUserDetails.put(columnName, resultSet.getString(columnName));
                            ++i;
                        }
                    }
                    System.out.println("End of FTPUserDetails: " + ftpUserDetails);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        this.closeObject(resultSet);
                        this.closeObject(preparedStatement);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeObject(resultSet);
                    this.closeObject(preparedStatement);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ftpUserDetails;
    }

    public void updateDocContent(String docId, String docName, String docType, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "In updateDocContent");
        Statement pStmt = null;
        try {
            try {
                String chgTerm = userInfo.getRemoteHost();
                String sqlQry = "UPDATE DOC_CONTENTS SET DOC_NAME = ?, DOC_TYPE = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE DOC_ID = ?";
                BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                pStmt = conn.prepareStatement(sqlQry);
                pStmt.setString(1, docName);
                pStmt.setString(2, docType);
                pStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                pStmt.setString(4, userInfo.getLoginCode());
                pStmt.setString(5, chgTerm);
                pStmt.setString(6, docId);
                int updateCount = pStmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "updateCount : [" + updateCount + "]");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSharedFilesData(String data, String transDB) {
        JSONArray sharedDocFiles;
        block12: {
            PreparedStatement pstm = null;
            ResultSet resultSet = null;
            Connection con = null;
            sharedDocFiles = new JSONArray();
            try {
                try {
                    String sql = "SELECT dtl.DOC_ID, dc.DOC_NAME, length(dc.doc_object) as doc_size, dtl.DELETE_FLAG AS DELETE_FLAG FROM DOC_TRANSACTION_LINK dtl, DOC_CONTENTS dc, DOC_TYPE dt WHERE  dtl.DOC_ID = dc.DOC_ID AND dtl.DOC_TYPE_ATTACH=dt.DOC_TYPE and dt.IS_SHARED='1' and dtl.SHARED_DOC is null";
                    con = this.getConnection(transDB);
                    BaseLogger.log("3", this.userInfo, null, "query :" + sql);
                    pstm = con.prepareStatement(sql);
                    resultSet = pstm.executeQuery();
                    while (resultSet.next()) {
                        JSONObject sharedFile = new JSONObject();
                        String deleteFlag = this.checkNull(resultSet.getString("DELETE_FLAG"));
                        String docId = resultSet.getString("DOC_ID");
                        String name = resultSet.getString("DOC_NAME");
                        String size = resultSet.getString("DOC_SIZE");
                        if (deleteFlag.equalsIgnoreCase("Y")) continue;
                        sharedFile.put("docId", (Object)this.checkNull(docId));
                        sharedFile.put("name", (Object)this.checkNull(name));
                        sharedFile.put("desc", (Object)this.checkNull(""));
                        sharedFile.put("shDesc", (Object)this.checkNull(""));
                        sharedFile.put("size", (Object)this.checkNull(size));
                        sharedDocFiles.put((Object)sharedFile);
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", this.userInfo, null, "Exception in DocumentHandlerWrapperEJB :: getSharedFilesData() : " + ex);
                    try {
                        this.closeObject(resultSet);
                        this.closeObject(pstm);
                        this.closeObject(con);
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeObject(resultSet);
                    this.closeObject(pstm);
                    this.closeObject(con);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.closeObject(resultSet);
                this.closeObject(pstm);
                this.closeObject(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sharedDocFiles.toString();
    }

    public void deleteAuditTrailDocAttachments(String docId, Connection conn) {
        String sqlQry = null;
        Statement preparedStatement = null;
        ResultSet rs = null;
        boolean isDataExist = false;
        try {
            BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: Audit trail doc data docId:: [" + docId + "]");
            sqlQry = "SELECT DOC_ID__REF FROM AUDIT_TRAIL_DOC WHERE DOC_ID__REF ='" + this.checkNull(docId) + "'";
            preparedStatement = conn.prepareStatement(sqlQry);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                isDataExist = true;
            }
            BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: Audit trail doc data isDataExist:: [" + isDataExist + "]");
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (!isDataExist) {
                return;
            }
            try {
                BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: Audit trail doc data conn:: [" + conn + "]");
                sqlQry = "DELETE AUDIT_TRAIL_DOC WHERE DOC_ID__REF ='" + this.checkNull(docId) + "'";
                BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: Audit trail doc data sql:: [" + sqlQry + "]");
                preparedStatement = conn.prepareStatement(sqlQry);
                int deletedRow = preparedStatement.executeUpdate();
                BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: Audit trail doc data deletedRow:: [" + deletedRow + "]");
                if (deletedRow > 0) {
                    BaseLogger.log("3", this.userInfo, null, "::deleteAuditTrailDocAttachment:: <---- audit trail doc data deleted --->");
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
            catch (Exception ae) {
                ae.printStackTrace();
                BaseLogger.log("0", this.userInfo, null, "DocumentHandlerEJB ::deleteAuditTrailDocAttachment:: Exception is :==>" + ae);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", this.userInfo, null, "Exception :DocumentHandlerEJB ::deleteAuditTrailDocAttachment:: in finally Block :==>" + e);
            }
        }
    }

    public HashMap<String, String> getDocFileNames(String refId, String refSer, UserInfoBean userInfo) {
        HashMap<String, String> docDetailMap = new HashMap<String, String>();
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                String sql = "SELECT DC.DOC_ID AS DOC_ID, DC.DOC_NAME AS DOC_NAME, DTC.DELETE_FLAG AS DELETE_FLAG FROM DOC_CONTENTS DC, DOC_TRANSACTION_LINK DTC WHERE DTC.DOC_ID=DC.DOC_ID AND DTC.REF_SER=? AND DTC.REF_ID=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refSer);
                pstmt.setString(2, refId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String isFileDeleted = this.checkNull(rs.getString("DELETE_FLAG"));
                    if (!isFileDeleted.equalsIgnoreCase("Y")) {
                        docDetailMap.put(this.checkNull(rs.getString("DOC_ID")), this.checkNull(rs.getString("DOC_NAME")));
                    }
                    BaseLogger.log("3", null, null, "DocumentHandlerServlet :: getDocFileNames() : docDetailMap [" + docDetailMap + "]");
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception :: getDocFileNames : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return docDetailMap;
    }

    public String isDocumentShared(String docId, String refId, String refSer, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String isDocShared = "0";
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                String sql = "SELECT SHARED_DOC FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND REF_ID=? AND REF_SER=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docId);
                pstmt.setString(2, refId);
                pstmt.setString(3, refSer);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    isDocShared = this.checkNull(rs.getString("SHARED_DOC"));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception :: isDocumentShared : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isDocShared;
    }

    public String getDocTypeAttach(String docId, String refId, String refSer, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String docTypeAttach = "";
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                String sql = "SELECT DOC_TYPE_ATTACH FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND REF_ID=? AND REF_SER=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docId);
                pstmt.setString(2, refId);
                pstmt.setString(3, refSer);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    docTypeAttach = this.checkNull(rs.getString("DOC_TYPE_ATTACH"));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception :: getDocTypeAttach : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return docTypeAttach;
    }

    public Boolean isDocumentLocked(String getDocTypeAttach, String docId, String refId, String refSer, UserInfoBean userInfo) {
        String lockApplicable;
        String docStatus;
        block24: {
            Statement pstmt = null;
            ResultSet rs = null;
            Connection conn = null;
            docStatus = "";
            lockApplicable = "";
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    conn = new ConnDriver().getConnectDB(transDB);
                    String sql = "SELECT DTL.DOC_STATUS AS DOC_STATUS, DT.LOCK_APPLICABLE AS LOCK_APPLICABLE FROM DOC_TRANSACTION_LINK DTL, DOC_TYPE DT WHERE DT.DOC_TYPE = DTL.DOC_TYPE_ATTACH AND DT.DOC_TYPE=? AND DTL.REF_ID=? AND DTL.REF_SER=? AND DTL.DOC_ID=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, getDocTypeAttach);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, refSer);
                    pstmt.setString(4, docId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        docStatus = this.checkNull(rs.getString("DOC_STATUS"));
                        lockApplicable = this.checkNull(rs.getString("LOCK_APPLICABLE"));
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception :: docStatus, lockApplicable : " + ex.getMessage());
                    ex.printStackTrace();
                    try {
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        break block24;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (docStatus.equalsIgnoreCase("1") && lockApplicable.equalsIgnoreCase("1")) {
            return true;
        }
        return false;
    }

    public void updateDocStatus(String docId, String refId, String refSer, String DocStatus, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                String sql = "UPDATE DOC_TRANSACTION_LINK SET DOC_STATUS =" + DocStatus + " WHERE DOC_ID=? AND REF_ID=? AND REF_SER=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docId);
                pstmt.setString(2, refId);
                pstmt.setString(3, refSer);
                int updateCount = pstmt.executeUpdate();
                pstmt.clearParameters();
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (updateCount > 0) {
                    conn.commit();
                }
            }
            catch (Exception ex) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseLogger.log("0", null, null, "Exception :: updateDocStatus : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][updateDocStatus] :==>\n" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {}
                BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][updateDocStatus] :==>\n" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void updateCheckInRemarks(String transDB, String checkInRemarks, String refId, String refSer, UserInfoBean userInfo, String objName) throws RemoteException, ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String tableName = "";
        String tranIdCol = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                conn = this.getConnection(transDB);
                String sql = "SELECT TRAN_ID_COL, TABLE_NAME FROM TRANSETUP WHERE TRAN_WINDOW=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, "w_" + objName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    tableName = rs.getString("TABLE_NAME");
                    tranIdCol = rs.getString("TRAN_ID_COL");
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                BaseLogger.log("3", userInfo, null, "tableName : [" + tableName + "] trandIdCol [" + tranIdCol + "]");
                String chgUser = userInfo.getLoginCode();
                String sqlUpd = "";
                int commaAvalibale = tranIdCol.indexOf(",");
                if (commaAvalibale != -1) {
                    String[] trandIdCol_array = tranIdCol.split(",");
                    String[] REF_ID_array = refId.split(":");
                    String sqlSuffix = "";
                    int j = 0;
                    while (j < trandIdCol_array.length) {
                        sqlSuffix = j != trandIdCol_array.length - 1 ? String.valueOf(sqlSuffix) + trandIdCol_array[j] + " = '" + REF_ID_array[j] + "' AND " : String.valueOf(sqlSuffix) + trandIdCol_array[j] + " = '" + REF_ID_array[j] + "'";
                        ++j;
                    }
                    sqlUpd = "UPDATE " + tableName + " SET REMARKS = ?, CHG_USER = ?, CHG_DATE = ? WHERE " + sqlSuffix;
                } else {
                    sqlUpd = "UPDATE " + tableName + " SET REMARKS = ?, CHG_USER = ?, CHG_DATE = ? WHERE " + tranIdCol + " = ?";
                }
                if (!"".equals(sqlUpd)) {
                    pstmt = conn.prepareStatement(sqlUpd);
                    pstmt.setString(1, checkInRemarks);
                    pstmt.setString(2, chgUser);
                    pstmt.setDate(3, new Date(new java.util.Date().getTime()));
                    pstmt.setString(4, refId);
                    int updCnt = pstmt.executeUpdate();
                    pstmt.clearParameters();
                }
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][updateCheckInRemarks] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateUserDetails(String refId, String refSer, String docId, String action, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                String sql = "UPDATE DOC_TRANSACTION_LINK SET LAST_UPDATED_ON=?, LAST_UPDATED_BY=?, LAST_OPERATION=? WHERE DOC_ID=? AND REF_ID=? AND REF_SER=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setDate(1, new Date(new java.util.Date().getTime()));
                pstmt.setString(2, userInfo.getLoginCode());
                pstmt.setString(3, action);
                pstmt.setString(4, docId);
                pstmt.setString(5, refId);
                pstmt.setString(6, refSer);
                int updateCount = pstmt.executeUpdate();
                pstmt.clearParameters();
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (updateCount > 0) {
                    conn.commit();
                }
            }
            catch (Exception ex) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseLogger.log("0", null, null, "Exception :: updateUserDetails : " + ex.getMessage());
                ex.printStackTrace();
                try {
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][updateUserDetails] :==>\n" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {}
                BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][updateUserDetails] :==>\n" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public int updateSharedFileDocUUID(String docId, String refId, String refSer, UserInfoBean userInfo) {
        int isdocUUIDUpdated;
        block27: {
            Statement pstmt = null;
            ResultSet rs = null;
            Connection conn = null;
            String docUUID = "";
            isdocUUIDUpdated = 0;
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    conn = new ConnDriver().getConnectDB(transDB);
                    String sql = "SELECT DOC_UUID FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND REF_ID=? AND REF_SER=? AND SHARED_DOC IS NULL";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, docId);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, refSer);
                    BaseLogger.log("3", userInfo, null, "updateSharedFileDocUUID :: sql : [" + sql + "]");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        docUUID = this.checkNull(rs.getString("DOC_UUID"));
                        BaseLogger.log("3", userInfo, null, "updateSharedFileDocUUID :: docUUID : [" + docUUID + "]");
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (!docUUID.equalsIgnoreCase("")) {
                        String updateSql = "UPDATE DOC_TRANSACTION_LINK SET DOC_UUID=? WHERE DOC_ID=? AND SHARED_DOC=?";
                        pstmt = conn.prepareStatement(updateSql);
                        pstmt.setString(1, docUUID);
                        pstmt.setString(2, docId);
                        pstmt.setString(3, "1");
                        BaseLogger.log("3", userInfo, null, "updateSharedFileDocUUID :: updateSql : [" + updateSql + "]");
                        isdocUUIDUpdated = pstmt.executeUpdate();
                        pstmt.clearParameters();
                    }
                    if (isdocUUIDUpdated > 0) {
                        String refIdSql = "SELECT REF_ID FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND SHARED_DOC=?";
                        pstmt = conn.prepareStatement(refIdSql);
                        pstmt.setString(1, docId);
                        pstmt.setString(2, "1");
                    }
                }
                catch (Exception e) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BaseLogger.log("0", null, null, "Exception : [DocumentHandlerServlet][getSharedFileDocUUID] :==>\n" + e.getMessage());
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                            conn = null;
                        }
                        break block27;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        BaseLogger.log("3", userInfo, null, "updateSharedFileDocUUID :: isdocUUIDUpdated : [" + isdocUUIDUpdated + "]");
        return isdocUUIDUpdated;
    }

    public ArrayList<String> getSharedDocRefId(String docId, String sharedDoc, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ArrayList<String> refIdList = new ArrayList<String>();
        try {
            try {
                String sql = "SELECT DISTINCT REF_ID AS REF_ID, REF_SER AS REF_SER FROM DOC_TRANSACTION_LINK WHERE DOC_ID=? AND SHARED_DOC=?";
                conn = this.getConnection(userInfo.getTransDB());
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docId);
                pstmt.setString(2, sharedDoc);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    refIdList.add(String.valueOf(rs.getString("REF_ID")) + "~SEP~" + rs.getString("REF_SER"));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getSharedDocRefId:: :==>" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getSharedDocRefId:: in finally Block :==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getSharedDocRefId:: in finally Block :==>" + e);
            }
        }
        return refIdList;
    }

    public String getObjName(String refSer, UserInfoBean userInfo) {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String objName = "";
        try {
            try {
                String sql = "SELECT TRAN_WINDOW FROM TRANSETUP WHERE REF_SER=?";
                conn = this.getConnection(userInfo.getTransDB());
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, refSer);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    objName = rs.getString("TRAN_WINDOW");
                    objName = objName.substring(2);
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getObjName::  :==>" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getSharedDocRefId:: in finally Block :==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getSharedDocRefId:: in finally Block :==>" + e);
            }
        }
        return objName;
    }

    public void saveDocProcessTrail(String docId, String procTrailStr, UserInfoBean userInfo) {
        DocumentProcessTrail docProcTrail = new DocumentProcessTrail();
        try {
            JSONObject procTrailObj = new JSONObject(procTrailStr);
            Iterator itr = procTrailObj.keys();
            while (itr.hasNext()) {
                String processId = (String)itr.next();
                JSONObject tempObj = procTrailObj.optJSONObject(processId);
                if (tempObj == null) continue;
                docProcTrail.insertIntoDocProcTrail(docId, tempObj.optString("PROC_MTD"), processId, tempObj.optString("RESPONSE_DATA"), tempObj.optString("REQUEST_PARAM"), tempObj.optString("ERROR_INFO"), userInfo);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::saveDocProcessTrail:: :==>" + e);
        }
    }

    public void updateExtractedData(String docId, String extractedData, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "In updateExtractedData");
        Statement pStmt = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String chgTerm = userInfo.getRemoteHostName();
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                String sqlQry = "UPDATE DOC_CONTENTS SET EXTRACTED_DATA = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE DOC_ID = ?";
                BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                pStmt = conn.prepareStatement(sqlQry);
                if ("oracle".equalsIgnoreCase(this.database)) {
                    CLOB clob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    clob.putString(1L, extractedData);
                    pStmt.setClob(1, (Clob)clob);
                } else {
                    pStmt.setString(1, extractedData);
                }
                pStmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pStmt.setString(3, userInfo.getLoginCode());
                pStmt.setString(4, chgTerm);
                pStmt.setString(5, docId);
                int updateCount = pStmt.executeUpdate();
                if (updateCount > 0) {
                    conn.commit();
                }
                BaseLogger.log("3", userInfo, null, "updateExtractedData updateCount : [" + updateCount + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateExtractedData::catch:==>" + e);
                try {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateExtractedData::finally:==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateExtractedData::finally:==>" + e);
            }
        }
    }

    public void updateProcessStatus(String docId, String procStatus, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "In updateProcessStatus");
        Statement pStmt = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String sqlQry = "UPDATE USER_DOC_CONTENTS SET PROC_STATUS = ? WHERE DOC_ID = ?";
                BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                pStmt = conn.prepareStatement(sqlQry);
                pStmt.setString(1, procStatus);
                pStmt.setString(2, docId);
                int updateCount = pStmt.executeUpdate();
                if (updateCount > 0) {
                    conn.commit();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                BaseLogger.log("3", userInfo, null, "updateProcessStatus updateCount : [" + updateCount + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateProcessStatus::catch:==>" + e);
                try {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateExtractedData::finally:==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateExtractedData::finally:==>" + e);
            }
        }
    }

    public JSONArray getDocTypeList(JSONArray resultData, String searchType, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "getDocTypeList :: docids : [" + resultData + "] length [" + resultData.length() + "]");
        BaseLogger.log("3", userInfo, null, "print line no 9560 searchType [" + searchType + "]");
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        Statement stmt = null;
        ResultSet mResultSet = null;
        String docId = "";
        String docType = "";
        String documentName = "";
        java.util.Date chgDate = new java.util.Date();
        JSONArray documentArray = new JSONArray();
        JSONObject nestedObject = new JSONObject();
        try {
            try {
                if (resultData.length() > 0) {
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    StringBuffer paramBuffer = new StringBuffer();
                    int i = 0;
                    while (i < resultData.length()) {
                        paramBuffer.append("'" + resultData.optString(i) + "',");
                        ++i;
                    }
                    BaseLogger.log("3", userInfo, null, "docid list [" + paramBuffer.toString() + "]");
                    String parameter = paramBuffer.toString();
                    parameter = parameter.substring(0, parameter.length() - 1);
                    String docAnswer = "";
                    if ("Q".equalsIgnoreCase(searchType)) {
                        StringBuffer paramBufferNew = new StringBuffer();
                        BaseLogger.log("3", userInfo, null, "print line no 9582 resultData [" + resultData.length() + "] resultData [" + resultData + "]");
                        int i2 = 0;
                        while (i2 < resultData.length()) {
                            String jsonStr = resultData.optString(i2);
                            JSONObject jsonobject = new JSONObject(jsonStr);
                            if (jsonobject != null) {
                                JSONArray docIdArray = jsonobject.optJSONArray("doc_id_list");
                                docAnswer = jsonobject.optString("answer");
                                if (docIdArray != null) {
                                    int j = 0;
                                    while (j < docIdArray.length()) {
                                        nestedObject = docIdArray.optJSONObject(i2);
                                        Iterator keys = nestedObject.keys();
                                        while (keys.hasNext()) {
                                            String key = (String)keys.next();
                                            paramBufferNew.append("'" + key + "',");
                                        }
                                        ++j;
                                    }
                                }
                            }
                            ++i2;
                        }
                        parameter = paramBufferNew.toString();
                        parameter = parameter.substring(0, parameter.length() - 1);
                    }
                    String sqlQry = "SELECT DOC_TYPE, DOC_ID,DOC_NAME,CHG_DATE FROM DOC_CONTENTS WHERE DOC_ID IN (" + parameter.toString() + ")";
                    BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                    stmt = conn.prepareStatement(sqlQry);
                    mResultSet = stmt.executeQuery();
                    while (mResultSet.next()) {
                        docId = mResultSet.getString("DOC_ID");
                        docType = mResultSet.getString("DOC_TYPE");
                        documentName = mResultSet.getString("DOC_NAME");
                        chgDate = mResultSet.getDate("CHG_DATE");
                        JSONObject documentData = new JSONObject();
                        documentData.put("DOC_NAME", (Object)documentName);
                        documentData.put("FILE_TYPE", (Object)docType);
                        documentData.put("DOC_ID", (Object)docId);
                        documentData.put("CHG_DATE", (Object)chgDate);
                        if (docAnswer != null) {
                            documentData.put("ANSWER", (Object)docAnswer);
                        }
                        String matchedValue = "";
                        if (nestedObject != null && nestedObject.has(docId)) {
                            matchedValue = nestedObject.optString(docId);
                            documentData.put("PAGE_CONTENT", (Object)matchedValue);
                        }
                        documentArray.put((Object)documentData);
                    }
                    BaseLogger.log("3", userInfo, null, "documentArray [" + documentArray + "]");
                    mResultSet.close();
                    mResultSet = null;
                    stmt.close();
                    stmt = null;
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeList::" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeList::finally:==>" + e);
            }
        }
        return documentArray;
    }

    public void trainDocument(String docId, String documentType, String ocrData, UserInfoBean userInfo) {
        BaseLogger.log("3", userInfo, null, "trainDocument :: docid : [" + docId + "] docType [" + documentType + "] ocrData : [" + ocrData + "]");
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        APIUtility apiUtility = new APIUtility();
        Statement stmt = null;
        ResultSet mResultSet = null;
        String enableCognitive = "";
        String procMtd = "";
        String result = "";
        try {
            try {
                String dataExtractorServiceURL = "";
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String sqlQry = "SELECT ENABLE_COGNITIVE, DEF_PROC_MTD FROM DOC_TYPE WHERE DOC_TYPE = ?";
                stmt = conn.prepareStatement(sqlQry);
                stmt.setString(1, documentType);
                mResultSet = stmt.executeQuery();
                while (mResultSet.next()) {
                    enableCognitive = this.checkNull(mResultSet.getString("ENABLE_COGNITIVE"));
                    procMtd = this.checkNull(mResultSet.getString("DEF_PROC_MTD"));
                }
                if ("Y".equalsIgnoreCase(enableCognitive)) {
                    Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
                    String serverUrl = "";
                    if (pythonServicesMap != null) {
                        Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                        String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                        String host = proteusSenseServiceDetails.get("HOST");
                        String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                        String path = apiUtility.getAPIUrl(userInfo, "VectorTraining");
                        if (path.contains("WeaviateVector")) {
                            serverUrl = apiUtility.getAPIUrl(userInfo, "WeaviateVector");
                        }
                        dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                        BaseLogger.log("3", null, null, "print dataExtractorServiceURL:::::," + dataExtractorServiceURL);
                    }
                    JSONObject configData = new JSONObject();
                    JSONArray ocrDataArray = new JSONArray();
                    JSONObject objData = new JSONObject();
                    ArrayList<String> openaiParams = apiUtility.getAPIKey(userInfo, "OpenAI");
                    ArrayList<String> pineConeParams = apiUtility.getAPIKey(userInfo, "PineCone");
                    String fileName = this.getDocumentFile(docId, userInfo.getTransDB());
                    File fileObj = new File(fileName);
                    objData.put("id", (Object)docId);
                    objData.put("description", (Object)ocrData);
                    JSONObject jsonObject = this.getOrderedJSONObject(objData.toString());
                    System.out.println("print jsonObject:::," + jsonObject);
                    ocrDataArray.put((Object)jsonObject);
                    System.out.println("print ocrDataArray:::," + ocrDataArray);
                    configData.put("index_name", (Object)"document");
                    configData.put("openAI_apiKey", (Object)openaiParams.get(0));
                    configData.put("pineCone_apiKey", (Object)pineConeParams.get(0));
                    configData.put("enterprise", (Object)userInfo.getEnterprise());
                    configData.put("dfJson", (Object)ocrDataArray.toString());
                    configData.put("proc_mtd", (Object)procMtd);
                    configData.put("server_url", (Object)serverUrl);
                    String configDataStr = configData.toString();
                    System.out.println("print configDataStr:::," + configDataStr);
                    String encodedParams = URLEncoder.encode(configDataStr, "UTF-8");
                    String dataExtractorService = dataExtractorServiceURL.endsWith("?") ? String.valueOf(dataExtractorServiceURL) + "jsonData=" + encodedParams : String.valueOf(dataExtractorServiceURL) + "?jsonData=" + encodedParams;
                    BaseLogger.log("3", null, null, "06122023 dataExtractorService [" + dataExtractorService + "]");
                    BaseLogger.log("3", null, null, "06122023 fileObj.exists() [" + fileObj.exists() + "] fileObj.getName() [" + fileObj.getName() + "]");
                    BaseLogger.log("3", null, null, "trainDocument makeMultipartRequest START [" + System.currentTimeMillis() + "]");
                    byte[] responseData = E12GenericUtility.makeMultipartRequest(dataExtractorService, fileObj);
                    BaseLogger.log("3", null, null, "trainDocument makeMultipartRequest END [" + System.currentTimeMillis() + "]");
                    result = new String(responseData);
                }
                mResultSet.close();
                mResultSet = null;
                stmt.close();
                stmt = null;
                conn.close();
                conn = null;
            }
            catch (Exception e) {
                e12GenericUtility.createErrorString(e);
                BaseLogger.log("3", null, null, "Exception :trainDocument :==>" + e12GenericUtility.createErrorString(e));
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :trainDocument::finally:==>" + e2);
                }
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :trainDocument::finally:==>" + e);
            }
        }
    }

    private JSONObject getOrderedJSONObject(String json) {
        JSONObject argumentJson = new JSONObject();
        try {
            argumentJson = new JSONObject(json){

                public JSONObject put(String key, Object value) throws JSONException {
                    try {
                        Field map = JSONObject.class.getDeclaredField("map");
                        map.setAccessible(true);
                        Object mapValue = map.get((Object)this);
                        if (!(mapValue instanceof LinkedHashMap)) {
                            map.set((Object)this, new LinkedHashMap());
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    return super.put(key, value);
                }
            };
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error :GenerateFormLayout :getOrderedJSONObject :==> " + e);
            e.printStackTrace();
        }
        System.out.println("argumentJson:::::;" + argumentJson);
        return argumentJson;
    }

    public void updateOverviewData(String docId, String overviewData, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "In updateOverviewData");
        Statement pStmt = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String chgTerm = userInfo.getRemoteHostName();
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                String sqlQry = "UPDATE DOC_CONTENTS SET OVERVIEW_DATA = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE DOC_ID = ?";
                BaseLogger.log("3", userInfo, null, "sqlQry [" + sqlQry + "]");
                pStmt = conn.prepareStatement(sqlQry);
                if ("oracle".equalsIgnoreCase(this.database)) {
                    CLOB clob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    clob.putString(1L, overviewData);
                    pStmt.setClob(1, (Clob)clob);
                } else {
                    pStmt.setString(1, overviewData);
                }
                pStmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pStmt.setString(3, userInfo.getLoginCode());
                pStmt.setString(4, chgTerm);
                pStmt.setString(5, docId);
                int updateCount = pStmt.executeUpdate();
                if (updateCount > 0) {
                    conn.commit();
                }
                BaseLogger.log("3", userInfo, null, "updateOverviewData updateCount : [" + updateCount + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateOverviewData::catch:==>" + e);
                try {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateOverviewData::finally:==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::updateOverviewData::finally:==>" + e);
            }
        }
    }

    public String validateCustomerDetails(String entType, String entCode, UserInfoBean userInfo) {
        String errMessage = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        boolean isValid = false;
        String sql = "";
        try {
            try {
                E12GenericUtility e12GenericUtility;
                block50: {
                    e12GenericUtility = new E12GenericUtility();
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    if ("".equalsIgnoreCase(entType) || "".equalsIgnoreCase(entCode)) break block50;
                    switch (entType.toUpperCase()) {
                        case "E": {
                            sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE=?";
                            break;
                        }
                        case "S": {
                            sql = "SELECT COUNT(*) AS COUNT FROM SUPPLIER WHERE SUPP_CODE=?";
                            break;
                        }
                        case "C": {
                            sql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE=?";
                            break;
                        }
                        case "T": {
                            sql = "SELECT COUNT(*) AS COUNT FROM TRANSPORTER WHERE TRAN_CODE=?";
                            break;
                        }
                        case "P": {
                            sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS=?";
                            break;
                        }
                        case "X": {
                            sql = "SELECT COUNT(*) AS COUNT FROM TAX_AUTHORITY WHERE TAUTH_CODE=?";
                            break;
                        }
                        case "L": {
                            sql = "SELECT COUNT(*) AS COUNT FROM LOANPARTY WHERE PARTY_CODE=?";
                            break;
                        }
                        case "R": {
                            sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE=?";
                            break;
                        }
                        case "B": {
                            sql = "SELECT COUNT(*) AS COUNT FROM BANK WHERE BANK_CODE=?";
                            break;
                        }
                    }
                    if (!sql.equalsIgnoreCase("")) {
                        int cnt;
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, entCode);
                        rs = pstmt.executeQuery();
                        if (rs.next() && (cnt = rs.getInt("COUNT")) > 0) {
                            isValid = true;
                        }
                    }
                }
                if (!isValid) {
                    errMessage = e12GenericUtility.getErrorJson("CUST_CODE", "VTINVCUSTC", userInfo.getLoginCode());
                    BaseLogger.log("3", userInfo, null, "Returning errMessage::: 9888[" + errMessage + "]");
                }
                BaseLogger.log("3", userInfo, null, "Returning errMessage:::[" + errMessage + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::validateCustomerDetails" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::validateCustomerDetails::finally:==>" + e2);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::validateCustomerDetails::finally:==>" + e);
            }
        }
        return errMessage;
    }

    public String getEntityType(UserInfoBean userInfo, String documentType) {
        String entType;
        block21: {
            entType = "C";
            Statement mPstmt = null;
            ResultSet rs = null;
            Connection conn = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    String sql = "SELECT ENT_TYPE FROM DOC_TYPE WHERE DOC_TYPE = ?";
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, documentType);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        entType = "".equalsIgnoreCase(this.checkNull(rs.getString("ENT_TYPE"))) ? entType : this.checkNull(rs.getString("ENT_TYPE"));
                    }
                    mPstmt.close();
                    mPstmt = null;
                    rs.close();
                    rs = null;
                    conn.close();
                    conn = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getEntityType" + e);
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getEntityType" + e2);
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getEntityType" + e);
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getEntityType" + e);
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "entType::::9980 [ " + entType + " ] ");
        return entType;
    }

    public String getDocTypeObj(UserInfoBean userInfo, String documentType) {
        JSONObject docTypeObj;
        block21: {
            docTypeObj = new JSONObject();
            Statement mPstmt = null;
            ResultSet rs = null;
            Connection conn = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    String sql = "SELECT SAVE_TYPE, OBJ_NAME__IMP FROM DOC_TYPE WHERE DOC_TYPE=?";
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, documentType);
                    rs = mPstmt.executeQuery();
                    if (rs.next()) {
                        docTypeObj.put("save_type", (Object)rs.getString("SAVE_TYPE"));
                        docTypeObj.put("obj_name__imp", (Object)rs.getString("OBJ_NAME__IMP"));
                    }
                    mPstmt.close();
                    mPstmt = null;
                    rs.close();
                    rs = null;
                    conn.close();
                    conn = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeObj::" + e);
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (mPstmt != null) {
                            mPstmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeObj::" + e2);
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeObj::" + e);
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mPstmt != null) {
                    mPstmt.close();
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::getDocTypeObj::" + e);
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "getDocTypeObj docTypeObj.toString():::: [ " + docTypeObj.toString() + " ] ");
        return docTypeObj.toString();
    }

    public String saveImportOrderItem(String docId, String docName, String itemCodeStr, UserInfoBean userInfo) throws ITMException, SQLException {
        Statement mPstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String retString = "";
        BaseLogger.log("2", userInfo, null, "Print saveImportOrderItem itemCodeStr:::: " + itemCodeStr + " ::::::::::");
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                java.util.Date date = new java.util.Date();
                SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.DB_DATETIME_FORMAT);
                String currentDate = formatter.format(date.getTime());
                Timestamp requestDate = Timestamp.valueOf(currentDate.trim());
                JSONArray itemCodeArr = new JSONArray(itemCodeStr);
                int i = 0;
                while (i < itemCodeArr.length()) {
                    JSONObject itemObject = itemCodeArr.getJSONObject(i);
                    String modifyItemCode = itemObject.optString("item_code");
                    String modifyItemDescr = itemObject.optString("descr");
                    String extractedDescr = itemObject.optString("extract_descr");
                    String vectorItemCode = itemObject.optString("vector_item_code");
                    String vectorItemDescr = itemObject.optString("vector_descr");
                    String lookupItemCode = itemObject.optString("system_item_code");
                    String lookupItemDescr = itemObject.optString("system_item_descr");
                    String tranId = commonDBAccessEJB.generateSeq("IMPORT_ORDER_SEQ", 20, userInfo.getTransDB());
                    String sql = "INSERT INTO IMPORT_ORDER_ITEM_INFO (TRAN_ID, DOC_ID, DOC_NAME, MODIFY_ITEM_CODE, MODIFY_ITEM_DESCR, EXTRACTED_DESCR, VECTOR_ITEM_CODE, VECTOR_ITEM_DESCR, LOOKUP_ITEM_CODE, LOOKUP_ITEM_DESCR, ADD_DATE, ADD_TERM, ADD_USER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    mPstmt = conn.prepareStatement(sql);
                    mPstmt.setString(1, tranId);
                    mPstmt.setString(2, docId);
                    mPstmt.setString(3, docName);
                    mPstmt.setString(4, modifyItemCode);
                    mPstmt.setString(5, modifyItemDescr);
                    mPstmt.setString(6, extractedDescr);
                    mPstmt.setString(7, vectorItemCode);
                    mPstmt.setString(8, vectorItemDescr);
                    mPstmt.setString(9, lookupItemCode);
                    mPstmt.setString(10, lookupItemDescr);
                    mPstmt.setTimestamp(11, requestDate);
                    mPstmt.setString(12, userInfo.getTermId());
                    mPstmt.setString(13, userInfo.getLoginCode());
                    rs = mPstmt.executeQuery();
                    ++i;
                }
                retString = "<Root><Detail>Success</Detail></Root>";
                conn.commit();
                mPstmt.close();
                mPstmt = null;
                rs.close();
                rs = null;
                conn.close();
                conn = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB saveImportOrderItem:::" + E12GenericUtility.getStackTrace(e));
                ITMException itm = new ITMException(e);
                retString = itm.getMessage();
                conn.rollback();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::saveImportOrderItem::" + E12GenericUtility.getStackTrace(e2));
                    ITMException itm2 = new ITMException(e2);
                    retString = itm2.getMessage();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (mPstmt != null) {
                    mPstmt.close();
                    mPstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :DocumentHandlerWrapperEJB ::saveImportOrderItem::" + E12GenericUtility.getStackTrace(e));
                ITMException itm = new ITMException(e);
                retString = itm.getMessage();
            }
        }
        return retString;
    }

    public void updateDocumentIsDownloaded(String isDownloaded, String docId, UserInfoBean userInfo) throws RemoteException, ITMException, SQLException {
        Connection connection = null;
        Statement pstmt = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                connection = connDriver.getConnectDB(transDB);
                String updateQuery = "UPDATE DOC_CONTENTS SET IS_DOWNLOADED = ? WHERE DOC_ID = ?";
                pstmt = connection.prepareStatement(updateQuery);
                pstmt.setString(1, isDownloaded);
                pstmt.setString(2, docId);
                int updateCount = pstmt.executeUpdate();
                BaseLogger.log("3", userInfo, null, "DocumentHandlerWrapperEJB.updateDocumentIsDownloaded() DOC_CONTENTS.IS_DOWNLOADED update count : [" + updateCount + "]");
                connection.commit();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                connection.rollback();
                BaseLogger.log("0", userInfo, null, "DocumentHandlerWrapperEJB.updateDocumentIsDownloaded() : Exception [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("DocumentHandlerWrapperEJB.updateDocumentIsDownloaded() : Exception :==>finally : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
    }

    static /* synthetic */ UserInfoBean access$0(DocumentHandlerWrapperEJB documentHandlerWrapperEJB) {
        return documentHandlerWrapperEJB.userInfo;
    }
}

