/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.Messages;
import ibase.webitm.ejb.ITMFreeFormEJB;
import ibase.webitm.ejb.XSLBuilderEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ITMFreeFormBean
implements Serializable {
    String objName;
    String pContext = "2";
    String objContext = "1";
    String editFlag = "A";
    String reqParamStr = "";
    private boolean isDataFound = true;
    String userLang = "en";
    String userCountry = "US";
    UserInfoBean userInfo = null;
    private String editor = "WebEditor";

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPContext(String pContext) {
        if (pContext != null && !"null".equalsIgnoreCase(pContext) && pContext.length() > 0) {
            this.pContext = pContext;
        }
    }

    public String getPContext() {
        return this.pContext;
    }

    public void setObjContext(String objContext) {
        if (objContext != null && !"null".equalsIgnoreCase(objContext) && objContext.length() > 0) {
            this.objContext = objContext;
        }
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String editFlag) {
        if (editFlag != null && !"null".equalsIgnoreCase(editFlag) && editFlag.length() > 0) {
            this.editFlag = editFlag;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setRequestParamStr(String reqParamStr) {
        this.reqParamStr = reqParamStr;
    }

    public boolean isDataFound() {
        return this.isDataFound;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getHTMLData() throws ITMException {
        String retHTMLStr = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String xslFileName = this.getXSLFileName();
            String xmlData = this.getXMLData();
            if (xmlData != null && xmlData.length() > 0) {
                Document dataDom = genericUtility.parseString(xmlData);
                NodeList detailNodeList = dataDom.getElementsByTagName("Detail1");
                if (detailNodeList.item(0) != null) {
                    String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                    retHTMLStr = genericUtility.transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                } else {
                    this.isDataFound = false;
                }
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public String getXMLData() throws ITMException {
        String retXMLStr = null;
        try {
            if (this.userInfo != null) {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                ITMFreeFormEJB itmFreeForm = new ITMFreeFormEJB();
                if ("A".equalsIgnoreCase(this.editFlag)) {
                    retXMLStr = itmFreeForm.getBlankAddForm(this.objName, this.objContext, String.valueOf(this.objName) + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
                } else if ("V".equalsIgnoreCase(this.editFlag)) {
                    retXMLStr = itmFreeForm.getViewFreeForm(this.objName, this.objContext, String.valueOf(this.objName) + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
                }
            } else {
                retXMLStr = Messages.getString("ITMFreeFormBean_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String getXSLFileName() throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = null;
            String fileName = String.valueOf(this.objName) + this.pContext + this.objContext + "_" + this.userLang + "_" + this.userCountry + "_" + this.editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                XSLBuilderEJB xslBuilderEJB = new XSLBuilderEJB();
                String xslString = "";
                String transDB = "";
                String profileIdRes = "";
                String profileId = "";
                if (this.userInfo != null) {
                    transDB = this.userInfo.getTransDB();
                    profileIdRes = this.userInfo.getProfileIdRes();
                    profileId = this.userInfo.getProfileId();
                }
                String propertyEditorDtl = String.valueOf(profileIdRes) + "~~SEP~~" + this.getEditor();
                xslString = transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 ? xslBuilderEJB.buildXSLString(this.objName, this.objContext, this.userLang, this.userCountry, this.pContext, this.editFlag, CommonConstants.APPLICATION_CONTEXT, propertyEditorDtl, this.userInfo) : xslBuilderEJB.buildXSLString(this.objName, this.objContext, this.userLang, this.userCountry, this.pContext, this.editFlag, CommonConstants.APPLICATION_CONTEXT, propEditorInfoMap, null);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    retFileName = xslString;
                }
                xslBuilderEJB = null;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }
}

