package ibase.webitm.bean.wsfa;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.json.JSONObject;
import org.omg.PortableInterceptor.SYSTEM_EXCEPTION;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.utility.ITMException;

public class DARCommonBean extends ValidatorEJB
{
	protected E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
    
	//added by prachi [W22FBAS009]
	public String collectionValidate(Document dom,int currentFormNo, String xtraParams,Connection connectionObject) throws Exception
	{
		System.out.println("inside dar comman bean");
		Node parentNode = null;
		Node childNode = null;
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		
		System.out.println("value of userID"+userId);

		StrgMeetDCRWizard swiz = new StrgMeetDCRWizard();
		NodeList parentList =null;
		NodeList childList= null;
		String childNodeName = "";
		String errString = "";
		String columnValue = "";
		int parentNodeListLength =0;
		int noOfChilds = 0;
		int ctr = 0;
		boolean isLocalConn = false;
		
		if (connectionObject == null) {
		connectionObject = getConnection();
		 isLocalConn = true;

		}
		
		userId = swiz.getEmpCode(userId, connectionObject);
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
		parentNodeListLength = parentList.getLength();
		for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
		{
			String selectBox = "";
			String updateFlag = "";
			parentNode = parentList.item(prntCtr);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for (ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				childNodeName = childNode.getNodeName();
				if(childNodeName.equalsIgnoreCase("attribute"))
				{
					if(childNode.getAttributes().getNamedItem("updateFlag") != null)
					{
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
				}
				if(childNodeName.equalsIgnoreCase("amount"))
				{
					String amount = checkNull(genericUtility.getColumnValueFromNode("amount", parentNode)).trim();

					String billAmount = checkNull(genericUtility.getColumnValueFromNode("bill_amt", parentNode)).trim();
					
					String PayMode = checkNull(genericUtility.getColumnValueFromNode("pay_mode", parentNode)).trim();										

					String MaxAmount = checkNull(swiz.getSfaParmValue(userId, "MAX_CASH_SALES_AMT",connectionObject));

					double Amount=0; 
					int maxCashAmt=0;
					if(amount!=null && amount.trim().length()>0)
					{
						Amount = Double.parseDouble(amount);
						
					}
					if(MaxAmount!=null && MaxAmount.trim().length()>0)
					{
						maxCashAmt = Integer.parseInt(MaxAmount);

					}
										
					if(amount==null || amount.trim().length()==0)
					{
						errString = itmDBAccessLocal.getErrorString( "amount" , "NULAMOUNT" , "" );
						break;
					}
					else if(amount != null && amount.trim().length()>0)
					{
						if (Amount > maxCashAmt && "C".equalsIgnoreCase(PayMode)) 
						{
							errString = itmDBAccessLocal.getErrorString("amount","INVLDAMTSE","");
							  break;
						}
					}
					
					
				}
				else if(childNodeName.equalsIgnoreCase("ref_date"))
				{
					String refdate =checkNull(genericUtility.getColumnValueFromNode("ref_date", parentNode)).trim();
					String billDate = checkNull(genericUtility.getColumnValueFromNode("bill_date", parentNode)).trim();
					String payMode = checkNull(genericUtility.getColumnValueFromNode("pay_mode", parentNode)).trim();
					System.out.println("refdate:"+refdate+" billDate:"+billDate+" payMode:"+payMode);
					if((refdate==null || refdate.trim().length()==0) && (payMode.equals("Q") || payMode.equals("O") ))
					{
						errString = itmDBAccessLocal.getErrorString("ref_date","NULCQDATE","");
                        break;
					}
					if ((refdate!=null && refdate.trim().length()>0) && (payMode.equals("Q") || payMode.equals("O")))
					{     
						//Added By Twinkle(10-Jan-24)- To add validation of ChequeDate should not be greater than currentDate[START]
						SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
						//java.util.Date date = Calendar.getInstance().getTime();
						Calendar cal = Calendar.getInstance();
						cal.setTime(new java.util.Date());
						cal.add(Calendar.MONTH, -3);
						java.util.Date date = cal.getTime();

						String currDate = sdfFormat.format( date );
						java.util.Date refDT = null;
						java.util.Date currentDate = null;
						java.util.Date billDT = null;
						//Added By Twinkle(10-Jan-24)- To add validation of ChequeDate should not be greater than currentDate[START]						try
						try
						{
							refDT = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							currentDate = sdfFormat.parse( currDate);
							billDT = sdfFormat.parse( billDate);

							System.out.println("billDT is:"+billDT+" refDT is:"+refDT+" currentDate:"+currentDate);
						}
						catch ( Exception e )
						{
							System.out.println("exception in case of ref_date");
							errString = itmDBAccessLocal.getErrorString( "ref_date", "INVCQDATE", "" );
							break;
						}
						
						if(refDT.before(currentDate))
                        {
							errString = itmDBAccessLocal.getErrorString( "ref_date", "INVCQODATE", "" );
							break;
                        }
					}	

			    }
			}
			if(errString != null && errString.trim().length() > 0)
			{
				break;
			}
			if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
			{
				connectionObject.close();
				connectionObject = null;
			}
		}
		return errString;
	}
	
	//added by prachi [W22FBAS009]
	public String collectionValidateAmount(Document dom,Connection conn,String winName,String totalDoctoramount,String formName) throws Exception
	{
		String errString = "";
		String formNo = "";
		Node parentNode = null;
		Node childNode = null;
		NodeList parentList =null;
		NodeList childList= null;
		String childNodeName = "";
		String columnValue = "";
		int parentNodeListLength =0;
		int noOfChilds = 0;
		int ctr = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		
		String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('"+formName+"')";
		PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
		pstmtForm.setString(1, winName);
		ResultSet rsForm = pstmtForm.executeQuery();
		while(rsForm.next())
		{
			formNo = checkNull(rsForm.getString("FORM_NO"));
		}
		if(rsForm != null)
		{
			rsForm.close();
			rsForm = null;
		}
		if(pstmtForm != null)
		{
			pstmtForm.close();
			pstmtForm = null;
		}
		
		String MaxCashSalesAmt = "";
		String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='MAX_CASH_SALES_AMT' ";
		pstmtForm = conn.prepareStatement(sfaParmSql);
		rsForm = pstmtForm.executeQuery();
		if (rsForm.next())
		{
			MaxCashSalesAmt = checkNull(rsForm.getString("PARM_VALUE"));
		}
		if(rsForm != null)
		{
			rsForm.close();
			rsForm = null;
		}
		if(pstmtForm != null)
		{
			pstmtForm.close();
			pstmtForm = null;
		}
		
		
		parentList = dom.getElementsByTagName("Detail"+ formNo);
		parentNodeListLength = parentList.getLength();
		for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
		{
            String updateFlag = "";
            parentNode = parentList.item(prntCtr);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for (ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}
				childNodeName = childNode.getNodeName();
				if(childNodeName.equalsIgnoreCase("attribute"))
				{
					if(childNode.getAttributes().getNamedItem("updateFlag") != null)
					{
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
				}
				else if ( "bill_amt".equalsIgnoreCase( childNodeName ) )
				{
					String billAmt = checkNull(genericUtility.getColumnValueFromNode("bill_amt", parentNode)).trim();
					if(!(totalDoctoramount.equals(billAmt)))
					{
						errString = itmDBAccessLocal.getErrorString( "bill_amt" , "AMTMISMTC" , "" );
						break;
					}

				}
			}
			if(errString != null && errString.trim().length() > 0)
			{
				break;
			}
		
		}
		return errString;

	}
	
	//added by prachi [W22FBAS009]
	public String darCollectionPosSave(Document dom,Connection conn,String currentFormNo,String formName,String userId) throws Exception
	{
		NodeList parentList = null;
		String errString = "";
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		StrgMeetDCRWizard swiz = new StrgMeetDCRWizard();
		String isFormMandatory = checkNull(swiz.getSfaParmValue(userId, "IS_FORM_MANDATORY", conn));
		String sfaparmBrand = checkNull(swiz.getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", conn));

        System.out.println("after sfa parm isFormMandatory:"+isFormMandatory+" sfaparmBrand:"+sfaparmBrand);
		String [] temp = isFormMandatory.split(",");
		List<String> parmNamelist = new ArrayList<String>();

		for(int i = 0 ;i < temp.length;i++)
		{
			if(!parmNamelist.contains(temp[i]) )
			{
				parmNamelist.add(temp[i]);
			}
		}
		
		parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		if(parmNamelist.contains(formName) && "Y".equalsIgnoreCase(sfaparmBrand))
		{
			if(parentNodeListLength == 0)
			{
				errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMSEL",userId);
			}
		}
		
		return errString;
	}
	//added by prachi [W22FBAS009]
	public String getFormNo(Connection connectionObject,String winName ,String formName) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String formNo="";
		
		try
		{
			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('"+formName+"')";
			pstmt = connectionObject.prepareStatement(objFormSql);
			pstmt.setString(1, winName);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(SQLException e)
			{
				e.printStackTrace();
			}
		}
		
		return formNo;
	}
	
	
	//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
	public HashMap<String, String> getItemUsageData(Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		HashMap<String, String> itemusageMap = new HashMap<String, String>();
		try
		{
				sql =" SELECT FLD_VALUE,DESCR FROM GENCODES WHERE MOD_NAME=? and FLD_NAME=? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,"W_WSFA_ITEM");
			pstmt.setString(2,"ITEM_USAGE");
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String fldvalue = checkNull(rs.getString("FLD_VALUE"));
				String descr = checkNull(rs.getString("DESCR"));
				itemusageMap.put(fldvalue.trim(), descr.trim());
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return itemusageMap;
	}
	
	
	public String getStandCodeHq(String empCode,Connection connectionObject) throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String stanCodeHq="";
		try
		{
			String sqlHq = "SELECT STAN_CODE__HQ FROM EMPLOYEE WHERE EMP_CODE= ? ";
			pstmt = connectionObject.prepareStatement( sqlHq );
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				stanCodeHq =   checkNull(rs.getString("STAN_CODE__HQ"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return stanCodeHq;
	}

	public boolean checkHeadquarterRouteIsAvilable(String empCode,String stanCodeHq,Connection connectionObject) throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		boolean isRouteAviable=false;
		try
		{

			int Count=0;
			String getLocalitySql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE SR  WHERE SR.STAN_CODE = ? AND SR.SPRS_CODE = ? AND SR.STATUS='Y'";

			pstmt = connectionObject.prepareStatement( getLocalitySql );
			pstmt.setString(1, stanCodeHq);
			pstmt.setString(2, empCode);
			rs = pstmt.executeQuery();			
			if ( rs.next() )
			{
				Count =   rs.getInt("COUNT");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(Count>0)
			{
				isRouteAviable=true;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return isRouteAviable;
	}
	//Added by mrunalini S
	public HashMap getItemAttributeDetails(Connection conn, String query, String bindValue, int strgCustCnt, String custList, String priceList, int sprsCnt) throws ITMException
	{
		System.out.println("getItemAttributeDetails getItemAttributeDetails method...!");
		System.out.println("query.!"+query);
		HashMap itemAttribMap = new HashMap();
		PreparedStatement pStmt = null;
		PreparedStatement pstmtItemAttrib = null;
		ResultSet rs = null;
		String sqlStr = "";
		String productCode = "";
		String productType = "";
		try
		{
			String itemCode = "";
			String itemSize = "";
			String itemColor = "";
			String itemVariant = "";
			String itemAttribDescr = "";
			String itemCodeStr = "";
			String prodCode = "";
			String prodType = "";
			StrgMeetDCRWizard swiz = new StrgMeetDCRWizard();
			String itemSer = swiz.getProdItmSer(bindValue, conn);
			
			if(priceList == null || priceList.trim().length() == 0)
			{
				priceList="";
			}
			if(bindValue == null || bindValue.trim().length() == 0)
			{
				bindValue="";
			}
			System.out.println("priceList [ "+priceList+" ]");
			System.out.println("bindValue [ "+bindValue+" ]");
			System.out.println("sprsCnt [ "+sprsCnt+" ]");
			
			pStmt = conn.prepareStatement(query);
			if(bindValue != null && bindValue.trim().length() > 0 && sprsCnt > 0)
			{
				pStmt.setString(1, priceList);
				pStmt.setString(2, bindValue);
			}
			else if((bindValue == null || bindValue.trim().length() == 0) && priceList != null && sprsCnt == 0)
			{
				pStmt.setString(1, priceList);
			}
			else if( priceList != null && sprsCnt == 0)
			{
				pStmt.setString(1, priceList);
			}
			rs = pStmt.executeQuery();
			while (rs.next())
			{
				itemCode = checkNull(rs.getString("ITEM_CODE"));
				prodCode = checkNull(rs.getString("PRODUCT_CODE"));
				prodType = checkNull(rs.getString("PRODUCT_TYPE"));

				if(itemCodeStr == null || itemCodeStr.trim().length() == 0)
				{
					itemCodeStr = itemCode;
				}
				else
				{
					itemCodeStr = itemCodeStr + "','" + itemCode;
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			itemCodeStr = "'" + itemCodeStr + "'";

			System.out.println("itemCodeStr=["+itemCodeStr+"]");


			String itemSizeCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_SIZE",conn);
			String itemColorCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_COLOR",conn);
			String itemVariantCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_VARIANT",conn);
			String itemGroupCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_GROUP",conn);

			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			if(itemColorCol.trim().length() == 0)
			{
				itemColorCol = "PHY_ATTRIB_2";
			}
			if(itemVariantCol.trim().length() == 0)
			{
				itemVariantCol = "PHY_ATTRIB_3";
			}
			if(itemGroupCol.trim().length() == 0)
			{
				itemGroupCol = "PHY_ATTRIB_22";
			}

			String itemAttribSql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE, ITEM.DESCR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemSizeCol+"=ATTRIB_ID) AS ITEM_SIZE, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemColorCol+"=ATTRIB_ID) AS ITEM_COLOR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemVariantCol+"=ATTRIB_ID) AS ITEM_VARIANT "+
					"FROM ITEM ITEM, ITM_ATTRIB_VAL ITEM_VAL "+
					"WHERE ITEM.PRODUCT_CODE= ? AND ITEM."+itemSizeCol+" "+
					"IN(SELECT DISTINCT TRIM(V.ATTRIB_ID) FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I."+itemSizeCol+" AND "+
					"I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I."+itemGroupCol+" "+
					"AND I.ACTIVE = 'Y' AND ITEM.ITEM_CODE IN("+itemCodeStr+")"+
					") order by item.item_code ";
			pstmtItemAttrib = conn.prepareStatement(itemAttribSql);


			String itemUSage="";
			String parmItemUsage = getSfaParmValueCommon(bindValue,"SAMPLE_ITEM_USAGE",conn);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuffCommon( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			if(sprsCnt > 0)
			{
				/*sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";*/
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? " +
						" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			// added by rupali on 02/05/19 for getting item from sprs_item if present [end]
			else
			{
				/*sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";*/
				/*sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? " +
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";*/
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? " +
						" AND ITEM.ITEM_SER IN("+itemSer+") AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			pStmt = conn.prepareStatement(sqlStr);
//			pStmt.setString(1, priceList);
//			pStmt.setString(2, bindValue);
			if(sprsCnt > 0)
			{
				pStmt.setString(1, priceList);
				pStmt.setString(2, bindValue);
			}
			else if(priceList != null && priceList.trim().length() > 0 && sprsCnt == 0)
			{
				pStmt.setString(1, priceList);
			}
			// commentted and added by rupali on 01/02/19 for getting only active items [end]

			rs = pStmt.executeQuery();
			while(rs.next())
			{
				productCode = "";
				productType = "";
				itemSize = "";
				itemColor = "";
				itemVariant = "";
				itemAttribDescr = "";
				productCode = checkNull(rs.getString("PRODUCT_CODE"));
				productType = checkNull(rs.getString("PRODUCT_TYPE"));

				pstmtItemAttrib.setString(1, productCode);
				pstmtItemAttrib.setString(2, productCode);
				pstmtItemAttrib.setString(3, productCode);
				ResultSet rsItemAttrib = pstmtItemAttrib.executeQuery();
				while(rsItemAttrib.next())
				{
					System.out.println("inside rsItemAttrib resultset");
					HashMap itemMap = new HashMap();
					itemCode = checkNull(rsItemAttrib.getString("ITEM_CODE"));
					itemSize = checkNull(rsItemAttrib.getString("ITEM_SIZE"));
					itemColor = checkNull(rsItemAttrib.getString("ITEM_COLOR"));
					itemVariant = checkNull(rsItemAttrib.getString("ITEM_VARIANT"));
					System.out.println("itemCode ::"+itemCode+" itemSize"+itemSize+" itemColor"+itemColor+" itemVariant"+itemVariant);

					if((itemColor == null || itemColor.trim().length() == 0) && (itemVariant.length() > 0))
					{
						itemAttribDescr = itemVariant;
					}
					else if((itemVariant == null || itemVariant.trim().length() == 0) && (itemColor.length() > 0))
					{
						itemAttribDescr = itemColor;
					}
					else if(itemColor.length() == 0 && itemVariant.length() == 0)
					{
						//itemAttribDescr = "Attribute not defined";
						itemAttribDescr = "";
					}
					if(itemColor.length() > 0 && itemVariant.length() > 0)
					{
						itemAttribDescr = itemVariant+"("+itemColor+")";
					}
					itemMap.put("ITEM_SIZE", itemSize);
					itemMap.put("ITEM_ATTRIBUTE", itemAttribDescr);

					itemAttribMap.put(itemCode, itemMap);

					//System.out.println("itemAttribMap ::"+itemAttribMap);
				}
				pstmtItemAttrib.clearParameters();
				if(rsItemAttrib != null)
				{
					rsItemAttrib.close();
					rsItemAttrib = null;
				}

			}
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			throw new ITMException(se);

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmtItemAttrib != null)
				{
					pstmtItemAttrib.close();
					pstmtItemAttrib = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception ee)
			{

			}
		}
		System.out.println("getItemAttributeDetails >> itemAttribMap ::"+itemAttribMap);
		return itemAttribMap;
	}
	public String getPreviousTwoOrderDetails(String itemCode, String eventDate, String strgCode, String sprsCode,Connection connectionObject) throws Exception
	{
		String sql = "";
		String preOrder = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String returnValue="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

			sql="SELECT * FROM (SELECT SM.EVENT_DATE,SMO.QUANTITY,SMO.VALUE FROM STRG_MEET SM ,STRG_MEET_ORDER SMO WHERE SALES_PERS=? AND " + 
					"SM.STRG_CODE=? AND SM.EVENT_DATE<? " + 
					"AND SM.DCR_ID=SMO.DCR_ID AND SM.STRG_CODE=SMO.STRG_CODE AND ITEM_CODE=? AND SM.confirmed='Y' ORDER BY SM.EVENT_DATE DESC ) " + 
					"WHERE ROWNUM <= 2 ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,sprsCode);
			pstmt.setString(2,strgCode);
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));	
			pstmt.setString(4,itemCode);

			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String workDate=checkNull(rs.getString("EVENT_DATE"));
				String value=checkNull(rs.getString("QUANTITY"));
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
				Calendar cal = Calendar.getInstance();
				cal.setTime( sdf.parse(workDate) );
				int day =cal.get(Calendar.DAY_OF_MONTH);
				int month = cal.get(Calendar.MONTH);
				String displayMont=(String)Array.get(months, month);

				//String boldValue="<b>"+value+"</b>";
				//String order=day+"-"+displayMont+" "+boldValue;
				String order=day+"-"+displayMont+" "+value;
				/*if(preOrder==null || preOrder.trim().length() == 0)
				{
					preOrder = order;
				}
				else
				{
					preOrder=preOrder+" "+order;
				}*/
				if(preOrder==null || preOrder.trim().length() == 0)
				{
					preOrder = order;
				}
				else
				{
					preOrder=preOrder+"#"+order;
				}
			}
			//returnValue="<span style='font-size: 12px;font-weight: lighter;float:right;'> &nbsp;"+preOrder+"</span>";
			returnValue=preOrder;
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return returnValue;
	}
	public double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, String priceList,Connection connectionObject) throws Exception
	{
		//System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [start]
		String listType = "";
		String lsUnit = "";
		String lsRefNo = "";
		Double mQty = 1d;
		// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [end]
		try
		{
			//System.out.println("strgCode:::>>>>[" + strgCode +"]" );

			//System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [start]
			//	rate = distComn.pickRate(priceList, workDate, itemCode, connectionObject);
			sql = " select list_type from pricelist_mst where price_list = ? ";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				listType = rs.getString("list_type");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
			//System.out.println("List Type:-[" + listType + "]");

			sql = "select unit  from item where item_code = ?";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, itemCode);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				lsUnit = rs.getString("unit");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;

			sql = "select max(ref_no) from pricelist where price_list  =? and item_code= ? and unit=? and list_type= ?"
					+ " and eff_from<=? and valid_upto>=? and min_qty<=? and max_qty>=? and (ref_no is not null)";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			pStmt.setString(2, itemCode);
			pStmt.setString(3, lsUnit);
			pStmt.setString(4, listType);
			pStmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setDouble(7, mQty);
			pStmt.setDouble(8, mQty);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				lsRefNo = checkNull(rs.getString(1));
			}
			//System.out.println("inside getLandingRate lsRefNo is"+lsRefNo);
			rate = distComn.pickRateRefnoWise(priceList,workDate, itemCode, "", listType,mQty, connectionObject);
			// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [end]
			//System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}

				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return rate;
	}
	public String getTotalMonths(String itemCode, String stockInfo, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String totMonths = "";
		try
		{
			String expDate = "";
			String sql = "select exp_date from item_lot_info where item_code = ? and  lot_no = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, stockInfo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				expDate = (rs.getString("exp_date") == null) ?"":rs.getString("exp_date").trim();
				System.out.println("expDate is::::::"+expDate);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			Date date1 = Calendar.getInstance().getTime();
			DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			DateFormat sdf1 = new SimpleDateFormat("MM/yy");
			String today = sdf.format(date1);
			System.out.println("Today : " + today);
			String expDt = "";
			if(expDate.trim().length() != 0)
			{
				totMonths = "0";
				SimpleDateFormat inputFormat=new SimpleDateFormat(getDBDateFormat());
				Date eventDate1=null;
				eventDate1 = inputFormat.parse(expDate);
				expDate=sdf.format(eventDate1);
				System.out.println("expDate is:::::"+expDate);
				expDt=sdf1.format(eventDate1);
				System.out.println("expDt is:::::"+expDt);
				Date date3 = sdf.parse(today);
				Date date2 = sdf.parse(expDate);
				if (date3.compareTo(date2) < 0)
				{
					Calendar cal = Calendar.getInstance();
					if (date3.before(date2)) {
						cal.setTime(date3);
					} else {
						cal.setTime(date2);
						date2 = date3;
					}
					int differ = 0;
					while (cal.getTime().before(date2)) {
						cal.add(Calendar.MONTH, 1);
						differ++;
					}
					totMonths = Integer.toString(differ - 1);
				}
				totMonths = expDt + " (" + totMonths +" "+ "Months)";
			}
			System.out.println("totMonths:::::"+totMonths);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return totMonths;
	}
	private String getFormattedStringBuffCommon( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}
	public String getSfaParmValueCommon(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;//Added by kailash.
		ResultSet rs1 = null;//Added by kailash.
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			//chnged by sachin satre on [11-nov-16] to get connectioni
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connectioni
				isLocalConn =true;
			}
			//chnged by sachin satre on [11-nov-16] to get connection
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				//System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				//added by mrunalni sinkar on 10-aug-2018(start)
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull( allRs.getString(1) );
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				//added by mrunalni sinkar on 10-aug-2018(end)
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	//added by mrunalini s
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
	public String getSalesPersName(String spCode,Connection conn)throws Exception
	{
		String spName="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, spCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				spName = checkNull(rs.getString("SP_NAME"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return spName;
	}
	public String getLocalityDescr(String locCode,Connection conn)throws Exception
	{
		String locDescr="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, locCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locDescr = checkNull(rs.getString("DESCR"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return locDescr;
	}
	public String getPropVal(String PropVal,Connection conn)throws Exception
	{
		String propDate="";
		PreparedStatement propPstmt = null;
		ResultSet propRs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'APPL_START_DAR'";
			propPstmt =  conn.prepareStatement(propSql);
			propRs = propPstmt.executeQuery();
			if(propRs.next())
			{
				propDate = propRs.getString("PROP_VALUE");
				propDate = genericUtility.getValidDateString(propDate, genericUtility.getDBDateFormat() ); // commented by rupali on 09/11/17 for slving date parsing issue while entering first dcr
			}
			//System.out.println("Appl_Start_Date =====["+propDate+"]");
			if (propRs!= null)
			{
				propRs.close();
				propRs = null;
			}
			if(propPstmt!=null)
			{
				propPstmt.close();
				propPstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (propRs!= null)
				{
					propRs.close();
					propRs = null;
				}
				if(propPstmt!=null)
				{
					propPstmt.close();
					propPstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return propDate;
	}
	public String getJoinDate(String userId,Connection conn)throws Exception
	{
		String joinDate = "";
		String joinDateSql = "";
		PreparedStatement joinDatePstmt = null;
		ResultSet joinDateRs = null;
		try
		{
			joinDateSql = "SELECT DATE_JOIN-1 AS DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = ? ";
			joinDatePstmt =conn.prepareStatement(joinDateSql);
			joinDatePstmt.setString(1,userId);
			joinDateRs = joinDatePstmt.executeQuery();
			if(joinDateRs.next())
			{
				joinDate = joinDateRs.getString("DATE_JOIN");
			}
			//System.out.println("joinDate=== ["+joinDate + "]");
			if (joinDateRs!= null)
			{
				joinDateRs.close();
				joinDateRs = null;
			}
			if(joinDatePstmt!=null)
			{
				joinDatePstmt.close();
				joinDatePstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (joinDateRs!= null)
				{
					joinDateRs.close();
					joinDateRs = null;
				}
				if(joinDatePstmt!=null)
				{
					joinDatePstmt.close();
					joinDatePstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return joinDate;
	}

	public String getFormNum(Connection conn)throws Exception
	{
		String formNum = "";
		PreparedStatement objFormpstmt = null;
		ResultSet objFormrs = null;
		try
		{
			String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= 'w_strg_meet_dcr_wiz' AND FORM_NAME IN('place','doctor','retailer','stockist') ORDER BY TO_NUMBER(FORM_NO)";
			objFormpstmt = conn.prepareStatement(objFormSql);
			objFormrs = objFormpstmt.executeQuery();
			while(objFormrs.next())
			{
				String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
				if(formNum == null || formNum.trim().length() == 0)
				{
					formNum = objFormNo;
				}
				else
				{
					formNum = formNum + "," + objFormNo;
				}
			}
			if(objFormrs != null)
			{
				objFormrs.close();
				objFormrs = null;
			}
			if(objFormpstmt != null)
			{
				objFormpstmt.close();
				objFormpstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(objFormrs != null)
				{
					objFormrs.close();
					objFormrs = null;
				}
				if(objFormpstmt != null)
				{
					objFormpstmt.close();
					objFormpstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return formNum;
	}
	public String getFormNumMgr(Connection conn)throws Exception
	{
		String formNum = "";
		PreparedStatement objFormpstmt = null;
		ResultSet objFormrs = null;
		try
		{
			String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= 'w_strg_meet_mgr_dcr_wiz' AND FORM_NAME IN('place','doctor','retailer','stockist') ORDER BY TO_NUMBER(FORM_NO)";
			objFormpstmt = conn.prepareStatement(objFormSql);
			objFormrs = objFormpstmt.executeQuery();
			while(objFormrs.next())
			{
				String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
				if(formNum == null || formNum.trim().length() == 0)
				{
					formNum = objFormNo;
				}
				else
				{
					formNum = formNum + "," + objFormNo;
				}
			}
			if(objFormrs != null)
			{
				objFormrs.close();
				objFormrs = null;
			}
			if(objFormpstmt != null)
			{
				objFormpstmt.close();
				objFormpstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(objFormrs != null)
				{
					objFormrs.close();
					objFormrs = null;
				}
				if(objFormpstmt != null)
				{
					objFormpstmt.close();
					objFormpstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return formNum;
	}
	public String getlocDescrOld(String userId,String lastRouteId,Connection conn)throws Exception
	{
		String lastLocDescr="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{

			String locDescrOldSql1 = "SELECT ST.DESCR AS DESCR FROM SPRS_ROUTE SR,STATION ST WHERE SPRS_CODE = ? AND ROUTE_ID= ? AND SR.STAN_CODE = ST.STAN_CODE AND SR.STATUS='Y'";
			pstmt = conn.prepareStatement(locDescrOldSql1);
			pstmt.setString(1, userId);
			pstmt.setString(2, lastRouteId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				lastLocDescr = checkNull(rs.getString("DESCR"));

			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return lastLocDescr;
	}
	public String getmodeDescr(String travelMode,Connection conn)throws Exception
	{
		String modeDescr="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String modeSql="SELECT TRAVEL_MODE_DESCR FROM TRAVEL_MODE_MASTER WHERE TRAVEL_MODE_ID=?";
			pstmt =  conn.prepareStatement( modeSql );
			pstmt.setString(1, travelMode);
			ResultSet rsMode= pstmt.executeQuery();
			if(rsMode.next())
			{
				modeDescr=checkNull(rsMode.getString("TRAVEL_MODE_DESCR"));
			}
			if (rsMode != null)
			{
				rsMode.close();
				rsMode = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return modeDescr;
	}
	public String getVisitedWithDisp( String visitedWithTeam,Connection connectionObject ) throws ITMException
	{
		//System.out.println("Inside getVisitedWithDisp");
		boolean isLocalConn =false;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String visitedWithDisp = "";
		try
		{
			if(visitedWithTeam.trim().length() > 0 )
			{
				String [] team = visitedWithTeam.split(",");
				for(int i = 0 ;i < team.length;i++)
				{
					String visitTeam = team[i];
					if(visitTeam!=null || !visitTeam.equalsIgnoreCase(""))
					{
						if(visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1)
						{
							String selTeam = checkNull(visitTeam.substring(visitTeam.indexOf("(")+1, visitTeam.indexOf(")")));
							String dispName = checkNull(getEmpNameDesign(selTeam,connectionObject));
							if(visitedWithDisp.trim().length() > 0 )
							{
								visitedWithDisp = visitedWithDisp +","+dispName;
							}
							else
							{
								visitedWithDisp = dispName;
							}
						}
					}
				}
				System.out.println("visitedWithDisp in bean::::::"+visitedWithDisp);
			}	
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: getvisitedwithdisplay :......... ["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return visitedWithDisp;
	}
	public String getEmpNameDesign(String empCode,Connection conn) throws ITMException
	{
		String name=null;
		String employeCode = null;
		String designCode = null;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT UPPER(EMP_FNAME) ||' ' ||UPPER(EMP_MNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE, DESIGN_CODE from employee 	WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				name = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
				designCode = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return name +"("+designCode+")";
	}
	public String getEventType( String domID,String sprsActCode, String eventType , String salesPers, String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		//System.out.println("Inside get event type");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		String activityType="";
		String activityDescr="";
		try
		{
			String actSql="SELECT FA.ACTIVITY_TYPE AS ACTIVITY_TYPE,FA.DESCR AS ACTIVITY_DESCR FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
					"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
					"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
					"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
					"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";

			pstmt = connectionObject.prepareStatement(actSql);
			pstmt.setString(1, eventType);
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				activityType=checkNull(rs.getString("ACTIVITY_TYPE"));
				activityDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			valueXmlString.append( "<Root>\r\n" );
			valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID+"' formName='"+formName+"'>\r\n" );
			valueXmlString.append("<activity_type protect = '1'><![CDATA[" ).append(checkNull(activityType)).append( "]]></activity_type>\r\n" );
			valueXmlString.append("<event_type_descr><![CDATA[" ).append(checkNull(activityDescr)).append( "]]></event_type_descr>\r\n" );
			valueXmlString.append("<meeting_status><![CDATA[" ).append("").append( "]]></meeting_status>\r\n" );
			valueXmlString.append("<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
			valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getEventtypebean:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getEventType:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]

	public HashMap getEmployeeDesignationMap (String division,Connection conn ) throws ITMException  //added by rupali on 06/03/17
	{

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String,String> employeeDesignatonMap  = new HashMap<String,String>();


		try
		{


			String sql="SELECT DISTINCT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) AS ENTITY_CODE,WF.DESCR AS DESIGNATION FROM ORG_ROLE_ASSIGN ORA,WF_ROLE WF " + 
					"WHERE ORA.ORG_UNIT=? AND ORA.ROLE_CODE=WF.ROLE_CODE AND WF.ROLE_PURPOSE='2' " + 
					"CONNECT BY REGEXP_SUBSTR(ORA.ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL " ;

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,division);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				String entitCode = checkNull(rs.getString("ENTITY_CODE"));
				String designaton = checkNull(rs.getString("DESIGNATION"));

				employeeDesignatonMap.put(entitCode, designaton);

			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("employeeDesignatonMap is :["+employeeDesignatonMap+"]");

		return employeeDesignatonMap;

	}
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[06/01/22][START]
	public int getCntPers(String EUINno,String strgCode,Connection conn) throws ITMException
	{

		PreparedStatement pstmt = null;
		ResultSet rSet = null;
		int EUINnoCnt = 0;
		try
		{
			//Changes made by Rahul P. on 26-Sep-2023 [Start] add condition in where clause ENTITY_TYPE='R'
			//String EUINosql = "SELECT COUNT(*) AS CNT FROM ENTITY_CONTACT WHERE TRIM(ENTITY_CODE)=TRIM(?) AND TRIM(CONTACT_PERS)=TRIM(?)";
			String EUINosql = "SELECT COUNT(*) AS CNT FROM ENTITY_CONTACT WHERE TRIM(ENTITY_CODE)=TRIM(?) AND TRIM(CONTACT_PERS)=TRIM(?) AND ENTITY_TYPE='R'";
			// Changes made by Rahul P. 26-Sep-2023 [End]
			pstmt = conn.prepareStatement(EUINosql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, EUINno);
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				EUINnoCnt = rSet.getInt("CNT");
			}
			if(rSet!=null)
			{
				rSet.close();
				rSet=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return EUINnoCnt;
	}
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[06/01/22][END]
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune sc code itemchange[21/01/22][START]
	public String getStrgCodedata( String domID, String strgCodeDom, String locCodeDom ,String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		System.out.println("Inside get getStrgCodedata");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();

		try
		{
			String actSql="SELECT  UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS AS ADDRESS_AS,SC.QUALIFICATION AS QUALIFICATION," + 
					" SC.MOBILE_NO AS MOBILE_NO, SC.EMAIL_ADDR AS EMAIL_ADDR, SC.SEX AS SEX,SC.CLASS_CODE AS CLASS_CODE,SC.SUBCLASS_CODE AS SUBCLASS_CODE, SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3," + 
					" SC.PROMOTER_NAME AS PROMOTER_NAME, SC.GST_NO AS GST_NO, SC.MAN_POWER AS MAN_POWER, SC.PIN AS PIN,SC.REG_NO AS REG_NO"+ 
					" FROM STRG_CUSTOMER SC,LOCALITY L WHERE SC.LOCALITY_CODE=L.LOCALITY_CODE AND SC.STATUS='U' AND TRIM(SC.SC_CODE)=TRIM(?) AND TRIM(SC.LOCALITY_CODE)=TRIM(?)";

			pstmt = connectionObject.prepareStatement(actSql);
			pstmt.setString(1, strgCodeDom);
			pstmt.setString(2, locCodeDom);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String strgclasscode=checkNull(rs.getString("CLASS_CODE"));
				String regNumber=checkNull(rs.getString("REG_NO"));
				String mobNo= checkNull(rs.getString("MOBILE_NO"));
				String emailAddr=checkNull(rs.getString("EMAIL_ADDR"));
				String subClassCode=checkNull(rs.getString("SUBCLASS_CODE"));
				String promoterName=checkNull(rs.getString("PROMOTER_NAME"));
				String manPower=checkNull(rs.getString("MAN_POWER"));
				String gstNo=checkNull(rs.getString("GST_NO"));
				valueXmlString.append( "<Root>\r\n" );
				valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID+"' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<strg_name visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );
				valueXmlString.append("<cust_name visible='0' protect ='1'><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");
				valueXmlString.append("<qualification visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
				valueXmlString.append( "<address_as visible='1' protect ='1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );//Added by kailash on 10-09-18.
				valueXmlString.append( "<addr1 visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );
				valueXmlString.append( "<addr2 visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );
				valueXmlString.append( "<addr3 visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );
				if(regNumber != null && regNumber.trim().length() > 0)
				{
					valueXmlString.append("<reg_no visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("REG_NO")) ).append( "]]></reg_no>\r\n" );
				}
				else
				{
					valueXmlString.append("<reg_no visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></reg_no>\r\n" );
				}
				if(strgclasscode != null && strgclasscode.trim().length() > 0)
				{
					valueXmlString.append( "<strg_class_code visible='1' protect ='1'><![CDATA[" ).append(strgclasscode).append( "]]></strg_class_code>\r\n" );
				}
				else
				{
					valueXmlString.append( "<strg_class_code visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
				}
				if(mobNo != null && mobNo.trim().length() > 0)
				{
					valueXmlString.append( "<mobile_no visible='1' protect='1'><![CDATA[" ).append(mobNo).append( "]]></mobile_no>\r\n" );
				}
				else
				{
					valueXmlString.append( "<mobile_no visible='1' protect='0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
				}
				if(emailAddr != null && emailAddr.trim().length() > 0)
				{
					valueXmlString.append( "<email_addr visible='1' protect='1'><![CDATA[" ).append(emailAddr).append( "]]></email_addr>\r\n" );
				}
				else
				{
					valueXmlString.append( "<email_addr visible='1' protect='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
				}
				valueXmlString.append( "<gender visible='1' protect='1'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
				if(subClassCode != null && subClassCode.trim().length() > 0)
				{
					valueXmlString.append("<subclass_code visible='1' protect ='1'><![CDATA[" ).append(subClassCode).append( "]]></subclass_code>\r\n" );
				}
				else
				{
					valueXmlString.append("<subclass_code visible='1' protect ='0'><![CDATA[" ).append(subClassCode).append( "]]></subclass_code>\r\n" );
				}
				valueXmlString.append("<pin visible='1' protect ='1'><![CDATA[" ).append(checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
				if(promoterName != null && promoterName.trim().length() > 0)
				{
					valueXmlString.append("<promoter_name visible='1' protect ='1'><![CDATA[" ).append(promoterName).append( "]]></promoter_name>\r\n" );
				}
				else
				{
					valueXmlString.append("<promoter_name visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
				}
				if(manPower != null && manPower.trim().length() > 0)
				{
					valueXmlString.append("<man_power visible='1' protect ='1'><![CDATA[" ).append(manPower).append( "]]></man_power>\r\n" );
				}
				else 
				{
					valueXmlString.append("<man_power visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
				}
				if(gstNo != null && gstNo.trim().length() > 0)
				{
					valueXmlString.append("<gst_no visible='1' protect ='1'><![CDATA[" ).append(gstNo).append( "]]></gst_no>\r\n" );
				}
				else
				{
					valueXmlString.append("<gst_no visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
				}
				valueXmlString.append("<contact_pers_name visible='1' protect ='1'><![CDATA[" ).append("").append( "]]></contact_pers_name>\r\n" );
				valueXmlString.append("<contact_pers visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				valueXmlString.append( "</Root>\r\n" );
			}
			else
			{
				valueXmlString.append( "<Root>\r\n" );
				valueXmlString.append("<Detail"+currentFormNo+" domID='1' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<strg_name visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
				valueXmlString.append("<qualification visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
				valueXmlString.append( "<address_as visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );//Added by kailash on 10-09-18.
				valueXmlString.append( "<addr1 visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
				valueXmlString.append( "<addr2 visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
				valueXmlString.append( "<addr3 visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
				valueXmlString.append("<reg_no visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></reg_no>\r\n" );
				valueXmlString.append( "<strg_class_code visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
				valueXmlString.append( "<class_code_descr visible='1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
				valueXmlString.append( "<mobile_no visible='1' protect='0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );					
				valueXmlString.append( "<email_addr visible='1' protect='0'><![CDATA[" ).append("" ).append( "]]></email_addr>\r\n" );
				valueXmlString.append( "<gender visible='1' protect='0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );					
				valueXmlString.append("<subclass_code visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
				valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
				valueXmlString.append("<pin visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
				valueXmlString.append("<promoter_name visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
				valueXmlString.append("<man_power visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
				valueXmlString.append("<gst_no visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
				valueXmlString.append("<contact_pers_name visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></contact_pers_name>\r\n" );
				valueXmlString.append("<contact_pers visible='1' protect ='0'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				valueXmlString.append( "</Root>\r\n" );
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :strgcodedetail:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getEventType:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune sc code itemchange[21/01/22][END]
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[24/01/22][START]
	public int getValidEuin(String EUINno,Connection conn) throws ITMException
	{

		PreparedStatement pstmt = null;
		ResultSet rSet = null;
		int validEUINCnt = 0;
		try
		{ 
			String EUINosql = "select (case when (regexp_like(trim(?),'^[E]{1}+[0-9]{6}$')) then 1 else 0 end) as CNT from dual";
			pstmt = conn.prepareStatement(EUINosql);
			pstmt.setString(1, EUINno);
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				validEUINCnt = rSet.getInt("CNT");
			}
			if(rSet!=null)
			{
				rSet.close();
				rSet=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return validEUINCnt;
	}
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[24/01/22][END]
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[24/01/22][START]
	public int getDupdEuin(String EUINno,String strgCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rSet = null;
		int DupEUINCnt = 0;
		try
		{ 
			ArrayList EuinNosList = new ArrayList();
			String EUINosql = "select CONTACT_PERS as EUINno from strg_meet where STRG_CODE IN(SELECT STRG_CODE from strg_cust_add where CONFIRMED='N') AND TRIM(STRG_CODE) !=TRIM(?) AND CONTACT_PERS IS NOT NULL"; 
			pstmt = conn.prepareStatement(EUINosql);
			pstmt.setString(1, strgCode);
			rSet = pstmt.executeQuery();
			while(rSet.next())
			{
				EuinNosList.add(rSet.getString("EUINno"));
			}
			if(rSet!=null)
			{
				rSet.close();
				rSet=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;

			}
			System.out.println("STRG_MEET EUIN NO ARRAY::"+EuinNosList);
			System.out.println(" EUIN NO ::"+EUINno);
			if (EuinNosList.contains(EUINno.trim()))
			{
				System.out.println("Inside EUIN no in strg_meet");
				DupEUINCnt =1;
			}
			if(DupEUINCnt ==0) 
			{
				System.out.println("Inside EUIN no is not in strg_meet");
				//Changes made by Rahul P. on 26-Sep-2023 [Start] add condition in where clause ENTITY_TYPE='R'
				//String EUINosql1 = "SELECT COUNT(*) AS CNT FROM ENTITY_CONTACT WHERE TRIM(CONTACT_PERS)=TRIM(?)";
				String EUINosql1 = "SELECT COUNT(*) AS CNT FROM ENTITY_CONTACT WHERE TRIM(CONTACT_PERS)=TRIM(?) AND ENTITY_TYPE='R'";
				//Changes made by Rahul P. on 26-Sep-2023 [End]
				pstmt = conn.prepareStatement(EUINosql1);
				pstmt.setString(1, EUINno);
				rSet = pstmt.executeQuery();
				if(rSet.next())
				{
					DupEUINCnt = rSet.getInt("CNT");
				}
				if(rSet!=null)
				{
					rSet.close();
					rSet=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;

				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return DupEUINCnt;
	}
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[24/01/22][END]
	//Added by bhagyashri T For Firtune EUIN NO OF Fortune[24/01/22][START]
	public int getStrgCode(String strgCode,Connection conn) throws ITMException
	{

		PreparedStatement pstmt = null;
		ResultSet rSet = null;
		int StrgCodeCnt = 0;
		try
		{ 
			String EUINosql = "SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE TRIM(SC_CODE)=TRIM(?)";
			pstmt = conn.prepareStatement(EUINosql);
			pstmt.setString(1, strgCode);
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				StrgCodeCnt = rSet.getInt("CNT");
			}
			if(rSet!=null)
			{
				rSet.close();
				rSet=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return StrgCodeCnt;
	}
	public String getJoinDate1(String userId,Connection conn)throws Exception
	{
		String joinDate = "";
		String joinDateSql = "";
		PreparedStatement joinDatePstmt = null;
		ResultSet joinDateRs = null;
		try
		{
			joinDateSql = "SELECT DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = ? ";
			joinDatePstmt =conn.prepareStatement(joinDateSql);
			joinDatePstmt.setString(1,userId);
			joinDateRs = joinDatePstmt.executeQuery();
			if(joinDateRs.next())
			{
				joinDate = joinDateRs.getString("DATE_JOIN");
			}
			//System.out.println("joinDate=== ["+joinDate + "]");
			if (joinDateRs!= null)
			{
				joinDateRs.close();
				joinDateRs = null;
			}
			if(joinDatePstmt!=null)
			{
				joinDatePstmt.close();
				joinDatePstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (joinDateRs!= null)
				{
					joinDateRs.close();
					joinDateRs = null;
				}
				if(joinDatePstmt!=null)
				{
					joinDatePstmt.close();
					joinDatePstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return joinDate;
	}
	//added by mrunalini SInkar sTART
	public int getCountFromTable(String tableName,String userId,Connection connectionObject)throws Exception
	{
		int count = 0;
		PreparedStatement selectPstmt = null;
		ResultSet selectRs = null;
		try
		{
			String selectSql = "SELECT COUNT(*) AS COUNT FROM "+tableName+" WHERE SALES_PERS = ?";
			selectPstmt = connectionObject.prepareStatement(selectSql);
			selectPstmt.setString(1,userId);
			selectRs = selectPstmt.executeQuery();
			if(selectRs.next())
			{
				count = selectRs.getInt("COUNT");
			}
			if(selectRs != null)
			{
				selectRs.close();
				selectRs = null;
			}
			if(selectPstmt != null)
			{
				selectPstmt.close();
				selectPstmt = null;
			}}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (selectRs!= null)
				{
					selectRs.close();
					selectRs = null;
				}
				if(selectPstmt!=null)
				{
					selectPstmt.close();
					selectPstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return count;

	}
	public String getMaxDate(String userId,String currDate,String tableName,String ColumnName,Connection connectionObject)throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String actTranDcrDate="";

		try
		{					

			String sql = "SELECT MAX("+ColumnName+") LAST_DCR_DATE FROM "+tableName+" WHERE "+ColumnName+" <= ? AND SALES_PERS = ? "+
					"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; 
			pstmt =  connectionObject.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				actTranDcrDate = rs.getString("LAST_DCR_DATE");

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("actTranDcrDate =["+actTranDcrDate+"]");
		return actTranDcrDate;
	}
	public String getRouteDescrStart(String userId,String eventDateDBFmt,Connection connectionObject)throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String lastLocDescr="";

		try
		{
			String locDescrOldSql = "SELECT ROUTE_DESCR__START AS DESCR FROM SPRS_ACT_TRAN  WHERE EVENT_DATE=? AND SALES_PERS=?";
			pstmt = connectionObject.prepareStatement(locDescrOldSql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(eventDateDBFmt));
			pstmt.setString(2, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				lastLocDescr = checkNull(rs.getString("DESCR"));

			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("lastDCRDate =["+lastLocDescr+"]");
		return lastLocDescr;
	}
	public String getLastDcrDate(String userId,String currDate,Connection connectionObject)throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String lastDCRDate="";

		try
		{

			String sql = "SELECT MAX(A.EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE <= ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE <>'PR'";
			pstmt =  connectionObject.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				lastDCRDate = rs.getString("LAST_DCR_DATE");
				//System.out.println("lastDCRDate =["+lastDCRDate+"]");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("lastDCRDate =["+lastDCRDate+"]");
		return lastDCRDate;
	}
	public String getLocData(String domID1,String selSprscodeww, String localityCode,String selRouteId,int currentFormNo,String formName,Connection connectionObject ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();

		try
		{
			String localityDes="",stanCode="",stationType="",routeID="",sprsCodeWW="";

			String sql="SELECT DISTINCT SR.LOCALITY_CODE AS LOCALITY_CODE,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) AS LOCALITY_DESCR,SR.STAN_CODE AS STAN_CODE, " + 
					"  SR.STATION_TYPE AS STATION_TYPE,SR.ROUTE_ID AS ROUTE_ID,SR.SPRS_CODE AS SPRS_CODE__WW   FROM SPRS_ROUTE SR,LOCALITY L " + 
					"  WHERE  L.LOCALITY_CODE=SR.LOCALITY_CODE  AND SR.STATUS ='Y' AND SR.SPRS_CODE IN("+selSprscodeww+") " + 
					"  AND SR.LOCALITY_CODE = ? " + 
					"  AND (TRIM(SR.SPRS_CODE) || ':' || TRIM(SR.ROUTE_ID))  IN("+selRouteId+") " + 
					"  ORDER BY LOCALITY_DESCR";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, localityCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityDes = checkNull(rs.getString("LOCALITY_DESCR"));
				stanCode = checkNull(rs.getString("STAN_CODE"));
				stationType = checkNull(rs.getString("STATION_TYPE"));
				routeID = checkNull(rs.getString("ROUTE_ID"));
				sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}


			valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
			valueXmlString.append("<locality_descr protect = '1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
			valueXmlString.append("<stan_code><![CDATA[" ).append(checkNull(stanCode)).append( "]]></stan_code>\r\n" );
			valueXmlString.append("<station_type><![CDATA[" ).append(stationType).append( "]]></station_type>\r\n" );
			valueXmlString.append("<route_id><![CDATA[" ).append(routeID).append( "]]></route_id>\r\n" );
			valueXmlString.append("<sprs_code__ww ><![CDATA[" ).append(sprsCodeWW).append( "]]></sprs_code__ww>\r\n" );

			valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );

		}
		catch(Exception e)
		{
			System.out.println( "Exception :getLocData:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getLocData:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "getLocData:==>\n"+valueXmlString.toString());

		return valueXmlString.toString();
	}

	public int getCountForPRActivity(String userId,String validWorkDate,Connection connectionObject)throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int count1=0;

		try
		{				
			String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? "
					+ "AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR' ";
			PreparedStatement prPstmt = connectionObject.prepareStatement(countPrSql);
			prPstmt.setString(1,userId);
			prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet prRs = prPstmt.executeQuery();
			if(prRs.next())
			{
				count1 = prRs.getInt("COUNT");
			}
			if(prRs != null)
			{
				prRs.close();
				prRs = null;
			}
			if(prPstmt != null)
			{
				prPstmt.close();
				prPstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("count1 =["+count1+"]");
		return count1;
	}
	//Added by bhagyashri T For contact_pers itemchange[25/MAR/22][W21KFOR011][START]
	public String getContactPersName( String domID,String strgCodeC, String euinNo ,String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		System.out.println("Inside get Contact_pers name");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		String conPersName="";
		System.out.println("in contact_pers itemchange euinNo ::"+euinNo);
		System.out.println("in contact_pers itemchange strgCodeC::"+strgCodeC);
		try
		{
			//Changes made by Rahul P. on 26-Sep-2023 [Start] add condition in where clause ENTITY_TYPE='R'
			//String cntperSql="SELECT TRIM(CONTACT_PERS_NAME) AS CONTACT_PERS_NAME FROM ENTITY_CONTACT WHERE TRIM(ENTITY_CODE)=TRIM(?) AND TRIM(CONTACT_PERS)=TRIM(?)";
			String cntperSql="SELECT TRIM(CONTACT_PERS_NAME) AS CONTACT_PERS_NAME FROM ENTITY_CONTACT WHERE TRIM(ENTITY_CODE)=TRIM(?) AND TRIM(CONTACT_PERS)=TRIM(?) AND ENTITY_TYPE='R'";
			//Changes made by Rahul P. on 26-Sep-2023 [End]
			
			pstmt = connectionObject.prepareStatement(cntperSql);
			pstmt.setString(1, strgCodeC);
			pstmt.setString(2, euinNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				conPersName=checkNull(rs.getString("CONTACT_PERS_NAME")).trim();
				System.out.println("Contact person name is:"+conPersName);
				valueXmlString.append( "<Root>\r\n" );
				valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID+"' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<contact_pers_name protect = '1'><![CDATA[" ).append(checkNull(conPersName)).append( "]]></contact_pers_name>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				valueXmlString.append( "</Root>\r\n" );
			}
			else
			{
				System.out.println("Contact person name is inside else:"+conPersName);
				valueXmlString.append( "<Root>\r\n" );
				valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID+"' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<contact_pers_name><![CDATA[" ).append("").append( "]]></contact_pers_name>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				valueXmlString.append( "</Root>\r\n" );
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getEventtypebean:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getEventType:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Added by bhagyashri T For contact_pers itemchange[25/MAR/22][W21KFOR011][END]
	public String getCallOutcome( String domID,String eventType, String meetingStatus ,String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		System.out.println("Inside get Contact_pers name");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		System.out.println("in getCallOutcome ::"+eventType);
		System.out.println("in getCallOutcome::"+meetingStatus);
		try
		{
			String callOutcome="";

			System.out.println("eventType["+eventType+"]meetingStatus["+meetingStatus+"]" );
			String meetingSql="SELECT CALL_OUTCOME  FROM CALL_OUTCOME WHERE ACTIVITY_CODE=?  and UPPER(CALL_OUTCOME_DESCR)=UPPER(?)";
			pstmt = connectionObject.prepareStatement(meetingSql);
			pstmt.setString(1,eventType);
			pstmt.setString(2,meetingStatus);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				callOutcome=checkNull(rs.getString("CALL_OUTCOME"));

			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			valueXmlString.append( "<Root>\r\n" );
			valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID+"' formName='"+formName+"'>\r\n" );
			valueXmlString.append("<call_outcome><![CDATA[" ).append(checkNull(callOutcome)).append( "]]></call_outcome>\r\n" );
			valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getEventtypebean:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getEventType:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getCustNameOnMeberPresent( String domID,String custName, String memberPresent ,String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		System.out.println("Inside get Contact_pers name");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		System.out.println("in getCustNameOnMeberPresent ::"+custName);
		System.out.println("in getCustNameOnMeberPresent::"+memberPresent);
		try
		{
			JSONObject custNameDetJson = new JSONObject(custName);
			custNameDetJson.put( "FORMAT_FIELD_VAL", memberPresent );
			
			valueXmlString.append( "<Root>\r\n" );
			valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n");
			valueXmlString.append("<cust_name><![CDATA[").append(checkNull(custNameDetJson.toString())).append("]]></cust_name>\r\n");
			valueXmlString.append("</Detail"+currentFormNo+">\r\n");
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getEventtypebean:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :getEventType:==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Added by Bhagyashri T for Invoice form[W22EBAS004][START]
	public HashMap getInvItemAttributeDetails(Connection conn, String query, String bindValue, int strgCustCnt, String custList, String priceList, int sprsCnt, String prcListTemplate) throws ITMException
	{
		System.out.println("Inside getInvItemAttributeDetails");
		HashMap itemAttribMap = new HashMap();
		PreparedStatement pStmt = null;
		PreparedStatement pstmtItemAttrib = null;
		ResultSet rs = null;
		String sqlStr = "";
		String productCode = "";
		String productType = "";
		try
		{
			String itemCode = "";
			String itemSize = "";
			String itemColor = "";
			String itemVariant = "";
			String itemAttribDescr = "";
			String itemCodeStr = "";
			String prodCode = "";
			String prodType = "";
			String taxChap ="";

			pStmt = conn.prepareStatement(query);
			
			if(bindValue != null && bindValue.trim().length() > 0)
			{
				pStmt.setString(1, prcListTemplate);
				pStmt.setString(2, bindValue);
			}
			rs = pStmt.executeQuery();
			while (rs.next())
			{
				itemCode = checkNull(rs.getString("ITEM_CODE"));
				prodCode = checkNull(rs.getString("PRODUCT_CODE"));
				prodType = checkNull(rs.getString("PRODUCT_TYPE"));

				if(itemCodeStr == null || itemCodeStr.trim().length() == 0)
				{
					itemCodeStr = itemCode;
				}
				else
				{
					itemCodeStr = itemCodeStr + "','" + itemCode;
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			itemCodeStr = "'" + itemCodeStr + "'";

			System.out.println("itemCodeStr =["+itemCodeStr+"]");


			String itemSizeCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_SIZE",conn);
			String itemColorCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_COLOR",conn);
			String itemVariantCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_VARIANT",conn);
			String itemGroupCol = getSfaParmValueCommon(bindValue,"ITEM_ATTRIB_GROUP",conn);

			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			if(itemColorCol.trim().length() == 0)
			{
				itemColorCol = "PHY_ATTRIB_2";
			}
			if(itemVariantCol.trim().length() == 0)
			{
				itemVariantCol = "PHY_ATTRIB_3";
			}
			if(itemGroupCol.trim().length() == 0)
			{
				itemGroupCol = "PHY_ATTRIB_22";
			}

			String itemAttribSql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE, ITEM.DESCR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemSizeCol+"=ATTRIB_ID) AS ITEM_SIZE, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemColorCol+"=ATTRIB_ID) AS ITEM_COLOR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemVariantCol+"=ATTRIB_ID) AS ITEM_VARIANT "+
					"FROM ITEM ITEM, ITM_ATTRIB_VAL ITEM_VAL "+
					"WHERE ITEM.PRODUCT_CODE= ? AND ITEM."+itemSizeCol+" "+
					"IN(SELECT DISTINCT TRIM(V.ATTRIB_ID) FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I."+itemSizeCol+" AND "+
					"I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I."+itemGroupCol+" "+
					"AND I.ACTIVE = 'Y' AND ITEM.ITEM_CODE IN("+itemCodeStr+")"+
					") order by item.item_code ";
			pstmtItemAttrib = conn.prepareStatement(itemAttribSql);


			String itemUSage="";
			String parmItemUsage = getSfaParmValueCommon(bindValue,"SAMPLE_ITEM_USAGE",conn);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuffCommon( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			if(sprsCnt > 0)
			{
				/*sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";*/
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SPRS_ITEM SI, SALES_PERS SP,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? " +
						" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			// added by rupali on 02/05/19 for getting item from sprs_item if present [end]
			else
			{
				/*sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";*/
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? " +
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			pStmt = conn.prepareStatement(sqlStr);
			pStmt.setString(1, prcListTemplate);
			pStmt.setString(2, bindValue);
			// commentted and added by rupali on 01/02/19 for getting only active items [end]

			rs = pStmt.executeQuery();
			while(rs.next())
			{
				productCode = "";
				productType = "";
				itemSize = "";
				itemColor = "";
				itemVariant = "";
				itemAttribDescr = "";
				productCode = checkNull(rs.getString("PRODUCT_CODE"));
				productType = checkNull(rs.getString("PRODUCT_TYPE"));

				pstmtItemAttrib.setString(1, productCode);
				pstmtItemAttrib.setString(2, productCode);
				pstmtItemAttrib.setString(3, productCode);
				ResultSet rsItemAttrib = pstmtItemAttrib.executeQuery();
				while(rsItemAttrib.next())
				{
					System.out.println("inside rsItemAttrib resultset");
					HashMap itemMap = new HashMap();
					itemCode = checkNull(rsItemAttrib.getString("ITEM_CODE"));
					itemSize = checkNull(rsItemAttrib.getString("ITEM_SIZE"));
					itemColor = checkNull(rsItemAttrib.getString("ITEM_COLOR"));
					itemVariant = checkNull(rsItemAttrib.getString("ITEM_VARIANT"));
					System.out.println("itemCode ::"+itemCode+" itemSize"+itemSize+" itemColor"+itemColor+" itemVariant"+itemVariant+"TAX_CHAP:"+taxChap);

					if((itemColor == null || itemColor.trim().length() == 0) && (itemVariant.length() > 0))
					{
						itemAttribDescr = itemVariant;
					}
					else if((itemVariant == null || itemVariant.trim().length() == 0) && (itemColor.length() > 0))
					{
						itemAttribDescr = itemColor;
					}
					else if(itemColor.length() == 0 && itemVariant.length() == 0)
					{
						//itemAttribDescr = "Attribute not defined";
						itemAttribDescr = "";
					}
					if(itemColor.length() > 0 && itemVariant.length() > 0)
					{
						itemAttribDescr = itemVariant+"("+itemColor+")";
					}
					itemMap.put("ITEM_SIZE", itemSize);
					itemMap.put("ITEM_ATTRIBUTE", itemAttribDescr);
					itemAttribMap.put(itemCode, itemMap);

					System.out.println("itemAttribMap IS AS IN INVOICE ::"+itemAttribMap);
				}
				pstmtItemAttrib.clearParameters();
				if(rsItemAttrib != null)
				{
					rsItemAttrib.close();
					rsItemAttrib = null;
				}

			}
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			throw new ITMException(se);

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmtItemAttrib != null)
				{
					pstmtItemAttrib.close();
					pstmtItemAttrib = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception ee)
			{

			}
		}
		System.out.println("getItemAttributeDetails >> itemAttribMap ::"+itemAttribMap);
		return itemAttribMap;
	}
	//Added by Bhagyashri T for Invoice subform[W22EBAS004][END]
	public String getPriceListSO(String userId,Connection conn)throws Exception
	{
		String priceList = "";
		String prclstSql = "";
		PreparedStatement priceListPstmt = null;
		ResultSet priceListRs = null;
		try
		{
			prclstSql = "SELECT ST.PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON ST.STATE_CODE=SP.STATE_CODE WHERE SP.SALES_PERS=?";
			priceListPstmt =conn.prepareStatement(prclstSql);
			priceListPstmt.setString(1,userId);
			priceListRs = priceListPstmt.executeQuery();
			if(priceListRs.next())
			{
				priceList = priceListRs.getString("PRICE_LIST").trim();
			}
			System.out.println("priceList=== ["+priceList + "]");
			if (priceListRs!= null)
			{
				priceListRs.close();
				priceListRs = null;
			}
			if(priceListPstmt!=null)
			{
				priceListPstmt.close();
				priceListPstmt = null;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (priceListRs!= null)
				{
					priceListRs.close();
					priceListRs = null;
				}
				if(priceListPstmt!=null)
				{
					priceListPstmt.close();
					priceListPstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return priceList;
	}
	//Added by Bhagyashri T for display amount in word[02/11/2022][start]
			private static final String EMPTY = "";

			private static final String[] X =
			{
				EMPTY, "One ", "Two ", "Three ", "Four ", "Five ", "Six ",
				"Seven ", "Eight ", "Nine ", "Ten ", "Eleven ","Twelve ",
				"Thirteen ", "Fourteen ", "Fifteen ", "Sixteen ",
				"Seventeen ", "Eighteen ", "Nineteen "
			};

			private static final String[] Y =
			{
				EMPTY, EMPTY, "Twenty ", "Thirty ", "Forty ", "Fifty ",
				"Sixty ", "Seventy ", "Eighty ", "Ninety "
			};

			// Function to convert a single-digit or two-digit number Longo words
			private static String convertToDigit(long n, String suffix)
			{
				// if `n` is zero
				if (n == 0) {
					return EMPTY;
				}

				// split `n` if it is more than 19
				if (n > 19) {
					return Y[(int) (n / 10)] + X[(int) (n % 10)] + suffix;
				}
				else {
					return X[(int) n] + suffix;
				}
			}

			// Function to convert a given number (max 9-digits) Longo words
			public static String convert(long n)
			{
				// for storing the word representation of the given number
				StringBuilder res = new StringBuilder();

				// add digits at ten million and hundred million place
				res.append(convertToDigit((n / 1000000000) % 100, "Billion, "));

				// add digits at ten million and hundred million place
				res.append(convertToDigit((n / 10000000) % 100, "Crore, "));

				// add digits at hundred thousand and one million place
				res.append(convertToDigit(((n / 100000) % 100), "Lakh, "));

				// add digits at thousand and tens thousand place
				res.append(convertToDigit(((n / 1000) % 100), "Thousand, "));

				// add digit at hundred place
				res.append(convertToDigit(((n / 100) % 10), "Hundred "));

				if ((n > 100) && (n % 100 != 0)) {
					res.append("and ");
				}

				// add digits at ones and tens place
				res.append(convertToDigit((n % 100), ""));

				return res.toString().trim()
						.replace(", and", " and")
						.replaceAll("^(.*),$", "$1");		// remove trailing comma
			}
	//Added by Bhagyashri T for display amount in word[02/11/2022][end]
}
