package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.utility.ITMException;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class StrgGetDocumentsListEJB extends ActionHandlerEJB implements StrgGetDocumentsListRemote, StrgGetDocumentsListLocal
{
	@Override
	public String action(String xmlStr, String xtraParams)
	{
		System.out.println( "Inside StrgGetDocumentsListEJB method name :: getDocumentsList - ["+ xmlStr +"]" );
		StringBuilder documentIds = new StringBuilder();
		Connection conn = null;
		try
		{
			conn = getConnection();
			String scCode = "";
			String brandCode = "";

			if( xmlStr != null && xmlStr.length() > 0 )
			{
				E12GenericUtility genericUtility = new E12GenericUtility();
				Document chgDataDom = genericUtility.parseString( xmlStr );
				if( chgDataDom.getElementsByTagName( "Header0" ).item( 0 ) != null )
				{
					Node rootNode = chgDataDom.getElementsByTagName( "Header0" ).item( 0 );
					NodeList chgDataNodeList = rootNode.getChildNodes();

					int noOfChgDataNodes = chgDataNodeList.getLength();

					for ( int i = 0; i < noOfChgDataNodes; i++ )
					{
						Node chgDataDetailNode = chgDataNodeList.item(i);
						String tagName = chgDataDetailNode.getNodeName();
						String formNo = "";
						if ( tagName.startsWith( "Detail" ) )
						{
							formNo = ( tagName.length() > "Detail".length()) ? ( tagName.substring( "Detail".length() ) ) : "1";
							NodeList chgColNodeList = chgDataDetailNode.getChildNodes();
							int noOfChgColNodes = chgColNodeList.getLength();
							for ( int j = 0; j < noOfChgColNodes; j++ )
							{
								Node chgColNode = chgColNodeList.item(j);
								String chtagName = chgColNode.getNodeName();
								if( chtagName != null && chtagName.length() > 0)
								{
									if( chtagName.equalsIgnoreCase("SC_CODE") )
									{
										scCode = chgColNode.getFirstChild().getNodeValue();
									}
									else if( chtagName.equalsIgnoreCase("BRAND_CODE") )
									{
										brandCode = chgColNode.getFirstChild().getNodeValue();
									}
								}
							}
						}
					}
				}
			}

			String refSer = getRefSer( conn, "strg_customer" );
			String refId = getTranId( scCode, brandCode, conn );
			documentIds.append( getDocumentList( refSer, refId, conn ) );

			String productRefSer = getRefSer( conn, "product" );
			refId = "'"+ brandCode +"'";
			documentIds.append( getDocumentList( productRefSer, refId, conn ) );

			refId = "'"+ scCode +"'";
			documentIds.append( getDocumentList( refSer, refId, conn ) );

			if(( documentIds.charAt( documentIds.length()-1 )) == ',' )
			{
				documentIds.deleteCharAt( documentIds.length() - 1 );
			}

			if( conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "StrgGetDocumentsListEJB retStr - ["+ documentIds +"]" );
		return documentIds.toString();
	}

	private String getTranId( String scCode, String brandCode, Connection conn  )
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String retStr = "";
		try
		{
			String query = "SELECT SC_CODE, LINE_NO FROM STRG_PRODUCT WHERE SC_CODE = ? AND BRAND_CODE = ?";
			pstmt = conn.prepareStatement( query );
			pstmt.setString(1, scCode);
			pstmt.setString(2, brandCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				retStr += "'"+ rs.getString( "SC_CODE" ) + ":" + rs.getString( "LINE_NO" ) + "',";
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( retStr.charAt( retStr.length() - 1 ) == ',' )
			{
				retStr = retStr.substring( 0, ( retStr.length() - 1 ) );
			}
			System.out.println("retStr - ["+retStr+"]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return retStr;
	}

	private String getDocumentList( String refSer, String refId, Connection conn )
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String retStr = "";
		try
		{
			String brandQuery = "SELECT DOC_CONTENTS.DOC_ID, DOC_CONTENTS.DOC_NAME FROM DOC_CONTENTS, DOC_TRANSACTION_LINK, USERS WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND USERS.CODE = DOC_CONTENTS.ADD_USER AND TRIM(REF_SER) = TRIM('" + refSer + "') AND TRIM(REF_ID) IN ( TRIM(" + refId + ") )  ORDER BY DOC_CONTENTS.DOC_ID";
			pstmt = conn.prepareStatement( brandQuery );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				retStr += rs.getString( "DOC_ID" ) + "::" + rs.getString( "DOC_NAME" ) + ",";
			}

			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			System.out.println( "refId - ["+ refId +"], retStr - ["+ retStr +"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return retStr;
	}

	public String getRefSer(Connection mConnection, String objName)throws RemoteException, ITMException
	{
		Statement mStmt = null;
		ResultSet rs = null;
		String refSer = null;
		try
		{
			String sqlQuery = null;
			objName = ( objName != null )?objName.trim():objName;
			sqlQuery = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_"+objName+"'";
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				refSer = rs.getString(1);
			}
			if(rs != null)
			{
				rs.close();
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :StrgGetDocumentsListEJB :getRefSer :\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStmt != null)
				{
					mStmt.close();
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :StrgGetDocumentsListEJB :getRefSer :==>"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return refSer;
	}
}