/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.bean;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLProcess {
    public static void main(String[] args) {
        BaseLogger.log("2", null, null, "Hello World!");
        try {
            String xmlString = "<SCHEDULE id=\"base5\"><SCHEDULE_NAME>base5</SCHEDULE_NAME><SCHEDULER_TYPE>ETL</SCHEDULER_TYPE><OBJECT_NAME>CUSTOMER</OBJECT_NAME><EXCEPTION_TYPE>0</EXCEPTION_TYPE></SCHEDULE>";
            XMLProcess xp = new XMLProcess();
            String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "ScheduleProperties.xml";
            xp.deleteNode("base5", filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savedom(String xmlString, String filePath) throws Exception {
        File f = new File(filePath);
        Document parentdom = this.parseFile(f);
        Document childdom = this.parseString(xmlString);
        Document addDom = this.appendToDom(parentdom, childdom);
        FileWriter fw = new FileWriter(filePath);
        fw.write(this.serailizeDom(addDom));
        fw.close();
        BaseLogger.log("2", null, null, "New dom saved");
    }

    private Node searchNode(Document dom, String schName) throws Exception {
        Node tabNode = null;
        try {
            NodeList tabNodeList = dom.getElementsByTagName("SCHEDULE");
            int ctr = 0;
            while (ctr < tabNodeList.getLength()) {
                Node currTabNode = tabNodeList.item(ctr);
                if (currTabNode.getAttributes().getNamedItem("id").getNodeValue().equals(schName)) {
                    tabNode = currTabNode;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :XMLProcess :searchNode(dom, tabID) :==>\n" + e.getMessage());
            throw e;
        }
        return tabNode;
    }

    public Document appendToDom(Document tempParentDom, Document tempChildDom) throws Exception {
        Document retDom = null;
        try {
            if (tempParentDom != null) {
                NodeList oriHeaderList = tempParentDom.getElementsByTagName("SCHEDULES");
                Node node = oriHeaderList.item(oriHeaderList.getLength());
                NodeList newDetailList = tempChildDom.getElementsByTagName("SCHEDULE");
                int len = newDetailList.getLength();
                if (len > 0) {
                    int j = 0;
                    while (j < len) {
                        Node nDetail = newDetailList.item(j);
                        Node importedNode = tempParentDom.importNode(nDetail, true);
                        oriHeaderList.item(0).appendChild(importedNode);
                        ++j;
                    }
                }
                retDom = tempParentDom;
            } else {
                retDom = tempChildDom;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :XMLProcess :appendToDomForedit :\n" + e.getMessage());
            throw e;
        }
        return retDom;
    }

    public void deleteNode(String tabID, String fileName) throws Exception {
        try {
            File f1 = new File(fileName);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document fileDom = documentBuilder.parse(f1);
            Node tabNode = this.searchNode(fileDom, tabID);
            fileDom.getElementsByTagName("SCHEDULES").item(0).removeChild(tabNode);
            DOMSource domSource = new DOMSource(fileDom);
            StreamResult streamResult = new StreamResult(f1);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
            BaseLogger.log("3", null, null, "dom Removed");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :XMLProcess :deleteNode :\n" + e.getMessage());
            throw e;
        }
    }

    public Document parseString(String xmlString) throws Exception {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(baos);
        }
        catch (Exception e) {
            dom = null;
            BaseLogger.log("0", null, null, "Exception :XMLProcess :parseString :==>\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    public Document parseFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        try {
            File file = null;
            file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            dom = parser.parse(file);
        }
        catch (Exception e) {
            dom = null;
            BaseLogger.log("0", null, null, "Exception :XMLProcess :parseFile :\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    public String serailizeDom(Document dom) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Transformer serializer = null;
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(dom), new StreamResult(out));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :XMLProcess :serailizeDom :\n" + e.getMessage());
            throw e;
        }
        return out.toString();
    }

    public String serializeNode(Node dom) throws Exception {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            retString = out.toString();
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            retString = null;
            BaseLogger.log("0", null, null, "Exception :XMLProcess :serializeNode :==>\n" + e.getMessage());
            throw e;
        }
        return retString;
    }
}

